;; Copyright (C) 2002-2004, Yuji Minejima <ggb01164@nifty.ne.jp>
;; ALL RIGHTS RESERVED.
;;
;; $ Id: must-sequence.lisp,v 1.31 2004/08/09 02:49:54 yuji Exp $
;;
;; Redistribution and use in source and binary forms, with or without
;; modification, are permitted provided that the following conditions
;; are met:
;;
;;  * Redistributions of source code must retain the above copyright
;;    notice, this list of conditions and the following disclaimer.
;;  * Redistributions in binary form must reproduce the above copyright
;;    notice, this list of conditions and the following disclaimer in
;;    the documentation and/or other materials provided with the
;;    distribution.
;;
;; THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
;; "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
;; LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
;; A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
;; OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
;; SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
;; LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
;; DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
;; THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
;; (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
;; OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

(eql (length "abc") 3)
(let ((str (make-array '(3) :element-type 'character
                            :initial-contents "abc"
                            :fill-pointer t)))
  (and (eql (length str) 3)
       (eql (setf (fill-pointer str) 2) 2)
       (eql (length str) 2)))
(zerop (length #*))
(zerop (length ""))
(zerop (length #()))
(zerop (length ()))
(eql (length '(0)) 1)
(eql (length '(0 1)) 2)
(eql (length '(0 1 2)) 3)
(eql (length '(0 1 2 3)) 4)
(eql (length '(0 1 2 3 4)) 5)
(eql (length '(0 1 2 3 4 5)) 6)
(eql (length '(0 1 2 3 4 5 6)) 7)
(eql (length #(0)) 1)
(eql (length #(0 1)) 2)
(eql (length #(0 1 2)) 3)
(eql (length #(0 1 2 3)) 4)
(eql (length #(0 1 2 3 4)) 5)
(eql (length #(0 1 2 3 4 5)) 6)
(eql (length #(0 1 2 3 4 5 6)) 7)
(eql (length (make-array 100)) 100)
(eql (length (make-sequence 'list 20)) 20)
(eql (length (make-sequence 'string 10)) 10)
(eql (length (make-sequence 'bit-vector 3)) 3)
(eql (length (make-sequence 'bit-vector 64)) 64)
(eql (length (make-sequence 'simple-vector 64)) 64)



(string= (copy-seq "love") "love")
(equalp (copy-seq '#(a b c d)) '#(a b c d))
(equalp (copy-seq '#*01010101) '#*01010101)
(equal (copy-seq '(love)) '(love))
(equal (copy-seq '(love hate war peace)) '(love hate war peace))
(null (copy-seq nil))
(string= (copy-seq "") "")
(let* ((seq0 "love&peace")
       (seq (copy-seq seq0)))
  (and (not (eq seq0 seq))
       (string= seq0 seq)))
(let* ((seq0 (list 'love 'and 'peace))
       (seq (copy-seq seq0)))
  (and (not (eq seq0 seq))
       (equal seq0 seq)))
(let* ((c0 (list 'love))
       (c1 (list 'peace))
       (seq (copy-seq (list c0 c1))))
  (and (equal seq '((love) (peace)))
       (eq (car seq) c0)
       (eq (cadr seq) c1)))
(let* ((seq0 '#(t nil t nil))
       (seq (copy-seq seq0)))
  (and (not (eq seq0 seq))
       (equalp seq seq0)))
(vectorp (copy-seq (vector)))
(simple-bit-vector-p (copy-seq #*))
(simple-vector-p (copy-seq (vector)))
(simple-vector-p (copy-seq (make-array 10
                                       :fill-pointer 3
                                       :initial-element nil)))
(simple-vector-p (copy-seq (vector 0 1)))
(simple-string-p (copy-seq "xyz"))
(simple-string-p (copy-seq (make-array 3
                                       :displaced-to "0123456789"
                                       :displaced-index-offset 3
                                       :element-type 'base-char)))
(simple-string-p (copy-seq (make-array 20
                                       :fill-pointer t
                                       :element-type 'base-char
                                       :initial-element #\Space)))
(simple-bit-vector-p (copy-seq #*0101))
(simple-bit-vector-p (copy-seq (make-array 30
                                           :fill-pointer 3
                                           :element-type 'bit
                                           :initial-element 0)))
(let* ((vec0 (make-array 10 :fill-pointer 3 :initial-contents "0123456789"))
       (vec (copy-seq vec0)))
  (and (simple-vector-p vec)
       (= (length vec) 3)
       (equalp vec #(#\0 #\1 #\2))))


(char= (elt "0123456789" 6) #\6)
(eq (elt #(a b c d e f g) 0) 'a)
(eq (elt '(a b c d e f g) 4) 'e)
(zerop (elt #*0101010 0))

(dotimes (i 10 t)
  (unless (char= (elt "0123456789" i) (digit-char i))
    (return nil)))

(let ((str (copy-seq "0123456789")))
  (and (char= (elt str 6) #\6)
       (setf (elt str 0) #\#)
       (string= str "#123456789")))

(let ((list (list 0 1 2 3)))
  (and (= (elt list 2) 2)
       (setf (elt list 1) 9)
       (= (elt list 1) 9)
       (equal list '(0 9 2 3))))

(let ((bv #*0101010101))
  (dotimes (i 10 t)
    (unless (= (elt bv i) (if (evenp i) 0 1))
      (return nil))))

(let ((vec (vector 'a 'b 'c)))
  (and (eq (elt vec 0) 'a)
       (eq (elt vec 1) 'b)
       (eq (elt vec 2) 'c)))


(let ((list (list 0 1 2 3)))
  (and (eq (fill list 'nil) list)
       (every 'null list)))

(let ((vector (vector 'x 'y 'z)))
  (and (eq (fill vector 'a) vector)
       (every #'(lambda (arg) (eq arg 'a)) vector)))

(let ((list (list 0 1 2 3)))
  (and (eq (fill list '9 :start 2) list)
       (equal list '(0 1 9 9))))

(let ((list (list 0 1 2 3)))
  (and (eq (fill list '9 :start 1 :end 3) list)
       (equal list '(0 9 9 3))))

(let ((list (list 0 1 2 3)))
  (and (eq (fill list '9 :start 1 :end nil) list)
       (equal list '(0 9 9 9))))

(let ((list (list 0 1 2 3)))
  (and (eq (fill list '9 :end 1) list)
       (equal list '(9 1 2 3))))

(let ((vector (vector 0 1 2 3)))
  (and (eq (fill vector 't :start 3) vector)
       (equalp vector '#(0 1 2 t))))

(let ((vector (vector 0 1 2 3)))
  (and (eq (fill vector 't :start 2 :end 4) vector)
       (equalp vector '#(0 1 t t))))

(let ((vector (vector 0 1 2 3)))
  (and (eq (fill vector 't :start 2 :end nil) vector)
       (equalp vector '#(0 1 t t))))

(let ((vector (vector 0 1 2 3)))
  (and (eq (fill vector 't :end 3) vector)
       (equalp vector '#(t t t 3))))



(null (make-sequence 'list 0))
(string= (make-sequence 'string 26 :initial-element #\.)
         "..........................")
(equalp (make-sequence '(vector double-float) 2
                       :initial-element 1d0)
        #(1.0d0 1.0d0))


(equal (make-sequence 'list 3 :initial-element 'a)
       '(a a a))

(equal (make-sequence 'cons 3 :initial-element 'a)
       '(a a a))

(null (make-sequence 'null 0 :initial-element 'a))

(equalp (make-sequence 'vector 3 :initial-element 'z)
        '#(z z z))

(equalp (make-sequence '(vector * *) 3 :initial-element 'z)
        '#(z z z))

(equalp (make-sequence '(vector t *) 3 :initial-element 'z)
        '#(z z z))

(string= (make-sequence '(string 3) 3 :initial-element '#\a)
         "aaa")

(string= (make-sequence 'string  4 :initial-element '#\z)
         "zzzz")

(string= (make-sequence '(vector character 3) 3 :initial-element '#\a)
         "aaa")

(equalp (make-sequence '(array t 1) 3 :initial-element 'z)
        '#(z z z))

(equalp (make-sequence '(array t (3)) 3 :initial-element 'z)
        '#(z z z))

(vectorp (make-sequence 'vector 10))


(string= (subseq "012345" 2) "2345")
(string= (subseq "012345" 3 5) "34")
(let ((str (copy-seq "012345")))
  (and (setf (subseq str 4) "abc")
       (string= str "0123ab")))
(let ((str (copy-seq "012345")))
  (setf (subseq str 0 2) "A")
  (string= str "A12345"))

(equal (subseq '(0 1 2 3) 0) '(0 1 2 3))
(equal (subseq '(0 1 2 3) 1) '(1 2 3))
(equal (subseq '(0 1 2 3) 2) '(2 3))
(equal (subseq '(0 1 2 3) 3) '(3))
(equal (subseq '(0 1 2 3) 4) '())
(equalp (subseq #(a b c d) 0) #(a b c d))
(equalp (subseq #(a b c d) 1) #(b c d))
(equalp (subseq #(a b c d) 2) #(c d))
(equalp (subseq #(a b c d) 3) #(d))
(equalp (subseq #(a b c d) 4) #())
(string= (subseq "0123" 0) "0123")
(string= (subseq "0123" 1) "123")
(string= (subseq "0123" 2) "23")
(string= (subseq "0123" 3) "3")
(string= (subseq "0123" 4) "")
(equalp (subseq #*1010 0) #*1010)
(equalp (subseq #*1010 1) #*010)
(equalp (subseq #*1010 2) #*10)
(equalp (subseq #*1010 3) #*0)
(equalp (subseq #*1010 4) #*)

(equal (subseq '(0 1 2 3) 0 4) '(0 1 2 3))
(equal (subseq '(0 1 2 3) 0 nil) '(0 1 2 3))
(let* ((list0 '(0 1 2 3))
       (list (subseq list0 0 4)))
  (and (not (eq list0 list))
       (equal list0 list)))
(let* ((list0 '(0 1 2 3))
       (list (subseq list0 0 nil)))
  (and (not (eq list0 list))
       (equal list0 list)))
(equal (subseq '(0 1 2 3) 1 3) '(1 2))
(equal (subseq '(0 1 2 3) 2 2) '())
(equal (subseq '(0 1 2 3) 0 0) '())
(equal (subseq '(0 1 2 3) 1 1) '())
(equal (subseq '(0 1 2 3) 2 2) '())
(equal (subseq '(0 1 2 3) 3 3) '())
(equal (subseq '(0 1 2 3) 4 4) '())

(let ((list (list 0 1 2 3 4 5 6 7)))
  (setf (subseq list 0) '(a b c d))
  (equal list '(a b c d 4 5 6 7)))

(let ((list (list 0 1 2 3)))
  (setf (subseq list 0) '(a b c d))
  (equal list '(a b c d)))

(let ((list (list 0 1 2 3)))
  (setf (subseq list 2) '(a b c d))
  (equal list '(0 1 a b)))

(let ((list (list 0 1 2 3)))
  (setf (subseq list 2 nil) '(a b c d))
  (equal list '(0 1 a b)))

(let ((list (list 0 1 2 3)))
  (setf (subseq list 1 3) '(a b c d))
  (equal list '(0 a b 3)))

(let ((list (list 0 1 2 3)))
  (setf (subseq list 0) '())
  (equal list '(0 1 2 3)))

(let ((list '()))
  (setf (subseq list 0) '(a b c d e))
  (null list))

(let ((list '(0 1 2 3)))
  (setf (subseq list 0 0) '(a b c d e))
  (equal list '(0 1 2 3)))

(let ((list '(0 1 2 3)))
  (setf (subseq list 1 1) '(a b c d e))
  (equal list '(0 1 2 3)))

(let ((list '(0 1 2 3)))
  (setf (subseq list 2 2) '(a b c d e))
  (equal list '(0 1 2 3)))

(let ((list '(0 1 2 3)))
  (setf (subseq list 3 3) '(a b c d e))
  (equal list '(0 1 2 3)))

(let ((list '(0 1 2 3)))
  (setf (subseq list 4 4) '(a b c d e))
  (equal list '(0 1 2 3)))



(let ((list (list 0 1 2 3 4 5 6 7)))
  (setf (subseq list 0) #(a b c d))
  (equal list '(a b c d 4 5 6 7)))

(let ((list (list 0 1 2 3)))
  (setf (subseq list 0) #(a b c d))
  (equal list '(a b c d)))

(let ((list (list 0 1 2 3)))
  (setf (subseq list 2) #(a b c d))
  (equal list '(0 1 a b)))

(let ((list (list 0 1 2 3)))
  (setf (subseq list 2 nil) #(a b c d))
  (equal list '(0 1 a b)))

(let ((list (list 0 1 2 3)))
  (setf (subseq list 1 3) #(a b c d))
  (equal list '(0 a b 3)))

(let ((list (list 0 1 2 3)))
  (setf (subseq list 0) #())
  (equal list '(0 1 2 3)))

(let ((list (list 0 1 2 3 4 5 6 7)))
  (setf (subseq list 0) "abcd")
  (equal list '(#\a #\b #\c #\d 4 5 6 7)))

(let ((list (list 0 1 2 3)))
  (setf (subseq list 0) "abcd")
  (equal list '(#\a #\b #\c #\d)))

(let ((list (list 0 1 2 3)))
  (setf (subseq list 2) "abcd")
  (equal list '(0 1 #\a #\b)))

(let ((list (list 0 1 2 3)))
  (setf (subseq list 2 nil) "abcd")
  (equal list '(0 1 #\a #\b)))

(let ((list (list 0 1 2 3)))
  (setf (subseq list 1 3) "abcd")
  (equal list '(0 #\a #\b 3)))

(let ((list (list 0 1 2 3)))
  (setf (subseq list 0) "")
  (equal list '(0 1 2 3)))


(equalp (subseq #(0 1 2 3) 0 4) #(0 1 2 3))
(equalp (subseq #(0 1 2 3) 0 nil) #(0 1 2 3))
(let* ((vec0 #(0 1 2 3))
       (vec (subseq vec0 0 4)))
  (and (not (eq vec0 vec))
       (equalp vec0 vec)))
(let* ((vec0 #(0 1 2 3))
       (vec (subseq vec0 0 nil)))
  (and (not (eq vec0 vec))
       (equalp vec0 vec)))
(equalp (subseq #(0 1 2 3) 1 3) #(1 2))
(equalp (subseq #(0 1 2 3) 2 2) #())
(equalp (subseq #(0 1 2 3) 0 0) #())
(equalp (subseq #(0 1 2 3) 1 1) #())
(equalp (subseq #(0 1 2 3) 2 2) #())
(equalp (subseq #(0 1 2 3) 3 3) #())
(equalp (subseq #(0 1 2 3) 4 4) #())

(let ((vec (vector 0 1 2 3 4 5 6 7)))
  (setf (subseq vec 0) #(a b c d))
  (equalp vec #(a b c d 4 5 6 7)))

(let ((vec (vector 0 1 2 3)))
  (setf (subseq vec 0) #(a b c d))
  (equalp vec #(a b c d)))

(let ((vec (vector 0 1 2 3)))
  (setf (subseq vec 2) #(a b c d))
  (equalp vec #(0 1 a b)))

(let ((vec (vector 0 1 2 3)))
  (setf (subseq vec 1 3) #(a b c d))
  (equalp vec #(0 a b 3)))

(let ((vec (vector 0 1 2 3)))
  (setf (subseq vec 0) #())
  (equalp vec #(0 1 2 3)))

(let ((vec (vector)))
  (setf (subseq vec 0) #(a b c d e))
  (equalp vec #()))

(let ((vec (vector 0 1 2 3)))
  (setf (subseq vec 0 0) #(a b c d e))
  (equalp vec #(0 1 2 3)))

(let ((vec (vector 0 1 2 3)))
  (setf (subseq vec 1 1) #(a b c d e))
  (equalp vec #(0 1 2 3)))

(let ((vec (vector 0 1 2 3)))
  (setf (subseq vec 2 2) #(a b c d e))
  (equalp vec #(0 1 2 3)))

(let ((vec (vector 0 1 2 3)))
  (setf (subseq vec 3 3) #(a b c d e))
  (equalp vec #(0 1 2 3)))

(let ((vec (vector 0 1 2 3)))
  (setf (subseq vec 4 4) #(a b c d e))
  (equalp vec #(0 1 2 3)))


(let ((vec (vector 0 1 2 3 4 5 6 7)))
  (setf (subseq vec 0) #(a b c d))
  (equalp vec #(a b c d 4 5 6 7)))

(let ((vec (vector 0 1 2 3)))
  (setf (subseq vec 0) #(a b c d))
  (equalp vec #(a b c d)))

(let ((vec (vector 0 1 2 3)))
  (setf (subseq vec 2) #(a b c d))
  (equalp vec #(0 1 a b)))

(let ((vec (vector 0 1 2 3)))
  (setf (subseq vec 2 nil) #(a b c d))
  (equalp vec #(0 1 a b)))

(let ((vec (vector 0 1 2 3)))
  (setf (subseq vec 1 3) #(a b c d))
  (equalp vec #(0 a b 3)))

(let ((vec (vector 0 1 2 3)))
  (setf (subseq vec 0) #())
  (equalp vec #(0 1 2 3)))

(HANDLER-CASE (PROGN (MAP 'SYMBOL #'+ '(0 1) '(1 0)))
  (TYPE-ERROR NIL T)
  (ERROR NIL NIL)
  (:NO-ERROR (&REST REST) (DECLARE (IGNORE REST)) NIL))
(HANDLER-CASE (PROGN (MAP 'HASH-TABLE #'+ '(0 1) '(1 0)))
  (TYPE-ERROR NIL T)
  (ERROR NIL NIL)
  (:NO-ERROR (&REST REST) (DECLARE (IGNORE REST)) NIL))


(string= (map 'string #'(lambda (x y)
                          (char "01234567890ABCDEF" (mod (+ x y) 16)))
              '(1 2 3 4)
              '(10 9 8 7))
         "AAAA")

(let ((seq (list "lower" "UPPER" "" "123")))
  (and (null (map nil #'nstring-upcase seq))
       (equal seq '("LOWER" "UPPER" "" "123"))))

(equal (map 'list #'- '(1 2 3 4)) '(-1 -2 -3 -4))

(string= (map 'string
              #'(lambda (x) (if (oddp x) #\1 #\0))
              '(1 2 3 4))
         "1010")



(equal (map 'list '+ '(0 1) '(1 0)) '(1 1))
(equal (map 'list '- '(0 1) '(1 0)) '(-1 1))

(every 'null (list (map 'list #'+ '())
                   (map 'list #'+ '() '())
                   (map 'list #'+ '() '() '())
                   (map 'list #'+ '() '() '() '())
                   (map 'list #'+ '() '() '() '() '())))
(every 'null (list (map 'list #'+ '())
                   (map 'list #'+ #() '())
                   (map 'list #'+ '() #() '())
                   (map 'list #'+ #() '() #() '())
                   (map 'list #'+ '() #() '() #() '())))

(equal (map 'list #'+ '(0 1 2)) '(0 1 2))
(equal (map 'list #'+ '(0 1 2) '(1 2 3)) '(1 3 5))
(equal (map 'list #'+ '(0 1 2) '(1 2 3) '(2 3 4)) '(3 6 9))
(equal (map 'list #'+ '(0 1 2) '(1 2 3) '(2 3 4) '(3 4 5)) '(6 10 14))

(equal (map 'list #'+ '(1 2) '(1 2 3)) '(2 4))
(equal (map 'list #'+ '(0 1 2) '(2 3) '(2 3 4)) '(4 7))
(equal (map 'list #'+ '(0 1 2) '(1 2 3) '(2) '(3 4 5)) '(6))
(equal (map 'list #'+ '(0 1 2) '(1 2 3) '(2 3 4) '(3 4 5) '()) '())

(equal (map 'cons #'+ '(0 1 2) '(2 1 0)) '(2 2 2))
(equal (map '(cons number cons) #'+ '(0 1 2) '(2 1 0)) '(2 2 2))
(equal (map '(cons number (cons number *)) #'+ '(0 1 2) '(2 1 0)) '(2 2 2))
(null (map 'null #'+ '()))


(equalp (map 'vector #'+ #()) #())
(equalp (map 'vector #'+ #() #()) #())
(equalp (map 'vector #'+ #() #() #()) #())
(equalp (map 'vector #'+ #() #() #() #()) #())
(equalp (map 'vector #'+ #() #() #() #() #()) #())
(equalp (map 'vector #'+ '() #()) #())
(equalp (map 'vector #'+ '() #() "") #())

(equalp (map 'vector #'+ '(0 1 2)) #(0 1 2))
(equalp (map 'vector #'+ '(0 1 2) #(1 2 3)) #(1 3 5))
(equalp (map 'vector #'+ #(0 1 2) '(1 2 3) #(2 3 4)) #(3 6 9))
(equalp (map 'vector #'+ '(0 1 2) #(1 2 3) '(2 3 4) #(3 4 5)) #(6 10 14))

(equalp (map 'vector #'+ '(1 2) '(1 2 3)) #(2 4))
(equalp (map 'vector #'+ '(0 1 2) '(2 3) '(2 3 4)) #(4 7))
(equalp (map 'vector #'+ '(0 1 2) '(1 2 3) '(2) '(3 4 5)) #(6))
(equalp (map 'vector #'+ '(0 1 2) '(1 2 3) '(2 3 4) '(3 4 5) '()) #())

(equalp (map 'vector #'+ #(1 2) #(1 2 3)) #(2 4))
(equalp (map 'vector #'+ #(0 1 2) #(2 3) #(2 3 4)) #(4 7))
(equalp (map 'vector #'+ #(0 1 2) '(1 2 3) #(2) '(3 4 5)) #(6))
(equalp (map 'vector #'+ '(0 1 2) #(1 2 3) '(2 3 4) '(3 4 5) '()) #())

(string= (map 'string #'(lambda (&rest rest) (char-upcase (car rest))) "") "")
(string= (map 'string #'(lambda (&rest rest) (char-upcase (car rest))) "" "")
         "")
(string= (map 'string
              #'(lambda (&rest rest) (char-upcase (car rest)))
              "" "" "")
         "")
(string= (map 'string
              #'(lambda (&rest rest) (char-upcase (car rest)))
              "" "" "" "")
         "")
(string= (map 'string
              #'(lambda (&rest rest) (char-upcase (car rest)))
              "" "" "" "" "")
         "")

(string= (map 'string #'(lambda (&rest rest) (char-upcase (car rest))) "") "")
(string= (map 'string #'(lambda (&rest rest) (char-upcase (car rest))) "" '())
         "")
(string= (map 'string #'(lambda (&rest rest) (char-upcase (car rest)))
              "" #() '()) "")
(string= (map 'string #'(lambda (&rest rest) (char-upcase (car rest)))
              '() '() "" "") "")
(string= (map 'string #'(lambda (&rest rest) (char-upcase (car rest)))
              #() #() #() #() #()) "")


(string= (map 'string
              #'(lambda (a b) (if (char< a b) b a))
              "axbycz"
              "xaybzc")
         "xxyyzz")

(string= (map 'string
              #'(lambda (a b) (if (char< a b) b a))
              "axbycz"
              "xayb")
         "xxyy")

(string= (map 'string
              #'(lambda (&rest rest) (if (zerop (apply #'logand rest)) #\0 #\1))
              '(0 1 0 1)
              #*1010101)
         "0000")

(string= (map 'string
              #'(lambda (&rest rest) (if (zerop (apply #'logand rest)) #\0 #\1))
              #*1111
              #*1010101
              #*001)
         "001")

(string= (map 'string
              #'(lambda (&rest rest) (if (zerop (apply #'logand rest)) #\0 #\1))
              #*1111
              #*1010101
              #*0)
         "0")

(string= (map 'string
              #'(lambda (&rest rest) (if (zerop (apply #'logand rest)) #\0 #\1))
              #*1111
              #*1000
              #*1011)
         "1000")


(let ((list ()))
  (and (null (map nil
                  #'(lambda (&rest rest)
                      (setq list (cons (apply #'+ rest) list)))
                  '(0 1 2 3)
                  '(1 2 3 4)))
       (equal list '(7 5 3 1))))

(let ((list ()))
  (and (null (map nil
                  #'(lambda (&rest rest)
                      (setq list (cons (apply #'+ rest) list)))
                  '(0 1 2 3)
                  '(1 2 3 4)
                  '(2 3 4 5)))
       (equal list (reverse '(3 6 9 12)))))

(let ((list ()))
  (and (null (map nil
                  #'(lambda (&rest rest)
                      (setq list (cons (apply #'+ rest) list)))
                  '(0 1 2 3)
                  '(1)
                  '(2 3 4 5)))
       (equal list '(3))))



(equalp (map '(vector * 2) #'+ #*01 #*10) #(1 1))
(equalp (map '(simple-vector 2) #'+ #*01 #*10) #(1 1))
(equalp (map '(array * 1) #'+ #*01 #*10) #(1 1))
(equalp (map '(simple-array * 1) #'+ #*01 #*10) #(1 1))
(equalp (map '(array * (2)) #'+ #*01 #*10) #(1 1))
(equalp (map '(simple-array * (2)) #'+ #*01 #*10) #(1 1))
(string= (map 'string #'char-upcase "abc") "ABC")
(string= (map 'base-string #'char-upcase "abc") "ABC")
(string= (map 'simple-string #'char-upcase "abc") "ABC")
(string= (map '(string 3) #'char-upcase "abc") "ABC")
(string= (map '(base-string 3) #'char-upcase "abc") "ABC")
(string= (map '(simple-string 3) #'char-upcase "abc") "ABC")
(string= (map '(vector character) #'char-upcase "abc") "ABC")
(string= (map '(vector character 3) #'char-upcase "abc") "ABC")
(string= (map '(vector base-char) #'char-upcase "abc") "ABC")
(string= (map '(vector base-char 3) #'char-upcase "abc") "ABC")
(string= (map '(vector standard-char) #'char-upcase "abc") "ABC")
(string= (map '(vector standard-char 3) #'char-upcase "abc") "ABC")
(string= (map '(array character 1) #'char-upcase "abc") "ABC")
(string= (map '(array character (3)) #'char-upcase "abc") "ABC")
(string= (map '(array base-char 1) #'char-upcase "abc") "ABC")
(string= (map '(array base-char (3)) #'char-upcase "abc") "ABC")
(string= (map '(array standard-char 1) #'char-upcase "abc") "ABC")
(string= (map '(array standard-char (3)) #'char-upcase "abc") "ABC")
(equalp (map 'bit-vector #'logand '(0 1 0 1) #*1010) #*0000)
(equalp (map 'simple-bit-vector #'logand '(0 1 0 1) #*1010) #*0000)
(equalp (map '(bit-vector 4) #'logand '(0 1 0 1) #*1010) #*0000)
(equalp (map '(simple-bit-vector 4) #'logand '(0 1 0 1) #*1010) #*0000)
(equalp (map '(array bit 1) #'logand '(0 1 0 1) #*1010) #*0000)
(equalp (map '(array bit (4)) #'logand '(0 1 0 1) #*1010) #*0000)
(equalp (map '(simple-array bit 1) #'logand '(0 1 0 1) #*1010) #*0000)
(equalp (map '(simple-array bit (4)) #'logand '(0 1 0 1) #*1010) #*0000)
(equalp (map '(vector bit) #'logand '(0 1 0 1) #*1010) #*0000)
(equalp (map '(vector bit 4) #'logand '(0 1 0 1) #*1010) #*0000)

(equal (map 'list #'+ '(0 1 2 3) #(3 2 1 0) #*0101) '(3 4 3 4))
(equalp (map 'vector #'+ '(0 1 2 3) #(3 2 1 0) #*0101) #(3 4 3 4))



(let ((a (list 1 2 3 4))
      (b (list 10 10 10 10)))
  (and (equal (map-into a #'+ a b) '(11 12 13 14))
       (equal a '(11 12 13 14))
       (equal b '(10 10 10 10))))
(let ((a '(11 12 13 14))
      (k '(one two three)))
  (equal (map-into a #'cons k a) '((ONE . 11) (TWO . 12) (THREE . 13) 14)))


(null (map-into nil 'identity))
(null (map-into nil #'identity))
(null (map-into nil #'identity '()))
(null (map-into nil #'identity '(0 1 2) '(9 8 7)))


(let ((list (list 0 1 2)))
  (and (eq (map-into list 'identity list) list)
       (equal list '(0 1 2))))
(let ((list (list 0 1 2)))
  (and (eq (map-into list 'identity '()) list)
       (equal list '(0 1 2))))

(let ((vec (vector 0 1 2)))
  (and (eq (map-into vec 'identity vec) vec)
       (equalp vec #(0 1 2))))
(let ((vec (vector 0 1 2)))
  (and (eq (map-into vec 'identity #()) vec)
       (equalp vec #(0 1 2))))
(let ((vec (vector 0 1 2)))
  (and (eq (map-into vec #'+ #() '() #()) vec)
       (equalp vec #(0 1 2))))


(equal (map-into (list nil nil) '+ '(0 1) '(1 0)) '(1 1))
(equal (map-into (list nil nil) '- '(0 1) '(1 0)) '(-1 1))
(let ((list (make-list 3 :initial-element nil)))
  (and (eq (map-into list #'+ '(0 1 2)) list)
       (equal list '(0 1 2))))
(let ((list (make-list 3 :initial-element nil)))
  (and (eq (map-into list #'+ '(0 1 2) '(1 2 3)) list)
       (equal list '(1 3 5))))
(let ((list (make-list 3 :initial-element nil)))
  (and (eq (map-into list #'+ '(0 1 2) '(1 2 3) '(2 3 4)) list)
       (equal list '(3 6 9))))

(let ((list (make-list 3 :initial-element nil)))
  (and (eq (map-into list #'+ '(1 2) '(1 2 3)) list)
       (equal list '(2 4 nil))))
(let ((list (make-list 1 :initial-element nil)))
  (and (eq (map-into list #'+ '(1 2 3) '(1 2 3)) list)
       (equal list '(2))))
(let ((list (make-list 3 :initial-element nil)))
  (and (eq (map-into list #'+ '(1 2 3 4) '(1 2 3) '(0)) list)
       (equal list '(2 nil nil))))


(let ((vec (make-sequence 'vector 3 :initial-element nil)))
  (and (eq (map-into vec #'+ '(0 1 2)) vec)
       (equalp vec #(0 1 2))))
(let ((vec (make-sequence 'vector 3 :initial-element nil)))
  (and (eq (map-into vec #'+ '(0 1 2) #(1 2 3)) vec)
       (equalp vec #(1 3 5))))
(let ((vec (make-sequence 'vector 3 :initial-element nil)))
  (and (eq (map-into vec #'+ '(0 1 2) '(1 2 3) #(2 3 4)) vec)
       (equalp vec #(3 6 9))))

(let ((vec (make-sequence 'vector 3 :initial-element nil)))
  (and (eq (map-into vec #'+ '(1 2) #(1 2 3)) vec)
       (equalp vec #(2 4 nil))))
(let ((vec (make-sequence 'vector 1 :initial-element nil)))
  (and (eq (map-into vec #'+ '(1 2) #(1 2 3)) vec)
       (equalp vec #(2))))
(let ((vec (make-sequence 'vector 3 :initial-element nil)))
  (and (eq (map-into vec #'+ '(1 2 3 4) #(1 2 3) '(0)) vec)
       (equalp vec #(2 nil nil))))


(let ((str (make-array 10
                       :element-type 'character
                       :initial-contents "0123456789"
                       :fill-pointer 3)))
  (and (eq (map-into str #'char-upcase "abcde") str)
       (string= str "ABCDE")
       (= (fill-pointer str) 5)))

(let ((vec (make-array 5
                       :initial-contents #(0 1 2 3 4)
                       :fill-pointer 3)))
  (and (eq (map-into vec #'+ '(0 1 2 3 4 5 6 7 8 9) '(9 8 7 6 5 4 3 2 1 0)) vec)
       (equalp vec #(9 9 9 9 9))))

(let ((vec (make-array 5
                       :initial-contents #(0 1 2 3 4)
                       :fill-pointer 3)))
  (and (eq (map-into vec #'+ '(0 1) '(9 8 7 6 5 4 3 2 1 0)) vec)
       (equalp vec #(9 9))))


(let ((vec (make-array 5
                       :element-type 'bit
                       :initial-contents #(1 1 1 1 1)
                       :fill-pointer 3)))
  (and (eq (map-into vec #'logand '(0 1) '(1 0 1 0 1 0)) vec)
       (equalp vec #*00)))


(eql (reduce #'* '(1 2 3 4 5)) 120)
(equal (reduce #'append '((1) (2)) :initial-value '(i n i t)) '(I N I T 1 2))
(equal (reduce #'append '((1) (2))
               :from-end t
               :initial-value '(i n i t))
       '(1 2 I N I T))
(eql (reduce #'- '(1 2 3 4)) -8)
(eql (reduce #'- '(1 2 3 4) :from-end t) -2)
(eql (reduce #'+ '()) 0)
(eql (reduce #'+ '(3)) 3)
(eq (reduce #'+ '(foo)) 'foo)
(equal (reduce #'list '(1 2 3 4)) '(((1 2) 3) 4))
(equal (reduce #'list '(1 2 3 4) :from-end t) '(1 (2 (3 4))))
(equal (reduce #'list '(1 2 3 4) :initial-value 'foo) '((((foo 1) 2) 3) 4))
(equal (reduce #'list '(1 2 3 4) :from-end t :initial-value 'foo)
       '(1 (2 (3 (4 foo)))))


(equal (reduce #'list '(0 1 2 3)) '(((0 1) 2) 3))
(equal (reduce #'list '(0 1 2 3) :start 1) '((1 2) 3))
(equal (reduce #'list '(0 1 2 3) :start 1 :end nil) '((1 2) 3))
(equal (reduce #'list '(0 1 2 3) :start 2) '(2 3))
(eq (reduce #'list '(0 1 2 3) :start 0 :end 0) '())
(eq (reduce #'list '(0 1 2 3) :start 0 :end 0 :initial-value 'initial-value)
    'initial-value)
(eq (reduce #'list '(0 1 2 3) :start 2 :end 2) '())
(eq (reduce #'list '(0 1 2 3) :start 2 :end 2 :initial-value 'initial-value)
    'initial-value)
(eq (reduce #'list '(0 1 2 3) :start 4 :end 4) '())
(eq (reduce #'list '(0 1 2 3) :start 4 :end 4 :initial-value 'initial-value)
    'initial-value)
(eql (reduce #'list '(0 1 2 3) :start 2 :end 3) 2)
(equal (reduce #'list '(0 1 2 3) :start 2 :end 3 :initial-value 'initial-value)
       '(initial-value 2))
(eql (reduce #'+ '(0 1 2 3 4 5 6 7 8 9)) 45)
(eql (reduce #'- '(0 1 2 3 4 5 6 7 8 9)) -45)
(eql (reduce #'- '(0 1 2 3 4 5 6 7 8 9) :from-end t) -5)
(equal (reduce #'list '(0 1 2 3) :initial-value 'initial-value)
       '((((initial-value 0) 1) 2) 3))
(equal (reduce #'list '(0 1 2 3) :from-end t) '(0 (1 (2 3))))
(equal (reduce #'list '((1) (2) (3) (4)) :key #'car) '(((1 2) 3) 4))
(equal (reduce #'list '((1) (2) (3) (4)) :key #'car :from-end nil)
       '(((1 2) 3) 4))
(equal (reduce #'list '((1) (2) (3) (4)) :key #'car :initial-value 0)
       '((((0 1) 2) 3) 4))
(equal (reduce #'list '((1) (2) (3) (4)) :key #'car :from-end t)
       '(1 (2 (3 4))))
(equal (reduce #'list '((1) (2) (3) (4))
               :key #'car :from-end t :initial-value 5)
       '(1 (2 (3 (4 5)))))




(equal (reduce #'list #(0 1 2 3)) '(((0 1) 2) 3))
(equal (reduce #'list #(0 1 2 3) :start 1) '((1 2) 3))
(equal (reduce #'list #(0 1 2 3) :start 1 :end nil) '((1 2) 3))
(equal (reduce #'list #(0 1 2 3) :start 2) '(2 3))
(eq (reduce #'list #(0 1 2 3) :start 0 :end 0) '())
(eq (reduce #'list #(0 1 2 3) :start 0 :end 0 :initial-value 'initial-value)
    'initial-value)
(eq (reduce #'list #(0 1 2 3) :start 2 :end 2) '())
(eq (reduce #'list #(0 1 2 3) :start 2 :end 2 :initial-value 'initial-value)
    'initial-value)
(eq (reduce #'list #(0 1 2 3) :start 4 :end 4) '())
(eq (reduce #'list #(0 1 2 3) :start 4 :end 4 :initial-value 'initial-value)
    'initial-value)
(eql (reduce #'list #(0 1 2 3) :start 2 :end 3) 2)
(equal (reduce #'list #(0 1 2 3) :start 2 :end 3 :initial-value 'initial-value)
       '(initial-value 2))
(eql (reduce #'+ #(0 1 2 3 4 5 6 7 8 9)) 45)
(eql (reduce #'- #(0 1 2 3 4 5 6 7 8 9)) -45)
(eql (reduce #'- #(0 1 2 3 4 5 6 7 8 9) :from-end t) -5)
(equal (reduce #'list #(0 1 2 3) :initial-value 'initial-value)
       '((((initial-value 0) 1) 2) 3))
(equal (reduce #'list #(0 1 2 3) :from-end t) '(0 (1 (2 3))))
(equal (reduce #'list #((1) (2) (3) (4)) :key #'car) '(((1 2) 3) 4))
(equal (reduce #'list #((1) (2) (3) (4)) :key #'car :from-end nil)
       '(((1 2) 3) 4))
(equal (reduce #'list #((1) (2) (3) (4)) :key #'car :initial-value 0)
       '((((0 1) 2) 3) 4))
(equal (reduce #'list #((1) (2) (3) (4)) :key #'car :from-end t)
       '(1 (2 (3 4))))
(equal (reduce #'list #((1) (2) (3) (4))
               :key #'car :from-end t :initial-value 5)
       '(1 (2 (3 (4 5)))))

(string= (reduce #'(lambda (&rest rest)
                     (concatenate 'string
                                  (string (car rest))
                                  (string (char-upcase (cadr rest)))))
                 "abcdefg"
                 :initial-value #\Z)
         "ZABCDEFG")


(eql (count #\a "how many A's are there in here?") 2)
(eql (count-if-not #'oddp '((1) (2) (3) (4)) :key #'car) 2)
(eql (count-if #'upper-case-p "The Crying of Lot 49" :start 4) 2)
(eql (count #\a (concatenate 'list "how many A's are there in here?")) 2)
(eql (count-if #'alpha-char-p "-a-b-c-0-1-2-3-4-") 3)
(eql (count-if #'alphanumericp "-a-b-c-0-1-2-3-4-") 8)

(eql (count 'nil '(t nil t nil t nil)) 3)
(eql (count 'nil #(t nil t nil t nil)) 3)
(zerop (count 9 '(0 1 2 3 4)))
(zerop (count 'a '(0 1 2 3 4)))
(eql (count 0 '(0 0 0 0 0) :start 1) 4)
(eql (count 0 '(0 0 0 0 0) :start 1 :end nil) 4)
(eql (count 0 '(0 0 0 0 0) :start 2) 3)
(zerop (count 0 '(0 0 0 0) :start 0 :end 0))
(zerop (count 0 '(0 0 0 0) :start 2 :end 2))
(zerop (count 0 '(0 0 0 0) :start 4 :end 4))
(eql (count 0 '(0 0 0 0) :start 2 :end 3) 1)
(eql (count #\a "abcABC" :test #'equalp) 2)
(eql (count #\a "abcABC" :test #'char-equal) 2)
(eql (count '(a) '((x) (y) (z) (a) (b) (c)) :test #'equalp) 1)
(eql (count #\a "abcABC" :test-not (complement #'equalp)) 2)
(eql (count #\a "abcABC" :test-not (complement #'char-equal)) 2)
(eql (count '(a) '((x) (y) (z) (a) (b) (c)) :test-not (complement #'equalp)) 1)
(eql (count 'a '((x) (y) (z) (a) (b) (c)) :key #'car :test #'eq) 1)
(eql (count 'nil '((x . x) (y) (z . z) (a) (b . b) (c)) :key #'cdr :test #'eq)
     3)
(let ((list nil))
  (and (eql (count 'a '(a b c d)
                   :test #'(lambda (a b) (setq list (cons b list)) (eq a b)))
            1)
       (equal list '(d c b a))))

(let ((list nil))
  (and (eql (count 'a '(a b c d)
                   :test #'(lambda (a b) (setq list (cons b list)) (eq a b))
                   :from-end t)
            1)
       (equal list '(a b c d))))


(zerop (count 9 #(0 1 2 3 4)))
(zerop (count 'a #(0 1 2 3 4)))
(eql (count 0 #(0 0 0 0 0) :start 1) 4)
(eql (count 0 #(0 0 0 0 0) :start 1 :end nil) 4)
(eql (count 0 #(0 0 0 0 0) :start 2) 3)
(zerop (count 0 #(0 0 0 0) :start 0 :end 0))
(zerop (count 0 #(0 0 0 0) :start 2 :end 2))
(zerop (count 0 #(0 0 0 0) :start 4 :end 4))
(eql (count 0 #(0 0 0 0) :start 2 :end 3) 1)
(eql (count '(a) #((x) (y) (z) (a) (b) (c)) :test #'equalp) 1)
(eql (count '(a) #((x) (y) (z) (a) (b) (c)) :test-not (complement #'equalp)) 1)
(eql (count 'a #((x) (y) (z) (a) (b) (c)) :key #'car :test #'eq) 1)
(eql (count 'nil #((x . x) (y) (z . z) (a) (b . b) (c)) :key #'cdr :test #'eq)
     3)
(let ((list nil))
  (and (eql (count 'a #(a b c d)
                   :test #'(lambda (a b) (setq list (cons b list)) (eq a b)))
            1)
       (equal list '(d c b a))))

(let ((list nil))
  (and (eql (count 'a #(a b c d)
                   :test #'(lambda (a b) (setq list (cons b list)) (eq a b))
                   :from-end t)
            1)
       (equal list '(a b c d))))


(eql (count-if #'null '(t nil t nil t nil)) 3)
(zerop (count-if #'(lambda (x) (eql x 9)) #(0 1 2 3 4)))
(zerop (count-if #'(lambda (a) (eq 'x a)) #(0 1 2 3 4)))
(eql (count-if #'zerop '(0 0 0 0 0) :start 1) 4)
(eql (count-if #'zerop '(0 0 0 0 0) :start 1 :end nil) 4)
(eql (count-if #'zerop '(0 0 0 0 0) :start 2) 3)
(zerop (count-if #'zerop '(0 0 0 0) :start 0 :end 0))
(zerop (count-if #'zerop '(0 0 0 0) :start 2 :end 2))
(zerop (count-if #'zerop '(0 0 0 0) :start 4 :end 4))
(eql (count-if #'zerop '(0 0 0 0) :start 2 :end 3) 1)
(eql (count-if #'(lambda (x) (equalp #\a x)) "abcABC") 2)
(eql (count-if #'(lambda (x) (char-equal #\a x)) "abcABC") 2)
(eql (count-if #'(lambda (x) (equal x '(a)))
               '((x) (y) (z) (a) (b) (c))) 1)
(eql (count-if  #'(lambda (x) (eq x 'a))
                '((x) (y) (z) (a) (b) (c)) :key #'car)
     1)
(eql (count-if 'null '((x . x) (y) (z . z) (a) (b . b) (c)) :key #'cdr)
     3)
(eql (count-if #'(lambda (x) (equal x '(a)))
               '((x) (y) (z) (a) (b) (c)))
     1)
(eql (count-if #'(lambda (x) (eq x 'a)) '((x) (y) (z) (a) (b) (c)) :key #'car)
     1)
(eql (count-if #'null '((x . x) (y) (z . z) (a) (b . b) (c)) :key #'cdr)
     3)
(let ((list nil))
  (and (eql (count-if  #'(lambda (x) (setq list (cons x list)) (eq x 'a))
                       '(a b c d))
            1)
       (equal list '(d c b a))))
(let ((list nil))
  (and (eql (count-if  #'(lambda (x) (setq list (cons x list)) (eq x 'a))
                       '(a b c d)
                       :from-end t)
            1)
       (equal list '(a b c d))))
(eql (count-if #'null #(t nil t nil t nil)) 3)
(eql (count-if #'zerop #(0 0 0 0 0) :start 1) 4)
(eql (count-if #'zerop #(0 0 0 0 0) :start 1 :end nil) 4)
(eql (count-if #'zerop #(0 0 0 0 0) :start 2) 3)
(zerop (count-if #'zerop #(0 0 0 0) :start 0 :end 0))
(zerop (count-if #'zerop #(0 0 0 0) :start 2 :end 2))
(zerop (count-if #'zerop #(0 0 0 0) :start 4 :end 4))
(eql (count-if #'zerop #(0 0 0 0) :start 2 :end 3) 1)
(eql (count-if #'(lambda (x) (equal x '(a)))
               #((x) (y) (z) (a) (b) (c))) 1)
(eql (count-if  #'(lambda (x) (eq x 'a))
                #((x) (y) (z) (a) (b) (c)) :key #'car)
     1)
(eql (count-if #'null #((x . x) (y) (z . z) (a) (b . b) (c)) :key #'cdr)
     3)
(eql (count-if #'(lambda (x) (equal x '(a)))
               #((x) (y) (z) (a) (b) (c)))
     1)
(eql (count-if #'(lambda (x) (eq x 'a)) #((x) (y) (z) (a) (b) (c)) :key #'car)
     1)
(eql (count-if #'null #((x . x) (y) (z . z) (a) (b . b) (c)) :key #'cdr)
     3)
(let ((list nil))
  (and (eql (count-if  #'(lambda (x) (setq list (cons x list)) (eq x 'a))
                       #(a b c d))
            1)
       (equal list '(d c b a))))
(let ((list nil))
  (and (eql (count-if  #'(lambda (x) (setq list (cons x list)) (eq x 'a))
                       #(a b c d)
                       :from-end t)
            1)
       (equal list '(a b c d))))



(eql (count-if-not (complement #'null) '(t nil t nil t nil)) 3)
(zerop (count-if-not #'(lambda (x) (not (eql x 9))) #(0 1 2 3 4)))
(zerop (count-if-not #'(lambda (a) (not (eq 'x a))) #(0 1 2 3 4)))
(eql (count-if-not (complement #'zerop) '(0 0 0 0 0) :start 1) 4)
(eql (count-if-not (complement #'zerop) '(0 0 0 0 0) :start 1 :end nil) 4)
(eql (count-if-not (complement #'zerop) '(0 0 0 0 0) :start 2) 3)
(zerop (count-if-not (complement #'zerop) '(0 0 0 0) :start 0 :end 0))
(zerop (count-if-not (complement #'zerop) '(0 0 0 0) :start 2 :end 2))
(zerop (count-if-not (complement #'zerop) '(0 0 0 0) :start 4 :end 4))
(eql (count-if-not (complement #'zerop) '(0 0 0 0) :start 2 :end 3) 1)
(eql (count-if-not #'(lambda (x) (not (equalp #\a x))) "abcABC") 2)
(eql (count-if-not #'(lambda (x) (not (char-equal #\a x))) "abcABC") 2)
(eql (count-if-not #'(lambda (x) (not (equal x '(a))))
               '((x) (y) (z) (a) (b) (c))) 1)
(eql (count-if-not  #'(lambda (x) (not (eq x 'a)))
                '((x) (y) (z) (a) (b) (c)) :key #'car)
     1)
(eql (count-if-not (complement #'null)
                   '((x . x) (y) (z . z) (a) (b . b) (c)) :key #'cdr)
     3)
(eql (count-if-not #'(lambda (x) (not (equal x '(a))))
               '((x) (y) (z) (a) (b) (c)))
     1)
(eql (count-if-not #'(lambda (x) (not (eq x 'a)))
                   '((x) (y) (z) (a) (b) (c)) :key #'car)
     1)
(eql (count-if-not (complement #'null)
                   '((x . x) (y) (z . z) (a) (b . b) (c)) :key #'cdr)
     3)
(let ((list nil))
  (and (eql (count-if-not  #'(lambda (x)
                               (setq list (cons x list))
                               (not (eq x 'a)))
                       '(a b c d))
            1)
       (equal list '(d c b a))))
(let ((list nil))
  (and (eql (count-if-not  #'(lambda (x)
                               (setq list (cons x list))
                               (not (eq x 'a)))
                       '(a b c d)
                       :from-end t)
            1)
       (equal list '(a b c d))))
(eql (count-if-not (complement #'null) #(t nil t nil t nil)) 3)
(eql (count-if-not (complement #'zerop) #(0 0 0 0 0) :start 1) 4)
(eql (count-if-not (complement #'zerop) #(0 0 0 0 0) :start 1 :end nil) 4)
(eql (count-if-not (complement #'zerop) #(0 0 0 0 0) :start 2) 3)
(zerop (count-if-not (complement #'zerop) #(0 0 0 0) :start 0 :end 0))
(zerop (count-if-not (complement #'zerop) #(0 0 0 0) :start 2 :end 2))
(zerop (count-if-not (complement #'zerop) #(0 0 0 0) :start 4 :end 4))
(eql (count-if-not (complement #'zerop) #(0 0 0 0) :start 2 :end 3) 1)
(eql (count-if-not #'(lambda (x) (not (equal x '(a))))
               #((x) (y) (z) (a) (b) (c))) 1)
(eql (count-if-not  #'(lambda (x) (not (eq x 'a)))
                #((x) (y) (z) (a) (b) (c)) :key #'car)
     1)
(eql (count-if-not (complement #'null)
                   #((x . x) (y) (z . z) (a) (b . b) (c)) :key #'cdr)
     3)
(eql (count-if-not #'(lambda (x) (not (equal x '(a))))
               #((x) (y) (z) (a) (b) (c)))
     1)
(eql (count-if-not #'(lambda (x) (not (eq x 'a)))
                   #((x) (y) (z) (a) (b) (c)) :key #'car)
     1)
(eql (count-if-not (complement #'null)
                   #((x . x) (y) (z . z) (a) (b . b) (c)) :key #'cdr)
     3)
(let ((list nil))
  (and (eql (count-if-not  #'(lambda (x)
                               (setq list (cons x list))
                               (not (eq x 'a)))
                       #(a b c d))
            1)
       (equal list '(d c b a))))
(let ((list nil))
  (and (eql (count-if-not  #'(lambda (x)
                               (setq list (cons x list))
                               (not (eq x 'a)))
                       #(a b c d)
                       :from-end t)
            1)
       (equal list '(a b c d))))


(null (reverse nil))
(string= (reverse "") "")
(equalp (reverse #*) #*)
(equalp (reverse #()) #())
(equal (reverse '(0 1 2 3)) '(3 2 1 0))
(string= (reverse "0123") "3210")
(equalp (reverse #*1100) #*0011)
(equalp (reverse #(a b c d)) #(d c b a))

(null (nreverse nil))
(string= (nreverse (copy-seq "")) "")
(equalp (nreverse (copy-seq #*)) #*)
(equalp (nreverse (copy-seq #())) #())
(equal (nreverse (list 0 1 2 3)) '(3 2 1 0))
(string= (nreverse (copy-seq "0123")) "3210")
(equalp (reverse (copy-seq #*1100)) #*0011)
(equalp (reverse (copy-seq #(a b c d))) #(d c b a))



(char= (find #\d "edcba" :test #'char>) #\c)
(eql (find-if #'oddp '(1 2 3 4 5) :end 3 :from-end t) 3)
(null (find-if-not #'complexp
                   '#(3.5 2 #C(1.0 0.0) #C(0.0 1.0))
                   :start 2))


(eq (find 'a '(a b c)) 'a)
(eq (find 'b '(a b c)) 'b)
(eq (find 'c '(a b c)) 'c)
(null (find 'x '(a b c)))
(null (find 'a '(a b c) :start 1))
(null (find 'b '(a b c) :start 2))
(null (find 'c '(a b c) :start 3))
(null (find 'a '(a b c) :start 0 :end 0))
(null (find 'a '(a b c) :start 0 :end 0 :from-end t))
(null (find 'a '(a b c) :start 1 :end 1))
(null (find 'a '(a b c) :start 1 :end 1 :from-end t))
(null (find 'a '(a b c) :start 2 :end 2))
(null (find 'a '(a b c) :start 2 :end 2 :from-end t))
(null (find 'a '(a b c) :start 3 :end 3))
(null (find 'a '(a b c) :start 3 :end 3 :from-end t))
(eq (find 'a '(a b c) :end nil) 'a)
(eq (find 'b '(a b c) :end nil) 'b)
(eq (find 'c '(a b c) :end nil) 'c)
(eq (find 'a '(a b c) :end 1) 'a)
(eq (find 'b '(a b c) :end 2) 'b)
(eq (find 'c '(a b c) :end 3) 'c)
(null (find 'a '(a b c) :end 0))
(null (find 'b '(a b c) :end 1))
(null (find 'c '(a b c) :end 2))

(null (find 'a '((a) (b) (c))))
(equal (find 'a '((a) (b) (c)) :key #'car) '(a))
(equal (find 'b '((a) (b) (c)) :key #'car) '(b))
(equal (find 'c '((a) (b) (c)) :key #'car) '(c))
(null (find 'z '((a) (b) (c)) :key #'car))
(let ((list '((a) (b) (c))))
  (and (eq (find 'a list :key #'car) (car list))
       (eq (find 'b list :key #'car) (cadr list))
       (eq (find 'c list :key #'car) (caddr list))
       (null (find 'z list :key #'car))))
(null (find '(a) '((a) (b) (c))))
(equal (find '(a) '((a) (b) (c)) :test #'equal) '(a))
(null (find '("a") '(("a") ("b") ("c"))))
(null (find '("a") '(("A") ("B") ("c")) :test #'equal))
(equal (find '("a") '(("A") ("B") ("c")) :test #'equalp) '("A"))
(eq (find 'nil '(first second third) :test (constantly t)) 'first)
(eql (find 3 '(0 1 2 3 4 5)) 3)
(eql (find 3 '(0 1 2 3 4 5) :test #'<) 4)
(eql (find 3 '(0 1 2 3 4 5) :test #'>) 0)

(equal (find '(a) '((a) (b) (c)) :test-not (complement #'equal)) '(a))
(null (find '("a") '(("A") ("B") ("c")) :test-not (complement #'equal)))
(equal (find '("a") '(("A") ("B") ("c")) :test-not (complement #'equalp))
       '("A"))
(eq (find 'nil '(first second third) :test-not (constantly nil)) 'first)
(eql (find 3 '(0 1 2 3 4 5) :test-not #'>=) 4)
(eql (find 3 '(0 1 2 3 4 5) :test-not #'<=) 0)

(equal (find 'a '((a) (b) (c) (a a) (b b) (c c)) :key #'car)
       '(a))
(equal (find 'a '((a) (b) (c) (a a) (b b) (c c)) :key #'car :from-end t)
       '(a a))
(equal (find 'b '((a) (b) (c) (a a) (b b) (c c)) :key #'car)
       '(b))
(equal (find 'b '((a) (b) (c) (a a) (b b) (c c)) :key #'car :from-end t)
       '(b b))
(equal (find 'c '((a) (b) (c) (a a) (b b) (c c)) :key #'car)
       '(c))
(equal (find 'c '((a) (b) (c) (a a) (b b) (c c)) :key #'car :from-end t)
       '(c c))
(null (find 'z '((a) (b) (c) (a a) (b b) (c c)) :key #'car))
(null (find 'z '((a) (b) (c) (a a) (b b) (c c)) :key #'car :from-end t))

(equal (find 'a '((a) (b) (c) (a a) (b b) (c c) (a a a))
             :key #'car
             :from-end t)
       '(a a a))
(equal (find 'a '((a) (b) (c) (a a) (b b) (c c) (a a a))
             :key #'car
             :from-end t
             :end nil)
       '(a a a))
(equal (find 'a '((a) (b) (c) (a a) (b b) (c c) (a a a))
             :key #'car
             :from-end t
             :end 6)
       '(a a))
(null (find 'a '((a) (b) (c) (a a) (b b) (c c) (a a a))
            :key #'car
            :from-end t
            :start 1
            :end 3))
(null (find #\c '("abc" "bcd" "cde")))
(string= (find #\c '("abc" "bcd" "cde")
               :key #'(lambda (arg) (char arg 0))
               :test #'char=)
         "cde")
(string= (find #\c '("abc" "bcd" "cde")
               :key #'(lambda (arg) (char arg 0))
               :test #'char>)
         "abc")
(string= (find #\c '("abc" "bcd" "cde")
               :start 1
               :key #'(lambda (arg) (char arg 0))
               :test #'char>)
         "bcd")


(eq (find 'a #(a b c)) 'a)
(eq (find 'b #(a b c)) 'b)
(eq (find 'c #(a b c)) 'c)
(null (find 'x #(a b c)))
(null (find 'a #(a b c) :start 1))
(null (find 'b #(a b c) :start 2))
(null (find 'c #(a b c) :start 3))
(null (find 'a #(a b c) :start 0 :end 0))
(null (find 'a #(a b c) :start 0 :end 0 :from-end t))
(null (find 'a #(a b c) :start 1 :end 1))
(null (find 'a #(a b c) :start 1 :end 1 :from-end t))
(null (find 'a #(a b c) :start 2 :end 2))
(null (find 'a #(a b c) :start 2 :end 2 :from-end t))
(null (find 'a #(a b c) :start 3 :end 3))
(null (find 'a #(a b c) :start 3 :end 3 :from-end t))
(eq (find 'a #(a b c) :end nil) 'a)
(eq (find 'b #(a b c) :end nil) 'b)
(eq (find 'c #(a b c) :end nil) 'c)
(eq (find 'a #(a b c) :end 1) 'a)
(eq (find 'b #(a b c) :end 2) 'b)
(eq (find 'c #(a b c) :end 3) 'c)
(null (find 'a #(a b c) :end 0))
(null (find 'b #(a b c) :end 1))
(null (find 'c #(a b c) :end 2))
(null (find 'a #((a) (b) (c))))
(equal (find 'a #((a) (b) (c)) :key #'car) '(a))
(equal (find 'b #((a) (b) (c)) :key #'car) '(b))
(equal (find 'c #((a) (b) (c)) :key #'car) '(c))
(null (find 'z #((a) (b) (c)) :key #'car))
(let ((vector #((a) (b) (c))))
  (and (eq (find 'a vector :key #'car) (aref vector 0))
       (eq (find 'b vector :key #'car) (aref vector 1))
       (eq (find 'c vector :key #'car) (aref vector 2))
       (null (find 'z vector :key #'car))))
(null (find '(a) #((a) (b) (c))))
(equal (find '(a) #((a) (b) (c)) :test #'equal) '(a))
(null (find '("a") #(("a") ("b") ("c"))))
(null (find '("a") #(("A") ("B") ("c")) :test #'equal))
(equal (find '("a") #(("A") ("B") ("c")) :test #'equalp) '("A"))
(eq (find 'nil #(first second third) :test (constantly t)) 'first)
(eql (find 3 #(0 1 2 3 4 5)) 3)
(eql (find 3 #(0 1 2 3 4 5) :test #'<) 4)
(eql (find 3 #(0 1 2 3 4 5) :test #'>) 0)
(equal (find '(a) #((a) (b) (c)) :test-not (complement #'equal)) '(a))
(null (find '("a") #(("A") ("B") ("c")) :test-not (complement #'equal)))
(equal (find '("a") #(("A") ("B") ("c")) :test-not (complement #'equalp))
       '("A"))
(eq (find 'nil #(first second third) :test-not (constantly nil)) 'first)
(eql (find 3 #(0 1 2 3 4 5) :test-not #'>=) 4)
(eql (find 3 #(0 1 2 3 4 5) :test-not #'<=) 0)
(equal (find 'a #((a) (b) (c) (a a) (b b) (c c)) :key #'car)
       '(a))
(equal (find 'a #((a) (b) (c) (a a) (b b) (c c)) :key #'car :from-end t)
       '(a a))
(equal (find 'b #((a) (b) (c) (a a) (b b) (c c)) :key #'car)
       '(b))
(equal (find 'b #((a) (b) (c) (a a) (b b) (c c)) :key #'car :from-end t)
       '(b b))
(equal (find 'c #((a) (b) (c) (a a) (b b) (c c)) :key #'car)
       '(c))
(equal (find 'c #((a) (b) (c) (a a) (b b) (c c)) :key #'car :from-end t)
       '(c c))
(null (find 'z #((a) (b) (c) (a a) (b b) (c c)) :key #'car))
(null (find 'z #((a) (b) (c) (a a) (b b) (c c)) :key #'car :from-end t))

(equal (find 'a #((a) (b) (c) (a a) (b b) (c c) (a a a))
             :key #'car
             :from-end t)
       '(a a a))
(equal (find 'a #((a) (b) (c) (a a) (b b) (c c) (a a a))
             :key #'car
             :from-end t
             :end nil)
       '(a a a))
(equal (find 'a #((a) (b) (c) (a a) (b b) (c c) (a a a))
             :key #'car
             :from-end t
             :end 6)
       '(a a))
(null (find 'a #((a) (b) (c) (a a) (b b) (c c) (a a a))
            :key #'car
            :from-end t
            :start 1
            :end 3))
(null (find #\c #("abc" "bcd" "cde")))
(string= (find #\c #("abc" "bcd" "cde")
               :key #'(lambda (arg) (char arg 0))
               :test #'char=)
         "cde")
(string= (find #\c #("abc" "bcd" "cde")
               :key #'(lambda (arg) (char arg 0))
               :test #'char>)
         "abc")
(string= (find #\c #("abc" "bcd" "cde")
               :start 1
               :key #'(lambda (arg) (char arg 0))
               :test #'char>)
         "bcd")
(null (find #\z "abcABC"))
(eql (find #\a "abcABC") #\a)
(eql (find #\A "abcABC") #\A)
(eql (find #\A "abcABC" :test #'char-equal) #\a)
(eql (find #\A "abcABC" :test #'char-equal :from-end t) #\A)
(eql (find #\a "abcABC" :test #'char-equal :from-end t) #\A)
(eql (find #\a "abcABC" :test #'char-equal :from-end t :end 4) #\A)
(eql (find #\a "abcABC" :test #'char-equal :from-end t :end 3) #\a)
(zerop (find 0 #*01))
(eql (find 1 #*01) 1)
(null (find 0 #*01 :start 1))
(null (find 1 #*01 :end 0))
(null (find 0 #*000001 :start 5))



(eq (find-if #'(lambda (x) (eq x 'a)) '(a b c)) 'a)
(eq (find-if #'(lambda (x) (eq x 'b)) '(a b c)) 'b)
(eq (find-if #'(lambda (x) (eq x 'c)) '(a b c)) 'c)
(null (find-if #'(lambda (arg) (eq arg 'x)) '(a b c)))
(null (find-if #'(lambda (x) (eq x 'a)) '(a b c) :start 1))
(null (find-if #'(lambda (x) (eq x 'b)) '(a b c) :start 2))
(null (find-if #'(lambda (x) (eq x 'c)) '(a b c) :start 3))
(null (find-if #'(lambda (x) (eq x 'a)) '(a b c) :start 0 :end 0))
(null (find-if #'(lambda (x) (eq x 'a)) '(a b c) :start 0 :end 0 :from-end t))
(null (find-if #'(lambda (x) (eq x 'a)) '(a b c) :start 1 :end 1))
(null (find-if #'(lambda (x) (eq x 'a)) '(a b c) :start 1 :end 1 :from-end t))
(null (find-if #'(lambda (x) (eq x 'a)) '(a b c) :start 2 :end 2))
(null (find-if #'(lambda (x) (eq x 'a)) '(a b c) :start 2 :end 2 :from-end t))
(null (find-if #'(lambda (x) (eq x 'a)) '(a b c) :start 3 :end 3))
(null (find-if #'(lambda (x) (eq x 'a)) '(a b c) :start 3 :end 3 :from-end t))
(eq (find-if #'(lambda (x) (eq x 'a)) '(a b c) :end nil) 'a)
(eq (find-if #'(lambda (x) (eq x 'b)) '(a b c) :end nil) 'b)
(eq (find-if #'(lambda (x) (eq x 'c)) '(a b c) :end nil) 'c)
(eq (find-if #'(lambda (x) (eq x 'a)) '(a b c) :end 1) 'a)
(eq (find-if #'(lambda (x) (eq x 'b)) '(a b c) :end 2) 'b)
(eq (find-if #'(lambda (x) (eq x 'c)) '(a b c) :end 3) 'c)
(null (find-if #'(lambda (x) (eq x 'a)) '(a b c) :end 0))
(null (find-if #'(lambda (x) (eq x 'b)) '(a b c) :end 1))
(null (find-if #'(lambda (x) (eq x 'c)) '(a b c) :end 2))
(null (find-if #'(lambda (x) (eq x 'a)) '((a) (b) (c))))
(equal (find-if #'(lambda (x) (eq x 'a)) '((a) (b) (c)) :key #'car) '(a))
(equal (find-if #'(lambda (x) (eq x 'b)) '((a) (b) (c)) :key #'car) '(b))
(equal (find-if #'(lambda (x) (eq x 'c)) '((a) (b) (c)) :key #'car) '(c))
(null (find-if #'(lambda (x) (eq x 'z)) '((a) (b) (c)) :key #'car))
(let ((list '((a) (b) (c))))
  (and (eq (find-if #'(lambda (x) (eq x 'a)) list :key #'car) (car list))
       (eq (find-if #'(lambda (x) (eq x 'b)) list :key #'car) (cadr list))
       (eq (find-if #'(lambda (x) (eq x 'c)) list :key #'car) (caddr list))
       (null (find-if #'(lambda (x) (eq x 'z)) list :key #'car))))
(equal (find-if #'(lambda (x) (eq x 'a))
                '((a) (b) (c) (a a) (b b) (c c)) :key #'car)
       '(a))
(equal (find-if #'(lambda (x) (eq x 'a))
                '((a) (b) (c) (a a) (b b) (c c)) :key #'car :from-end t)
       '(a a))
(equal (find-if #'(lambda (x) (eq x 'b))
                '((a) (b) (c) (a a) (b b) (c c)) :key #'car)
       '(b))
(equal (find-if #'(lambda (x) (eq x 'b))
                '((a) (b) (c) (a a) (b b) (c c)) :key #'car :from-end t)
       '(b b))
(equal (find-if #'(lambda (x) (eq x 'c))
                '((a) (b) (c) (a a) (b b) (c c)) :key #'car)
       '(c))
(equal (find-if #'(lambda (x) (eq x 'c))
                '((a) (b) (c) (a a) (b b) (c c)) :key #'car :from-end t)
       '(c c))
(null (find-if #'(lambda (x) (eq x 'z))
               '((a) (b) (c) (a a) (b b) (c c)) :key #'car))
(null (find-if #'(lambda (x) (eq x 'z))
               '((a) (b) (c) (a a) (b b) (c c)) :key #'car :from-end t))
(equal (find-if #'(lambda (x) (eq x 'a))
                '((a) (b) (c) (a a) (b b) (c c) (a a a))
                :key #'car
                :from-end t)
       '(a a a))
(equal (find-if #'(lambda (x) (eq x 'a))
                '((a) (b) (c) (a a) (b b) (c c) (a a a))
                :key #'car
                :from-end t
                :end nil)
       '(a a a))
(equal (find-if #'(lambda (x) (eq x 'a))
                '((a) (b) (c) (a a) (b b) (c c) (a a a))
                :key #'car
                :from-end t
                :end 6)
       '(a a))
(null (find-if #'(lambda (x) (eq x 'a))
               '((a) (b) (c) (a a) (b b) (c c) (a a a))
               :key #'car
               :from-end t
               :start 1
               :end 3))
(null (find-if #'(lambda (x) (eql x #\c)) '("abc" "bcd" "cde")))
(string= (find-if #'(lambda (x) (eql x #\c)) '("abc" "bcd" "cde")
                  :key #'(lambda (arg) (char arg 0)))
         "cde")
(string= (find-if #'(lambda (x) (char> #\c x)) '("abc" "bcd" "cde")
                  :key #'(lambda (arg) (char arg 0)))
         "abc")
(string= (find-if #'(lambda (x) (char> #\c x)) '("abc" "bcd" "cde")
               :start 1
               :key #'(lambda (arg) (char arg 0)))
         "bcd")


(eq (find-if #'(lambda (x) (eq x 'a)) #(a b c)) 'a)
(eq (find-if #'(lambda (x) (eq x 'b)) #(a b c)) 'b)
(eq (find-if #'(lambda (x) (eq x 'c)) #(a b c)) 'c)
(null (find-if #'(lambda (arg) (eq arg 'x)) #(a b c)))
(null (find-if #'(lambda (x) (eq x 'a)) #(a b c) :start 1))
(null (find-if #'(lambda (x) (eq x 'b)) #(a b c) :start 2))
(null (find-if #'(lambda (x) (eq x 'c)) #(a b c) :start 3))
(null (find-if #'(lambda (x) (eq x 'a)) #(a b c) :start 0 :end 0))
(null (find-if #'(lambda (x) (eq x 'a)) #(a b c) :start 0 :end 0 :from-end t))
(null (find-if #'(lambda (x) (eq x 'a)) #(a b c) :start 1 :end 1))
(null (find-if #'(lambda (x) (eq x 'a)) #(a b c) :start 1 :end 1 :from-end t))
(null (find-if #'(lambda (x) (eq x 'a)) #(a b c) :start 2 :end 2))
(null (find-if #'(lambda (x) (eq x 'a)) #(a b c) :start 2 :end 2 :from-end t))
(null (find-if #'(lambda (x) (eq x 'a)) #(a b c) :start 3 :end 3))
(null (find-if #'(lambda (x) (eq x 'a)) #(a b c) :start 3 :end 3 :from-end t))
(eq (find-if #'(lambda (x) (eq x 'a)) #(a b c) :end nil) 'a)
(eq (find-if #'(lambda (x) (eq x 'b)) #(a b c) :end nil) 'b)
(eq (find-if #'(lambda (x) (eq x 'c)) #(a b c) :end nil) 'c)
(eq (find-if #'(lambda (x) (eq x 'a)) #(a b c) :end 1) 'a)
(eq (find-if #'(lambda (x) (eq x 'b)) #(a b c) :end 2) 'b)
(eq (find-if #'(lambda (x) (eq x 'c)) #(a b c) :end 3) 'c)
(null (find-if #'(lambda (x) (eq x 'a)) #(a b c) :end 0))
(null (find-if #'(lambda (x) (eq x 'b)) #(a b c) :end 1))
(null (find-if #'(lambda (x) (eq x 'c)) #(a b c) :end 2))
(null (find-if #'(lambda (x) (eq x 'a)) #((a) (b) (c))))
(equal (find-if #'(lambda (x) (eq x 'a)) #((a) (b) (c)) :key #'car) '(a))
(equal (find-if #'(lambda (x) (eq x 'b)) #((a) (b) (c)) :key #'car) '(b))
(equal (find-if #'(lambda (x) (eq x 'c)) #((a) (b) (c)) :key #'car) '(c))
(null (find-if #'(lambda (x) (eq x 'z)) #((a) (b) (c)) :key #'car))
(let ((vector #((a) (b) (c))))
  (and (eq (find-if #'(lambda (x) (eq x 'a)) vector :key #'car) (aref vector 0))
       (eq (find-if #'(lambda (x) (eq x 'b)) vector :key #'car) (aref vector 1))
       (eq (find-if #'(lambda (x) (eq x 'c)) vector :key #'car) (aref vector 2))
       (null (find-if #'(lambda (x) (eq x 'z)) vector :key #'car))))
(equal (find-if #'(lambda (x) (eq x 'a))
                #((a) (b) (c) (a a) (b b) (c c)) :key #'car)
       '(a))
(equal (find-if #'(lambda (x) (eq x 'a))
                #((a) (b) (c) (a a) (b b) (c c)) :key #'car :from-end t)
       '(a a))
(equal (find-if #'(lambda (x) (eq x 'b))
                #((a) (b) (c) (a a) (b b) (c c)) :key #'car)
       '(b))
(equal (find-if #'(lambda (x) (eq x 'b))
                #((a) (b) (c) (a a) (b b) (c c)) :key #'car :from-end t)
       '(b b))
(equal (find-if #'(lambda (x) (eq x 'c))
                #((a) (b) (c) (a a) (b b) (c c)) :key #'car)
       '(c))
(equal (find-if #'(lambda (x) (eq x 'c))
                #((a) (b) (c) (a a) (b b) (c c)) :key #'car :from-end t)
       '(c c))
(null (find-if #'(lambda (x) (eq x 'z))
               #((a) (b) (c) (a a) (b b) (c c)) :key #'car))
(null (find-if #'(lambda (x) (eq x 'z))
               #((a) (b) (c) (a a) (b b) (c c)) :key #'car :from-end t))
(equal (find-if #'(lambda (x) (eq x 'a))
                #((a) (b) (c) (a a) (b b) (c c) (a a a))
                :key #'car
                :from-end t)
       '(a a a))
(equal (find-if #'(lambda (x) (eq x 'a))
                #((a) (b) (c) (a a) (b b) (c c) (a a a))
                :key #'car
                :from-end t
                :end nil)
       '(a a a))
(equal (find-if #'(lambda (x) (eq x 'a))
                #((a) (b) (c) (a a) (b b) (c c) (a a a))
                :key #'car
                :from-end t
                :end 6)
       '(a a))
(null (find-if #'(lambda (x) (eq x 'a))
               #((a) (b) (c) (a a) (b b) (c c) (a a a))
               :key #'car
               :from-end t
               :start 1
               :end 3))
(null (find-if #'(lambda (x) (eql x #\c)) #("abc" "bcd" "cde")))
(string= (find-if #'(lambda (x) (eql x #\c)) #("abc" "bcd" "cde")
                  :key #'(lambda (arg) (char arg 0)))
         "cde")
(string= (find-if #'(lambda (x) (char> #\c x)) #("abc" "bcd" "cde")
                  :key #'(lambda (arg) (char arg 0)))
         "abc")
(string= (find-if #'(lambda (x) (char> #\c x)) #("abc" "bcd" "cde")
               :start 1
               :key #'(lambda (arg) (char arg 0)))
         "bcd")


(eq (find-if-not #'(lambda (x) (not (eq x 'a))) '(a b c)) 'a)
(eq (find-if-not #'(lambda (x) (not (eq x 'b))) '(a b c)) 'b)
(eq (find-if-not #'(lambda (x) (not (eq x 'c))) '(a b c)) 'c)
(null (find-if-not #'(lambda (arg) (not (eq arg 'x))) '(a b c)))
(null (find-if-not #'(lambda (x) (not (eq x 'a))) '(a b c) :start 1))
(null (find-if-not #'(lambda (x) (not (eq x 'b))) '(a b c) :start 2))
(null (find-if-not #'(lambda (x) (not (eq x 'c))) '(a b c) :start 3))
(null (find-if-not #'(lambda (x) (not (eq x 'a))) '(a b c) :start 0 :end 0))
(null (find-if-not #'(lambda (x) (not (eq x 'a))) '(a b c)
                   :start 0 :end 0 :from-end t))
(null (find-if-not #'(lambda (x) (not (eq x 'a))) '(a b c) :start 1 :end 1))
(null (find-if-not #'(lambda (x) (not (eq x 'a))) '(a b c)
                   :start 1 :end 1 :from-end t))
(null (find-if-not #'(lambda (x) (not (eq x 'a))) '(a b c) :start 2 :end 2))
(null (find-if-not #'(lambda (x) (not (eq x 'a))) '(a b c)
                   :start 2 :end 2 :from-end t))
(null (find-if-not #'(lambda (x) (not (eq x 'a))) '(a b c) :start 3 :end 3))
(null (find-if-not #'(lambda (x) (not (eq x 'a))) '(a b c)
                   :start 3 :end 3 :from-end t))
(eq (find-if-not #'(lambda (x) (not (eq x 'a))) '(a b c) :end nil) 'a)
(eq (find-if-not #'(lambda (x) (not (eq x 'b))) '(a b c) :end nil) 'b)
(eq (find-if-not #'(lambda (x) (not (eq x 'c))) '(a b c) :end nil) 'c)
(eq (find-if-not #'(lambda (x) (not (eq x 'a))) '(a b c) :end 1) 'a)
(eq (find-if-not #'(lambda (x) (not (eq x 'b))) '(a b c) :end 2) 'b)
(eq (find-if-not #'(lambda (x) (not (eq x 'c))) '(a b c) :end 3) 'c)
(null (find-if-not #'(lambda (x) (not (eq x 'a))) '(a b c) :end 0))
(null (find-if-not #'(lambda (x) (not (eq x 'b))) '(a b c) :end 1))
(null (find-if-not #'(lambda (x) (not (eq x 'c))) '(a b c) :end 2))
(null (find-if-not #'(lambda (x) (not (eq x 'a))) '((a) (b) (c))))
(equal (find-if-not #'(lambda (x) (not (eq x 'a))) '((a) (b) (c)) :key #'car)
       '(a))
(equal (find-if-not #'(lambda (x) (not (eq x 'b))) '((a) (b) (c)) :key #'car)
       '(b))
(equal (find-if-not #'(lambda (x) (not (eq x 'c))) '((a) (b) (c)) :key #'car)
       '(c))
(null (find-if-not #'(lambda (x) (not (eq x 'z))) '((a) (b) (c)) :key #'car))
(let ((list '((a) (b) (c))))
  (and (eq (find-if-not #'(lambda (x) (not (eq x 'a))) list :key #'car)
           (car list))
       (eq (find-if-not #'(lambda (x) (not (eq x 'b))) list :key #'car)
           (cadr list))
       (eq (find-if-not #'(lambda (x) (not (eq x 'c))) list :key #'car)
           (caddr list))
       (null (find-if-not #'(lambda (x) (not (eq x 'z))) list :key #'car))))
(equal (find-if-not #'(lambda (x) (not (eq x 'a)))
                    '((a) (b) (c) (a a) (b b) (c c)) :key #'car)
       '(a))
(equal (find-if-not #'(lambda (x) (not (eq x 'a)))
                    '((a) (b) (c) (a a) (b b) (c c)) :key #'car :from-end t)
       '(a a))
(equal (find-if-not #'(lambda (x) (not (eq x 'b)))
                    '((a) (b) (c) (a a) (b b) (c c)) :key #'car)
       '(b))
(equal (find-if-not #'(lambda (x) (not (eq x 'b)))
                    '((a) (b) (c) (a a) (b b) (c c)) :key #'car :from-end t)
       '(b b))
(equal (find-if-not #'(lambda (x) (not (eq x 'c)))
                    '((a) (b) (c) (a a) (b b) (c c)) :key #'car)
       '(c))
(equal (find-if-not #'(lambda (x) (not (eq x 'c)))
                    '((a) (b) (c) (a a) (b b) (c c)) :key #'car :from-end t)
       '(c c))
(null (find-if-not #'(lambda (x) (not (eq x 'z)))
                   '((a) (b) (c) (a a) (b b) (c c)) :key #'car))
(null (find-if-not #'(lambda (x) (not (eq x 'z)))
                   '((a) (b) (c) (a a) (b b) (c c)) :key #'car :from-end t))
(equal (find-if-not #'(lambda (x) (not (eq x 'a)))
                    '((a) (b) (c) (a a) (b b) (c c) (a a a))
                    :key #'car
                    :from-end t)
       '(a a a))
(equal (find-if-not #'(lambda (x) (not (eq x 'a)))
                    '((a) (b) (c) (a a) (b b) (c c) (a a a))
                    :key #'car
                    :from-end t
                    :end nil)
       '(a a a))
(equal (find-if-not #'(lambda (x) (not (eq x 'a)))
                    '((a) (b) (c) (a a) (b b) (c c) (a a a))
                    :key #'car
                    :from-end t
                    :end 6)
       '(a a))
(null (find-if-not #'(lambda (x) (not (eq x 'a)))
                   '((a) (b) (c) (a a) (b b) (c c) (a a a))
                   :key #'car
                   :from-end t
                   :start 1
                   :end 3))
(null (find-if-not #'(lambda (x) (not (eql x #\c))) '("abc" "bcd" "cde")))
(string= (find-if-not #'(lambda (x) (not (eql x #\c))) '("abc" "bcd" "cde")
                      :key #'(lambda (arg) (char arg 0)))
         "cde")
(string= (find-if-not #'(lambda (x) (not (char> #\c x))) '("abc" "bcd" "cde")
                      :key #'(lambda (arg) (char arg 0)))
         "abc")
(string= (find-if-not #'(lambda (x) (not (char> #\c x))) '("abc" "bcd" "cde")
                      :start 1
                      :key #'(lambda (arg) (char arg 0)))
         "bcd")

(eq (find-if-not #'(lambda (x) (not (eq x 'a))) #(a b c)) 'a)
(eq (find-if-not #'(lambda (x) (not (eq x 'b))) #(a b c)) 'b)
(eq (find-if-not #'(lambda (x) (not (eq x 'c))) #(a b c)) 'c)
(null (find-if-not #'(lambda (arg) (not (eq arg 'x))) #(a b c)))
(null (find-if-not #'(lambda (x) (not (eq x 'a))) #(a b c) :start 1))
(null (find-if-not #'(lambda (x) (not (eq x 'b))) #(a b c) :start 2))
(null (find-if-not #'(lambda (x) (not (eq x 'c))) #(a b c) :start 3))
(null (find-if-not #'(lambda (x) (not (eq x 'a))) #(a b c) :start 0 :end 0))
(null (find-if-not #'(lambda (x) (not (eq x 'a))) #(a b c) :start 0 :end 0
                   :from-end t))
(null (find-if-not #'(lambda (x) (not (eq x 'a))) #(a b c) :start 1 :end 1))
(null (find-if-not #'(lambda (x) (not (eq x 'a))) #(a b c) :start 1 :end 1
                   :from-end t))
(null (find-if-not #'(lambda (x) (not (eq x 'a))) #(a b c) :start 2 :end 2))
(null (find-if-not #'(lambda (x) (not (eq x 'a))) #(a b c) :start 2 :end 2
                   :from-end t))
(null (find-if-not #'(lambda (x) (not (eq x 'a))) #(a b c) :start 3 :end 3))
(null (find-if-not #'(lambda (x) (not (eq x 'a))) #(a b c) :start 3 :end 3
                   :from-end t))
(eq (find-if-not #'(lambda (x) (not (eq x 'a))) #(a b c) :end nil) 'a)
(eq (find-if-not #'(lambda (x) (not (eq x 'b))) #(a b c) :end nil) 'b)
(eq (find-if-not #'(lambda (x) (not (eq x 'c))) #(a b c) :end nil) 'c)
(eq (find-if-not #'(lambda (x) (not (eq x 'a))) #(a b c) :end 1) 'a)
(eq (find-if-not #'(lambda (x) (not (eq x 'b))) #(a b c) :end 2) 'b)
(eq (find-if-not #'(lambda (x) (not (eq x 'c))) #(a b c) :end 3) 'c)
(null (find-if-not #'(lambda (x) (not (eq x 'a))) #(a b c) :end 0))
(null (find-if-not #'(lambda (x) (not (eq x 'b))) #(a b c) :end 1))
(null (find-if-not #'(lambda (x) (not (eq x 'c))) #(a b c) :end 2))
(null (find-if-not #'(lambda (x) (not (eq x 'a))) #((a) (b) (c))))
(equal (find-if-not #'(lambda (x) (not (eq x 'a))) #((a) (b) (c)) :key #'car)
       '(a))
(equal (find-if-not #'(lambda (x) (not (eq x 'b))) #((a) (b) (c)) :key #'car)
       '(b))
(equal (find-if-not #'(lambda (x) (not (eq x 'c))) #((a) (b) (c)) :key #'car)
       '(c))
(null (find-if-not #'(lambda (x) (not (eq x 'z))) #((a) (b) (c)) :key #'car))
(let ((vector #((a) (b) (c))))
  (and (eq (find-if-not #'(lambda (x) (not (eq x 'a))) vector :key #'car)
           (aref vector 0))
       (eq (find-if-not #'(lambda (x) (not (eq x 'b))) vector :key #'car)
           (aref vector 1))
       (eq (find-if-not #'(lambda (x) (not (eq x 'c))) vector :key #'car)
           (aref vector 2))
       (null (find-if-not #'(lambda (x) (not (eq x 'z))) vector :key #'car))))
(equal (find-if-not #'(lambda (x) (not (eq x 'a)))
                    #((a) (b) (c) (a a) (b b) (c c)) :key #'car)
       '(a))
(equal (find-if-not #'(lambda (x) (not (eq x 'a)))
                    #((a) (b) (c) (a a) (b b) (c c)) :key #'car :from-end t)
       '(a a))
(equal (find-if-not #'(lambda (x) (not (eq x 'b)))
                    #((a) (b) (c) (a a) (b b) (c c)) :key #'car)
       '(b))
(equal (find-if-not #'(lambda (x) (not (eq x 'b)))
                    #((a) (b) (c) (a a) (b b) (c c)) :key #'car :from-end t)
       '(b b))
(equal (find-if-not #'(lambda (x) (not (eq x 'c)))
                    #((a) (b) (c) (a a) (b b) (c c)) :key #'car)
       '(c))
(equal (find-if-not #'(lambda (x) (not (eq x 'c)))
                    #((a) (b) (c) (a a) (b b) (c c)) :key #'car :from-end t)
       '(c c))
(null (find-if-not #'(lambda (x) (not (eq x 'z)))
                   #((a) (b) (c) (a a) (b b) (c c)) :key #'car))
(null (find-if-not #'(lambda (x) (not (eq x 'z)))
                   #((a) (b) (c) (a a) (b b) (c c)) :key #'car :from-end t))
(equal (find-if-not #'(lambda (x) (not (eq x 'a)))
                    #((a) (b) (c) (a a) (b b) (c c) (a a a))
                    :key #'car
                    :from-end t)
       '(a a a))
(equal (find-if-not #'(lambda (x) (not (eq x 'a)))
                    #((a) (b) (c) (a a) (b b) (c c) (a a a))
                    :key #'car
                    :from-end t
                    :end nil)
       '(a a a))
(equal (find-if-not #'(lambda (x) (not (eq x 'a)))
                    #((a) (b) (c) (a a) (b b) (c c) (a a a))
                    :key #'car
                    :from-end t
                    :end 6)
       '(a a))
(null (find-if-not #'(lambda (x) (not (eq x 'a)))
                   #((a) (b) (c) (a a) (b b) (c c) (a a a))
                   :key #'car
                   :from-end t
                   :start 1
                   :end 3))
(string= (find-if-not #'(lambda (x) (not (eql x #\c))) #("abc" "bcd" "cde")
                      :key #'(lambda (arg) (char arg 0)))
         "cde")
(string= (find-if-not #'(lambda (x) (not (char> #\c x))) #("abc" "bcd" "cde")
                      :key #'(lambda (arg) (char arg 0)))
         "abc")
(string= (find-if-not #'(lambda (x) (not (char> #\c x))) #("abc" "bcd" "cde")
                      :start 1
                      :key #'(lambda (arg) (char arg 0)))
         "bcd")




(eql (position #\a "baobab" :from-end t) 4)
(eql (position-if #'oddp '((1) (2) (3) (4)) :start 1 :key #'car) 2)
(null (position 595 '()))
(eql (position-if-not #'integerp '(1 2 3 4 5.0)) 4)

(eql (position 'a '(a b c)) 0)
(eql (position 'b '(a b c)) 1)
(eql (position 'c '(a b c)) 2)
(null (position 'x '(a b c)))
(null (position 'a '(a b c) :start 1))
(null (position 'b '(a b c) :start 2))
(null (position 'c '(a b c) :start 3))
(null (position 'a '(a b c) :start 0 :end 0))
(null (position 'a '(a b c) :start 0 :end 0 :from-end t))
(null (position 'a '(a b c) :start 1 :end 1))
(null (position 'a '(a b c) :start 1 :end 1 :from-end t))
(null (position 'a '(a b c) :start 2 :end 2))
(null (position 'a '(a b c) :start 2 :end 2 :from-end t))
(null (position 'a '(a b c) :start 3 :end 3))
(null (position 'a '(a b c) :start 3 :end 3 :from-end t))
(eql (position 'a '(a b c) :end nil) '0)
(eql (position 'b '(a b c) :end nil) '1)
(eql (position 'c '(a b c) :end nil) '2)
(eql (position 'a '(a b c) :end 1) '0)
(eql (position 'b '(a b c) :end 2) '1)
(eql (position 'c '(a b c) :end 3) '2)
(null (position 'a '(a b c) :end 0))
(null (position 'b '(a b c) :end 1))
(null (position 'c '(a b c) :end 2))
(null (position 'a '((a) (b) (c))))
(eql (position 'a '((a) (b) (c)) :key #'car) 0)
(eql (position 'b '((a) (b) (c)) :key #'car) 1)
(eql (position 'c '((a) (b) (c)) :key #'car) 2)
(null (position 'z '((a) (b) (c)) :key #'car))
(null (position '(a) '((a) (b) (c))))
(eql (position '(a) '((a) (b) (c)) :test #'equal) 0)
(null (position '("a") '(("a") ("b") ("c"))))
(null (position '("a") '(("A") ("B") ("c")) :test #'equal))
(eql (position '("a") '(("A") ("B") ("c")) :test #'equalp) 0)
(eql (position 'nil '(first second third) :test (constantly t)) 0)
(eql (position 3 '(0 1 2 3 4 5)) 3)
(eql (position 3 '(0 1 2 3 4 5) :test #'<) 4)
(eql (position 3 '(0 1 2 3 4 5) :test #'>) 0)
(eql (position '(a) '((a) (b) (c)) :test-not (complement #'equal)) 0)
(null (position '("a") '(("A") ("B") ("c")) :test-not (complement #'equal)))
(eql (position '("a") '(("A") ("B") ("c")) :test-not (complement #'equalp))
     0)
(eql (position 'nil '(first second third) :test-not (constantly nil)) 0)
(eql (position 3 '(0 1 2 3 4 5) :test-not #'>=) 4)
(eql (position 3 '(0 1 2 3 4 5) :test-not #'<=) 0)
(eql (position 'a '((a) (b) (c) (a a) (b b) (c c)) :key #'car) 0)
(eql (position 'a '((a) (b) (c) (a a) (b b) (c c)) :key #'car :from-end t) 3)
(eql (position 'b '((a) (b) (c) (a a) (b b) (c c)) :key #'car) 1)
(eql (position 'b '((a) (b) (c) (a a) (b b) (c c)) :key #'car :from-end t) 4)
(eql (position 'c '((a) (b) (c) (a a) (b b) (c c)) :key #'car) 2)
(eql (position 'c '((a) (b) (c) (a a) (b b) (c c)) :key #'car :from-end t) 5)
(null (position 'z '((a) (b) (c) (a a) (b b) (c c)) :key #'car))
(null (position 'z '((a) (b) (c) (a a) (b b) (c c)) :key #'car :from-end t))
(eql (position 'a '((a) (b) (c) (a a) (b b) (c c) (a a a))
               :key #'car
               :from-end t)
     6)
(eql (position 'a '((a) (b) (c) (a a) (b b) (c c) (a a a))
               :key #'car
               :from-end t
               :end nil)
     6)
(eql (position 'a '((a) (b) (c) (a a) (b b) (c c) (a a a))
               :key #'car
               :from-end t
               :end 6)
     3)
(null (position 'a '((a) (b) (c) (a a) (b b) (c c) (a a a))
                :key #'car
                :from-end t
                :start 1
                :end 3))
(null (position #\c '("abc" "bcd" "cde")))
(eql (position #\c '("abc" "bcd" "cde")
               :key #'(lambda (arg) (char arg 0))
               :test #'char=)
     2)
(eql (position #\c '("abc" "bcd" "cde")
               :key #'(lambda (arg) (char arg 0))
               :test #'char>)
     0)
(eql (position #\c '("abc" "bcd" "cde")
               :start 1
               :key #'(lambda (arg) (char arg 0))
               :test #'char>)
     1)
(eql (position 'a #(a b c)) 0)
(eql (position 'b #(a b c)) 1)
(eql (position 'c #(a b c)) 2)
(null (position 'x #(a b c)))
(null (position 'a #(a b c) :start 1))
(null (position 'b #(a b c) :start 2))
(null (position 'c #(a b c) :start 3))
(null (position 'a #(a b c) :start 0 :end 0))
(null (position 'a #(a b c) :start 0 :end 0 :from-end t))
(null (position 'a #(a b c) :start 1 :end 1))
(null (position 'a #(a b c) :start 1 :end 1 :from-end t))
(null (position 'a #(a b c) :start 2 :end 2))
(null (position 'a #(a b c) :start 2 :end 2 :from-end t))
(null (position 'a #(a b c) :start 3 :end 3))
(null (position 'a #(a b c) :start 3 :end 3 :from-end t))
(eql (position 'a #(a b c) :end nil) 0)
(eql (position 'b #(a b c) :end nil) 1)
(eql (position 'c #(a b c) :end nil) 2)
(eql (position 'a #(a b c) :end 1) 0)
(eql (position 'b #(a b c) :end 2) 1)
(eql (position 'c #(a b c) :end 3) 2)
(null (position 'a #(a b c) :end 0))
(null (position 'b #(a b c) :end 1))
(null (position 'c #(a b c) :end 2))
(null (position 'a #((a) (b) (c))))
(eql (position 'a #((a) (b) (c)) :key #'car) 0)
(eql (position 'b #((a) (b) (c)) :key #'car) 1)
(eql (position 'c #((a) (b) (c)) :key #'car) 2)
(null (position 'z #((a) (b) (c)) :key #'car))
(null (position '(a) #((a) (b) (c))))
(eql (position '(a) #((a) (b) (c)) :test #'equal) 0)
(null (position '("a") #(("a") ("b") ("c"))))
(null (position '("a") #(("A") ("B") ("c")) :test #'equal))
(eql (position '("a") #(("A") ("B") ("c")) :test #'equalp) 0)
(eql (position 'nil #(first second third) :test (constantly t)) 0)
(eql (position 'nil #(first second third) :test (constantly t) :from-end t) 2)
(eql (position 3 #(0 1 2 3 4 5)) 3)
(eql (position 3 #(0 1 2 3 4 5) :test #'<) 4)
(eql (position 3 #(0 1 2 3 4 5) :test #'>) 0)
(eql (position '(a) #((a) (b) (c)) :test-not (complement #'equal)) 0)
(null (position '("a") #(("A") ("B") ("c")) :test-not (complement #'equal)))
(eql (position '("a") #(("A") ("B") ("c")) :test-not (complement #'equalp))
     0)
(eql (position 'nil #(first second third) :test-not (constantly nil)) 0)
(eql (position 3 #(0 1 2 3 4 5) :test-not #'>=) 4)
(eql (position 3 #(0 1 2 3 4 5) :test-not #'<=) 0)
(eql (position 'a #((a) (b) (c) (a a) (b b) (c c)) :key #'car) 0)
(eql (position 'a #((a) (b) (c) (a a) (b b) (c c)) :key #'car :from-end t) 3)
(eql (position 'b #((a) (b) (c) (a a) (b b) (c c)) :key #'car) 1)
(eql (position 'b #((a) (b) (c) (a a) (b b) (c c)) :key #'car :from-end t) 4)
(eql (position 'c #((a) (b) (c) (a a) (b b) (c c)) :key #'car) 2)
(eql (position 'c #((a) (b) (c) (a a) (b b) (c c)) :key #'car :from-end t) 5)
(null (position 'z #((a) (b) (c) (a a) (b b) (c c)) :key #'car))
(null (position 'z #((a) (b) (c) (a a) (b b) (c c)) :key #'car :from-end t))
(eql (position 'a #((a) (b) (c) (a a) (b b) (c c) (a a a))
               :key #'car
               :from-end t)
     6)
(eql (position 'a #((a) (b) (c) (a a) (b b) (c c) (a a a))
               :key #'car
               :from-end t
               :end nil)
     6)
(eql (position 'a #((a) (b) (c) (a a) (b b) (c c) (a a a))
               :key #'car
               :from-end t
               :end 6)
     3)
(null (position 'a #((a) (b) (c) (a a) (b b) (c c) (a a a))
                :key #'car
                :from-end t
                :start 1
                :end 3))
(null (position #\c #("abc" "bcd" "cde")))
(eql (position #\c #("abc" "bcd" "cde")
               :key #'(lambda (arg) (char arg 0))
               :test #'char=)
     2)
(eql (position #\c #("abc" "bcd" "cde")
               :key #'(lambda (arg) (char arg 0))
               :test #'char>)
     0)
(eql (position #\c #("abc" "bcd" "cde")
               :start 1
               :key #'(lambda (arg) (char arg 0))
               :test #'char>)
     1)
(null (position #\z "abcABC"))
(eql (position #\a "abcABC") 0)
(eql (position #\A "abcABC") 3)
(eql (position #\A "abcABC" :test #'char-equal) 0)
(eql (position #\A "abcABC" :test #'char-equal :from-end t) 3)
(eql (position #\a "abcABC" :test #'char-equal :from-end t) 3)
(eql (position #\a "abcABC" :test #'char-equal :from-end t :end 4) 3)
(eql (position #\a "abcABC" :test #'char-equal :from-end t :end 3) 0)
(zerop (position 0 #*01))
(eql (position 1 #*01) 1)
(null (position 0 #*01 :start 1))
(null (position 1 #*01 :end 0))
(null (position 0 #*000001 :start 5))


(eql (position-if #'(lambda (x) (eq x 'a)) '(a b c)) 0)
(eql (position-if #'(lambda (x) (eq x 'b)) '(a b c)) 1)
(eql (position-if #'(lambda (x) (eq x 'c)) '(a b c)) 2)
(null (position-if #'(lambda (arg) (eq arg 'x)) '(a b c)))
(null (position-if #'(lambda (x) (eq x 'a)) '(a b c) :start 1))
(null (position-if #'(lambda (x) (eq x 'b)) '(a b c) :start 2))
(null (position-if #'(lambda (x) (eq x 'c)) '(a b c) :start 3))
(null (position-if #'(lambda (x) (eq x 'a)) '(a b c) :start 0 :end 0))
(null (position-if #'(lambda (x) (eq x 'a)) '(a b c) :start 0 :end 0
                   :from-end t))
(null (position-if #'(lambda (x) (eq x 'a)) '(a b c) :start 1 :end 1))
(null (position-if #'(lambda (x) (eq x 'a)) '(a b c) :start 1 :end 1
                   :from-end t))
(null (position-if #'(lambda (x) (eq x 'a)) '(a b c) :start 2 :end 2))
(null (position-if #'(lambda (x) (eq x 'a)) '(a b c) :start 2 :end 2
                   :from-end t))
(null (position-if #'(lambda (x) (eq x 'a)) '(a b c) :start 3 :end 3))
(null (position-if #'(lambda (x) (eq x 'a)) '(a b c) :start 3 :end 3
                   :from-end t))
(eql (position-if #'(lambda (x) (eq x 'a)) '(a b c) :end nil) 0)
(eql (position-if #'(lambda (x) (eq x 'b)) '(a b c) :end nil) 1)
(eql (position-if #'(lambda (x) (eq x 'c)) '(a b c) :end nil) 2)
(eql (position-if #'(lambda (x) (eq x 'a)) '(a b c) :end 1) 0)
(eql (position-if #'(lambda (x) (eq x 'b)) '(a b c) :end 2) 1)
(eql (position-if #'(lambda (x) (eq x 'c)) '(a b c) :end 3) 2)
(null (position-if #'(lambda (x) (eq x 'a)) '(a b c) :end 0))
(null (position-if #'(lambda (x) (eq x 'b)) '(a b c) :end 1))
(null (position-if #'(lambda (x) (eq x 'c)) '(a b c) :end 2))
(null (position-if #'(lambda (x) (eq x 'a)) '((a) (b) (c))))
(eql (position-if #'(lambda (x) (eq x 'a)) '((a) (b) (c)) :key #'car) 0)
(eql (position-if #'(lambda (x) (eq x 'b)) '((a) (b) (c)) :key #'car) 1)
(eql (position-if #'(lambda (x) (eq x 'c)) '((a) (b) (c)) :key #'car) 2)
(null (position-if #'(lambda (x) (eq x 'z)) '((a) (b) (c)) :key #'car))
(eql (position-if #'(lambda (x) (eq x 'a))
                  '((a) (b) (c) (a a) (b b) (c c)) :key #'car)
     0)
(eql (position-if #'(lambda (x) (eq x 'a))
                  '((a) (b) (c) (a a) (b b) (c c)) :key #'car :from-end t)
     3)
(eql (position-if #'(lambda (x) (eq x 'b))
                  '((a) (b) (c) (a a) (b b) (c c)) :key #'car)
     1)
(eql (position-if #'(lambda (x) (eq x 'b))
                  '((a) (b) (c) (a a) (b b) (c c)) :key #'car :from-end t)
     4)
(eql (position-if #'(lambda (x) (eq x 'c))
                  '((a) (b) (c) (a a) (b b) (c c)) :key #'car)
     2)
(eql (position-if #'(lambda (x) (eq x 'c))
                  '((a) (b) (c) (a a) (b b) (c c)) :key #'car :from-end t)
     5)
(null (position-if #'(lambda (x) (eq x 'z))
                   '((a) (b) (c) (a a) (b b) (c c)) :key #'car))
(null (position-if #'(lambda (x) (eq x 'z))
                   '((a) (b) (c) (a a) (b b) (c c)) :key #'car :from-end t))
(eql (position-if #'(lambda (x) (eq x 'a))
                  '((a) (b) (c) (a a) (b b) (c c) (a a a))
                  :key #'car
                  :from-end t)
     6)
(eql (position-if #'(lambda (x) (eq x 'a))
                  '((a) (b) (c) (a a) (b b) (c c) (a a a))
                  :key #'car
                  :from-end t
                  :end nil)
     6)
(eql (position-if #'(lambda (x) (eq x 'a))
                  '((a) (b) (c) (a a) (b b) (c c) (a a a))
                  :key #'car
                  :from-end t
                  :end 6)
     3)
(null (position-if #'(lambda (x) (eq x 'a))
                   '((a) (b) (c) (a a) (b b) (c c) (a a a))
                   :key #'car
                   :from-end t
                   :start 1
                   :end 3))
(null (position-if #'(lambda (x) (eql x #\c)) '("abc" "bcd" "cde")))
(eql (position-if #'(lambda (x) (eql x #\c)) '("abc" "bcd" "cde")
                  :key #'(lambda (arg) (char arg 0)))
     2)
(eql (position-if #'(lambda (x) (char> #\c x)) '("abc" "bcd" "cde")
                  :key #'(lambda (arg) (char arg 0)))
     0)
(eql (position-if #'(lambda (x) (char> #\c x)) '("abc" "bcd" "cde")
                  :start 1
                  :key #'(lambda (arg) (char arg 0)))
     1)
(eql (position-if #'(lambda (x) (eq x 'a)) #(a b c)) 0)
(eql (position-if #'(lambda (x) (eq x 'b)) #(a b c)) 1)
(eql (position-if #'(lambda (x) (eq x 'c)) #(a b c)) 2)
(null (position-if #'(lambda (arg) (eq arg 'x)) #(a b c)))
(null (position-if #'(lambda (x) (eq x 'a)) #(a b c) :start 1))
(null (position-if #'(lambda (x) (eq x 'b)) #(a b c) :start 2))
(null (position-if #'(lambda (x) (eq x 'c)) #(a b c) :start 3))
(null (position-if #'(lambda (x) (eq x 'a)) #(a b c) :start 0 :end 0))
(null (position-if #'(lambda (x) (eq x 'a)) #(a b c) :start 0 :end 0
                   :from-end t))
(null (position-if #'(lambda (x) (eq x 'a)) #(a b c) :start 1 :end 1))
(null (position-if #'(lambda (x) (eq x 'a)) #(a b c) :start 1 :end 1
                   :from-end t))
(null (position-if #'(lambda (x) (eq x 'a)) #(a b c) :start 2 :end 2))
(null (position-if #'(lambda (x) (eq x 'a)) #(a b c) :start 2 :end 2
                   :from-end t))
(null (position-if #'(lambda (x) (eq x 'a)) #(a b c) :start 3 :end 3))
(null (position-if #'(lambda (x) (eq x 'a)) #(a b c) :start 3 :end 3
                   :from-end t))
(eql (position-if #'(lambda (x) (eq x 'a)) #(a b c) :end nil) 0)
(eql (position-if #'(lambda (x) (eq x 'b)) #(a b c) :end nil) 1)
(eql (position-if #'(lambda (x) (eq x 'c)) #(a b c) :end nil) 2)
(eql (position-if #'(lambda (x) (eq x 'a)) #(a b c) :end 1) 0)
(eql (position-if #'(lambda (x) (eq x 'b)) #(a b c) :end 2) 1)
(eql (position-if #'(lambda (x) (eq x 'c)) #(a b c) :end 3) 2)
(null (position-if #'(lambda (x) (eq x 'a)) #(a b c) :end 0))
(null (position-if #'(lambda (x) (eq x 'b)) #(a b c) :end 1))
(null (position-if #'(lambda (x) (eq x 'c)) #(a b c) :end 2))
(null (position-if #'(lambda (x) (eq x 'a)) #((a) (b) (c))))
(eql (position-if #'(lambda (x) (eq x 'a)) #((a) (b) (c)) :key #'car) 0)
(eql (position-if #'(lambda (x) (eq x 'b)) #((a) (b) (c)) :key #'car) 1)
(eql (position-if #'(lambda (x) (eq x 'c)) #((a) (b) (c)) :key #'car) 2)
(null (position-if #'(lambda (x) (eq x 'z)) #((a) (b) (c)) :key #'car))
(eql (position-if #'(lambda (x) (eq x 'a))
                  #((a) (b) (c) (a a) (b b) (c c)) :key #'car)
     0)
(eql (position-if #'(lambda (x) (eq x 'a))
                  #((a) (b) (c) (a a) (b b) (c c)) :key #'car :from-end t)
     3)
(eql (position-if #'(lambda (x) (eq x 'b))
                  #((a) (b) (c) (a a) (b b) (c c)) :key #'car)
     1)
(eql (position-if #'(lambda (x) (eq x 'b))
                  #((a) (b) (c) (a a) (b b) (c c)) :key #'car :from-end t)
     4)
(eql (position-if #'(lambda (x) (eq x 'c))
                  #((a) (b) (c) (a a) (b b) (c c)) :key #'car)
     2)
(eql (position-if #'(lambda (x) (eq x 'c))
                  #((a) (b) (c) (a a) (b b) (c c)) :key #'car :from-end t)
     5)
(null (position-if #'(lambda (x) (eq x 'z))
                   #((a) (b) (c) (a a) (b b) (c c)) :key #'car))
(null (position-if #'(lambda (x) (eq x 'z))
                   #((a) (b) (c) (a a) (b b) (c c)) :key #'car :from-end t))
(eql (position-if #'(lambda (x) (eq x 'a))
                  #((a) (b) (c) (a a) (b b) (c c) (a a a))
                  :key #'car
                  :from-end t)
     6)
(eql (position-if #'(lambda (x) (eq x 'a))
                  #((a) (b) (c) (a a) (b b) (c c) (a a a))
                  :key #'car
                  :from-end t
                  :end nil)
     6)
(eql (position-if #'(lambda (x) (eq x 'a))
                  #((a) (b) (c) (a a) (b b) (c c) (a a a))
                  :key #'car
                  :from-end t
                  :end 6)
     3)
(null (position-if #'(lambda (x) (eq x 'a))
                   #((a) (b) (c) (a a) (b b) (c c) (a a a))
                   :key #'car
                   :from-end t
                   :start 1
                   :end 3))
(null (position-if #'(lambda (x) (eql x #\c)) #("abc" "bcd" "cde")))
(eql (position-if #'(lambda (x) (eql x #\c)) #("abc" "bcd" "cde")
                  :key #'(lambda (arg) (char arg 0)))
     2)
(eql (position-if #'(lambda (x) (char> #\c x)) #("abc" "bcd" "cde")
                  :key #'(lambda (arg) (char arg 0)))
     0)
(eql (position-if #'(lambda (x) (char> #\c x)) #("abc" "bcd" "cde")
                  :start 1
                  :key #'(lambda (arg) (char arg 0)))
     1)


(eql (position-if-not #'(lambda (x) (not (eq x 'a))) '(a b c)) 0)
(eql (position-if-not #'(lambda (x) (not (eq x 'b))) '(a b c)) 1)
(eql (position-if-not #'(lambda (x) (not (eq x 'c))) '(a b c)) 2)
(null (position-if-not #'(lambda (arg) (not (eq arg 'x))) '(a b c)))
(null (position-if-not #'(lambda (x) (not (eq x 'a))) '(a b c) :start 1))
(null (position-if-not #'(lambda (x) (not (eq x 'b))) '(a b c) :start 2))
(null (position-if-not #'(lambda (x) (not (eq x 'c))) '(a b c) :start 3))
(null (position-if-not #'(lambda (x) (not (eq x 'a))) '(a b c) :start 0 :end 0))
(null (position-if-not #'(lambda (x) (not (eq x 'a))) '(a b c)
                   :start 0 :end 0 :from-end t))
(null (position-if-not #'(lambda (x) (not (eq x 'a))) '(a b c) :start 1 :end 1))
(null (position-if-not #'(lambda (x) (not (eq x 'a))) '(a b c)
                   :start 1 :end 1 :from-end t))
(null (position-if-not #'(lambda (x) (not (eq x 'a))) '(a b c) :start 2 :end 2))
(null (position-if-not #'(lambda (x) (not (eq x 'a))) '(a b c)
                   :start 2 :end 2 :from-end t))
(null (position-if-not #'(lambda (x) (not (eq x 'a))) '(a b c) :start 3 :end 3))
(null (position-if-not #'(lambda (x) (not (eq x 'a))) '(a b c)
                   :start 3 :end 3 :from-end t))
(eql (position-if-not #'(lambda (x) (not (eq x 'a))) '(a b c) :end nil) 0)
(eql (position-if-not #'(lambda (x) (not (eq x 'b))) '(a b c) :end nil) 1)
(eql (position-if-not #'(lambda (x) (not (eq x 'c))) '(a b c) :end nil) 2)
(eql (position-if-not #'(lambda (x) (not (eq x 'a))) '(a b c) :end 1) 0)
(eql (position-if-not #'(lambda (x) (not (eq x 'b))) '(a b c) :end 2) 1)
(eql (position-if-not #'(lambda (x) (not (eq x 'c))) '(a b c) :end 3) 2)
(null (position-if-not #'(lambda (x) (not (eq x 'a))) '(a b c) :end 0))
(null (position-if-not #'(lambda (x) (not (eq x 'b))) '(a b c) :end 1))
(null (position-if-not #'(lambda (x) (not (eq x 'c))) '(a b c) :end 2))
(null (position-if-not #'(lambda (x) (not (eq x 'a))) '((a) (b) (c))))
(eql (position-if-not #'(lambda (x) (not (eq x 'a))) '((a) (b) (c)) :key #'car)
     0)
(eql (position-if-not #'(lambda (x) (not (eq x 'b))) '((a) (b) (c)) :key #'car)
     1)
(eql (position-if-not #'(lambda (x) (not (eq x 'c))) '((a) (b) (c)) :key #'car)
     2)
(null (position-if-not #'(lambda (x) (not (eq x 'z))) '((a) (b) (c))
                       :key #'car))
(eql (position-if-not #'(lambda (x) (not (eq x 'a)))
                      '((a) (b) (c) (a a) (b b) (c c)) :key #'car)
     0)
(eql (position-if-not #'(lambda (x) (not (eq x 'a)))
                      '((a) (b) (c) (a a) (b b) (c c)) :key #'car :from-end t)
     3)
(eql (position-if-not #'(lambda (x) (not (eq x 'b)))
                      '((a) (b) (c) (a a) (b b) (c c)) :key #'car)
     1)
(eql (position-if-not #'(lambda (x) (not (eq x 'b)))
                      '((a) (b) (c) (a a) (b b) (c c)) :key #'car :from-end t)
     4)
(eql (position-if-not #'(lambda (x) (not (eq x 'c)))
                      '((a) (b) (c) (a a) (b b) (c c)) :key #'car)
     2)
(eql (position-if-not #'(lambda (x) (not (eq x 'c)))
                      '((a) (b) (c) (a a) (b b) (c c)) :key #'car :from-end t)
     5)
(null (position-if-not #'(lambda (x) (not (eq x 'z)))
                       '((a) (b) (c) (a a) (b b) (c c)) :key #'car))
(null (position-if-not #'(lambda (x) (not (eq x 'z)))
                       '((a) (b) (c) (a a) (b b) (c c)) :key #'car :from-end t))
(eql (position-if-not #'(lambda (x) (not (eq x 'a)))
                      '((a) (b) (c) (a a) (b b) (c c) (a a a))
                      :key #'car
                      :from-end t)
     6)
(eql (position-if-not #'(lambda (x) (not (eq x 'a)))
                      '((a) (b) (c) (a a) (b b) (c c) (a a a))
                      :key #'car
                      :from-end t
                      :end nil)
     6)
(eql (position-if-not #'(lambda (x) (not (eq x 'a)))
                      '((a) (b) (c) (a a) (b b) (c c) (a a a))
                      :key #'car
                      :from-end t
                      :end 6)
     3)
(null (position-if-not #'(lambda (x) (not (eq x 'a)))
                       '((a) (b) (c) (a a) (b b) (c c) (a a a))
                       :key #'car
                       :from-end t
                       :start 1
                       :end 3))
(null (position-if-not #'(lambda (x) (not (eql x #\c))) '("abc" "bcd" "cde")))
(eql (position-if-not #'(lambda (x) (not (eql x #\c))) '("abc" "bcd" "cde")
                      :key #'(lambda (arg) (char arg 0)))
     2)
(eql (position-if-not #'(lambda (x) (not (char> #\c x))) '("abc" "bcd" "cde")
                      :key #'(lambda (arg) (char arg 0)))
     0)
(eql (position-if-not #'(lambda (x) (not (char> #\c x))) '("abc" "bcd" "cde")
                      :start 1
                      :key #'(lambda (arg) (char arg 0)))
     1)

(eql (position-if-not #'(lambda (x) (not (eq x 'a))) #(a b c)) 0)
(eql (position-if-not #'(lambda (x) (not (eq x 'b))) #(a b c)) 1)
(eql (position-if-not #'(lambda (x) (not (eq x 'c))) #(a b c)) 2)
(null (position-if-not #'(lambda (arg) (not (eq arg 'x))) #(a b c)))
(null (position-if-not #'(lambda (x) (not (eq x 'a))) #(a b c) :start 1))
(null (position-if-not #'(lambda (x) (not (eq x 'b))) #(a b c) :start 2))
(null (position-if-not #'(lambda (x) (not (eq x 'c))) #(a b c) :start 3))
(null (position-if-not #'(lambda (x) (not (eq x 'a))) #(a b c) :start 0 :end 0))
(null (position-if-not #'(lambda (x) (not (eq x 'a))) #(a b c) :start 0 :end 0
                   :from-end t))
(null (position-if-not #'(lambda (x) (not (eq x 'a))) #(a b c) :start 1 :end 1))
(null (position-if-not #'(lambda (x) (not (eq x 'a))) #(a b c) :start 1 :end 1
                   :from-end t))
(null (position-if-not #'(lambda (x) (not (eq x 'a))) #(a b c) :start 2 :end 2))
(null (position-if-not #'(lambda (x) (not (eq x 'a))) #(a b c) :start 2 :end 2
                   :from-end t))
(null (position-if-not #'(lambda (x) (not (eq x 'a))) #(a b c) :start 3 :end 3))
(null (position-if-not #'(lambda (x) (not (eq x 'a))) #(a b c) :start 3 :end 3
                   :from-end t))
(eql (position-if-not #'(lambda (x) (not (eq x 'a))) #(a b c) :end nil) 0)
(eql (position-if-not #'(lambda (x) (not (eq x 'b))) #(a b c) :end nil) 1)
(eql (position-if-not #'(lambda (x) (not (eq x 'c))) #(a b c) :end nil) 2)
(eql (position-if-not #'(lambda (x) (not (eq x 'a))) #(a b c) :end 1) 0)
(eql (position-if-not #'(lambda (x) (not (eq x 'b))) #(a b c) :end 2) 1)
(eql (position-if-not #'(lambda (x) (not (eq x 'c))) #(a b c) :end 3) 2)
(null (position-if-not #'(lambda (x) (not (eq x 'a))) #(a b c) :end 0))
(null (position-if-not #'(lambda (x) (not (eq x 'b))) #(a b c) :end 1))
(null (position-if-not #'(lambda (x) (not (eq x 'c))) #(a b c) :end 2))
(null (position-if-not #'(lambda (x) (not (eq x 'a))) #((a) (b) (c))))
(eql (position-if-not #'(lambda (x) (not (eq x 'a))) #((a) (b) (c)) :key #'car)
     0)
(eql (position-if-not #'(lambda (x) (not (eq x 'b))) #((a) (b) (c)) :key #'car)
     1)
(eql (position-if-not #'(lambda (x) (not (eq x 'c))) #((a) (b) (c)) :key #'car)
     2)
(null (position-if-not #'(lambda (x) (not (eq x 'z))) #((a) (b) (c))
                       :key #'car))
(eql (position-if-not #'(lambda (x) (not (eq x 'a)))
                      #((a) (b) (c) (a a) (b b) (c c)) :key #'car)
     0)
(eql (position-if-not #'(lambda (x) (not (eq x 'a)))
                      #((a) (b) (c) (a a) (b b) (c c)) :key #'car :from-end t)
     3)
(eql (position-if-not #'(lambda (x) (not (eq x 'b)))
                      #((a) (b) (c) (a a) (b b) (c c)) :key #'car)
     1)
(eql (position-if-not #'(lambda (x) (not (eq x 'b)))
                      #((a) (b) (c) (a a) (b b) (c c)) :key #'car :from-end t)
     4)
(eql (position-if-not #'(lambda (x) (not (eq x 'c)))
                      #((a) (b) (c) (a a) (b b) (c c)) :key #'car)
     2)
(eql (position-if-not #'(lambda (x) (not (eq x 'c)))
                      #((a) (b) (c) (a a) (b b) (c c)) :key #'car :from-end t)
     5)
(null (position-if-not #'(lambda (x) (not (eq x 'z)))
                       #((a) (b) (c) (a a) (b b) (c c)) :key #'car))
(null (position-if-not #'(lambda (x) (not (eq x 'z)))
                       #((a) (b) (c) (a a) (b b) (c c)) :key #'car :from-end t))
(eql (position-if-not #'(lambda (x) (not (eq x 'a)))
                      #((a) (b) (c) (a a) (b b) (c c) (a a a))
                      :key #'car
                      :from-end t)
     6)
(eql (position-if-not #'(lambda (x) (not (eq x 'a)))
                      #((a) (b) (c) (a a) (b b) (c c) (a a a))
                      :key #'car
                      :from-end t
                      :end nil)
     6)
(eql (position-if-not #'(lambda (x) (not (eq x 'a)))
                      #((a) (b) (c) (a a) (b b) (c c) (a a a))
                      :key #'car
                      :from-end t
                      :end 6)
     3)
(null (position-if-not #'(lambda (x) (not (eq x 'a)))
                       #((a) (b) (c) (a a) (b b) (c c) (a a a))
                       :key #'car
                       :from-end t
                       :start 1
                       :end 3))
(eql (position-if-not #'(lambda (x) (not (eql x #\c))) #("abc" "bcd" "cde")
                      :key #'(lambda (arg) (char arg 0)))
     2)
(eql (position-if-not #'(lambda (x) (not (char> #\c x))) #("abc" "bcd" "cde")
                      :key #'(lambda (arg) (char arg 0)))
     0)
(eql (position-if-not #'(lambda (x) (not (char> #\c x))) #("abc" "bcd" "cde")
                      :start 1
                      :key #'(lambda (arg) (char arg 0)))
     1)



(eql (search "dog" "it's a dog's life") 7)
(eql (search '(0 1) '(2 4 6 1 3 5) :key #'oddp) 2)


(eql (search '() '()) 0)
(null (search '(a b c) '(x y z)))
(eql (search '() '(x y z)) 0)
(eql (search '(a) '(a)) 0)
(eql (search '(a b c) '(a b c x y z)) 0)
(eql (search '(a b c) '(x a b c y z)) 1)
(eql (search '(a b c) '(x y a b c z)) 2)
(eql (search '(a b c) '(x y z a b c)) 3)
(eql (search '(a b c) '(a b c a b c) :start2 1) 3)
(eql (search '(a b c) '(a b c a b c) :start2 1 :end2 nil) 3)
(eql (search '(a b c) '(a b c a b c) :start1 1 :start2 1 :end2 nil) 1)
(eql (search '(a b c) '(a b c a b c) :start1 1 :end1 nil :start2 1 :end2 nil) 1)
(null (search '(a b c) '(a b c a b c) :start2 0 :end2 0))
(null (search '(a b c) '(a b c a b c) :start2 1 :end2 1))
(null (search '(a b c) '(a b c a b c) :start2 2 :end2 2))
(null (search '(a b c) '(a b c a b c) :start2 3 :end2 3))
(null (search '(a b c) '(a b c a b c) :start2 4 :end2 4))
(null (search '(a b c) '(a b c a b c) :start2 5 :end2 5))
(null (search '(a b c) '(a b c a b c) :start2 6 :end2 6))
(eql (search '(a b c) '(a b c a b c)) 0)
(eql (search '(a b c) '(a b c a b c) :from-end t) 3)
(eql (search '(a b c) '(a b c a b c) :start2 3 :end2 6) 3)
(eql (search '(a b c) '(a b c a b c) :start2 3 :end2 6 :from-end t) 3)
(eql (search '(a b c) '(a b c a b c)
             :start1 0 :end1 2 :start2 0 :end2 6)
     0)
(eql (search '(a b c) '(a b c a b c)
             :start1 0 :end1 2 :start2 0 :end2 6 :from-end t)
     3)
(eql (search '(a b c) '(a b c a b c) :start1 0 :end1 0 :start2 0 :end2 0) 0)
(eql (search '(a b c) '(a b c a b c) :start1 1 :end1 1 :start2 0 :end2 0) 0)
(eql (search '(a b c) '(a b c a b c) :start1 2 :end1 2 :start2 0 :end2 0) 0)
(eql (search '(a b c) '(a b c a b c) :start1 3 :end1 3 :start2 0 :end2 0) 0)
(eql (search '(a b c) '(a b c a b c) :start1 0 :end1 0 :start2 1 :end2 1) 1)
(eql (search '(a b c) '(a b c a b c) :start1 1 :end1 1 :start2 1 :end2 1) 1)
(eql (search '(a b c) '(a b c a b c) :start1 2 :end1 2 :start2 1 :end2 1) 1)
(eql (search '(a b c) '(a b c a b c) :start1 3 :end1 3 :start2 1 :end2 1) 1)
(eql (search '(a b c) '(a b c a b c) :start1 0 :end1 0 :start2 6 :end2 6) 6)
(eql (search '(a b c) '(a b c a b c) :start1 1 :end1 1 :start2 6 :end2 6) 6)
(eql (search '(a b c) '(a b c a b c) :start1 2 :end1 2 :start2 6 :end2 6) 6)
(eql (search '(a b c) '(a b c a b c) :start1 3 :end1 3 :start2 6 :end2 6) 6)

(eql (search '(a b c) '(a b c a b c) :start1 0 :end1 0 :start2 0 :end2 0
             :from-end t) 0)
(eql (search '(a b c) '(a b c a b c) :start1 1 :end1 1 :start2 0 :end2 0
             :from-end t) 0)
(eql (search '(a b c) '(a b c a b c) :start1 2 :end1 2 :start2 0 :end2 0
             :from-end t) 0)
(eql (search '(a b c) '(a b c a b c) :start1 3 :end1 3 :start2 0 :end2 0
             :from-end t) 0)
(eql (search '(a b c) '(a b c a b c) :start1 0 :end1 0 :start2 1 :end2 1
             :from-end t) 1)
(eql (search '(a b c) '(a b c a b c) :start1 1 :end1 1 :start2 1 :end2 1
             :from-end t) 1)
(eql (search '(a b c) '(a b c a b c) :start1 2 :end1 2 :start2 1 :end2 1
             :from-end t) 1)
(eql (search '(a b c) '(a b c a b c) :start1 3 :end1 3 :start2 1 :end2 1
             :from-end t) 1)
(eql (search '(a b c) '(a b c a b c) :start1 0 :end1 0 :start2 6 :end2 6
             :from-end t) 6)
(eql (search '(a b c) '(a b c a b c) :start1 1 :end1 1 :start2 6 :end2 6
             :from-end t) 6)
(eql (search '(a b c) '(a b c a b c) :start1 2 :end1 2 :start2 6 :end2 6
             :from-end t) 6)
(eql (search '(a b c) '(a b c a b c) :start1 3 :end1 3 :start2 6 :end2 6
             :from-end t) 6)

(null (search '(#\a #\b #\c) '(#\A #\B #\C)))
(eql (search '(#\a #\b #\c) '(#\A #\B #\C) :test #'char-equal) 0)
(eql (search '(#\a #\b #\c) '(#\A #\B #\C) :test-not (complement #'char-equal))
             0)
(eql (search '(#\a #\b) '(#\a #\b #\x #\y #\z)) 0)
(eql (search '(#\a #\b) '(#\a #\b #\x #\y #\z) :test #'char<) 1)
(eql (search '(#\a #\b) '(#\a #\b #\x #\y #\z) :test-not (complement #'char<))
     1)
(eql (search '(#\a #\b) '(#\a #\b #\x #\y #\z)
             :test-not (complement #'char<)
             :from-end t)
     3)

(null (search '((a) (b)) '((x) (y) (z) (a) (b) (c))))
(eql (search '((a) (b)) '((x) (y) (z) (a) (b) (c)) :key #'car) 3)
(eql (search '((a) (b)) '((a) (b) (c) (x) (y) (z) (a) (b) (c)) :key #'car)
     0)
(eql (search '((a) (b)) '((a) (b) (c) (x) (y) (z) (a) (b) (c))
             :key #'car
             :from-end t)
     6)

(eql (search '((a a) (b b)) '((a) (b) (c) (x) (y) (z) (a) (b) (c)) :key #'car)
     0)
(eql (search '((a a) (b b))
             '((a nil) (b t) (c nil) (x) (y) (z) (a 0) (b 1) (c 2))
             :key #'car
             :from-end t)
     6)

(eql (search '(("a" a) ("b" b))
             '(("a" nil) ("b" t) ("c" nil) ("x") ("y") ("z")
               ("A" 0) ("B" 1) ("C" 2))
             :start1 1
             :end1 2
             :start2 3
             :end2 nil
             :key #'car
             :test #'string-equal
             :from-end t)
     7)


(eql (search #() '()) 0)
(null (search #(a b c) '(x y z)))
(eql (search #() '(x y z)) 0)
(eql (search #(a) '(a)) 0)
(eql (search #(a b c) '(a b c x y z)) 0)
(eql (search #(a b c) '(x a b c y z)) 1)
(eql (search #(a b c) '(x y a b c z)) 2)
(eql (search #(a b c) '(x y z a b c)) 3)
(eql (search #(a b c) '(a b c a b c) :start2 1) 3)
(eql (search #(a b c) '(a b c a b c) :start2 1 :end2 nil) 3)
(eql (search #(a b c) '(a b c a b c) :start1 1 :start2 1 :end2 nil) 1)
(eql (search #(a b c) '(a b c a b c) :start1 1 :end1 nil :start2 1 :end2 nil) 1)
(null (search #(a b c) '(a b c a b c) :start2 0 :end2 0))
(null (search #(a b c) '(a b c a b c) :start2 1 :end2 1))
(null (search #(a b c) '(a b c a b c) :start2 2 :end2 2))
(null (search #(a b c) '(a b c a b c) :start2 3 :end2 3))
(null (search #(a b c) '(a b c a b c) :start2 4 :end2 4))
(null (search #(a b c) '(a b c a b c) :start2 5 :end2 5))
(null (search #(a b c) '(a b c a b c) :start2 6 :end2 6))
(eql (search #(a b c) '(a b c a b c)) 0)
(eql (search #(a b c) '(a b c a b c) :from-end t) 3)
(eql (search #(a b c) '(a b c a b c) :start2 3 :end2 6) 3)
(eql (search #(a b c) '(a b c a b c) :start2 3 :end2 6 :from-end t) 3)
(eql (search #(a b c) '(a b c a b c)
             :start1 0 :end1 2 :start2 0 :end2 6)
     0)
(eql (search #(a b c) '(a b c a b c)
             :start1 0 :end1 2 :start2 0 :end2 6 :from-end t)
     3)
(eql (search #(a b c) '(a b c a b c) :start1 0 :end1 0 :start2 0 :end2 0) 0)
(eql (search #(a b c) '(a b c a b c) :start1 1 :end1 1 :start2 0 :end2 0) 0)
(eql (search #(a b c) '(a b c a b c) :start1 2 :end1 2 :start2 0 :end2 0) 0)
(eql (search #(a b c) '(a b c a b c) :start1 3 :end1 3 :start2 0 :end2 0) 0)
(eql (search #(a b c) '(a b c a b c) :start1 0 :end1 0 :start2 1 :end2 1) 1)
(eql (search #(a b c) '(a b c a b c) :start1 1 :end1 1 :start2 1 :end2 1) 1)
(eql (search #(a b c) '(a b c a b c) :start1 2 :end1 2 :start2 1 :end2 1) 1)
(eql (search #(a b c) '(a b c a b c) :start1 3 :end1 3 :start2 1 :end2 1) 1)
(eql (search #(a b c) '(a b c a b c) :start1 0 :end1 0 :start2 6 :end2 6) 6)
(eql (search #(a b c) '(a b c a b c) :start1 1 :end1 1 :start2 6 :end2 6) 6)
(eql (search #(a b c) '(a b c a b c) :start1 2 :end1 2 :start2 6 :end2 6) 6)
(eql (search #(a b c) '(a b c a b c) :start1 3 :end1 3 :start2 6 :end2 6) 6)

(eql (search #(a b c) '(a b c a b c) :start1 0 :end1 0 :start2 0 :end2 0
             :from-end t) 0)
(eql (search #(a b c) '(a b c a b c) :start1 1 :end1 1 :start2 0 :end2 0
             :from-end t) 0)
(eql (search #(a b c) '(a b c a b c) :start1 2 :end1 2 :start2 0 :end2 0
             :from-end t) 0)
(eql (search #(a b c) '(a b c a b c) :start1 3 :end1 3 :start2 0 :end2 0
             :from-end t) 0)
(eql (search #(a b c) '(a b c a b c) :start1 0 :end1 0 :start2 1 :end2 1
             :from-end t) 1)
(eql (search #(a b c) '(a b c a b c) :start1 1 :end1 1 :start2 1 :end2 1
             :from-end t) 1)
(eql (search #(a b c) '(a b c a b c) :start1 2 :end1 2 :start2 1 :end2 1
             :from-end t) 1)
(eql (search #(a b c) '(a b c a b c) :start1 3 :end1 3 :start2 1 :end2 1
             :from-end t) 1)
(eql (search #(a b c) '(a b c a b c) :start1 0 :end1 0 :start2 6 :end2 6
             :from-end t) 6)
(eql (search #(a b c) '(a b c a b c) :start1 1 :end1 1 :start2 6 :end2 6
             :from-end t) 6)
(eql (search #(a b c) '(a b c a b c) :start1 2 :end1 2 :start2 6 :end2 6
             :from-end t) 6)
(eql (search #(a b c) '(a b c a b c) :start1 3 :end1 3 :start2 6 :end2 6
             :from-end t) 6)

(null (search #(#\a #\b #\c) '(#\A #\B #\C)))
(eql (search #(#\a #\b #\c) '(#\A #\B #\C) :test #'char-equal) 0)
(eql (search #(#\a #\b #\c) '(#\A #\B #\C) :test-not (complement #'char-equal))
             0)
(eql (search #(#\a #\b) '(#\a #\b #\x #\y #\z)) 0)
(eql (search #(#\a #\b) '(#\a #\b #\x #\y #\z) :test #'char<) 1)
(eql (search #(#\a #\b) '(#\a #\b #\x #\y #\z) :test-not (complement #'char<))
     1)
(eql (search #(#\a #\b) '(#\a #\b #\x #\y #\z)
             :test-not (complement #'char<)
             :from-end t)
     3)

(null (search #((a) (b)) '((x) (y) (z) (a) (b) (c))))
(eql (search #((a) (b)) '((x) (y) (z) (a) (b) (c)) :key #'car) 3)
(eql (search #((a) (b)) '((a) (b) (c) (x) (y) (z) (a) (b) (c)) :key #'car)
     0)
(eql (search #((a) (b)) '((a) (b) (c) (x) (y) (z) (a) (b) (c))
             :key #'car
             :from-end t)
     6)

(eql (search #((a a) (b b)) '((a) (b) (c) (x) (y) (z) (a) (b) (c)) :key #'car)
     0)
(eql (search #((a a) (b b))
             '((a nil) (b t) (c nil) (x) (y) (z) (a 0) (b 1) (c 2))
             :key #'car
             :from-end t)
     6)

(eql (search #(("a" a) ("b" b))
             '(("a" nil) ("b" t) ("c" nil) ("x") ("y") ("z")
               ("A" 0) ("B" 1) ("C" 2))
             :start1 1
             :end1 2
             :start2 3
             :end2 nil
             :key #'car
             :test #'string-equal
             :from-end t)
     7)


(eql (search '() #()) 0)
(null (search '(a b c) #(x y z)))
(eql (search '() #(x y z)) 0)
(eql (search '(a) #(a)) 0)
(eql (search '(a b c) #(a b c x y z)) 0)
(eql (search '(a b c) #(x a b c y z)) 1)
(eql (search '(a b c) #(x y a b c z)) 2)
(eql (search '(a b c) #(x y z a b c)) 3)
(eql (search '(a b c) #(a b c a b c) :start2 1) 3)
(eql (search '(a b c) #(a b c a b c) :start2 1 :end2 nil) 3)
(eql (search '(a b c) #(a b c a b c) :start1 1 :start2 1 :end2 nil) 1)
(eql (search '(a b c) #(a b c a b c) :start1 1 :end1 nil :start2 1 :end2 nil) 1)
(null (search '(a b c) #(a b c a b c) :start2 0 :end2 0))
(null (search '(a b c) #(a b c a b c) :start2 1 :end2 1))
(null (search '(a b c) #(a b c a b c) :start2 2 :end2 2))
(null (search '(a b c) #(a b c a b c) :start2 3 :end2 3))
(null (search '(a b c) #(a b c a b c) :start2 4 :end2 4))
(null (search '(a b c) #(a b c a b c) :start2 5 :end2 5))
(null (search '(a b c) #(a b c a b c) :start2 6 :end2 6))
(eql (search '(a b c) #(a b c a b c)) 0)
(eql (search '(a b c) #(a b c a b c) :from-end t) 3)
(eql (search '(a b c) #(a b c a b c) :start2 3 :end2 6) 3)
(eql (search '(a b c) #(a b c a b c) :start2 3 :end2 6 :from-end t) 3)
(eql (search '(a b c) #(a b c a b c)
             :start1 0 :end1 2 :start2 0 :end2 6)
     0)
(eql (search '(a b c) #(a b c a b c)
             :start1 0 :end1 2 :start2 0 :end2 6 :from-end t)
     3)
(eql (search '(a b c) #(a b c a b c) :start1 0 :end1 0 :start2 0 :end2 0) 0)
(eql (search '(a b c) #(a b c a b c) :start1 1 :end1 1 :start2 0 :end2 0) 0)
(eql (search '(a b c) #(a b c a b c) :start1 2 :end1 2 :start2 0 :end2 0) 0)
(eql (search '(a b c) #(a b c a b c) :start1 3 :end1 3 :start2 0 :end2 0) 0)
(eql (search '(a b c) #(a b c a b c) :start1 0 :end1 0 :start2 1 :end2 1) 1)
(eql (search '(a b c) #(a b c a b c) :start1 1 :end1 1 :start2 1 :end2 1) 1)
(eql (search '(a b c) #(a b c a b c) :start1 2 :end1 2 :start2 1 :end2 1) 1)
(eql (search '(a b c) #(a b c a b c) :start1 3 :end1 3 :start2 1 :end2 1) 1)
(eql (search '(a b c) #(a b c a b c) :start1 0 :end1 0 :start2 6 :end2 6) 6)
(eql (search '(a b c) #(a b c a b c) :start1 1 :end1 1 :start2 6 :end2 6) 6)
(eql (search '(a b c) #(a b c a b c) :start1 2 :end1 2 :start2 6 :end2 6) 6)
(eql (search '(a b c) #(a b c a b c) :start1 3 :end1 3 :start2 6 :end2 6) 6)

(eql (search '(a b c) #(a b c a b c) :start1 0 :end1 0 :start2 0 :end2 0
             :from-end t) 0)
(eql (search '(a b c) #(a b c a b c) :start1 1 :end1 1 :start2 0 :end2 0
             :from-end t) 0)
(eql (search '(a b c) #(a b c a b c) :start1 2 :end1 2 :start2 0 :end2 0
             :from-end t) 0)
(eql (search '(a b c) #(a b c a b c) :start1 3 :end1 3 :start2 0 :end2 0
             :from-end t) 0)
(eql (search '(a b c) #(a b c a b c) :start1 0 :end1 0 :start2 1 :end2 1
             :from-end t) 1)
(eql (search '(a b c) #(a b c a b c) :start1 1 :end1 1 :start2 1 :end2 1
             :from-end t) 1)
(eql (search '(a b c) #(a b c a b c) :start1 2 :end1 2 :start2 1 :end2 1
             :from-end t) 1)
(eql (search '(a b c) #(a b c a b c) :start1 3 :end1 3 :start2 1 :end2 1
             :from-end t) 1)
(eql (search '(a b c) #(a b c a b c) :start1 0 :end1 0 :start2 6 :end2 6
             :from-end t) 6)
(eql (search '(a b c) #(a b c a b c) :start1 1 :end1 1 :start2 6 :end2 6
             :from-end t) 6)
(eql (search '(a b c) #(a b c a b c) :start1 2 :end1 2 :start2 6 :end2 6
             :from-end t) 6)
(eql (search '(a b c) #(a b c a b c) :start1 3 :end1 3 :start2 6 :end2 6
             :from-end t) 6)

(null (search '(#\a #\b #\c) #(#\A #\B #\C)))
(eql (search '(#\a #\b #\c) #(#\A #\B #\C) :test #'char-equal) 0)
(eql (search '(#\a #\b #\c) #(#\A #\B #\C) :test-not (complement #'char-equal))
             0)
(eql (search '(#\a #\b) #(#\a #\b #\x #\y #\z)) 0)
(eql (search '(#\a #\b) #(#\a #\b #\x #\y #\z) :test #'char<) 1)
(eql (search '(#\a #\b) #(#\a #\b #\x #\y #\z) :test-not (complement #'char<))
     1)
(eql (search '(#\a #\b) #(#\a #\b #\x #\y #\z)
             :test-not (complement #'char<)
             :from-end t)
     3)

(null (search '((a) (b)) #((x) (y) (z) (a) (b) (c))))
(eql (search '((a) (b)) #((x) (y) (z) (a) (b) (c)) :key #'car) 3)
(eql (search '((a) (b)) #((a) (b) (c) (x) (y) (z) (a) (b) (c)) :key #'car)
     0)
(eql (search '((a) (b)) #((a) (b) (c) (x) (y) (z) (a) (b) (c))
             :key #'car
             :from-end t)
     6)

(eql (search '((a a) (b b)) #((a) (b) (c) (x) (y) (z) (a) (b) (c)) :key #'car)
     0)
(eql (search '((a a) (b b))
             #((a nil) (b t) (c nil) (x) (y) (z) (a 0) (b 1) (c 2))
             :key #'car
             :from-end t)
     6)

(eql (search '(("a" a) ("b" b))
             #(("a" nil) ("b" t) ("c" nil) ("x") ("y") ("z")
               ("A" 0) ("B" 1) ("C" 2))
             :start1 1
             :end1 2
             :start2 3
             :end2 nil
             :key #'car
             :test #'string-equal
             :from-end t)
     7)


(eql (search #() #()) 0)
(null (search #(a b c) #(x y z)))
(eql (search #() #(x y z)) 0)
(eql (search #(a) #(a)) 0)
(eql (search #(a b c) #(a b c x y z)) 0)
(eql (search #(a b c) #(x a b c y z)) 1)
(eql (search #(a b c) #(x y a b c z)) 2)
(eql (search #(a b c) #(x y z a b c)) 3)
(eql (search #(a b c) #(a b c a b c) :start2 1) 3)
(eql (search #(a b c) #(a b c a b c) :start2 1 :end2 nil) 3)
(eql (search #(a b c) #(a b c a b c) :start1 1 :start2 1 :end2 nil) 1)
(eql (search #(a b c) #(a b c a b c) :start1 1 :end1 nil :start2 1 :end2 nil) 1)
(null (search #(a b c) #(a b c a b c) :start2 0 :end2 0))
(null (search #(a b c) #(a b c a b c) :start2 1 :end2 1))
(null (search #(a b c) #(a b c a b c) :start2 2 :end2 2))
(null (search #(a b c) #(a b c a b c) :start2 3 :end2 3))
(null (search #(a b c) #(a b c a b c) :start2 4 :end2 4))
(null (search #(a b c) #(a b c a b c) :start2 5 :end2 5))
(null (search #(a b c) #(a b c a b c) :start2 6 :end2 6))
(eql (search #(a b c) #(a b c a b c)) 0)
(eql (search #(a b c) #(a b c a b c) :from-end t) 3)
(eql (search #(a b c) #(a b c a b c) :start2 3 :end2 6) 3)
(eql (search #(a b c) #(a b c a b c) :start2 3 :end2 6 :from-end t) 3)
(eql (search #(a b c) #(a b c a b c)
             :start1 0 :end1 2 :start2 0 :end2 6)
     0)
(eql (search #(a b c) #(a b c a b c)
             :start1 0 :end1 2 :start2 0 :end2 6 :from-end t)
     3)
(eql (search #(a b c) #(a b c a b c) :start1 0 :end1 0 :start2 0 :end2 0) 0)
(eql (search #(a b c) #(a b c a b c) :start1 1 :end1 1 :start2 0 :end2 0) 0)
(eql (search #(a b c) #(a b c a b c) :start1 2 :end1 2 :start2 0 :end2 0) 0)
(eql (search #(a b c) #(a b c a b c) :start1 3 :end1 3 :start2 0 :end2 0) 0)
(eql (search #(a b c) #(a b c a b c) :start1 0 :end1 0 :start2 1 :end2 1) 1)
(eql (search #(a b c) #(a b c a b c) :start1 1 :end1 1 :start2 1 :end2 1) 1)
(eql (search #(a b c) #(a b c a b c) :start1 2 :end1 2 :start2 1 :end2 1) 1)
(eql (search #(a b c) #(a b c a b c) :start1 3 :end1 3 :start2 1 :end2 1) 1)
(eql (search #(a b c) #(a b c a b c) :start1 0 :end1 0 :start2 6 :end2 6) 6)
(eql (search #(a b c) #(a b c a b c) :start1 1 :end1 1 :start2 6 :end2 6) 6)
(eql (search #(a b c) #(a b c a b c) :start1 2 :end1 2 :start2 6 :end2 6) 6)
(eql (search #(a b c) #(a b c a b c) :start1 3 :end1 3 :start2 6 :end2 6) 6)

(eql (search #(a b c) #(a b c a b c) :start1 0 :end1 0 :start2 0 :end2 0
             :from-end t) 0)
(eql (search #(a b c) #(a b c a b c) :start1 1 :end1 1 :start2 0 :end2 0
             :from-end t) 0)
(eql (search #(a b c) #(a b c a b c) :start1 2 :end1 2 :start2 0 :end2 0
             :from-end t) 0)
(eql (search #(a b c) #(a b c a b c) :start1 3 :end1 3 :start2 0 :end2 0
             :from-end t) 0)
(eql (search #(a b c) #(a b c a b c) :start1 0 :end1 0 :start2 1 :end2 1
             :from-end t) 1)
(eql (search #(a b c) #(a b c a b c) :start1 1 :end1 1 :start2 1 :end2 1
             :from-end t) 1)
(eql (search #(a b c) #(a b c a b c) :start1 2 :end1 2 :start2 1 :end2 1
             :from-end t) 1)
(eql (search #(a b c) #(a b c a b c) :start1 3 :end1 3 :start2 1 :end2 1
             :from-end t) 1)
(eql (search #(a b c) #(a b c a b c) :start1 0 :end1 0 :start2 6 :end2 6
             :from-end t) 6)
(eql (search #(a b c) #(a b c a b c) :start1 1 :end1 1 :start2 6 :end2 6
             :from-end t) 6)
(eql (search #(a b c) #(a b c a b c) :start1 2 :end1 2 :start2 6 :end2 6
             :from-end t) 6)
(eql (search #(a b c) #(a b c a b c) :start1 3 :end1 3 :start2 6 :end2 6
             :from-end t) 6)

(null (search #(#\a #\b #\c) #(#\A #\B #\C)))
(eql (search #(#\a #\b #\c) #(#\A #\B #\C) :test #'char-equal) 0)
(eql (search #(#\a #\b #\c) #(#\A #\B #\C) :test-not (complement #'char-equal))
             0)
(eql (search #(#\a #\b) #(#\a #\b #\x #\y #\z)) 0)
(eql (search #(#\a #\b) #(#\a #\b #\x #\y #\z) :test #'char<) 1)
(eql (search #(#\a #\b) #(#\a #\b #\x #\y #\z) :test-not (complement #'char<))
     1)
(eql (search #(#\a #\b) #(#\a #\b #\x #\y #\z)
             :test-not (complement #'char<)
             :from-end t)
     3)

(null (search #((a) (b)) #((x) (y) (z) (a) (b) (c))))
(eql (search #((a) (b)) #((x) (y) (z) (a) (b) (c)) :key #'car) 3)
(eql (search #((a) (b)) #((a) (b) (c) (x) (y) (z) (a) (b) (c)) :key #'car)
     0)
(eql (search #((a) (b)) #((a) (b) (c) (x) (y) (z) (a) (b) (c))
             :key #'car
             :from-end t)
     6)

(eql (search #((a a) (b b)) #((a) (b) (c) (x) (y) (z) (a) (b) (c)) :key #'car)
     0)
(eql (search #((a a) (b b))
             #((a nil) (b t) (c nil) (x) (y) (z) (a 0) (b 1) (c 2))
             :key #'car
             :from-end t)
     6)

(eql (search #(("a" a) ("b" b))
             #(("a" nil) ("b" t) ("c" nil) ("x") ("y") ("z")
               ("A" 0) ("B" 1) ("C" 2))
             :start1 1
             :end1 2
             :start2 3
             :end2 nil
             :key #'car
             :test #'string-equal
             :from-end t)
     7)


(null (search "peace" "LOVE&PEACE"))
(eql (search "peace" "LOVE&PEACE" :test #'char-equal) 5)
(eql (search (concatenate 'simple-vector "peace")
             (concatenate 'list "LOVE&PEACE") :test #'char-equal)
     5)
(eql (search (concatenate 'list "peace")
             (concatenate 'vector "LOVE&PEACE") :test #'char-equal)
     5)
(eql (search (concatenate 'vector "peace")
             (concatenate 'vector "LOVE&PEACE") :test #'char-equal)
     5)

(eql (search #*10 #*010101) 1)
(eql (search #*10 #*010101 :from-end t) 3)


(null (search "PeAcE" "LoVe&pEaCe"))
(eql (search "PeAcE" "LoVe&pEaCe" :key #'char-upcase) 5)
(eql (search "abc" "abc xyz abc" :from-end t) 8)
(eql (search "abc" "abc xyz abc xyz abc xyz abc"
             :start2 8
             :end2 19)
     8)
(eql (search "abc" "abc xyz abc xyz abc xyz abc"
             :from-end t
             :start2 8
             :end2 19)
     16)



(eql (mismatch "abcd" "ABCDE" :test #'char-equal) 4)
(eql (mismatch '(3 2 1 1 2 3) '(1 2 3) :from-end t) 3)
(null (mismatch '(1 2 3) '(2 3 4) :test-not #'eq :key #'oddp))
(null (mismatch '(1 2 3 4 5 6) '(3 4 5 6 7) :start1 2 :end2 4))


(null (mismatch '() '()))
(eql (mismatch '(a b c) '(x y z)) 0)
(eql (mismatch '() '(x y z)) 0)
(eql (mismatch '(x y z) '()) 0)
(null (mismatch '(a) '(a)))
(eql (mismatch '(a b c x y z) '(a b c)) 3)
(null (mismatch '(a b c) '(a b c)))
(eql (mismatch '(a b c d e f) '(a b c)) 3)
(eql (mismatch '(a b c) '(a b c d e f)) 3)
(eql (mismatch '(a b c) '(a b x)) 2)
(eql (mismatch '(a b c) '(a x c)) 1)
(eql (mismatch '(a b c) '(x b c)) 0)
(eql (mismatch '(x y z a b c x y z) '(a b c) :start1 3) 6)
(eql (mismatch '(x y z a b c x y z) '(a b c) :start1 3 :end1 nil) 6)
(eql (mismatch '(x y z a b c x y z) '(a b c) :start1 3 :end1 4) 4)
(eql (mismatch '(x y z a b c x y z) '(a b c) :start1 3 :end1 3) 3)
(null (mismatch '(x y z) '() :start1 0 :end1 0))
(null (mismatch '(x y z) '() :start1 1 :end1 1))
(null (mismatch '(x y z) '() :start1 2 :end1 2))
(null (mismatch '(x y z) '() :start1 3 :end1 3))
(null (mismatch '(x y z) '() :start1 0 :end1 0 :start2 0 :end2 0))
;(null (mismatch '(x y z) '() :start1 1 :end1 1 :start2 1 :end2 1))
;(null (mismatch '(x y z) '() :start1 2 :end1 2 :start2 2 :end2 2))
;(null (mismatch '(x y z) '() :start1 3 :end1 3 :start2 3 :end2 3))
;(null (mismatch '(x y z) '() :start1 0 :end1 0 :start2 3 :end2 3))
;(null (mismatch '(x y z) '() :start1 1 :end1 1 :start2 2 :end2 2))
;(null (mismatch '(x y z) '() :start1 2 :end1 2 :start2 1 :end2 1))
(null (mismatch '(x y z) '() :start1 3 :end1 3 :start2 0 :end2 0))
(eql (mismatch '(x y z) '(a b c) :start1 0 :end1 0) 0)
(eql (mismatch '(x y z) '(a b c) :start1 1 :end1 1) 1)
(eql (mismatch '(x y z) '(a b c) :start1 2 :end1 2) 2)
(eql (mismatch '(x y z) '(a b c) :start1 3 :end1 3) 3)
(eql (mismatch '(x y z) '(x y z) :start1 0 :end1 1) 1)
(eql (mismatch '(x y z) '(x y z) :start1 0 :end1 2) 2)
(eql (mismatch '(x y z) '(x y z Z) :start1 0 :end1 3) 3)
(null (mismatch '(x y z) '(x y z) :start1 0 :end1 3))
(eql (mismatch '(a b c x y z) '(x y z a b c)) 0)
(eql (mismatch '(a b c x y z) '(x y z a b c) :start1 3) 6)
(eql (mismatch '(a b c x y z a b c) '(x y z a b c x y z) :start1 3) 9)
(eql (mismatch '(a b c x y z a b c) '(x y z a b c x y z) :start1 6) 6)
(eql (mismatch '(a b c x y z a b c) '(x y z a b c x y z) :start1 6 :start2 3)
     9)
(eql (mismatch '(a b c x y z a b c) '(x y z a b c x y z) :start1 0 :start2 3)
     6)
(eql (mismatch '(a b c) '(a b c x y z)) 3)
(eql (mismatch '(a b c) '(x a b c y z)) 0)
(eql (mismatch '(a b c) '(x a b c y z) :start2 1) 3)
(eql (mismatch '(a b c) '(x a b c y z) :start2 1 :end2 nil) 3)
(null (mismatch '(a b c) '(x a b c y z) :start2 1 :end2 4))

(eql (mismatch '(a b c d e) '(c d)) 0)
(eql (mismatch '(a b c d e) '(c d) :start1 2) 4)
(eql (mismatch '(a b c d e) '(c d) :start1 2 :end1 3) 3)
(eql (mismatch '(a b c d e) '(c d) :start1 2 :start2 1) 2)
(eql (mismatch '(a b c d e) '(c d) :start1 3 :start2 1) 4)
(eql (mismatch '(a b c d e) '(c d) :start1 2 :end2 1) 3)
(null (mismatch '(a b c d) '(a b c d) :start1 1 :end1 2 :start2 1 :end2 2))
(null (mismatch '(a b c d) '(a b c d) :start1 1 :end1 3 :start2 1 :end2 3))
(null (mismatch '(a b c d) '(a b c d) :start1 1 :end1 4 :start2 1 :end2 4))
(eql (mismatch '(a b c d) '(a b c d) :start1 1 :end1 nil :start2 1 :end2 1) 1)
(eql (mismatch '(a b c d) '(a b c d) :start1 1 :end1 nil :start2 1 :end2 2) 2)
(eql (mismatch '(a b c d) '(a b c d) :start1 1 :end1 nil :start2 1 :end2 3) 3)
(null (mismatch '(a b c d) '(a b c d) :start1 1 :end1 nil :start2 1 :end2 4))
(eql (mismatch '(a b c d) '(a b c d) :start1 1 :end1 1 :start2 1) 1)
(eql (mismatch '(a b c d) '(a b c d) :start1 1 :end1 2 :start2 1) 2)
(eql (mismatch '(a b c d) '(a b c d) :start1 1 :end1 3 :start2 1) 3)
(null (mismatch '(a b c d) '(a b c d) :start1 1 :end1 4 :start2 1))

(null (mismatch '(a b c) '(a b c) :from-end t))
(eql (mismatch '(a b c d) '(a b c) :from-end t) 4)
(eql (mismatch '(a b c) '(c) :from-end t) 2)
(eql (mismatch '(a b c) '(z a b c) :from-end t) 0)
(eql (mismatch '(a b c) '(x y z a b c) :from-end t) 0)
(eql (mismatch '(x y z a b c) '(a b c) :from-end t) 3)
(eql (mismatch '(x y z a b c) '(a b c) :end1 3 :from-end t) 3)
(eql (mismatch '(x y z a b c) '(a b c) :end1 5 :from-end t) 5)
(eql (mismatch '(x y z a b c x y z) '(a b c) :end1 6 :from-end t) 3)
(eql (mismatch '(x y z a b c x y z) '(a b c) :start1 2 :end1 6 :from-end t) 3)
(eql (mismatch '(x y z a b c x y z) '(a b c)
               :from-end t
               :start1 2 :end1 5
               :start2 1 :end2 2
               ) 4)
(eql (mismatch '(x y z a b c x y z) '(a b c)
               :start1 2 :end1 5
               :start2 1 :end2 2
               ) 2)
(eql (mismatch '((a) (b) (c)) '((a) (b) (c))) 0)
(null (mismatch '((a) (b) (c)) '((a) (b) (c)) :key #'car))
(null (mismatch '((a) (b) (c)) '((a) (b) (c)) :test #'equal))
(eql (mismatch '(#(a) #(b) #(c)) '(#(a) #(b) #(c))) 0)
(null (mismatch '(#(a) #(b) #(c)) '(#(a) #(b) #(c)) :test #'equalp))
(eql (mismatch '((a) (b) (c) (d)) '((a) (b) (c)) :key #'car) 3)
(eql (mismatch '((a) (b) (c)) '((a) (b) (c) (d)) :key #'car) 3)
(eql (mismatch '(#\a #\b #\c) '(#\A #\B #\C)) 0)
(null (mismatch '(#\a #\b #\c) '(#\A #\B #\C) :key #'char-upcase))
(null (mismatch '(#\a #\b #\c) '(#\A #\B #\C) :key #'char-downcase))
(null (mismatch '(#\a #\b #\c) '(#\A #\B #\C)
                :key #'char-upcase
                :start1 1 :end1 2
                :start2 1 :end2 2))
(null (mismatch '(#\a #\b #\c) '(#\A #\B #\C)
                :key #'char-upcase
                :start1 2
                :start2 2))
(eql (mismatch '((a b c) (b c d) (d e f))
               '((b b c) (c c d) (e e f)))
     0)
(eql (mismatch '((a b c) (b c d) (d e f))
               '((b b c) (c c d) (e e f))
               :key #'cdr)
     0)
(null (mismatch '((a b c) (b c d) (d e f))
                '((b b c) (c c d) (e e f))
                :key #'cdr
                :test #'equal))
(eql (mismatch '((a b c) (b c d) (d e f) (e f g))
               '((b b c) (c c d) (e e f))
               :key #'cdr
               :test #'equal)
     3)
(eql (mismatch '((a b c) (b c d) (d e f) (e f g))
               '((b b c) (c c d) (e e f))
               :key #'cdr
               :test #'equal
               :from-end t)
     4)
(eql (mismatch '((a a a) (a b c) (b c d) (d e f))
               '((b b c) (c c d) (e e f))
               :key #'cdr
               :test #'equal
               :from-end t)
     1)
(null (mismatch '((a a a) (a b c) (b c d) (d e f) (e f g))
               '((b b c) (c c d) (e e f))
               :key #'cdr
               :test #'equal
               :from-end t
               :start1 1
               :end1 4))
(eql (mismatch '((a a a) (a b c) (b c d) (d e f) (e f g))
               '((b b c) (c c d) (e e f))
               :key #'cdr
               :test #'equal
               :from-end t
               :start1 1)
     5)
(eql (mismatch '((a a a) (a b c) (b c d) (d e f) (e f g))
               '((b b c) (c c d) (e e f))
               :key #'cdr
               :test #'equal
               :from-end t
               :end1 3
               :start2 1
               :end2 2)

     2)


(null (mismatch #() '()))
(eql (mismatch #(a b c) '(x y z)) 0)
(eql (mismatch #() '(x y z)) 0)
(eql (mismatch #(x y z) '()) 0)
(null (mismatch #(a) '(a)))
(eql (mismatch #(a b c x y z) '(a b c)) 3)
(null (mismatch #(a b c) '(a b c)))
(eql (mismatch #(a b c d e f) '(a b c)) 3)
(eql (mismatch #(a b c) '(a b c d e f)) 3)
(eql (mismatch #(a b c) '(a b x)) 2)
(eql (mismatch #(a b c) '(a x c)) 1)
(eql (mismatch #(a b c) '(x b c)) 0)
(eql (mismatch #(x y z a b c x y z) '(a b c) :start1 3) 6)
(eql (mismatch #(x y z a b c x y z) '(a b c) :start1 3 :end1 nil) 6)
(eql (mismatch #(x y z a b c x y z) '(a b c) :start1 3 :end1 4) 4)
(eql (mismatch #(x y z a b c x y z) '(a b c) :start1 3 :end1 3) 3)
(null (mismatch #(x y z) '() :start1 0 :end1 0))
(null (mismatch #(x y z) '() :start1 1 :end1 1))
(null (mismatch #(x y z) '() :start1 2 :end1 2))
(null (mismatch #(x y z) '() :start1 3 :end1 3))
(null (mismatch #(x y z) '() :start1 0 :end1 0 :start2 0 :end2 0))
;(null (mismatch #(x y z) '() :start1 1 :end1 1 :start2 1 :end2 1))
;(null (mismatch #(x y z) '() :start1 2 :end1 2 :start2 2 :end2 2))
;(null (mismatch #(x y z) '() :start1 3 :end1 3 :start2 3 :end2 3))
;(null (mismatch #(x y z) '() :start1 0 :end1 0 :start2 3 :end2 3))
;(null (mismatch #(x y z) '() :start1 1 :end1 1 :start2 2 :end2 2))
;(null (mismatch #(x y z) '() :start1 2 :end1 2 :start2 1 :end2 1))
(null (mismatch #(x y z) '() :start1 3 :end1 3 :start2 0 :end2 0))
(eql (mismatch #(x y z) '(a b c) :start1 0 :end1 0) 0)
(eql (mismatch #(x y z) '(a b c) :start1 1 :end1 1) 1)
(eql (mismatch #(x y z) '(a b c) :start1 2 :end1 2) 2)
(eql (mismatch #(x y z) '(a b c) :start1 3 :end1 3) 3)
(eql (mismatch #(x y z) '(x y z) :start1 0 :end1 1) 1)
(eql (mismatch #(x y z) '(x y z) :start1 0 :end1 2) 2)
(eql (mismatch #(x y z) '(x y z Z) :start1 0 :end1 3) 3)
(null (mismatch #(x y z) '(x y z) :start1 0 :end1 3))
(eql (mismatch #(a b c x y z) '(x y z a b c)) 0)
(eql (mismatch #(a b c x y z) '(x y z a b c) :start1 3) 6)
(eql (mismatch #(a b c x y z a b c) '(x y z a b c x y z) :start1 3) 9)
(eql (mismatch #(a b c x y z a b c) '(x y z a b c x y z) :start1 6) 6)
(eql (mismatch #(a b c x y z a b c) '(x y z a b c x y z) :start1 6 :start2 3)
     9)
(eql (mismatch #(a b c x y z a b c) '(x y z a b c x y z) :start1 0 :start2 3)
     6)
(eql (mismatch #(a b c) '(a b c x y z)) 3)
(eql (mismatch #(a b c) '(x a b c y z)) 0)
(eql (mismatch #(a b c) '(x a b c y z) :start2 1) 3)
(eql (mismatch #(a b c) '(x a b c y z) :start2 1 :end2 nil) 3)
(null (mismatch #(a b c) '(x a b c y z) :start2 1 :end2 4))
(eql (mismatch #(a b c d e) '(c d)) 0)
(eql (mismatch #(a b c d e) '(c d) :start1 2) 4)
(eql (mismatch #(a b c d e) '(c d) :start1 2 :end1 3) 3)
(eql (mismatch #(a b c d e) '(c d) :start1 2 :start2 1) 2)
(eql (mismatch #(a b c d e) '(c d) :start1 3 :start2 1) 4)
(eql (mismatch #(a b c d e) '(c d) :start1 2 :end2 1) 3)
(null (mismatch #(a b c d) '(a b c d) :start1 1 :end1 2 :start2 1 :end2 2))
(null (mismatch #(a b c d) '(a b c d) :start1 1 :end1 3 :start2 1 :end2 3))
(null (mismatch #(a b c d) '(a b c d) :start1 1 :end1 4 :start2 1 :end2 4))
(eql (mismatch #(a b c d) '(a b c d) :start1 1 :end1 nil :start2 1 :end2 1) 1)
(eql (mismatch #(a b c d) '(a b c d) :start1 1 :end1 nil :start2 1 :end2 2) 2)
(eql (mismatch #(a b c d) '(a b c d) :start1 1 :end1 nil :start2 1 :end2 3) 3)
(null (mismatch #(a b c d) '(a b c d) :start1 1 :end1 nil :start2 1 :end2 4))
(eql (mismatch #(a b c d) '(a b c d) :start1 1 :end1 1 :start2 1) 1)
(eql (mismatch #(a b c d) '(a b c d) :start1 1 :end1 2 :start2 1) 2)
(eql (mismatch #(a b c d) '(a b c d) :start1 1 :end1 3 :start2 1) 3)
(null (mismatch #(a b c d) '(a b c d) :start1 1 :end1 4 :start2 1))
(null (mismatch #(a b c) '(a b c) :from-end t))
(eql (mismatch #(a b c d) '(a b c) :from-end t) 4)
(eql (mismatch #(a b c) '(c) :from-end t) 2)
(eql (mismatch #(a b c) '(z a b c) :from-end t) 0)
(eql (mismatch #(a b c) '(x y z a b c) :from-end t) 0)
(eql (mismatch #(x y z a b c) '(a b c) :from-end t) 3)
(eql (mismatch #(x y z a b c) '(a b c) :end1 3 :from-end t) 3)
(eql (mismatch #(x y z a b c) '(a b c) :end1 5 :from-end t) 5)
(eql (mismatch #(x y z a b c x y z) '(a b c) :end1 6 :from-end t) 3)
(eql (mismatch #(x y z a b c x y z) '(a b c) :start1 2 :end1 6 :from-end t) 3)
(eql (mismatch #(x y z a b c x y z) '(a b c)
               :from-end t
               :start1 2 :end1 5
               :start2 1 :end2 2
               ) 4)
(eql (mismatch #(x y z a b c x y z) '(a b c)
               :start1 2 :end1 5
               :start2 1 :end2 2
               ) 2)
(eql (mismatch #((a) (b) (c)) '((a) (b) (c))) 0)
(null (mismatch #((a) (b) (c)) '((a) (b) (c)) :key #'car))
(null (mismatch #((a) (b) (c)) '((a) (b) (c)) :test #'equal))
(eql (mismatch #(#(a) #(b) #(c)) '(#(a) #(b) #(c))) 0)
(null (mismatch #(#(a) #(b) #(c)) '(#(a) #(b) #(c)) :test #'equalp))
(eql (mismatch #((a) (b) (c) (d)) '((a) (b) (c)) :key #'car) 3)
(eql (mismatch #((a) (b) (c)) '((a) (b) (c) (d)) :key #'car) 3)
(eql (mismatch #(#\a #\b #\c) '(#\A #\B #\C)) 0)
(null (mismatch #(#\a #\b #\c) '(#\A #\B #\C) :key #'char-upcase))
(null (mismatch #(#\a #\b #\c) '(#\A #\B #\C) :key #'char-downcase))
(null (mismatch #(#\a #\b #\c) '(#\A #\B #\C)
                :key #'char-upcase
                :start1 1 :end1 2
                :start2 1 :end2 2))
(null (mismatch #(#\a #\b #\c) '(#\A #\B #\C)
                :key #'char-upcase
                :start1 2
                :start2 2))
(eql (mismatch #((a b c) (b c d) (d e f))
               '((b b c) (c c d) (e e f)))
     0)
(eql (mismatch #((a b c) (b c d) (d e f))
               '((b b c) (c c d) (e e f))
               :key #'cdr)
     0)
(null (mismatch #((a b c) (b c d) (d e f))
                '((b b c) (c c d) (e e f))
                :key #'cdr
                :test #'equal))
(eql (mismatch #((a b c) (b c d) (d e f) (e f g))
               '((b b c) (c c d) (e e f))
               :key #'cdr
               :test #'equal)
     3)
(eql (mismatch #((a b c) (b c d) (d e f) (e f g))
               '((b b c) (c c d) (e e f))
               :key #'cdr
               :test #'equal
               :from-end t)
     4)
(eql (mismatch #((a a a) (a b c) (b c d) (d e f))
               '((b b c) (c c d) (e e f))
               :key #'cdr
               :test #'equal
               :from-end t)
     1)
(null (mismatch #((a a a) (a b c) (b c d) (d e f) (e f g))
               '((b b c) (c c d) (e e f))
               :key #'cdr
               :test #'equal
               :from-end t
               :start1 1
               :end1 4))
(eql (mismatch #((a a a) (a b c) (b c d) (d e f) (e f g))
               '((b b c) (c c d) (e e f))
               :key #'cdr
               :test #'equal
               :from-end t
               :start1 1)
     5)
(eql (mismatch #((a a a) (a b c) (b c d) (d e f) (e f g))
               '((b b c) (c c d) (e e f))
               :key #'cdr
               :test #'equal
               :from-end t
               :end1 3
               :start2 1
               :end2 2)

     2)


(null (mismatch '() #()))
(eql (mismatch '(a b c) #(x y z)) 0)
(eql (mismatch '() #(x y z)) 0)
(eql (mismatch '(x y z) #()) 0)
(null (mismatch '(a) #(a)))
(eql (mismatch '(a b c x y z) #(a b c)) 3)
(null (mismatch '(a b c) #(a b c)))
(eql (mismatch '(a b c d e f) #(a b c)) 3)
(eql (mismatch '(a b c) #(a b c d e f)) 3)
(eql (mismatch '(a b c) #(a b x)) 2)
(eql (mismatch '(a b c) #(a x c)) 1)
(eql (mismatch '(a b c) #(x b c)) 0)
(eql (mismatch '(x y z a b c x y z) #(a b c) :start1 3) 6)
(eql (mismatch '(x y z a b c x y z) #(a b c) :start1 3 :end1 nil) 6)
(eql (mismatch '(x y z a b c x y z) #(a b c) :start1 3 :end1 4) 4)
(eql (mismatch '(x y z a b c x y z) #(a b c) :start1 3 :end1 3) 3)
(null (mismatch '(x y z) #() :start1 0 :end1 0))
(null (mismatch '(x y z) #() :start1 1 :end1 1))
(null (mismatch '(x y z) #() :start1 2 :end1 2))
(null (mismatch '(x y z) #() :start1 3 :end1 3))
(null (mismatch '(x y z) #() :start1 0 :end1 0 :start2 0 :end2 0))
;(null (mismatch '(x y z) #() :start1 1 :end1 1 :start2 1 :end2 1))
;(null (mismatch '(x y z) #() :start1 2 :end1 2 :start2 2 :end2 2))
;(null (mismatch '(x y z) #() :start1 3 :end1 3 :start2 3 :end2 3))
;(null (mismatch '(x y z) #() :start1 0 :end1 0 :start2 3 :end2 3))
;(null (mismatch '(x y z) #() :start1 1 :end1 1 :start2 2 :end2 2))
;(null (mismatch '(x y z) #() :start1 2 :end1 2 :start2 1 :end2 1))
(null (mismatch '(x y z) #() :start1 3 :end1 3 :start2 0 :end2 0))
(eql (mismatch '(x y z) #(a b c) :start1 0 :end1 0) 0)
(eql (mismatch '(x y z) #(a b c) :start1 1 :end1 1) 1)
(eql (mismatch '(x y z) #(a b c) :start1 2 :end1 2) 2)
(eql (mismatch '(x y z) #(a b c) :start1 3 :end1 3) 3)
(eql (mismatch '(x y z) #(x y z) :start1 0 :end1 1) 1)
(eql (mismatch '(x y z) #(x y z) :start1 0 :end1 2) 2)
(eql (mismatch '(x y z) #(x y z Z) :start1 0 :end1 3) 3)
(null (mismatch '(x y z) #(x y z) :start1 0 :end1 3))
(eql (mismatch '(a b c x y z) #(x y z a b c)) 0)
(eql (mismatch '(a b c x y z) #(x y z a b c) :start1 3) 6)
(eql (mismatch '(a b c x y z a b c) #(x y z a b c x y z) :start1 3) 9)
(eql (mismatch '(a b c x y z a b c) #(x y z a b c x y z) :start1 6) 6)
(eql (mismatch '(a b c x y z a b c) #(x y z a b c x y z) :start1 6 :start2 3)
     9)
(eql (mismatch '(a b c x y z a b c) #(x y z a b c x y z) :start1 0 :start2 3)
     6)
(eql (mismatch '(a b c) #(a b c x y z)) 3)
(eql (mismatch '(a b c) #(x a b c y z)) 0)
(eql (mismatch '(a b c) #(x a b c y z) :start2 1) 3)
(eql (mismatch '(a b c) #(x a b c y z) :start2 1 :end2 nil) 3)
(null (mismatch '(a b c) #(x a b c y z) :start2 1 :end2 4))
(eql (mismatch '(a b c d e) #(c d)) 0)
(eql (mismatch '(a b c d e) #(c d) :start1 2) 4)
(eql (mismatch '(a b c d e) #(c d) :start1 2 :end1 3) 3)
(eql (mismatch '(a b c d e) #(c d) :start1 2 :start2 1) 2)
(eql (mismatch '(a b c d e) #(c d) :start1 3 :start2 1) 4)
(eql (mismatch '(a b c d e) #(c d) :start1 2 :end2 1) 3)
(null (mismatch '(a b c d) #(a b c d) :start1 1 :end1 2 :start2 1 :end2 2))
(null (mismatch '(a b c d) #(a b c d) :start1 1 :end1 3 :start2 1 :end2 3))
(null (mismatch '(a b c d) #(a b c d) :start1 1 :end1 4 :start2 1 :end2 4))
(eql (mismatch '(a b c d) #(a b c d) :start1 1 :end1 nil :start2 1 :end2 1) 1)
(eql (mismatch '(a b c d) #(a b c d) :start1 1 :end1 nil :start2 1 :end2 2) 2)
(eql (mismatch '(a b c d) #(a b c d) :start1 1 :end1 nil :start2 1 :end2 3) 3)
(null (mismatch '(a b c d) #(a b c d) :start1 1 :end1 nil :start2 1 :end2 4))
(eql (mismatch '(a b c d) #(a b c d) :start1 1 :end1 1 :start2 1) 1)
(eql (mismatch '(a b c d) #(a b c d) :start1 1 :end1 2 :start2 1) 2)
(eql (mismatch '(a b c d) #(a b c d) :start1 1 :end1 3 :start2 1) 3)
(null (mismatch '(a b c d) #(a b c d) :start1 1 :end1 4 :start2 1))
(null (mismatch '(a b c) #(a b c) :from-end t))
(eql (mismatch '(a b c d) #(a b c) :from-end t) 4)
(eql (mismatch '(a b c) #(c) :from-end t) 2)
(eql (mismatch '(a b c) #(z a b c) :from-end t) 0)
(eql (mismatch '(a b c) #(x y z a b c) :from-end t) 0)
(eql (mismatch '(x y z a b c) #(a b c) :from-end t) 3)
(eql (mismatch '(x y z a b c) #(a b c) :end1 3 :from-end t) 3)
(eql (mismatch '(x y z a b c) #(a b c) :end1 5 :from-end t) 5)
(eql (mismatch '(x y z a b c x y z) #(a b c) :end1 6 :from-end t) 3)
(eql (mismatch '(x y z a b c x y z) #(a b c) :start1 2 :end1 6 :from-end t) 3)
(eql (mismatch '(x y z a b c x y z) #(a b c)
               :from-end t
               :start1 2 :end1 5
               :start2 1 :end2 2
               ) 4)
(eql (mismatch '(x y z a b c x y z) #(a b c)
               :start1 2 :end1 5
               :start2 1 :end2 2
               ) 2)
(eql (mismatch '((a) (b) (c)) #((a) (b) (c))) 0)
(null (mismatch '((a) (b) (c)) #((a) (b) (c)) :key #'car))
(null (mismatch '((a) (b) (c)) #((a) (b) (c)) :test #'equal))
(eql (mismatch '(#(a) #(b) #(c)) #(#(a) #(b) #(c))) 0)
(null (mismatch '(#(a) #(b) #(c)) #(#(a) #(b) #(c)) :test #'equalp))
(eql (mismatch '((a) (b) (c) (d)) #((a) (b) (c)) :key #'car) 3)
(eql (mismatch '((a) (b) (c)) #((a) (b) (c) (d)) :key #'car) 3)
(eql (mismatch '(#\a #\b #\c) #(#\A #\B #\C)) 0)
(null (mismatch '(#\a #\b #\c) #(#\A #\B #\C) :key #'char-upcase))
(null (mismatch '(#\a #\b #\c) #(#\A #\B #\C) :key #'char-downcase))
(null (mismatch '(#\a #\b #\c) #(#\A #\B #\C)
                :key #'char-upcase
                :start1 1 :end1 2
                :start2 1 :end2 2))
(null (mismatch '(#\a #\b #\c) #(#\A #\B #\C)
                :key #'char-upcase
                :start1 2
                :start2 2))
(eql (mismatch '((a b c) (b c d) (d e f))
               #((b b c) (c c d) (e e f)))
     0)
(eql (mismatch '((a b c) (b c d) (d e f))
               #((b b c) (c c d) (e e f))
               :key #'cdr)
     0)
(null (mismatch '((a b c) (b c d) (d e f))
                #((b b c) (c c d) (e e f))
                :key #'cdr
                :test #'equal))
(eql (mismatch '((a b c) (b c d) (d e f) (e f g))
               #((b b c) (c c d) (e e f))
               :key #'cdr
               :test #'equal)
     3)
(eql (mismatch '((a b c) (b c d) (d e f) (e f g))
               #((b b c) (c c d) (e e f))
               :key #'cdr
               :test #'equal
               :from-end t)
     4)
(eql (mismatch '((a a a) (a b c) (b c d) (d e f))
               #((b b c) (c c d) (e e f))
               :key #'cdr
               :test #'equal
               :from-end t)
     1)
(null (mismatch '((a a a) (a b c) (b c d) (d e f) (e f g))
                #((b b c) (c c d) (e e f))
                :key #'cdr
                :test #'equal
                :from-end t
                :start1 1
                :end1 4))
(eql (mismatch '((a a a) (a b c) (b c d) (d e f) (e f g))
               #((b b c) (c c d) (e e f))
               :key #'cdr
               :test #'equal
               :from-end t
               :start1 1)
     5)
(eql (mismatch '((a a a) (a b c) (b c d) (d e f) (e f g))
               #((b b c) (c c d) (e e f))
               :key #'cdr
               :test #'equal
               :from-end t
               :end1 3
               :start2 1
               :end2 2)

     2)


(null (mismatch #() #()))
(eql (mismatch #(a b c) #(x y z)) 0)
(eql (mismatch #() #(x y z)) 0)
(eql (mismatch #(x y z) #()) 0)
(null (mismatch #(a) #(a)))
(eql (mismatch #(a b c x y z) #(a b c)) 3)
(null (mismatch #(a b c) #(a b c)))
(eql (mismatch #(a b c d e f) #(a b c)) 3)
(eql (mismatch #(a b c) #(a b c d e f)) 3)
(eql (mismatch #(a b c) #(a b x)) 2)
(eql (mismatch #(a b c) #(a x c)) 1)
(eql (mismatch #(a b c) #(x b c)) 0)
(eql (mismatch #(x y z a b c x y z) #(a b c) :start1 3) 6)
(eql (mismatch #(x y z a b c x y z) #(a b c) :start1 3 :end1 nil) 6)
(eql (mismatch #(x y z a b c x y z) #(a b c) :start1 3 :end1 4) 4)
(eql (mismatch #(x y z a b c x y z) #(a b c) :start1 3 :end1 3) 3)
(null (mismatch #(x y z) #() :start1 0 :end1 0))
(null (mismatch #(x y z) #() :start1 1 :end1 1))
(null (mismatch #(x y z) #() :start1 2 :end1 2))
(null (mismatch #(x y z) #() :start1 3 :end1 3))
(null (mismatch #(x y z) #() :start1 0 :end1 0 :start2 0 :end2 0))
;(null (mismatch #(x y z) #() :start1 1 :end1 1 :start2 1 :end2 1))
;(null (mismatch #(x y z) #() :start1 2 :end1 2 :start2 2 :end2 2))
;(null (mismatch #(x y z) #() :start1 3 :end1 3 :start2 3 :end2 3))
;(null (mismatch #(x y z) #() :start1 0 :end1 0 :start2 3 :end2 3))
;(null (mismatch #(x y z) #() :start1 1 :end1 1 :start2 2 :end2 2))
;(null (mismatch #(x y z) #() :start1 2 :end1 2 :start2 1 :end2 1))
(null (mismatch #(x y z) #() :start1 3 :end1 3 :start2 0 :end2 0))
(eql (mismatch #(x y z) #(a b c) :start1 0 :end1 0) 0)
(eql (mismatch #(x y z) #(a b c) :start1 1 :end1 1) 1)
(eql (mismatch #(x y z) #(a b c) :start1 2 :end1 2) 2)
(eql (mismatch #(x y z) #(a b c) :start1 3 :end1 3) 3)
(eql (mismatch #(x y z) #(x y z) :start1 0 :end1 1) 1)
(eql (mismatch #(x y z) #(x y z) :start1 0 :end1 2) 2)
(eql (mismatch #(x y z) #(x y z Z) :start1 0 :end1 3) 3)
(null (mismatch #(x y z) #(x y z) :start1 0 :end1 3))
(eql (mismatch #(a b c x y z) #(x y z a b c)) 0)
(eql (mismatch #(a b c x y z) #(x y z a b c) :start1 3) 6)
(eql (mismatch #(a b c x y z a b c) #(x y z a b c x y z) :start1 3) 9)
(eql (mismatch #(a b c x y z a b c) #(x y z a b c x y z) :start1 6) 6)
(eql (mismatch #(a b c x y z a b c) #(x y z a b c x y z) :start1 6 :start2 3)
     9)
(eql (mismatch #(a b c x y z a b c) #(x y z a b c x y z) :start1 0 :start2 3)
     6)
(eql (mismatch #(a b c) #(a b c x y z)) 3)
(eql (mismatch #(a b c) #(x a b c y z)) 0)
(eql (mismatch #(a b c) #(x a b c y z) :start2 1) 3)
(eql (mismatch #(a b c) #(x a b c y z) :start2 1 :end2 nil) 3)
(null (mismatch #(a b c) #(x a b c y z) :start2 1 :end2 4))
(eql (mismatch #(a b c d e) #(c d)) 0)
(eql (mismatch #(a b c d e) #(c d) :start1 2) 4)
(eql (mismatch #(a b c d e) #(c d) :start1 2 :end1 3) 3)
(eql (mismatch #(a b c d e) #(c d) :start1 2 :start2 1) 2)
(eql (mismatch #(a b c d e) #(c d) :start1 3 :start2 1) 4)
(eql (mismatch #(a b c d e) #(c d) :start1 2 :end2 1) 3)
(null (mismatch #(a b c d) #(a b c d) :start1 1 :end1 2 :start2 1 :end2 2))
(null (mismatch #(a b c d) #(a b c d) :start1 1 :end1 3 :start2 1 :end2 3))
(null (mismatch #(a b c d) #(a b c d) :start1 1 :end1 4 :start2 1 :end2 4))
(eql (mismatch #(a b c d) #(a b c d) :start1 1 :end1 nil :start2 1 :end2 1) 1)
(eql (mismatch #(a b c d) #(a b c d) :start1 1 :end1 nil :start2 1 :end2 2) 2)
(eql (mismatch #(a b c d) #(a b c d) :start1 1 :end1 nil :start2 1 :end2 3) 3)
(null (mismatch #(a b c d) #(a b c d) :start1 1 :end1 nil :start2 1 :end2 4))
(eql (mismatch #(a b c d) #(a b c d) :start1 1 :end1 1 :start2 1) 1)
(eql (mismatch #(a b c d) #(a b c d) :start1 1 :end1 2 :start2 1) 2)
(eql (mismatch #(a b c d) #(a b c d) :start1 1 :end1 3 :start2 1) 3)
(null (mismatch #(a b c d) #(a b c d) :start1 1 :end1 4 :start2 1))
(null (mismatch #(a b c) #(a b c) :from-end t))
(eql (mismatch #(a b c d) #(a b c) :from-end t) 4)
(eql (mismatch #(a b c) #(c) :from-end t) 2)
(eql (mismatch #(a b c) #(z a b c) :from-end t) 0)
(eql (mismatch #(a b c) #(x y z a b c) :from-end t) 0)
(eql (mismatch #(x y z a b c) #(a b c) :from-end t) 3)
(eql (mismatch #(x y z a b c) #(a b c) :end1 3 :from-end t) 3)
(eql (mismatch #(x y z a b c) #(a b c) :end1 5 :from-end t) 5)
(eql (mismatch #(x y z a b c x y z) #(a b c) :end1 6 :from-end t) 3)
(eql (mismatch #(x y z a b c x y z) #(a b c) :start1 2 :end1 6 :from-end t) 3)
(eql (mismatch #(x y z a b c x y z) #(a b c)
               :from-end t
               :start1 2 :end1 5
               :start2 1 :end2 2
               ) 4)
(eql (mismatch #(x y z a b c x y z) #(a b c)
               :start1 2 :end1 5
               :start2 1 :end2 2
               ) 2)
(eql (mismatch #((a) (b) (c)) #((a) (b) (c))) 0)
(null (mismatch #((a) (b) (c)) #((a) (b) (c)) :key #'car))
(null (mismatch #((a) (b) (c)) #((a) (b) (c)) :test #'equal))
(eql (mismatch #(#(a) #(b) #(c)) #(#(a) #(b) #(c))) 0)
(null (mismatch #(#(a) #(b) #(c)) #(#(a) #(b) #(c)) :test #'equalp))
(eql (mismatch #((a) (b) (c) (d)) #((a) (b) (c)) :key #'car) 3)
(eql (mismatch #((a) (b) (c)) #((a) (b) (c) (d)) :key #'car) 3)
(eql (mismatch #(#\a #\b #\c) #(#\A #\B #\C)) 0)
(null (mismatch #(#\a #\b #\c) #(#\A #\B #\C) :key #'char-upcase))
(null (mismatch #(#\a #\b #\c) #(#\A #\B #\C) :key #'char-downcase))
(null (mismatch #(#\a #\b #\c) #(#\A #\B #\C)
                :key #'char-upcase
                :start1 1 :end1 2
                :start2 1 :end2 2))
(null (mismatch #(#\a #\b #\c) #(#\A #\B #\C)
                :key #'char-upcase
                :start1 2
                :start2 2))
(eql (mismatch #((a b c) (b c d) (d e f))
               #((b b c) (c c d) (e e f)))
     0)
(eql (mismatch #((a b c) (b c d) (d e f))
               #((b b c) (c c d) (e e f))
               :key #'cdr)
     0)
(null (mismatch #((a b c) (b c d) (d e f))
                #((b b c) (c c d) (e e f))
                :key #'cdr
                :test #'equal))
(eql (mismatch #((a b c) (b c d) (d e f) (e f g))
               #((b b c) (c c d) (e e f))
               :key #'cdr
               :test #'equal)
     3)
(eql (mismatch #((a b c) (b c d) (d e f) (e f g))
               #((b b c) (c c d) (e e f))
               :key #'cdr
               :test #'equal
               :from-end t)
     4)
(eql (mismatch #((a a a) (a b c) (b c d) (d e f))
               #((b b c) (c c d) (e e f))
               :key #'cdr
               :test #'equal
               :from-end t)
     1)
(null (mismatch #((a a a) (a b c) (b c d) (d e f) (e f g))
                #((b b c) (c c d) (e e f))
                :key #'cdr
                :test #'equal
                :from-end t
                :start1 1
                :end1 4))
(eql (mismatch #((a a a) (a b c) (b c d) (d e f) (e f g))
               #((b b c) (c c d) (e e f))
               :key #'cdr
               :test #'equal
               :from-end t
               :start1 1)
     5)
(eql (mismatch #((a a a) (a b c) (b c d) (d e f) (e f g))
               #((b b c) (c c d) (e e f))
               :key #'cdr
               :test #'equal
               :from-end t
               :end1 3
               :start2 1
               :end2 2)

     2)


(eql (mismatch "abc" "xyz") 0)
(null (mismatch "" ""))
(null (mismatch "a" "a"))
(null (mismatch "abc" "abc"))
(null (mismatch "abc" "ABC" :key #'char-downcase))
(null (mismatch "abc" "ABC" :test #'char-equal))
(eql (mismatch "abcde" "abc") 3)
(eql (mismatch "abc" "abcde") 3)
(eql (mismatch "abc" "abxyz") 2)
(eql (mismatch "abcde" "abx") 2)
(null (mismatch "abc" "abc" :from-end t))
(eql (mismatch "abcxyz" "xyzxyz" :from-end t) 3)
(eql (mismatch "abcxyz" "xyz" :from-end t) 3)
(eql (mismatch "xyz" "abcxyz" :from-end t) 0)
(eql (mismatch "ayz" "abcxyz" :from-end t) 1)
(null (mismatch "abc" "xyz" :test #'char<))
(eql (mismatch "abc" "xyz" :test #'char>) 0)
(eql (mismatch "abcxyz" "abcdefg") 3)
(eql (mismatch "1xyz" "22xyz" :from-end t) 1)

(null (mismatch #*010101 #*010101))
(eql (mismatch #*010 #*101) 0)
(eql (mismatch #*010 #*101 :from-end t) 3)
(eql (mismatch #*0101 #*010101) 4)
(eql (mismatch #*010101 #*0101) 4)
(eql (mismatch #*010100 #*010111) 4)
(null (mismatch #*0101 #*0101 :from-end t))
(eql (mismatch #*00101 #*0101 :from-end t) 1)
(eql (mismatch #*0101 #*00101 :from-end t) 0)
(eql (mismatch #*00101 #*10101 :from-end t) 1)



(equal (replace "abcdefghij" "0123456789" :start1 4 :end1 7 :start2 4)
       "abcd456hij")
(let ((lst (copy-seq "012345678")))
  (and (equal (replace lst lst :start1 2 :start2 0) "010123456")
       (equal lst "010123456")))


(let* ((list0 (list 'a 'b 'c 'd 'e))
       (list (replace list0 '(x y z))))
  (and (eq list0 list)
       (equal list0 '(x y z d e))))

(let* ((list0 (list 'a 'b 'c 'd 'e))
       (list (replace list0 '(x y z) :start1 1)))
  (and (eq list0 list)
       (equal list0 '(a x y z e))))

(let* ((list0 (list 'a 'b 'c 'd 'e))
       (list (replace list0 '(x y z) :start1 1 :end1 nil)))
  (and (eq list0 list)
       (equal list0 '(a x y z e))))

(let* ((list0 (list 'a 'b 'c 'd 'e))
       (list (replace list0 '(x y z) :start1 1 :start2 1)))
  (and (eq list0 list)
       (equal list0 '(a y z d e))))

(let* ((list0 (list 'a 'b 'c 'd 'e))
       (list (replace list0 '(x y z) :start1 1 :start2 1 :end2 nil)))
  (and (eq list0 list)
       (equal list0 '(a y z d e))))

(let* ((list0 (list 'a 'b 'c 'd 'e))
       (list (replace list0 '(x y z) :start1 1 :end1 nil :start2 1 :end2 nil)))
  (and (eq list0 list)
       (equal list0 '(a y z d e))))

(let* ((list0 (list 'a 'b 'c 'd 'e))
       (list (replace list0 '(x y z) :start1 1 :end1 2 :start2 1)))
  (and (eq list0 list)
       (equal list0 '(a y c d e))))

(let* ((list0 (list 'a 'b 'c 'd 'e))
       (list (replace list0 '(x y z) :start1 1 :end1 1)))
  (and (eq list0 list)
       (equal list0 '(a b c d e))))

(let* ((list0 (list 'a 'b 'c 'd 'e))
       (list (replace list0 '(x y z) :start1 2 :end1 2)))
  (and (eq list0 list)
       (equal list0 '(a b c d e))))

(let* ((list0 (list 'a 'b 'c 'd 'e))
       (list (replace list0 '(x y z) :start1 3 :end1 3)))
  (and (eq list0 list)
       (equal list0 '(a b c d e))))

(let* ((list0 (list 'a 'b 'c 'd 'e))
       (list (replace list0 '(x y z) :start1 4 :end1 4)))
  (and (eq list0 list)
       (equal list0 '(a b c d e))))

(let* ((list0 (list 'a 'b 'c 'd 'e))
       (list (replace list0 '(x y z) :start1 5 :end1 5)))
  (and (eq list0 list)
       (equal list0 '(a b c d e))))

(null (replace nil nil))
(null (replace nil '(a b c)))

(let* ((list0 (list 'a 'b 'c))
       (list (replace list0 '())))
  (and (eq list0 list)
       (equal list0 '(a b c))))

(let* ((list0 (list 'a 'b 'c 'd 'e))
       (list (replace list0 list0)))
  (and (eq list0 list)
       (equal list0 '(a b c d e))))

(let* ((list0 (list 'a 'b 'c 'd 'e))
       (list (replace list0 list0 :start1 3)))
  (and (eq list0 list)
       (equal list0 '(a b c a b))))

(let* ((list0 (list 'a 'b 'c 'd 'e))
       (list (replace list0 list0 :start1 1)))
  (and (eq list0 list)
       (equal list0 '(a a b c d))))

(let* ((list0 (list 'a 'b 'c 'd 'e))
       (list (replace list0 list0 :start1 1 :end1 3)))
  (and (eq list0 list)
       (equal list0 '(a a b d e))))

(let* ((list0 (list 'a 'b 'c))
       (list (replace list0 '(x y z))))
  (and (eq list0 list)
       (equal list0 '(x y z))))


(let* ((vector0 (vector 'a 'b 'c 'd 'e))
       (vector (replace vector0 '(x y z))))
  (and (eq vector0 vector)
       (equalp vector0 #(x y z d e))))

(let* ((vector0 (vector 'a 'b 'c 'd 'e))
       (vector (replace vector0 '(x y z) :start1 1)))
  (and (eq vector0 vector)
       (equalp vector0 #(a x y z e))))

(let* ((vector0 (vector 'a 'b 'c 'd 'e))
       (vector (replace vector0 '(x y z) :start1 1 :end1 nil)))
  (and (eq vector0 vector)
       (equalp vector0 #(a x y z e))))

(let* ((vector0 (vector 'a 'b 'c 'd 'e))
       (vector (replace vector0 '(x y z) :start1 1 :start2 1)))
  (and (eq vector0 vector)
       (equalp vector0 #(a y z d e))))

(let* ((vector0 (vector 'a 'b 'c 'd 'e))
       (vector (replace vector0 '(x y z) :start1 1 :start2 1 :end2 nil)))
  (and (eq vector0 vector)
       (equalp vector0 #(a y z d e))))

(let* ((vector0 (vector 'a 'b 'c 'd 'e))
       (vector (replace vector0 '(x y z) :start1 1 :end1 nil :start2 1 :end2 nil)))
  (and (eq vector0 vector)
       (equalp vector0 #(a y z d e))))

(let* ((vector0 (vector 'a 'b 'c 'd 'e))
       (vector (replace vector0 '(x y z) :start1 1 :end1 2 :start2 1)))
  (and (eq vector0 vector)
       (equalp vector0 #(a y c d e))))

(let* ((vector0 (vector 'a 'b 'c 'd 'e))
       (vector (replace vector0 '(x y z) :start1 1 :end1 1)))
  (and (eq vector0 vector)
       (equalp vector0 #(a b c d e))))

(let* ((vector0 (vector 'a 'b 'c 'd 'e))
       (vector (replace vector0 '(x y z) :start1 2 :end1 2)))
  (and (eq vector0 vector)
       (equalp vector0 #(a b c d e))))

(let* ((vector0 (vector 'a 'b 'c 'd 'e))
       (vector (replace vector0 '(x y z) :start1 3 :end1 3)))
  (and (eq vector0 vector)
       (equalp vector0 #(a b c d e))))

(let* ((vector0 (vector 'a 'b 'c 'd 'e))
       (vector (replace vector0 '(x y z) :start1 4 :end1 4)))
  (and (eq vector0 vector)
       (equalp vector0 #(a b c d e))))

(let* ((vector0 (vector 'a 'b 'c 'd 'e))
       (vector (replace vector0 '(x y z) :start1 5 :end1 5)))
  (and (eq vector0 vector)
       (equalp vector0 #(a b c d e))))

(null (replace nil #()))
(null (replace nil #(a b c)))

(let* ((vector0 (vector 'a 'b 'c))
       (vector (replace vector0 '())))
  (and (eq vector0 vector)
       (equalp vector0 #(a b c))))

(let* ((vector0 (vector 'a 'b 'c 'd 'e))
       (vector (replace vector0 vector0)))
  (and (eq vector0 vector)
       (equalp vector0 #(a b c d e))))

(let* ((vector0 (vector 'a 'b 'c 'd 'e))
       (vector (replace vector0 vector0 :start1 3)))
  (and (eq vector0 vector)
       (equalp vector0 #(a b c a b))))

(let* ((vector0 (vector 'a 'b 'c 'd 'e))
       (vector (replace vector0 vector0 :start1 1)))
  (and (eq vector0 vector)
       (equalp vector0 #(a a b c d))))

(let* ((vector0 (vector 'a 'b 'c 'd 'e))
       (vector (replace vector0 vector0 :start1 1 :end1 3)))
  (and (eq vector0 vector)
       (equalp vector0 #(a a b d e))))

(let* ((vector0 (vector 'a 'b 'c))
       (vector (replace vector0 '(x y z))))
  (and (eq vector0 vector)
       (equalp vector0 #(x y z))))


(let* ((vector0 (vector 'a 'b 'c 'd 'e))
       (vector (replace vector0 #(x y z))))
  (and (eq vector0 vector)
       (equalp vector0 #(x y z d e))))

(let* ((vector0 (vector 'a 'b 'c 'd 'e))
       (vector (replace vector0 #(x y z) :start1 1)))
  (and (eq vector0 vector)
       (equalp vector0 #(a x y z e))))

(let* ((vector0 (vector 'a 'b 'c 'd 'e))
       (vector (replace vector0 #(x y z) :start1 1 :end1 nil)))
  (and (eq vector0 vector)
       (equalp vector0 #(a x y z e))))

(let* ((vector0 (vector 'a 'b 'c 'd 'e))
       (vector (replace vector0 #(x y z) :start1 1 :start2 1)))
  (and (eq vector0 vector)
       (equalp vector0 #(a y z d e))))

(let* ((vector0 (vector 'a 'b 'c 'd 'e))
       (vector (replace vector0 #(x y z) :start1 1 :start2 1 :end2 nil)))
  (and (eq vector0 vector)
       (equalp vector0 #(a y z d e))))

(let* ((vector0 (vector 'a 'b 'c 'd 'e))
       (vector (replace vector0 #(x y z) :start1 1 :end1 nil :start2 1 :end2 nil)))
  (and (eq vector0 vector)
       (equalp vector0 #(a y z d e))))

(let* ((vector0 (vector 'a 'b 'c 'd 'e))
       (vector (replace vector0 #(x y z) :start1 1 :end1 2 :start2 1)))
  (and (eq vector0 vector)
       (equalp vector0 #(a y c d e))))

(let* ((vector0 (vector 'a 'b 'c 'd 'e))
       (vector (replace vector0 #(x y z) :start1 1 :end1 1)))
  (and (eq vector0 vector)
       (equalp vector0 #(a b c d e))))

(let* ((vector0 (vector 'a 'b 'c 'd 'e))
       (vector (replace vector0 #(x y z) :start1 2 :end1 2)))
  (and (eq vector0 vector)
       (equalp vector0 #(a b c d e))))

(let* ((vector0 (vector 'a 'b 'c 'd 'e))
       (vector (replace vector0 #(x y z) :start1 3 :end1 3)))
  (and (eq vector0 vector)
       (equalp vector0 #(a b c d e))))

(let* ((vector0 (vector 'a 'b 'c 'd 'e))
       (vector (replace vector0 #(x y z) :start1 4 :end1 4)))
  (and (eq vector0 vector)
       (equalp vector0 #(a b c d e))))

(let* ((vector0 (vector 'a 'b 'c 'd 'e))
       (vector (replace vector0 #(x y z) :start1 5 :end1 5)))
  (and (eq vector0 vector)
       (equalp vector0 #(a b c d e))))

(null (replace nil #()))
(null (replace nil #(a b c)))

(let* ((vector0 (vector 'a 'b 'c))
       (vector (replace vector0 #())))
  (and (eq vector0 vector)
       (equalp vector0 #(a b c))))

(let* ((vector0 (vector 'a 'b 'c 'd 'e))
       (vector (replace vector0 vector0)))
  (and (eq vector0 vector)
       (equalp vector0 #(a b c d e))))

(let* ((vector0 (vector 'a 'b 'c 'd 'e))
       (vector (replace vector0 vector0 :start1 3)))
  (and (eq vector0 vector)
       (equalp vector0 #(a b c a b))))

(let* ((vector0 (vector 'a 'b 'c 'd 'e))
       (vector (replace vector0 vector0 :start1 1)))
  (and (eq vector0 vector)
       (equalp vector0 #(a a b c d))))

(let* ((vector0 (vector 'a 'b 'c 'd 'e))
       (vector (replace vector0 vector0 :start1 1 :end1 3)))
  (and (eq vector0 vector)
       (equalp vector0 #(a a b d e))))

(let* ((vector0 (vector 'a 'b 'c))
       (vector (replace vector0 #(x y z))))
  (and (eq vector0 vector)
       (equalp vector0 #(x y z))))

(let* ((str0 (copy-seq "abc"))
       (str (replace str0 "xyz")))
  (and (eq str0 str)
       (equalp str0 "xyz")))

(let* ((str0 (copy-seq ""))
       (str (replace str0 "")))
  (and (eq str0 str)
       (equalp str0 "")))

(let* ((str0 (copy-seq ""))
       (str (replace str0 "xyz")))
  (and (eq str0 str)
       (equalp str0 "")))

(let* ((str0 (copy-seq "abc"))
       (str (replace str0 "")))
  (and (eq str0 str)
       (equalp str0 "abc")))

(let* ((str0 (copy-seq "abcdef"))
       (str (replace str0 "xyz" :start1 3)))
  (and (eq str0 str)
       (equalp str0 "abcxyz")))

(let* ((str0 (copy-seq "abcdef"))
       (str (replace str0 "xyz" :start1 4 :start2 1)))
  (and (eq str0 str)
       (equalp str0 "abcdyz")))

(let* ((str0 (copy-seq "abcdef"))
       (str (replace str0 "xyz" :start1 1 :end1 2 :start2 1)))
  (and (eq str0 str)
       (equalp str0 "aycdef")))

(let* ((str0 (copy-seq "abcdef"))
       (str (replace str0 "xyz" :start1 1 :start2 1 :end2 2)))
  (and (eq str0 str)
       (equalp str0 "aycdef")))

(let* ((str0 (copy-seq "abcdef"))
       (str (replace str0 str0 :start1 1)))
  (and (eq str0 str)
       (equalp str0 "aabcde")))


(let* ((bv0 (copy-seq #*0000))
       (bv (replace bv0 #*1010)))
  (and (eq bv0 bv)
       (equalp bv0 #*1010)))

(let* ((bv0 (copy-seq #*))
       (bv (replace bv0 #*1010)))
  (and (eq bv0 bv)
       (equalp bv0 #*)))

(let* ((bv0 (copy-seq #*0000))
       (bv (replace bv0 #*)))
  (and (eq bv0 bv)
       (equalp bv0 #*0000)))

(let* ((bv0 (copy-seq #*0000))
       (bv (replace bv0 #*1111 :start1 2)))
  (and (eq bv0 bv)
       (equalp bv0 #*0011)))

(let* ((bv0 (copy-seq #*1001))
       (bv (replace bv0 #*0110 :start1 1 :end1 3 :start2 1 :end2 3)))
  (and (eq bv0 bv)
       (equalp bv0 #*1111)))

(let* ((bv0 (copy-seq #*1010))
       (bv (replace bv0 bv0 :start1 1)))
  (and (eq bv0 bv)
       (equalp bv0 #*1101)))



(equal (substitute #\. #\SPACE "0 2 4 6") "0.2.4.6")
(equal (substitute 9 4 '(1 2 4 1 3 4 5)) '(1 2 9 1 3 9 5))
(equal (substitute 9 4 '(1 2 4 1 3 4 5) :count 1) '(1 2 9 1 3 4 5))
(equal (substitute 9 4 '(1 2 4 1 3 4 5) :count 1 :from-end t) '(1 2 4 1 3 9 5))
(equal (substitute 9 3 '(1 2 4 1 3 4 5) :test #'>) '(9 9 4 9 3 4 5))
(equal (substitute-if 0 #'evenp '((1) (2) (3) (4)) :start 2 :key #'car)
       '((1) (2) (3) 0))
(equal (substitute-if 9 #'oddp '(1 2 4 1 3 4 5)) '(9 2 4 9 9 4 9))
(equal (substitute-if 9 #'evenp '(1 2 4 1 3 4 5) :count 1 :from-end t)
       '(1 2 4 1 3 9 5))
(let ((some-things (list 'a 'car 'b 'cdr 'c)))
  (and (equal (nsubstitute-if "function was here" #'fboundp some-things
                              :count 1 :from-end t)
              '(A CAR B "function was here" C))
       (equal some-things '(A CAR B "function was here" C))))
(let ((alpha-tester (copy-seq "ab ")))
  (and (equal (nsubstitute-if-not #\z #'alpha-char-p alpha-tester) "abz")
       (equal alpha-tester "abz")))


(equal (substitute 'a 'x '(x y z)) '(a y z))
(equal (substitute 'b 'y '(x y z)) '(x b z))
(equal (substitute 'c 'z '(x y z)) '(x y c))
(equal (substitute 'a 'p '(x y z)) '(x y z))
(equal (substitute 'a 'x '()) '())
(equal (substitute #\x #\b '(#\a #\b #\c #\d #\e) :test #'char<)
       '(#\a #\b #\x #\x #\x))
(equal (substitute #\x #\b '(#\a #\b #\c #\d #\e)
                   :test-not (complement #'char<))
       '(#\a #\b #\x #\x #\x))
(equal (substitute '(a) 'x '((x) (y) (z)) :key #'car)
       '((a) (y) (z)))
(equal (substitute 'c 'b '(a b a b a b a b)) '(a c a c a c a c))
(equal (substitute 'a 'b '(b b b)) '(a a a))
(equal (substitute 'z 'x '(a x b x c x d x e x f))
       '(a z b z c z d z e z f))
(equal (substitute 'z 'x '(a x b x c x d x e x f) :count nil)
       '(a z b z c z d z e z f))
(equal (substitute 'z 'x '(a x b x c x d x e x f) :count 0)
       '(a x b x c x d x e x f))
(equal (substitute 'z 'x '(a x b x c x d x e x f) :count -100)
       '(a x b x c x d x e x f))
(equal (substitute 'z 'x '(a x b x c x d x e x f) :count 1)
       '(a z b x c x d x e x f))
(equal (substitute 'z 'x '(a x b x c x d x e x f) :count 2)
       '(a z b z c x d x e x f))
(equal (substitute 'z 'x '(a x b x c x d x e x f) :count 3)
       '(a z b z c z d x e x f))
(equal (substitute 'z 'x '(a x b x c x d x e x f) :count 4)
       '(a z b z c z d z e x f))
(equal (substitute 'z 'x '(a x b x c x d x e x f) :count 5)
       '(a z b z c z d z e z f))
(equal (substitute 'z 'x '(a x b x c x d x e x f) :count 6)
       '(a z b z c z d z e z f))
(equal (substitute 'z 'x '(a x b x c x d x e x f) :count 7)
       '(a z b z c z d z e z f))
(equal (substitute 'z 'x '(a x b x c x d x e x f) :count nil :from-end t)
       '(a z b z c z d z e z f))
(equal (substitute 'z 'x '(a x b x c x d x e x f) :count 0 :from-end t)
       '(a x b x c x d x e x f))
(equal (substitute 'z 'x '(a x b x c x d x e x f) :count -100 :from-end t)
       '(a x b x c x d x e x f))
(equal (substitute 'z 'x '(a x b x c x d x e x f) :count 1 :from-end t)
       '(a x b x c x d x e z f))
(equal (substitute 'z 'x '(a x b x c x d x e x f) :count 2 :from-end t)
       '(a x b x c x d z e z f))
(equal (substitute 'z 'x '(a x b x c x d x e x f) :count 3 :from-end t)
       '(a x b x c z d z e z f))
(equal (substitute 'z 'x '(a x b x c x d x e x f) :count 4 :from-end t)
       '(a x b z c z d z e z f))
(equal (substitute 'z 'x '(a x b x c x d x e x f) :count 5 :from-end t)
       '(a z b z c z d z e z f))
(equal (substitute 'z 'x '(a x b x c x d x e x f) :count 6 :from-end t)
       '(a z b z c z d z e z f))
(equal (substitute 'z 'x '(a x b x c x d x e x f) :count 7 :from-end t)
       '(a z b z c z d z e z f))
(equal (substitute 'z 'x '(a x b x c x d x e x f) :start 2 :count 1)
       '(a x b z c x d x e x f))
(equal (substitute 'z 'x '(a x b x c x d x e x f) :start 2 :end nil :count 1)
       '(a x b z c x d x e x f))
(equal (substitute 'z 'x '(a x b x c x d x e x f) :start 2 :end 6 :count 100)
       '(a x b z c z d x e x f))
(equal (substitute 'z 'x '(a x b x c x d x e x f) :start 2 :end 11 :count 100)
       '(a x b z c z d z e z f))
(equal (substitute 'z 'x '(a x b x c x d x e x f) :start 2 :end 8 :count 10)
       '(a x b z c z d z e x f))
(equal (substitute 'z 'x '(a x b x c x d x e x f)
                   :start 2 :end 8 :count 2 :from-end t)
       '(a x b x c z d z e x f))
(equal (substitute #\z #\c '(#\a #\b #\c #\d #\e #\f) :test #'char<)
       '(#\a #\b #\c #\z #\z #\z))
(equal (substitute #\z #\c '(#\a #\b #\c #\d #\e #\f)
                   :test-not (complement #'char<))
       '(#\a #\b #\c #\z #\z #\z))
(equal (substitute "peace" "war" '("love" "hate" "war" "peace") :test #'equal)
       '("love" "hate" "peace" "peace"))
(equal (substitute "peace" "war" '("love" "hate" "war" "peace")
                   :test-not (complement #'equal))
       '("love" "hate" "peace" "peace"))
(equal (substitute "peace" "war" '("war" "War" "WAr" "WAR")
                   :test #'string-equal)
       '("peace" "peace" "peace" "peace"))
(equal (substitute "peace" "war" '("war" "War" "WAr" "WAR")
                   :test-not (complement #'string-equal))
       '("peace" "peace" "peace" "peace"))
(equal (substitute "peace" "WAR" '("war" "War" "WAr" "WAR")
                   :test #'string=)
       '("war" "War" "WAr" "peace"))
(equal (substitute "peace" "WAR" '("war" "War" "WAr" "WAR")
                   :test-not (complement #'string=))
       '("war" "War" "WAr" "peace"))
(equal (substitute "peace" "WAR" '("war" "War" "WAr" "WAR")
                   :test #'string=
                   :key #'string-upcase)
       '("peace" "peace" "peace" "peace"))
(equal (substitute "peace" "WAR" '("war" "War" "WAr" "WAR")
                   :test-not (complement #'string=)
                   :key #'string-upcase)
       '("peace" "peace" "peace" "peace"))
(equal (substitute "peace" "WAR" '("war" "War" "WAr" "WAR")
                   :start 1
                   :end 2
                   :test #'string=
                   :key #'string-upcase)
       '("war" "peace" "WAr" "WAR"))
(equal (substitute "peace" "WAR" '("war" "War" "WAr" "WAR")
                   :start 1
                   :end 2
                   :test-not (complement #'string=)
                   :key #'string-upcase)
       '("war" "peace" "WAr" "WAR"))
(equal (substitute "peace" "WAR" '("war" "War" "WAr" "WAR")
                   :start 1
                   :end nil
                   :test #'string=
                   :key #'string-upcase)
       '("war" "peace" "peace" "peace"))
(equal (substitute "peace" "WAR" '("war" "War" "WAr" "WAR")
                   :start 1
                   :end nil
                   :test-not (complement #'string=)
                   :key #'string-upcase)
       '("war" "peace" "peace" "peace"))
(equal (substitute "peace" "war" '("war" "War" "WAr" "WAR")
                   :test #'string=
                   :key #'string-upcase)
       '("war" "War" "WAr" "WAR"))
(equal (substitute "peace" "war" '("war" "War" "WAr" "WAR")
                   :test-not (complement #'string=)
                   :key #'string-upcase)
       '("war" "War" "WAr" "WAR"))
(equal (substitute "peace" "WAR"
                   '("war" "War" "WAr" "WAR" "war" "War" "WAr" "WAR")
                   :start 1
                   :end 7
                   :count 1
                   :test-not (complement #'string=)
                   :key #'string-upcase)
       '("war" "peace" "WAr" "WAR" "war" "War" "WAr" "WAR"))
(equal (substitute "peace" "WAR"
                   '("war" "War" "WAr" "WAR" "war" "War" "WAr" "WAR")
                   :start 1
                   :end 7
                   :count 2
                   :test-not (complement #'string=)
                   :key #'string-upcase)
       '("war" "peace" "peace" "WAR" "war" "War" "WAr" "WAR"))
(equal (substitute "peace" "WAR"
                   '("war" "War" "WAr" "WAR" "war" "War" "WAr" "WAR")
                   :start 1
                   :end 7
                   :count 2
                   :from-end t
                   :test-not (complement #'string=)
                   :key #'string-upcase)
       '("war" "War" "WAr" "WAR" "war" "peace" "peace" "WAR"))
(equal (substitute "peace" "WAR"
                   '("war" "War" "WAr" "WAR" "war" "War" "WAr" "WAR")
                   :start 1
                   :end 7
                   :count 0
                   :from-end t
                   :test-not (complement #'string=)
                   :key #'string-upcase)
       '("war" "War" "WAr" "WAR" "war" "War" "WAr" "WAR"))
(equal (substitute "peace" "WAR"
                   '("war" "War" "WAr" "WAR" "war" "War" "WAr" "WAR")
                   :start 1
                   :end 7
                   :count -2
                   :from-end t
                   :test-not (complement #'string=)
                   :key #'string-upcase)
       '("war" "War" "WAr" "WAR" "war" "War" "WAr" "WAR"))
(equal (substitute "peace" "WAR"
                   '("war" "War" "WAr" "WAR" "war" "War" "WAr" "WAR")
                   :start 1
                   :end 7
                   :count nil
                   :from-end t
                   :test-not (complement #'string=)
                   :key #'string-upcase)
       '("war" "peace" "peace" "peace" "peace" "peace" "peace" "WAR"))
(equal (substitute "peace" "WAR"
                   '("war" "War" "WAr" "WAR" "war" "War" "WAr" "WAR")
                   :start 1
                   :end 7
                   :count 6
                   :from-end t
                   :test-not (complement #'string=)
                   :key #'string-upcase)
       '("war" "peace" "peace" "peace" "peace" "peace" "peace" "WAR"))
(equal (substitute "peace" "WAR"
                   '("war" "War" "WAr" "WAR" "war" "War" "WAr" "WAR")
                   :start 1
                   :end 7
                   :count 7
                   :from-end t
                   :test-not (complement #'string=)
                   :key #'string-upcase)
       '("war" "peace" "peace" "peace" "peace" "peace" "peace" "WAR"))
(equal (substitute "peace" "WAR"
                   '("war" "War" "WAr" "WAR" "war" "War" "WAr" "WAR")
                   :start 1
                   :end 7
                   :count 100
                   :from-end t
                   :test-not (complement #'string=)
                   :key #'string-upcase)
       '("war" "peace" "peace" "peace" "peace" "peace" "peace" "WAR"))


(equalp (substitute 'a 'x #(x y z)) #(a y z))
(equalp (substitute 'b 'y #(x y z)) #(x b z))
(equalp (substitute 'c 'z #(x y z)) #(x y c))
(equalp (substitute 'a 'p #(x y z)) #(x y z))
(equalp (substitute 'a 'x #()) #())
(equalp (substitute #\x #\b #(#\a #\b #\c #\d #\e) :test #'char<)
        #(#\a #\b #\x #\x #\x))
(equalp (substitute #\x #\b #(#\a #\b #\c #\d #\e)
                   :test-not (complement #'char<))
       #(#\a #\b #\x #\x #\x))
(equalp (substitute '(a) 'x #((x) (y) (z)) :key #'car)
       #((a) (y) (z)))
(equalp (substitute 'c 'b #(a b a b a b a b)) #(a c a c a c a c))
(equalp (substitute 'a 'b #(b b b)) #(a a a))
(equalp (substitute 'z 'x #(a x b x c x d x e x f))
        #(a z b z c z d z e z f))
(equalp (substitute 'z 'x #(a x b x c x d x e x f) :count nil)
        #(a z b z c z d z e z f))
(equalp (substitute 'z 'x #(a x b x c x d x e x f) :count 0)
        #(a x b x c x d x e x f))
(equalp (substitute 'z 'x #(a x b x c x d x e x f) :count -100)
        #(a x b x c x d x e x f))
(equalp (substitute 'z 'x #(a x b x c x d x e x f) :count 1)
        #(a z b x c x d x e x f))
(equalp (substitute 'z 'x #(a x b x c x d x e x f) :count 2)
        #(a z b z c x d x e x f))
(equalp (substitute 'z 'x #(a x b x c x d x e x f) :count 3)
        #(a z b z c z d x e x f))
(equalp (substitute 'z 'x #(a x b x c x d x e x f) :count 4)
        #(a z b z c z d z e x f))
(equalp (substitute 'z 'x #(a x b x c x d x e x f) :count 5)
        #(a z b z c z d z e z f))
(equalp (substitute 'z 'x #(a x b x c x d x e x f) :count 6)
        #(a z b z c z d z e z f))
(equalp (substitute 'z 'x #(a x b x c x d x e x f) :count 7)
        #(a z b z c z d z e z f))
(equalp (substitute 'z 'x #(a x b x c x d x e x f) :count nil :from-end t)
        #(a z b z c z d z e z f))
(equalp (substitute 'z 'x #(a x b x c x d x e x f) :count 0 :from-end t)
        #(a x b x c x d x e x f))
(equalp (substitute 'z 'x #(a x b x c x d x e x f) :count -100 :from-end t)
        #(a x b x c x d x e x f))
(equalp (substitute 'z 'x #(a x b x c x d x e x f) :count 1 :from-end t)
        #(a x b x c x d x e z f))
(equalp (substitute 'z 'x #(a x b x c x d x e x f) :count 2 :from-end t)
        #(a x b x c x d z e z f))
(equalp (substitute 'z 'x #(a x b x c x d x e x f) :count 3 :from-end t)
        #(a x b x c z d z e z f))
(equalp (substitute 'z 'x #(a x b x c x d x e x f) :count 4 :from-end t)
        #(a x b z c z d z e z f))
(equalp (substitute 'z 'x #(a x b x c x d x e x f) :count 5 :from-end t)
        #(a z b z c z d z e z f))
(equalp (substitute 'z 'x #(a x b x c x d x e x f) :count 6 :from-end t)
        #(a z b z c z d z e z f))
(equalp (substitute 'z 'x #(a x b x c x d x e x f) :count 7 :from-end t)
        #(a z b z c z d z e z f))
(equalp (substitute 'z 'x #(a x b x c x d x e x f) :start 2 :count 1)
       #(a x b z c x d x e x f))
(equalp (substitute 'z 'x #(a x b x c x d x e x f) :start 2 :end nil :count 1)
       #(a x b z c x d x e x f))
(equalp (substitute 'z 'x #(a x b x c x d x e x f) :start 2 :end 6 :count 100)
       #(a x b z c z d x e x f))
(equalp (substitute 'z 'x #(a x b x c x d x e x f) :start 2 :end 11 :count 100)
       #(a x b z c z d z e z f))
(equalp (substitute 'z 'x #(a x b x c x d x e x f) :start 2 :end 8 :count 10)
       #(a x b z c z d z e x f))
(equalp (substitute 'z 'x #(a x b x c x d x e x f)
                   :start 2 :end 8 :count 2 :from-end t)
       #(a x b x c z d z e x f))
(equalp (substitute #\z #\c #(#\a #\b #\c #\d #\e #\f) :test #'char<)
       #(#\a #\b #\c #\z #\z #\z))
(equalp (substitute #\z #\c #(#\a #\b #\c #\d #\e #\f)
                   :test-not (complement #'char<))
       #(#\a #\b #\c #\z #\z #\z))
(equalp (substitute "peace" "war" #("love" "hate" "war" "peace") :test #'equal)
       #("love" "hate" "peace" "peace"))
(equalp (substitute "peace" "war" #("love" "hate" "war" "peace")
                   :test-not (complement #'equal))
       #("love" "hate" "peace" "peace"))
(equalp (substitute "peace" "war" #("war" "War" "WAr" "WAR")
                   :test #'string-equal)
       #("peace" "peace" "peace" "peace"))
(equalp (substitute "peace" "war" #("war" "War" "WAr" "WAR")
                   :test-not (complement #'string-equal))
       #("peace" "peace" "peace" "peace"))
(equalp (substitute "peace" "WAR" #("war" "War" "WAr" "WAR")
                   :test #'string=)
       #("war" "War" "WAr" "peace"))
(equalp (substitute "peace" "WAR" #("war" "War" "WAr" "WAR")
                   :test-not (complement #'string=))
       #("war" "War" "WAr" "peace"))
(equalp (substitute "peace" "WAR" #("war" "War" "WAr" "WAR")
                   :test #'string=
                   :key #'string-upcase)
       #("peace" "peace" "peace" "peace"))
(equalp (substitute "peace" "WAR" #("war" "War" "WAr" "WAR")
                   :test-not (complement #'string=)
                   :key #'string-upcase)
       #("peace" "peace" "peace" "peace"))
(equalp (substitute "peace" "WAR" #("war" "War" "WAr" "WAR")
                   :start 1
                   :end 2
                   :test #'string=
                   :key #'string-upcase)
       #("war" "peace" "WAr" "WAR"))
(equalp (substitute "peace" "WAR" #("war" "War" "WAr" "WAR")
                   :start 1
                   :end 2
                   :test-not (complement #'string=)
                   :key #'string-upcase)
       #("war" "peace" "WAr" "WAR"))
(equalp (substitute "peace" "WAR" #("war" "War" "WAr" "WAR")
                   :start 1
                   :end nil
                   :test #'string=
                   :key #'string-upcase)
       #("war" "peace" "peace" "peace"))
(equalp (substitute "peace" "WAR" #("war" "War" "WAr" "WAR")
                   :start 1
                   :end nil
                   :test-not (complement #'string=)
                   :key #'string-upcase)
       #("war" "peace" "peace" "peace"))
(equalp (substitute "peace" "war" #("war" "War" "WAr" "WAR")
                   :test #'string=
                   :key #'string-upcase)
       #("war" "War" "WAr" "WAR"))
(equalp (substitute "peace" "war" #("war" "War" "WAr" "WAR")
                   :test-not (complement #'string=)
                   :key #'string-upcase)
       #("war" "War" "WAr" "WAR"))
(equalp (substitute "peace" "WAR"
                   #("war" "War" "WAr" "WAR" "war" "War" "WAr" "WAR")
                   :start 1
                   :end 7
                   :count 1
                   :test-not (complement #'string=)
                   :key #'string-upcase)
       #("war" "peace" "WAr" "WAR" "war" "War" "WAr" "WAR"))
(equalp (substitute "peace" "WAR"
                   #("war" "War" "WAr" "WAR" "war" "War" "WAr" "WAR")
                   :start 1
                   :end 7
                   :count 2
                   :test-not (complement #'string=)
                   :key #'string-upcase)
       #("war" "peace" "peace" "WAR" "war" "War" "WAr" "WAR"))
(equalp (substitute "peace" "WAR"
                   #("war" "War" "WAr" "WAR" "war" "War" "WAr" "WAR")
                   :start 1
                   :end 7
                   :count 2
                   :from-end t
                   :test-not (complement #'string=)
                   :key #'string-upcase)
       #("war" "War" "WAr" "WAR" "war" "peace" "peace" "WAR"))
(equalp (substitute "peace" "WAR"
                   #("war" "War" "WAr" "WAR" "war" "War" "WAr" "WAR")
                   :start 1
                   :end 7
                   :count 0
                   :from-end t
                   :test-not (complement #'string=)
                   :key #'string-upcase)
       #("war" "War" "WAr" "WAR" "war" "War" "WAr" "WAR"))
(equalp (substitute "peace" "WAR"
                   #("war" "War" "WAr" "WAR" "war" "War" "WAr" "WAR")
                   :start 1
                   :end 7
                   :count -2
                   :from-end t
                   :test-not (complement #'string=)
                   :key #'string-upcase)
       #("war" "War" "WAr" "WAR" "war" "War" "WAr" "WAR"))
(equalp (substitute "peace" "WAR"
                   #("war" "War" "WAr" "WAR" "war" "War" "WAr" "WAR")
                   :start 1
                   :end 7
                   :count nil
                   :from-end t
                   :test-not (complement #'string=)
                   :key #'string-upcase)
       #("war" "peace" "peace" "peace" "peace" "peace" "peace" "WAR"))
(equalp (substitute "peace" "WAR"
                   #("war" "War" "WAr" "WAR" "war" "War" "WAr" "WAR")
                   :start 1
                   :end 7
                   :count 6
                   :from-end t
                   :test-not (complement #'string=)
                   :key #'string-upcase)
       #("war" "peace" "peace" "peace" "peace" "peace" "peace" "WAR"))
(equalp (substitute "peace" "WAR"
                   #("war" "War" "WAr" "WAR" "war" "War" "WAr" "WAR")
                   :start 1
                   :end 7
                   :count 7
                   :from-end t
                   :test-not (complement #'string=)
                   :key #'string-upcase)
       #("war" "peace" "peace" "peace" "peace" "peace" "peace" "WAR"))
(equalp (substitute "peace" "WAR"
                   #("war" "War" "WAr" "WAR" "war" "War" "WAr" "WAR")
                   :start 1
                   :end 7
                   :count 100
                   :from-end t
                   :test-not (complement #'string=)
                   :key #'string-upcase)
       #("war" "peace" "peace" "peace" "peace" "peace" "peace" "WAR"))
(string= (substitute #\A #\a "abcabc") "AbcAbc")
(string= (substitute #\A #\a "") "")
(string= (substitute #\A #\a "xyz") "xyz")
(string= (substitute #\A #\a "aaaaaaaaaa" :start 5 :end nil) "aaaaaAAAAA")
(string= (substitute #\x #\5 "0123456789" :test #'char<) "012345xxxx")
(string= (substitute #\x #\5 "0123456789" :test #'char>) "xxxxx56789")
(string= (substitute #\x #\D "abcdefg"
                     :key #'char-upcase
                     :test #'char>)
         "xxxdefg")
(string= (substitute #\x #\D "abcdefg"
                     :start 1
                     :end 2
                     :key #'char-upcase
                     :test #'char>)
         "axcdefg")
(string= (substitute #\A #\a "aaaaaaaaaa" :count 2) "AAaaaaaaaa")
(string= (substitute #\A #\a "aaaaaaaaaa" :count -1) "aaaaaaaaaa")
(string= (substitute #\A #\a "aaaaaaaaaa" :count 0) "aaaaaaaaaa")
(string= (substitute #\A #\a "aaaaaaaaaa" :count nil) "AAAAAAAAAA")
(string= (substitute #\A #\a "aaaaaaaaaa" :count 100) "AAAAAAAAAA")
(string= (substitute #\A #\a "aaaaaaaaaa" :count 9) "AAAAAAAAAa")
(string= (substitute #\A #\a "aaaaaaaaaa" :count 9 :from-end t) "aAAAAAAAAA")
(string= (substitute #\A #\a "aaaaaaaaaa"
                     :start 2
                     :end 8
                     :count 3)
         "aaAAAaaaaa")
(string= (substitute #\A #\a "aaaaaaaaaa"
                     :start 2
                     :end 8
                     :from-end t
                     :count 3)
         "aaaaaAAAaa")
(string= (substitute #\x #\A "aaaaaaaaaa"
                     :start 2
                     :end 8
                     :from-end t
                     :count 3)
         "aaaaaaaaaa")
(string= (substitute #\X #\A "aaaaaaaaaa"
                     :start 2
                     :end 8
                     :from-end t
                     :key #'char-upcase
                     :count 3)
         "aaaaaXXXaa")
(string= (substitute #\X #\D "abcdefghij"
                     :start 2
                     :end 8
                     :from-end t
                     :key #'char-upcase
                     :test #'char<
                     :count 3)
         "abcdeXXXij")
(equalp (substitute 0 1 #*1111) #*0000)
(equalp (substitute 0 1 #*1111 :start 1 :end nil) #*1000)
(equalp (substitute 0 1 #*1111 :start 1 :end 3) #*1001)
(equalp (substitute 0 1 #*11111111 :start 1 :end 7) #*10000001)
(equalp (substitute 0 1 #*11111111 :start 1 :end 7 :count 3) #*10001111)
(equalp (substitute 0 1 #*11111111 :start 1 :end 7 :count 3 :from-end t)
        #*11110001)
(equalp (substitute 1 1 #*10101010
                    :start 1 :end 7 :count 3 :from-end t
                    :key #'(lambda (x) (if (zerop x) 1 0)))
        #*11111110)
(equalp (substitute 1 1 #*10101010
                    :start 1 :end 7 :count 3 :from-end t
                    :key #'(lambda (x) (if (zerop x) 1 0))
                    :test #'>=)
        #*10101110)



(equal (substitute-if 'a #'(lambda (arg) (eq arg 'x)) '(x y z)) '(a y z))
(equal (substitute-if 'b #'(lambda (arg) (eq arg 'y)) '(x y z)) '(x b z))
(equal (substitute-if 'c #'(lambda (arg) (eq arg 'z)) '(x y z)) '(x y c))
(equal (substitute-if 'a #'(lambda (arg) (eq arg 'p)) '(x y z)) '(x y z))
(equal (substitute-if 'a #'(lambda (arg) (eq arg 'x)) '()) '())
(equal (substitute-if #\x #'(lambda (arg) (char< #\b arg))
                      '(#\a #\b #\c #\d #\e))
       '(#\a #\b #\x #\x #\x))
(equal (substitute-if '(a) #'(lambda (arg) (eq arg 'x))
                      '((x) (y) (z)) :key #'car)
       '((a) (y) (z)))
(equal (substitute-if 'c #'(lambda (arg) (eq arg 'b))
                      '(a b a b a b a b)) '(a c a c a c a c))
(equal (substitute-if 'a #'(lambda (arg) (eq arg 'b))
                      '(b b b)) '(a a a))
(equal (substitute-if 'z #'(lambda (arg) (eq arg 'x))
                      '(a x b x c x d x e x f))
       '(a z b z c z d z e z f))
(equal (substitute-if 'z #'(lambda (arg) (eq arg 'x))
                      '(a x b x c x d x e x f) :count nil)
       '(a z b z c z d z e z f))
(equal (substitute-if 'z #'(lambda (arg) (eq arg 'x))
                      '(a x b x c x d x e x f) :count 0)
       '(a x b x c x d x e x f))
(equal (substitute-if 'z #'(lambda (arg) (eq arg 'x))
                      '(a x b x c x d x e x f) :count -100)
       '(a x b x c x d x e x f))
(equal (substitute-if 'z #'(lambda (arg) (eq arg 'x))
                      '(a x b x c x d x e x f) :count 1)
       '(a z b x c x d x e x f))
(equal (substitute-if 'z #'(lambda (arg) (eq arg 'x))
                      '(a x b x c x d x e x f) :count 2)
       '(a z b z c x d x e x f))
(equal (substitute-if 'z #'(lambda (arg) (eq arg 'x))
                      '(a x b x c x d x e x f) :count 3)
       '(a z b z c z d x e x f))
(equal (substitute-if 'z #'(lambda (arg) (eq arg 'x))
                      '(a x b x c x d x e x f) :count 4)
       '(a z b z c z d z e x f))
(equal (substitute-if 'z #'(lambda (arg) (eq arg 'x))
                      '(a x b x c x d x e x f) :count 5)
       '(a z b z c z d z e z f))
(equal (substitute-if 'z #'(lambda (arg) (eq arg 'x))
                      '(a x b x c x d x e x f) :count 6)
       '(a z b z c z d z e z f))
(equal (substitute-if 'z #'(lambda (arg) (eq arg 'x))
                      '(a x b x c x d x e x f) :count 7)
       '(a z b z c z d z e z f))
(equal (substitute-if 'z #'(lambda (arg) (eq arg 'x))
                      '(a x b x c x d x e x f) :count nil :from-end t)
       '(a z b z c z d z e z f))
(equal (substitute-if 'z #'(lambda (arg) (eq arg 'x))
                      '(a x b x c x d x e x f) :count 0 :from-end t)
       '(a x b x c x d x e x f))
(equal (substitute-if 'z #'(lambda (arg) (eq arg 'x))
                      '(a x b x c x d x e x f) :count -100 :from-end t)
       '(a x b x c x d x e x f))
(equal (substitute-if 'z #'(lambda (arg) (eq arg 'x))
                      '(a x b x c x d x e x f) :count 1 :from-end t)
       '(a x b x c x d x e z f))
(equal (substitute-if 'z #'(lambda (arg) (eq arg 'x))
                      '(a x b x c x d x e x f) :count 2 :from-end t)
       '(a x b x c x d z e z f))
(equal (substitute-if 'z #'(lambda (arg) (eq arg 'x))
                      '(a x b x c x d x e x f) :count 3 :from-end t)
       '(a x b x c z d z e z f))
(equal (substitute-if 'z #'(lambda (arg) (eq arg 'x))
                      '(a x b x c x d x e x f) :count 4 :from-end t)
       '(a x b z c z d z e z f))
(equal (substitute-if 'z #'(lambda (arg) (eq arg 'x))
                      '(a x b x c x d x e x f) :count 5 :from-end t)
       '(a z b z c z d z e z f))
(equal (substitute-if 'z #'(lambda (arg) (eq arg 'x))
                      '(a x b x c x d x e x f) :count 6 :from-end t)
       '(a z b z c z d z e z f))
(equal (substitute-if 'z #'(lambda (arg) (eq arg 'x))
                      '(a x b x c x d x e x f) :count 7 :from-end t)
       '(a z b z c z d z e z f))
(equal (substitute-if 'z #'(lambda (arg) (eq arg 'x))
                      '(a x b x c x d x e x f) :start 2 :count 1)
       '(a x b z c x d x e x f))
(equal (substitute-if 'z #'(lambda (arg) (eq arg 'x))
                      '(a x b x c x d x e x f) :start 2 :end nil :count 1)
       '(a x b z c x d x e x f))
(equal (substitute-if 'z #'(lambda (arg) (eq arg 'x))
                      '(a x b x c x d x e x f) :start 2 :end 6 :count 100)
       '(a x b z c z d x e x f))
(equal (substitute-if 'z #'(lambda (arg) (eq arg 'x))
                      '(a x b x c x d x e x f) :start 2 :end 11 :count 100)
       '(a x b z c z d z e z f))
(equal (substitute-if 'z #'(lambda (arg) (eq arg 'x))
                      '(a x b x c x d x e x f) :start 2 :end 8 :count 10)
       '(a x b z c z d z e x f))
(equal (substitute-if 'z #'(lambda (arg) (eq arg 'x))
                      '(a x b x c x d x e x f)
                   :start 2 :end 8 :count 2 :from-end t)
       '(a x b x c z d z e x f))
(equal (substitute-if #\z #'(lambda (arg) (char< #\c arg))
                      '(#\a #\b #\c #\d #\e #\f))
       '(#\a #\b #\c #\z #\z #\z))
(equal (substitute-if "peace" #'(lambda (arg) (equal "war" arg))
                      '("love" "hate" "war" "peace"))
       '("love" "hate" "peace" "peace"))
(equal (substitute-if "peace" #'(lambda (arg) (string-equal "war" arg))
                      '("war" "War" "WAr" "WAR"))
       '("peace" "peace" "peace" "peace"))
(equal (substitute-if "peace" #'(lambda (arg) (string= "WAR" arg))
                      '("war" "War" "WAr" "WAR")
                      :key #'string-upcase)
       '("peace" "peace" "peace" "peace"))
(equal (substitute-if "peace" #'(lambda (arg) (string= "WAR" arg))
                      '("war" "War" "WAr" "WAR")
                      :start 1
                      :end 2
                      :key #'string-upcase)
       '("war" "peace" "WAr" "WAR"))
(equal (substitute-if "peace" #'(lambda (arg) (string= "WAR" arg))
                      '("war" "War" "WAr" "WAR")
                      :start 1
                      :end nil
                      :key #'string-upcase)
       '("war" "peace" "peace" "peace"))
(equal (substitute-if "peace" #'(lambda (arg) (string= "war" arg))
                      '("war" "War" "WAr" "WAR")
                      :key #'string-upcase)
       '("war" "War" "WAr" "WAR"))
(equal (substitute-if "peace" #'(lambda (arg) (string= "WAR" arg))
                   '("war" "War" "WAr" "WAR" "war" "War" "WAr" "WAR")
                   :start 1
                   :end 7
                   :count 1
                   :key #'string-upcase)
       '("war" "peace" "WAr" "WAR" "war" "War" "WAr" "WAR"))
(equal (substitute-if "peace" #'(lambda (arg) (string= "WAR" arg))
                   '("war" "War" "WAr" "WAR" "war" "War" "WAr" "WAR")
                   :start 1
                   :end 7
                   :count 2
                   :key #'string-upcase)
       '("war" "peace" "peace" "WAR" "war" "War" "WAr" "WAR"))
(equal (substitute-if "peace" #'(lambda (arg) (string= "WAR" arg))
                   '("war" "War" "WAr" "WAR" "war" "War" "WAr" "WAR")
                   :start 1
                   :end 7
                   :count 2
                   :from-end t
                   :key #'string-upcase)
       '("war" "War" "WAr" "WAR" "war" "peace" "peace" "WAR"))
(equal (substitute-if "peace" #'(lambda (arg) (string= "WAR" arg))
                   '("war" "War" "WAr" "WAR" "war" "War" "WAr" "WAR")
                   :start 1
                   :end 7
                   :count 0
                   :from-end t
                   :key #'string-upcase)
       '("war" "War" "WAr" "WAR" "war" "War" "WAr" "WAR"))
(equal (substitute-if "peace" #'(lambda (arg) (string= "WAR" arg))
                   '("war" "War" "WAr" "WAR" "war" "War" "WAr" "WAR")
                   :start 1
                   :end 7
                   :count -2
                   :from-end t
                   :key #'string-upcase)
       '("war" "War" "WAr" "WAR" "war" "War" "WAr" "WAR"))
(equal (substitute-if "peace" #'(lambda (arg) (string= "WAR" arg))
                   '("war" "War" "WAr" "WAR" "war" "War" "WAr" "WAR")
                   :start 1
                   :end 7
                   :count nil
                   :from-end t
                   :key #'string-upcase)
       '("war" "peace" "peace" "peace" "peace" "peace" "peace" "WAR"))
(equal (substitute-if "peace" #'(lambda (arg) (string= "WAR" arg))
                   '("war" "War" "WAr" "WAR" "war" "War" "WAr" "WAR")
                   :start 1
                   :end 7
                   :count 6
                   :from-end t
                   :key #'string-upcase)
       '("war" "peace" "peace" "peace" "peace" "peace" "peace" "WAR"))
(equal (substitute-if "peace" #'(lambda (arg) (string= "WAR" arg))
                   '("war" "War" "WAr" "WAR" "war" "War" "WAr" "WAR")
                   :start 1
                   :end 7
                   :count 7
                   :from-end t
                   :key #'string-upcase)
       '("war" "peace" "peace" "peace" "peace" "peace" "peace" "WAR"))
(equal (substitute-if "peace" #'(lambda (arg) (string= "WAR" arg))
                   '("war" "War" "WAr" "WAR" "war" "War" "WAr" "WAR")
                   :start 1
                   :end 7
                   :count 100
                   :from-end t
                   :key #'string-upcase)
       '("war" "peace" "peace" "peace" "peace" "peace" "peace" "WAR"))


(equalp (substitute-if 'a #'(lambda (arg) (eq arg 'x)) #(x y z)) #(a y z))
(equalp (substitute-if 'b #'(lambda (arg) (eq arg 'y)) #(x y z)) #(x b z))
(equalp (substitute-if 'c #'(lambda (arg) (eq arg 'z)) #(x y z)) #(x y c))
(equalp (substitute-if 'a #'(lambda (arg) (eq arg 'p)) #(x y z)) #(x y z))
(equalp (substitute-if 'a #'(lambda (arg) (eq arg 'x)) #()) #())
(equalp (substitute-if #\x #'(lambda (arg) (char< #\b arg))
                      #(#\a #\b #\c #\d #\e))
       #(#\a #\b #\x #\x #\x))
(equalp (substitute-if '(a) #'(lambda (arg) (eq arg 'x))
                      #((x) (y) (z)) :key #'car)
       #((a) (y) (z)))
(equalp (substitute-if 'c #'(lambda (arg) (eq arg 'b))
                      #(a b a b a b a b)) #(a c a c a c a c))
(equalp (substitute-if 'a #'(lambda (arg) (eq arg 'b))
                      #(b b b)) #(a a a))
(equalp (substitute-if 'z #'(lambda (arg) (eq arg 'x))
                      #(a x b x c x d x e x f))
       #(a z b z c z d z e z f))
(equalp (substitute-if 'z #'(lambda (arg) (eq arg 'x))
                      #(a x b x c x d x e x f) :count nil)
       #(a z b z c z d z e z f))
(equalp (substitute-if 'z #'(lambda (arg) (eq arg 'x))
                      #(a x b x c x d x e x f) :count 0)
       #(a x b x c x d x e x f))
(equalp (substitute-if 'z #'(lambda (arg) (eq arg 'x))
                      #(a x b x c x d x e x f) :count -100)
       #(a x b x c x d x e x f))
(equalp (substitute-if 'z #'(lambda (arg) (eq arg 'x))
                      #(a x b x c x d x e x f) :count 1)
       #(a z b x c x d x e x f))
(equalp (substitute-if 'z #'(lambda (arg) (eq arg 'x))
                      #(a x b x c x d x e x f) :count 2)
       #(a z b z c x d x e x f))
(equalp (substitute-if 'z #'(lambda (arg) (eq arg 'x))
                      #(a x b x c x d x e x f) :count 3)
       #(a z b z c z d x e x f))
(equalp (substitute-if 'z #'(lambda (arg) (eq arg 'x))
                      #(a x b x c x d x e x f) :count 4)
       #(a z b z c z d z e x f))
(equalp (substitute-if 'z #'(lambda (arg) (eq arg 'x))
                      #(a x b x c x d x e x f) :count 5)
       #(a z b z c z d z e z f))
(equalp (substitute-if 'z #'(lambda (arg) (eq arg 'x))
                      #(a x b x c x d x e x f) :count 6)
       #(a z b z c z d z e z f))
(equalp (substitute-if 'z #'(lambda (arg) (eq arg 'x))
                      #(a x b x c x d x e x f) :count 7)
       #(a z b z c z d z e z f))
(equalp (substitute-if 'z #'(lambda (arg) (eq arg 'x))
                      #(a x b x c x d x e x f) :count nil :from-end t)
       #(a z b z c z d z e z f))
(equalp (substitute-if 'z #'(lambda (arg) (eq arg 'x))
                      #(a x b x c x d x e x f) :count 0 :from-end t)
       #(a x b x c x d x e x f))
(equalp (substitute-if 'z #'(lambda (arg) (eq arg 'x))
                      #(a x b x c x d x e x f) :count -100 :from-end t)
       #(a x b x c x d x e x f))
(equalp (substitute-if 'z #'(lambda (arg) (eq arg 'x))
                      #(a x b x c x d x e x f) :count 1 :from-end t)
       #(a x b x c x d x e z f))
(equalp (substitute-if 'z #'(lambda (arg) (eq arg 'x))
                      #(a x b x c x d x e x f) :count 2 :from-end t)
       #(a x b x c x d z e z f))
(equalp (substitute-if 'z #'(lambda (arg) (eq arg 'x))
                      #(a x b x c x d x e x f) :count 3 :from-end t)
       #(a x b x c z d z e z f))
(equalp (substitute-if 'z #'(lambda (arg) (eq arg 'x))
                      #(a x b x c x d x e x f) :count 4 :from-end t)
       #(a x b z c z d z e z f))
(equalp (substitute-if 'z #'(lambda (arg) (eq arg 'x))
                      #(a x b x c x d x e x f) :count 5 :from-end t)
       #(a z b z c z d z e z f))
(equalp (substitute-if 'z #'(lambda (arg) (eq arg 'x))
                      #(a x b x c x d x e x f) :count 6 :from-end t)
       #(a z b z c z d z e z f))
(equalp (substitute-if 'z #'(lambda (arg) (eq arg 'x))
                      #(a x b x c x d x e x f) :count 7 :from-end t)
       #(a z b z c z d z e z f))
(equalp (substitute-if 'z #'(lambda (arg) (eq arg 'x))
                      #(a x b x c x d x e x f) :start 2 :count 1)
       #(a x b z c x d x e x f))
(equalp (substitute-if 'z #'(lambda (arg) (eq arg 'x))
                      #(a x b x c x d x e x f) :start 2 :end nil :count 1)
       #(a x b z c x d x e x f))
(equalp (substitute-if 'z #'(lambda (arg) (eq arg 'x))
                      #(a x b x c x d x e x f) :start 2 :end 6 :count 100)
       #(a x b z c z d x e x f))
(equalp (substitute-if 'z #'(lambda (arg) (eq arg 'x))
                      #(a x b x c x d x e x f) :start 2 :end 11 :count 100)
       #(a x b z c z d z e z f))
(equalp (substitute-if 'z #'(lambda (arg) (eq arg 'x))
                      #(a x b x c x d x e x f) :start 2 :end 8 :count 10)
       #(a x b z c z d z e x f))
(equalp (substitute-if 'z #'(lambda (arg) (eq arg 'x))
                      #(a x b x c x d x e x f)
                   :start 2 :end 8 :count 2 :from-end t)
       #(a x b x c z d z e x f))
(equalp (substitute-if #\z #'(lambda (arg) (char< #\c arg))
                      #(#\a #\b #\c #\d #\e #\f))
       #(#\a #\b #\c #\z #\z #\z))
(equalp (substitute-if "peace" #'(lambda (arg) (equal "war" arg))
                      #("love" "hate" "war" "peace"))
       #("love" "hate" "peace" "peace"))
(equalp (substitute-if "peace" #'(lambda (arg) (string-equal "war" arg))
                      #("war" "War" "WAr" "WAR"))
       #("peace" "peace" "peace" "peace"))
(equalp (substitute-if "peace" #'(lambda (arg) (string= "WAR" arg))
                      #("war" "War" "WAr" "WAR")
                      :key #'string-upcase)
       #("peace" "peace" "peace" "peace"))
(equalp (substitute-if "peace" #'(lambda (arg) (string= "WAR" arg))
                      #("war" "War" "WAr" "WAR")
                      :start 1
                      :end 2
                      :key #'string-upcase)
       #("war" "peace" "WAr" "WAR"))
(equalp (substitute-if "peace" #'(lambda (arg) (string= "WAR" arg))
                      #("war" "War" "WAr" "WAR")
                      :start 1
                      :end nil
                      :key #'string-upcase)
       #("war" "peace" "peace" "peace"))
(equalp (substitute-if "peace" #'(lambda (arg) (string= "war" arg))
                      #("war" "War" "WAr" "WAR")
                      :key #'string-upcase)
       #("war" "War" "WAr" "WAR"))
(equalp (substitute-if "peace" #'(lambda (arg) (string= "WAR" arg))
                   #("war" "War" "WAr" "WAR" "war" "War" "WAr" "WAR")
                   :start 1
                   :end 7
                   :count 1
                   :key #'string-upcase)
       #("war" "peace" "WAr" "WAR" "war" "War" "WAr" "WAR"))
(equalp (substitute-if "peace" #'(lambda (arg) (string= "WAR" arg))
                   #("war" "War" "WAr" "WAR" "war" "War" "WAr" "WAR")
                   :start 1
                   :end 7
                   :count 2
                   :key #'string-upcase)
       #("war" "peace" "peace" "WAR" "war" "War" "WAr" "WAR"))
(equalp (substitute-if "peace" #'(lambda (arg) (string= "WAR" arg))
                   #("war" "War" "WAr" "WAR" "war" "War" "WAr" "WAR")
                   :start 1
                   :end 7
                   :count 2
                   :from-end t
                   :key #'string-upcase)
       #("war" "War" "WAr" "WAR" "war" "peace" "peace" "WAR"))
(equalp (substitute-if "peace" #'(lambda (arg) (string= "WAR" arg))
                   #("war" "War" "WAr" "WAR" "war" "War" "WAr" "WAR")
                   :start 1
                   :end 7
                   :count 0
                   :from-end t
                   :key #'string-upcase)
       #("war" "War" "WAr" "WAR" "war" "War" "WAr" "WAR"))
(equalp (substitute-if "peace" #'(lambda (arg) (string= "WAR" arg))
                   #("war" "War" "WAr" "WAR" "war" "War" "WAr" "WAR")
                   :start 1
                   :end 7
                   :count -2
                   :from-end t
                   :key #'string-upcase)
       #("war" "War" "WAr" "WAR" "war" "War" "WAr" "WAR"))
(equalp (substitute-if "peace" #'(lambda (arg) (string= "WAR" arg))
                   #("war" "War" "WAr" "WAR" "war" "War" "WAr" "WAR")
                   :start 1
                   :end 7
                   :count nil
                   :from-end t
                   :key #'string-upcase)
       #("war" "peace" "peace" "peace" "peace" "peace" "peace" "WAR"))
(equalp (substitute-if "peace" #'(lambda (arg) (string= "WAR" arg))
                   #("war" "War" "WAr" "WAR" "war" "War" "WAr" "WAR")
                   :start 1
                   :end 7
                   :count 6
                   :from-end t
                   :key #'string-upcase)
       #("war" "peace" "peace" "peace" "peace" "peace" "peace" "WAR"))
(equalp (substitute-if "peace" #'(lambda (arg) (string= "WAR" arg))
                   #("war" "War" "WAr" "WAR" "war" "War" "WAr" "WAR")
                   :start 1
                   :end 7
                   :count 7
                   :from-end t
                   :key #'string-upcase)
       #("war" "peace" "peace" "peace" "peace" "peace" "peace" "WAR"))
(equalp (substitute-if "peace" #'(lambda (arg) (string= "WAR" arg))
                   #("war" "War" "WAr" "WAR" "war" "War" "WAr" "WAR")
                   :start 1
                   :end 7
                   :count 100
                   :from-end t
                   :key #'string-upcase)
       #("war" "peace" "peace" "peace" "peace" "peace" "peace" "WAR"))

(string= (substitute-if #\A #'(lambda (arg) (eql #\a arg)) "abcabc") "AbcAbc")
(string= (substitute-if #\A #'(lambda (arg) (eql #\a arg)) "") "")
(string= (substitute-if #\A #'(lambda (arg) (eql #\a arg)) "xyz") "xyz")
(string= (substitute-if #\A #'(lambda (arg) (eql #\a arg))
                        "aaaaaaaaaa" :start 5 :end nil) "aaaaaAAAAA")
(string= (substitute-if #\x #'(lambda (arg) (char< #\5 arg))
                        "0123456789") "012345xxxx")
(string= (substitute-if #\x #'(lambda (arg) (char> #\5 arg))
                        "0123456789") "xxxxx56789")
(string= (substitute-if #\x #'(lambda (arg) (char> #\D arg)) "abcdefg"
                     :key #'char-upcase)
         "xxxdefg")
(string= (substitute-if #\x #'(lambda (arg) (char> #\D arg)) "abcdefg"
                     :start 1
                     :end 2
                     :key #'char-upcase)
         "axcdefg")
(string= (substitute-if #\A #'(lambda (arg) (eql #\a arg))
                        "aaaaaaaaaa" :count 2) "AAaaaaaaaa")
(string= (substitute-if #\A #'(lambda (arg) (eql #\a arg))
                        "aaaaaaaaaa" :count -1) "aaaaaaaaaa")
(string= (substitute-if #\A #'(lambda (arg) (eql #\a arg))
                        "aaaaaaaaaa" :count 0) "aaaaaaaaaa")
(string= (substitute-if #\A #'(lambda (arg) (eql #\a arg))
                        "aaaaaaaaaa" :count nil) "AAAAAAAAAA")
(string= (substitute-if #\A #'(lambda (arg) (eql #\a arg))
                        "aaaaaaaaaa" :count 100) "AAAAAAAAAA")
(string= (substitute-if #\A #'(lambda (arg) (eql #\a arg))
                        "aaaaaaaaaa" :count 9) "AAAAAAAAAa")
(string= (substitute-if #\A #'(lambda (arg) (eql #\a arg))
                        "aaaaaaaaaa" :count 9 :from-end t) "aAAAAAAAAA")
(string= (substitute-if #\A #'(lambda (arg) (eql #\a arg))
                        "aaaaaaaaaa"
                        :start 2
                        :end 8
                        :count 3)
         "aaAAAaaaaa")
(string= (substitute-if #\A #'(lambda (arg) (eql #\a arg))
                        "aaaaaaaaaa"
                        :start 2
                        :end 8
                        :from-end t
                        :count 3)
         "aaaaaAAAaa")
(string= (substitute-if #\x #'(lambda (arg) (eql #\A arg))
                        "aaaaaaaaaa"
                        :start 2
                        :end 8
                        :from-end t
                        :count 3)
         "aaaaaaaaaa")
(string= (substitute-if #\X #'(lambda (arg) (eql #\A arg))
                        "aaaaaaaaaa"
                        :start 2
                        :end 8
                        :from-end t
                        :key #'char-upcase
                        :count 3)
         "aaaaaXXXaa")
(string= (substitute-if #\X #'(lambda (arg) (char< #\D arg))
                        "abcdefghij"
                        :start 2
                        :end 8
                        :from-end t
                        :key #'char-upcase
                        :count 3)
         "abcdeXXXij")
(equalp (substitute-if 0 #'(lambda (arg) (= 1 arg)) #*1111) #*0000)
(equalp (substitute-if 0 #'(lambda (arg) (= 1 arg))
                       #*1111 :start 1 :end nil) #*1000)
(equalp (substitute-if 0 #'(lambda (arg) (= 1 arg))
                       #*1111 :start 1 :end 3) #*1001)
(equalp (substitute-if 0 #'(lambda (arg) (= 1 arg))
                       #*11111111 :start 1 :end 7) #*10000001)
(equalp (substitute-if 0 #'(lambda (arg) (= 1 arg))
                       #*11111111 :start 1 :end 7 :count 3) #*10001111)
(equalp (substitute-if 0 #'(lambda (arg) (= 1 arg))
                       #*11111111 :start 1 :end 7 :count 3 :from-end t)
        #*11110001)
(equalp (substitute-if 1 #'(lambda (arg) (= 1 arg))
                       #*10101010
                       :start 1 :end 7 :count 3 :from-end t
                       :key #'(lambda (x) (if (zerop x) 1 0)))
        #*11111110)
(equalp (substitute-if 1 #'(lambda (arg) (>= 1 arg))
                       #*10101010
                       :start 1 :end 7 :count 3 :from-end t
                       :key #'(lambda (x) (if (zerop x) 1 0)))
        #*10101110)



(equal (substitute-if-not 'a #'(lambda (arg) (not (eq arg 'x))) '(x y z))
       '(a y z))
(equal (substitute-if-not 'b #'(lambda (arg) (not (eq arg 'y))) '(x y z))
       '(x b z))
(equal (substitute-if-not 'c #'(lambda (arg) (not (eq arg 'z))) '(x y z))
       '(x y c))
(equal (substitute-if-not 'a #'(lambda (arg) (not (eq arg 'p))) '(x y z))
       '(x y z))
(equal (substitute-if-not 'a #'(lambda (arg) (not (eq arg 'x))) '()) '())
(equal (substitute-if-not #\x #'(lambda (arg) (not (char< #\b arg)))
                      '(#\a #\b #\c #\d #\e))
       '(#\a #\b #\x #\x #\x))
(equal (substitute-if-not '(a) #'(lambda (arg) (not (eq arg 'x)))
                      '((x) (y) (z)) :key #'car)
       '((a) (y) (z)))
(equal (substitute-if-not 'c #'(lambda (arg) (not (eq arg 'b)))
                      '(a b a b a b a b)) '(a c a c a c a c))
(equal (substitute-if-not 'a #'(lambda (arg) (not (eq arg 'b)))
                      '(b b b)) '(a a a))
(equal (substitute-if-not 'z #'(lambda (arg) (not (eq arg 'x)))
                      '(a x b x c x d x e x f))
       '(a z b z c z d z e z f))
(equal (substitute-if-not 'z #'(lambda (arg) (not (eq arg 'x)))
                      '(a x b x c x d x e x f) :count nil)
       '(a z b z c z d z e z f))
(equal (substitute-if-not 'z #'(lambda (arg) (not (eq arg 'x)))
                      '(a x b x c x d x e x f) :count 0)
       '(a x b x c x d x e x f))
(equal (substitute-if-not 'z #'(lambda (arg) (not (eq arg 'x)))
                      '(a x b x c x d x e x f) :count -100)
       '(a x b x c x d x e x f))
(equal (substitute-if-not 'z #'(lambda (arg) (not (eq arg 'x)))
                      '(a x b x c x d x e x f) :count 1)
       '(a z b x c x d x e x f))
(equal (substitute-if-not 'z #'(lambda (arg) (not (eq arg 'x)))
                      '(a x b x c x d x e x f) :count 2)
       '(a z b z c x d x e x f))
(equal (substitute-if-not 'z #'(lambda (arg) (not (eq arg 'x)))
                      '(a x b x c x d x e x f) :count 3)
       '(a z b z c z d x e x f))
(equal (substitute-if-not 'z #'(lambda (arg) (not (eq arg 'x)))
                      '(a x b x c x d x e x f) :count 4)
       '(a z b z c z d z e x f))
(equal (substitute-if-not 'z #'(lambda (arg) (not (eq arg 'x)))
                      '(a x b x c x d x e x f) :count 5)
       '(a z b z c z d z e z f))
(equal (substitute-if-not 'z #'(lambda (arg) (not (eq arg 'x)))
                      '(a x b x c x d x e x f) :count 6)
       '(a z b z c z d z e z f))
(equal (substitute-if-not 'z #'(lambda (arg) (not (eq arg 'x)))
                      '(a x b x c x d x e x f) :count 7)
       '(a z b z c z d z e z f))
(equal (substitute-if-not 'z #'(lambda (arg) (not (eq arg 'x)))
                      '(a x b x c x d x e x f) :count nil :from-end t)
       '(a z b z c z d z e z f))
(equal (substitute-if-not 'z #'(lambda (arg) (not (eq arg 'x)))
                      '(a x b x c x d x e x f) :count 0 :from-end t)
       '(a x b x c x d x e x f))
(equal (substitute-if-not 'z #'(lambda (arg) (not (eq arg 'x)))
                      '(a x b x c x d x e x f) :count -100 :from-end t)
       '(a x b x c x d x e x f))
(equal (substitute-if-not 'z #'(lambda (arg) (not (eq arg 'x)))
                      '(a x b x c x d x e x f) :count 1 :from-end t)
       '(a x b x c x d x e z f))
(equal (substitute-if-not 'z #'(lambda (arg) (not (eq arg 'x)))
                      '(a x b x c x d x e x f) :count 2 :from-end t)
       '(a x b x c x d z e z f))
(equal (substitute-if-not 'z #'(lambda (arg) (not (eq arg 'x)))
                      '(a x b x c x d x e x f) :count 3 :from-end t)
       '(a x b x c z d z e z f))
(equal (substitute-if-not 'z #'(lambda (arg) (not (eq arg 'x)))
                      '(a x b x c x d x e x f) :count 4 :from-end t)
       '(a x b z c z d z e z f))
(equal (substitute-if-not 'z #'(lambda (arg) (not (eq arg 'x)))
                      '(a x b x c x d x e x f) :count 5 :from-end t)
       '(a z b z c z d z e z f))
(equal (substitute-if-not 'z #'(lambda (arg) (not (eq arg 'x)))
                      '(a x b x c x d x e x f) :count 6 :from-end t)
       '(a z b z c z d z e z f))
(equal (substitute-if-not 'z #'(lambda (arg) (not (eq arg 'x)))
                      '(a x b x c x d x e x f) :count 7 :from-end t)
       '(a z b z c z d z e z f))
(equal (substitute-if-not 'z #'(lambda (arg) (not (eq arg 'x)))
                      '(a x b x c x d x e x f) :start 2 :count 1)
       '(a x b z c x d x e x f))
(equal (substitute-if-not 'z #'(lambda (arg) (not (eq arg 'x)))
                      '(a x b x c x d x e x f) :start 2 :end nil :count 1)
       '(a x b z c x d x e x f))
(equal (substitute-if-not 'z #'(lambda (arg) (not (eq arg 'x)))
                      '(a x b x c x d x e x f) :start 2 :end 6 :count 100)
       '(a x b z c z d x e x f))
(equal (substitute-if-not 'z #'(lambda (arg) (not (eq arg 'x)))
                      '(a x b x c x d x e x f) :start 2 :end 11 :count 100)
       '(a x b z c z d z e z f))
(equal (substitute-if-not 'z #'(lambda (arg) (not (eq arg 'x)))
                      '(a x b x c x d x e x f) :start 2 :end 8 :count 10)
       '(a x b z c z d z e x f))
(equal (substitute-if-not 'z #'(lambda (arg) (not (eq arg 'x)))
                      '(a x b x c x d x e x f)
                   :start 2 :end 8 :count 2 :from-end t)
       '(a x b x c z d z e x f))
(equal (substitute-if-not #\z #'(lambda (arg) (not (char< #\c arg)))
                      '(#\a #\b #\c #\d #\e #\f))
       '(#\a #\b #\c #\z #\z #\z))
(equal (substitute-if-not "peace" #'(lambda (arg) (not (equal "war" arg)))
                      '("love" "hate" "war" "peace"))
       '("love" "hate" "peace" "peace"))
(equal (substitute-if-not "peace"
                          #'(lambda (arg) (not (string-equal "war" arg)))
                          '("war" "War" "WAr" "WAR"))
       '("peace" "peace" "peace" "peace"))
(equal (substitute-if-not "peace" #'(lambda (arg) (not (string= "WAR" arg)))
                      '("war" "War" "WAr" "WAR")
                      :key #'string-upcase)
       '("peace" "peace" "peace" "peace"))
(equal (substitute-if-not "peace" #'(lambda (arg) (not (string= "WAR" arg)))
                      '("war" "War" "WAr" "WAR")
                      :start 1
                      :end 2
                      :key #'string-upcase)
       '("war" "peace" "WAr" "WAR"))
(equal (substitute-if-not "peace" #'(lambda (arg) (not (string= "WAR" arg)))
                      '("war" "War" "WAr" "WAR")
                      :start 1
                      :end nil
                      :key #'string-upcase)
       '("war" "peace" "peace" "peace"))
(equal (substitute-if-not "peace" #'(lambda (arg) (not (string= "war" arg)))
                      '("war" "War" "WAr" "WAR")
                      :key #'string-upcase)
       '("war" "War" "WAr" "WAR"))
(equal (substitute-if-not "peace" #'(lambda (arg) (not (string= "WAR" arg)))
                   '("war" "War" "WAr" "WAR" "war" "War" "WAr" "WAR")
                   :start 1
                   :end 7
                   :count 1
                   :key #'string-upcase)
       '("war" "peace" "WAr" "WAR" "war" "War" "WAr" "WAR"))
(equal (substitute-if-not "peace" #'(lambda (arg) (not (string= "WAR" arg)))
                   '("war" "War" "WAr" "WAR" "war" "War" "WAr" "WAR")
                   :start 1
                   :end 7
                   :count 2
                   :key #'string-upcase)
       '("war" "peace" "peace" "WAR" "war" "War" "WAr" "WAR"))
(equal (substitute-if-not "peace" #'(lambda (arg) (not (string= "WAR" arg)))
                   '("war" "War" "WAr" "WAR" "war" "War" "WAr" "WAR")
                   :start 1
                   :end 7
                   :count 2
                   :from-end t
                   :key #'string-upcase)
       '("war" "War" "WAr" "WAR" "war" "peace" "peace" "WAR"))
(equal (substitute-if-not "peace" #'(lambda (arg) (not (string= "WAR" arg)))
                   '("war" "War" "WAr" "WAR" "war" "War" "WAr" "WAR")
                   :start 1
                   :end 7
                   :count 0
                   :from-end t
                   :key #'string-upcase)
       '("war" "War" "WAr" "WAR" "war" "War" "WAr" "WAR"))
(equal (substitute-if-not "peace" #'(lambda (arg) (not (string= "WAR" arg)))
                   '("war" "War" "WAr" "WAR" "war" "War" "WAr" "WAR")
                   :start 1
                   :end 7
                   :count -2
                   :from-end t
                   :key #'string-upcase)
       '("war" "War" "WAr" "WAR" "war" "War" "WAr" "WAR"))
(equal (substitute-if-not "peace" #'(lambda (arg) (not (string= "WAR" arg)))
                   '("war" "War" "WAr" "WAR" "war" "War" "WAr" "WAR")
                   :start 1
                   :end 7
                   :count nil
                   :from-end t
                   :key #'string-upcase)
       '("war" "peace" "peace" "peace" "peace" "peace" "peace" "WAR"))
(equal (substitute-if-not "peace" #'(lambda (arg) (not (string= "WAR" arg)))
                   '("war" "War" "WAr" "WAR" "war" "War" "WAr" "WAR")
                   :start 1
                   :end 7
                   :count 6
                   :from-end t
                   :key #'string-upcase)
       '("war" "peace" "peace" "peace" "peace" "peace" "peace" "WAR"))
(equal (substitute-if-not "peace" #'(lambda (arg) (not (string= "WAR" arg)))
                   '("war" "War" "WAr" "WAR" "war" "War" "WAr" "WAR")
                   :start 1
                   :end 7
                   :count 7
                   :from-end t
                   :key #'string-upcase)
       '("war" "peace" "peace" "peace" "peace" "peace" "peace" "WAR"))
(equal (substitute-if-not "peace" #'(lambda (arg) (not (string= "WAR" arg)))
                   '("war" "War" "WAr" "WAR" "war" "War" "WAr" "WAR")
                   :start 1
                   :end 7
                   :count 100
                   :from-end t
                   :key #'string-upcase)
       '("war" "peace" "peace" "peace" "peace" "peace" "peace" "WAR"))


(equalp (substitute-if-not 'a #'(lambda (arg) (not (eq arg 'x)))
                           #(x y z)) #(a y z))
(equalp (substitute-if-not 'b #'(lambda (arg) (not (eq arg 'y)))
                           #(x y z)) #(x b z))
(equalp (substitute-if-not 'c #'(lambda (arg) (not (eq arg 'z)))
                           #(x y z)) #(x y c))
(equalp (substitute-if-not 'a #'(lambda (arg) (not (eq arg 'p)))
                           #(x y z)) #(x y z))
(equalp (substitute-if-not 'a #'(lambda (arg) (not (eq arg 'x)))
                           #()) #())
(equalp (substitute-if-not #\x #'(lambda (arg) (not (char< #\b arg)))
                      #(#\a #\b #\c #\d #\e))
       #(#\a #\b #\x #\x #\x))
(equalp (substitute-if-not '(a) #'(lambda (arg) (not (eq arg 'x)))
                      #((x) (y) (z)) :key #'car)
       #((a) (y) (z)))
(equalp (substitute-if-not 'c #'(lambda (arg) (not (eq arg 'b)))
                      #(a b a b a b a b)) #(a c a c a c a c))
(equalp (substitute-if-not 'a #'(lambda (arg) (not (eq arg 'b)))
                      #(b b b)) #(a a a))
(equalp (substitute-if-not 'z #'(lambda (arg) (not (eq arg 'x)))
                      #(a x b x c x d x e x f))
       #(a z b z c z d z e z f))
(equalp (substitute-if-not 'z #'(lambda (arg) (not (eq arg 'x)))
                      #(a x b x c x d x e x f) :count nil)
       #(a z b z c z d z e z f))
(equalp (substitute-if-not 'z #'(lambda (arg) (not (eq arg 'x)))
                      #(a x b x c x d x e x f) :count 0)
       #(a x b x c x d x e x f))
(equalp (substitute-if-not 'z #'(lambda (arg) (not (eq arg 'x)))
                      #(a x b x c x d x e x f) :count -100)
       #(a x b x c x d x e x f))
(equalp (substitute-if-not 'z #'(lambda (arg) (not (eq arg 'x)))
                      #(a x b x c x d x e x f) :count 1)
       #(a z b x c x d x e x f))
(equalp (substitute-if-not 'z #'(lambda (arg) (not (eq arg 'x)))
                      #(a x b x c x d x e x f) :count 2)
       #(a z b z c x d x e x f))
(equalp (substitute-if-not 'z #'(lambda (arg) (not (eq arg 'x)))
                      #(a x b x c x d x e x f) :count 3)
       #(a z b z c z d x e x f))
(equalp (substitute-if-not 'z #'(lambda (arg) (not (eq arg 'x)))
                      #(a x b x c x d x e x f) :count 4)
       #(a z b z c z d z e x f))
(equalp (substitute-if-not 'z #'(lambda (arg) (not (eq arg 'x)))
                      #(a x b x c x d x e x f) :count 5)
       #(a z b z c z d z e z f))
(equalp (substitute-if-not 'z #'(lambda (arg) (not (eq arg 'x)))
                      #(a x b x c x d x e x f) :count 6)
       #(a z b z c z d z e z f))
(equalp (substitute-if-not 'z #'(lambda (arg) (not (eq arg 'x)))
                      #(a x b x c x d x e x f) :count 7)
       #(a z b z c z d z e z f))
(equalp (substitute-if-not 'z #'(lambda (arg) (not (eq arg 'x)))
                      #(a x b x c x d x e x f) :count nil :from-end t)
       #(a z b z c z d z e z f))
(equalp (substitute-if-not 'z #'(lambda (arg) (not (eq arg 'x)))
                      #(a x b x c x d x e x f) :count 0 :from-end t)
       #(a x b x c x d x e x f))
(equalp (substitute-if-not 'z #'(lambda (arg) (not (eq arg 'x)))
                      #(a x b x c x d x e x f) :count -100 :from-end t)
       #(a x b x c x d x e x f))
(equalp (substitute-if-not 'z #'(lambda (arg) (not (eq arg 'x)))
                      #(a x b x c x d x e x f) :count 1 :from-end t)
       #(a x b x c x d x e z f))
(equalp (substitute-if-not 'z #'(lambda (arg) (not (eq arg 'x)))
                      #(a x b x c x d x e x f) :count 2 :from-end t)
       #(a x b x c x d z e z f))
(equalp (substitute-if-not 'z #'(lambda (arg) (not (eq arg 'x)))
                      #(a x b x c x d x e x f) :count 3 :from-end t)
       #(a x b x c z d z e z f))
(equalp (substitute-if-not 'z #'(lambda (arg) (not (eq arg 'x)))
                      #(a x b x c x d x e x f) :count 4 :from-end t)
       #(a x b z c z d z e z f))
(equalp (substitute-if-not 'z #'(lambda (arg) (not (eq arg 'x)))
                      #(a x b x c x d x e x f) :count 5 :from-end t)
       #(a z b z c z d z e z f))
(equalp (substitute-if-not 'z #'(lambda (arg) (not (eq arg 'x)))
                      #(a x b x c x d x e x f) :count 6 :from-end t)
       #(a z b z c z d z e z f))
(equalp (substitute-if-not 'z #'(lambda (arg) (not (eq arg 'x)))
                      #(a x b x c x d x e x f) :count 7 :from-end t)
       #(a z b z c z d z e z f))
(equalp (substitute-if-not 'z #'(lambda (arg) (not (eq arg 'x)))
                      #(a x b x c x d x e x f) :start 2 :count 1)
       #(a x b z c x d x e x f))
(equalp (substitute-if-not 'z #'(lambda (arg) (not (eq arg 'x)))
                      #(a x b x c x d x e x f) :start 2 :end nil :count 1)
       #(a x b z c x d x e x f))
(equalp (substitute-if-not 'z #'(lambda (arg) (not (eq arg 'x)))
                      #(a x b x c x d x e x f) :start 2 :end 6 :count 100)
       #(a x b z c z d x e x f))
(equalp (substitute-if-not 'z #'(lambda (arg) (not (eq arg 'x)))
                      #(a x b x c x d x e x f) :start 2 :end 11 :count 100)
       #(a x b z c z d z e z f))
(equalp (substitute-if-not 'z #'(lambda (arg) (not (eq arg 'x)))
                      #(a x b x c x d x e x f) :start 2 :end 8 :count 10)
       #(a x b z c z d z e x f))
(equalp (substitute-if-not 'z #'(lambda (arg) (not (eq arg 'x)))
                      #(a x b x c x d x e x f)
                   :start 2 :end 8 :count 2 :from-end t)
       #(a x b x c z d z e x f))
(equalp (substitute-if-not #\z #'(lambda (arg) (not (char< #\c arg)))
                      #(#\a #\b #\c #\d #\e #\f))
       #(#\a #\b #\c #\z #\z #\z))
(equalp (substitute-if-not "peace" #'(lambda (arg) (not (equal "war" arg)))
                      #("love" "hate" "war" "peace"))
       #("love" "hate" "peace" "peace"))
(equalp (substitute-if-not "peace"
                           #'(lambda (arg) (not (string-equal "war" arg)))
                           #("war" "War" "WAr" "WAR"))
       #("peace" "peace" "peace" "peace"))
(equalp (substitute-if-not "peace" #'(lambda (arg) (not (string= "WAR" arg)))
                      #("war" "War" "WAr" "WAR")
                      :key #'string-upcase)
       #("peace" "peace" "peace" "peace"))
(equalp (substitute-if-not "peace" #'(lambda (arg) (not (string= "WAR" arg)))
                      #("war" "War" "WAr" "WAR")
                      :start 1
                      :end 2
                      :key #'string-upcase)
       #("war" "peace" "WAr" "WAR"))
(equalp (substitute-if-not "peace" #'(lambda (arg) (not (string= "WAR" arg)))
                      #("war" "War" "WAr" "WAR")
                      :start 1
                      :end nil
                      :key #'string-upcase)
       #("war" "peace" "peace" "peace"))
(equalp (substitute-if-not "peace" #'(lambda (arg) (not (string= "war" arg)))
                      #("war" "War" "WAr" "WAR")
                      :key #'string-upcase)
       #("war" "War" "WAr" "WAR"))
(equalp (substitute-if-not "peace" #'(lambda (arg) (not (string= "WAR" arg)))
                   #("war" "War" "WAr" "WAR" "war" "War" "WAr" "WAR")
                   :start 1
                   :end 7
                   :count 1
                   :key #'string-upcase)
       #("war" "peace" "WAr" "WAR" "war" "War" "WAr" "WAR"))
(equalp (substitute-if-not "peace" #'(lambda (arg) (not (string= "WAR" arg)))
                   #("war" "War" "WAr" "WAR" "war" "War" "WAr" "WAR")
                   :start 1
                   :end 7
                   :count 2
                   :key #'string-upcase)
       #("war" "peace" "peace" "WAR" "war" "War" "WAr" "WAR"))
(equalp (substitute-if-not "peace" #'(lambda (arg) (not (string= "WAR" arg)))
                   #("war" "War" "WAr" "WAR" "war" "War" "WAr" "WAR")
                   :start 1
                   :end 7
                   :count 2
                   :from-end t
                   :key #'string-upcase)
       #("war" "War" "WAr" "WAR" "war" "peace" "peace" "WAR"))
(equalp (substitute-if-not "peace" #'(lambda (arg) (not (string= "WAR" arg)))
                   #("war" "War" "WAr" "WAR" "war" "War" "WAr" "WAR")
                   :start 1
                   :end 7
                   :count 0
                   :from-end t
                   :key #'string-upcase)
       #("war" "War" "WAr" "WAR" "war" "War" "WAr" "WAR"))
(equalp (substitute-if-not "peace" #'(lambda (arg) (not (string= "WAR" arg)))
                   #("war" "War" "WAr" "WAR" "war" "War" "WAr" "WAR")
                   :start 1
                   :end 7
                   :count -2
                   :from-end t
                   :key #'string-upcase)
       #("war" "War" "WAr" "WAR" "war" "War" "WAr" "WAR"))
(equalp (substitute-if-not "peace" #'(lambda (arg) (not (string= "WAR" arg)))
                   #("war" "War" "WAr" "WAR" "war" "War" "WAr" "WAR")
                   :start 1
                   :end 7
                   :count nil
                   :from-end t
                   :key #'string-upcase)
       #("war" "peace" "peace" "peace" "peace" "peace" "peace" "WAR"))
(equalp (substitute-if-not "peace" #'(lambda (arg) (not (string= "WAR" arg)))
                   #("war" "War" "WAr" "WAR" "war" "War" "WAr" "WAR")
                   :start 1
                   :end 7
                   :count 6
                   :from-end t
                   :key #'string-upcase)
       #("war" "peace" "peace" "peace" "peace" "peace" "peace" "WAR"))
(equalp (substitute-if-not "peace" #'(lambda (arg) (not (string= "WAR" arg)))
                   #("war" "War" "WAr" "WAR" "war" "War" "WAr" "WAR")
                   :start 1
                   :end 7
                   :count 7
                   :from-end t
                   :key #'string-upcase)
       #("war" "peace" "peace" "peace" "peace" "peace" "peace" "WAR"))
(equalp (substitute-if-not "peace" #'(lambda (arg) (not (string= "WAR" arg)))
                   #("war" "War" "WAr" "WAR" "war" "War" "WAr" "WAR")
                   :start 1
                   :end 7
                   :count 100
                   :from-end t
                   :key #'string-upcase)
       #("war" "peace" "peace" "peace" "peace" "peace" "peace" "WAR"))

(string= (substitute-if-not #\A #'(lambda (arg) (not (eql #\a arg))) "abcabc")
         "AbcAbc")
(string= (substitute-if-not #\A #'(lambda (arg) (not (eql #\a arg))) "") "")
(string= (substitute-if-not #\A #'(lambda (arg) (not (eql #\a arg))) "xyz")
         "xyz")
(string= (substitute-if-not #\A #'(lambda (arg) (not (eql #\a arg)))
                        "aaaaaaaaaa" :start 5 :end nil) "aaaaaAAAAA")
(string= (substitute-if-not #\x #'(lambda (arg) (not (char< #\5 arg)))
                        "0123456789") "012345xxxx")
(string= (substitute-if-not #\x #'(lambda (arg) (not (char> #\5 arg)))
                        "0123456789") "xxxxx56789")
(string= (substitute-if-not #\x #'(lambda (arg) (not (char> #\D arg)))
                            "abcdefg"
                            :key #'char-upcase)
         "xxxdefg")
(string= (substitute-if-not #\x #'(lambda (arg) (not (char> #\D arg)))
                            "abcdefg"
                            :start 1
                            :end 2
                            :key #'char-upcase)
         "axcdefg")
(string= (substitute-if-not #\A #'(lambda (arg) (not (eql #\a arg)))
                        "aaaaaaaaaa" :count 2) "AAaaaaaaaa")
(string= (substitute-if-not #\A #'(lambda (arg) (not (eql #\a arg)))
                        "aaaaaaaaaa" :count -1) "aaaaaaaaaa")
(string= (substitute-if-not #\A #'(lambda (arg) (not (eql #\a arg)))
                        "aaaaaaaaaa" :count 0) "aaaaaaaaaa")
(string= (substitute-if-not #\A #'(lambda (arg) (not (eql #\a arg)))
                        "aaaaaaaaaa" :count nil) "AAAAAAAAAA")
(string= (substitute-if-not #\A #'(lambda (arg) (not (eql #\a arg)))
                        "aaaaaaaaaa" :count 100) "AAAAAAAAAA")
(string= (substitute-if-not #\A #'(lambda (arg) (not (eql #\a arg)))
                        "aaaaaaaaaa" :count 9) "AAAAAAAAAa")
(string= (substitute-if-not #\A #'(lambda (arg) (not (eql #\a arg)))
                        "aaaaaaaaaa" :count 9 :from-end t) "aAAAAAAAAA")
(string= (substitute-if-not #\A #'(lambda (arg) (not (eql #\a arg)))
                        "aaaaaaaaaa"
                        :start 2
                        :end 8
                        :count 3)
         "aaAAAaaaaa")
(string= (substitute-if-not #\A #'(lambda (arg) (not (eql #\a arg)))
                        "aaaaaaaaaa"
                        :start 2
                        :end 8
                        :from-end t
                        :count 3)
         "aaaaaAAAaa")
(string= (substitute-if-not #\x #'(lambda (arg) (not (eql #\A arg)))
                        "aaaaaaaaaa"
                        :start 2
                        :end 8
                        :from-end t
                        :count 3)
         "aaaaaaaaaa")
(string= (substitute-if-not #\X #'(lambda (arg) (not (eql #\A arg)))
                        "aaaaaaaaaa"
                        :start 2
                        :end 8
                        :from-end t
                        :key #'char-upcase
                        :count 3)
         "aaaaaXXXaa")
(string= (substitute-if-not #\X #'(lambda (arg) (not (char< #\D arg)))
                        "abcdefghij"
                        :start 2
                        :end 8
                        :from-end t
                        :key #'char-upcase
                        :count 3)
         "abcdeXXXij")
(equalp (substitute-if-not 0 #'(lambda (arg) (not (= 1 arg))) #*1111) #*0000)
(equalp (substitute-if-not 0 #'(lambda (arg) (not (= 1 arg)))
                       #*1111 :start 1 :end nil) #*1000)
(equalp (substitute-if-not 0 #'(lambda (arg) (not (= 1 arg)))
                       #*1111 :start 1 :end 3) #*1001)
(equalp (substitute-if-not 0 #'(lambda (arg) (not (= 1 arg)))
                       #*11111111 :start 1 :end 7) #*10000001)
(equalp (substitute-if-not 0 #'(lambda (arg) (not (= 1 arg)))
                       #*11111111 :start 1 :end 7 :count 3) #*10001111)
(equalp (substitute-if-not 0 #'(lambda (arg) (not (= 1 arg)))
                       #*11111111 :start 1 :end 7 :count 3 :from-end t)
        #*11110001)
(equalp (substitute-if-not 1 #'(lambda (arg) (not (= 1 arg)))
                       #*10101010
                       :start 1 :end 7 :count 3 :from-end t
                       :key #'(lambda (x) (if (zerop x) 1 0)))
        #*11111110)
(equalp (substitute-if-not 1 #'(lambda (arg) (not (>= 1 arg)))
                       #*10101010
                       :start 1 :end 7 :count 3 :from-end t
                       :key #'(lambda (x) (if (zerop x) 1 0)))
        #*10101110)


(equal (nsubstitute 'a 'x (copy-seq '(x y z))) '(a y z))
(equal (nsubstitute 'b 'y (copy-seq '(x y z))) '(x b z))
(equal (nsubstitute 'c 'z (copy-seq '(x y z))) '(x y c))
(equal (nsubstitute 'a 'p (copy-seq '(x y z))) '(x y z))
(equal (nsubstitute 'a 'x (copy-seq '())) '())
(equal (nsubstitute #\x #\b (copy-seq '(#\a #\b #\c #\d #\e)) :test #'char<)
       '(#\a #\b #\x #\x #\x))
(equal (nsubstitute #\x #\b (copy-seq '(#\a #\b #\c #\d #\e))
                   :test-not (complement #'char<))
       '(#\a #\b #\x #\x #\x))
(equal (nsubstitute '(a) 'x (copy-seq '((x) (y) (z))) :key #'car)
       '((a) (y) (z)))
(equal (nsubstitute 'c 'b (copy-seq '(a b a b a b a b))) '(a c a c a c a c))
(equal (nsubstitute 'a 'b (copy-seq '(b b b))) '(a a a))
(equal (nsubstitute 'z 'x (copy-seq '(a x b x c x d x e x f)))
       '(a z b z c z d z e z f))
(equal (nsubstitute 'z 'x (copy-seq '(a x b x c x d x e x f)) :count nil)
       '(a z b z c z d z e z f))
(equal (nsubstitute 'z 'x (copy-seq '(a x b x c x d x e x f)) :count 0)
       '(a x b x c x d x e x f))
(equal (nsubstitute 'z 'x (copy-seq '(a x b x c x d x e x f)) :count -100)
       '(a x b x c x d x e x f))
(equal (nsubstitute 'z 'x (copy-seq '(a x b x c x d x e x f)) :count 1)
       '(a z b x c x d x e x f))
(equal (nsubstitute 'z 'x (copy-seq '(a x b x c x d x e x f)) :count 2)
       '(a z b z c x d x e x f))
(equal (nsubstitute 'z 'x (copy-seq '(a x b x c x d x e x f)) :count 3)
       '(a z b z c z d x e x f))
(equal (nsubstitute 'z 'x (copy-seq '(a x b x c x d x e x f)) :count 4)
       '(a z b z c z d z e x f))
(equal (nsubstitute 'z 'x (copy-seq '(a x b x c x d x e x f)) :count 5)
       '(a z b z c z d z e z f))
(equal (nsubstitute 'z 'x (copy-seq '(a x b x c x d x e x f)) :count 6)
       '(a z b z c z d z e z f))
(equal (nsubstitute 'z 'x (copy-seq '(a x b x c x d x e x f)) :count 7)
       '(a z b z c z d z e z f))
(equal (nsubstitute 'z 'x (copy-seq '(a x b x c x d x e x f))
                    :count nil :from-end t)
       '(a z b z c z d z e z f))
(equal (nsubstitute 'z 'x (copy-seq '(a x b x c x d x e x f))
                    :count 0 :from-end t)
       '(a x b x c x d x e x f))
(equal (nsubstitute 'z 'x (copy-seq '(a x b x c x d x e x f))
                    :count -100 :from-end t)
       '(a x b x c x d x e x f))
(equal (nsubstitute 'z 'x (copy-seq '(a x b x c x d x e x f))
                    :count 1 :from-end t)
       '(a x b x c x d x e z f))
(equal (nsubstitute 'z 'x (copy-seq '(a x b x c x d x e x f))
                    :count 2 :from-end t)
       '(a x b x c x d z e z f))
(equal (nsubstitute 'z 'x (copy-seq '(a x b x c x d x e x f))
                    :count 3 :from-end t)
       '(a x b x c z d z e z f))
(equal (nsubstitute 'z 'x (copy-seq '(a x b x c x d x e x f))
                    :count 4 :from-end t)
       '(a x b z c z d z e z f))
(equal (nsubstitute 'z 'x (copy-seq '(a x b x c x d x e x f))
                    :count 5 :from-end t)
       '(a z b z c z d z e z f))
(equal (nsubstitute 'z 'x (copy-seq '(a x b x c x d x e x f))
                    :count 6 :from-end t)
       '(a z b z c z d z e z f))
(equal (nsubstitute 'z 'x (copy-seq '(a x b x c x d x e x f))
                    :count 7 :from-end t)
       '(a z b z c z d z e z f))
(equal (nsubstitute 'z 'x (copy-seq '(a x b x c x d x e x f))
                    :start 2 :count 1)
       '(a x b z c x d x e x f))
(equal (nsubstitute 'z 'x (copy-seq '(a x b x c x d x e x f))
                    :start 2 :end nil :count 1)
       '(a x b z c x d x e x f))
(equal (nsubstitute 'z 'x (copy-seq '(a x b x c x d x e x f))
                    :start 2 :end 6 :count 100)
       '(a x b z c z d x e x f))
(equal (nsubstitute 'z 'x (copy-seq '(a x b x c x d x e x f))
                    :start 2 :end 11 :count 100)
       '(a x b z c z d z e z f))
(equal (nsubstitute 'z 'x (copy-seq '(a x b x c x d x e x f))
                    :start 2 :end 8 :count 10)
       '(a x b z c z d z e x f))
(equal (nsubstitute 'z 'x (copy-seq '(a x b x c x d x e x f))
                   :start 2 :end 8 :count 2 :from-end t)
       '(a x b x c z d z e x f))
(equal (nsubstitute #\z #\c (copy-seq '(#\a #\b #\c #\d #\e #\f))
                    :test #'char<)
       '(#\a #\b #\c #\z #\z #\z))
(equal (nsubstitute #\z #\c (copy-seq '(#\a #\b #\c #\d #\e #\f))
                   :test-not (complement #'char<))
       '(#\a #\b #\c #\z #\z #\z))
(equal (nsubstitute "peace" "war" (copy-seq '("love" "hate" "war" "peace"))
                    :test #'equal)
       '("love" "hate" "peace" "peace"))
(equal (nsubstitute "peace" "war" (copy-seq '("love" "hate" "war" "peace"))
                   :test-not (complement #'equal))
       '("love" "hate" "peace" "peace"))
(equal (nsubstitute "peace" "war" (copy-seq '("war" "War" "WAr" "WAR"))
                   :test #'string-equal)
       '("peace" "peace" "peace" "peace"))
(equal (nsubstitute "peace" "war" (copy-seq '("war" "War" "WAr" "WAR"))
                   :test-not (complement #'string-equal))
       '("peace" "peace" "peace" "peace"))
(equal (nsubstitute "peace" "WAR" (copy-seq '("war" "War" "WAr" "WAR"))
                   :test #'string=)
       '("war" "War" "WAr" "peace"))
(equal (nsubstitute "peace" "WAR" (copy-seq '("war" "War" "WAr" "WAR"))
                   :test-not (complement #'string=))
       '("war" "War" "WAr" "peace"))
(equal (nsubstitute "peace" "WAR" (copy-seq '("war" "War" "WAr" "WAR"))
                   :test #'string=
                   :key #'string-upcase)
       '("peace" "peace" "peace" "peace"))
(equal (nsubstitute "peace" "WAR" (copy-seq '("war" "War" "WAr" "WAR"))
                   :test-not (complement #'string=)
                   :key #'string-upcase)
       '("peace" "peace" "peace" "peace"))
(equal (nsubstitute "peace" "WAR" (copy-seq '("war" "War" "WAr" "WAR"))
                   :start 1
                   :end 2
                   :test #'string=
                   :key #'string-upcase)
       '("war" "peace" "WAr" "WAR"))
(equal (nsubstitute "peace" "WAR" (copy-seq '("war" "War" "WAr" "WAR"))
                   :start 1
                   :end 2
                   :test-not (complement #'string=)
                   :key #'string-upcase)
       '("war" "peace" "WAr" "WAR"))
(equal (nsubstitute "peace" "WAR" (copy-seq '("war" "War" "WAr" "WAR"))
                   :start 1
                   :end nil
                   :test #'string=
                   :key #'string-upcase)
       '("war" "peace" "peace" "peace"))
(equal (nsubstitute "peace" "WAR" (copy-seq '("war" "War" "WAr" "WAR"))
                   :start 1
                   :end nil
                   :test-not (complement #'string=)
                   :key #'string-upcase)
       '("war" "peace" "peace" "peace"))
(equal (nsubstitute "peace" "war" (copy-seq '("war" "War" "WAr" "WAR"))
                   :test #'string=
                   :key #'string-upcase)
       '("war" "War" "WAr" "WAR"))
(equal (nsubstitute "peace" "war" (copy-seq '("war" "War" "WAr" "WAR"))
                   :test-not (complement #'string=)
                   :key #'string-upcase)
       '("war" "War" "WAr" "WAR"))
(equal (nsubstitute "peace" "WAR"
                    (copy-seq
                     '("war" "War" "WAr" "WAR" "war" "War" "WAr" "WAR"))
                   :start 1
                   :end 7
                   :count 1
                   :test-not (complement #'string=)
                   :key #'string-upcase)
       '("war" "peace" "WAr" "WAR" "war" "War" "WAr" "WAR"))
(equal (nsubstitute "peace" "WAR"
                   (copy-seq '("war" "War" "WAr" "WAR" "war" "War" "WAr" "WAR"))
                   :start 1
                   :end 7
                   :count 2
                   :test-not (complement #'string=)
                   :key #'string-upcase)
       '("war" "peace" "peace" "WAR" "war" "War" "WAr" "WAR"))
(equal (nsubstitute "peace" "WAR"
                    (copy-seq
                     '("war" "War" "WAr" "WAR" "war" "War" "WAr" "WAR"))
                    :start 1
                    :end 7
                    :count 2
                    :from-end t
                    :test-not (complement #'string=)
                    :key #'string-upcase)
       '("war" "War" "WAr" "WAR" "war" "peace" "peace" "WAR"))
(equal (nsubstitute "peace" "WAR"
                    (copy-seq
                     '("war" "War" "WAr" "WAR" "war" "War" "WAr" "WAR"))
                    :start 1
                    :end 7
                    :count 0
                    :from-end t
                    :test-not (complement #'string=)
                    :key #'string-upcase)
       '("war" "War" "WAr" "WAR" "war" "War" "WAr" "WAR"))
(equal (nsubstitute "peace" "WAR"
                    (copy-seq
                     '("war" "War" "WAr" "WAR" "war" "War" "WAr" "WAR"))
                    :start 1
                    :end 7
                    :count -2
                    :from-end t
                    :test-not (complement #'string=)
                    :key #'string-upcase)
       '("war" "War" "WAr" "WAR" "war" "War" "WAr" "WAR"))
(equal (nsubstitute "peace" "WAR"
                    (copy-seq
                     '("war" "War" "WAr" "WAR" "war" "War" "WAr" "WAR"))
                    :start 1
                    :end 7
                    :count nil
                    :from-end t
                    :test-not (complement #'string=)
                    :key #'string-upcase)
       '("war" "peace" "peace" "peace" "peace" "peace" "peace" "WAR"))
(equal (nsubstitute "peace" "WAR"
                    (copy-seq
                     '("war" "War" "WAr" "WAR" "war" "War" "WAr" "WAR"))
                    :start 1
                    :end 7
                    :count 6
                    :from-end t
                    :test-not (complement #'string=)
                    :key #'string-upcase)
       '("war" "peace" "peace" "peace" "peace" "peace" "peace" "WAR"))
(equal (nsubstitute "peace" "WAR"
                    (copy-seq
                     '("war" "War" "WAr" "WAR" "war" "War" "WAr" "WAR"))
                    :start 1
                    :end 7
                    :count 7
                    :from-end t
                    :test-not (complement #'string=)
                    :key #'string-upcase)
       '("war" "peace" "peace" "peace" "peace" "peace" "peace" "WAR"))
(equal (nsubstitute "peace" "WAR"
                    (copy-seq
                     '("war" "War" "WAr" "WAR" "war" "War" "WAr" "WAR"))
                    :start 1
                    :end 7
                    :count 100
                    :from-end t
                    :test-not (complement #'string=)
                    :key #'string-upcase)
       '("war" "peace" "peace" "peace" "peace" "peace" "peace" "WAR"))


(equalp (nsubstitute 'a 'x (copy-seq #(x y z))) #(a y z))
(equalp (nsubstitute 'b 'y (copy-seq #(x y z))) #(x b z))
(equalp (nsubstitute 'c 'z (copy-seq #(x y z))) #(x y c))
(equalp (nsubstitute 'a 'p (copy-seq #(x y z))) #(x y z))
(equalp (nsubstitute 'a 'x (copy-seq #())) #())
(equalp (nsubstitute #\x #\b (copy-seq #(#\a #\b #\c #\d #\e)) :test #'char<)
        #(#\a #\b #\x #\x #\x))
(equalp (nsubstitute #\x #\b (copy-seq #(#\a #\b #\c #\d #\e))
                   :test-not (complement #'char<))
       #(#\a #\b #\x #\x #\x))
(equalp (nsubstitute '(a) 'x (copy-seq #((x) (y) (z))) :key #'car)
       #((a) (y) (z)))
(equalp (nsubstitute 'c 'b (copy-seq #(a b a b a b a b))) #(a c a c a c a c))
(equalp (nsubstitute 'a 'b (copy-seq #(b b b))) #(a a a))
(equalp (nsubstitute 'z 'x (copy-seq #(a x b x c x d x e x f)))
        #(a z b z c z d z e z f))
(equalp (nsubstitute 'z 'x (copy-seq #(a x b x c x d x e x f)) :count nil)
        #(a z b z c z d z e z f))
(equalp (nsubstitute 'z 'x (copy-seq #(a x b x c x d x e x f)) :count 0)
        #(a x b x c x d x e x f))
(equalp (nsubstitute 'z 'x (copy-seq #(a x b x c x d x e x f)) :count -100)
        #(a x b x c x d x e x f))
(equalp (nsubstitute 'z 'x (copy-seq #(a x b x c x d x e x f)) :count 1)
        #(a z b x c x d x e x f))
(equalp (nsubstitute 'z 'x (copy-seq #(a x b x c x d x e x f)) :count 2)
        #(a z b z c x d x e x f))
(equalp (nsubstitute 'z 'x (copy-seq #(a x b x c x d x e x f)) :count 3)
        #(a z b z c z d x e x f))
(equalp (nsubstitute 'z 'x (copy-seq #(a x b x c x d x e x f)) :count 4)
        #(a z b z c z d z e x f))
(equalp (nsubstitute 'z 'x (copy-seq #(a x b x c x d x e x f)) :count 5)
        #(a z b z c z d z e z f))
(equalp (nsubstitute 'z 'x (copy-seq #(a x b x c x d x e x f)) :count 6)
        #(a z b z c z d z e z f))
(equalp (nsubstitute 'z 'x (copy-seq #(a x b x c x d x e x f)) :count 7)
        #(a z b z c z d z e z f))
(equalp (nsubstitute 'z 'x (copy-seq #(a x b x c x d x e x f))
                     :count nil :from-end t)
        #(a z b z c z d z e z f))
(equalp (nsubstitute 'z 'x (copy-seq #(a x b x c x d x e x f))
                     :count 0 :from-end t)
        #(a x b x c x d x e x f))
(equalp (nsubstitute 'z 'x (copy-seq #(a x b x c x d x e x f))
                     :count -100 :from-end t)
        #(a x b x c x d x e x f))
(equalp (nsubstitute 'z 'x (copy-seq #(a x b x c x d x e x f))
                     :count 1 :from-end t)
        #(a x b x c x d x e z f))
(equalp (nsubstitute 'z 'x (copy-seq #(a x b x c x d x e x f))
                     :count 2 :from-end t)
        #(a x b x c x d z e z f))
(equalp (nsubstitute 'z 'x (copy-seq #(a x b x c x d x e x f))
                     :count 3 :from-end t)
        #(a x b x c z d z e z f))
(equalp (nsubstitute 'z 'x (copy-seq #(a x b x c x d x e x f))
                     :count 4 :from-end t)
        #(a x b z c z d z e z f))
(equalp (nsubstitute 'z 'x (copy-seq #(a x b x c x d x e x f))
                     :count 5 :from-end t)
        #(a z b z c z d z e z f))
(equalp (nsubstitute 'z 'x (copy-seq #(a x b x c x d x e x f))
                     :count 6 :from-end t)
        #(a z b z c z d z e z f))
(equalp (nsubstitute 'z 'x (copy-seq #(a x b x c x d x e x f))
                     :count 7 :from-end t)
        #(a z b z c z d z e z f))
(equalp (nsubstitute 'z 'x (copy-seq #(a x b x c x d x e x f))
                     :start 2 :count 1)
       #(a x b z c x d x e x f))
(equalp (nsubstitute 'z 'x (copy-seq #(a x b x c x d x e x f))
                     :start 2 :end nil :count 1)
       #(a x b z c x d x e x f))
(equalp (nsubstitute 'z 'x (copy-seq #(a x b x c x d x e x f))
                     :start 2 :end 6 :count 100)
       #(a x b z c z d x e x f))
(equalp (nsubstitute 'z 'x (copy-seq #(a x b x c x d x e x f))
                     :start 2 :end 11 :count 100)
       #(a x b z c z d z e z f))
(equalp (nsubstitute 'z 'x (copy-seq #(a x b x c x d x e x f))
                     :start 2 :end 8 :count 10)
       #(a x b z c z d z e x f))
(equalp (nsubstitute 'z 'x (copy-seq #(a x b x c x d x e x f))
                   :start 2 :end 8 :count 2 :from-end t)
       #(a x b x c z d z e x f))
(equalp (nsubstitute #\z #\c (copy-seq #(#\a #\b #\c #\d #\e #\f))
                     :test #'char<)
       #(#\a #\b #\c #\z #\z #\z))
(equalp (nsubstitute #\z #\c (copy-seq #(#\a #\b #\c #\d #\e #\f))
                   :test-not (complement #'char<))
       #(#\a #\b #\c #\z #\z #\z))
(equalp (nsubstitute "peace" "war" (copy-seq #("love" "hate" "war" "peace"))
                     :test #'equal)
       #("love" "hate" "peace" "peace"))
(equalp (nsubstitute "peace" "war" (copy-seq #("love" "hate" "war" "peace"))
                   :test-not (complement #'equal))
       #("love" "hate" "peace" "peace"))
(equalp (nsubstitute "peace" "war" (copy-seq #("war" "War" "WAr" "WAR"))
                   :test #'string-equal)
       #("peace" "peace" "peace" "peace"))
(equalp (nsubstitute "peace" "war" (copy-seq #("war" "War" "WAr" "WAR"))
                   :test-not (complement #'string-equal))
       #("peace" "peace" "peace" "peace"))
(equalp (nsubstitute "peace" "WAR" (copy-seq #("war" "War" "WAr" "WAR"))
                   :test #'string=)
       #("war" "War" "WAr" "peace"))
(equalp (nsubstitute "peace" "WAR" (copy-seq #("war" "War" "WAr" "WAR"))
                   :test-not (complement #'string=))
       #("war" "War" "WAr" "peace"))
(equalp (nsubstitute "peace" "WAR" (copy-seq #("war" "War" "WAr" "WAR"))
                   :test #'string=
                   :key #'string-upcase)
       #("peace" "peace" "peace" "peace"))
(equalp (nsubstitute "peace" "WAR" (copy-seq #("war" "War" "WAr" "WAR"))
                   :test-not (complement #'string=)
                   :key #'string-upcase)
       #("peace" "peace" "peace" "peace"))
(equalp (nsubstitute "peace" "WAR" (copy-seq #("war" "War" "WAr" "WAR"))
                   :start 1
                   :end 2
                   :test #'string=
                   :key #'string-upcase)
       #("war" "peace" "WAr" "WAR"))
(equalp (nsubstitute "peace" "WAR" (copy-seq #("war" "War" "WAr" "WAR"))
                   :start 1
                   :end 2
                   :test-not (complement #'string=)
                   :key #'string-upcase)
       #("war" "peace" "WAr" "WAR"))
(equalp (nsubstitute "peace" "WAR" (copy-seq #("war" "War" "WAr" "WAR"))
                   :start 1
                   :end nil
                   :test #'string=
                   :key #'string-upcase)
       #("war" "peace" "peace" "peace"))
(equalp (nsubstitute "peace" "WAR" (copy-seq #("war" "War" "WAr" "WAR"))
                   :start 1
                   :end nil
                   :test-not (complement #'string=)
                   :key #'string-upcase)
       #("war" "peace" "peace" "peace"))
(equalp (nsubstitute "peace" "war" (copy-seq #("war" "War" "WAr" "WAR"))
                   :test #'string=
                   :key #'string-upcase)
       #("war" "War" "WAr" "WAR"))
(equalp (nsubstitute "peace" "war" (copy-seq #("war" "War" "WAr" "WAR"))
                   :test-not (complement #'string=)
                   :key #'string-upcase)
       #("war" "War" "WAr" "WAR"))
(equalp (nsubstitute "peace" "WAR"
                     (copy-seq
                      #("war" "War" "WAr" "WAR" "war" "War" "WAr" "WAR"))
                     :start 1
                     :end 7
                     :count 1
                     :test-not (complement #'string=)
                     :key #'string-upcase)
        #("war" "peace" "WAr" "WAR" "war" "War" "WAr" "WAR"))
(equalp (nsubstitute "peace" "WAR"
                     (copy-seq
                      #("war" "War" "WAr" "WAR" "war" "War" "WAr" "WAR"))
                     :start 1
                     :end 7
                     :count 2
                     :test-not (complement #'string=)
                     :key #'string-upcase)
        #("war" "peace" "peace" "WAR" "war" "War" "WAr" "WAR"))
(equalp (nsubstitute "peace" "WAR"
                     (copy-seq
                      #("war" "War" "WAr" "WAR" "war" "War" "WAr" "WAR"))
                     :start 1
                     :end 7
                     :count 2
                     :from-end t
                     :test-not (complement #'string=)
                     :key #'string-upcase)
        #("war" "War" "WAr" "WAR" "war" "peace" "peace" "WAR"))
(equalp (nsubstitute "peace" "WAR"
                     (copy-seq
                      #("war" "War" "WAr" "WAR" "war" "War" "WAr" "WAR"))
                     :start 1
                     :end 7
                     :count 0
                     :from-end t
                     :test-not (complement #'string=)
                     :key #'string-upcase)
        #("war" "War" "WAr" "WAR" "war" "War" "WAr" "WAR"))
(equalp (nsubstitute "peace" "WAR"
                     (copy-seq
                      #("war" "War" "WAr" "WAR" "war" "War" "WAr" "WAR"))
                     :start 1
                     :end 7
                     :count -2
                     :from-end t
                     :test-not (complement #'string=)
                     :key #'string-upcase)
        #("war" "War" "WAr" "WAR" "war" "War" "WAr" "WAR"))
(equalp (nsubstitute "peace" "WAR"
                     (copy-seq
                      #("war" "War" "WAr" "WAR" "war" "War" "WAr" "WAR"))
                     :start 1
                     :end 7
                     :count nil
                     :from-end t
                     :test-not (complement #'string=)
                     :key #'string-upcase)
        #("war" "peace" "peace" "peace" "peace" "peace" "peace" "WAR"))
(equalp (nsubstitute "peace" "WAR"
                     (copy-seq
                      #("war" "War" "WAr" "WAR" "war" "War" "WAr" "WAR"))
                     :start 1
                     :end 7
                     :count 6
                     :from-end t
                     :test-not (complement #'string=)
                     :key #'string-upcase)
        #("war" "peace" "peace" "peace" "peace" "peace" "peace" "WAR"))
(equalp (nsubstitute "peace" "WAR"
                     (copy-seq
                      #("war" "War" "WAr" "WAR" "war" "War" "WAr" "WAR"))
                     :start 1
                     :end 7
                     :count 7
                     :from-end t
                     :test-not (complement #'string=)
                     :key #'string-upcase)
        #("war" "peace" "peace" "peace" "peace" "peace" "peace" "WAR"))
(equalp (nsubstitute "peace" "WAR"
                     (copy-seq
                      #("war" "War" "WAr" "WAR" "war" "War" "WAr" "WAR"))
                     :start 1
                     :end 7
                     :count 100
                     :from-end t
                     :test-not (complement #'string=)
                     :key #'string-upcase)
        #("war" "peace" "peace" "peace" "peace" "peace" "peace" "WAR"))
(string= (nsubstitute #\A #\a (copy-seq "abcabc")) "AbcAbc")
(string= (nsubstitute #\A #\a (copy-seq "")) "")
(string= (nsubstitute #\A #\a (copy-seq "xyz")) "xyz")
(string= (nsubstitute #\A #\a (copy-seq "aaaaaaaaaa") :start 5 :end nil)
         "aaaaaAAAAA")
(string= (nsubstitute #\x #\5 (copy-seq "0123456789") :test #'char<)
         "012345xxxx")
(string= (nsubstitute #\x #\5 (copy-seq "0123456789") :test #'char>)
         "xxxxx56789")
(string= (nsubstitute #\x #\D (copy-seq "abcdefg")
                      :key #'char-upcase
                      :test #'char>)
         "xxxdefg")
(string= (nsubstitute #\x #\D (copy-seq "abcdefg")
                     :start 1
                     :end 2
                     :key #'char-upcase
                     :test #'char>)
         "axcdefg")
(string= (nsubstitute #\A #\a (copy-seq "aaaaaaaaaa") :count 2) "AAaaaaaaaa")
(string= (nsubstitute #\A #\a (copy-seq "aaaaaaaaaa") :count -1) "aaaaaaaaaa")
(string= (nsubstitute #\A #\a (copy-seq "aaaaaaaaaa") :count 0) "aaaaaaaaaa")
(string= (nsubstitute #\A #\a (copy-seq "aaaaaaaaaa") :count nil) "AAAAAAAAAA")
(string= (nsubstitute #\A #\a (copy-seq "aaaaaaaaaa") :count 100) "AAAAAAAAAA")
(string= (nsubstitute #\A #\a (copy-seq "aaaaaaaaaa") :count 9) "AAAAAAAAAa")
(string= (nsubstitute #\A #\a (copy-seq "aaaaaaaaaa") :count 9 :from-end t)
         "aAAAAAAAAA")
(string= (nsubstitute #\A #\a (copy-seq "aaaaaaaaaa")
                     :start 2
                     :end 8
                     :count 3)
         "aaAAAaaaaa")
(string= (nsubstitute #\A #\a (copy-seq "aaaaaaaaaa")
                     :start 2
                     :end 8
                     :from-end t
                     :count 3)
         "aaaaaAAAaa")
(string= (nsubstitute #\x #\A (copy-seq "aaaaaaaaaa")
                     :start 2
                     :end 8
                     :from-end t
                     :count 3)
         "aaaaaaaaaa")
(string= (nsubstitute #\X #\A (copy-seq "aaaaaaaaaa")
                     :start 2
                     :end 8
                     :from-end t
                     :key #'char-upcase
                     :count 3)
         "aaaaaXXXaa")
(string= (nsubstitute #\X #\D (copy-seq "abcdefghij")
                     :start 2
                     :end 8
                     :from-end t
                     :key #'char-upcase
                     :test #'char<
                     :count 3)
         "abcdeXXXij")
(equalp (nsubstitute 0 1 (copy-seq #*1111)) #*0000)
(equalp (nsubstitute 0 1 (copy-seq #*1111) :start 1 :end nil) #*1000)
(equalp (nsubstitute 0 1 (copy-seq #*1111) :start 1 :end 3) #*1001)
(equalp (nsubstitute 0 1 (copy-seq #*11111111) :start 1 :end 7) #*10000001)
(equalp (nsubstitute 0 1 (copy-seq #*11111111) :start 1 :end 7 :count 3)
        #*10001111)
(equalp (nsubstitute 0 1 (copy-seq #*11111111)
                     :start 1 :end 7 :count 3 :from-end t)
        #*11110001)
(equalp (nsubstitute 1 1 (copy-seq #*10101010)
                    :start 1 :end 7 :count 3 :from-end t
                    :key #'(lambda (x) (if (zerop x) 1 0)))
        #*11111110)
(equalp (nsubstitute 1 1 (copy-seq #*10101010)
                    :start 1 :end 7 :count 3 :from-end t
                    :key #'(lambda (x) (if (zerop x) 1 0))
                    :test #'>=)
        #*10101110)



(equal (nsubstitute-if 'a #'(lambda (arg) (eq arg 'x)) (copy-seq '(x y z)))
       '(a y z))
(equal (nsubstitute-if 'b #'(lambda (arg) (eq arg 'y)) (copy-seq '(x y z)))
       '(x b z))
(equal (nsubstitute-if 'c #'(lambda (arg) (eq arg 'z)) (copy-seq '(x y z)))
       '(x y c))
(equal (nsubstitute-if 'a #'(lambda (arg) (eq arg 'p)) (copy-seq '(x y z)))
       '(x y z))
(equal (nsubstitute-if 'a #'(lambda (arg) (eq arg 'x)) (copy-seq '()))
                       '())
(equal (nsubstitute-if #\x #'(lambda (arg) (char< #\b arg))
                       (copy-seq '(#\a #\b #\c #\d #\e)))
       '(#\a #\b #\x #\x #\x))
(equal (nsubstitute-if '(a) #'(lambda (arg) (eq arg 'x))
                       (copy-seq '((x) (y) (z))) :key #'car)
       '((a) (y) (z)))
(equal (nsubstitute-if 'c #'(lambda (arg) (eq arg 'b))
                      (copy-seq '(a b a b a b a b))) '(a c a c a c a c))
(equal (nsubstitute-if 'a #'(lambda (arg) (eq arg 'b))
                       (copy-seq '(b b b))) '(a a a))
(equal (nsubstitute-if 'z #'(lambda (arg) (eq arg 'x))
                       (copy-seq '(a x b x c x d x e x f)))
       '(a z b z c z d z e z f))
(equal (nsubstitute-if 'z #'(lambda (arg) (eq arg 'x))
                       (copy-seq '(a x b x c x d x e x f)) :count nil)
       '(a z b z c z d z e z f))
(equal (nsubstitute-if 'z #'(lambda (arg) (eq arg 'x))
                       (copy-seq '(a x b x c x d x e x f)) :count 0)
       '(a x b x c x d x e x f))
(equal (nsubstitute-if 'z #'(lambda (arg) (eq arg 'x))
                       (copy-seq '(a x b x c x d x e x f)) :count -100)
       '(a x b x c x d x e x f))
(equal (nsubstitute-if 'z #'(lambda (arg) (eq arg 'x))
                       (copy-seq '(a x b x c x d x e x f)) :count 1)
       '(a z b x c x d x e x f))
(equal (nsubstitute-if 'z #'(lambda (arg) (eq arg 'x))
                       (copy-seq '(a x b x c x d x e x f)) :count 2)
       '(a z b z c x d x e x f))
(equal (nsubstitute-if 'z #'(lambda (arg) (eq arg 'x))
                       (copy-seq '(a x b x c x d x e x f)) :count 3)
       '(a z b z c z d x e x f))
(equal (nsubstitute-if 'z #'(lambda (arg) (eq arg 'x))
                       (copy-seq '(a x b x c x d x e x f)) :count 4)
       '(a z b z c z d z e x f))
(equal (nsubstitute-if 'z #'(lambda (arg) (eq arg 'x))
                       (copy-seq '(a x b x c x d x e x f)) :count 5)
       '(a z b z c z d z e z f))
(equal (nsubstitute-if 'z #'(lambda (arg) (eq arg 'x))
                       (copy-seq '(a x b x c x d x e x f)) :count 6)
       '(a z b z c z d z e z f))
(equal (nsubstitute-if 'z #'(lambda (arg) (eq arg 'x))
                       (copy-seq '(a x b x c x d x e x f)) :count 7)
       '(a z b z c z d z e z f))
(equal (nsubstitute-if 'z #'(lambda (arg) (eq arg 'x))
                       (copy-seq '(a x b x c x d x e x f))
                       :count nil :from-end t)
       '(a z b z c z d z e z f))
(equal (nsubstitute-if 'z #'(lambda (arg) (eq arg 'x))
                       (copy-seq '(a x b x c x d x e x f)) :count 0 :from-end t)
       '(a x b x c x d x e x f))
(equal (nsubstitute-if 'z #'(lambda (arg) (eq arg 'x))
                       (copy-seq '(a x b x c x d x e x f))
                       :count -100 :from-end t)
       '(a x b x c x d x e x f))
(equal (nsubstitute-if 'z #'(lambda (arg) (eq arg 'x))
                       (copy-seq '(a x b x c x d x e x f))
                       :count 1 :from-end t)
       '(a x b x c x d x e z f))
(equal (nsubstitute-if 'z #'(lambda (arg) (eq arg 'x))
                       (copy-seq '(a x b x c x d x e x f))
                       :count 2 :from-end t)
       '(a x b x c x d z e z f))
(equal (nsubstitute-if 'z #'(lambda (arg) (eq arg 'x))
                       (copy-seq '(a x b x c x d x e x f))
                       :count 3 :from-end t)
       '(a x b x c z d z e z f))
(equal (nsubstitute-if 'z #'(lambda (arg) (eq arg 'x))
                       (copy-seq '(a x b x c x d x e x f))
                       :count 4 :from-end t)
       '(a x b z c z d z e z f))
(equal (nsubstitute-if 'z #'(lambda (arg) (eq arg 'x))
                       (copy-seq '(a x b x c x d x e x f))
                       :count 5 :from-end t)
       '(a z b z c z d z e z f))
(equal (nsubstitute-if 'z #'(lambda (arg) (eq arg 'x))
                       (copy-seq '(a x b x c x d x e x f))
                       :count 6 :from-end t)
       '(a z b z c z d z e z f))
(equal (nsubstitute-if 'z #'(lambda (arg) (eq arg 'x))
                       (copy-seq '(a x b x c x d x e x f))
                       :count 7 :from-end t)
       '(a z b z c z d z e z f))
(equal (nsubstitute-if 'z #'(lambda (arg) (eq arg 'x))
                       (copy-seq '(a x b x c x d x e x f)) :start 2 :count 1)
       '(a x b z c x d x e x f))
(equal (nsubstitute-if 'z #'(lambda (arg) (eq arg 'x))
                       (copy-seq '(a x b x c x d x e x f))
                       :start 2 :end nil :count 1)
       '(a x b z c x d x e x f))
(equal (nsubstitute-if 'z #'(lambda (arg) (eq arg 'x))
                       (copy-seq '(a x b x c x d x e x f))
                       :start 2 :end 6 :count 100)
       '(a x b z c z d x e x f))
(equal (nsubstitute-if 'z #'(lambda (arg) (eq arg 'x))
                       (copy-seq '(a x b x c x d x e x f))
                       :start 2 :end 11 :count 100)
       '(a x b z c z d z e z f))
(equal (nsubstitute-if 'z #'(lambda (arg) (eq arg 'x))
                       (copy-seq '(a x b x c x d x e x f))
                       :start 2 :end 8 :count 10)
       '(a x b z c z d z e x f))
(equal (nsubstitute-if 'z #'(lambda (arg) (eq arg 'x))
                       (copy-seq '(a x b x c x d x e x f))
                   :start 2 :end 8 :count 2 :from-end t)
       '(a x b x c z d z e x f))
(equal (nsubstitute-if #\z #'(lambda (arg) (char< #\c arg))
                       (copy-seq '(#\a #\b #\c #\d #\e #\f)))
       '(#\a #\b #\c #\z #\z #\z))
(equal (nsubstitute-if "peace" #'(lambda (arg) (equal "war" arg))
                       (copy-seq '("love" "hate" "war" "peace")))
       '("love" "hate" "peace" "peace"))
(equal (nsubstitute-if "peace" #'(lambda (arg) (string-equal "war" arg))
                       (copy-seq '("war" "War" "WAr" "WAR")))
       '("peace" "peace" "peace" "peace"))
(equal (nsubstitute-if "peace" #'(lambda (arg) (string= "WAR" arg))
                       (copy-seq '("war" "War" "WAr" "WAR"))
                      :key #'string-upcase)
       '("peace" "peace" "peace" "peace"))
(equal (nsubstitute-if "peace" #'(lambda (arg) (string= "WAR" arg))
                       (copy-seq '("war" "War" "WAr" "WAR"))
                      :start 1
                      :end 2
                      :key #'string-upcase)
       '("war" "peace" "WAr" "WAR"))
(equal (nsubstitute-if "peace" #'(lambda (arg) (string= "WAR" arg))
                       (copy-seq '("war" "War" "WAr" "WAR"))
                      :start 1
                      :end nil
                      :key #'string-upcase)
       '("war" "peace" "peace" "peace"))
(equal (nsubstitute-if "peace" #'(lambda (arg) (string= "war" arg))
                       (copy-seq '("war" "War" "WAr" "WAR"))
                      :key #'string-upcase)
       '("war" "War" "WAr" "WAR"))
(equal (nsubstitute-if "peace" #'(lambda (arg) (string= "WAR" arg))
                       (copy-seq
                        '("war" "War" "WAr" "WAR" "war" "War" "WAr" "WAR"))
                       :start 1
                       :end 7
                       :count 1
                       :key #'string-upcase)
       '("war" "peace" "WAr" "WAR" "war" "War" "WAr" "WAR"))
(equal (nsubstitute-if "peace" #'(lambda (arg) (string= "WAR" arg))
                       (copy-seq
                        '("war" "War" "WAr" "WAR" "war" "War" "WAr" "WAR"))
                       :start 1
                       :end 7
                       :count 2
                       :key #'string-upcase)
       '("war" "peace" "peace" "WAR" "war" "War" "WAr" "WAR"))
(equal (nsubstitute-if "peace" #'(lambda (arg) (string= "WAR" arg))
                       (copy-seq
                        '("war" "War" "WAr" "WAR" "war" "War" "WAr" "WAR"))
                       :start 1
                       :end 7
                       :count 2
                       :from-end t
                       :key #'string-upcase)
       '("war" "War" "WAr" "WAR" "war" "peace" "peace" "WAR"))
(equal (nsubstitute-if "peace" #'(lambda (arg) (string= "WAR" arg))
                       (copy-seq
                        '("war" "War" "WAr" "WAR" "war" "War" "WAr" "WAR"))
                       :start 1
                       :end 7
                       :count 0
                       :from-end t
                       :key #'string-upcase)
       '("war" "War" "WAr" "WAR" "war" "War" "WAr" "WAR"))
(equal (nsubstitute-if "peace" #'(lambda (arg) (string= "WAR" arg))
                       (copy-seq
                        '("war" "War" "WAr" "WAR" "war" "War" "WAr" "WAR"))
                       :start 1
                       :end 7
                       :count -2
                       :from-end t
                       :key #'string-upcase)
       '("war" "War" "WAr" "WAR" "war" "War" "WAr" "WAR"))
(equal (nsubstitute-if "peace" #'(lambda (arg) (string= "WAR" arg))
                       (copy-seq
                        '("war" "War" "WAr" "WAR" "war" "War" "WAr" "WAR"))
                       :start 1
                       :end 7
                       :count nil
                       :from-end t
                       :key #'string-upcase)
       '("war" "peace" "peace" "peace" "peace" "peace" "peace" "WAR"))
(equal (nsubstitute-if "peace" #'(lambda (arg) (string= "WAR" arg))
                       (copy-seq
                        '("war" "War" "WAr" "WAR" "war" "War" "WAr" "WAR"))
                       :start 1
                       :end 7
                       :count 6
                       :from-end t
                       :key #'string-upcase)
       '("war" "peace" "peace" "peace" "peace" "peace" "peace" "WAR"))
(equal (nsubstitute-if "peace" #'(lambda (arg) (string= "WAR" arg))
                       (copy-seq
                        '("war" "War" "WAr" "WAR" "war" "War" "WAr" "WAR"))
                       :start 1
                       :end 7
                       :count 7
                       :from-end t
                       :key #'string-upcase)
       '("war" "peace" "peace" "peace" "peace" "peace" "peace" "WAR"))
(equal (nsubstitute-if "peace" #'(lambda (arg) (string= "WAR" arg))
                       (copy-seq
                        '("war" "War" "WAr" "WAR" "war" "War" "WAr" "WAR"))
                       :start 1
                       :end 7
                       :count 100
                       :from-end t
                       :key #'string-upcase)
       '("war" "peace" "peace" "peace" "peace" "peace" "peace" "WAR"))


(equalp (nsubstitute-if 'a #'(lambda (arg) (eq arg 'x)) (copy-seq #(x y z)))
        #(a y z))
(equalp (nsubstitute-if 'b #'(lambda (arg) (eq arg 'y)) (copy-seq #(x y z)))
        #(x b z))
(equalp (nsubstitute-if 'c #'(lambda (arg) (eq arg 'z)) (copy-seq #(x y z)))
        #(x y c))
(equalp (nsubstitute-if 'a #'(lambda (arg) (eq arg 'p)) (copy-seq #(x y z)))
        #(x y z))
(equalp (nsubstitute-if 'a #'(lambda (arg) (eq arg 'x)) (copy-seq #())) #())
(equalp (nsubstitute-if #\x #'(lambda (arg) (char< #\b arg))
                        (copy-seq #(#\a #\b #\c #\d #\e)))
        #(#\a #\b #\x #\x #\x))
(equalp (nsubstitute-if '(a) #'(lambda (arg) (eq arg 'x))
                        (copy-seq #((x) (y) (z))) :key #'car)
        #((a) (y) (z)))
(equalp (nsubstitute-if 'c #'(lambda (arg) (eq arg 'b))
                        (copy-seq #(a b a b a b a b))) #(a c a c a c a c))
(equalp (nsubstitute-if 'a #'(lambda (arg) (eq arg 'b))
                        (copy-seq #(b b b))) #(a a a))
(equalp (nsubstitute-if 'z #'(lambda (arg) (eq arg 'x))
                        (copy-seq #(a x b x c x d x e x f)))
       #(a z b z c z d z e z f))
(equalp (nsubstitute-if 'z #'(lambda (arg) (eq arg 'x))
                        (copy-seq #(a x b x c x d x e x f)) :count nil)
        #(a z b z c z d z e z f))
(equalp (nsubstitute-if 'z #'(lambda (arg) (eq arg 'x))
                        (copy-seq #(a x b x c x d x e x f)) :count 0)
        #(a x b x c x d x e x f))
(equalp (nsubstitute-if 'z #'(lambda (arg) (eq arg 'x))
                        (copy-seq #(a x b x c x d x e x f)) :count -100)
        #(a x b x c x d x e x f))
(equalp (nsubstitute-if 'z #'(lambda (arg) (eq arg 'x))
                        (copy-seq #(a x b x c x d x e x f)) :count 1)
        #(a z b x c x d x e x f))
(equalp (nsubstitute-if 'z #'(lambda (arg) (eq arg 'x))
                        (copy-seq #(a x b x c x d x e x f)) :count 2)
        #(a z b z c x d x e x f))
(equalp (nsubstitute-if 'z #'(lambda (arg) (eq arg 'x))
                        (copy-seq #(a x b x c x d x e x f)) :count 3)
        #(a z b z c z d x e x f))
(equalp (nsubstitute-if 'z #'(lambda (arg) (eq arg 'x))
                        (copy-seq #(a x b x c x d x e x f)) :count 4)
        #(a z b z c z d z e x f))
(equalp (nsubstitute-if 'z #'(lambda (arg) (eq arg 'x))
                        (copy-seq #(a x b x c x d x e x f)) :count 5)
        #(a z b z c z d z e z f))
(equalp (nsubstitute-if 'z #'(lambda (arg) (eq arg 'x))
                        (copy-seq #(a x b x c x d x e x f)) :count 6)
        #(a z b z c z d z e z f))
(equalp (nsubstitute-if 'z #'(lambda (arg) (eq arg 'x))
                        (copy-seq #(a x b x c x d x e x f)) :count 7)
        #(a z b z c z d z e z f))
(equalp (nsubstitute-if 'z #'(lambda (arg) (eq arg 'x))
                        (copy-seq #(a x b x c x d x e x f))
                        :count nil :from-end t)
        #(a z b z c z d z e z f))
(equalp (nsubstitute-if 'z #'(lambda (arg) (eq arg 'x))
                        (copy-seq #(a x b x c x d x e x f))
                        :count 0 :from-end t)
        #(a x b x c x d x e x f))
(equalp (nsubstitute-if 'z #'(lambda (arg) (eq arg 'x))
                        (copy-seq #(a x b x c x d x e x f))
                        :count -100 :from-end t)
        #(a x b x c x d x e x f))
(equalp (nsubstitute-if 'z #'(lambda (arg) (eq arg 'x))
                        (copy-seq #(a x b x c x d x e x f))
                        :count 1 :from-end t)
        #(a x b x c x d x e z f))
(equalp (nsubstitute-if 'z #'(lambda (arg) (eq arg 'x))
                        (copy-seq #(a x b x c x d x e x f))
                        :count 2 :from-end t)
        #(a x b x c x d z e z f))
(equalp (nsubstitute-if 'z #'(lambda (arg) (eq arg 'x))
                        (copy-seq #(a x b x c x d x e x f))
                        :count 3 :from-end t)
        #(a x b x c z d z e z f))
(equalp (nsubstitute-if 'z #'(lambda (arg) (eq arg 'x))
                        (copy-seq #(a x b x c x d x e x f))
                        :count 4 :from-end t)
        #(a x b z c z d z e z f))
(equalp (nsubstitute-if 'z #'(lambda (arg) (eq arg 'x))
                        (copy-seq #(a x b x c x d x e x f))
                        :count 5 :from-end t)
        #(a z b z c z d z e z f))
(equalp (nsubstitute-if 'z #'(lambda (arg) (eq arg 'x))
                        (copy-seq #(a x b x c x d x e x f))
                        :count 6 :from-end t)
        #(a z b z c z d z e z f))
(equalp (nsubstitute-if 'z #'(lambda (arg) (eq arg 'x))
                        (copy-seq #(a x b x c x d x e x f))
                        :count 7 :from-end t)
        #(a z b z c z d z e z f))
(equalp (nsubstitute-if 'z #'(lambda (arg) (eq arg 'x))
                        (copy-seq #(a x b x c x d x e x f))
                        :start 2 :count 1)
        #(a x b z c x d x e x f))
(equalp (nsubstitute-if 'z #'(lambda (arg) (eq arg 'x))
                        (copy-seq #(a x b x c x d x e x f))
                        :start 2 :end nil :count 1)
        #(a x b z c x d x e x f))
(equalp (nsubstitute-if 'z #'(lambda (arg) (eq arg 'x))
                        (copy-seq #(a x b x c x d x e x f))
                        :start 2 :end 6 :count 100)
        #(a x b z c z d x e x f))
(equalp (nsubstitute-if 'z #'(lambda (arg) (eq arg 'x))
                        (copy-seq #(a x b x c x d x e x f))
                        :start 2 :end 11 :count 100)
        #(a x b z c z d z e z f))
(equalp (nsubstitute-if 'z #'(lambda (arg) (eq arg 'x))
                        (copy-seq #(a x b x c x d x e x f))
                        :start 2 :end 8 :count 10)
        #(a x b z c z d z e x f))
(equalp (nsubstitute-if 'z #'(lambda (arg) (eq arg 'x))
                        (copy-seq #(a x b x c x d x e x f))
                        :start 2 :end 8 :count 2 :from-end t)
        #(a x b x c z d z e x f))
(equalp (nsubstitute-if #\z #'(lambda (arg) (char< #\c arg))
                        (copy-seq #(#\a #\b #\c #\d #\e #\f)))
        #(#\a #\b #\c #\z #\z #\z))
(equalp (nsubstitute-if "peace" #'(lambda (arg) (equal "war" arg))
                        (copy-seq #("love" "hate" "war" "peace")))
       #("love" "hate" "peace" "peace"))
(equalp (nsubstitute-if "peace" #'(lambda (arg) (string-equal "war" arg))
                        (copy-seq #("war" "War" "WAr" "WAR")))
       #("peace" "peace" "peace" "peace"))
(equalp (nsubstitute-if "peace" #'(lambda (arg) (string= "WAR" arg))
                        (copy-seq #("war" "War" "WAr" "WAR"))
                      :key #'string-upcase)
       #("peace" "peace" "peace" "peace"))
(equalp (nsubstitute-if "peace" #'(lambda (arg) (string= "WAR" arg))
                        (copy-seq #("war" "War" "WAr" "WAR"))
                        :start 1
                        :end 2
                        :key #'string-upcase)
        #("war" "peace" "WAr" "WAR"))
(equalp (nsubstitute-if "peace" #'(lambda (arg) (string= "WAR" arg))
                        (copy-seq #("war" "War" "WAr" "WAR"))
                        :start 1
                        :end nil
                        :key #'string-upcase)
        #("war" "peace" "peace" "peace"))
(equalp (nsubstitute-if "peace" #'(lambda (arg) (string= "war" arg))
                        (copy-seq #("war" "War" "WAr" "WAR"))
                        :key #'string-upcase)
        #("war" "War" "WAr" "WAR"))
(equalp (nsubstitute-if "peace" #'(lambda (arg) (string= "WAR" arg))
                        (copy-seq
                         #("war" "War" "WAr" "WAR" "war" "War" "WAr" "WAR"))
                        :start 1
                        :end 7
                        :count 1
                        :key #'string-upcase)
        #("war" "peace" "WAr" "WAR" "war" "War" "WAr" "WAR"))
(equalp (nsubstitute-if "peace" #'(lambda (arg) (string= "WAR" arg))
                        (copy-seq
                         #("war" "War" "WAr" "WAR" "war" "War" "WAr" "WAR"))
                        :start 1
                        :end 7
                        :count 2
                        :key #'string-upcase)
        #("war" "peace" "peace" "WAR" "war" "War" "WAr" "WAR"))
(equalp (nsubstitute-if "peace" #'(lambda (arg) (string= "WAR" arg))
                        (copy-seq
                         #("war" "War" "WAr" "WAR" "war" "War" "WAr" "WAR"))
                        :start 1
                        :end 7
                        :count 2
                        :from-end t
                        :key #'string-upcase)
        #("war" "War" "WAr" "WAR" "war" "peace" "peace" "WAR"))
(equalp (nsubstitute-if "peace" #'(lambda (arg) (string= "WAR" arg))
                        (copy-seq
                         #("war" "War" "WAr" "WAR" "war" "War" "WAr" "WAR"))
                        :start 1
                        :end 7
                        :count 0
                        :from-end t
                        :key #'string-upcase)
        #("war" "War" "WAr" "WAR" "war" "War" "WAr" "WAR"))
(equalp (nsubstitute-if "peace" #'(lambda (arg) (string= "WAR" arg))
                        (copy-seq
                         #("war" "War" "WAr" "WAR" "war" "War" "WAr" "WAR"))
                        :start 1
                        :end 7
                        :count -2
                        :from-end t
                        :key #'string-upcase)
        #("war" "War" "WAr" "WAR" "war" "War" "WAr" "WAR"))
(equalp (nsubstitute-if "peace" #'(lambda (arg) (string= "WAR" arg))
                        (copy-seq
                         #("war" "War" "WAr" "WAR" "war" "War" "WAr" "WAR"))
                        :start 1
                        :end 7
                        :count nil
                        :from-end t
                        :key #'string-upcase)
        #("war" "peace" "peace" "peace" "peace" "peace" "peace" "WAR"))
(equalp (nsubstitute-if "peace" #'(lambda (arg) (string= "WAR" arg))
                        (copy-seq
                         #("war" "War" "WAr" "WAR" "war" "War" "WAr" "WAR"))
                        :start 1
                        :end 7
                        :count 6
                        :from-end t
                        :key #'string-upcase)
        #("war" "peace" "peace" "peace" "peace" "peace" "peace" "WAR"))
(equalp (nsubstitute-if "peace" #'(lambda (arg) (string= "WAR" arg))
                        (copy-seq
                         #("war" "War" "WAr" "WAR" "war" "War" "WAr" "WAR"))
                        :start 1
                        :end 7
                        :count 7
                        :from-end t
                        :key #'string-upcase)
        #("war" "peace" "peace" "peace" "peace" "peace" "peace" "WAR"))
(equalp (nsubstitute-if "peace" #'(lambda (arg) (string= "WAR" arg))
                        (copy-seq
                         #("war" "War" "WAr" "WAR" "war" "War" "WAr" "WAR"))
                        :start 1
                        :end 7
                        :count 100
                        :from-end t
                        :key #'string-upcase)
        #("war" "peace" "peace" "peace" "peace" "peace" "peace" "WAR"))

(string= (nsubstitute-if #\A #'(lambda (arg) (eql #\a arg))
                         (copy-seq "abcabc")) "AbcAbc")
(string= (nsubstitute-if #\A #'(lambda (arg) (eql #\a arg)) (copy-seq "")) "")
(string= (nsubstitute-if #\A #'(lambda (arg) (eql #\a arg)) (copy-seq "xyz"))
         "xyz")
(string= (nsubstitute-if #\A #'(lambda (arg) (eql #\a arg))
                         (copy-seq "aaaaaaaaaa") :start 5 :end nil)
         "aaaaaAAAAA")
(string= (nsubstitute-if #\x #'(lambda (arg) (char< #\5 arg))
                         (copy-seq "0123456789")) "012345xxxx")
(string= (nsubstitute-if #\x #'(lambda (arg) (char> #\5 arg))
                         (copy-seq "0123456789")) "xxxxx56789")
(string= (nsubstitute-if #\x #'(lambda (arg) (char> #\D arg))
                         (copy-seq "abcdefg")
                         :key #'char-upcase)
         "xxxdefg")
(string= (nsubstitute-if #\x #'(lambda (arg) (char> #\D arg))
                         (copy-seq "abcdefg")
                         :start 1
                         :end 2
                         :key #'char-upcase)
         "axcdefg")
(string= (nsubstitute-if #\A #'(lambda (arg) (eql #\a arg))
                         (copy-seq "aaaaaaaaaa") :count 2) "AAaaaaaaaa")
(string= (nsubstitute-if #\A #'(lambda (arg) (eql #\a arg))
                         (copy-seq "aaaaaaaaaa") :count -1) "aaaaaaaaaa")
(string= (nsubstitute-if #\A #'(lambda (arg) (eql #\a arg))
                         (copy-seq "aaaaaaaaaa") :count 0) "aaaaaaaaaa")
(string= (nsubstitute-if #\A #'(lambda (arg) (eql #\a arg))
                         (copy-seq "aaaaaaaaaa") :count nil) "AAAAAAAAAA")
(string= (nsubstitute-if #\A #'(lambda (arg) (eql #\a arg))
                         (copy-seq "aaaaaaaaaa") :count 100) "AAAAAAAAAA")
(string= (nsubstitute-if #\A #'(lambda (arg) (eql #\a arg))
                         (copy-seq "aaaaaaaaaa") :count 9) "AAAAAAAAAa")
(string= (nsubstitute-if #\A #'(lambda (arg) (eql #\a arg))
                         (copy-seq "aaaaaaaaaa") :count 9 :from-end t)
         "aAAAAAAAAA")
(string= (nsubstitute-if #\A #'(lambda (arg) (eql #\a arg))
                         (copy-seq "aaaaaaaaaa")
                        :start 2
                        :end 8
                        :count 3)
         "aaAAAaaaaa")
(string= (nsubstitute-if #\A #'(lambda (arg) (eql #\a arg))
                         (copy-seq "aaaaaaaaaa")
                        :start 2
                        :end 8
                        :from-end t
                        :count 3)
         "aaaaaAAAaa")
(string= (nsubstitute-if #\x #'(lambda (arg) (eql #\A arg))
                         (copy-seq "aaaaaaaaaa")
                        :start 2
                        :end 8
                        :from-end t
                        :count 3)
         "aaaaaaaaaa")
(string= (nsubstitute-if #\X #'(lambda (arg) (eql #\A arg))
                         (copy-seq "aaaaaaaaaa")
                        :start 2
                        :end 8
                        :from-end t
                        :key #'char-upcase
                        :count 3)
         "aaaaaXXXaa")
(string= (nsubstitute-if #\X #'(lambda (arg) (char< #\D arg))
                         (copy-seq "abcdefghij")
                        :start 2
                        :end 8
                        :from-end t
                        :key #'char-upcase
                        :count 3)
         "abcdeXXXij")
(equalp (nsubstitute-if 0 #'(lambda (arg) (= 1 arg)) (copy-seq #*1111)) #*0000)
(equalp (nsubstitute-if 0 #'(lambda (arg) (= 1 arg))
                        (copy-seq #*1111) :start 1 :end nil) #*1000)
(equalp (nsubstitute-if 0 #'(lambda (arg) (= 1 arg))
                        (copy-seq #*1111) :start 1 :end 3) #*1001)
(equalp (nsubstitute-if 0 #'(lambda (arg) (= 1 arg))
                        (copy-seq #*11111111) :start 1 :end 7) #*10000001)
(equalp (nsubstitute-if 0 #'(lambda (arg) (= 1 arg))
                        (copy-seq #*11111111) :start 1 :end 7 :count 3)
        #*10001111)
(equalp (nsubstitute-if 0 #'(lambda (arg) (= 1 arg))
                        (copy-seq #*11111111)
                        :start 1 :end 7 :count 3 :from-end t)
        #*11110001)
(equalp (nsubstitute-if 1 #'(lambda (arg) (= 1 arg))
                        (copy-seq #*10101010)
                        :start 1 :end 7 :count 3 :from-end t
                        :key #'(lambda (x) (if (zerop x) 1 0)))
        #*11111110)
(equalp (nsubstitute-if 1 #'(lambda (arg) (>= 1 arg))
                        (copy-seq #*10101010)
                        :start 1 :end 7 :count 3 :from-end t
                        :key #'(lambda (x) (if (zerop x) 1 0)))
        #*10101110)


(equal (nsubstitute-if-not 'a #'(lambda (arg) (not (eq arg 'x)))
                           (copy-seq '(x y z)))
       '(a y z))
(equal (nsubstitute-if-not 'b #'(lambda (arg) (not (eq arg 'y)))
                           (copy-seq '(x y z)))
       '(x b z))
(equal (nsubstitute-if-not 'c #'(lambda (arg) (not (eq arg 'z)))
                           (copy-seq '(x y z)))
       '(x y c))
(equal (nsubstitute-if-not 'a #'(lambda (arg) (not (eq arg 'p)))
                           (copy-seq '(x y z)))
       '(x y z))
(equal (nsubstitute-if-not 'a #'(lambda (arg) (not (eq arg 'x)))
                           (copy-seq '())) '())
(equal (nsubstitute-if-not #\x #'(lambda (arg) (not (char< #\b arg)))
                           (copy-seq '(#\a #\b #\c #\d #\e)))
       '(#\a #\b #\x #\x #\x))
(equal (nsubstitute-if-not '(a) #'(lambda (arg) (not (eq arg 'x)))
                           (copy-seq '((x) (y) (z))) :key #'car)
       '((a) (y) (z)))
(equal (nsubstitute-if-not 'c #'(lambda (arg) (not (eq arg 'b)))
                           (copy-seq '(a b a b a b a b))) '(a c a c a c a c))
(equal (nsubstitute-if-not 'a #'(lambda (arg) (not (eq arg 'b)))
                           (copy-seq '(b b b))) '(a a a))
(equal (nsubstitute-if-not 'z #'(lambda (arg) (not (eq arg 'x)))
                           (copy-seq '(a x b x c x d x e x f)))
       '(a z b z c z d z e z f))
(equal (nsubstitute-if-not 'z #'(lambda (arg) (not (eq arg 'x)))
                           (copy-seq '(a x b x c x d x e x f)) :count nil)
       '(a z b z c z d z e z f))
(equal (nsubstitute-if-not 'z #'(lambda (arg) (not (eq arg 'x)))
                           (copy-seq '(a x b x c x d x e x f)) :count 0)
       '(a x b x c x d x e x f))
(equal (nsubstitute-if-not 'z #'(lambda (arg) (not (eq arg 'x)))
                           (copy-seq '(a x b x c x d x e x f)) :count -100)
       '(a x b x c x d x e x f))
(equal (nsubstitute-if-not 'z #'(lambda (arg) (not (eq arg 'x)))
                           (copy-seq '(a x b x c x d x e x f)) :count 1)
       '(a z b x c x d x e x f))
(equal (nsubstitute-if-not 'z #'(lambda (arg) (not (eq arg 'x)))
                           (copy-seq '(a x b x c x d x e x f)) :count 2)
       '(a z b z c x d x e x f))
(equal (nsubstitute-if-not 'z #'(lambda (arg) (not (eq arg 'x)))
                           (copy-seq '(a x b x c x d x e x f)) :count 3)
       '(a z b z c z d x e x f))
(equal (nsubstitute-if-not 'z #'(lambda (arg) (not (eq arg 'x)))
                           (copy-seq '(a x b x c x d x e x f)) :count 4)
       '(a z b z c z d z e x f))
(equal (nsubstitute-if-not 'z #'(lambda (arg) (not (eq arg 'x)))
                           (copy-seq '(a x b x c x d x e x f)) :count 5)
       '(a z b z c z d z e z f))
(equal (nsubstitute-if-not 'z #'(lambda (arg) (not (eq arg 'x)))
                           (copy-seq '(a x b x c x d x e x f)) :count 6)
       '(a z b z c z d z e z f))
(equal (nsubstitute-if-not 'z #'(lambda (arg) (not (eq arg 'x)))
                           (copy-seq '(a x b x c x d x e x f)) :count 7)
       '(a z b z c z d z e z f))
(equal (nsubstitute-if-not 'z #'(lambda (arg) (not (eq arg 'x)))
                           (copy-seq '(a x b x c x d x e x f))
                           :count nil :from-end t)
       '(a z b z c z d z e z f))
(equal (nsubstitute-if-not 'z #'(lambda (arg) (not (eq arg 'x)))
                           (copy-seq '(a x b x c x d x e x f))
                           :count 0 :from-end t)
       '(a x b x c x d x e x f))
(equal (nsubstitute-if-not 'z #'(lambda (arg) (not (eq arg 'x)))
                           (copy-seq '(a x b x c x d x e x f))
                           :count -100 :from-end t)
       '(a x b x c x d x e x f))
(equal (nsubstitute-if-not 'z #'(lambda (arg) (not (eq arg 'x)))
                           (copy-seq '(a x b x c x d x e x f))
                           :count 1 :from-end t)
       '(a x b x c x d x e z f))
(equal (nsubstitute-if-not 'z #'(lambda (arg) (not (eq arg 'x)))
                           (copy-seq '(a x b x c x d x e x f))
                           :count 2 :from-end t)
       '(a x b x c x d z e z f))
(equal (nsubstitute-if-not 'z #'(lambda (arg) (not (eq arg 'x)))
                           (copy-seq '(a x b x c x d x e x f))
                           :count 3 :from-end t)
       '(a x b x c z d z e z f))
(equal (nsubstitute-if-not 'z #'(lambda (arg) (not (eq arg 'x)))
                           (copy-seq '(a x b x c x d x e x f))
                           :count 4 :from-end t)
       '(a x b z c z d z e z f))
(equal (nsubstitute-if-not 'z #'(lambda (arg) (not (eq arg 'x)))
                           (copy-seq '(a x b x c x d x e x f))
                           :count 5 :from-end t)
       '(a z b z c z d z e z f))
(equal (nsubstitute-if-not 'z #'(lambda (arg) (not (eq arg 'x)))
                           (copy-seq '(a x b x c x d x e x f))
                           :count 6 :from-end t)
       '(a z b z c z d z e z f))
(equal (nsubstitute-if-not 'z #'(lambda (arg) (not (eq arg 'x)))
                           (copy-seq '(a x b x c x d x e x f))
                           :count 7 :from-end t)
       '(a z b z c z d z e z f))
(equal (nsubstitute-if-not 'z #'(lambda (arg) (not (eq arg 'x)))
                           (copy-seq '(a x b x c x d x e x f))
                           :start 2 :count 1)
       '(a x b z c x d x e x f))
(equal (nsubstitute-if-not 'z #'(lambda (arg) (not (eq arg 'x)))
                           (copy-seq '(a x b x c x d x e x f))
                           :start 2 :end nil :count 1)
       '(a x b z c x d x e x f))
(equal (nsubstitute-if-not 'z #'(lambda (arg) (not (eq arg 'x)))
                           (copy-seq '(a x b x c x d x e x f))
                           :start 2 :end 6 :count 100)
       '(a x b z c z d x e x f))
(equal (nsubstitute-if-not 'z #'(lambda (arg) (not (eq arg 'x)))
                           (copy-seq '(a x b x c x d x e x f))
                           :start 2 :end 11 :count 100)
       '(a x b z c z d z e z f))
(equal (nsubstitute-if-not 'z #'(lambda (arg) (not (eq arg 'x)))
                           (copy-seq '(a x b x c x d x e x f))
                           :start 2 :end 8 :count 10)
       '(a x b z c z d z e x f))
(equal (nsubstitute-if-not 'z #'(lambda (arg) (not (eq arg 'x)))
                           (copy-seq '(a x b x c x d x e x f))
                   :start 2 :end 8 :count 2 :from-end t)
       '(a x b x c z d z e x f))
(equal (nsubstitute-if-not #\z #'(lambda (arg) (not (char< #\c arg)))
                           (copy-seq '(#\a #\b #\c #\d #\e #\f)))
       '(#\a #\b #\c #\z #\z #\z))
(equal (nsubstitute-if-not "peace" #'(lambda (arg) (not (equal "war" arg)))
                           (copy-seq '("love" "hate" "war" "peace")))
       '("love" "hate" "peace" "peace"))
(equal (nsubstitute-if-not "peace"
                          #'(lambda (arg) (not (string-equal "war" arg)))
                          (copy-seq '("war" "War" "WAr" "WAR")))
       '("peace" "peace" "peace" "peace"))
(equal (nsubstitute-if-not "peace" #'(lambda (arg) (not (string= "WAR" arg)))
                           (copy-seq '("war" "War" "WAr" "WAR"))
                           :key #'string-upcase)
       '("peace" "peace" "peace" "peace"))
(equal (nsubstitute-if-not "peace" #'(lambda (arg) (not (string= "WAR" arg)))
                           (copy-seq '("war" "War" "WAr" "WAR"))
                           :start 1
                           :end 2
                           :key #'string-upcase)
       '("war" "peace" "WAr" "WAR"))
(equal (nsubstitute-if-not "peace" #'(lambda (arg) (not (string= "WAR" arg)))
                           (copy-seq '("war" "War" "WAr" "WAR"))
                           :start 1
                           :end nil
                           :key #'string-upcase)
       '("war" "peace" "peace" "peace"))
(equal (nsubstitute-if-not "peace" #'(lambda (arg) (not (string= "war" arg)))
                           (copy-seq '("war" "War" "WAr" "WAR"))
                           :key #'string-upcase)
       '("war" "War" "WAr" "WAR"))
(equal (nsubstitute-if-not "peace" #'(lambda (arg) (not (string= "WAR" arg)))
                           (copy-seq
                            '("war" "War" "WAr" "WAR" "war" "War" "WAr" "WAR"))
                           :start 1
                           :end 7
                           :count 1
                           :key #'string-upcase)
       '("war" "peace" "WAr" "WAR" "war" "War" "WAr" "WAR"))
(equal (nsubstitute-if-not "peace" #'(lambda (arg) (not (string= "WAR" arg)))
                           (copy-seq
                            '("war" "War" "WAr" "WAR" "war" "War" "WAr" "WAR"))
                           :start 1
                           :end 7
                           :count 2
                           :key #'string-upcase)
       '("war" "peace" "peace" "WAR" "war" "War" "WAr" "WAR"))
(equal (nsubstitute-if-not "peace" #'(lambda (arg) (not (string= "WAR" arg)))
                           (copy-seq
                            '("war" "War" "WAr" "WAR" "war" "War" "WAr" "WAR"))
                           :start 1
                           :end 7
                           :count 2
                           :from-end t
                           :key #'string-upcase)
       '("war" "War" "WAr" "WAR" "war" "peace" "peace" "WAR"))
(equal (nsubstitute-if-not "peace" #'(lambda (arg) (not (string= "WAR" arg)))
                           (copy-seq
                            '("war" "War" "WAr" "WAR" "war" "War" "WAr" "WAR"))
                           :start 1
                           :end 7
                           :count 0
                           :from-end t
                           :key #'string-upcase)
       '("war" "War" "WAr" "WAR" "war" "War" "WAr" "WAR"))
(equal (nsubstitute-if-not "peace" #'(lambda (arg) (not (string= "WAR" arg)))
                           (copy-seq
                            '("war" "War" "WAr" "WAR" "war" "War" "WAr" "WAR"))
                           :start 1
                           :end 7
                           :count -2
                           :from-end t
                           :key #'string-upcase)
       '("war" "War" "WAr" "WAR" "war" "War" "WAr" "WAR"))
(equal (nsubstitute-if-not "peace" #'(lambda (arg) (not (string= "WAR" arg)))
                           (copy-seq
                            '("war" "War" "WAr" "WAR" "war" "War" "WAr" "WAR"))
                           :start 1
                           :end 7
                           :count nil
                           :from-end t
                           :key #'string-upcase)
       '("war" "peace" "peace" "peace" "peace" "peace" "peace" "WAR"))
(equal (nsubstitute-if-not "peace" #'(lambda (arg) (not (string= "WAR" arg)))
                           (copy-seq
                            '("war" "War" "WAr" "WAR" "war" "War" "WAr" "WAR"))
                           :start 1
                           :end 7
                           :count 6
                           :from-end t
                           :key #'string-upcase)
       '("war" "peace" "peace" "peace" "peace" "peace" "peace" "WAR"))
(equal (nsubstitute-if-not "peace" #'(lambda (arg) (not (string= "WAR" arg)))
                           (copy-seq
                            '("war" "War" "WAr" "WAR" "war" "War" "WAr" "WAR"))
                           :start 1
                           :end 7
                           :count 7
                           :from-end t
                           :key #'string-upcase)
       '("war" "peace" "peace" "peace" "peace" "peace" "peace" "WAR"))
(equal (nsubstitute-if-not "peace" #'(lambda (arg) (not (string= "WAR" arg)))
                           (copy-seq
                            '("war" "War" "WAr" "WAR" "war" "War" "WAr" "WAR"))
                           :start 1
                           :end 7
                           :count 100
                           :from-end t
                           :key #'string-upcase)
       '("war" "peace" "peace" "peace" "peace" "peace" "peace" "WAR"))


(equalp (nsubstitute-if-not 'a #'(lambda (arg) (not (eq arg 'x)))
                            (copy-seq #(x y z))) #(a y z))
(equalp (nsubstitute-if-not 'b #'(lambda (arg) (not (eq arg 'y)))
                            (copy-seq #(x y z))) #(x b z))
(equalp (nsubstitute-if-not 'c #'(lambda (arg) (not (eq arg 'z)))
                            (copy-seq #(x y z))) #(x y c))
(equalp (nsubstitute-if-not 'a #'(lambda (arg) (not (eq arg 'p)))
                            (copy-seq #(x y z))) #(x y z))
(equalp (nsubstitute-if-not 'a #'(lambda (arg) (not (eq arg 'x)))
                            (copy-seq #())) #())
(equalp (nsubstitute-if-not #\x #'(lambda (arg) (not (char< #\b arg)))
                            (copy-seq #(#\a #\b #\c #\d #\e)))
       #(#\a #\b #\x #\x #\x))
(equalp (nsubstitute-if-not '(a) #'(lambda (arg) (not (eq arg 'x)))
                            (copy-seq #((x) (y) (z))) :key #'car)
       #((a) (y) (z)))
(equalp (nsubstitute-if-not 'c #'(lambda (arg) (not (eq arg 'b)))
                            (copy-seq #(a b a b a b a b))) #(a c a c a c a c))
(equalp (nsubstitute-if-not 'a #'(lambda (arg) (not (eq arg 'b)))
                            (copy-seq #(b b b))) #(a a a))
(equalp (nsubstitute-if-not 'z #'(lambda (arg) (not (eq arg 'x)))
                            (copy-seq #(a x b x c x d x e x f)))
       #(a z b z c z d z e z f))
(equalp (nsubstitute-if-not 'z #'(lambda (arg) (not (eq arg 'x)))
                            (copy-seq #(a x b x c x d x e x f)) :count nil)
       #(a z b z c z d z e z f))
(equalp (nsubstitute-if-not 'z #'(lambda (arg) (not (eq arg 'x)))
                            (copy-seq #(a x b x c x d x e x f)) :count 0)
       #(a x b x c x d x e x f))
(equalp (nsubstitute-if-not 'z #'(lambda (arg) (not (eq arg 'x)))
                            (copy-seq #(a x b x c x d x e x f)) :count -100)
       #(a x b x c x d x e x f))
(equalp (nsubstitute-if-not 'z #'(lambda (arg) (not (eq arg 'x)))
                            (copy-seq #(a x b x c x d x e x f)) :count 1)
       #(a z b x c x d x e x f))
(equalp (nsubstitute-if-not 'z #'(lambda (arg) (not (eq arg 'x)))
                            (copy-seq #(a x b x c x d x e x f)) :count 2)
       #(a z b z c x d x e x f))
(equalp (nsubstitute-if-not 'z #'(lambda (arg) (not (eq arg 'x)))
                            (copy-seq #(a x b x c x d x e x f)) :count 3)
       #(a z b z c z d x e x f))
(equalp (nsubstitute-if-not 'z #'(lambda (arg) (not (eq arg 'x)))
                            (copy-seq #(a x b x c x d x e x f)) :count 4)
       #(a z b z c z d z e x f))
(equalp (nsubstitute-if-not 'z #'(lambda (arg) (not (eq arg 'x)))
                            (copy-seq #(a x b x c x d x e x f)) :count 5)
       #(a z b z c z d z e z f))
(equalp (nsubstitute-if-not 'z #'(lambda (arg) (not (eq arg 'x)))
                            (copy-seq #(a x b x c x d x e x f)) :count 6)
       #(a z b z c z d z e z f))
(equalp (nsubstitute-if-not 'z #'(lambda (arg) (not (eq arg 'x)))
                            (copy-seq #(a x b x c x d x e x f)) :count 7)
       #(a z b z c z d z e z f))
(equalp (nsubstitute-if-not 'z #'(lambda (arg) (not (eq arg 'x)))
                            (copy-seq #(a x b x c x d x e x f))
                            :count nil :from-end t)
       #(a z b z c z d z e z f))
(equalp (nsubstitute-if-not 'z #'(lambda (arg) (not (eq arg 'x)))
                            (copy-seq #(a x b x c x d x e x f))
                            :count 0 :from-end t)
       #(a x b x c x d x e x f))
(equalp (nsubstitute-if-not 'z #'(lambda (arg) (not (eq arg 'x)))
                            (copy-seq #(a x b x c x d x e x f))
                            :count -100 :from-end t)
       #(a x b x c x d x e x f))
(equalp (nsubstitute-if-not 'z #'(lambda (arg) (not (eq arg 'x)))
                            (copy-seq #(a x b x c x d x e x f))
                            :count 1 :from-end t)
       #(a x b x c x d x e z f))
(equalp (nsubstitute-if-not 'z #'(lambda (arg) (not (eq arg 'x)))
                            (copy-seq #(a x b x c x d x e x f))
                            :count 2 :from-end t)
       #(a x b x c x d z e z f))
(equalp (nsubstitute-if-not 'z #'(lambda (arg) (not (eq arg 'x)))
                            (copy-seq #(a x b x c x d x e x f))
                            :count 3 :from-end t)
       #(a x b x c z d z e z f))
(equalp (nsubstitute-if-not 'z #'(lambda (arg) (not (eq arg 'x)))
                            (copy-seq #(a x b x c x d x e x f))
                            :count 4 :from-end t)
       #(a x b z c z d z e z f))
(equalp (nsubstitute-if-not 'z #'(lambda (arg) (not (eq arg 'x)))
                            (copy-seq #(a x b x c x d x e x f))
                            :count 5 :from-end t)
       #(a z b z c z d z e z f))
(equalp (nsubstitute-if-not 'z #'(lambda (arg) (not (eq arg 'x)))
                            (copy-seq #(a x b x c x d x e x f))
                            :count 6 :from-end t)
       #(a z b z c z d z e z f))
(equalp (nsubstitute-if-not 'z #'(lambda (arg) (not (eq arg 'x)))
                            (copy-seq #(a x b x c x d x e x f))
                            :count 7 :from-end t)
       #(a z b z c z d z e z f))
(equalp (nsubstitute-if-not 'z #'(lambda (arg) (not (eq arg 'x)))
                            (copy-seq #(a x b x c x d x e x f))
                            :start 2 :count 1)
       #(a x b z c x d x e x f))
(equalp (nsubstitute-if-not 'z #'(lambda (arg) (not (eq arg 'x)))
                            (copy-seq #(a x b x c x d x e x f))
                            :start 2 :end nil :count 1)
       #(a x b z c x d x e x f))
(equalp (nsubstitute-if-not 'z #'(lambda (arg) (not (eq arg 'x)))
                            (copy-seq #(a x b x c x d x e x f))
                            :start 2 :end 6 :count 100)
       #(a x b z c z d x e x f))
(equalp (nsubstitute-if-not 'z #'(lambda (arg) (not (eq arg 'x)))
                            (copy-seq #(a x b x c x d x e x f))
                            :start 2 :end 11 :count 100)
       #(a x b z c z d z e z f))
(equalp (nsubstitute-if-not 'z #'(lambda (arg) (not (eq arg 'x)))
                            (copy-seq #(a x b x c x d x e x f))
                            :start 2 :end 8 :count 10)
       #(a x b z c z d z e x f))
(equalp (nsubstitute-if-not 'z #'(lambda (arg) (not (eq arg 'x)))
                            (copy-seq #(a x b x c x d x e x f))
                            :start 2 :end 8 :count 2 :from-end t)
       #(a x b x c z d z e x f))
(equalp (nsubstitute-if-not #\z #'(lambda (arg) (not (char< #\c arg)))
                            (copy-seq #(#\a #\b #\c #\d #\e #\f)))
        #(#\a #\b #\c #\z #\z #\z))
(equalp (nsubstitute-if-not "peace" #'(lambda (arg) (not (equal "war" arg)))
                            (copy-seq #("love" "hate" "war" "peace")))
       #("love" "hate" "peace" "peace"))
(equalp (nsubstitute-if-not "peace"
                           #'(lambda (arg) (not (string-equal "war" arg)))
                           (copy-seq #("war" "War" "WAr" "WAR")))
       #("peace" "peace" "peace" "peace"))
(equalp (nsubstitute-if-not "peace" #'(lambda (arg) (not (string= "WAR" arg)))
                            (copy-seq #("war" "War" "WAr" "WAR"))
                            :key #'string-upcase)
        #("peace" "peace" "peace" "peace"))
(equalp (nsubstitute-if-not "peace" #'(lambda (arg) (not (string= "WAR" arg)))
                            (copy-seq #("war" "War" "WAr" "WAR"))
                            :start 1
                            :end 2
                            :key #'string-upcase)
        #("war" "peace" "WAr" "WAR"))
(equalp (nsubstitute-if-not "peace" #'(lambda (arg) (not (string= "WAR" arg)))
                            (copy-seq #("war" "War" "WAr" "WAR"))
                            :start 1
                            :end nil
                            :key #'string-upcase)
        #("war" "peace" "peace" "peace"))
(equalp (nsubstitute-if-not "peace" #'(lambda (arg) (not (string= "war" arg)))
                            (copy-seq #("war" "War" "WAr" "WAR"))
                            :key #'string-upcase)
        #("war" "War" "WAr" "WAR"))
(equalp (nsubstitute-if-not "peace" #'(lambda (arg) (not (string= "WAR" arg)))
                            (copy-seq
                             #("war" "War" "WAr" "WAR" "war" "War" "WAr" "WAR"))
                            :start 1
                            :end 7
                            :count 1
                            :key #'string-upcase)
        #("war" "peace" "WAr" "WAR" "war" "War" "WAr" "WAR"))
(equalp (nsubstitute-if-not "peace" #'(lambda (arg) (not (string= "WAR" arg)))
                            (copy-seq
                             #("war" "War" "WAr" "WAR" "war" "War" "WAr" "WAR"))
                            :start 1
                            :end 7
                            :count 2
                            :key #'string-upcase)
        #("war" "peace" "peace" "WAR" "war" "War" "WAr" "WAR"))
(equalp (nsubstitute-if-not "peace" #'(lambda (arg) (not (string= "WAR" arg)))
                            (copy-seq
                             #("war" "War" "WAr" "WAR" "war" "War" "WAr" "WAR"))
                            :start 1
                            :end 7
                            :count 2
                            :from-end t
                            :key #'string-upcase)
        #("war" "War" "WAr" "WAR" "war" "peace" "peace" "WAR"))
(equalp (nsubstitute-if-not "peace" #'(lambda (arg) (not (string= "WAR" arg)))
                            (copy-seq
                             #("war" "War" "WAr" "WAR" "war" "War" "WAr" "WAR"))
                            :start 1
                            :end 7
                            :count 0
                            :from-end t
                            :key #'string-upcase)
        #("war" "War" "WAr" "WAR" "war" "War" "WAr" "WAR"))
(equalp (nsubstitute-if-not "peace" #'(lambda (arg) (not (string= "WAR" arg)))
                            (copy-seq
                             #("war" "War" "WAr" "WAR" "war" "War" "WAr" "WAR"))
                            :start 1
                            :end 7
                            :count -2
                            :from-end t
                            :key #'string-upcase)
        #("war" "War" "WAr" "WAR" "war" "War" "WAr" "WAR"))
(equalp (nsubstitute-if-not "peace" #'(lambda (arg) (not (string= "WAR" arg)))
                            (copy-seq
                             #("war" "War" "WAr" "WAR" "war" "War" "WAr" "WAR"))
                            :start 1
                            :end 7
                            :count nil
                            :from-end t
                            :key #'string-upcase)
        #("war" "peace" "peace" "peace" "peace" "peace" "peace" "WAR"))
(equalp (nsubstitute-if-not "peace" #'(lambda (arg) (not (string= "WAR" arg)))
                            (copy-seq
                             #("war" "War" "WAr" "WAR" "war" "War" "WAr" "WAR"))
                            :start 1
                            :end 7
                            :count 6
                            :from-end t
                            :key #'string-upcase)
        #("war" "peace" "peace" "peace" "peace" "peace" "peace" "WAR"))
(equalp (nsubstitute-if-not "peace" #'(lambda (arg) (not (string= "WAR" arg)))
                            (copy-seq
                             #("war" "War" "WAr" "WAR" "war" "War" "WAr" "WAR"))
                            :start 1
                            :end 7
                            :count 7
                            :from-end t
                            :key #'string-upcase)
        #("war" "peace" "peace" "peace" "peace" "peace" "peace" "WAR"))
(equalp (nsubstitute-if-not "peace" #'(lambda (arg) (not (string= "WAR" arg)))
                            (copy-seq
                             #("war" "War" "WAr" "WAR" "war" "War" "WAr" "WAR"))
                            :start 1
                            :end 7
                            :count 100
                            :from-end t
                            :key #'string-upcase)
        #("war" "peace" "peace" "peace" "peace" "peace" "peace" "WAR"))

(string= (nsubstitute-if-not #\A #'(lambda (arg) (not (eql #\a arg)))
                             (copy-seq "abcabc"))
         "AbcAbc")
(string= (nsubstitute-if-not #\A #'(lambda (arg) (not (eql #\a arg)))
                             (copy-seq "")) "")
(string= (nsubstitute-if-not #\A #'(lambda (arg) (not (eql #\a arg)))
                             (copy-seq "xyz"))
         "xyz")
(string= (nsubstitute-if-not #\A #'(lambda (arg) (not (eql #\a arg)))
                             (copy-seq "aaaaaaaaaa") :start 5 :end nil)
         "aaaaaAAAAA")
(string= (nsubstitute-if-not #\x #'(lambda (arg) (not (char< #\5 arg)))
                             (copy-seq "0123456789")) "012345xxxx")
(string= (nsubstitute-if-not #\x #'(lambda (arg) (not (char> #\5 arg)))
                             (copy-seq "0123456789")) "xxxxx56789")
(string= (nsubstitute-if-not #\x #'(lambda (arg) (not (char> #\D arg)))
                             (copy-seq "abcdefg")
                             :key #'char-upcase)
         "xxxdefg")
(string= (nsubstitute-if-not #\x #'(lambda (arg) (not (char> #\D arg)))
                             (copy-seq "abcdefg")
                             :start 1
                             :end 2
                             :key #'char-upcase)
         "axcdefg")
(string= (nsubstitute-if-not #\A #'(lambda (arg) (not (eql #\a arg)))
                             (copy-seq "aaaaaaaaaa") :count 2) "AAaaaaaaaa")
(string= (nsubstitute-if-not #\A #'(lambda (arg) (not (eql #\a arg)))
                             (copy-seq "aaaaaaaaaa") :count -1) "aaaaaaaaaa")
(string= (nsubstitute-if-not #\A #'(lambda (arg) (not (eql #\a arg)))
                             (copy-seq "aaaaaaaaaa") :count 0) "aaaaaaaaaa")
(string= (nsubstitute-if-not #\A #'(lambda (arg) (not (eql #\a arg)))
                             (copy-seq "aaaaaaaaaa") :count nil) "AAAAAAAAAA")
(string= (nsubstitute-if-not #\A #'(lambda (arg) (not (eql #\a arg)))
                             (copy-seq "aaaaaaaaaa") :count 100) "AAAAAAAAAA")
(string= (nsubstitute-if-not #\A #'(lambda (arg) (not (eql #\a arg)))
                             (copy-seq "aaaaaaaaaa") :count 9) "AAAAAAAAAa")
(string= (nsubstitute-if-not #\A #'(lambda (arg) (not (eql #\a arg)))
                             (copy-seq "aaaaaaaaaa") :count 9 :from-end t)
         "aAAAAAAAAA")
(string= (nsubstitute-if-not #\A #'(lambda (arg) (not (eql #\a arg)))
                             (copy-seq "aaaaaaaaaa")
                             :start 2
                             :end 8
                             :count 3)
         "aaAAAaaaaa")
(string= (nsubstitute-if-not #\A #'(lambda (arg) (not (eql #\a arg)))
                             (copy-seq "aaaaaaaaaa")
                             :start 2
                             :end 8
                             :from-end t
                             :count 3)
         "aaaaaAAAaa")
(string= (nsubstitute-if-not #\x #'(lambda (arg) (not (eql #\A arg)))
                             (copy-seq "aaaaaaaaaa")
                             :start 2
                             :end 8
                             :from-end t
                             :count 3)
         "aaaaaaaaaa")
(string= (nsubstitute-if-not #\X #'(lambda (arg) (not (eql #\A arg)))
                             (copy-seq "aaaaaaaaaa")
                             :start 2
                             :end 8
                             :from-end t
                             :key #'char-upcase
                             :count 3)
         "aaaaaXXXaa")
(string= (nsubstitute-if-not #\X #'(lambda (arg) (not (char< #\D arg)))
                             (copy-seq "abcdefghij")
                             :start 2
                             :end 8
                             :from-end t
                             :key #'char-upcase
                             :count 3)
         "abcdeXXXij")
(equalp (nsubstitute-if-not 0 #'(lambda (arg) (not (= 1 arg)))
                            (copy-seq #*1111)) #*0000)
(equalp (nsubstitute-if-not 0 #'(lambda (arg) (not (= 1 arg)))
                            (copy-seq #*1111) :start 1 :end nil) #*1000)
(equalp (nsubstitute-if-not 0 #'(lambda (arg) (not (= 1 arg)))
                            (copy-seq #*1111) :start 1 :end 3) #*1001)
(equalp (nsubstitute-if-not 0 #'(lambda (arg) (not (= 1 arg)))
                            (copy-seq #*11111111) :start 1 :end 7) #*10000001)
(equalp (nsubstitute-if-not 0 #'(lambda (arg) (not (= 1 arg)))
                            (copy-seq #*11111111) :start 1 :end 7 :count 3)
        #*10001111)
(equalp (nsubstitute-if-not 0 #'(lambda (arg) (not (= 1 arg)))
                            (copy-seq #*11111111)
                            :start 1 :end 7 :count 3 :from-end t)
        #*11110001)
(equalp (nsubstitute-if-not 1 #'(lambda (arg) (not (= 1 arg)))
                            (copy-seq #*10101010)
                            :start 1 :end 7 :count 3 :from-end t
                            :key #'(lambda (x) (if (zerop x) 1 0)))
        #*11111110)
(equalp (nsubstitute-if-not 1 #'(lambda (arg) (not (>= 1 arg)))
                            (copy-seq #*10101010)
                            :start 1 :end 7 :count 3 :from-end t
                            :key #'(lambda (x) (if (zerop x) 1 0)))
        #*10101110)


(string= (concatenate 'string "all" " " "together" " " "now")
         "all together now")
(equal (concatenate 'list "ABC" '(d e f) #(1 2 3) #*1011)
       '(#\A #\B #\C D E F 1 2 3 1 0 1 1))
(null (concatenate 'list))
(HANDLER-CASE (PROGN (CONCATENATE 'SYMBOL))
  (ERROR NIL T)
  (ERROR NIL NIL)
  (:NO-ERROR (&REST REST) (DECLARE (IGNORE REST)) NIL))
(HANDLER-CASE (PROGN (CONCATENATE 'CLASS))
  (ERROR NIL T)
  (ERROR NIL NIL)
  (:NO-ERROR (&REST REST) (DECLARE (IGNORE REST)) NIL))


(equal (concatenate 'list '() '(a b c) '(x y z)) '(a b c x y z))
(equal (concatenate 'list '(a) #(b) '(c) #(x y) '(z)) '(a b c x y z))
(equal (concatenate 'list '(a b c) #(d e f) "ghi" #*0101)
       '(a b c d e f #\g #\h #\i 0 1 0 1))
(null (concatenate 'list))
(let* ((list0 '(a b c))
       (list (concatenate 'list list0)))
  (and (not (eq list0 list))
       (equal list list0)
       (equal list '(a b c))))
(null (concatenate 'list '() #() "" #*))
(equal (concatenate 'list #(a b c) '() '() '(x y z) #() #() #* #(j k l))
       '(a b c x y z j k l))

(equalp (concatenate 'vector '() '(a b c) '(x y z)) #(a b c x y z))
(equalp (concatenate 'vector '(a) #(b) '(c) #(x y) '(z)) #(a b c x y z))
(equalp (concatenate 'vector '(a b c) #(d e f) "ghi" #*0101)
        #(a b c d e f #\g #\h #\i 0 1 0 1))
(equalp (concatenate 'vector) #())
(let* ((vector0 #(a b c))
       (vector (concatenate 'vector vector0)))
  (and (not (eq vector0 vector))
       (equalp vector vector0)
       (equalp vector #(a b c))))
(equalp (concatenate 'vector '() #() "" #*) #())
(equalp (concatenate 'vector #(a b c) '() '() '(x y z) #() #() #* #(j k l))
        #(a b c x y z j k l))

(string= (concatenate 'string "abc" "def" "ghi" "jkl" "mno" "pqr")
         "abcdefghijklmnopqr")
(string= (concatenate
          'string
          "" "abc" "" "def" "" "ghi" "" "" "jkl" "" "mno" "" "pqr" "" "")
         "abcdefghijklmnopqr")
(string= (concatenate 'string) "")
(string= (concatenate 'string "" '() #* #()) "")
(string= (concatenate 'string "abc" '(#\d #\e #\f #\g) #(#\h #\i #\j #\k #\l))
         "abcdefghijkl")
(equal (concatenate 'bit-vector #*0101 #*1010) #*01011010)
(equal (concatenate 'bit-vector #*0101 #*1010 #* #*11 #*1 #*1)
       #*010110101111)
(equal (concatenate 'bit-vector '(0 1 0 1) '(0 1 0 1) #(0 1 0 1) #*0101)
       #*0101010101010101)
(equal (concatenate 'bit-vector) #*)
(equal (concatenate 'bit-vector #*) #*)
(equal (concatenate 'bit-vector #* '() #()) #*)



(let ((test1 (list 1 3 4 6 7))
      (test2 (list 2 5 8)))
  (equal (merge 'list test1 test2 #'<) '(1 2 3 4 5 6 7 8)))
(let ((test1 (copy-seq "BOY"))
      (test2 (copy-seq "nosy")))
  (equal (merge 'string test1 test2 #'char-lessp) "BnOosYy"))
(let ((test1 (vector '(red . 1) '(blue . 4)))
      (test2 (vector '(yellow . 2) '(green . 7))))
  (equalp (merge 'vector test1 test2 #'< :key #'cdr)
          #((RED . 1) (YELLOW . 2) (BLUE . 4) (GREEN . 7))))


(equal (merge 'list (list 1 3 5 7 9) (list 0 2 4 6 8) #'<)
       '(0 1 2 3 4 5 6 7 8 9))
(equal (merge 'cons (list 1 3 5 7 9) (list 0 2 4 6 8) #'<)
       '(0 1 2 3 4 5 6 7 8 9))
(equal (merge 'list (list 0 1 2) nil #'<) '(0 1 2))
(equal (merge 'list nil (list 0 1 2) #'<) '(0 1 2))
(equal (merge 'list nil nil #'<) nil)
(equal (merge 'list
              (list '(1 1) '(2 1) '(3 1))
              (list '(1 2) '(2 2) '(3 2)) #'< :key #'car)
       '((1 1) (1 2) (2 1) (2 2) (3 1) (3 2)))
(equal (merge 'list
              (list '(1 1) '(2 1) '(2 1 1) '(3 1))
              (list '(1 2) '(2 2) '(3 2)) #'< :key #'car)
       '((1 1) (1 2) (2 1) (2 1 1) (2 2) (3 1) (3 2)))
(equal (merge 'list
              (list '(1 1) '(2 1) '(2 1 1) '(3 1))
              (list '(1 2) '(2 2) '(3 2) '(3 2 2)) #'< :key #'car)
       '((1 1) (1 2) (2 1) (2 1 1) (2 2) (3 1) (3 2) (3 2 2)))
(equal (merge 'list (list 3 1 9 5 7) (list 8 6 0 2 4) #'<)
       '(3 1 8 6 0 2 4 9 5 7))


(equal (merge 'list (vector 1 3 5 7 9) (list 0 2 4 6 8) #'<)
       '(0 1 2 3 4 5 6 7 8 9))
(equal (merge 'cons (vector 1 3 5 7 9) (list 0 2 4 6 8) #'<)
       '(0 1 2 3 4 5 6 7 8 9))
(equal (merge 'list (vector 0 1 2) nil #'<) '(0 1 2))
(equal (merge 'list #() (list 0 1 2) #'<) '(0 1 2))
(equal (merge 'list #() #() #'<) nil)
(equal (merge 'list
              (vector '(1 1) '(2 1) '(3 1))
              (list '(1 2) '(2 2) '(3 2)) #'< :key #'car)
       '((1 1) (1 2) (2 1) (2 2) (3 1) (3 2)))
(equal (merge 'list
              (vector '(1 1) '(2 1) '(2 1 1) '(3 1))
              (list '(1 2) '(2 2) '(3 2)) #'< :key #'car)
       '((1 1) (1 2) (2 1) (2 1 1) (2 2) (3 1) (3 2)))
(equal (merge 'list
              (vector '(1 1) '(2 1) '(2 1 1) '(3 1))
              (list '(1 2) '(2 2) '(3 2) '(3 2 2)) #'< :key #'car)
       '((1 1) (1 2) (2 1) (2 1 1) (2 2) (3 1) (3 2) (3 2 2)))
(equal (merge 'list (vector 3 1 9 5 7) (list 8 6 0 2 4) #'<)
       '(3 1 8 6 0 2 4 9 5 7))


(equal (merge 'list (list 1 3 5 7 9) (vector 0 2 4 6 8) #'<)
       '(0 1 2 3 4 5 6 7 8 9))
(equal (merge 'cons (list 1 3 5 7 9) (vector 0 2 4 6 8) #'<)
       '(0 1 2 3 4 5 6 7 8 9))
(equal (merge 'list (list 0 1 2) #() #'<) '(0 1 2))
(equal (merge 'list nil (vector 0 1 2) #'<) '(0 1 2))
(equal (merge 'list nil #() #'<) nil)
(equal (merge 'list
              (list '(1 1) '(2 1) '(3 1))
              (vector '(1 2) '(2 2) '(3 2)) #'< :key #'car)
       '((1 1) (1 2) (2 1) (2 2) (3 1) (3 2)))
(equal (merge 'list
              (list '(1 1) '(2 1) '(2 1 1) '(3 1))
              (vector '(1 2) '(2 2) '(3 2)) #'< :key #'car)
       '((1 1) (1 2) (2 1) (2 1 1) (2 2) (3 1) (3 2)))
(equal (merge 'list
              (list '(1 1) '(2 1) '(2 1 1) '(3 1))
              (vector '(1 2) '(2 2) '(3 2) '(3 2 2)) #'< :key #'car)
       '((1 1) (1 2) (2 1) (2 1 1) (2 2) (3 1) (3 2) (3 2 2)))
(equal (merge 'list (list 3 1 9 5 7) (vector 8 6 0 2 4) #'<)
       '(3 1 8 6 0 2 4 9 5 7))


(equal (merge 'list (vector 1 3 5 7 9) (vector 0 2 4 6 8) #'<)
       '(0 1 2 3 4 5 6 7 8 9))
(equal (merge 'cons (vector 1 3 5 7 9) (vector 0 2 4 6 8) #'<)
       '(0 1 2 3 4 5 6 7 8 9))
(equal (merge 'list (vector 0 1 2) #() #'<) '(0 1 2))
(equal (merge 'list #() (vector 0 1 2) #'<) '(0 1 2))
(equal (merge 'list #() #() #'<) nil)
(equal (merge 'list
              (vector '(1 1) '(2 1) '(3 1))
              (vector '(1 2) '(2 2) '(3 2)) #'< :key #'car)
       '((1 1) (1 2) (2 1) (2 2) (3 1) (3 2)))
(equal (merge 'list
              (vector '(1 1) '(2 1) '(2 1 1) '(3 1))
              (vector '(1 2) '(2 2) '(3 2)) #'< :key #'car)
       '((1 1) (1 2) (2 1) (2 1 1) (2 2) (3 1) (3 2)))
(equal (merge 'list
              (vector '(1 1) '(2 1) '(2 1 1) '(3 1))
              (vector '(1 2) '(2 2) '(3 2) '(3 2 2)) #'< :key #'car)
       '((1 1) (1 2) (2 1) (2 1 1) (2 2) (3 1) (3 2) (3 2 2)))
(equal (merge 'list (vector 3 1 9 5 7) (vector 8 6 0 2 4) #'<)
       '(3 1 8 6 0 2 4 9 5 7))


(equalp (merge 'vector (list 1 3 5 7 9) (list 0 2 4 6 8) #'<)
        #(0 1 2 3 4 5 6 7 8 9))
(equalp (merge 'vector (list 1 3 5 7 9) (list 0 2 4 6 8) #'<)
        #(0 1 2 3 4 5 6 7 8 9))
(equalp (merge 'vector (list 0 1 2) nil #'<) #(0 1 2))
(equalp (merge 'vector nil (list 0 1 2) #'<) #(0 1 2))
(equalp (merge 'vector nil nil #'<) #())
(equalp (merge 'vector
              (list '(1 1) '(2 1) '(3 1))
              (list '(1 2) '(2 2) '(3 2)) #'< :key #'car)
        #((1 1) (1 2) (2 1) (2 2) (3 1) (3 2)))
(equalp (merge 'vector
               (list '(1 1) '(2 1) '(2 1 1) '(3 1))
               (list '(1 2) '(2 2) '(3 2)) #'< :key #'car)
        #((1 1) (1 2) (2 1) (2 1 1) (2 2) (3 1) (3 2)))
(equalp (merge 'vector
               (list '(1 1) '(2 1) '(2 1 1) '(3 1))
               (list '(1 2) '(2 2) '(3 2) '(3 2 2)) #'< :key #'car)
        #((1 1) (1 2) (2 1) (2 1 1) (2 2) (3 1) (3 2) (3 2 2)))
(equalp (merge 'vector (list 3 1 9 5 7) (list 8 6 0 2 4) #'<)
        #(3 1 8 6 0 2 4 9 5 7))


(equalp (merge 'vector (vector 1 3 5 7 9) (list 0 2 4 6 8) #'<)
        #(0 1 2 3 4 5 6 7 8 9))
(equalp (merge 'vector (vector 1 3 5 7 9) (list 0 2 4 6 8) #'<)
        #(0 1 2 3 4 5 6 7 8 9))
(equalp (merge 'vector (vector 0 1 2) nil #'<) #(0 1 2))
(equalp (merge 'vector #() (list 0 1 2) #'<) #(0 1 2))
(equalp (merge 'vector #() #() #'<) #())
(equalp (merge 'vector
              (vector '(1 1) '(2 1) '(3 1))
              (list '(1 2) '(2 2) '(3 2)) #'< :key #'car)
        #((1 1) (1 2) (2 1) (2 2) (3 1) (3 2)))
(equalp (merge 'vector
               (vector '(1 1) '(2 1) '(2 1 1) '(3 1))
               (list '(1 2) '(2 2) '(3 2)) #'< :key #'car)
        #((1 1) (1 2) (2 1) (2 1 1) (2 2) (3 1) (3 2)))
(equalp (merge 'vector
               (vector '(1 1) '(2 1) '(2 1 1) '(3 1))
               (list '(1 2) '(2 2) '(3 2) '(3 2 2)) #'< :key #'car)
        #((1 1) (1 2) (2 1) (2 1 1) (2 2) (3 1) (3 2) (3 2 2)))
(equalp (merge 'vector (vector 3 1 9 5 7) (list 8 6 0 2 4) #'<)
        #(3 1 8 6 0 2 4 9 5 7))


(equalp (merge 'vector (list 1 3 5 7 9) (vector 0 2 4 6 8) #'<)
        #(0 1 2 3 4 5 6 7 8 9))
(equalp (merge 'vector (list 1 3 5 7 9) (vector 0 2 4 6 8) #'<)
        #(0 1 2 3 4 5 6 7 8 9))
(equalp (merge 'vector (list 0 1 2) #() #'<) #(0 1 2))
(equalp (merge 'vector nil (vector 0 1 2) #'<) #(0 1 2))
(equalp (merge 'vector nil #() #'<) #())
(equalp (merge 'vector
               (list '(1 1) '(2 1) '(3 1))
               (vector '(1 2) '(2 2) '(3 2)) #'< :key #'car)
        #((1 1) (1 2) (2 1) (2 2) (3 1) (3 2)))
(equalp (merge 'vector
               (list '(1 1) '(2 1) '(2 1 1) '(3 1))
               (vector '(1 2) '(2 2) '(3 2)) #'< :key #'car)
        #((1 1) (1 2) (2 1) (2 1 1) (2 2) (3 1) (3 2)))
(equalp (merge 'vector
               (list '(1 1) '(2 1) '(2 1 1) '(3 1))
               (vector '(1 2) '(2 2) '(3 2) '(3 2 2)) #'< :key #'car)
        #((1 1) (1 2) (2 1) (2 1 1) (2 2) (3 1) (3 2) (3 2 2)))
(equalp (merge 'vector (list 3 1 9 5 7) (vector 8 6 0 2 4) #'<)
        #(3 1 8 6 0 2 4 9 5 7))


(equalp (merge 'vector (vector 1 3 5 7 9) (vector 0 2 4 6 8) #'<)
        #(0 1 2 3 4 5 6 7 8 9))
(equalp (merge 'vector (vector 0 1 2) #() #'<) #(0 1 2))
(equalp (merge 'vector #() (vector 0 1 2) #'<) #(0 1 2))
(equalp (merge 'vector #() #() #'<) #())
(equalp (merge 'vector
               (vector '(1 1) '(2 1) '(3 1))
               (vector '(1 2) '(2 2) '(3 2)) #'< :key #'car)
        #((1 1) (1 2) (2 1) (2 2) (3 1) (3 2)))
(equalp (merge 'vector
               (vector '(1 1) '(2 1) '(2 1 1) '(3 1))
               (vector '(1 2) '(2 2) '(3 2)) #'< :key #'car)
        #((1 1) (1 2) (2 1) (2 1 1) (2 2) (3 1) (3 2)))
(equalp (merge 'vector
               (vector '(1 1) '(2 1) '(2 1 1) '(3 1))
               (vector '(1 2) '(2 2) '(3 2) '(3 2 2)) #'< :key #'car)
        #((1 1) (1 2) (2 1) (2 1 1) (2 2) (3 1) (3 2) (3 2 2)))
(equalp (merge 'vector (vector 3 1 9 5 7) (vector 8 6 0 2 4) #'<)
        #(3 1 8 6 0 2 4 9 5 7))


(string= (merge 'string (list #\a #\c #\e) (list #\b #\d #\f) #'char<) "abcdef")
(string= (merge 'string (list #\a #\b #\c) (list #\d #\e #\f) #'char<) "abcdef")
(string= (merge 'string (list #\a #\b #\c) '() #'char<) "abc")
(string= (merge 'string '() (list #\a #\b #\c) #'char<) "abc")
(string= (merge 'string (list #\a #\b #\c) (copy-seq "") #'char<) "abc")
(string= (merge 'string (list #\a #\b #\c) (copy-seq "BCD") #'char-lessp)
         "abBcCD")
(string= (merge 'string (list #\a #\b #\z) #(#\c #\x #\y) #'char<) "abcxyz")

(equal (merge 'bit-vector (copy-seq #*0101) (copy-seq #*1010) #'<) #*01011010)
(equal (merge 'bit-vector (copy-seq #*0101) (copy-seq #*) #'<) #*0101)
(equal (merge 'bit-vector (copy-seq #*0101) '() #'<) #*0101)
(equal (merge 'bit-vector nil (copy-seq #*0101) #'<) #*0101)
(equal (merge 'bit-vector (copy-seq #*0101) (copy-seq #*0101) #'<) #*00101101)




(equal (remove 4 '(1 3 4 5 9)) '(1 3 5 9))
(equal (remove 4 '(1 2 4 1 3 4 5)) '(1 2 1 3 5))
(equal (remove 4 '(1 2 4 1 3 4 5) :count 1) '(1 2 1 3 4 5))
(equal (remove 4 '(1 2 4 1 3 4 5) :count 1 :from-end t) '(1 2 4 1 3 5))
(equal (remove 3 '(1 2 4 1 3 4 5) :test #'>) '(4 3 4 5))
(let* ((lst '(list of four elements))
       (lst2 (copy-seq lst))
       (lst3 (delete 'four lst)))
  (and (equal lst3 '(LIST OF ELEMENTS))
       (not (equal lst lst2))))
(equal (remove-if #'oddp '(1 2 4 1 3 4 5)) '(2 4 4))
(equal (remove-if #'evenp '(1 2 4 1 3 4 5) :count 1 :from-end t)
       '(1 2 4 1 3 5))
(equal (remove-if-not #'evenp '(1 2 3 4 5 6 7 8 9) :count 2 :from-end t)
       '(1 2 3 4 5 6 8))
(equal (delete 4 (list 1 2 4 1 3 4 5)) '(1 2 1 3 5))
(equal (delete 4 (list 1 2 4 1 3 4 5) :count 1) '(1 2 1 3 4 5))
(equal (delete 4 (list 1 2 4 1 3 4 5) :count 1 :from-end t) '(1 2 4 1 3 5))
(equal (delete 3 (list 1 2 4 1 3 4 5) :test #'>) '(4 3 4 5))
(equal (delete-if #'oddp (list 1 2 4 1 3 4 5)) '(2 4 4))
(equal (delete-if #'evenp (list 1 2 4 1 3 4 5) :count 1 :from-end t)
       '(1 2 4 1 3 5))
(equal (delete-if #'evenp (list 1 2 3 4 5 6)) '(1 3 5))


(let* ((list0 (list 0 1 2 3 4))
       (list (remove 3 list0)))
  (and (not (eq list0 list))
       (equal list0 '(0 1 2 3 4))
       (equal list '(0 1 2 4))))
(equal (remove 'a (list 'a 'b 'c 'a 'b 'c)) '(b c b c))
(equal (remove 'b (list 'a 'b 'c 'a 'b 'c)) '(a c a c))
(equal (remove 'c (list 'a 'b 'c 'a 'b 'c)) '(a b a b))
(equal (remove 'a (list 'a 'a 'a)) '())
(equal (remove 'z (list 'a 'b 'c)) '(a b c))
(equal (remove 'a '()) '())
(equal (remove 'a (list 'a 'b 'c 'a 'b 'c) :count 0) '(a b c a b c))
(equal (remove 'a (list 'a 'b 'c 'a 'b 'c) :count 1) '(b c a b c))
(equal (remove 'a (list 'a 'b 'c 'a 'b 'c) :count 1 :from-end t) '(a b c b c))
(equal (remove 'a (list 'a 'b 'c 'a 'b 'c) :count 2) '(b c b c))
(equal (remove 'a (list 'a 'b 'c 'a 'b 'c) :count 2 :from-end t) '(b c b c))
(equal (remove 'a (list 'a 'b 'c 'a 'b 'c) :count 3) '(b c b c))
(equal (remove 'a (list 'a 'b 'c 'a 'b 'c) :count 3 :from-end t) '(b c b c))
(equal (remove 'a (list 'a 'b 'c 'a 'b 'c) :count 4) '(b c b c))
(equal (remove 'a (list 'a 'b 'c 'a 'b 'c) :count 4 :from-end t) '(b c b c))
(equal (remove 'a (list 'a 'b 'c 'a 'b 'c) :count -1) '(a b c a b c))
(equal (remove 'a (list 'a 'b 'c 'a 'b 'c) :count -10) '(a b c a b c))
(equal (remove 'a (list 'a 'b 'c 'a 'b 'c) :count -100) '(a b c a b c))
(equal (remove 'a (list 'a 'b 'c 'a 'b 'c 'a 'b 'c 'a 'b 'c) :start 1)
       '(a b c b c b c b c))
(equal (remove 'a (list 'a 'b 'c 'a 'b 'c 'a 'b 'c 'a 'b 'c) :start 1 :count 1)
       '(a b c b c a b c a b c))
(equal (remove 'a (list 'a 'b 'c 'a 'b 'c 'a 'b 'c 'a 'b 'c) :start 1 :count 2)
       '(a b c b c b c a b c))
(equal (remove 'a (list 'a 'b 'c 'a 'b 'c 'a 'b 'c 'a 'b 'c)
               :start 1 :end nil :count 2)
       '(a b c b c b c a b c))
(equal (remove 'a (list 'a 'b 'c 'a 'b 'c 'a 'b 'c 'a 'b 'c) :start 1 :end 8)
       '(a b c b c b c a b c))
(equal (remove 'a (list 'a 'b 'c 'a 'b 'c 'a 'b 'c 'a 'b 'c)
               :start 1 :end 8 :count 1)
       '(a b c b c a b c a b c))
(equal (remove 'a (list 'a 'b 'c 'a 'b 'c 'a 'b 'c 'a 'b 'c)
               :start 1 :end 8 :count 1 :from-end t)
       '(a b c a b c b c a b c))
(equal (remove 'a (list 'a 'b 'c 'a 'b 'c 'a 'b 'c 'a 'b 'c)
               :start 1 :end 8 :count 0 :from-end t)
       '(a b c a b c a b c a b c))
(equal (remove 'a (list 'a 'b 'c 'a 'b 'c 'a 'b 'c 'a 'b 'c)
               :start 1 :end 8 :count -100 :from-end t)
       '(a b c a b c a b c a b c))
(equal (remove 'a (list 'a 'b 'c 'a 'b 'c 'a 'b 'c 'a 'b 'c) :start 1 :end 1)
       '(a b c a b c a b c a b c))
(equal (remove 'a (list 'a 'b 'c 'a 'b 'c 'a 'b 'c 'a 'b 'c) :start 2 :end 2)
       '(a b c a b c a b c a b c))
(equal (remove 'a (list 'a 'b 'c 'a 'b 'c 'a 'b 'c 'a 'b 'c) :start 12 :end 12)
       '(a b c a b c a b c a b c))
(equal (remove 'a (list '(a) '(b) '(c) '(a) '(b) '(c)) :key #'car)
       '((b) (c) (b) (c)))
(equal (remove 'a (list '(a . b) '(b . c) '(c . a)
                        '(a . b) '(b . c) '(c . a))
               :key #'cdr)
       '((a . b) (b . c) (a . b) (b . c)))
(equal (remove "love" (list '("Love") '("LOve") '("LOVe") '("LOVE")) :key #'car)
       '(("Love") ("LOve") ("LOVe") ("LOVE")))
(equal (remove "love" (list '("Love") '("LOve") '("LOVe") '("LOVE"))
               :key #'car :count -10)
       '(("Love") ("LOve") ("LOVe") ("LOVE")))
(equal (remove "love" (list '("Love") '("LOve") '("LOVe") '("LOVE"))
               :key #'car :test #'string-equal)
       '())
(equal (remove "love" (list '("Love") '("LOve") '("LOVe") '("LOVE"))
               :key #'car :test-not (complement #'string-equal))
       '())
(equal (remove "love" (list '("Love") '("LOve") '("LOVe") '("LOVE"))
               :key #'car :test #'string-equal :count 1)
       '(("LOve") ("LOVe") ("LOVE")))
(equal (remove "love" (list '("Love") '("LOve") '("LOVe") '("LOVE"))
               :key #'car :test-not (complement #'string-equal) :count 1)
       '(("LOve") ("LOVe") ("LOVE")))
(equal (remove "love" (list '("Love") '("LOve") '("LOVe") '("LOVE"))
               :key #'car :test #'string-equal :count 1 :from-end t)
       '(("Love") ("LOve") ("LOVe")))
(equal (remove "love" (list '("Love") '("LOve") '("LOVe") '("LOVE"))
               :key #'car :test-not (complement #'string-equal)
               :count 1 :from-end t)
       '(("Love") ("LOve") ("LOVe")))
(equal (remove "love" (list '("Love") '("LOve") '("LOVe") '("LOVE"))
               :key #'car :test #'string-equal :count 2 :from-end t)
       '(("Love") ("LOve")))
(equal (remove "love" (list '("Love") '("LOve") '("LOVe") '("LOVE"))
               :key #'car :test-not (complement #'string-equal)
               :count 2 :from-end t)
       '(("Love") ("LOve")))
(equal (remove "love" (list '("Love") '("LOve") '("LOVe") '("LOVE"))
               :key #'car :test #'string-equal :start 1 :end 3)
       '(("Love") ("LOVE")))
(equal (remove "love" (list '("Love") '("LOve") '("LOVe") '("LOVE"))
               :key #'car :test-not (complement #'string-equal) :start 1 :end 3)
       '(("Love") ("LOVE")))
(equal (remove "love" (list '("Love") '("LOve") '("LOVe") '("LOVE"))
               :key #'car :test #'string-equal :count 1 :start 1 :end 3)
       '(("Love") ("LOVe") ("LOVE")))
(equal (remove "love" (list '("Love") '("LOve") '("LOVe") '("LOVE"))
               :key #'car :test-not (complement #'string-equal)
               :count 1 :start 1 :end 3)
       '(("Love") ("LOVe") ("LOVE")))
(equal (remove "love" (list '("Love") '("LOve") '("LOVe") '("LOVE"))
               :key #'car :test #'string-equal :count 1 :from-end t
               :start 1 :end 3)
       '(("Love") ("LOve") ("LOVE")))
(equal (remove "love" (list '("Love") '("LOve") '("LOVe") '("LOVE"))
               :key #'car :test-not (complement #'string-equal)
               :count 1 :from-end t :start 1 :end 3)
       '(("Love") ("LOve") ("LOVE")))
(equal (remove "love" (list '("Love") '("LOve") '("LOVe") '("LOVE"))
               :key #'car :test #'string-equal :count 10 :from-end t
               :start 1 :end 3)
       '(("Love") ("LOVE")))
(equal (remove "love" (list '("Love") '("LOve") '("LOVe") '("LOVE"))
               :key #'car :test-not (complement #'string-equal)
               :count 10 :from-end t :start 1 :end 3)
       '(("Love") ("LOVE")))


(let* ((vector0 (vector 0 1 2 3 4))
       (vector (remove 3 vector0)))
  (and (not (eq vector0 vector))
       (equalp vector0 #(0 1 2 3 4))
       (equalp vector #(0 1 2 4))))
(equalp (remove 'a (vector 'a 'b 'c 'a 'b 'c)) #(b c b c))
(equalp (remove 'b (vector 'a 'b 'c 'a 'b 'c)) #(a c a c))
(equalp (remove 'c (vector 'a 'b 'c 'a 'b 'c)) #(a b a b))
(equalp (remove 'a (vector 'a 'a 'a)) #())
(equalp (remove 'z (vector 'a 'b 'c)) #(a b c))
(equalp (remove 'a #()) #())
(equalp (remove 'a (vector 'a 'b 'c 'a 'b 'c) :count 0) #(a b c a b c))
(equalp (remove 'a (vector 'a 'b 'c 'a 'b 'c) :count 1) #(b c a b c))
(equalp (remove 'a (vector 'a 'b 'c 'a 'b 'c) :count 1 :from-end t) #(a b c b c))
(equalp (remove 'a (vector 'a 'b 'c 'a 'b 'c) :count 2) #(b c b c))
(equalp (remove 'a (vector 'a 'b 'c 'a 'b 'c) :count 2 :from-end t) #(b c b c))
(equalp (remove 'a (vector 'a 'b 'c 'a 'b 'c) :count 3) #(b c b c))
(equalp (remove 'a (vector 'a 'b 'c 'a 'b 'c) :count 3 :from-end t) #(b c b c))
(equalp (remove 'a (vector 'a 'b 'c 'a 'b 'c) :count 4) #(b c b c))
(equalp (remove 'a (vector 'a 'b 'c 'a 'b 'c) :count 4 :from-end t) #(b c b c))
(equalp (remove 'a (vector 'a 'b 'c 'a 'b 'c) :count -1) #(a b c a b c))
(equalp (remove 'a (vector 'a 'b 'c 'a 'b 'c) :count -10) #(a b c a b c))
(equalp (remove 'a (vector 'a 'b 'c 'a 'b 'c) :count -100) #(a b c a b c))
(equalp (remove 'a (vector 'a 'b 'c 'a 'b 'c 'a 'b 'c 'a 'b 'c) :start 1)
        #(a b c b c b c b c))
(equalp (remove 'a (vector 'a 'b 'c 'a 'b 'c 'a 'b 'c 'a 'b 'c)
                :start 1 :count 1)
       #(a b c b c a b c a b c))
(equalp (remove 'a (vector 'a 'b 'c 'a 'b 'c 'a 'b 'c 'a 'b 'c)
                :start 1 :count 2)
       #(a b c b c b c a b c))
(equalp (remove 'a (vector 'a 'b 'c 'a 'b 'c 'a 'b 'c 'a 'b 'c)
               :start 1 :end nil :count 2)
       #(a b c b c b c a b c))
(equalp (remove 'a (vector 'a 'b 'c 'a 'b 'c 'a 'b 'c 'a 'b 'c) :start 1 :end 8)
        #(a b c b c b c a b c))
(equalp (remove 'a (vector 'a 'b 'c 'a 'b 'c 'a 'b 'c 'a 'b 'c)
               :start 1 :end 8 :count 1)
        #(a b c b c a b c a b c))
(equalp (remove 'a (vector 'a 'b 'c 'a 'b 'c 'a 'b 'c 'a 'b 'c)
               :start 1 :end 8 :count 1 :from-end t)
        #(a b c a b c b c a b c))
(equalp (remove 'a (vector 'a 'b 'c 'a 'b 'c 'a 'b 'c 'a 'b 'c)
               :start 1 :end 8 :count 0 :from-end t)
        #(a b c a b c a b c a b c))
(equalp (remove 'a (vector 'a 'b 'c 'a 'b 'c 'a 'b 'c 'a 'b 'c)
               :start 1 :end 8 :count -100 :from-end t)
        #(a b c a b c a b c a b c))
(equalp (remove 'a (vector 'a 'b 'c 'a 'b 'c 'a 'b 'c 'a 'b 'c) :start 1 :end 1)
        #(a b c a b c a b c a b c))
(equalp (remove 'a (vector 'a 'b 'c 'a 'b 'c 'a 'b 'c 'a 'b 'c) :start 2 :end 2)
        #(a b c a b c a b c a b c))
(equalp (remove 'a (vector 'a 'b 'c 'a 'b 'c 'a 'b 'c 'a 'b 'c)
                :start 12 :end 12)
        #(a b c a b c a b c a b c))
(equalp (remove 'a (vector '(a) '(b) '(c) '(a) '(b) '(c)) :key #'car)
        #((b) (c) (b) (c)))
(equalp (remove 'a (vector '(a . b) '(b . c) '(c . a)
                           '(a . b) '(b . c) '(c . a))
               :key #'cdr)
        #((a . b) (b . c) (a . b) (b . c)))
(equalp (remove "love" (vector '("Love") '("LOve") '("LOVe") '("LOVE"))
                :key #'car)
        #(("Love") ("LOve") ("LOVe") ("LOVE")))
(equalp (remove "love" (vector '("Love") '("LOve") '("LOVe") '("LOVE"))
                :key #'car :count -10)
        #(("Love") ("LOve") ("LOVe") ("LOVE")))
(equalp (remove "love" (vector '("Love") '("LOve") '("LOVe") '("LOVE"))
                :key #'car :test #'string-equal)
        #())
(equalp (remove "love" (vector '("Love") '("LOve") '("LOVe") '("LOVE"))
                :key #'car :test-not (complement #'string-equal))
        #())
(equalp (remove "love" (vector '("Love") '("LOve") '("LOVe") '("LOVE"))
                :key #'car :test #'string-equal :count 1)
        #(("LOve") ("LOVe") ("LOVE")))
(equalp (remove "love" (vector '("Love") '("LOve") '("LOVe") '("LOVE"))
                :key #'car :test-not (complement #'string-equal) :count 1)
        #(("LOve") ("LOVe") ("LOVE")))
(equalp (remove "love" (vector '("Love") '("LOve") '("LOVe") '("LOVE"))
                :key #'car :test #'string-equal :count 1 :from-end t)
        #(("Love") ("LOve") ("LOVe")))
(equalp (remove "love" (vector '("Love") '("LOve") '("LOVe") '("LOVE"))
                :key #'car :test-not (complement #'string-equal)
                :count 1 :from-end t)
        #(("Love") ("LOve") ("LOVe")))
(equalp (remove "love" (vector '("Love") '("LOve") '("LOVe") '("LOVE"))
                :key #'car :test #'string-equal :count 2 :from-end t)
        #(("Love") ("LOve")))
(equalp (remove "love" (vector '("Love") '("LOve") '("LOVe") '("LOVE"))
                :key #'car :test-not (complement #'string-equal)
                :count 2 :from-end t)
        #(("Love") ("LOve")))
(equalp (remove "love" (vector '("Love") '("LOve") '("LOVe") '("LOVE"))
                :key #'car :test #'string-equal :start 1 :end 3)
        #(("Love") ("LOVE")))
(equalp (remove "love" (vector '("Love") '("LOve") '("LOVe") '("LOVE"))
                :key #'car :test-not (complement #'string-equal) :start 1 :end 3)
        #(("Love") ("LOVE")))
(equalp (remove "love" (vector '("Love") '("LOve") '("LOVe") '("LOVE"))
                :key #'car :test #'string-equal :count 1 :start 1 :end 3)
        #(("Love") ("LOVe") ("LOVE")))
(equalp (remove "love" (vector '("Love") '("LOve") '("LOVe") '("LOVE"))
                :key #'car :test-not (complement #'string-equal)
                :count 1 :start 1 :end 3)
        #(("Love") ("LOVe") ("LOVE")))
(equalp (remove "love" (vector '("Love") '("LOve") '("LOVe") '("LOVE"))
                :key #'car :test #'string-equal :count 1 :from-end t
                :start 1 :end 3)
        #(("Love") ("LOve") ("LOVE")))
(equalp (remove "love" (vector '("Love") '("LOve") '("LOVe") '("LOVE"))
                :key #'car :test-not (complement #'string-equal)
                :count 1 :from-end t :start 1 :end 3)
        #(("Love") ("LOve") ("LOVE")))
(equalp (remove "love" (vector '("Love") '("LOve") '("LOVe") '("LOVE"))
                :key #'car :test #'string-equal :count 10 :from-end t
                :start 1 :end 3)
        #(("Love") ("LOVE")))
(equalp (remove "love" (vector '("Love") '("LOve") '("LOVe") '("LOVE"))
                :key #'car :test-not (complement #'string-equal)
                :count 10 :from-end t :start 1 :end 3)
        #(("Love") ("LOVE")))

(string= (remove #\a (copy-seq "abcabc")) "bcbc")
(string= (remove #\a (copy-seq "")) "")
(string= (remove #\a (copy-seq "xyz")) "xyz")
(string= (remove #\a (copy-seq "ABCABC")) "ABCABC")
(string= (remove #\a (copy-seq "ABCABC") :key #'char-downcase) "BCBC")
(string= (remove #\a (copy-seq "abcabc") :count 1) "bcabc")
(string= (remove #\a (copy-seq "abcabc") :count 1 :from-end t) "abcbc")
(string= (remove #\a (copy-seq "abcabc") :count 0) "abcabc")
(string= (remove #\a (copy-seq "abcabc") :count -10) "abcabc")
(let* ((str0 (copy-seq "abc"))
       (str (remove #\a str0)))
  (and (not (eq str0 str))
       (string= str0 "abc")
       (string= str "bc")))
(string= (remove #\a (copy-seq "abcabc") :count 0) "abcabc")
(string= (remove #\a (copy-seq "abcabc")) "bcbc")
(string= (remove #\b (copy-seq "abcabc")) "acac")
(string= (remove #\c (copy-seq "abcabc")) "abab")
(string= (remove #\a (copy-seq "abcabc") :count 0) "abcabc")
(string= (remove #\a (copy-seq "abcabc") :count 1) "bcabc")
(string= (remove #\a (copy-seq "abcabc") :count 1 :from-end t) "abcbc")
(string= (remove #\a (copy-seq "abcabc") :count 2) "bcbc")
(string= (remove #\a (copy-seq "abcabc") :count 2 :from-end t) "bcbc")
(string= (remove #\a (copy-seq "abcabc") :count 3) "bcbc")
(string= (remove #\a (copy-seq "abcabc") :count 3 :from-end t) "bcbc")
(string= (remove #\a (copy-seq "abcabc") :count 4) "bcbc")
(string= (remove #\a (copy-seq "abcabc") :count 4 :from-end t) "bcbc")
(string= (remove #\a (copy-seq "abcabc") :count -1) "abcabc")
(string= (remove #\a (copy-seq "abcabc") :count -10) "abcabc")
(string= (remove #\a (copy-seq "abcabc") :count -100) "abcabc")
(string= (remove #\a (copy-seq "abcabcabcabc") :start 1) "abcbcbcbc")
(string= (remove #\a (copy-seq "abcabcabcabc") :start 1 :count 1) "abcbcabcabc")
(string= (remove #\a (copy-seq "abcabcabcabc") :start 1 :count 2) "abcbcbcabc")
(string= (remove #\a (copy-seq "abcabcabcabc") :start 1 :end nil :count 2)
         "abcbcbcabc")
(string= (remove #\a (copy-seq "abcabcabcabc") :start 1 :end 8) "abcbcbcabc")
(string= (remove #\a (copy-seq "abcabcabcabc") :start 1 :end 8 :count 1)
         "abcbcabcabc")
(string= (remove #\a (copy-seq "abcabcabcabc")
                 :start 1 :end 8 :count 1 :from-end t)
         "abcabcbcabc")
(string= (remove #\a (copy-seq "abcabcabcabc")
                 :start 1 :end 8 :count 0 :from-end t)
         "abcabcabcabc")
(string= (remove #\a (copy-seq "abcabcabcabc")
                 :start 1 :end 8 :count -100 :from-end t)
         "abcabcabcabc")
(string= (remove #\a (copy-seq "abcabcabcabc") :start 1 :end 1)
         "abcabcabcabc")
(string= (remove #\a (copy-seq "abcabcabcabc") :start 2 :end 2) "abcabcabcabc")
(string= (remove #\a (copy-seq "abcabcabcabc") :start 12 :end 12) "abcabcabcabc")
(equal (remove 0 #*0101) #*11)
(equal (remove 0 #*01010101 :count 1) #*1010101)
(equal (remove 0 #*01010101 :count 1 :from-end t) #*0101011)
(equal (remove 0 #*01010101 :start 1) #*01111)
(equal (remove 0 #*01010101 :start 1 :end nil) #*01111)
(equal (remove 0 #*01010101 :start 1 :end 6) #*011101)
(equal (remove 0 #*01010101 :start 1 :end 6 :count 1) #*0110101)
(equal (remove 0 #*01010101 :start 1 :end 6 :count 1 :from-end t) #*0101101)
(equal (remove 0 #*01010101
               :start 1 :end 6 :count 1 :from-end t
               :test #'(lambda (a b) (declare (ignore a)) (oddp b)))
       #*0101001)
(equal (remove 0 #*01010101
               :start 1 :end 6 :count 1 :from-end t
               :test-not #'(lambda (a b) (declare (ignore a)) (evenp b)))
       #*0101001)
(equal (remove 0 #*01010101
               :start 1 :end 6 :count 1 :from-end t
               :test #'(lambda (a b) (declare (ignore a)) (evenp b)))
       #*0101101)
(equal (remove 0 #*01010101
               :start 1 :end 6 :count 1 :from-end t
               :test-not #'(lambda (a b) (declare (ignore a)) (oddp b)))
       #*0101101)
(equal (remove 0 #*01010101
               :start 1 :end 6 :count 1 :from-end t
               :key #'(lambda (arg) (* arg 10))
               :test #'(lambda (a b) (declare (ignore a)) (> b 1)))
       #*0101001)


(let* ((list0 (list 0 1 2 3 4))
       (list (remove-if #'(lambda (arg) (eql arg 3)) list0)))
  (and (not (eq list0 list))
       (equal list0 '(0 1 2 3 4))
       (equal list '(0 1 2 4))))
(equal (remove-if #'(lambda (arg) (eql arg 'a)) (list 'a 'b 'c 'a 'b 'c))
       '(b c b c))
(equal (remove-if #'(lambda (arg) (eql arg 'b)) (list 'a 'b 'c 'a 'b 'c))
       '(a c a c))
(equal (remove-if #'(lambda (arg) (eql arg 'c)) (list 'a 'b 'c 'a 'b 'c))
       '(a b a b))
(equal (remove-if #'(lambda (arg) (eql arg 'a)) (list 'a 'a 'a)) '())
(equal (remove-if #'(lambda (arg) (eql arg 'z)) (list 'a 'b 'c)) '(a b c))
(equal (remove-if #'(lambda (arg) (eql arg 'a)) '()) '())
(equal (remove-if #'(lambda (arg) (eql arg 'a)) (list 'a 'b 'c 'a 'b 'c)
                  :count 0) '(a b c a b c))
(equal (remove-if #'(lambda (arg) (eql arg 'a)) (list 'a 'b 'c 'a 'b 'c)
                  :count 1) '(b c a b c))
(equal (remove-if #'(lambda (arg) (eql arg 'a)) (list 'a 'b 'c 'a 'b 'c)
                  :count 1 :from-end t) '(a b c b c))
(equal (remove-if #'(lambda (arg) (eql arg 'a)) (list 'a 'b 'c 'a 'b 'c)
                  :count 2) '(b c b c))
(equal (remove-if #'(lambda (arg) (eql arg 'a)) (list 'a 'b 'c 'a 'b 'c)
                  :count 2 :from-end t) '(b c b c))
(equal (remove-if #'(lambda (arg) (eql arg 'a)) (list 'a 'b 'c 'a 'b 'c)
                  :count 3) '(b c b c))
(equal (remove-if #'(lambda (arg) (eql arg 'a)) (list 'a 'b 'c 'a 'b 'c)
                  :count 3 :from-end t) '(b c b c))
(equal (remove-if #'(lambda (arg) (eql arg 'a)) (list 'a 'b 'c 'a 'b 'c)
                  :count 4) '(b c b c))
(equal (remove-if #'(lambda (arg) (eql arg 'a)) (list 'a 'b 'c 'a 'b 'c)
                  :count 4 :from-end t) '(b c b c))
(equal (remove-if #'(lambda (arg) (eql arg 'a)) (list 'a 'b 'c 'a 'b 'c)
                  :count -1) '(a b c a b c))
(equal (remove-if #'(lambda (arg) (eql arg 'a)) (list 'a 'b 'c 'a 'b 'c)
                  :count -10) '(a b c a b c))
(equal (remove-if #'(lambda (arg) (eql arg 'a)) (list 'a 'b 'c 'a 'b 'c)
                  :count -100) '(a b c a b c))
(equal (remove-if #'(lambda (arg) (eql arg 'a))
                  (list 'a 'b 'c 'a 'b 'c 'a 'b 'c 'a 'b 'c) :start 1)
       '(a b c b c b c b c))
(equal (remove-if #'(lambda (arg) (eql arg 'a))
                  (list 'a 'b 'c 'a 'b 'c 'a 'b 'c 'a 'b 'c) :start 1 :count 1)
       '(a b c b c a b c a b c))
(equal (remove-if #'(lambda (arg) (eql arg 'a))
                  (list 'a 'b 'c 'a 'b 'c 'a 'b 'c 'a 'b 'c) :start 1 :count 2)
       '(a b c b c b c a b c))
(equal (remove-if #'(lambda (arg) (eql arg 'a))
                  (list 'a 'b 'c 'a 'b 'c 'a 'b 'c 'a 'b 'c)
                  :start 1 :end nil :count 2)
       '(a b c b c b c a b c))
(equal (remove-if #'(lambda (arg) (eql arg 'a))
                  (list 'a 'b 'c 'a 'b 'c 'a 'b 'c 'a 'b 'c) :start 1 :end 8)
       '(a b c b c b c a b c))
(equal (remove-if #'(lambda (arg) (eql arg 'a))
                  (list 'a 'b 'c 'a 'b 'c 'a 'b 'c 'a 'b 'c)
                  :start 1 :end 8 :count 1)
       '(a b c b c a b c a b c))
(equal (remove-if #'(lambda (arg) (eql arg 'a))
                  (list 'a 'b 'c 'a 'b 'c 'a 'b 'c 'a 'b 'c)
                  :start 1 :end 8 :count 1 :from-end t)
       '(a b c a b c b c a b c))
(equal (remove-if #'(lambda (arg) (eql arg 'a))
                  (list 'a 'b 'c 'a 'b 'c 'a 'b 'c 'a 'b 'c)
                  :start 1 :end 8 :count 0 :from-end t)
       '(a b c a b c a b c a b c))
(equal (remove-if #'(lambda (arg) (eql arg 'a))
                  (list 'a 'b 'c 'a 'b 'c 'a 'b 'c 'a 'b 'c)
                  :start 1 :end 8 :count -100 :from-end t)
       '(a b c a b c a b c a b c))
(equal (remove-if #'(lambda (arg) (eql arg 'a))
                  (list 'a 'b 'c 'a 'b 'c 'a 'b 'c 'a 'b 'c) :start 1 :end 1)
       '(a b c a b c a b c a b c))
(equal (remove-if #'(lambda (arg) (eql arg 'a))
                  (list 'a 'b 'c 'a 'b 'c 'a 'b 'c 'a 'b 'c) :start 2 :end 2)
       '(a b c a b c a b c a b c))
(equal (remove-if #'(lambda (arg) (eql arg 'a))
                  (list 'a 'b 'c 'a 'b 'c 'a 'b 'c 'a 'b 'c)
                  :start 12 :end 12)
       '(a b c a b c a b c a b c))
(equal (remove-if #'(lambda (arg) (eql arg 'a))
                  (list '(a) '(b) '(c) '(a) '(b) '(c)) :key #'car)
       '((b) (c) (b) (c)))
(equal (remove-if #'(lambda (arg) (eql arg 'a))
                  (list '(a . b) '(b . c) '(c . a)
                        '(a . b) '(b . c) '(c . a))
                  :key #'cdr)
       '((a . b) (b . c) (a . b) (b . c)))
(equal (remove-if #'(lambda (arg) (eql arg "love"))
                  (list '("Love") '("LOve") '("LOVe") '("LOVE"))
                  :key #'car)
       '(("Love") ("LOve") ("LOVe") ("LOVE")))
(equal (remove-if #'(lambda (arg) (eql arg "love"))
                  (list '("Love") '("LOve") '("LOVe") '("LOVE"))
                  :key #'car :count -10)
       '(("Love") ("LOve") ("LOVe") ("LOVE")))
(equal (remove-if #'(lambda (arg) (string-equal arg "love"))
                      (list '("Love") '("LOve") '("LOVe") '("LOVE"))
                      :key #'car)
       '())
(equal (remove-if #'(lambda (arg) (string-equal arg "love"))
                  (list '("Love") '("LOve") '("LOVe") '("LOVE"))
                  :key #'car :count 1)
       '(("LOve") ("LOVe") ("LOVE")))
(equal (remove-if #'(lambda (arg) (string-equal arg "love"))
                  (list '("Love") '("LOve") '("LOVe") '("LOVE"))
                  :key #'car :count 1 :from-end t)
       '(("Love") ("LOve") ("LOVe")))
(equal (remove-if #'(lambda (arg) (string-equal arg "love"))
                  (list '("Love") '("LOve") '("LOVe") '("LOVE"))
                  :key #'car :count 2 :from-end t)
       '(("Love") ("LOve")))
(equal (remove-if #'(lambda (arg) (string-equal arg "love"))
                  (list '("Love") '("LOve") '("LOVe") '("LOVE"))
                  :key #'car :start 1 :end 3)
       '(("Love") ("LOVE")))
(equal (remove-if #'(lambda (arg) (string-equal arg "love"))
                  (list '("Love") '("LOve") '("LOVe") '("LOVE"))
                  :key #'car :count 1 :start 1 :end 3)
       '(("Love") ("LOVe") ("LOVE")))
(equal (remove-if #'(lambda (arg) (string-equal arg "love"))
                  (list '("Love") '("LOve") '("LOVe") '("LOVE"))
                  :key #'car :count 1 :from-end t
                  :start 1 :end 3)
       '(("Love") ("LOve") ("LOVE")))
(equal (remove-if #'(lambda (arg) (string-equal arg "love"))
                  (list '("Love") '("LOve") '("LOVe") '("LOVE"))
                  :key #'car :count 10 :from-end t :start 1 :end 3)
       '(("Love") ("LOVE")))


(let* ((vector0 (vector 0 1 2 3 4))
       (vector (remove-if #'(lambda (arg) (eql arg 3)) vector0)))
  (and (not (eq vector0 vector))
       (equalp vector0 #(0 1 2 3 4))
       (equalp vector #(0 1 2 4))))
(equalp (remove-if #'(lambda (arg) (eql arg 'a))
                   (vector 'a 'b 'c 'a 'b 'c)) #(b c b c))
(equalp (remove-if #'(lambda (arg) (eql arg 'b))
                   (vector 'a 'b 'c 'a 'b 'c)) #(a c a c))
(equalp (remove-if #'(lambda (arg) (eql arg 'c))
                   (vector 'a 'b 'c 'a 'b 'c)) #(a b a b))
(equalp (remove-if #'(lambda (arg) (eql arg 'a))
                   (vector 'a 'a 'a)) #())
(equalp (remove-if #'(lambda (arg) (eql arg 'z))
                   (vector 'a 'b 'c)) #(a b c))
(equalp (remove-if #'(lambda (arg) (eql arg 'a)) #()) #())
(equalp (remove-if #'(lambda (arg) (eql arg 'a))
                   (vector 'a 'b 'c 'a 'b 'c) :count 0) #(a b c a b c))
(equalp (remove-if #'(lambda (arg) (eql arg 'a))
                   (vector 'a 'b 'c 'a 'b 'c) :count 1) #(b c a b c))
(equalp (remove-if #'(lambda (arg) (eql arg 'a))
                   (vector 'a 'b 'c 'a 'b 'c) :count 1 :from-end t) #(a b c b c))
(equalp (remove-if #'(lambda (arg) (eql arg 'a))
                   (vector 'a 'b 'c 'a 'b 'c) :count 2) #(b c b c))
(equalp (remove-if #'(lambda (arg) (eql arg 'a))
                   (vector 'a 'b 'c 'a 'b 'c) :count 2 :from-end t) #(b c b c))
(equalp (remove-if #'(lambda (arg) (eql arg 'a))
                   (vector 'a 'b 'c 'a 'b 'c) :count 3) #(b c b c))
(equalp (remove-if #'(lambda (arg) (eql arg 'a))
                   (vector 'a 'b 'c 'a 'b 'c) :count 3 :from-end t) #(b c b c))
(equalp (remove-if #'(lambda (arg) (eql arg 'a))
                   (vector 'a 'b 'c 'a 'b 'c) :count 4) #(b c b c))
(equalp (remove-if #'(lambda (arg) (eql arg 'a))
                   (vector 'a 'b 'c 'a 'b 'c) :count 4 :from-end t) #(b c b c))
(equalp (remove-if #'(lambda (arg) (eql arg 'a))
                   (vector 'a 'b 'c 'a 'b 'c) :count -1) #(a b c a b c))
(equalp (remove-if #'(lambda (arg) (eql arg 'a))
                   (vector 'a 'b 'c 'a 'b 'c) :count -10) #(a b c a b c))
(equalp (remove-if #'(lambda (arg) (eql arg 'a))
                   (vector 'a 'b 'c 'a 'b 'c) :count -100) #(a b c a b c))
(equalp (remove-if #'(lambda (arg) (eql arg 'a))
                   (vector 'a 'b 'c 'a 'b 'c 'a 'b 'c 'a 'b 'c) :start 1)
        #(a b c b c b c b c))
(equalp (remove-if #'(lambda (arg) (eql arg 'a))
                   (vector 'a 'b 'c 'a 'b 'c 'a 'b 'c 'a 'b 'c)
                   :start 1 :count 1)
       #(a b c b c a b c a b c))
(equalp (remove-if #'(lambda (arg) (eql arg 'a))
                   (vector 'a 'b 'c 'a 'b 'c 'a 'b 'c 'a 'b 'c)
                   :start 1 :count 2)
        #(a b c b c b c a b c))
(equalp (remove-if #'(lambda (arg) (eql arg 'a))
                   (vector 'a 'b 'c 'a 'b 'c 'a 'b 'c 'a 'b 'c)
                   :start 1 :end nil :count 2)
        #(a b c b c b c a b c))
(equalp (remove-if #'(lambda (arg) (eql arg 'a))
                   (vector 'a 'b 'c 'a 'b 'c 'a 'b 'c 'a 'b 'c) :start 1 :end 8)
        #(a b c b c b c a b c))
(equalp (remove-if #'(lambda (arg) (eql arg 'a))
                   (vector 'a 'b 'c 'a 'b 'c 'a 'b 'c 'a 'b 'c)
                   :start 1 :end 8 :count 1)
        #(a b c b c a b c a b c))
(equalp (remove-if #'(lambda (arg) (eql arg 'a))
                   (vector 'a 'b 'c 'a 'b 'c 'a 'b 'c 'a 'b 'c)
                   :start 1 :end 8 :count 1 :from-end t)
        #(a b c a b c b c a b c))
(equalp (remove-if #'(lambda (arg) (eql arg 'a))
                   (vector 'a 'b 'c 'a 'b 'c 'a 'b 'c 'a 'b 'c)
                   :start 1 :end 8 :count 0 :from-end t)
        #(a b c a b c a b c a b c))
(equalp (remove-if #'(lambda (arg) (eql arg 'a))
                   (vector 'a 'b 'c 'a 'b 'c 'a 'b 'c 'a 'b 'c)
                   :start 1 :end 8 :count -100 :from-end t)
        #(a b c a b c a b c a b c))
(equalp (remove-if #'(lambda (arg) (eql arg 'a))
                   (vector 'a 'b 'c 'a 'b 'c 'a 'b 'c 'a 'b 'c) :start 1 :end 1)
        #(a b c a b c a b c a b c))
(equalp (remove-if #'(lambda (arg) (eql arg 'a))
                   (vector 'a 'b 'c 'a 'b 'c 'a 'b 'c 'a 'b 'c) :start 2 :end 2)
        #(a b c a b c a b c a b c))
(equalp (remove-if #'(lambda (arg) (eql arg 'a))
                   (vector 'a 'b 'c 'a 'b 'c 'a 'b 'c 'a 'b 'c)
                   :start 12 :end 12)
        #(a b c a b c a b c a b c))
(equalp (remove-if #'(lambda (arg) (eql arg 'a))
                   (vector '(a) '(b) '(c) '(a) '(b) '(c)) :key #'car)
        #((b) (c) (b) (c)))
(equalp (remove-if #'(lambda (arg) (eql arg 'a))
                   (vector '(a . b) '(b . c) '(c . a)
                           '(a . b) '(b . c) '(c . a))
               :key #'cdr)
        #((a . b) (b . c) (a . b) (b . c)))
(equalp (remove-if #'(lambda (arg) (eql arg "love"))
                   (vector '("Love") '("LOve") '("LOVe") '("LOVE"))
                   :key #'car)
        #(("Love") ("LOve") ("LOVe") ("LOVE")))
(equalp (remove-if #'(lambda (arg) (eql arg "love"))
                   (vector '("Love") '("LOve") '("LOVe") '("LOVE"))
                   :key #'car :count -10)
        #(("Love") ("LOve") ("LOVe") ("LOVE")))
(equalp (remove-if #'(lambda (arg) (string-equal arg "love"))
                   (vector '("Love") '("LOve") '("LOVe") '("LOVE"))
                   :key #'car)
        #())
(equalp (remove-if #'(lambda (arg) (string-equal arg "love"))
                   (vector '("Love") '("LOve") '("LOVe") '("LOVE"))
                   :key #'car)
        #())
(equalp (remove-if #'(lambda (arg) (string-equal arg "love"))
                   (vector '("Love") '("LOve") '("LOVe") '("LOVE"))
                   :key #'car :count 1)
        #(("LOve") ("LOVe") ("LOVE")))
(equalp (remove-if #'(lambda (arg) (string-equal arg "love"))
                   (vector '("Love") '("LOve") '("LOVe") '("LOVE"))
                   :key #'car :count 1)
        #(("LOve") ("LOVe") ("LOVE")))
(equalp (remove-if #'(lambda (arg) (string-equal arg "love"))
                   (vector '("Love") '("LOve") '("LOVe") '("LOVE"))
                   :key #'car :count 1 :from-end t)
        #(("Love") ("LOve") ("LOVe")))
(equalp (remove-if #'(lambda (arg) (string-equal arg "love"))
                   (vector '("Love") '("LOve") '("LOVe") '("LOVE"))
                   :key #'car :count 1 :from-end t)
        #(("Love") ("LOve") ("LOVe")))
(equalp (remove-if #'(lambda (arg) (string-equal arg "love"))
                   (vector '("Love") '("LOve") '("LOVe") '("LOVE"))
                   :key #'car :count 2 :from-end t)
        #(("Love") ("LOve")))
(equalp (remove-if #'(lambda (arg) (string-equal arg "love"))
                   (vector '("Love") '("LOve") '("LOVe") '("LOVE"))
                   :key #'car :count 2 :from-end t)
        #(("Love") ("LOve")))
(equalp (remove-if #'(lambda (arg) (string-equal arg "love"))
                   (vector '("Love") '("LOve") '("LOVe") '("LOVE"))
                   :key #'car :start 1 :end 3)
        #(("Love") ("LOVE")))
(equalp (remove-if #'(lambda (arg) (string-equal arg "love"))
                   (vector '("Love") '("LOve") '("LOVe") '("LOVE"))
                   :key #'car :count 1 :start 1 :end 3)
        #(("Love") ("LOVe") ("LOVE")))
(equalp (remove-if #'(lambda (arg) (string-equal arg "love"))
                   (vector '("Love") '("LOve") '("LOVe") '("LOVE"))
                   :key #'car :count 1 :from-end t
                   :start 1 :end 3)
        #(("Love") ("LOve") ("LOVE")))
(equalp (remove-if #'(lambda (arg) (string-equal arg "love"))
                   (vector '("Love") '("LOve") '("LOVe") '("LOVE"))
                   :key #'car :count 10 :from-end t
                   :start 1 :end 3)
        #(("Love") ("LOVE")))

(string= (remove-if #'(lambda (arg) (string-equal arg #\a)) (copy-seq "abcabc"))
         "bcbc")
(string= (remove-if #'(lambda (arg) (string-equal arg #\a)) (copy-seq "")) "")
(string= (remove-if #'(lambda (arg) (string-equal arg #\a)) (copy-seq "xyz"))
         "xyz")
(string= (remove-if #'(lambda (arg) (string-equal arg #\a)) (copy-seq "ABCABC")
                    :key #'char-downcase) "BCBC")
(string= (remove-if #'(lambda (arg) (string-equal arg #\a)) (copy-seq "abcabc")
                    :count 1) "bcabc")
(string= (remove-if #'(lambda (arg) (string-equal arg #\a)) (copy-seq "abcabc")
                    :count 1 :from-end t) "abcbc")
(string= (remove-if #'(lambda (arg) (string-equal arg #\a)) (copy-seq "abcabc")
                    :count 0) "abcabc")
(string= (remove-if #'(lambda (arg) (string-equal arg #\a)) (copy-seq "abcabc")
                    :count -10) "abcabc")
(let* ((str0 (copy-seq "abc"))
       (str (remove-if #'(lambda (arg) (string-equal arg #\a)) str0)))
  (and (not (eq str0 str))
       (string= str0 "abc")
       (string= str "bc")))
(string= (remove-if #'(lambda (arg) (string-equal arg #\a)) (copy-seq "abcabc")
                    :count 0) "abcabc")
(string= (remove-if #'(lambda (arg) (string-equal arg #\a)) (copy-seq "abcabc"))
         "bcbc")
(string= (remove-if #'(lambda (arg) (string-equal arg #\b)) (copy-seq "abcabc"))
         "acac")
(string= (remove-if #'(lambda (arg) (string-equal arg #\c)) (copy-seq "abcabc"))
         "abab")
(string= (remove-if #'(lambda (arg) (string-equal arg #\a)) (copy-seq "abcabc")
                    :count 0) "abcabc")
(string= (remove-if #'(lambda (arg) (string-equal arg #\a)) (copy-seq "abcabc")
                    :count 1) "bcabc")
(string= (remove-if #'(lambda (arg) (string-equal arg #\a)) (copy-seq "abcabc")
                    :count 1 :from-end t) "abcbc")
(string= (remove-if #'(lambda (arg) (string-equal arg #\a)) (copy-seq "abcabc")
                    :count 2) "bcbc")
(string= (remove-if #'(lambda (arg) (string-equal arg #\a)) (copy-seq "abcabc")
                    :count 2 :from-end t) "bcbc")
(string= (remove-if #'(lambda (arg) (string-equal arg #\a)) (copy-seq "abcabc")
                    :count 3) "bcbc")
(string= (remove-if #'(lambda (arg) (string-equal arg #\a)) (copy-seq "abcabc")
                    :count 3 :from-end t) "bcbc")
(string= (remove-if #'(lambda (arg) (string-equal arg #\a)) (copy-seq "abcabc")
                    :count 4) "bcbc")
(string= (remove-if #'(lambda (arg) (string-equal arg #\a)) (copy-seq "abcabc")
                    :count 4 :from-end t) "bcbc")
(string= (remove-if #'(lambda (arg) (string-equal arg #\a)) (copy-seq "abcabc")
                    :count -1) "abcabc")
(string= (remove-if #'(lambda (arg) (string-equal arg #\a)) (copy-seq "abcabc")
                    :count -10) "abcabc")
(string= (remove-if #'(lambda (arg) (string-equal arg #\a)) (copy-seq "abcabc")
                    :count -100) "abcabc")
(string= (remove-if #'(lambda (arg) (string-equal arg #\a))
                    (copy-seq "abcabcabcabc") :start 1) "abcbcbcbc")
(string= (remove-if #'(lambda (arg) (string-equal arg #\a))
                    (copy-seq "abcabcabcabc") :start 1 :count 1) "abcbcabcabc")
(string= (remove-if #'(lambda (arg) (eql arg #\a)) (copy-seq "abcabcabcabc")
                    :start 1 :count 2)
         "abcbcbcabc")
(string= (remove-if #'(lambda (arg) (eql arg #\a)) (copy-seq "abcabcabcabc")
                    :start 1 :end nil :count 2)
         "abcbcbcabc")
(string= (remove-if #'(lambda (arg) (eql arg #\a)) (copy-seq "abcabcabcabc")
                    :start 1 :end 8) "abcbcbcabc")
(string= (remove-if #'(lambda (arg) (eql arg #\a)) (copy-seq "abcabcabcabc")
                    :start 1 :end 8 :count 1)
         "abcbcabcabc")
(string= (remove-if #'(lambda (arg) (eql arg #\a)) (copy-seq "abcabcabcabc")
                 :start 1 :end 8 :count 1 :from-end t)
         "abcabcbcabc")
(string= (remove-if #'(lambda (arg) (eql arg #\a)) (copy-seq "abcabcabcabc")
                 :start 1 :end 8 :count 0 :from-end t)
         "abcabcabcabc")
(string= (remove-if #'(lambda (arg) (eql arg #\a)) (copy-seq "abcabcabcabc")
                 :start 1 :end 8 :count -100 :from-end t)
         "abcabcabcabc")
(string= (remove-if #'(lambda (arg) (eql arg #\a)) (copy-seq "abcabcabcabc")
                    :start 1 :end 1)
         "abcabcabcabc")
(string= (remove-if #'(lambda (arg) (eql arg #\a)) (copy-seq "abcabcabcabc")
                    :start 2 :end 2) "abcabcabcabc")
(string= (remove-if #'(lambda (arg) (eql arg #\a)) (copy-seq "abcabcabcabc")
                    :start 12 :end 12) "abcabcabcabc")
(equal (remove-if #'zerop #*0101) #*11)
(equal (remove-if #'zerop #*01010101 :count 1) #*1010101)
(equal (remove-if #'zerop #*01010101 :count 1 :from-end t) #*0101011)
(equal (remove-if #'zerop #*01010101 :start 1) #*01111)
(equal (remove-if #'zerop #*01010101 :start 1 :end nil) #*01111)
(equal (remove-if #'zerop #*01010101 :start 1 :end 6) #*011101)
(equal (remove-if #'zerop #*01010101 :start 1 :end 6 :count 1) #*0110101)
(equal (remove-if #'zerop #*01010101 :start 1 :end 6 :count 1 :from-end t)
       #*0101101)
(equal (remove-if #'oddp #*01010101 :start 1 :end 6 :count 1 :from-end t)
       #*0101001)
(equal (remove-if #'evenp #*01010101 :start 1 :end 6 :count 1 :from-end t)
       #*0101101)
(equal (remove-if #'plusp #*01010101
               :start 1 :end 6 :count 1 :from-end t
               :key #'(lambda (arg) (* arg 10)))
       #*0101001)


(let* ((list0 (list 0 1 2 3 4))
       (list (remove-if-not #'(lambda (arg) (not (eql arg 3))) list0)))
  (and (not (eq list0 list))
       (equal list0 '(0 1 2 3 4))
       (equal list '(0 1 2 4))))
(equal (remove-if-not #'(lambda (arg) (not (eql arg 'a)))
                      (list 'a 'b 'c 'a 'b 'c))
       '(b c b c))
(equal (remove-if-not #'(lambda (arg) (not (eql arg 'b)))
                      (list 'a 'b 'c 'a 'b 'c))
       '(a c a c))
(equal (remove-if-not #'(lambda (arg) (not (eql arg 'c)))
                      (list 'a 'b 'c 'a 'b 'c))
       '(a b a b))
(equal (remove-if-not #'(lambda (arg) (not (eql arg 'a)))
                      (list 'a 'a 'a)) '())
(equal (remove-if-not #'(lambda (arg) (not (eql arg 'z)))
                      (list 'a 'b 'c)) '(a b c))
(equal (remove-if-not #'(lambda (arg) (not (eql arg 'a))) '()) '())
(equal (remove-if-not #'(lambda (arg) (not (eql arg 'a)))
                      (list 'a 'b 'c 'a 'b 'c) :count 0) '(a b c a b c))
(equal (remove-if-not #'(lambda (arg) (not (eql arg 'a)))
                      (list 'a 'b 'c 'a 'b 'c) :count 1) '(b c a b c))
(equal (remove-if-not #'(lambda (arg) (not (eql arg 'a)))
                      (list 'a 'b 'c 'a 'b 'c) :count 1 :from-end t)
       '(a b c b c))
(equal (remove-if-not #'(lambda (arg) (not (eql arg 'a)))
                      (list 'a 'b 'c 'a 'b 'c) :count 2)
       '(b c b c))
(equal (remove-if-not #'(lambda (arg) (not (eql arg 'a)))
                      (list 'a 'b 'c 'a 'b 'c) :count 2 :from-end t)
       '(b c b c))
(equal (remove-if-not #'(lambda (arg) (not (eql arg 'a)))
                      (list 'a 'b 'c 'a 'b 'c) :count 3)
       '(b c b c))
(equal (remove-if-not #'(lambda (arg) (not (eql arg 'a)))
                      (list 'a 'b 'c 'a 'b 'c) :count 3 :from-end t)
       '(b c b c))
(equal (remove-if-not #'(lambda (arg) (not (eql arg 'a)))
                      (list 'a 'b 'c 'a 'b 'c) :count 4)
       '(b c b c))
(equal (remove-if-not #'(lambda (arg) (not (eql arg 'a)))
                      (list 'a 'b 'c 'a 'b 'c) :count 4 :from-end t)
       '(b c b c))
(equal (remove-if-not #'(lambda (arg) (not (eql arg 'a)))
                      (list 'a 'b 'c 'a 'b 'c) :count -1)
       '(a b c a b c))
(equal (remove-if-not #'(lambda (arg) (not (eql arg 'a)))
                      (list 'a 'b 'c 'a 'b 'c) :count -10)
       '(a b c a b c))
(equal (remove-if-not #'(lambda (arg) (not (eql arg 'a)))
                      (list 'a 'b 'c 'a 'b 'c) :count -100)
       '(a b c a b c))
(equal (remove-if-not #'(lambda (arg) (not (eql arg 'a)))
                      (list 'a 'b 'c 'a 'b 'c 'a 'b 'c 'a 'b 'c) :start 1)
       '(a b c b c b c b c))
(equal (remove-if-not #'(lambda (arg) (not (eql arg 'a)))
                      (list 'a 'b 'c 'a 'b 'c 'a 'b 'c 'a 'b 'c)
                      :start 1 :count 1)
       '(a b c b c a b c a b c))
(equal (remove-if-not #'(lambda (arg) (not (eql arg 'a)))
                      (list 'a 'b 'c 'a 'b 'c 'a 'b 'c 'a 'b 'c)
                      :start 1 :count 2)
       '(a b c b c b c a b c))
(equal (remove-if-not #'(lambda (arg) (not (eql arg 'a)))
                      (list 'a 'b 'c 'a 'b 'c 'a 'b 'c 'a 'b 'c)
                      :start 1 :end nil :count 2)
       '(a b c b c b c a b c))
(equal (remove-if-not #'(lambda (arg) (not (eql arg 'a)))
                      (list 'a 'b 'c 'a 'b 'c 'a 'b 'c 'a 'b 'c) :start 1 :end 8)
       '(a b c b c b c a b c))
(equal (remove-if-not #'(lambda (arg) (not (eql arg 'a)))
                      (list 'a 'b 'c 'a 'b 'c 'a 'b 'c 'a 'b 'c)
                      :start 1 :end 8 :count 1)
       '(a b c b c a b c a b c))
(equal (remove-if-not #'(lambda (arg) (not (eql arg 'a)))
                      (list 'a 'b 'c 'a 'b 'c 'a 'b 'c 'a 'b 'c)
                      :start 1 :end 8 :count 1 :from-end t)
       '(a b c a b c b c a b c))
(equal (remove-if-not #'(lambda (arg) (not (eql arg 'a)))
                      (list 'a 'b 'c 'a 'b 'c 'a 'b 'c 'a 'b 'c)
                      :start 1 :end 8 :count 0 :from-end t)
       '(a b c a b c a b c a b c))
(equal (remove-if-not #'(lambda (arg) (not (eql arg 'a)))
                      (list 'a 'b 'c 'a 'b 'c 'a 'b 'c 'a 'b 'c)
                      :start 1 :end 8 :count -100 :from-end t)
       '(a b c a b c a b c a b c))
(equal (remove-if-not #'(lambda (arg) (not (eql arg 'a)))
                      (list 'a 'b 'c 'a 'b 'c 'a 'b 'c 'a 'b 'c) :start 1 :end 1)
       '(a b c a b c a b c a b c))
(equal (remove-if-not #'(lambda (arg) (not (eql arg 'a)))
                      (list 'a 'b 'c 'a 'b 'c 'a 'b 'c 'a 'b 'c) :start 2 :end 2)
       '(a b c a b c a b c a b c))
(equal (remove-if-not #'(lambda (arg) (not (eql arg 'a)))
                      (list 'a 'b 'c 'a 'b 'c 'a 'b 'c 'a 'b 'c)
                      :start 12 :end 12)
       '(a b c a b c a b c a b c))
(equal (remove-if-not #'(lambda (arg) (not (eql arg 'a)))
                      (list '(a) '(b) '(c) '(a) '(b) '(c)) :key #'car)
       '((b) (c) (b) (c)))
(equal (remove-if-not #'(lambda (arg) (not (eql arg 'a)))
                      (list '(a . b) '(b . c) '(c . a)
                            '(a . b) '(b . c) '(c . a))
                      :key #'cdr)
       '((a . b) (b . c) (a . b) (b . c)))
(equal (remove-if-not #'(lambda (arg) (not (eql arg "love")))
                      (list '("Love") '("LOve") '("LOVe") '("LOVE"))
                      :key #'car)
       '(("Love") ("LOve") ("LOVe") ("LOVE")))
(equal (remove-if-not #'(lambda (arg) (not (eql arg "love")))
                      (list '("Love") '("LOve") '("LOVe") '("LOVE"))
                      :key #'car :count -10)
       '(("Love") ("LOve") ("LOVe") ("LOVE")))
(equal (remove-if-not #'(lambda (arg) (not (string-equal arg "love")))
                      (list '("Love") '("LOve") '("LOVe") '("LOVE"))
                      :key #'car)
       '())
(equal (remove-if-not #'(lambda (arg) (not (string-equal arg "love")))
                      (list '("Love") '("LOve") '("LOVe") '("LOVE"))
                      :key #'car :count 1)
       '(("LOve") ("LOVe") ("LOVE")))
(equal (remove-if-not #'(lambda (arg) (not (string-equal arg "love")))
                      (list '("Love") '("LOve") '("LOVe") '("LOVE"))
                      :key #'car :count 1 :from-end t)
       '(("Love") ("LOve") ("LOVe")))
(equal (remove-if-not #'(lambda (arg) (not (string-equal arg "love")))
                      (list '("Love") '("LOve") '("LOVe") '("LOVE"))
                      :key #'car :count 2 :from-end t)
       '(("Love") ("LOve")))
(equal (remove-if-not #'(lambda (arg) (not (string-equal arg "love")))
                      (list '("Love") '("LOve") '("LOVe") '("LOVE"))
                      :key #'car :start 1 :end 3)
       '(("Love") ("LOVE")))
(equal (remove-if-not #'(lambda (arg) (not (string-equal arg "love")))
                      (list '("Love") '("LOve") '("LOVe") '("LOVE"))
                      :key #'car :count 1 :start 1 :end 3)
       '(("Love") ("LOVe") ("LOVE")))
(equal (remove-if-not #'(lambda (arg) (not (string-equal arg "love")))
                      (list '("Love") '("LOve") '("LOVe") '("LOVE"))
                      :key #'car :count 1 :from-end t
                      :start 1 :end 3)
       '(("Love") ("LOve") ("LOVE")))
(equal (remove-if-not #'(lambda (arg) (not (string-equal arg "love")))
                      (list '("Love") '("LOve") '("LOVe") '("LOVE"))
                      :key #'car :count 10 :from-end t :start 1 :end 3)
       '(("Love") ("LOVE")))


(let* ((vector0 (vector 0 1 2 3 4))
       (vector (remove-if-not #'(lambda (arg) (not (eql arg 3))) vector0)))
  (and (not (eq vector0 vector))
       (equalp vector0 #(0 1 2 3 4))
       (equalp vector #(0 1 2 4))))
(equalp (remove-if-not #'(lambda (arg) (not (eql arg 'a)))
                       (vector 'a 'b 'c 'a 'b 'c)) #(b c b c))
(equalp (remove-if-not #'(lambda (arg) (not (eql arg 'b)))
                       (vector 'a 'b 'c 'a 'b 'c)) #(a c a c))
(equalp (remove-if-not #'(lambda (arg) (not (eql arg 'c)))
                   (vector 'a 'b 'c 'a 'b 'c)) #(a b a b))
(equalp (remove-if-not #'(lambda (arg) (not (eql arg 'a)))
                   (vector 'a 'a 'a)) #())
(equalp (remove-if-not #'(lambda (arg) (not (eql arg 'z)))
                   (vector 'a 'b 'c)) #(a b c))
(equalp (remove-if-not #'(lambda (arg) (not (eql arg 'a))) #()) #())
(equalp (remove-if-not #'(lambda (arg) (not (eql arg 'a)))
                   (vector 'a 'b 'c 'a 'b 'c) :count 0) #(a b c a b c))
(equalp (remove-if-not #'(lambda (arg) (not (eql arg 'a)))
                   (vector 'a 'b 'c 'a 'b 'c) :count 1) #(b c a b c))
(equalp (remove-if-not #'(lambda (arg) (not (eql arg 'a)))
                   (vector 'a 'b 'c 'a 'b 'c) :count 1 :from-end t) #(a b c b c))
(equalp (remove-if-not #'(lambda (arg) (not (eql arg 'a)))
                   (vector 'a 'b 'c 'a 'b 'c) :count 2) #(b c b c))
(equalp (remove-if-not #'(lambda (arg) (not (eql arg 'a)))
                   (vector 'a 'b 'c 'a 'b 'c) :count 2 :from-end t) #(b c b c))
(equalp (remove-if-not #'(lambda (arg) (not (eql arg 'a)))
                   (vector 'a 'b 'c 'a 'b 'c) :count 3) #(b c b c))
(equalp (remove-if-not #'(lambda (arg) (not (eql arg 'a)))
                   (vector 'a 'b 'c 'a 'b 'c) :count 3 :from-end t) #(b c b c))
(equalp (remove-if-not #'(lambda (arg) (not (eql arg 'a)))
                   (vector 'a 'b 'c 'a 'b 'c) :count 4) #(b c b c))
(equalp (remove-if-not #'(lambda (arg) (not (eql arg 'a)))
                   (vector 'a 'b 'c 'a 'b 'c) :count 4 :from-end t) #(b c b c))
(equalp (remove-if-not #'(lambda (arg) (not (eql arg 'a)))
                   (vector 'a 'b 'c 'a 'b 'c) :count -1) #(a b c a b c))
(equalp (remove-if-not #'(lambda (arg) (not (eql arg 'a)))
                   (vector 'a 'b 'c 'a 'b 'c) :count -10) #(a b c a b c))
(equalp (remove-if-not #'(lambda (arg) (not (eql arg 'a)))
                   (vector 'a 'b 'c 'a 'b 'c) :count -100) #(a b c a b c))
(equalp (remove-if-not #'(lambda (arg) (not (eql arg 'a)))
                   (vector 'a 'b 'c 'a 'b 'c 'a 'b 'c 'a 'b 'c) :start 1)
        #(a b c b c b c b c))
(equalp (remove-if-not #'(lambda (arg) (not (eql arg 'a)))
                   (vector 'a 'b 'c 'a 'b 'c 'a 'b 'c 'a 'b 'c)
                   :start 1 :count 1)
       #(a b c b c a b c a b c))
(equalp (remove-if-not #'(lambda (arg) (not (eql arg 'a)))
                   (vector 'a 'b 'c 'a 'b 'c 'a 'b 'c 'a 'b 'c)
                   :start 1 :count 2)
        #(a b c b c b c a b c))
(equalp (remove-if-not #'(lambda (arg) (not (eql arg 'a)))
                   (vector 'a 'b 'c 'a 'b 'c 'a 'b 'c 'a 'b 'c)
                   :start 1 :end nil :count 2)
        #(a b c b c b c a b c))
(equalp (remove-if-not #'(lambda (arg) (not (eql arg 'a)))
                   (vector 'a 'b 'c 'a 'b 'c 'a 'b 'c 'a 'b 'c) :start 1 :end 8)
        #(a b c b c b c a b c))
(equalp (remove-if-not #'(lambda (arg) (not (eql arg 'a)))
                   (vector 'a 'b 'c 'a 'b 'c 'a 'b 'c 'a 'b 'c)
                   :start 1 :end 8 :count 1)
        #(a b c b c a b c a b c))
(equalp (remove-if-not #'(lambda (arg) (not (eql arg 'a)))
                   (vector 'a 'b 'c 'a 'b 'c 'a 'b 'c 'a 'b 'c)
                   :start 1 :end 8 :count 1 :from-end t)
        #(a b c a b c b c a b c))
(equalp (remove-if-not #'(lambda (arg) (not (eql arg 'a)))
                   (vector 'a 'b 'c 'a 'b 'c 'a 'b 'c 'a 'b 'c)
                   :start 1 :end 8 :count 0 :from-end t)
        #(a b c a b c a b c a b c))
(equalp (remove-if-not #'(lambda (arg) (not (eql arg 'a)))
                   (vector 'a 'b 'c 'a 'b 'c 'a 'b 'c 'a 'b 'c)
                   :start 1 :end 8 :count -100 :from-end t)
        #(a b c a b c a b c a b c))
(equalp (remove-if-not #'(lambda (arg) (not (eql arg 'a)))
                   (vector 'a 'b 'c 'a 'b 'c 'a 'b 'c 'a 'b 'c) :start 1 :end 1)
        #(a b c a b c a b c a b c))
(equalp (remove-if-not #'(lambda (arg) (not (eql arg 'a)))
                   (vector 'a 'b 'c 'a 'b 'c 'a 'b 'c 'a 'b 'c) :start 2 :end 2)
        #(a b c a b c a b c a b c))
(equalp (remove-if-not #'(lambda (arg) (not (eql arg 'a)))
                   (vector 'a 'b 'c 'a 'b 'c 'a 'b 'c 'a 'b 'c)
                   :start 12 :end 12)
        #(a b c a b c a b c a b c))
(equalp (remove-if-not #'(lambda (arg) (not (eql arg 'a)))
                   (vector '(a) '(b) '(c) '(a) '(b) '(c)) :key #'car)
        #((b) (c) (b) (c)))
(equalp (remove-if-not #'(lambda (arg) (not (eql arg 'a)))
                   (vector '(a . b) '(b . c) '(c . a)
                           '(a . b) '(b . c) '(c . a))
               :key #'cdr)
        #((a . b) (b . c) (a . b) (b . c)))
(equalp (remove-if-not #'(lambda (arg) (not (eql arg "love")))
                   (vector '("Love") '("LOve") '("LOVe") '("LOVE"))
                   :key #'car)
        #(("Love") ("LOve") ("LOVe") ("LOVE")))
(equalp (remove-if-not #'(lambda (arg) (not (eql arg "love")))
                   (vector '("Love") '("LOve") '("LOVe") '("LOVE"))
                   :key #'car :count -10)
        #(("Love") ("LOve") ("LOVe") ("LOVE")))
(equalp (remove-if-not #'(lambda (arg) (not (string-equal arg "love")))
                   (vector '("Love") '("LOve") '("LOVe") '("LOVE"))
                   :key #'car)
        #())
(equalp (remove-if-not #'(lambda (arg) (not (string-equal arg "love")))
                   (vector '("Love") '("LOve") '("LOVe") '("LOVE"))
                   :key #'car)
        #())
(equalp (remove-if-not #'(lambda (arg) (not (string-equal arg "love")))
                   (vector '("Love") '("LOve") '("LOVe") '("LOVE"))
                   :key #'car :count 1)
        #(("LOve") ("LOVe") ("LOVE")))
(equalp (remove-if-not #'(lambda (arg) (not (string-equal arg "love")))
                   (vector '("Love") '("LOve") '("LOVe") '("LOVE"))
                   :key #'car :count 1)
        #(("LOve") ("LOVe") ("LOVE")))
(equalp (remove-if-not #'(lambda (arg) (not (string-equal arg "love")))
                   (vector '("Love") '("LOve") '("LOVe") '("LOVE"))
                   :key #'car :count 1 :from-end t)
        #(("Love") ("LOve") ("LOVe")))
(equalp (remove-if-not #'(lambda (arg) (not (string-equal arg "love")))
                   (vector '("Love") '("LOve") '("LOVe") '("LOVE"))
                   :key #'car :count 1 :from-end t)
        #(("Love") ("LOve") ("LOVe")))
(equalp (remove-if-not #'(lambda (arg) (not (string-equal arg "love")))
                   (vector '("Love") '("LOve") '("LOVe") '("LOVE"))
                   :key #'car :count 2 :from-end t)
        #(("Love") ("LOve")))
(equalp (remove-if-not #'(lambda (arg) (not (string-equal arg "love")))
                   (vector '("Love") '("LOve") '("LOVe") '("LOVE"))
                   :key #'car :count 2 :from-end t)
        #(("Love") ("LOve")))
(equalp (remove-if-not #'(lambda (arg) (not (string-equal arg "love")))
                   (vector '("Love") '("LOve") '("LOVe") '("LOVE"))
                   :key #'car :start 1 :end 3)
        #(("Love") ("LOVE")))
(equalp (remove-if-not #'(lambda (arg) (not (string-equal arg "love")))
                   (vector '("Love") '("LOve") '("LOVe") '("LOVE"))
                   :key #'car :count 1 :start 1 :end 3)
        #(("Love") ("LOVe") ("LOVE")))
(equalp (remove-if-not #'(lambda (arg) (not (string-equal arg "love")))
                   (vector '("Love") '("LOve") '("LOVe") '("LOVE"))
                   :key #'car :count 1 :from-end t
                   :start 1 :end 3)
        #(("Love") ("LOve") ("LOVE")))
(equalp (remove-if-not #'(lambda (arg) (not (string-equal arg "love")))
                   (vector '("Love") '("LOve") '("LOVe") '("LOVE"))
                   :key #'car :count 10 :from-end t
                   :start 1 :end 3)
        #(("Love") ("LOVE")))

(string= (remove-if-not #'(lambda (arg) (not (string-equal arg #\a)))
                        (copy-seq "abcabc"))
         "bcbc")
(string= (remove-if-not #'(lambda (arg) (not (string-equal arg #\a)))
                        (copy-seq "")) "")
(string= (remove-if-not #'(lambda (arg) (not (string-equal arg #\a)))
                        (copy-seq "xyz"))
         "xyz")
(string= (remove-if-not #'(lambda (arg) (not (string-equal arg #\a)))
                        (copy-seq "ABCABC")
                        :key #'char-downcase) "BCBC")
(string= (remove-if-not #'(lambda (arg) (not (string-equal arg #\a)))
                        (copy-seq "abcabc")
                    :count 1) "bcabc")
(string= (remove-if-not #'(lambda (arg) (not (string-equal arg #\a)))
                        (copy-seq "abcabc")
                    :count 1 :from-end t) "abcbc")
(string= (remove-if-not #'(lambda (arg) (not (string-equal arg #\a)))
                        (copy-seq "abcabc")
                    :count 0) "abcabc")
(string= (remove-if-not #'(lambda (arg) (not (string-equal arg #\a)))
                        (copy-seq "abcabc")
                    :count -10) "abcabc")
(let* ((str0 (copy-seq "abc"))
       (str (remove-if-not #'(lambda (arg) (not (string-equal arg #\a))) str0)))
  (and (not (eq str0 str))
       (string= str0 "abc")
       (string= str "bc")))
(string= (remove-if-not #'(lambda (arg) (not (string-equal arg #\a)))
                        (copy-seq "abcabc")
                    :count 0) "abcabc")
(string= (remove-if-not #'(lambda (arg) (not (string-equal arg #\a)))
                        (copy-seq "abcabc"))
         "bcbc")
(string= (remove-if-not #'(lambda (arg) (not (string-equal arg #\b)))
                        (copy-seq "abcabc"))
         "acac")
(string= (remove-if-not #'(lambda (arg) (not (string-equal arg #\c)))
                        (copy-seq "abcabc"))
         "abab")
(string= (remove-if-not #'(lambda (arg) (not (string-equal arg #\a)))
                        (copy-seq "abcabc")
                    :count 0) "abcabc")
(string= (remove-if-not #'(lambda (arg) (not (string-equal arg #\a)))
                        (copy-seq "abcabc")
                    :count 1) "bcabc")
(string= (remove-if-not #'(lambda (arg) (not (string-equal arg #\a)))
                        (copy-seq "abcabc")
                    :count 1 :from-end t) "abcbc")
(string= (remove-if-not #'(lambda (arg) (not (string-equal arg #\a)))
                        (copy-seq "abcabc")
                    :count 2) "bcbc")
(string= (remove-if-not #'(lambda (arg) (not (string-equal arg #\a)))
                        (copy-seq "abcabc")
                    :count 2 :from-end t) "bcbc")
(string= (remove-if-not #'(lambda (arg) (not (string-equal arg #\a)))
                        (copy-seq "abcabc")
                    :count 3) "bcbc")
(string= (remove-if-not #'(lambda (arg) (not (string-equal arg #\a)))
                        (copy-seq "abcabc")
                    :count 3 :from-end t) "bcbc")
(string= (remove-if-not #'(lambda (arg) (not (string-equal arg #\a)))
                        (copy-seq "abcabc")
                    :count 4) "bcbc")
(string= (remove-if-not #'(lambda (arg) (not (string-equal arg #\a)))
                        (copy-seq "abcabc")
                    :count 4 :from-end t) "bcbc")
(string= (remove-if-not #'(lambda (arg) (not (string-equal arg #\a)))
                        (copy-seq "abcabc")
                    :count -1) "abcabc")
(string= (remove-if-not #'(lambda (arg) (not (string-equal arg #\a)))
                        (copy-seq "abcabc")
                    :count -10) "abcabc")
(string= (remove-if-not #'(lambda (arg) (not (string-equal arg #\a)))
                        (copy-seq "abcabc")
                    :count -100) "abcabc")
(string= (remove-if-not #'(lambda (arg) (not (string-equal arg #\a)))
                    (copy-seq "abcabcabcabc") :start 1) "abcbcbcbc")
(string= (remove-if-not #'(lambda (arg) (not (string-equal arg #\a)))
                    (copy-seq "abcabcabcabc") :start 1 :count 1) "abcbcabcabc")
(string= (remove-if-not #'(lambda (arg) (not (eql arg #\a)))
                        (copy-seq "abcabcabcabc") :start 1 :count 2)
         "abcbcbcabc")
(string= (remove-if-not #'(lambda (arg) (not (eql arg #\a)))
                        (copy-seq "abcabcabcabc") :start 1 :end nil :count 2)
         "abcbcbcabc")
(string= (remove-if-not #'(lambda (arg) (not (eql arg #\a)))
                        (copy-seq "abcabcabcabc") :start 1 :end 8) "abcbcbcabc")
(string= (remove-if-not #'(lambda (arg) (not (eql arg #\a)))
                        (copy-seq "abcabcabcabc") :start 1 :end 8 :count 1)
         "abcbcabcabc")
(string= (remove-if-not #'(lambda (arg) (not (eql arg #\a)))
                        (copy-seq "abcabcabcabc")
                        :start 1 :end 8 :count 1 :from-end t)
         "abcabcbcabc")
(string= (remove-if-not #'(lambda (arg) (not (eql arg #\a)))
                        (copy-seq "abcabcabcabc")
                        :start 1 :end 8 :count 0 :from-end t)
         "abcabcabcabc")
(string= (remove-if-not #'(lambda (arg) (not (eql arg #\a)))
                        (copy-seq "abcabcabcabc")
                        :start 1 :end 8 :count -100 :from-end t)
         "abcabcabcabc")
(string= (remove-if-not #'(lambda (arg) (not (eql arg #\a)))
                        (copy-seq "abcabcabcabc") :start 1 :end 1)
         "abcabcabcabc")
(string= (remove-if-not #'(lambda (arg) (not (eql arg #\a)))
                        (copy-seq "abcabcabcabc")
                        :start 2 :end 2) "abcabcabcabc")
(string= (remove-if-not #'(lambda (arg) (not (eql arg #\a)))
                        (copy-seq "abcabcabcabc")
                        :start 12 :end 12) "abcabcabcabc")
(equal (remove-if-not (complement #'zerop) #*0101) #*11)
(equal (remove-if-not (complement #'zerop) #*01010101 :count 1) #*1010101)
(equal (remove-if-not (complement #'zerop) #*01010101 :count 1 :from-end t)
       #*0101011)
(equal (remove-if-not (complement #'zerop) #*01010101 :start 1) #*01111)
(equal (remove-if-not (complement #'zerop) #*01010101 :start 1 :end nil) #*01111)
(equal (remove-if-not (complement #'zerop) #*01010101 :start 1 :end 6) #*011101)
(equal (remove-if-not (complement #'zerop) #*01010101 :start 1 :end 6 :count 1)
       #*0110101)
(equal (remove-if-not (complement #'zerop) #*01010101
                      :start 1 :end 6 :count 1 :from-end t)
       #*0101101)
(equal (remove-if-not (complement #'oddp) #*01010101
                      :start 1 :end 6 :count 1 :from-end t)
       #*0101001)
(equal (remove-if-not (complement #'evenp)
                      #*01010101 :start 1 :end 6 :count 1 :from-end t)
       #*0101101)
(equal (remove-if-not (complement #'plusp) #*01010101
               :start 1 :end 6 :count 1 :from-end t
               :key #'(lambda (arg) (* arg 10)))
       #*0101001)


(equal (delete 'a (list 'a 'b 'c 'a 'b 'c)) '(b c b c))
(equal (delete 'b (list 'a 'b 'c 'a 'b 'c)) '(a c a c))
(equal (delete 'c (list 'a 'b 'c 'a 'b 'c)) '(a b a b))
(equal (delete 'a (list 'a 'a 'a)) '())
(equal (delete 'z (list 'a 'b 'c)) '(a b c))
(equal (delete 'a '()) '())
(equal (delete 'a (list 'a 'b 'c 'a 'b 'c) :count 0) '(a b c a b c))
(equal (delete 'a (list 'a 'b 'c 'a 'b 'c) :count 1) '(b c a b c))
(equal (delete 'a (list 'a 'b 'c 'a 'b 'c) :count 1 :from-end t) '(a b c b c))
(equal (delete 'a (list 'a 'b 'c 'a 'b 'c) :count 2) '(b c b c))
(equal (delete 'a (list 'a 'b 'c 'a 'b 'c) :count 2 :from-end t) '(b c b c))
(equal (delete 'a (list 'a 'b 'c 'a 'b 'c) :count 3) '(b c b c))
(equal (delete 'a (list 'a 'b 'c 'a 'b 'c) :count 3 :from-end t) '(b c b c))
(equal (delete 'a (list 'a 'b 'c 'a 'b 'c) :count 4) '(b c b c))
(equal (delete 'a (list 'a 'b 'c 'a 'b 'c) :count 4 :from-end t) '(b c b c))
(equal (delete 'a (list 'a 'b 'c 'a 'b 'c) :count -1) '(a b c a b c))
(equal (delete 'a (list 'a 'b 'c 'a 'b 'c) :count -10) '(a b c a b c))
(equal (delete 'a (list 'a 'b 'c 'a 'b 'c) :count -100) '(a b c a b c))
(equal (delete 'a (list 'a 'b 'c 'a 'b 'c 'a 'b 'c 'a 'b 'c) :start 1)
       '(a b c b c b c b c))
(equal (delete 'a (list 'a 'b 'c 'a 'b 'c 'a 'b 'c 'a 'b 'c) :start 1 :count 1)
       '(a b c b c a b c a b c))
(equal (delete 'a (list 'a 'b 'c 'a 'b 'c 'a 'b 'c 'a 'b 'c) :start 1 :count 2)
       '(a b c b c b c a b c))
(equal (delete 'a (list 'a 'b 'c 'a 'b 'c 'a 'b 'c 'a 'b 'c)
               :start 1 :end nil :count 2)
       '(a b c b c b c a b c))
(equal (delete 'a (list 'a 'b 'c 'a 'b 'c 'a 'b 'c 'a 'b 'c) :start 1 :end 8)
       '(a b c b c b c a b c))
(equal (delete 'a (list 'a 'b 'c 'a 'b 'c 'a 'b 'c 'a 'b 'c)
               :start 1 :end 8 :count 1)
       '(a b c b c a b c a b c))
(equal (delete 'a (list 'a 'b 'c 'a 'b 'c 'a 'b 'c 'a 'b 'c)
               :start 1 :end 8 :count 1 :from-end t)
       '(a b c a b c b c a b c))
(equal (delete 'a (list 'a 'b 'c 'a 'b 'c 'a 'b 'c 'a 'b 'c)
               :start 1 :end 8 :count 0 :from-end t)
       '(a b c a b c a b c a b c))
(equal (delete 'a (list 'a 'b 'c 'a 'b 'c 'a 'b 'c 'a 'b 'c)
               :start 1 :end 8 :count -100 :from-end t)
       '(a b c a b c a b c a b c))
(equal (delete 'a (list 'a 'b 'c 'a 'b 'c 'a 'b 'c 'a 'b 'c) :start 1 :end 1)
       '(a b c a b c a b c a b c))
(equal (delete 'a (list 'a 'b 'c 'a 'b 'c 'a 'b 'c 'a 'b 'c) :start 2 :end 2)
       '(a b c a b c a b c a b c))
(equal (delete 'a (list 'a 'b 'c 'a 'b 'c 'a 'b 'c 'a 'b 'c) :start 12 :end 12)
       '(a b c a b c a b c a b c))
(equal (delete 'a (list '(a) '(b) '(c) '(a) '(b) '(c)) :key #'car)
       '((b) (c) (b) (c)))
(equal (delete 'a (list '(a . b) '(b . c) '(c . a)
                        '(a . b) '(b . c) '(c . a))
               :key #'cdr)
       '((a . b) (b . c) (a . b) (b . c)))
(equal (delete "love" (list '("Love") '("LOve") '("LOVe") '("LOVE")) :key #'car)
       '(("Love") ("LOve") ("LOVe") ("LOVE")))
(equal (delete "love" (list '("Love") '("LOve") '("LOVe") '("LOVE"))
               :key #'car :count -10)
       '(("Love") ("LOve") ("LOVe") ("LOVE")))
(equal (delete "love" (list '("Love") '("LOve") '("LOVe") '("LOVE"))
               :key #'car :test #'string-equal)
       '())
(equal (delete "love" (list '("Love") '("LOve") '("LOVe") '("LOVE"))
               :key #'car :test-not (complement #'string-equal))
       '())
(equal (delete "love" (list '("Love") '("LOve") '("LOVe") '("LOVE"))
               :key #'car :test #'string-equal :count 1)
       '(("LOve") ("LOVe") ("LOVE")))
(equal (delete "love" (list '("Love") '("LOve") '("LOVe") '("LOVE"))
               :key #'car :test-not (complement #'string-equal) :count 1)
       '(("LOve") ("LOVe") ("LOVE")))
(equal (delete "love" (list '("Love") '("LOve") '("LOVe") '("LOVE"))
               :key #'car :test #'string-equal :count 1 :from-end t)
       '(("Love") ("LOve") ("LOVe")))
(equal (delete "love" (list '("Love") '("LOve") '("LOVe") '("LOVE"))
               :key #'car :test-not (complement #'string-equal)
               :count 1 :from-end t)
       '(("Love") ("LOve") ("LOVe")))
(equal (delete "love" (list '("Love") '("LOve") '("LOVe") '("LOVE"))
               :key #'car :test #'string-equal :count 2 :from-end t)
       '(("Love") ("LOve")))
(equal (delete "love" (list '("Love") '("LOve") '("LOVe") '("LOVE"))
               :key #'car :test-not (complement #'string-equal)
               :count 2 :from-end t)
       '(("Love") ("LOve")))
(equal (delete "love" (list '("Love") '("LOve") '("LOVe") '("LOVE"))
               :key #'car :test #'string-equal :start 1 :end 3)
       '(("Love") ("LOVE")))
(equal (delete "love" (list '("Love") '("LOve") '("LOVe") '("LOVE"))
               :key #'car :test-not (complement #'string-equal) :start 1 :end 3)
       '(("Love") ("LOVE")))
(equal (delete "love" (list '("Love") '("LOve") '("LOVe") '("LOVE"))
               :key #'car :test #'string-equal :count 1 :start 1 :end 3)
       '(("Love") ("LOVe") ("LOVE")))
(equal (delete "love" (list '("Love") '("LOve") '("LOVe") '("LOVE"))
               :key #'car :test-not (complement #'string-equal)
               :count 1 :start 1 :end 3)
       '(("Love") ("LOVe") ("LOVE")))
(equal (delete "love" (list '("Love") '("LOve") '("LOVe") '("LOVE"))
               :key #'car :test #'string-equal :count 1 :from-end t
               :start 1 :end 3)
       '(("Love") ("LOve") ("LOVE")))
(equal (delete "love" (list '("Love") '("LOve") '("LOVe") '("LOVE"))
               :key #'car :test-not (complement #'string-equal)
               :count 1 :from-end t :start 1 :end 3)
       '(("Love") ("LOve") ("LOVE")))
(equal (delete "love" (list '("Love") '("LOve") '("LOVe") '("LOVE"))
               :key #'car :test #'string-equal :count 10 :from-end t
               :start 1 :end 3)
       '(("Love") ("LOVE")))
(equal (delete "love" (list '("Love") '("LOve") '("LOVe") '("LOVE"))
               :key #'car :test-not (complement #'string-equal)
               :count 10 :from-end t :start 1 :end 3)
       '(("Love") ("LOVE")))


(equalp (delete 'a (vector 'a 'b 'c 'a 'b 'c)) #(b c b c))
(equalp (delete 'b (vector 'a 'b 'c 'a 'b 'c)) #(a c a c))
(equalp (delete 'c (vector 'a 'b 'c 'a 'b 'c)) #(a b a b))
(equalp (delete 'a (vector 'a 'a 'a)) #())
(equalp (delete 'z (vector 'a 'b 'c)) #(a b c))
(equalp (delete 'a #()) #())
(equalp (delete 'a (vector 'a 'b 'c 'a 'b 'c) :count 0) #(a b c a b c))
(equalp (delete 'a (vector 'a 'b 'c 'a 'b 'c) :count 1) #(b c a b c))
(equalp (delete 'a (vector 'a 'b 'c 'a 'b 'c) :count 1 :from-end t) #(a b c b c))
(equalp (delete 'a (vector 'a 'b 'c 'a 'b 'c) :count 2) #(b c b c))
(equalp (delete 'a (vector 'a 'b 'c 'a 'b 'c) :count 2 :from-end t) #(b c b c))
(equalp (delete 'a (vector 'a 'b 'c 'a 'b 'c) :count 3) #(b c b c))
(equalp (delete 'a (vector 'a 'b 'c 'a 'b 'c) :count 3 :from-end t) #(b c b c))
(equalp (delete 'a (vector 'a 'b 'c 'a 'b 'c) :count 4) #(b c b c))
(equalp (delete 'a (vector 'a 'b 'c 'a 'b 'c) :count 4 :from-end t) #(b c b c))
(equalp (delete 'a (vector 'a 'b 'c 'a 'b 'c) :count -1) #(a b c a b c))
(equalp (delete 'a (vector 'a 'b 'c 'a 'b 'c) :count -10) #(a b c a b c))
(equalp (delete 'a (vector 'a 'b 'c 'a 'b 'c) :count -100) #(a b c a b c))
(equalp (delete 'a (vector 'a 'b 'c 'a 'b 'c 'a 'b 'c 'a 'b 'c) :start 1)
        #(a b c b c b c b c))
(equalp (delete 'a (vector 'a 'b 'c 'a 'b 'c 'a 'b 'c 'a 'b 'c)
                :start 1 :count 1)
       #(a b c b c a b c a b c))
(equalp (delete 'a (vector 'a 'b 'c 'a 'b 'c 'a 'b 'c 'a 'b 'c)
                :start 1 :count 2)
       #(a b c b c b c a b c))
(equalp (delete 'a (vector 'a 'b 'c 'a 'b 'c 'a 'b 'c 'a 'b 'c)
               :start 1 :end nil :count 2)
       #(a b c b c b c a b c))
(equalp (delete 'a (vector 'a 'b 'c 'a 'b 'c 'a 'b 'c 'a 'b 'c) :start 1 :end 8)
        #(a b c b c b c a b c))
(equalp (delete 'a (vector 'a 'b 'c 'a 'b 'c 'a 'b 'c 'a 'b 'c)
               :start 1 :end 8 :count 1)
        #(a b c b c a b c a b c))
(equalp (delete 'a (vector 'a 'b 'c 'a 'b 'c 'a 'b 'c 'a 'b 'c)
               :start 1 :end 8 :count 1 :from-end t)
        #(a b c a b c b c a b c))
(equalp (delete 'a (vector 'a 'b 'c 'a 'b 'c 'a 'b 'c 'a 'b 'c)
               :start 1 :end 8 :count 0 :from-end t)
        #(a b c a b c a b c a b c))
(equalp (delete 'a (vector 'a 'b 'c 'a 'b 'c 'a 'b 'c 'a 'b 'c)
               :start 1 :end 8 :count -100 :from-end t)
        #(a b c a b c a b c a b c))
(equalp (delete 'a (vector 'a 'b 'c 'a 'b 'c 'a 'b 'c 'a 'b 'c) :start 1 :end 1)
        #(a b c a b c a b c a b c))
(equalp (delete 'a (vector 'a 'b 'c 'a 'b 'c 'a 'b 'c 'a 'b 'c) :start 2 :end 2)
        #(a b c a b c a b c a b c))
(equalp (delete 'a (vector 'a 'b 'c 'a 'b 'c 'a 'b 'c 'a 'b 'c)
                :start 12 :end 12)
        #(a b c a b c a b c a b c))
(equalp (delete 'a (vector '(a) '(b) '(c) '(a) '(b) '(c)) :key #'car)
        #((b) (c) (b) (c)))
(equalp (delete 'a (vector '(a . b) '(b . c) '(c . a)
                           '(a . b) '(b . c) '(c . a))
               :key #'cdr)
        #((a . b) (b . c) (a . b) (b . c)))
(equalp (delete "love" (vector '("Love") '("LOve") '("LOVe") '("LOVE"))
                :key #'car)
        #(("Love") ("LOve") ("LOVe") ("LOVE")))
(equalp (delete "love" (vector '("Love") '("LOve") '("LOVe") '("LOVE"))
                :key #'car :count -10)
        #(("Love") ("LOve") ("LOVe") ("LOVE")))
(equalp (delete "love" (vector '("Love") '("LOve") '("LOVe") '("LOVE"))
                :key #'car :test #'string-equal)
        #())
(equalp (delete "love" (vector '("Love") '("LOve") '("LOVe") '("LOVE"))
                :key #'car :test-not (complement #'string-equal))
        #())
(equalp (delete "love" (vector '("Love") '("LOve") '("LOVe") '("LOVE"))
                :key #'car :test #'string-equal :count 1)
        #(("LOve") ("LOVe") ("LOVE")))
(equalp (delete "love" (vector '("Love") '("LOve") '("LOVe") '("LOVE"))
                :key #'car :test-not (complement #'string-equal) :count 1)
        #(("LOve") ("LOVe") ("LOVE")))
(equalp (delete "love" (vector '("Love") '("LOve") '("LOVe") '("LOVE"))
                :key #'car :test #'string-equal :count 1 :from-end t)
        #(("Love") ("LOve") ("LOVe")))
(equalp (delete "love" (vector '("Love") '("LOve") '("LOVe") '("LOVE"))
                :key #'car :test-not (complement #'string-equal)
                :count 1 :from-end t)
        #(("Love") ("LOve") ("LOVe")))
(equalp (delete "love" (vector '("Love") '("LOve") '("LOVe") '("LOVE"))
                :key #'car :test #'string-equal :count 2 :from-end t)
        #(("Love") ("LOve")))
(equalp (delete "love" (vector '("Love") '("LOve") '("LOVe") '("LOVE"))
                :key #'car :test-not (complement #'string-equal)
                :count 2 :from-end t)
        #(("Love") ("LOve")))
(equalp (delete "love" (vector '("Love") '("LOve") '("LOVe") '("LOVE"))
                :key #'car :test #'string-equal :start 1 :end 3)
        #(("Love") ("LOVE")))
(equalp (delete "love" (vector '("Love") '("LOve") '("LOVe") '("LOVE"))
                :key #'car :test-not (complement #'string-equal) :start 1 :end 3)
        #(("Love") ("LOVE")))
(equalp (delete "love" (vector '("Love") '("LOve") '("LOVe") '("LOVE"))
                :key #'car :test #'string-equal :count 1 :start 1 :end 3)
        #(("Love") ("LOVe") ("LOVE")))
(equalp (delete "love" (vector '("Love") '("LOve") '("LOVe") '("LOVE"))
                :key #'car :test-not (complement #'string-equal)
                :count 1 :start 1 :end 3)
        #(("Love") ("LOVe") ("LOVE")))
(equalp (delete "love" (vector '("Love") '("LOve") '("LOVe") '("LOVE"))
                :key #'car :test #'string-equal :count 1 :from-end t
                :start 1 :end 3)
        #(("Love") ("LOve") ("LOVE")))
(equalp (delete "love" (vector '("Love") '("LOve") '("LOVe") '("LOVE"))
                :key #'car :test-not (complement #'string-equal)
                :count 1 :from-end t :start 1 :end 3)
        #(("Love") ("LOve") ("LOVE")))
(equalp (delete "love" (vector '("Love") '("LOve") '("LOVe") '("LOVE"))
                :key #'car :test #'string-equal :count 10 :from-end t
                :start 1 :end 3)
        #(("Love") ("LOVE")))
(equalp (delete "love" (vector '("Love") '("LOve") '("LOVe") '("LOVE"))
                :key #'car :test-not (complement #'string-equal)
                :count 10 :from-end t :start 1 :end 3)
        #(("Love") ("LOVE")))

(string= (delete #\a (copy-seq "abcabc")) "bcbc")
(string= (delete #\a (copy-seq "")) "")
(string= (delete #\a (copy-seq "xyz")) "xyz")
(string= (delete #\a (copy-seq "ABCABC")) "ABCABC")
(string= (delete #\a (copy-seq "ABCABC") :key #'char-downcase) "BCBC")
(string= (delete #\a (copy-seq "abcabc") :count 1) "bcabc")
(string= (delete #\a (copy-seq "abcabc") :count 1 :from-end t) "abcbc")
(string= (delete #\a (copy-seq "abcabc") :count 0) "abcabc")
(string= (delete #\a (copy-seq "abcabc") :count -10) "abcabc")
(string= (delete #\a (copy-seq "abcabc") :count 0) "abcabc")
(string= (delete #\a (copy-seq "abcabc")) "bcbc")
(string= (delete #\b (copy-seq "abcabc")) "acac")
(string= (delete #\c (copy-seq "abcabc")) "abab")
(string= (delete #\a (copy-seq "abcabc") :count 0) "abcabc")
(string= (delete #\a (copy-seq "abcabc") :count 1) "bcabc")
(string= (delete #\a (copy-seq "abcabc") :count 1 :from-end t) "abcbc")
(string= (delete #\a (copy-seq "abcabc") :count 2) "bcbc")
(string= (delete #\a (copy-seq "abcabc") :count 2 :from-end t) "bcbc")
(string= (delete #\a (copy-seq "abcabc") :count 3) "bcbc")
(string= (delete #\a (copy-seq "abcabc") :count 3 :from-end t) "bcbc")
(string= (delete #\a (copy-seq "abcabc") :count 4) "bcbc")
(string= (delete #\a (copy-seq "abcabc") :count 4 :from-end t) "bcbc")
(string= (delete #\a (copy-seq "abcabc") :count -1) "abcabc")
(string= (delete #\a (copy-seq "abcabc") :count -10) "abcabc")
(string= (delete #\a (copy-seq "abcabc") :count -100) "abcabc")
(string= (delete #\a (copy-seq "abcabcabcabc") :start 1) "abcbcbcbc")
(string= (delete #\a (copy-seq "abcabcabcabc") :start 1 :count 1) "abcbcabcabc")
(string= (delete #\a (copy-seq "abcabcabcabc") :start 1 :count 2) "abcbcbcabc")
(string= (delete #\a (copy-seq "abcabcabcabc") :start 1 :end nil :count 2)
         "abcbcbcabc")
(string= (delete #\a (copy-seq "abcabcabcabc") :start 1 :end 8) "abcbcbcabc")
(string= (delete #\a (copy-seq "abcabcabcabc") :start 1 :end 8 :count 1)
         "abcbcabcabc")
(string= (delete #\a (copy-seq "abcabcabcabc")
                 :start 1 :end 8 :count 1 :from-end t)
         "abcabcbcabc")
(string= (delete #\a (copy-seq "abcabcabcabc")
                 :start 1 :end 8 :count 0 :from-end t)
         "abcabcabcabc")
(string= (delete #\a (copy-seq "abcabcabcabc")
                 :start 1 :end 8 :count -100 :from-end t)
         "abcabcabcabc")
(string= (delete #\a (copy-seq "abcabcabcabc") :start 1 :end 1)
         "abcabcabcabc")
(string= (delete #\a (copy-seq "abcabcabcabc") :start 2 :end 2) "abcabcabcabc")
(string= (delete #\a (copy-seq "abcabcabcabc") :start 12 :end 12) "abcabcabcabc")
(equal (delete 0 #*0101) #*11)
(equal (delete 0 #*01010101 :count 1) #*1010101)
(equal (delete 0 #*01010101 :count 1 :from-end t) #*0101011)
(equal (delete 0 #*01010101 :start 1) #*01111)
(equal (delete 0 #*01010101 :start 1 :end nil) #*01111)
(equal (delete 0 #*01010101 :start 1 :end 6) #*011101)
(equal (delete 0 #*01010101 :start 1 :end 6 :count 1) #*0110101)
(equal (delete 0 #*01010101 :start 1 :end 6 :count 1 :from-end t) #*0101101)
(equal (delete 0 #*01010101
               :start 1 :end 6 :count 1 :from-end t
               :test #'(lambda (a b) (declare (ignore a)) (oddp b)))
       #*0101001)
(equal (delete 0 #*01010101
               :start 1 :end 6 :count 1 :from-end t
               :test-not #'(lambda (a b) (declare (ignore a)) (evenp b)))
       #*0101001)
(equal (delete 0 #*01010101
               :start 1 :end 6 :count 1 :from-end t
               :test #'(lambda (a b) (declare (ignore a)) (evenp b)))
       #*0101101)
(equal (delete 0 #*01010101
               :start 1 :end 6 :count 1 :from-end t
               :test-not #'(lambda (a b) (declare (ignore a)) (oddp b)))
       #*0101101)
(equal (delete 0 #*01010101
               :start 1 :end 6 :count 1 :from-end t
               :key #'(lambda (arg) (* arg 10))
               :test #'(lambda (a b) (declare (ignore a)) (> b 1)))
       #*0101001)


(equal (delete-if #'(lambda (arg) (eql arg 'a)) (list 'a 'b 'c 'a 'b 'c))
       '(b c b c))
(equal (delete-if #'(lambda (arg) (eql arg 'b)) (list 'a 'b 'c 'a 'b 'c))
       '(a c a c))
(equal (delete-if #'(lambda (arg) (eql arg 'c)) (list 'a 'b 'c 'a 'b 'c))
       '(a b a b))
(equal (delete-if #'(lambda (arg) (eql arg 'a)) (list 'a 'a 'a)) '())
(equal (delete-if #'(lambda (arg) (eql arg 'z)) (list 'a 'b 'c)) '(a b c))
(equal (delete-if #'(lambda (arg) (eql arg 'a)) '()) '())
(equal (delete-if #'(lambda (arg) (eql arg 'a)) (list 'a 'b 'c 'a 'b 'c)
                  :count 0) '(a b c a b c))
(equal (delete-if #'(lambda (arg) (eql arg 'a)) (list 'a 'b 'c 'a 'b 'c)
                  :count 1) '(b c a b c))
(equal (delete-if #'(lambda (arg) (eql arg 'a)) (list 'a 'b 'c 'a 'b 'c)
                  :count 1 :from-end t) '(a b c b c))
(equal (delete-if #'(lambda (arg) (eql arg 'a)) (list 'a 'b 'c 'a 'b 'c)
                  :count 2) '(b c b c))
(equal (delete-if #'(lambda (arg) (eql arg 'a)) (list 'a 'b 'c 'a 'b 'c)
                  :count 2 :from-end t) '(b c b c))
(equal (delete-if #'(lambda (arg) (eql arg 'a)) (list 'a 'b 'c 'a 'b 'c)
                  :count 3) '(b c b c))
(equal (delete-if #'(lambda (arg) (eql arg 'a)) (list 'a 'b 'c 'a 'b 'c)
                  :count 3 :from-end t) '(b c b c))
(equal (delete-if #'(lambda (arg) (eql arg 'a)) (list 'a 'b 'c 'a 'b 'c)
                  :count 4) '(b c b c))
(equal (delete-if #'(lambda (arg) (eql arg 'a)) (list 'a 'b 'c 'a 'b 'c)
                  :count 4 :from-end t) '(b c b c))
(equal (delete-if #'(lambda (arg) (eql arg 'a)) (list 'a 'b 'c 'a 'b 'c)
                  :count -1) '(a b c a b c))
(equal (delete-if #'(lambda (arg) (eql arg 'a)) (list 'a 'b 'c 'a 'b 'c)
                  :count -10) '(a b c a b c))
(equal (delete-if #'(lambda (arg) (eql arg 'a)) (list 'a 'b 'c 'a 'b 'c)
                  :count -100) '(a b c a b c))
(equal (delete-if #'(lambda (arg) (eql arg 'a))
                  (list 'a 'b 'c 'a 'b 'c 'a 'b 'c 'a 'b 'c) :start 1)
       '(a b c b c b c b c))
(equal (delete-if #'(lambda (arg) (eql arg 'a))
                  (list 'a 'b 'c 'a 'b 'c 'a 'b 'c 'a 'b 'c) :start 1 :count 1)
       '(a b c b c a b c a b c))
(equal (delete-if #'(lambda (arg) (eql arg 'a))
                  (list 'a 'b 'c 'a 'b 'c 'a 'b 'c 'a 'b 'c) :start 1 :count 2)
       '(a b c b c b c a b c))
(equal (delete-if #'(lambda (arg) (eql arg 'a))
                  (list 'a 'b 'c 'a 'b 'c 'a 'b 'c 'a 'b 'c)
                  :start 1 :end nil :count 2)
       '(a b c b c b c a b c))
(equal (delete-if #'(lambda (arg) (eql arg 'a))
                  (list 'a 'b 'c 'a 'b 'c 'a 'b 'c 'a 'b 'c) :start 1 :end 8)
       '(a b c b c b c a b c))
(equal (delete-if #'(lambda (arg) (eql arg 'a))
                  (list 'a 'b 'c 'a 'b 'c 'a 'b 'c 'a 'b 'c)
                  :start 1 :end 8 :count 1)
       '(a b c b c a b c a b c))
(equal (delete-if #'(lambda (arg) (eql arg 'a))
                  (list 'a 'b 'c 'a 'b 'c 'a 'b 'c 'a 'b 'c)
                  :start 1 :end 8 :count 1 :from-end t)
       '(a b c a b c b c a b c))
(equal (delete-if #'(lambda (arg) (eql arg 'a))
                  (list 'a 'b 'c 'a 'b 'c 'a 'b 'c 'a 'b 'c)
                  :start 1 :end 8 :count 0 :from-end t)
       '(a b c a b c a b c a b c))
(equal (delete-if #'(lambda (arg) (eql arg 'a))
                  (list 'a 'b 'c 'a 'b 'c 'a 'b 'c 'a 'b 'c)
                  :start 1 :end 8 :count -100 :from-end t)
       '(a b c a b c a b c a b c))
(equal (delete-if #'(lambda (arg) (eql arg 'a))
                  (list 'a 'b 'c 'a 'b 'c 'a 'b 'c 'a 'b 'c) :start 1 :end 1)
       '(a b c a b c a b c a b c))
(equal (delete-if #'(lambda (arg) (eql arg 'a))
                  (list 'a 'b 'c 'a 'b 'c 'a 'b 'c 'a 'b 'c) :start 2 :end 2)
       '(a b c a b c a b c a b c))
(equal (delete-if #'(lambda (arg) (eql arg 'a))
                  (list 'a 'b 'c 'a 'b 'c 'a 'b 'c 'a 'b 'c)
                  :start 12 :end 12)
       '(a b c a b c a b c a b c))
(equal (delete-if #'(lambda (arg) (eql arg 'a))
                  (list '(a) '(b) '(c) '(a) '(b) '(c)) :key #'car)
       '((b) (c) (b) (c)))
(equal (delete-if #'(lambda (arg) (eql arg 'a))
                  (list '(a . b) '(b . c) '(c . a)
                        '(a . b) '(b . c) '(c . a))
                  :key #'cdr)
       '((a . b) (b . c) (a . b) (b . c)))
(equal (delete-if #'(lambda (arg) (eql arg "love"))
                  (list '("Love") '("LOve") '("LOVe") '("LOVE"))
                  :key #'car)
       '(("Love") ("LOve") ("LOVe") ("LOVE")))
(equal (delete-if #'(lambda (arg) (eql arg "love"))
                  (list '("Love") '("LOve") '("LOVe") '("LOVE"))
                  :key #'car :count -10)
       '(("Love") ("LOve") ("LOVe") ("LOVE")))
(equal (delete-if #'(lambda (arg) (string-equal arg "love"))
                      (list '("Love") '("LOve") '("LOVe") '("LOVE"))
                      :key #'car)
       '())
(equal (delete-if #'(lambda (arg) (string-equal arg "love"))
                  (list '("Love") '("LOve") '("LOVe") '("LOVE"))
                  :key #'car :count 1)
       '(("LOve") ("LOVe") ("LOVE")))
(equal (delete-if #'(lambda (arg) (string-equal arg "love"))
                  (list '("Love") '("LOve") '("LOVe") '("LOVE"))
                  :key #'car :count 1 :from-end t)
       '(("Love") ("LOve") ("LOVe")))
(equal (delete-if #'(lambda (arg) (string-equal arg "love"))
                  (list '("Love") '("LOve") '("LOVe") '("LOVE"))
                  :key #'car :count 2 :from-end t)
       '(("Love") ("LOve")))
(equal (delete-if #'(lambda (arg) (string-equal arg "love"))
                  (list '("Love") '("LOve") '("LOVe") '("LOVE"))
                  :key #'car :start 1 :end 3)
       '(("Love") ("LOVE")))
(equal (delete-if #'(lambda (arg) (string-equal arg "love"))
                  (list '("Love") '("LOve") '("LOVe") '("LOVE"))
                  :key #'car :count 1 :start 1 :end 3)
       '(("Love") ("LOVe") ("LOVE")))
(equal (delete-if #'(lambda (arg) (string-equal arg "love"))
                  (list '("Love") '("LOve") '("LOVe") '("LOVE"))
                  :key #'car :count 1 :from-end t
                  :start 1 :end 3)
       '(("Love") ("LOve") ("LOVE")))
(equal (delete-if #'(lambda (arg) (string-equal arg "love"))
                  (list '("Love") '("LOve") '("LOVe") '("LOVE"))
                  :key #'car :count 10 :from-end t :start 1 :end 3)
       '(("Love") ("LOVE")))


(equalp (delete-if #'(lambda (arg) (eql arg 'a))
                   (vector 'a 'b 'c 'a 'b 'c)) #(b c b c))
(equalp (delete-if #'(lambda (arg) (eql arg 'b))
                   (vector 'a 'b 'c 'a 'b 'c)) #(a c a c))
(equalp (delete-if #'(lambda (arg) (eql arg 'c))
                   (vector 'a 'b 'c 'a 'b 'c)) #(a b a b))
(equalp (delete-if #'(lambda (arg) (eql arg 'a))
                   (vector 'a 'a 'a)) #())
(equalp (delete-if #'(lambda (arg) (eql arg 'z))
                   (vector 'a 'b 'c)) #(a b c))
(equalp (delete-if #'(lambda (arg) (eql arg 'a)) #()) #())
(equalp (delete-if #'(lambda (arg) (eql arg 'a))
                   (vector 'a 'b 'c 'a 'b 'c) :count 0) #(a b c a b c))
(equalp (delete-if #'(lambda (arg) (eql arg 'a))
                   (vector 'a 'b 'c 'a 'b 'c) :count 1) #(b c a b c))
(equalp (delete-if #'(lambda (arg) (eql arg 'a))
                   (vector 'a 'b 'c 'a 'b 'c) :count 1 :from-end t) #(a b c b c))
(equalp (delete-if #'(lambda (arg) (eql arg 'a))
                   (vector 'a 'b 'c 'a 'b 'c) :count 2) #(b c b c))
(equalp (delete-if #'(lambda (arg) (eql arg 'a))
                   (vector 'a 'b 'c 'a 'b 'c) :count 2 :from-end t) #(b c b c))
(equalp (delete-if #'(lambda (arg) (eql arg 'a))
                   (vector 'a 'b 'c 'a 'b 'c) :count 3) #(b c b c))
(equalp (delete-if #'(lambda (arg) (eql arg 'a))
                   (vector 'a 'b 'c 'a 'b 'c) :count 3 :from-end t) #(b c b c))
(equalp (delete-if #'(lambda (arg) (eql arg 'a))
                   (vector 'a 'b 'c 'a 'b 'c) :count 4) #(b c b c))
(equalp (delete-if #'(lambda (arg) (eql arg 'a))
                   (vector 'a 'b 'c 'a 'b 'c) :count 4 :from-end t) #(b c b c))
(equalp (delete-if #'(lambda (arg) (eql arg 'a))
                   (vector 'a 'b 'c 'a 'b 'c) :count -1) #(a b c a b c))
(equalp (delete-if #'(lambda (arg) (eql arg 'a))
                   (vector 'a 'b 'c 'a 'b 'c) :count -10) #(a b c a b c))
(equalp (delete-if #'(lambda (arg) (eql arg 'a))
                   (vector 'a 'b 'c 'a 'b 'c) :count -100) #(a b c a b c))
(equalp (delete-if #'(lambda (arg) (eql arg 'a))
                   (vector 'a 'b 'c 'a 'b 'c 'a 'b 'c 'a 'b 'c) :start 1)
        #(a b c b c b c b c))
(equalp (delete-if #'(lambda (arg) (eql arg 'a))
                   (vector 'a 'b 'c 'a 'b 'c 'a 'b 'c 'a 'b 'c)
                   :start 1 :count 1)
       #(a b c b c a b c a b c))
(equalp (delete-if #'(lambda (arg) (eql arg 'a))
                   (vector 'a 'b 'c 'a 'b 'c 'a 'b 'c 'a 'b 'c)
                   :start 1 :count 2)
        #(a b c b c b c a b c))
(equalp (delete-if #'(lambda (arg) (eql arg 'a))
                   (vector 'a 'b 'c 'a 'b 'c 'a 'b 'c 'a 'b 'c)
                   :start 1 :end nil :count 2)
        #(a b c b c b c a b c))
(equalp (delete-if #'(lambda (arg) (eql arg 'a))
                   (vector 'a 'b 'c 'a 'b 'c 'a 'b 'c 'a 'b 'c) :start 1 :end 8)
        #(a b c b c b c a b c))
(equalp (delete-if #'(lambda (arg) (eql arg 'a))
                   (vector 'a 'b 'c 'a 'b 'c 'a 'b 'c 'a 'b 'c)
                   :start 1 :end 8 :count 1)
        #(a b c b c a b c a b c))
(equalp (delete-if #'(lambda (arg) (eql arg 'a))
                   (vector 'a 'b 'c 'a 'b 'c 'a 'b 'c 'a 'b 'c)
                   :start 1 :end 8 :count 1 :from-end t)
        #(a b c a b c b c a b c))
(equalp (delete-if #'(lambda (arg) (eql arg 'a))
                   (vector 'a 'b 'c 'a 'b 'c 'a 'b 'c 'a 'b 'c)
                   :start 1 :end 8 :count 0 :from-end t)
        #(a b c a b c a b c a b c))
(equalp (delete-if #'(lambda (arg) (eql arg 'a))
                   (vector 'a 'b 'c 'a 'b 'c 'a 'b 'c 'a 'b 'c)
                   :start 1 :end 8 :count -100 :from-end t)
        #(a b c a b c a b c a b c))
(equalp (delete-if #'(lambda (arg) (eql arg 'a))
                   (vector 'a 'b 'c 'a 'b 'c 'a 'b 'c 'a 'b 'c) :start 1 :end 1)
        #(a b c a b c a b c a b c))
(equalp (delete-if #'(lambda (arg) (eql arg 'a))
                   (vector 'a 'b 'c 'a 'b 'c 'a 'b 'c 'a 'b 'c) :start 2 :end 2)
        #(a b c a b c a b c a b c))
(equalp (delete-if #'(lambda (arg) (eql arg 'a))
                   (vector 'a 'b 'c 'a 'b 'c 'a 'b 'c 'a 'b 'c)
                   :start 12 :end 12)
        #(a b c a b c a b c a b c))
(equalp (delete-if #'(lambda (arg) (eql arg 'a))
                   (vector '(a) '(b) '(c) '(a) '(b) '(c)) :key #'car)
        #((b) (c) (b) (c)))
(equalp (delete-if #'(lambda (arg) (eql arg 'a))
                   (vector '(a . b) '(b . c) '(c . a)
                           '(a . b) '(b . c) '(c . a))
               :key #'cdr)
        #((a . b) (b . c) (a . b) (b . c)))
(equalp (delete-if #'(lambda (arg) (eql arg "love"))
                   (vector '("Love") '("LOve") '("LOVe") '("LOVE"))
                   :key #'car)
        #(("Love") ("LOve") ("LOVe") ("LOVE")))
(equalp (delete-if #'(lambda (arg) (eql arg "love"))
                   (vector '("Love") '("LOve") '("LOVe") '("LOVE"))
                   :key #'car :count -10)
        #(("Love") ("LOve") ("LOVe") ("LOVE")))
(equalp (delete-if #'(lambda (arg) (string-equal arg "love"))
                   (vector '("Love") '("LOve") '("LOVe") '("LOVE"))
                   :key #'car)
        #())
(equalp (delete-if #'(lambda (arg) (string-equal arg "love"))
                   (vector '("Love") '("LOve") '("LOVe") '("LOVE"))
                   :key #'car)
        #())
(equalp (delete-if #'(lambda (arg) (string-equal arg "love"))
                   (vector '("Love") '("LOve") '("LOVe") '("LOVE"))
                   :key #'car :count 1)
        #(("LOve") ("LOVe") ("LOVE")))
(equalp (delete-if #'(lambda (arg) (string-equal arg "love"))
                   (vector '("Love") '("LOve") '("LOVe") '("LOVE"))
                   :key #'car :count 1)
        #(("LOve") ("LOVe") ("LOVE")))
(equalp (delete-if #'(lambda (arg) (string-equal arg "love"))
                   (vector '("Love") '("LOve") '("LOVe") '("LOVE"))
                   :key #'car :count 1 :from-end t)
        #(("Love") ("LOve") ("LOVe")))
(equalp (delete-if #'(lambda (arg) (string-equal arg "love"))
                   (vector '("Love") '("LOve") '("LOVe") '("LOVE"))
                   :key #'car :count 1 :from-end t)
        #(("Love") ("LOve") ("LOVe")))
(equalp (delete-if #'(lambda (arg) (string-equal arg "love"))
                   (vector '("Love") '("LOve") '("LOVe") '("LOVE"))
                   :key #'car :count 2 :from-end t)
        #(("Love") ("LOve")))
(equalp (delete-if #'(lambda (arg) (string-equal arg "love"))
                   (vector '("Love") '("LOve") '("LOVe") '("LOVE"))
                   :key #'car :count 2 :from-end t)
        #(("Love") ("LOve")))
(equalp (delete-if #'(lambda (arg) (string-equal arg "love"))
                   (vector '("Love") '("LOve") '("LOVe") '("LOVE"))
                   :key #'car :start 1 :end 3)
        #(("Love") ("LOVE")))
(equalp (delete-if #'(lambda (arg) (string-equal arg "love"))
                   (vector '("Love") '("LOve") '("LOVe") '("LOVE"))
                   :key #'car :count 1 :start 1 :end 3)
        #(("Love") ("LOVe") ("LOVE")))
(equalp (delete-if #'(lambda (arg) (string-equal arg "love"))
                   (vector '("Love") '("LOve") '("LOVe") '("LOVE"))
                   :key #'car :count 1 :from-end t
                   :start 1 :end 3)
        #(("Love") ("LOve") ("LOVE")))
(equalp (delete-if #'(lambda (arg) (string-equal arg "love"))
                   (vector '("Love") '("LOve") '("LOVe") '("LOVE"))
                   :key #'car :count 10 :from-end t
                   :start 1 :end 3)
        #(("Love") ("LOVE")))

(string= (delete-if #'(lambda (arg) (string-equal arg #\a)) (copy-seq "abcabc"))
         "bcbc")
(string= (delete-if #'(lambda (arg) (string-equal arg #\a)) (copy-seq "")) "")
(string= (delete-if #'(lambda (arg) (string-equal arg #\a)) (copy-seq "xyz"))
         "xyz")
(string= (delete-if #'(lambda (arg) (string-equal arg #\a)) (copy-seq "ABCABC")
                    :key #'char-downcase) "BCBC")
(string= (delete-if #'(lambda (arg) (string-equal arg #\a)) (copy-seq "abcabc")
                    :count 1) "bcabc")
(string= (delete-if #'(lambda (arg) (string-equal arg #\a)) (copy-seq "abcabc")
                    :count 1 :from-end t) "abcbc")
(string= (delete-if #'(lambda (arg) (string-equal arg #\a)) (copy-seq "abcabc")
                    :count 0) "abcabc")
(string= (delete-if #'(lambda (arg) (string-equal arg #\a)) (copy-seq "abcabc")
                    :count -10) "abcabc")
(string= (delete-if #'(lambda (arg) (string-equal arg #\a)) (copy-seq "abcabc")
                    :count 0) "abcabc")
(string= (delete-if #'(lambda (arg) (string-equal arg #\a)) (copy-seq "abcabc"))
         "bcbc")
(string= (delete-if #'(lambda (arg) (string-equal arg #\b)) (copy-seq "abcabc"))
         "acac")
(string= (delete-if #'(lambda (arg) (string-equal arg #\c)) (copy-seq "abcabc"))
         "abab")
(string= (delete-if #'(lambda (arg) (string-equal arg #\a)) (copy-seq "abcabc")
                    :count 0) "abcabc")
(string= (delete-if #'(lambda (arg) (string-equal arg #\a)) (copy-seq "abcabc")
                    :count 1) "bcabc")
(string= (delete-if #'(lambda (arg) (string-equal arg #\a)) (copy-seq "abcabc")
                    :count 1 :from-end t) "abcbc")
(string= (delete-if #'(lambda (arg) (string-equal arg #\a)) (copy-seq "abcabc")
                    :count 2) "bcbc")
(string= (delete-if #'(lambda (arg) (string-equal arg #\a)) (copy-seq "abcabc")
                    :count 2 :from-end t) "bcbc")
(string= (delete-if #'(lambda (arg) (string-equal arg #\a)) (copy-seq "abcabc")
                    :count 3) "bcbc")
(string= (delete-if #'(lambda (arg) (string-equal arg #\a)) (copy-seq "abcabc")
                    :count 3 :from-end t) "bcbc")
(string= (delete-if #'(lambda (arg) (string-equal arg #\a)) (copy-seq "abcabc")
                    :count 4) "bcbc")
(string= (delete-if #'(lambda (arg) (string-equal arg #\a)) (copy-seq "abcabc")
                    :count 4 :from-end t) "bcbc")
(string= (delete-if #'(lambda (arg) (string-equal arg #\a)) (copy-seq "abcabc")
                    :count -1) "abcabc")
(string= (delete-if #'(lambda (arg) (string-equal arg #\a)) (copy-seq "abcabc")
                    :count -10) "abcabc")
(string= (delete-if #'(lambda (arg) (string-equal arg #\a)) (copy-seq "abcabc")
                    :count -100) "abcabc")
(string= (delete-if #'(lambda (arg) (string-equal arg #\a))
                    (copy-seq "abcabcabcabc") :start 1) "abcbcbcbc")
(string= (delete-if #'(lambda (arg) (string-equal arg #\a))
                    (copy-seq "abcabcabcabc") :start 1 :count 1) "abcbcabcabc")
(string= (delete-if #'(lambda (arg) (eql arg #\a)) (copy-seq "abcabcabcabc")
                    :start 1 :count 2)
         "abcbcbcabc")
(string= (delete-if #'(lambda (arg) (eql arg #\a)) (copy-seq "abcabcabcabc")
                    :start 1 :end nil :count 2)
         "abcbcbcabc")
(string= (delete-if #'(lambda (arg) (eql arg #\a)) (copy-seq "abcabcabcabc")
                    :start 1 :end 8) "abcbcbcabc")
(string= (delete-if #'(lambda (arg) (eql arg #\a)) (copy-seq "abcabcabcabc")
                    :start 1 :end 8 :count 1)
         "abcbcabcabc")
(string= (delete-if #'(lambda (arg) (eql arg #\a)) (copy-seq "abcabcabcabc")
                 :start 1 :end 8 :count 1 :from-end t)
         "abcabcbcabc")
(string= (delete-if #'(lambda (arg) (eql arg #\a)) (copy-seq "abcabcabcabc")
                 :start 1 :end 8 :count 0 :from-end t)
         "abcabcabcabc")
(string= (delete-if #'(lambda (arg) (eql arg #\a)) (copy-seq "abcabcabcabc")
                 :start 1 :end 8 :count -100 :from-end t)
         "abcabcabcabc")
(string= (delete-if #'(lambda (arg) (eql arg #\a)) (copy-seq "abcabcabcabc")
                    :start 1 :end 1)
         "abcabcabcabc")
(string= (delete-if #'(lambda (arg) (eql arg #\a)) (copy-seq "abcabcabcabc")
                    :start 2 :end 2) "abcabcabcabc")
(string= (delete-if #'(lambda (arg) (eql arg #\a)) (copy-seq "abcabcabcabc")
                    :start 12 :end 12) "abcabcabcabc")
(equal (delete-if #'zerop #*0101) #*11)
(equal (delete-if #'zerop #*01010101 :count 1) #*1010101)
(equal (delete-if #'zerop #*01010101 :count 1 :from-end t) #*0101011)
(equal (delete-if #'zerop #*01010101 :start 1) #*01111)
(equal (delete-if #'zerop #*01010101 :start 1 :end nil) #*01111)
(equal (delete-if #'zerop #*01010101 :start 1 :end 6) #*011101)
(equal (delete-if #'zerop #*01010101 :start 1 :end 6 :count 1) #*0110101)
(equal (delete-if #'zerop #*01010101 :start 1 :end 6 :count 1 :from-end t)
       #*0101101)
(equal (delete-if #'oddp #*01010101 :start 1 :end 6 :count 1 :from-end t)
       #*0101001)
(equal (delete-if #'evenp #*01010101 :start 1 :end 6 :count 1 :from-end t)
       #*0101101)
(equal (delete-if #'plusp #*01010101
               :start 1 :end 6 :count 1 :from-end t
               :key #'(lambda (arg) (* arg 10)))
       #*0101001)


(equal (delete-if-not #'(lambda (arg) (not (eql arg 'a)))
                      (list 'a 'b 'c 'a 'b 'c))
       '(b c b c))
(equal (delete-if-not #'(lambda (arg) (not (eql arg 'b)))
                      (list 'a 'b 'c 'a 'b 'c))
       '(a c a c))
(equal (delete-if-not #'(lambda (arg) (not (eql arg 'c)))
                      (list 'a 'b 'c 'a 'b 'c))
       '(a b a b))
(equal (delete-if-not #'(lambda (arg) (not (eql arg 'a)))
                      (list 'a 'a 'a)) '())
(equal (delete-if-not #'(lambda (arg) (not (eql arg 'z)))
                      (list 'a 'b 'c)) '(a b c))
(equal (delete-if-not #'(lambda (arg) (not (eql arg 'a))) '()) '())
(equal (delete-if-not #'(lambda (arg) (not (eql arg 'a)))
                      (list 'a 'b 'c 'a 'b 'c) :count 0) '(a b c a b c))
(equal (delete-if-not #'(lambda (arg) (not (eql arg 'a)))
                      (list 'a 'b 'c 'a 'b 'c) :count 1) '(b c a b c))
(equal (delete-if-not #'(lambda (arg) (not (eql arg 'a)))
                      (list 'a 'b 'c 'a 'b 'c) :count 1 :from-end t)
       '(a b c b c))
(equal (delete-if-not #'(lambda (arg) (not (eql arg 'a)))
                      (list 'a 'b 'c 'a 'b 'c) :count 2)
       '(b c b c))
(equal (delete-if-not #'(lambda (arg) (not (eql arg 'a)))
                      (list 'a 'b 'c 'a 'b 'c) :count 2 :from-end t)
       '(b c b c))
(equal (delete-if-not #'(lambda (arg) (not (eql arg 'a)))
                      (list 'a 'b 'c 'a 'b 'c) :count 3)
       '(b c b c))
(equal (delete-if-not #'(lambda (arg) (not (eql arg 'a)))
                      (list 'a 'b 'c 'a 'b 'c) :count 3 :from-end t)
       '(b c b c))
(equal (delete-if-not #'(lambda (arg) (not (eql arg 'a)))
                      (list 'a 'b 'c 'a 'b 'c) :count 4)
       '(b c b c))
(equal (delete-if-not #'(lambda (arg) (not (eql arg 'a)))
                      (list 'a 'b 'c 'a 'b 'c) :count 4 :from-end t)
       '(b c b c))
(equal (delete-if-not #'(lambda (arg) (not (eql arg 'a)))
                      (list 'a 'b 'c 'a 'b 'c) :count -1)
       '(a b c a b c))
(equal (delete-if-not #'(lambda (arg) (not (eql arg 'a)))
                      (list 'a 'b 'c 'a 'b 'c) :count -10)
       '(a b c a b c))
(equal (delete-if-not #'(lambda (arg) (not (eql arg 'a)))
                      (list 'a 'b 'c 'a 'b 'c) :count -100)
       '(a b c a b c))
(equal (delete-if-not #'(lambda (arg) (not (eql arg 'a)))
                      (list 'a 'b 'c 'a 'b 'c 'a 'b 'c 'a 'b 'c) :start 1)
       '(a b c b c b c b c))
(equal (delete-if-not #'(lambda (arg) (not (eql arg 'a)))
                      (list 'a 'b 'c 'a 'b 'c 'a 'b 'c 'a 'b 'c)
                      :start 1 :count 1)
       '(a b c b c a b c a b c))
(equal (delete-if-not #'(lambda (arg) (not (eql arg 'a)))
                      (list 'a 'b 'c 'a 'b 'c 'a 'b 'c 'a 'b 'c)
                      :start 1 :count 2)
       '(a b c b c b c a b c))
(equal (delete-if-not #'(lambda (arg) (not (eql arg 'a)))
                      (list 'a 'b 'c 'a 'b 'c 'a 'b 'c 'a 'b 'c)
                      :start 1 :end nil :count 2)
       '(a b c b c b c a b c))
(equal (delete-if-not #'(lambda (arg) (not (eql arg 'a)))
                      (list 'a 'b 'c 'a 'b 'c 'a 'b 'c 'a 'b 'c) :start 1 :end 8)
       '(a b c b c b c a b c))
(equal (delete-if-not #'(lambda (arg) (not (eql arg 'a)))
                      (list 'a 'b 'c 'a 'b 'c 'a 'b 'c 'a 'b 'c)
                      :start 1 :end 8 :count 1)
       '(a b c b c a b c a b c))
(equal (delete-if-not #'(lambda (arg) (not (eql arg 'a)))
                      (list 'a 'b 'c 'a 'b 'c 'a 'b 'c 'a 'b 'c)
                      :start 1 :end 8 :count 1 :from-end t)
       '(a b c a b c b c a b c))
(equal (delete-if-not #'(lambda (arg) (not (eql arg 'a)))
                      (list 'a 'b 'c 'a 'b 'c 'a 'b 'c 'a 'b 'c)
                      :start 1 :end 8 :count 0 :from-end t)
       '(a b c a b c a b c a b c))
(equal (delete-if-not #'(lambda (arg) (not (eql arg 'a)))
                      (list 'a 'b 'c 'a 'b 'c 'a 'b 'c 'a 'b 'c)
                      :start 1 :end 8 :count -100 :from-end t)
       '(a b c a b c a b c a b c))
(equal (delete-if-not #'(lambda (arg) (not (eql arg 'a)))
                      (list 'a 'b 'c 'a 'b 'c 'a 'b 'c 'a 'b 'c) :start 1 :end 1)
       '(a b c a b c a b c a b c))
(equal (delete-if-not #'(lambda (arg) (not (eql arg 'a)))
                      (list 'a 'b 'c 'a 'b 'c 'a 'b 'c 'a 'b 'c) :start 2 :end 2)
       '(a b c a b c a b c a b c))
(equal (delete-if-not #'(lambda (arg) (not (eql arg 'a)))
                      (list 'a 'b 'c 'a 'b 'c 'a 'b 'c 'a 'b 'c)
                      :start 12 :end 12)
       '(a b c a b c a b c a b c))
(equal (delete-if-not #'(lambda (arg) (not (eql arg 'a)))
                      (list '(a) '(b) '(c) '(a) '(b) '(c)) :key #'car)
       '((b) (c) (b) (c)))
(equal (delete-if-not #'(lambda (arg) (not (eql arg 'a)))
                      (list '(a . b) '(b . c) '(c . a)
                            '(a . b) '(b . c) '(c . a))
                      :key #'cdr)
       '((a . b) (b . c) (a . b) (b . c)))
(equal (delete-if-not #'(lambda (arg) (not (eql arg "love")))
                      (list '("Love") '("LOve") '("LOVe") '("LOVE"))
                      :key #'car)
       '(("Love") ("LOve") ("LOVe") ("LOVE")))
(equal (delete-if-not #'(lambda (arg) (not (eql arg "love")))
                      (list '("Love") '("LOve") '("LOVe") '("LOVE"))
                      :key #'car :count -10)
       '(("Love") ("LOve") ("LOVe") ("LOVE")))
(equal (delete-if-not #'(lambda (arg) (not (string-equal arg "love")))
                      (list '("Love") '("LOve") '("LOVe") '("LOVE"))
                      :key #'car)
       '())
(equal (delete-if-not #'(lambda (arg) (not (string-equal arg "love")))
                      (list '("Love") '("LOve") '("LOVe") '("LOVE"))
                      :key #'car :count 1)
       '(("LOve") ("LOVe") ("LOVE")))
(equal (delete-if-not #'(lambda (arg) (not (string-equal arg "love")))
                      (list '("Love") '("LOve") '("LOVe") '("LOVE"))
                      :key #'car :count 1 :from-end t)
       '(("Love") ("LOve") ("LOVe")))
(equal (delete-if-not #'(lambda (arg) (not (string-equal arg "love")))
                      (list '("Love") '("LOve") '("LOVe") '("LOVE"))
                      :key #'car :count 2 :from-end t)
       '(("Love") ("LOve")))
(equal (delete-if-not #'(lambda (arg) (not (string-equal arg "love")))
                      (list '("Love") '("LOve") '("LOVe") '("LOVE"))
                      :key #'car :start 1 :end 3)
       '(("Love") ("LOVE")))
(equal (delete-if-not #'(lambda (arg) (not (string-equal arg "love")))
                      (list '("Love") '("LOve") '("LOVe") '("LOVE"))
                      :key #'car :count 1 :start 1 :end 3)
       '(("Love") ("LOVe") ("LOVE")))
(equal (delete-if-not #'(lambda (arg) (not (string-equal arg "love")))
                      (list '("Love") '("LOve") '("LOVe") '("LOVE"))
                      :key #'car :count 1 :from-end t
                      :start 1 :end 3)
       '(("Love") ("LOve") ("LOVE")))
(equal (delete-if-not #'(lambda (arg) (not (string-equal arg "love")))
                      (list '("Love") '("LOve") '("LOVe") '("LOVE"))
                      :key #'car :count 10 :from-end t :start 1 :end 3)
       '(("Love") ("LOVE")))


(equalp (delete-if-not #'(lambda (arg) (not (eql arg 'a)))
                       (vector 'a 'b 'c 'a 'b 'c)) #(b c b c))
(equalp (delete-if-not #'(lambda (arg) (not (eql arg 'b)))
                       (vector 'a 'b 'c 'a 'b 'c)) #(a c a c))
(equalp (delete-if-not #'(lambda (arg) (not (eql arg 'c)))
                   (vector 'a 'b 'c 'a 'b 'c)) #(a b a b))
(equalp (delete-if-not #'(lambda (arg) (not (eql arg 'a)))
                   (vector 'a 'a 'a)) #())
(equalp (delete-if-not #'(lambda (arg) (not (eql arg 'z)))
                   (vector 'a 'b 'c)) #(a b c))
(equalp (delete-if-not #'(lambda (arg) (not (eql arg 'a))) #()) #())
(equalp (delete-if-not #'(lambda (arg) (not (eql arg 'a)))
                   (vector 'a 'b 'c 'a 'b 'c) :count 0) #(a b c a b c))
(equalp (delete-if-not #'(lambda (arg) (not (eql arg 'a)))
                   (vector 'a 'b 'c 'a 'b 'c) :count 1) #(b c a b c))
(equalp (delete-if-not #'(lambda (arg) (not (eql arg 'a)))
                   (vector 'a 'b 'c 'a 'b 'c) :count 1 :from-end t) #(a b c b c))
(equalp (delete-if-not #'(lambda (arg) (not (eql arg 'a)))
                   (vector 'a 'b 'c 'a 'b 'c) :count 2) #(b c b c))
(equalp (delete-if-not #'(lambda (arg) (not (eql arg 'a)))
                   (vector 'a 'b 'c 'a 'b 'c) :count 2 :from-end t) #(b c b c))
(equalp (delete-if-not #'(lambda (arg) (not (eql arg 'a)))
                   (vector 'a 'b 'c 'a 'b 'c) :count 3) #(b c b c))
(equalp (delete-if-not #'(lambda (arg) (not (eql arg 'a)))
                   (vector 'a 'b 'c 'a 'b 'c) :count 3 :from-end t) #(b c b c))
(equalp (delete-if-not #'(lambda (arg) (not (eql arg 'a)))
                   (vector 'a 'b 'c 'a 'b 'c) :count 4) #(b c b c))
(equalp (delete-if-not #'(lambda (arg) (not (eql arg 'a)))
                   (vector 'a 'b 'c 'a 'b 'c) :count 4 :from-end t) #(b c b c))
(equalp (delete-if-not #'(lambda (arg) (not (eql arg 'a)))
                   (vector 'a 'b 'c 'a 'b 'c) :count -1) #(a b c a b c))
(equalp (delete-if-not #'(lambda (arg) (not (eql arg 'a)))
                   (vector 'a 'b 'c 'a 'b 'c) :count -10) #(a b c a b c))
(equalp (delete-if-not #'(lambda (arg) (not (eql arg 'a)))
                   (vector 'a 'b 'c 'a 'b 'c) :count -100) #(a b c a b c))
(equalp (delete-if-not #'(lambda (arg) (not (eql arg 'a)))
                   (vector 'a 'b 'c 'a 'b 'c 'a 'b 'c 'a 'b 'c) :start 1)
        #(a b c b c b c b c))
(equalp (delete-if-not #'(lambda (arg) (not (eql arg 'a)))
                   (vector 'a 'b 'c 'a 'b 'c 'a 'b 'c 'a 'b 'c)
                   :start 1 :count 1)
       #(a b c b c a b c a b c))
(equalp (delete-if-not #'(lambda (arg) (not (eql arg 'a)))
                   (vector 'a 'b 'c 'a 'b 'c 'a 'b 'c 'a 'b 'c)
                   :start 1 :count 2)
        #(a b c b c b c a b c))
(equalp (delete-if-not #'(lambda (arg) (not (eql arg 'a)))
                   (vector 'a 'b 'c 'a 'b 'c 'a 'b 'c 'a 'b 'c)
                   :start 1 :end nil :count 2)
        #(a b c b c b c a b c))
(equalp (delete-if-not #'(lambda (arg) (not (eql arg 'a)))
                   (vector 'a 'b 'c 'a 'b 'c 'a 'b 'c 'a 'b 'c) :start 1 :end 8)
        #(a b c b c b c a b c))
(equalp (delete-if-not #'(lambda (arg) (not (eql arg 'a)))
                   (vector 'a 'b 'c 'a 'b 'c 'a 'b 'c 'a 'b 'c)
                   :start 1 :end 8 :count 1)
        #(a b c b c a b c a b c))
(equalp (delete-if-not #'(lambda (arg) (not (eql arg 'a)))
                   (vector 'a 'b 'c 'a 'b 'c 'a 'b 'c 'a 'b 'c)
                   :start 1 :end 8 :count 1 :from-end t)
        #(a b c a b c b c a b c))
(equalp (delete-if-not #'(lambda (arg) (not (eql arg 'a)))
                   (vector 'a 'b 'c 'a 'b 'c 'a 'b 'c 'a 'b 'c)
                   :start 1 :end 8 :count 0 :from-end t)
        #(a b c a b c a b c a b c))
(equalp (delete-if-not #'(lambda (arg) (not (eql arg 'a)))
                   (vector 'a 'b 'c 'a 'b 'c 'a 'b 'c 'a 'b 'c)
                   :start 1 :end 8 :count -100 :from-end t)
        #(a b c a b c a b c a b c))
(equalp (delete-if-not #'(lambda (arg) (not (eql arg 'a)))
                   (vector 'a 'b 'c 'a 'b 'c 'a 'b 'c 'a 'b 'c) :start 1 :end 1)
        #(a b c a b c a b c a b c))
(equalp (delete-if-not #'(lambda (arg) (not (eql arg 'a)))
                   (vector 'a 'b 'c 'a 'b 'c 'a 'b 'c 'a 'b 'c) :start 2 :end 2)
        #(a b c a b c a b c a b c))
(equalp (delete-if-not #'(lambda (arg) (not (eql arg 'a)))
                   (vector 'a 'b 'c 'a 'b 'c 'a 'b 'c 'a 'b 'c)
                   :start 12 :end 12)
        #(a b c a b c a b c a b c))
(equalp (delete-if-not #'(lambda (arg) (not (eql arg 'a)))
                   (vector '(a) '(b) '(c) '(a) '(b) '(c)) :key #'car)
        #((b) (c) (b) (c)))
(equalp (delete-if-not #'(lambda (arg) (not (eql arg 'a)))
                   (vector '(a . b) '(b . c) '(c . a)
                           '(a . b) '(b . c) '(c . a))
               :key #'cdr)
        #((a . b) (b . c) (a . b) (b . c)))
(equalp (delete-if-not #'(lambda (arg) (not (eql arg "love")))
                   (vector '("Love") '("LOve") '("LOVe") '("LOVE"))
                   :key #'car)
        #(("Love") ("LOve") ("LOVe") ("LOVE")))
(equalp (delete-if-not #'(lambda (arg) (not (eql arg "love")))
                   (vector '("Love") '("LOve") '("LOVe") '("LOVE"))
                   :key #'car :count -10)
        #(("Love") ("LOve") ("LOVe") ("LOVE")))
(equalp (delete-if-not #'(lambda (arg) (not (string-equal arg "love")))
                   (vector '("Love") '("LOve") '("LOVe") '("LOVE"))
                   :key #'car)
        #())
(equalp (delete-if-not #'(lambda (arg) (not (string-equal arg "love")))
                   (vector '("Love") '("LOve") '("LOVe") '("LOVE"))
                   :key #'car)
        #())
(equalp (delete-if-not #'(lambda (arg) (not (string-equal arg "love")))
                   (vector '("Love") '("LOve") '("LOVe") '("LOVE"))
                   :key #'car :count 1)
        #(("LOve") ("LOVe") ("LOVE")))
(equalp (delete-if-not #'(lambda (arg) (not (string-equal arg "love")))
                   (vector '("Love") '("LOve") '("LOVe") '("LOVE"))
                   :key #'car :count 1)
        #(("LOve") ("LOVe") ("LOVE")))
(equalp (delete-if-not #'(lambda (arg) (not (string-equal arg "love")))
                   (vector '("Love") '("LOve") '("LOVe") '("LOVE"))
                   :key #'car :count 1 :from-end t)
        #(("Love") ("LOve") ("LOVe")))
(equalp (delete-if-not #'(lambda (arg) (not (string-equal arg "love")))
                   (vector '("Love") '("LOve") '("LOVe") '("LOVE"))
                   :key #'car :count 1 :from-end t)
        #(("Love") ("LOve") ("LOVe")))
(equalp (delete-if-not #'(lambda (arg) (not (string-equal arg "love")))
                   (vector '("Love") '("LOve") '("LOVe") '("LOVE"))
                   :key #'car :count 2 :from-end t)
        #(("Love") ("LOve")))
(equalp (delete-if-not #'(lambda (arg) (not (string-equal arg "love")))
                   (vector '("Love") '("LOve") '("LOVe") '("LOVE"))
                   :key #'car :count 2 :from-end t)
        #(("Love") ("LOve")))
(equalp (delete-if-not #'(lambda (arg) (not (string-equal arg "love")))
                   (vector '("Love") '("LOve") '("LOVe") '("LOVE"))
                   :key #'car :start 1 :end 3)
        #(("Love") ("LOVE")))
(equalp (delete-if-not #'(lambda (arg) (not (string-equal arg "love")))
                   (vector '("Love") '("LOve") '("LOVe") '("LOVE"))
                   :key #'car :count 1 :start 1 :end 3)
        #(("Love") ("LOVe") ("LOVE")))
(equalp (delete-if-not #'(lambda (arg) (not (string-equal arg "love")))
                   (vector '("Love") '("LOve") '("LOVe") '("LOVE"))
                   :key #'car :count 1 :from-end t
                   :start 1 :end 3)
        #(("Love") ("LOve") ("LOVE")))
(equalp (delete-if-not #'(lambda (arg) (not (string-equal arg "love")))
                   (vector '("Love") '("LOve") '("LOVe") '("LOVE"))
                   :key #'car :count 10 :from-end t
                   :start 1 :end 3)
        #(("Love") ("LOVE")))

(string= (delete-if-not #'(lambda (arg) (not (string-equal arg #\a)))
                        (copy-seq "abcabc"))
         "bcbc")
(string= (delete-if-not #'(lambda (arg) (not (string-equal arg #\a)))
                        (copy-seq "")) "")
(string= (delete-if-not #'(lambda (arg) (not (string-equal arg #\a)))
                        (copy-seq "xyz"))
         "xyz")
(string= (delete-if-not #'(lambda (arg) (not (string-equal arg #\a)))
                        (copy-seq "ABCABC")
                        :key #'char-downcase) "BCBC")
(string= (delete-if-not #'(lambda (arg) (not (string-equal arg #\a)))
                        (copy-seq "abcabc")
                    :count 1) "bcabc")
(string= (delete-if-not #'(lambda (arg) (not (string-equal arg #\a)))
                        (copy-seq "abcabc")
                    :count 1 :from-end t) "abcbc")
(string= (delete-if-not #'(lambda (arg) (not (string-equal arg #\a)))
                        (copy-seq "abcabc")
                    :count 0) "abcabc")
(string= (delete-if-not #'(lambda (arg) (not (string-equal arg #\a)))
                        (copy-seq "abcabc")
                    :count -10) "abcabc")
(string= (delete-if-not #'(lambda (arg) (not (string-equal arg #\a)))
                        (copy-seq "abcabc")
                    :count 0) "abcabc")
(string= (delete-if-not #'(lambda (arg) (not (string-equal arg #\a)))
                        (copy-seq "abcabc"))
         "bcbc")
(string= (delete-if-not #'(lambda (arg) (not (string-equal arg #\b)))
                        (copy-seq "abcabc"))
         "acac")
(string= (delete-if-not #'(lambda (arg) (not (string-equal arg #\c)))
                        (copy-seq "abcabc"))
         "abab")
(string= (delete-if-not #'(lambda (arg) (not (string-equal arg #\a)))
                        (copy-seq "abcabc")
                    :count 0) "abcabc")
(string= (delete-if-not #'(lambda (arg) (not (string-equal arg #\a)))
                        (copy-seq "abcabc")
                    :count 1) "bcabc")
(string= (delete-if-not #'(lambda (arg) (not (string-equal arg #\a)))
                        (copy-seq "abcabc")
                    :count 1 :from-end t) "abcbc")
(string= (delete-if-not #'(lambda (arg) (not (string-equal arg #\a)))
                        (copy-seq "abcabc")
                    :count 2) "bcbc")
(string= (delete-if-not #'(lambda (arg) (not (string-equal arg #\a)))
                        (copy-seq "abcabc")
                    :count 2 :from-end t) "bcbc")
(string= (delete-if-not #'(lambda (arg) (not (string-equal arg #\a)))
                        (copy-seq "abcabc")
                    :count 3) "bcbc")
(string= (delete-if-not #'(lambda (arg) (not (string-equal arg #\a)))
                        (copy-seq "abcabc")
                    :count 3 :from-end t) "bcbc")
(string= (delete-if-not #'(lambda (arg) (not (string-equal arg #\a)))
                        (copy-seq "abcabc")
                    :count 4) "bcbc")
(string= (delete-if-not #'(lambda (arg) (not (string-equal arg #\a)))
                        (copy-seq "abcabc")
                    :count 4 :from-end t) "bcbc")
(string= (delete-if-not #'(lambda (arg) (not (string-equal arg #\a)))
                        (copy-seq "abcabc")
                    :count -1) "abcabc")
(string= (delete-if-not #'(lambda (arg) (not (string-equal arg #\a)))
                        (copy-seq "abcabc")
                    :count -10) "abcabc")
(string= (delete-if-not #'(lambda (arg) (not (string-equal arg #\a)))
                        (copy-seq "abcabc")
                    :count -100) "abcabc")
(string= (delete-if-not #'(lambda (arg) (not (string-equal arg #\a)))
                    (copy-seq "abcabcabcabc") :start 1) "abcbcbcbc")
(string= (delete-if-not #'(lambda (arg) (not (string-equal arg #\a)))
                    (copy-seq "abcabcabcabc") :start 1 :count 1) "abcbcabcabc")
(string= (delete-if-not #'(lambda (arg) (not (eql arg #\a)))
                        (copy-seq "abcabcabcabc") :start 1 :count 2)
         "abcbcbcabc")
(string= (delete-if-not #'(lambda (arg) (not (eql arg #\a)))
                        (copy-seq "abcabcabcabc") :start 1 :end nil :count 2)
         "abcbcbcabc")
(string= (delete-if-not #'(lambda (arg) (not (eql arg #\a)))
                        (copy-seq "abcabcabcabc") :start 1 :end 8) "abcbcbcabc")
(string= (delete-if-not #'(lambda (arg) (not (eql arg #\a)))
                        (copy-seq "abcabcabcabc") :start 1 :end 8 :count 1)
         "abcbcabcabc")
(string= (delete-if-not #'(lambda (arg) (not (eql arg #\a)))
                        (copy-seq "abcabcabcabc")
                        :start 1 :end 8 :count 1 :from-end t)
         "abcabcbcabc")
(string= (delete-if-not #'(lambda (arg) (not (eql arg #\a)))
                        (copy-seq "abcabcabcabc")
                        :start 1 :end 8 :count 0 :from-end t)
         "abcabcabcabc")
(string= (delete-if-not #'(lambda (arg) (not (eql arg #\a)))
                        (copy-seq "abcabcabcabc")
                        :start 1 :end 8 :count -100 :from-end t)
         "abcabcabcabc")
(string= (delete-if-not #'(lambda (arg) (not (eql arg #\a)))
                        (copy-seq "abcabcabcabc") :start 1 :end 1)
         "abcabcabcabc")
(string= (delete-if-not #'(lambda (arg) (not (eql arg #\a)))
                        (copy-seq "abcabcabcabc")
                        :start 2 :end 2) "abcabcabcabc")
(string= (delete-if-not #'(lambda (arg) (not (eql arg #\a)))
                        (copy-seq "abcabcabcabc")
                        :start 12 :end 12) "abcabcabcabc")
(equal (delete-if-not (complement #'zerop) #*0101) #*11)
(equal (delete-if-not (complement #'zerop) #*01010101 :count 1) #*1010101)
(equal (delete-if-not (complement #'zerop) #*01010101 :count 1 :from-end t)
       #*0101011)
(equal (delete-if-not (complement #'zerop) #*01010101 :start 1) #*01111)
(equal (delete-if-not (complement #'zerop) #*01010101 :start 1 :end nil) #*01111)
(equal (delete-if-not (complement #'zerop) #*01010101 :start 1 :end 6) #*011101)
(equal (delete-if-not (complement #'zerop) #*01010101 :start 1 :end 6 :count 1)
       #*0110101)
(equal (delete-if-not (complement #'zerop) #*01010101
                      :start 1 :end 6 :count 1 :from-end t)
       #*0101101)
(equal (delete-if-not (complement #'oddp) #*01010101
                      :start 1 :end 6 :count 1 :from-end t)
       #*0101001)
(equal (delete-if-not (complement #'evenp)
                      #*01010101 :start 1 :end 6 :count 1 :from-end t)
       #*0101101)
(equal (delete-if-not (complement #'plusp) #*01010101
               :start 1 :end 6 :count 1 :from-end t
               :key #'(lambda (arg) (* arg 10)))
       #*0101001)


(equal (remove-duplicates "aBcDAbCd" :test #'char-equal :from-end t) "aBcD")
(equal (remove-duplicates '(a b c b d d e)) '(A C B D E))
(equal (remove-duplicates '(a b c b d d e) :from-end t) '(A B C D E))
(equal (remove-duplicates '((foo #\a) (bar #\%) (baz #\A))
                          :test #'char-equal :key #'cadr)
       '((BAR #\%) (BAZ #\A)))
(equal (remove-duplicates '((foo #\a) (bar #\%) (baz #\A))
                          :test #'char-equal :key #'cadr :from-end t)
       '((FOO #\a) (BAR #\%)))
(let* ((list0 (list 0 1 2 3 4 5 6))
       (list (delete-duplicates list0 :key #'oddp :start 1 :end 6)))
  (equal list '(0 4 5 6)))


#-CLISP ;Bruno: The tests ignores ANSI CL "remove-duplicates returns a sequence
        ; that may share with sequence or may be identical to sequence
        ; if no elements need to be removed."
(let* ((list0 (list 0 1 2))
       (list (remove-duplicates list0)))
  (and (not (eq list0 list))
       (equal list0 '(0 1 2))
       (equal list '(0 1 2))))
(let* ((list0 (list 2 1 0 1 0 1 2))
       (list (remove-duplicates list0)))
  (and (not (eq list0 list))
       (equal list0 '(2 1 0 1 0 1 2))
       (equal list '(0 1 2))))
#-CLISP ;Bruno: The tests ignores ANSI CL "remove-duplicates returns a sequence
        ; that may share with sequence or may be identical to sequence if no
        ; elements need to be removed."
(let* ((vector0 (vector 0 1 2))
       (vector (remove-duplicates vector0)))
  (and (not (eq vector0 vector))
       (equalp vector0 #(0 1 2))
       (equalp vector #(0 1 2))))
(let* ((vector0 (vector 2 1 0 1 0 1 2))
       (vector (remove-duplicates vector0)))
  (and (not (eq vector0 vector))
       (equalp vector0 #(2 1 0 1 0 1 2))
       (equalp vector #(0 1 2))))

(equal (remove-duplicates (list 0 1 2 2 3 3 3)) '(0 1 2 3))
(equal (remove-duplicates (list 0 0 0 2 0 1 1 2 2 2 1 1 1 1 2)) '(0 1 2))
(equal (remove-duplicates (list 'a 'a 'b 'c 'c)) '(a b c))
(equal (remove-duplicates (list 0 1 2)) '(0 1 2))
(equal (remove-duplicates (list 2 0 2 1 1 1 0 0 0 1 2)) '(0 1 2))
(equal (remove-duplicates (list)) '())
(equal (remove-duplicates (list '(x . 0) '(y . 1) '(z . 2)
                                '(a . 0) '(b . 1) '(c . 2)) :key #'cdr)
       '((a . 0) (b . 1) (c . 2)))
(equal (remove-duplicates (list '(x . 0) '(y . 1) '(z . 2)
                                '(a . 0) '(b . 1) '(c . 2))
                          :key #'cdr
                          :test #'(lambda (a b) (and (oddp a) (oddp b))))
       '((x . 0) (z . 2) (a . 0) (b . 1) (c . 2)))
(equal (remove-duplicates (list '(x . 0) '(y . 1) '(z . 2)
                                '(a . 0) '(b . 1) '(c . 2))
                          :key #'cdr
                          :test-not #'(lambda (a b)
                                        (not (and (oddp a) (oddp b)))))
       '((x . 0) (z . 2) (a . 0) (b . 1) (c . 2)))
(equal (remove-duplicates (list '(x . 0) '(y . 1) '(z . 2)
                                '(a . 0) '(b . 1) '(c . 2))
                          :key #'cdr
                          :test #'(lambda (a b) (and (evenp a) (evenp b))))
       '((y . 1) (b . 1) (c . 2)))
(equal (remove-duplicates (list '(x . 0) '(y . 1) '(z . 2)
                                '(a . 0) '(b . 1) '(c . 2))
                          :key #'cdr
                          :test-not #'(lambda (a b)
                                        (not (and (evenp a) (evenp b)))))
       '((y . 1) (b . 1) (c . 2)))
(equal (remove-duplicates (list 0 1 2 0 1 2 0 1 2 0 1 2) :start 3 :end 9)
       '(0 1 2 0 1 2 0 1 2))
(equal (remove-duplicates (list '(0 . 0) '(1 . 1)  '(2 . 2)
                                '(0 . 3) '(1 . 4)  '(2 . 5)
                                '(0 . 6) '(1 . 7)  '(2 . 8)
                                '(0 . 9) '(1 . 10) '(2 . 11)))
       (list '(0 . 0) '(1 . 1)  '(2 . 2)
             '(0 . 3) '(1 . 4)  '(2 . 5)
             '(0 . 6) '(1 . 7)  '(2 . 8)
             '(0 . 9) '(1 . 10) '(2 . 11)))
(equal (remove-duplicates (list '(0 . 0) '(1 . 1)  '(2 . 2)
                                '(0 . 3) '(1 . 4)  '(2 . 5)
                                '(0 . 6) '(1 . 7)  '(2 . 8)
                                '(0 . 9) '(1 . 10) '(2 . 11))
                          :key #'car)
       '((0 . 9) (1 . 10) (2 . 11)))
(equal (remove-duplicates (list '(0 . 0) '(1 . 1)  '(2 . 2)
                                '(0 . 3) '(1 . 4)  '(2 . 5)
                                '(0 . 6) '(1 . 7)  '(2 . 8)
                                '(0 . 9) '(1 . 10) '(2 . 11))
                          :key #'car :from-end t)
       (list '(0 . 0) '(1 . 1) '(2 . 2)))
(equal (remove-duplicates (list '(0 . 0) '(1 . 1)  '(2 . 2)
                                '(0 . 3) '(1 . 4)  '(2 . 5)
                                '(0 . 6) '(1 . 7)  '(2 . 8)
                                '(0 . 9) '(1 . 10) '(2 . 11))
                          :start 3 :key #'car)
       (list '(0 . 0) '(1 . 1)  '(2 . 2)
             '(0 . 9) '(1 . 10) '(2 . 11)))
(equal (remove-duplicates (list '(0 . 0) '(1 . 1)  '(2 . 2)
                                '(0 . 3) '(1 . 4)  '(2 . 5)
                                '(0 . 6) '(1 . 7)  '(2 . 8)
                                '(0 . 9) '(1 . 10) '(2 . 11))
                          :start 3 :key #'car :from-end t)
       (list '(0 . 0) '(1 . 1)  '(2 . 2)
             '(0 . 3) '(1 . 4)  '(2 . 5)))
(equal (remove-duplicates (list '(0 . 0) '(1 . 1)  '(2 . 2)
                                '(0 . 3) '(1 . 4)  '(2 . 5)
                                '(0 . 6) '(1 . 7)  '(2 . 8)
                                '(0 . 9) '(1 . 10) '(2 . 11))
                          :start 3 :end nil :key #'car)
       (list '(0 . 0) '(1 . 1)  '(2 . 2)
             '(0 . 9) '(1 . 10) '(2 . 11)))
(equal (remove-duplicates (list '(0 . 0) '(1 . 1)  '(2 . 2)
                                '(0 . 3) '(1 . 4)  '(2 . 5)
                                '(0 . 6) '(1 . 7)  '(2 . 8)
                                '(0 . 9) '(1 . 10) '(2 . 11))
                          :start 3 :end 9 :key #'car)
       '((0 . 0) (1 . 1)  (2 . 2)
         (0 . 6) (1 . 7)  (2 . 8)
         (0 . 9) (1 . 10) (2 . 11)))
(equal (remove-duplicates (list '(0 . 0) '(1 . 1)  '(2 . 2)
                                '(0 . 3) '(1 . 4)  '(2 . 5)
                                '(0 . 6) '(1 . 7)  '(2 . 8)
                                '(0 . 9) '(1 . 10) '(2 . 11))
                          :start 3 :end 9 :key #'car :from-end t)
       (list '(0 . 0) '(1 . 1)  '(2 . 2)
             '(0 . 3) '(1 . 4)  '(2 . 5)
             '(0 . 9) '(1 . 10) '(2 . 11)))
(equal (remove-duplicates (list "Monday" "Tuesday" "Wednesday" "Thursday"
                                "Friday" "Saturday" "Sunday")
                          :key #'length)
       (list "Tuesday" "Wednesday" "Saturday" "Sunday"))
(equal (remove-duplicates (list "Monday" "Tuesday" "Wednesday" "Thursday"
                                "Friday" "Saturday" "Sunday")
                          :key #'(lambda (arg) (char arg 0)) :test #'char=)
       (list "Monday" "Wednesday" "Thursday" "Friday" "Sunday"))
(equal (remove-duplicates (list "Monday" "Tuesday" "Wednesday" "Thursday"
                                "Friday" "Saturday" "Sunday")
                          :key #'(lambda (arg) (char arg 0))
                          :test-not (complement #'char=))
       (list "Monday" "Wednesday" "Thursday" "Friday" "Sunday"))
(equal (remove-duplicates (list #\a #\b #\c #\A #\B #\C) :key #'char-upcase)
       '(#\A #\B #\C))
(equal (remove-duplicates (list #\a #\b #\c #\A #\B #\C)
                          :key #'char-upcase :from-end t)
       '(#\a #\b #\c))
(equal (remove-duplicates (list #\a #\b #\c #\A #\B #\C) :test #'char=)
       (list #\a #\b #\c #\A #\B #\C))
(equal (remove-duplicates (list #\a #\b #\c #\A #\B #\C)
                          :test-not (complement #'char=))
       (list #\a #\b #\c #\A #\B #\C))
(equal (remove-duplicates (list #\a #\b #\c #\A #\B #\C) :test #'char-equal)
       (list #\A #\B #\C))
(equal (remove-duplicates (list #\a #\b #\c #\A #\B #\C)
                          :test-not (complement #'char-equal))
       (list #\A #\B #\C))
(equal (remove-duplicates (list #\a #\b #\c #\A #\B #\C)
                          :test #'char-equal :from-end t)
       (list #\a #\b #\c))
(equal (remove-duplicates (list #\a #\b #\c #\A #\B #\C)
                          :test-not (complement #'char-equal) :from-end t)
       (list #\a #\b #\c))
(equal (remove-duplicates (list #\a #\1 #\b #\1 #\2 #\c #\0 #\A #\0 #\B #\C #\9)
                          :key #'alpha-char-p)
       (list #\C #\9))
(equal (remove-duplicates (list #\a #\1 #\b #\1 #\2 #\c #\0 #\A #\0 #\B #\C #\9)
                          :key #'alphanumericp)
       (list #\9))
(equal (remove-duplicates (list '(#\A . 0) '(#\b . 1)  '(#\C . 2)
                                '(#\a . 3) '(#\B . 4)  '(#\c . 5)
                                '(#\A . 6) '(#\b . 7)  '(#\C . 8)
                                '(#\a . 9) '(#\B . 10) '(#\c . 11)))
       (list '(#\A . 0) '(#\b . 1)  '(#\C . 2)
             '(#\a . 3) '(#\B . 4)  '(#\c . 5)
             '(#\A . 6) '(#\b . 7)  '(#\C . 8)
             '(#\a . 9) '(#\B . 10) '(#\c . 11)))
(equal (remove-duplicates (list '(#\A . 0) '(#\b . 1)  '(#\C . 2)
                                '(#\a . 3) '(#\B . 4)  '(#\c . 5)
                                '(#\A . 6) '(#\b . 7)  '(#\C . 8)
                                '(#\a . 9) '(#\B . 10) '(#\c . 11))
                          :key #'car)
       (list '(#\A . 6) '(#\b . 7)  '(#\C . 8)
             '(#\a . 9) '(#\B . 10) '(#\c . 11)))
(equal (remove-duplicates (list '(#\A . 0) '(#\b . 1)  '(#\C . 2)
                                '(#\a . 3) '(#\B . 4)  '(#\c . 5)
                                '(#\A . 6) '(#\b . 7)  '(#\C . 8)
                                '(#\a . 9) '(#\B . 10) '(#\c . 11))
                          :key #'car :start 3 :end 9)
       (list '(#\A . 0) '(#\b . 1)  '(#\C . 2)
             '(#\a . 3) '(#\B . 4)  '(#\c . 5)
             '(#\A . 6) '(#\b . 7)  '(#\C . 8)
             '(#\a . 9) '(#\B . 10) '(#\c . 11)))
(equal (remove-duplicates (list '(#\A . 0) '(#\b . 1)  '(#\C . 2)
                                '(#\a . 3) '(#\B . 4)  '(#\c . 5)
                                '(#\A . 6) '(#\b . 7)  '(#\C . 8)
                                '(#\a . 9) '(#\B . 10) '(#\c . 11))
                          :key #'car :start 3 :end 9 :test #'char-equal)
       (list '(#\A . 0) '(#\b . 1)  '(#\C . 2)
             '(#\A . 6) '(#\b . 7)  '(#\C . 8)
             '(#\a . 9) '(#\B . 10) '(#\c . 11)))
(equal (remove-duplicates (list '(#\A . 0) '(#\b . 1)  '(#\C . 2)
                                '(#\a . 3) '(#\B . 4)  '(#\c . 5)
                                '(#\A . 6) '(#\b . 7)  '(#\C . 8)
                                '(#\a . 9) '(#\B . 10) '(#\c . 11))
                          :key #'car :start 3 :end 9
                          :test-not (complement #'char-equal))
       (list '(#\A . 0) '(#\b . 1)  '(#\C . 2)
             '(#\A . 6) '(#\b . 7)  '(#\C . 8)
             '(#\a . 9) '(#\B . 10) '(#\c . 11)))
(equal (remove-duplicates (list '(#\A . 0) '(#\b . 1)  '(#\C . 2)
                                '(#\a . 3) '(#\B . 4)  '(#\c . 5)
                                '(#\A . 6) '(#\b . 7)  '(#\C . 8)
                                '(#\a . 9) '(#\B . 10) '(#\c . 11))
                          :key #'car :start 3 :end 9 :test #'char-equal
                          :from-end t)
       (list '(#\A . 0) '(#\b . 1)  '(#\C . 2)
             '(#\a . 3) '(#\B . 4)  '(#\c . 5)
             '(#\a . 9) '(#\B . 10) '(#\c . 11)))
(equal (remove-duplicates (list '(#\A . 0) '(#\b . 1)  '(#\C . 2)
                                '(#\a . 3) '(#\B . 4)  '(#\c . 5)
                                '(#\A . 6) '(#\b . 7)  '(#\C . 8)
                                '(#\a . 9) '(#\B . 10) '(#\c . 11))
                          :key #'car :start 3 :end 9
                          :test-not (complement #'char-equal) :from-end t)
       (list '(#\A . 0) '(#\b . 1)  '(#\C . 2)
             '(#\a . 3) '(#\B . 4)  '(#\c . 5)
             '(#\a . 9) '(#\B . 10) '(#\c . 11)))
(equal (remove-duplicates (list '(#\A . 0) '(#\b . 1)  '(#\C . 2)
                                '(#\a . 3) '(#\B . 4)  '(#\c . 5)
                                '(#\A . 6) '(#\b . 7)  '(#\C . 8)
                                '(#\a . 9) '(#\B . 10) '(#\c . 11))
                          :key #'car :start 3)
       (list '(#\A . 0) '(#\b . 1)  '(#\C . 2)
             '(#\A . 6) '(#\b . 7)  '(#\C . 8)
             '(#\a . 9) '(#\B . 10) '(#\c . 11)))
(equal (remove-duplicates (list '(#\A . 0) '(#\b . 1)  '(#\C . 2)
                                '(#\a . 3) '(#\B . 4)  '(#\c . 5)
                                '(#\A . 6) '(#\b . 7)  '(#\C . 8)
                                '(#\a . 9) '(#\B . 10) '(#\c . 11))
                          :key #'car :start 3 :end nil)
       (list '(#\A . 0) '(#\b . 1)  '(#\C . 2)
             '(#\A . 6) '(#\b . 7)  '(#\C . 8)
             '(#\a . 9) '(#\B . 10) '(#\c . 11)))
(equal (remove-duplicates (list '(#\A . 0) '(#\b . 1)  '(#\C . 2)
                                '(#\a . 3) '(#\B . 4)  '(#\c . 5)
                                '(#\A . 6) '(#\b . 7)  '(#\C . 8)
                                '(#\a . 9) '(#\B . 10) '(#\c . 11))
                          :key #'car :start 3 :from-end t)
       (list '(#\A . 0) '(#\b . 1)  '(#\C . 2)
             '(#\a . 3) '(#\B . 4)  '(#\c . 5)
             '(#\A . 6) '(#\b . 7)  '(#\C . 8)))
(equal (remove-duplicates (list '(#\A . 0) '(#\b . 1)  '(#\C . 2)
                                '(#\a . 3) '(#\B . 4)  '(#\c . 5)
                                '(#\A . 6) '(#\b . 7)  '(#\C . 8)
                                '(#\a . 9) '(#\B . 10) '(#\c . 11))
                          :key #'car :end 9)
       (list '(#\a . 3) '(#\B . 4)  '(#\c . 5)
             '(#\A . 6) '(#\b . 7)  '(#\C . 8)
             '(#\a . 9) '(#\B . 10) '(#\c . 11)))
(equal (remove-duplicates (list '(#\A . 0) '(#\b . 1)  '(#\C . 2)
                                '(#\a . 3) '(#\B . 4)  '(#\c . 5)
                                '(#\A . 6) '(#\b . 7)  '(#\C . 8)
                                '(#\a . 9) '(#\B . 10) '(#\c . 11))
                          :key #'car :end 9 :from-end t)
       (list '(#\A . 0) '(#\b . 1)  '(#\C . 2)
             '(#\a . 3) '(#\B . 4)  '(#\c . 5)
             '(#\a . 9) '(#\B . 10) '(#\c . 11)))
(equal (remove-duplicates (list '(#\A . 0) '(#\b . 1)  '(#\C . 2)
                                '(#\a . 3) '(#\B . 4)  '(#\c . 5)
                                '(#\A . 6) '(#\b . 7)  '(#\C . 8)
                                '(#\a . 9) '(#\B . 10) '(#\c . 11))
                          :key #'car :start 0 :end 12 :test #'char-equal)
       (list '(#\a . 9) '(#\B . 10) '(#\c . 11)))
(equal (remove-duplicates (list '(#\A . 0) '(#\b . 1)  '(#\C . 2)
                                '(#\a . 3) '(#\B . 4)  '(#\c . 5)
                                '(#\A . 6) '(#\b . 7)  '(#\C . 8)
                                '(#\a . 9) '(#\B . 10) '(#\c . 11))
                          :key #'car :start 0 :end 12
                          :test-not (complement #'char-equal))
       (list '(#\a . 9) '(#\B . 10) '(#\c . 11)))
(equal (remove-duplicates (list '(#\A . 0) '(#\b . 1)  '(#\C . 2)
                                '(#\a . 3) '(#\B . 4)  '(#\c . 5)
                                '(#\A . 6) '(#\b . 7)  '(#\C . 8)
                                '(#\a . 9) '(#\B . 10) '(#\c . 11))
                          :key #'car :start 0 :end 12 :test #'char-equal
                          :from-end t)
       '((#\A . 0) (#\b . 1) (#\C . 2)))
(equal (remove-duplicates (list '(#\A . 0) '(#\b . 1)  '(#\C . 2)
                                '(#\a . 3) '(#\B . 4)  '(#\c . 5)
                                '(#\A . 6) '(#\b . 7)  '(#\C . 8)
                                '(#\a . 9) '(#\B . 10) '(#\c . 11))
                          :key #'car :start 0 :end 12
                          :test-not (complement #'char-equal) :from-end t)
       '((#\A . 0) (#\b . 1) (#\C . 2)))


(equalp (remove-duplicates (vector 0 1 2 2 3 3 3)) #(0 1 2 3))
(equalp (remove-duplicates (vector 0 0 0 2 0 1 1 2 2 2 1 1 1 1 2)) #(0 1 2))
(equalp (remove-duplicates (vector 'a 'a 'b 'c 'c)) #(a b c))
(equalp (remove-duplicates (vector 0 1 2)) #(0 1 2))
(equalp (remove-duplicates (vector 2 0 2 1 1 1 0 0 0 1 2)) #(0 1 2))
(equalp (remove-duplicates (vector)) #())
(equalp (remove-duplicates (vector '(x . 0) '(y . 1) '(z . 2)
                                   '(a . 0) '(b . 1) '(c . 2)) :key #'cdr)
        #((a . 0) (b . 1) (c . 2)))
(equalp (remove-duplicates (vector '(x . 0) '(y . 1) '(z . 2)
                                   '(a . 0) '(b . 1) '(c . 2))
                           :key #'cdr
                           :test #'(lambda (a b) (and (oddp a) (oddp b))))
        #((x . 0) (z . 2) (a . 0) (b . 1) (c . 2)))
(equalp (remove-duplicates (vector '(x . 0) '(y . 1) '(z . 2)
                                   '(a . 0) '(b . 1) '(c . 2))
                           :key #'cdr
                           :test-not #'(lambda (a b)
                                         (not (and (oddp a) (oddp b)))))
        #((x . 0) (z . 2) (a . 0) (b . 1) (c . 2)))
(equalp (remove-duplicates (vector '(x . 0) '(y . 1) '(z . 2)
                                   '(a . 0) '(b . 1) '(c . 2))
                           :key #'cdr
                           :test #'(lambda (a b) (and (evenp a) (evenp b))))
        #((y . 1) (b . 1) (c . 2)))
(equalp (remove-duplicates (vector '(x . 0) '(y . 1) '(z . 2)
                                   '(a . 0) '(b . 1) '(c . 2))
                           :key #'cdr
                           :test-not #'(lambda (a b)
                                         (not (and (evenp a) (evenp b)))))
        #((y . 1) (b . 1) (c . 2)))
(equalp (remove-duplicates (vector 0 1 2 0 1 2 0 1 2 0 1 2) :start 3 :end 9)
        #(0 1 2 0 1 2 0 1 2))
(equalp (remove-duplicates (vector '(0 . 0) '(1 . 1)  '(2 . 2)
                                   '(0 . 3) '(1 . 4)  '(2 . 5)
                                   '(0 . 6) '(1 . 7)  '(2 . 8)
                                   '(0 . 9) '(1 . 10) '(2 . 11)))
        (vector '(0 . 0) '(1 . 1)  '(2 . 2)
                '(0 . 3) '(1 . 4)  '(2 . 5)
                '(0 . 6) '(1 . 7)  '(2 . 8)
                '(0 . 9) '(1 . 10) '(2 . 11)))
(equalp (remove-duplicates (vector '(0 . 0) '(1 . 1)  '(2 . 2)
                                   '(0 . 3) '(1 . 4)  '(2 . 5)
                                   '(0 . 6) '(1 . 7)  '(2 . 8)
                                   '(0 . 9) '(1 . 10) '(2 . 11))
                           :key #'car)
        #((0 . 9) (1 . 10) (2 . 11)))
(equalp (remove-duplicates (vector '(0 . 0) '(1 . 1)  '(2 . 2)
                                   '(0 . 3) '(1 . 4)  '(2 . 5)
                                   '(0 . 6) '(1 . 7)  '(2 . 8)
                                   '(0 . 9) '(1 . 10) '(2 . 11))
                           :key #'car :from-end t)
        (vector '(0 . 0) '(1 . 1) '(2 . 2)))
(equalp (remove-duplicates (vector '(0 . 0) '(1 . 1)  '(2 . 2)
                                   '(0 . 3) '(1 . 4)  '(2 . 5)
                                   '(0 . 6) '(1 . 7)  '(2 . 8)
                                   '(0 . 9) '(1 . 10) '(2 . 11))
                           :start 3 :key #'car)
        (vector '(0 . 0) '(1 . 1)  '(2 . 2)
                '(0 . 9) '(1 . 10) '(2 . 11)))
(equalp (remove-duplicates (vector '(0 . 0) '(1 . 1)  '(2 . 2)
                                   '(0 . 3) '(1 . 4)  '(2 . 5)
                                   '(0 . 6) '(1 . 7)  '(2 . 8)
                                   '(0 . 9) '(1 . 10) '(2 . 11))
                           :start 3 :key #'car :from-end t)
        (vector '(0 . 0) '(1 . 1)  '(2 . 2)
                '(0 . 3) '(1 . 4)  '(2 . 5)))
(equalp (remove-duplicates (vector '(0 . 0) '(1 . 1)  '(2 . 2)
                                   '(0 . 3) '(1 . 4)  '(2 . 5)
                                   '(0 . 6) '(1 . 7)  '(2 . 8)
                                   '(0 . 9) '(1 . 10) '(2 . 11))
                           :start 3 :end nil :key #'car)
        (vector '(0 . 0) '(1 . 1)  '(2 . 2)
                '(0 . 9) '(1 . 10) '(2 . 11)))
(equalp (remove-duplicates (vector '(0 . 0) '(1 . 1)  '(2 . 2)
                                   '(0 . 3) '(1 . 4)  '(2 . 5)
                                   '(0 . 6) '(1 . 7)  '(2 . 8)
                                   '(0 . 9) '(1 . 10) '(2 . 11))
                           :start 3 :end 9 :key #'car)
        #((0 . 0) (1 . 1)  (2 . 2)
          (0 . 6) (1 . 7)  (2 . 8)
          (0 . 9) (1 . 10) (2 . 11)))
(equalp (remove-duplicates (vector '(0 . 0) '(1 . 1)  '(2 . 2)
                                   '(0 . 3) '(1 . 4)  '(2 . 5)
                                   '(0 . 6) '(1 . 7)  '(2 . 8)
                                   '(0 . 9) '(1 . 10) '(2 . 11))
                           :start 3 :end 9 :key #'car :from-end t)
        (vector '(0 . 0) '(1 . 1)  '(2 . 2)
                '(0 . 3) '(1 . 4)  '(2 . 5)
                '(0 . 9) '(1 . 10) '(2 . 11)))
(equalp (remove-duplicates (vector "Monday" "Tuesday" "Wednesday" "Thursday"
                                   "Friday" "Saturday" "Sunday")
                           :key #'length)
        (vector "Tuesday" "Wednesday" "Saturday" "Sunday"))
(equalp (remove-duplicates (vector "Monday" "Tuesday" "Wednesday" "Thursday"
                                   "Friday" "Saturday" "Sunday")
                           :key #'(lambda (arg) (char arg 0)) :test #'char=)
        (vector "Monday" "Wednesday" "Thursday" "Friday" "Sunday"))
(equalp (remove-duplicates (vector "Monday" "Tuesday" "Wednesday" "Thursday"
                                   "Friday" "Saturday" "Sunday")
                           :key #'(lambda (arg) (char arg 0))
                           :test-not (complement #'char=))
        (vector "Monday" "Wednesday" "Thursday" "Friday" "Sunday"))
(equalp (remove-duplicates (vector #\a #\b #\c #\A #\B #\C) :key #'char-upcase)
        #(#\A #\B #\C))
(equalp (remove-duplicates (vector #\a #\b #\c #\A #\B #\C)
                           :key #'char-upcase :from-end t)
        #(#\a #\b #\c))
(equalp (remove-duplicates (vector #\a #\b #\c #\A #\B #\C) :test #'char=)
        (vector #\a #\b #\c #\A #\B #\C))
(equalp (remove-duplicates (vector #\a #\b #\c #\A #\B #\C)
                           :test-not (complement #'char=))
        (vector #\a #\b #\c #\A #\B #\C))
(equalp (remove-duplicates (vector #\a #\b #\c #\A #\B #\C) :test #'char-equal)
        (vector #\A #\B #\C))
(equalp (remove-duplicates (vector #\a #\b #\c #\A #\B #\C)
                           :test-not (complement #'char-equal))
        (vector #\A #\B #\C))
(equalp (remove-duplicates (vector #\a #\b #\c #\A #\B #\C)
                           :test #'char-equal :from-end t)
        (vector #\a #\b #\c))
(equalp (remove-duplicates (vector #\a #\b #\c #\A #\B #\C)
                           :test-not (complement #'char-equal) :from-end t)
        (vector #\a #\b #\c))

(equalp (remove-duplicates
         (vector #\a #\1 #\b #\1 #\2 #\c #\0 #\A #\0 #\B #\C #\9)
         :key #'alpha-char-p)
        (vector #\C #\9))
(equalp (remove-duplicates
         (vector #\a #\1 #\b #\1 #\2 #\c #\0 #\A #\0 #\B #\C #\9)
         :key #'alphanumericp)
        (vector #\9))
(equalp (remove-duplicates (vector '(#\A . 0) '(#\b . 1)  '(#\C . 2)
                                   '(#\a . 3) '(#\B . 4)  '(#\c . 5)
                                   '(#\A . 6) '(#\b . 7)  '(#\C . 8)
                                   '(#\a . 9) '(#\B . 10) '(#\c . 11)))
        (vector '(#\A . 0) '(#\b . 1)  '(#\C . 2)
                '(#\a . 3) '(#\B . 4)  '(#\c . 5)
                '(#\A . 6) '(#\b . 7)  '(#\C . 8)
                '(#\a . 9) '(#\B . 10) '(#\c . 11)))
(equalp (remove-duplicates (vector '(#\A . 0) '(#\b . 1)  '(#\C . 2)
                                   '(#\a . 3) '(#\B . 4)  '(#\c . 5)
                                   '(#\A . 6) '(#\b . 7)  '(#\C . 8)
                                   '(#\a . 9) '(#\B . 10) '(#\c . 11))
                           :key #'car)
        (vector '(#\A . 6) '(#\b . 7)  '(#\C . 8)
                '(#\a . 9) '(#\B . 10) '(#\c . 11)))
(equalp (remove-duplicates (vector '(#\A . 0) '(#\b . 1)  '(#\C . 2)
                                   '(#\a . 3) '(#\B . 4)  '(#\c . 5)
                                   '(#\A . 6) '(#\b . 7)  '(#\C . 8)
                                   '(#\a . 9) '(#\B . 10) '(#\c . 11))
                           :key #'car :start 3 :end 9)
        (vector '(#\A . 0) '(#\b . 1)  '(#\C . 2)
                '(#\a . 3) '(#\B . 4)  '(#\c . 5)
                '(#\A . 6) '(#\b . 7)  '(#\C . 8)
                '(#\a . 9) '(#\B . 10) '(#\c . 11)))
(equalp (remove-duplicates (vector '(#\A . 0) '(#\b . 1)  '(#\C . 2)
                                   '(#\a . 3) '(#\B . 4)  '(#\c . 5)
                                   '(#\A . 6) '(#\b . 7)  '(#\C . 8)
                                   '(#\a . 9) '(#\B . 10) '(#\c . 11))
                           :key #'car :start 3 :end 9 :test #'char-equal)
        (vector '(#\A . 0) '(#\b . 1)  '(#\C . 2)
                '(#\A . 6) '(#\b . 7)  '(#\C . 8)
                '(#\a . 9) '(#\B . 10) '(#\c . 11)))
(equalp (remove-duplicates (vector '(#\A . 0) '(#\b . 1)  '(#\C . 2)
                                   '(#\a . 3) '(#\B . 4)  '(#\c . 5)
                                   '(#\A . 6) '(#\b . 7)  '(#\C . 8)
                                   '(#\a . 9) '(#\B . 10) '(#\c . 11))
                           :key #'car :start 3 :end 9
                           :test-not (complement #'char-equal))
        (vector '(#\A . 0) '(#\b . 1)  '(#\C . 2)
                '(#\A . 6) '(#\b . 7)  '(#\C . 8)
                '(#\a . 9) '(#\B . 10) '(#\c . 11)))
(equalp (remove-duplicates (vector '(#\A . 0) '(#\b . 1)  '(#\C . 2)
                                   '(#\a . 3) '(#\B . 4)  '(#\c . 5)
                                   '(#\A . 6) '(#\b . 7)  '(#\C . 8)
                                   '(#\a . 9) '(#\B . 10) '(#\c . 11))
                           :key #'car :start 3 :end 9 :test #'char-equal
                           :from-end t)
        (vector '(#\A . 0) '(#\b . 1)  '(#\C . 2)
                '(#\a . 3) '(#\B . 4)  '(#\c . 5)
                '(#\a . 9) '(#\B . 10) '(#\c . 11)))
(equalp (remove-duplicates (vector '(#\A . 0) '(#\b . 1)  '(#\C . 2)
                                   '(#\a . 3) '(#\B . 4)  '(#\c . 5)
                                   '(#\A . 6) '(#\b . 7)  '(#\C . 8)
                                   '(#\a . 9) '(#\B . 10) '(#\c . 11))
                           :key #'car :start 3 :end 9
                           :test-not (complement #'char-equal)
                           :from-end t)
        (vector '(#\A . 0) '(#\b . 1)  '(#\C . 2)
                '(#\a . 3) '(#\B . 4)  '(#\c . 5)
                '(#\a . 9) '(#\B . 10) '(#\c . 11)))
(equalp (remove-duplicates (vector '(#\A . 0) '(#\b . 1)  '(#\C . 2)
                                   '(#\a . 3) '(#\B . 4)  '(#\c . 5)
                                   '(#\A . 6) '(#\b . 7)  '(#\C . 8)
                                   '(#\a . 9) '(#\B . 10) '(#\c . 11))
                           :key #'car :start 3)
        (vector '(#\A . 0) '(#\b . 1)  '(#\C . 2)
                '(#\A . 6) '(#\b . 7)  '(#\C . 8)
                '(#\a . 9) '(#\B . 10) '(#\c . 11)))
(equalp (remove-duplicates (vector '(#\A . 0) '(#\b . 1)  '(#\C . 2)
                                   '(#\a . 3) '(#\B . 4)  '(#\c . 5)
                                   '(#\A . 6) '(#\b . 7)  '(#\C . 8)
                                   '(#\a . 9) '(#\B . 10) '(#\c . 11))
                           :key #'car :start 3 :end nil)
        (vector '(#\A . 0) '(#\b . 1)  '(#\C . 2)
                '(#\A . 6) '(#\b . 7)  '(#\C . 8)
                '(#\a . 9) '(#\B . 10) '(#\c . 11)))
(equalp (remove-duplicates (vector '(#\A . 0) '(#\b . 1)  '(#\C . 2)
                                   '(#\a . 3) '(#\B . 4)  '(#\c . 5)
                                   '(#\A . 6) '(#\b . 7)  '(#\C . 8)
                                   '(#\a . 9) '(#\B . 10) '(#\c . 11))
                           :key #'car :start 3 :from-end t)
        (vector '(#\A . 0) '(#\b . 1)  '(#\C . 2)
                '(#\a . 3) '(#\B . 4)  '(#\c . 5)
                '(#\A . 6) '(#\b . 7)  '(#\C . 8)))
(equalp (remove-duplicates (vector '(#\A . 0) '(#\b . 1)  '(#\C . 2)
                                   '(#\a . 3) '(#\B . 4)  '(#\c . 5)
                                   '(#\A . 6) '(#\b . 7)  '(#\C . 8)
                                   '(#\a . 9) '(#\B . 10) '(#\c . 11))
                           :key #'car :end 9)
        (vector '(#\a . 3) '(#\B . 4)  '(#\c . 5)
                '(#\A . 6) '(#\b . 7)  '(#\C . 8)
                '(#\a . 9) '(#\B . 10) '(#\c . 11)))
(equalp (remove-duplicates (vector '(#\A . 0) '(#\b . 1)  '(#\C . 2)
                                   '(#\a . 3) '(#\B . 4)  '(#\c . 5)
                                   '(#\A . 6) '(#\b . 7)  '(#\C . 8)
                                   '(#\a . 9) '(#\B . 10) '(#\c . 11))
                           :key #'car :end 9 :from-end t)
        (vector '(#\A . 0) '(#\b . 1)  '(#\C . 2)
                '(#\a . 3) '(#\B . 4)  '(#\c . 5)
                '(#\a . 9) '(#\B . 10) '(#\c . 11)))
(equalp (remove-duplicates (vector '(#\A . 0) '(#\b . 1)  '(#\C . 2)
                                   '(#\a . 3) '(#\B . 4)  '(#\c . 5)
                                   '(#\A . 6) '(#\b . 7)  '(#\C . 8)
                                   '(#\a . 9) '(#\B . 10) '(#\c . 11))
                           :key #'car :start 0 :end 12 :test #'char-equal)
        (vector '(#\a . 9) '(#\B . 10) '(#\c . 11)))
(equalp (remove-duplicates (vector '(#\A . 0) '(#\b . 1)  '(#\C . 2)
                                   '(#\a . 3) '(#\B . 4)  '(#\c . 5)
                                   '(#\A . 6) '(#\b . 7)  '(#\C . 8)
                                   '(#\a . 9) '(#\B . 10) '(#\c . 11))
                           :key #'car :start 0 :end 12
                           :test-not (complement #'char-equal))
        (vector '(#\a . 9) '(#\B . 10) '(#\c . 11)))
(equalp (remove-duplicates (vector '(#\A . 0) '(#\b . 1)  '(#\C . 2)
                                   '(#\a . 3) '(#\B . 4)  '(#\c . 5)
                                   '(#\A . 6) '(#\b . 7)  '(#\C . 8)
                                   '(#\a . 9) '(#\B . 10) '(#\c . 11))
                           :key #'car :start 0 :end 12 :test #'char-equal
                           :from-end t)
        #((#\A . 0) (#\b . 1) (#\C . 2)))
(equalp (remove-duplicates (vector '(#\A . 0) '(#\b . 1)  '(#\C . 2)
                                   '(#\a . 3) '(#\B . 4)  '(#\c . 5)
                                   '(#\A . 6) '(#\b . 7)  '(#\C . 8)
                                   '(#\a . 9) '(#\B . 10) '(#\c . 11))
                           :key #'car :start 0 :end 12
                           :test-not (complement #'char-equal) :from-end t)
        #((#\A . 0) (#\b . 1) (#\C . 2)))

(string= (remove-duplicates (copy-seq "")) "")
(string= (remove-duplicates (copy-seq "abc")) "abc")
(string= (remove-duplicates (copy-seq "abcabc")) "abc")
(string= (remove-duplicates (copy-seq "cbaabc")) "abc")
(string= (remove-duplicates (copy-seq "cbaabc") :from-end t) "cba")
(string= (remove-duplicates (copy-seq "cbaabcABCCBA")) "abcCBA")
(string= (remove-duplicates (copy-seq "cbaabcABCCBA") :from-end t) "cbaABC")
(string= (remove-duplicates (copy-seq "cbaabcABCCBA") :key #'char-downcase)
         "CBA")
(string= (remove-duplicates (copy-seq "cbaabcABCCBA")
                            :key #'char-downcase :from-end t)
         "cba")
(string= (remove-duplicates (copy-seq "cbaabcABCCBA") :start 3) "cbaabcCBA")
(string= (remove-duplicates (copy-seq "cbaabcABCCBA") :start 3 :from-end t)
         "cbaabcABC")
(string= (remove-duplicates (copy-seq "cbaabcABCCBA") :start 3 :end 9)
         "cbaabcABCCBA")
(string= (remove-duplicates (copy-seq "cbaabcABCCBA")
                            :start 3 :end 9 :key #'char-upcase)
         "cbaABCCBA")
(string= (remove-duplicates (copy-seq "cbaabcABCCBA")
                            :start 3 :end 9 :key #'char-upcase :from-end t)
         "cbaabcCBA")
(string= (remove-duplicates (copy-seq "cbaabcABCCBA")
                            :start 3 :end 9 :test #'char-equal :from-end t)
         "cbaabcCBA")
(string= (remove-duplicates (copy-seq "cbaabcABCCBA")
                            :start 3 :end 9 :test-not (complement #'char-equal)
                            :from-end t)
         "cbaabcCBA")
(string= (remove-duplicates (copy-seq "cbaabcABCCBA")
                            :start 3 :end 9 :key #'upper-case-p :test #'eq)
         "cbacCCBA")
(string= (remove-duplicates (copy-seq "cbaabcABCCBA")
                            :start 3 :end 9 :key #'upper-case-p :test #'eq
                            :from-end t)
         "cbaaACBA")
(equal (remove-duplicates (copy-seq #*0011)) #*01)
(equal (remove-duplicates (copy-seq #*0110)) #*10)
(equal (remove-duplicates (copy-seq #*0110) :from-end t) #*01)
(equal (remove-duplicates (copy-seq #*0110) :start 1) #*010)
(equal (remove-duplicates (copy-seq #*0001111011000100010)) #*10)
(equal (remove-duplicates (copy-seq #*0001111011000100010) :from-end t) #*01)
(equal (remove-duplicates (copy-seq #*)) #*)
(equal (remove-duplicates (copy-seq #*01)) #*01)
(equal (remove-duplicates (copy-seq #*10)) #*10)
(equal (remove-duplicates (copy-seq #*0)) #*0)
(equal (remove-duplicates (copy-seq #*1)) #*1)
(equal (remove-duplicates (copy-seq #*1001) :start 1 :end 3) #*101)
(equal (remove-duplicates (copy-seq #*01011010) :start 2 :end 6) #*011010)
(equal (remove-duplicates (copy-seq #*01011010) :start 2 :end 6 :from-end t)
       #*010110)
(equal (remove-duplicates (copy-seq #*01011010)
                          :start 2 :end 6 :from-end t
                          :key #'(lambda (arg) (char "aA" arg)))
       #*010110)
(equal (remove-duplicates (copy-seq #*01011010)
                          :start 2 :end 6 :from-end t
                          :key #'(lambda (arg) (char "aA" arg))
                          :test #'char-equal)
       #*01010)
(equal (remove-duplicates (copy-seq #*01011010)
                          :start 2 :end 6 :from-end t
                          :key #'(lambda (arg) (char "aA" arg))
                          :test-not (complement #'char-equal))
       #*01010)
(equal (remove-duplicates (copy-seq #*01011010)
                          :start 2 :end 6
                          :key #'(lambda (arg) (char "aA" arg))
                          :test #'char-equal)
       #*01010)
(equal (remove-duplicates (copy-seq #*01011010)
                          :start 2 :end 6
                          :key #'(lambda (arg) (char "aA" arg))
                          :test-not (complement #'char-equal))
       #*01010)
