/*
 * Copyright 2009 Canonical Ltd.
 * 
 * This program is free software: you can redistribute it and/or modify it 
 * under the terms of either or both of the following licenses:
 *
 * 1) the GNU Lesser General Public License version 3, as published by the 
 * Free Software Foundation; and/or
 * 2) the GNU Lesser General Public License version 2.1, as published by 
 * the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied warranties of 
 * MERCHANTABILITY, SATISFACTORY QUALITY or FITNESS FOR A PARTICULAR 
 * PURPOSE.  See the applicable version of the GNU Lesser General Public 
 * License for more details.
 * 
 * You should have received a copy of both the GNU Lesser General Public 
 * License version 3 and version 2.1 along with this program.  If not, see 
 * <http://www.gnu.org/licenses/>
 *
 * Authored by: Neil Jagdish Patel <neil.patel@canonical.com>
 *
 */

#ifndef _CTK_BIN_H_
#define _CTK_BIN_H_

#include <glib.h>
#include <clutter/clutter.h>
#include <clutk/ctk-actor.h>

G_BEGIN_DECLS

#define CTK_TYPE_BIN (ctk_bin_get_type ())

#define CTK_BIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj),\
	CTK_TYPE_BIN, CtkBin))

#define CTK_BIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass),\
	CTK_TYPE_BIN, CtkBinClass))

#define CTK_IS_BIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj),\
	CTK_TYPE_BIN))

#define CTK_IS_BIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass),\
	CTK_TYPE_BIN))

#define CTK_BIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj),\
	CTK_TYPE_BIN, CtkBinClass))

typedef struct _CtkBin        CtkBin;
typedef struct _CtkBinClass   CtkBinClass;
typedef struct _CtkBinPrivate CtkBinPrivate;
 
struct _CtkBin
{
  CtkActor parent;	

  CtkBinPrivate *priv;
};

struct _CtkBinClass
{
  /*< private >*/
  CtkActorClass  parent_class;

  /*< public >*/
  /* signals, not vfuncs */

  /* vtable */

  /*< private >*/
  /* padding */
  void (*_ctk_padding1) (void);
  void (*_ctk_padding2) (void);
  void (*_ctk_padding3) (void);
  void (*_ctk_padding4) (void);
  void (*_ctk_padding5) (void);
  void (*_ctk_padding6) (void);
};

GType          ctk_bin_get_type (void) G_GNUC_CONST;

ClutterActor * ctk_bin_get_child (CtkBin *bin);

G_END_DECLS

#endif /* _CTK_BIN_H_ */

