/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 * Copyright 2009 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of either or both of the following licenses:
 *
 * 1) the GNU Lesser General Public License version 3, as published by the
 * Free Software Foundation; and/or
 * 2) the GNU Lesser General Public License version 2.1, as published by
 * the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranties of
 * MERCHANTABILITY, SATISFACTORY QUALITY or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the applicable version of the GNU Lesser General Public
 * License for more details.
 *
 * You should have received a copy of both the GNU Lesser General Public
 * License version 3 and version 2.1 along with this program.  If not, see
 * <http://www.gnu.org/licenses/>
 *
 * Authored by: Gordon Allott <gord.allott@canonical.com>
 *
 */
#if HAVE_CONFIG_H
#include <config.h>
#endif

#include "ctk-menu-item.h"
#include <glib.h>
#include "ctk-image-menu-item.h"

#define CTK_IMAGE_MENU_ITEM_GET_PRIVATE(obj) (G_TYPE_INSTANCE_GET_PRIVATE ((obj),\
  CTK_TYPE_IMAGE_MENU_ITEM, \
  CtkImageMenuItemPrivate))

enum
{
  PROP_0,

  PROP_IMAGE
};

struct _CtkImageMenuItemPrivate
{
  GdkPixbuf *image;
};


G_DEFINE_TYPE (CtkImageMenuItem, ctk_image_menu_item, CTK_TYPE_MENU_ITEM);

static void
ctk_image_menu_item_init (CtkImageMenuItem *object)
{
  /* TODO: Add initialization code here */
}

static void
ctk_image_menu_item_finalize (GObject *object)
{
  /* TODO: Add deinitalization code here */

  G_OBJECT_CLASS (ctk_image_menu_item_parent_class)->finalize (object);
}

static void
ctk_image_menu_item_set_property (GObject *object, guint prop_id, const GValue *value, GParamSpec *pspec)
{
  g_return_if_fail (CTK_IS_IMAGE_MENU_ITEM (object));
  CtkImageMenuItem *menuitem = CTK_IMAGE_MENU_ITEM (object);

  switch (prop_id)
    {
      case PROP_IMAGE:
        ctk_image_menu_item_set_image (menuitem, g_value_get_object (value));
        break;
      default:
        G_OBJECT_WARN_INVALID_PROPERTY_ID (object, prop_id, pspec);
        break;
    }
}

static void
ctk_image_menu_item_get_property (GObject *object, guint prop_id, GValue *value, GParamSpec *pspec)
{
  g_return_if_fail (CTK_IS_IMAGE_MENU_ITEM (object));
  CtkImageMenuItem *menuitem = CTK_IMAGE_MENU_ITEM (object);

  switch (prop_id)
    {
      case PROP_IMAGE:
        g_value_set_object (value, ctk_image_menu_item_get_image (menuitem));
        break;
      default:
        G_OBJECT_WARN_INVALID_PROPERTY_ID (object, prop_id, pspec);
        break;
    }
}

static void
ctk_image_menu_item_class_init (CtkImageMenuItemClass *klass)
{
  GObjectClass* object_class = G_OBJECT_CLASS (klass);
  //CtkMenuItemClass* parent_class = CTK_MENU_ITEM_CLASS (klass);

  g_type_class_add_private (klass, sizeof (CtkImageMenuItemPrivate));

  object_class->finalize = ctk_image_menu_item_finalize;
  object_class->set_property = ctk_image_menu_item_set_property;
  object_class->get_property = ctk_image_menu_item_get_property;


  g_object_class_install_property (object_class,
                                   PROP_IMAGE,
                                   g_param_spec_object ("image",
                                                        "image",
                                                        "The image for this widget in GdkPixbuf form",
                                                        GDK_TYPE_PIXBUF,
                                                        G_PARAM_READABLE | G_PARAM_WRITABLE));
}


CtkImageMenuItem *
ctk_image_menu_item_new (void)
{
  CtkImageMenuItem *item;
  item = g_object_new (CTK_TYPE_IMAGE_MENU_ITEM,
                       "label", "",
                       NULL);
  return item;
}

CtkImageMenuItem *
ctk_image_menu_item_new_with_label (const gchar *label)
{
  CtkImageMenuItem *item;
  item = g_object_new (CTK_TYPE_IMAGE_MENU_ITEM,
                       "label", label,
                       NULL);
  return item;
}

void
ctk_image_menu_item_set_image (CtkImageMenuItem *menuitem, GdkPixbuf *pixbuf)
{
  g_return_if_fail (CTK_IS_IMAGE_MENU_ITEM (menuitem));
  g_return_if_fail (GDK_IS_PIXBUF (pixbuf));
  CtkImageMenuItemPrivate *priv = CTK_IMAGE_MENU_ITEM_GET_PRIVATE(menuitem);
  if (priv->image == NULL)
    {
      g_object_unref (priv->image);
      priv->image = NULL;
    }

  priv->image = pixbuf;
  g_object_ref (priv->image);

  g_object_notify (G_OBJECT (menuitem), "image");
}

GdkPixbuf *
ctk_image_menu_item_get_image (CtkImageMenuItem *menuitem)
{
  g_return_val_if_fail (CTK_IS_IMAGE_MENU_ITEM (menuitem), FALSE);
  return CTK_IMAGE_MENU_ITEM_GET_PRIVATE(menuitem)->image;
}
