/*
//
//  Copyright 1997-2009 Torsten Rohlfing
//
//  Copyright 2004-2010 SRI International
//
//  This file is part of the Computational Morphometry Toolkit.
//
//  http://www.nitrc.org/projects/cmtk/
//
//  The Computational Morphometry Toolkit is free software: you can
//  redistribute it and/or modify it under the terms of the GNU General Public
//  License as published by the Free Software Foundation, either version 3 of
//  the License, or (at your option) any later version.
//
//  The Computational Morphometry Toolkit is distributed in the hope that it
//  will be useful, but WITHOUT ANY WARRANTY; without even the implied
//  warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License along
//  with the Computational Morphometry Toolkit.  If not, see
//  <http://www.gnu.org/licenses/>.
//
//  $Revision: 3288 $
//
//  $LastChangedDate: 2011-07-26 16:27:51 -0700 (Tue, 26 Jul 2011) $
//
//  $LastChangedBy: torstenrohlfing $
//
*/

#include <Registration/cmtkVoxelMatchingAffineFunctional.h>

#ifdef CMTK_USE_SMP
#  include <System/cmtkThreads.h>
#endif

#include <Registration/cmtkVoxelMatchingAffineFunctionalTemplate.h>
#include <Registration/cmtkVoxelMatchingMutInf.h>
#include <Registration/cmtkVoxelMatchingNormMutInf.h>
#include <Registration/cmtkVoxelMatchingCorrRatio.h>
#include <Registration/cmtkVoxelMatchingMeanSquaredDifference.h>
#include <Registration/cmtkVoxelMatchingCrossCorrelation.h>

namespace
cmtk
{

/** \addtogroup Registration */
//@{

VoxelMatchingAffineFunctional* 
VoxelMatchingAffineFunctional
::Create
( const int metric, UniformVolume::SmartPtr& refVolume, UniformVolume::SmartPtr& fltVolume, AffineXform::SmartPtr& affineXform )
{
  switch ( fltVolume->GetData()->GetDataClass() ) 
    {
    case DATACLASS_UNKNOWN :
    case DATACLASS_GREY :
      switch ( metric ) 
	{
	case 0:
	  return new VoxelMatchingAffineFunctionalTemplate< VoxelMatchingNormMutInf_Trilinear >( refVolume, fltVolume, affineXform );
	case 1:
	  return new VoxelMatchingAffineFunctionalTemplate<VoxelMatchingMutInf_Trilinear>( refVolume, fltVolume, affineXform );
	case 2:
	  return new VoxelMatchingAffineFunctionalTemplate<VoxelMatchingCorrRatio_Trilinear>( refVolume, fltVolume, affineXform );
	case 3:
	  return NULL; // masked nmi retired
	case 4:
	  return new VoxelMatchingAffineFunctionalTemplate<VoxelMatchingMeanSquaredDifference>( refVolume, fltVolume, affineXform );
	case 5:
	  return new VoxelMatchingAffineFunctionalTemplate<VoxelMatchingCrossCorrelation>( refVolume, fltVolume, affineXform );
	default:
	  break;
	}
      break;
    case DATACLASS_LABEL :
      switch ( metric ) 
	{
	case 0:
	  return new VoxelMatchingAffineFunctionalTemplate<VoxelMatchingNormMutInf_NearestNeighbor>( refVolume, fltVolume, affineXform );
	case 1:
	  return new VoxelMatchingAffineFunctionalTemplate<VoxelMatchingMutInf_NearestNeighbor>( refVolume, fltVolume, affineXform );
	case 2:
	  return new VoxelMatchingAffineFunctionalTemplate<VoxelMatchingCorrRatio_NearestNeighbor>( refVolume, fltVolume, affineXform );
	case 3:
	  return NULL; // masked nmi retired
	case 4:
	  return new VoxelMatchingAffineFunctionalTemplate<VoxelMatchingMeanSquaredDifference>( refVolume, fltVolume, affineXform );
	case 5:
	  return new VoxelMatchingAffineFunctionalTemplate<VoxelMatchingCrossCorrelation>( refVolume, fltVolume, affineXform );
	default:
	  break;
	}
      break;
    }
  
  return NULL;
}

} // namespace cmtk
