#!/usr/bin/perl -w

# cobex_put.pl - v0.1 - fsn - 2003-08-29
# A perl frontend for cobex_put
#
# Copyright (c) 2003 Fredrik Srensson
#

use strict;
use Getopt::Std;

our $COBEX_PUT_BIN="./cobex_put";	# Change this
our $DEVICE_DEFAULT="/dev/ttyUSB0";	# And possibly this also

sub main {
	our $opt_d;
	our $opt_i;
	our $opt_o;

	getopt('iod');

	if (! $opt_i ) {&help; exit(0)}
	if (! -r $opt_i) { print "ERROR: File not readable.\n"; &help; exit(1);}
	my $INFILE=$opt_i;
	my $OUTFILE;

	if (! $opt_o ) {
		$OUTFILE = $opt_i;
		$OUTFILE =~ s/.*\///;
	} else {
		$OUTFILE=$opt_o;
	}

	if (length($OUTFILE) > 20) {print "ERROR: In my opinion, the outfile name is to long.\n"; exit(1);}

	my $DEVICE=(! $opt_d) ? $DEVICE_DEFAULT : $opt_d ;

	system ("$COBEX_PUT_BIN $DEVICE $INFILE $OUTFILE");

	my $val = $? >> 8;

	if ($val == 1 ) {
		print "ERROR: cobex.put got the wrong number of parameters. How?\n";
	} elsif ($val == 2) {
		print "ERROR: The object was rejected.\n";
	} elsif ($val == 3) {
		print "ERROR: The device is full.\n";
	} elsif ($val == 4) {
		print "ERROR: There was some unknown transmission error.\n";
	} elsif ($val == 5) {
		print "ERROR: Couldn't open the device correctly.\n";
	} elsif ($val == 6) {
		print "ERROR: Got a timeout error.\n";
	} elsif ($val == 7) {
		print "ERROR: Couldn't initiate OBEX. Try restarting the device.\n";
	} elsif ($val == 8) {
		print "ERROR: The file has disappered.\n";
	} elsif ($val == 99) {
		print "ERROR: Caught a signal, you should probably restart the device.\n";
	}
}

sub help {
	print "obex_put.pl v0.1\n\n";
	print "Usage: obex_put.pl -i <infile> [-o <name_on_device>] [-d <device>]\n\n";
	print "If -o is omitted, <name_on_device> is built from <infile>.\n";
	print "If -d is omitted, <device> is $DEVICE_DEFAULT.\n";
}

&main;
