/*
*
* tools.h - Common routines for COBEX-programs.
*
* Copyright (c) 2004,2005 Fredrik Srensson
*
* History:
* v0.1 - fsn - 04-01-20 - First version
* v0.5 - fsn - 04-07-08 - Better dump_packet_headers
* v0.6 - fsn - 05-07-19 - Generic signal handlers
*
* NOTE: While cobex_core are fairly stable, cobex_tools ARE NOT! Don't 
* rely on them, they might not even be here tomorrow.
*
*/

#include <sys/types.h>
#include <ezV24/ezV24.h>
#include "cobex_defs.h"
#include "cobex_core.h"

#ifndef __COBEX_TOOLS_H
#define __COBEX_TOOLS_H

typedef struct {
	int connState;
	v24_port_t *port;
} state;

#define CTOOLS_STATE_NOT_CONNECTED	0x00
#define CTOOLS_STATE_CONNECTED		0x01
#define CTOOLS_STATE_INOBEX		0x02

// Nice compund tool functions.

int ctools_connect( v24_port_t *aPort );
int ctools_disconnect( obex_packet *packet, v24_port_t *port ) ;
int ctools_recursePath ( obex_packet *packet, char *path, v24_port_t *port );
int ctools_setPath( obex_packet *packet, char *path, v24_port_t *port );
int ctools_deleteFile( obex_packet *packet, char *name, v24_port_t *port ) ;
int ctools_abort( obex_packet *packet, v24_port_t *port ) ;
int ctools_getFileByName( obex_packet *packet, char *name, v24_port_t *port ) ;
int ctools_getFileByType( obex_packet *packet, char *name, v24_port_t *port ) ;

// Signal handlers, global state functions.

void ctools_installSignalhandler ( void );
void ctools_setup_state ( v24_port_t *port );
void ctools_set_state_not_connected( void ) ;
void ctools_set_state_connected( void ) ;
void ctools_set_state_inobex( void ) ;
int ctools_get_state( void ) ;

/* Build path/filename from a unifrom path. You must malloc enough space */
int ctools_buildPath ( char *inFullPath, char *outPath, char *outName );

int printBody(obex_packet *inPacket) ;
int ctools_recBody( obex_packet *packet, v24_port_t *port ) ;

/* Debug only, you hear? */
void dump_packet_headers ( obex_packet *inPacket);


#endif
