/*
*
* Copyright (c) 2004 Fredrik Srensson
*
*  Demoimplementation, dodetect.c
*
*/

#include <stdio.h>
#include <ezV24/ezV24.h>
#include <signal.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include "detect.h"

const int OK = 0;
const int ERROR_USAGE = 1;
const int ERROR_OBJECT_REJECTED = 2;
const int ERROR_DEVICE_FULL = 3;
const int ERROR_TRANSMISSION_ERROR = 4;
const int ERROR_NO_DEVICE = 5;
const int ERROR_TIMEOUT = 6;
const int ERROR_NO_OBEX = 7;
const int ERROR_NO_SUCH_FILE = 8;
const int ERROR_SIGNAL = 99;

v24_port_t *UsedPort=NULL;

static void mySignalHandler ( int reason ) {
	v24ClosePort(UsedPort);
	exit(ERROR_SIGNAL);
}

static void installSignalhandler ( void ) {
	signal(SIGINT,mySignalHandler);
	signal(SIGTERM,mySignalHandler);
}

void openPort(char *port) {
	int rc;

	// Open Port

	UsedPort=v24OpenPort(port,V24_STANDARD);
	if (UsedPort==NULL) {
		exit(ERROR_NO_DEVICE);
	}

	// Set parameters

	rc=v24SetParameters(UsedPort,V24_B115200,V24_8BIT,V24_NONE);
	if ( rc!=V24_E_OK ) {
		v24ClosePort(UsedPort);
		exit(ERROR_NO_DEVICE);
	}
}

// Wait for lines when doing AT commands.

int waitFor(v24_port_t *aPort, char *msg, int lgt, char *bmsg, int blgt) {
	char answer[80];
	u_int nrC;
	u_int i;

	if (lgt > 79) { return ERROR_TRANSMISSION_ERROR; }

	do {
		nrC=v24Gets(aPort,answer,79);
		for (i=0; i<79; i++) {
			if (answer[i]<32) {answer[i]=0; break;}
		}
		if ( blgt > 0) {
			if (strncmp (answer, bmsg, blgt) ==0 ) return ERROR_TRANSMISSION_ERROR;
		}
		if ( nrC == 0 ) return ERROR_TIMEOUT;
		if ( nrC < 0 ) {
			return ERROR_TRANSMISSION_ERROR;
		}
	} while (strncmp ( answer, msg , lgt) != 0) ;
	return OK;
}

// Dirty rotten flush.

void flushBuffer (v24_port_t *comPort) {
	int rc;
	while (v24HaveData(comPort)>0) {
		rc=v24Getc(comPort);
	}
}

int main (int argc, char *argv[]) {

	char theModel[256];
	char theSoftware[256];
	long capabilities;
	int rc;

	// Init.

	installSignalhandler();
	openPort(argv[1]);

	// Do some init's.

	flushBuffer(UsedPort);
	rc=v24Puts(UsedPort,"\r\r\rATZ\r");
	if ( rc < 7 ) {
		v24ClosePort(UsedPort);
		return ERROR_TRANSMISSION_ERROR;
	} else {
		waitFor(UsedPort,"OK",2,NULL,0);
	}

	// Go! Go! Go!

	rc=detectModel ( theModel, theSoftware, &capabilities, UsedPort );

	if (!rc) {

	// Report.

		printf ("Phone: %s - Software: %s .\n",theModel,theSoftware);
	}

	// Bye!

	v24ClosePort(UsedPort);

	return 0;
}
