/*-------------------------------------------------------------------------
Trace.java -- Trace Output Class
Compiler Generator Coco/R,
Copyright (c) 1990, 2004 Hanspeter Moessenboeck, University of Linz
extended by M. Loeberbauer & A. Woess, Univ. of Linz
ported from C# to Java by Wolfgang Ahorner
with improvements by Pat Terry, Rhodes University

This program is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by the
Free Software Foundation; either version 2, or (at your option) any
later version.

This program is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

As an exception, it is allowed to write an extension of Coco/R that is
used as a plugin in non-free software.

If not otherwise stated, any source code generated by Coco/R (other than
Coco/R itself) does not fall under the GNU General Public License.
------------------------------------------------------------------------*/

package Coco;

import java.io.PrintWriter;     /* pdt */
import java.io.BufferedWriter;  /* pdt */
import java.io.FileWriter;      /* pdt */
import java.io.IOException;

class Trace {
	String fileName;              /* pdt */
	PrintWriter w;

	private void CheckOpen() {
		if (w == null) {
			try {
				w = new PrintWriter(new BufferedWriter(new FileWriter(fileName, false))); /* pdt */
			} catch (IOException e) {
				throw new FatalError("Could not open " + fileName);
			}
		}
	}

	public Trace (String dir) {
		fileName = dir + "trace.txt"; /* pdt */
	}

	// returns a string with a minimum length of |w| characters
	// the string is left-adjusted if w < 0 and right-adjusted otherwise
	public String formatString(String s, int w) {
		int size = s.length();
		StringBuffer b = new StringBuffer();
		if (w >= 0) {
			for (int i = 0; i < w - size; i++) b.append(" ");
			return (b.toString() + s);
		} else {
			for (int i = w; i < -size; i++) b.append(" ");
			return (s + b.toString());
		}
	}

	public void Write (String s) {
		CheckOpen(); w.print(s);
	}

	// writes a string with a minimum length of |w| characters
	public void Write(String s, int w) {
		Write(formatString(s, w));
	}

	public void WriteLine () {
		CheckOpen(); w.println();
	}

	public void WriteLine (String s) {
		CheckOpen(); w.println(s);
	}

	public void WriteLine(String s, int w) {
		CheckOpen(); WriteLine(formatString(s, w));
	}

	public void Close () { /* pdt */
		if (w != null) {
			w.close();
			System.out.println("trace output is in " + fileName);
		}
	}

}