#------------------------------------------------------------------------
#$Author: antanas $
#$Date: 2015-11-09 12:17:48 +0200 (Pr, 09 lapkr. 2015) $ 
#$Revision: 4237 $
#$URL: svn://www.crystallography.net/cod-tools/tags/v2.4/src/lib/perl5/COD/SUsage.pm $
#------------------------------------------------------------------------
#*
#  Simple usage message generator.
#**

package COD::SUsage;

use strict;
use warnings;

require Exporter;
our @ISA = qw(Exporter);
our @EXPORT_OK = qw(
    options
    usage
);

sub usage
{
    my $script = shift;
    $script = $0 unless defined $script;

    open( SCRIPT, $script ) or die("Could not open $script: $!");
    while( <SCRIPT> ) {
        if( /^\s*#\*/ .. /^\s*#\*\*/ ) {
            /^\s*#\*?\*?/;
            my $line = "$'";
            $line =~ s/\$0/$0/g;
            print $line;
        }
    }
    close( SCRIPT );
}

sub options
{
    my $script = shift;
    $script = $0 unless defined $script;

    print "$script: The '--options' option is a placehoder.\n";
    print "$script: It should be replaced by one of the following options:\n";
    open( SCRIPT, $0 ) or die $!;
    while( <SCRIPT> ) {
        if( /^#\*\s+OPTIONS:/../^#\*\*/ ) {
            s/^#\*\s+OPTIONS://;
            s/^#\*\*?//;
            s/\$0/$0/g;
            print;
        }
    }
    close( SCRIPT );
}

1;
