import gtk, gobject, cohoba, re
from os.path import join
import cPickle

from cohoba.houston.Account import Account
import cohoba.houston.AccountStore as AccountStore
from cohoba.common.PyListStore import PyListStore
from cohoba.common.Utils import singleton

ACCOUNTS_FILE = join(cohoba.USER_COHOBA_DIR, "accounts.pickle")

class AccountList(PyListStore):
	__gsignals__ = {
		"account-added" : (gobject.SIGNAL_RUN_LAST, gobject.TYPE_NONE, [gobject.TYPE_PYOBJECT]),
		"account-deleted" : (gobject.SIGNAL_RUN_LAST, gobject.TYPE_NONE, [gobject.TYPE_PYOBJECT]),
	}
	def __init__(self):
		PyListStore.__init__(self)
		
	def add_account(self, account):
		self.append(account)
		account.connect('account-changed', self.on_account_changed)
		self.emit('account-added', account)
		return account
	
	def on_account_changed(self, account):
		iter = self.get_iter_for_object(account)
		if iter == None:
			return

		self.row_changed(self.get_path(iter), iter)
		
	def remove_account(self, account):
		iter = self.get_iter_for_object(account)
		if iter == None:
			return
			
		account.disconnect_account()
		account.delete()
		
		self.remove(iter)
		self.emit('account-deleted', account)
	
	def find(self, conn_path):
		for account in self:
			if account.is_connection(conn_path):
				return account
				
	def load(self):
		accounts = AccountStore.load_all_accounts()
		for account in accounts:
			self.add_account(account)
			
AccountList = singleton(AccountList)
