/**************************************************************************\
 *
 *  This file is part of the Coin 3D visualization library.
 *  Copyright (C) 1998-2003 by Systems in Motion. All rights reserved.
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public License
 *  version 2.1 as published by the Free Software Foundation. See the
 *  file LICENSE.LGPL at the root directory of the distribution for
 *  more details.
 *
 *  If you want to use Coin for applications not compatible with the
 *  LGPL, please contact SIM to acquire a Professional Edition license.
 *
 *  Systems in Motion, Teknobyen, Abels Gate 5, 7030 Trondheim, NORWAY
 *  http://www.sim.no support@sim.no Voice: +47 22114160 Fax: +47 22207097
 *
\**************************************************************************/

/*!
  \class SoMotion3Event SoMotion3Event.h Inventor/events/SoMotion3Event.h
  \brief The SoMotion3Event class contains information about 3D movement
  events.
  \ingroup events

  Motion3 events are generated by devices capable of "3D motion", for
  instance spaceballs. Instances of this class contains information about
  these devices' translations and rotations in all 3 dimensions.

  \sa SoEvent, SoLocation2Event
  \sa SoEventCallback, SoHandleEventAction */

#include <Inventor/events/SoMotion3Event.h>
#include <Inventor/SbName.h>
#include <assert.h>


SO_EVENT_SOURCE(SoMotion3Event);

/*!
  Initialize the type information data.
 */
void
SoMotion3Event::initClass(void)
{
  SO_EVENT_INIT_CLASS(SoMotion3Event, SoEvent);
}

/*!
  Constructor. Resets values for translation and rotation information.
 */
SoMotion3Event::SoMotion3Event(void)
{
  this->translation.setValue(0.0f, 0.0f, 0.0f);
  this->rotation = SbRotation::identity();
}

/*!
  Destructor.
 */
SoMotion3Event::~SoMotion3Event()
{
}

/*!
  Sets the translation value of this event. Method is used by the
  window specific device class(es) generating the event.

  \sa getTranslation()
 */
void
SoMotion3Event::setTranslation(const SbVec3f & t)
{
  this->translation = t;
}

/*!
  Returns translation value. Note that translation are specified relative
  to former events, i.e. the values given here are \e not accumulated
  global coordinates.

  \sa getTime()
 */
const SbVec3f &
SoMotion3Event::getTranslation(void) const
{
  return this->translation;
}

/*!
  Sets the rotation value of this event. Method is used by the
  window specific device class(es) generating the event.
 */
void
SoMotion3Event::setRotation(const SbRotation & r)
{
  this->rotation = r;
}

/*!
  Returns rotational value. Note that rotations are specified relative
  to former events, i.e. the values given here are \e not accumulated
  rotations.

  \sa getTime()
 */
const SbRotation &
SoMotion3Event::getRotation(void) const
{
  return this->rotation;
}
