/************************************************************************** *
 *  This file is part of the Coin 3D visualization library.
 *  Copyright (C) 1998-2008 by Kongsberg SIM.  All rights reserved.
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  ("GPL") version 2 as published by the Free Software Foundation.
 *  See the file LICENSE.GPL at the root directory of this source
 *  distribution for additional information about the GNU GPL.
 *
 *  For using Coin with software that can not be combined with the GNU
 *  GPL, and for taking advantage of the additional benefits of our
 *  support services, please contact Kongsberg SIM about acquiring
 *  a Coin Professional Edition License.
 *
 *  See http://www.coin3d.org/ for more information.
 *
 *  Kongsberg SIM, Postboks 1283, Pirsenteret, 7462 Trondheim, NORWAY.
 *  http://www.sim.no/  sales@sim.no  coin-support@coin3d.org
 *
\**************************************************************************/

#ifndef COIN_INTERNAL
#error this is a private header file
#endif /* !COIN_INTERNAL */

#ifndef SO_TRANSFORMBOXDRAGGER_IV_H
#define SO_TRANSFORMBOXDRAGGER_IV_H

static const char TRANSFORMBOXDRAGGER_draggergeometry[] =
  "#Inventor V2.1 ascii\n"
  "\n"
  "\n"
  "\n"
  "DEF TRANSFORMBOX_INACTIVE_MATERIAL Material { diffuseColor 0.5 0.5 0.5  emissiveColor 0.5 0.5 0.5 }\n"
  "DEF TRANSFORMBOX_ACTIVE_MATERIAL Material { diffuseColor 0.5 0.5 0  emissiveColor 0.5 0.5 0 }\n"
  "DEF TRANSFORMBOX_FEEDBACK_MATERIAL Material { diffuseColor 0.5 0 0.5  emissiveColor 0.5 0 0.5 }\n"
  "\n"
  "\n"
  "\n"
  "\n"
  "\n"
  "\n"
  "DEF TRANSFORMBOX_SOLIDMARKER Cube { width 0.1  height 0.1  depth 0.1 }\n"
  "\n"
  "\n"
  "\n"
  "\n"
  "\n"
  "DEF TRANSFORMBOX_SCALEDRAGPOINTS Group {\n"
  "   Separator {\n"
  "      Translation { translation 1.1 1.1 1.1 }\n"
  "      USE TRANSFORMBOX_SOLIDMARKER\n"
  "   }\n"
  "   Separator {\n"
  "      Translation { translation 1.1 1.1 -1.1 }\n"
  "      USE TRANSFORMBOX_SOLIDMARKER\n"
  "   }\n"
  "   Separator {\n"
  "      Translation { translation 1.1 -1.1 1.1 }\n"
  "      USE TRANSFORMBOX_SOLIDMARKER\n"
  "   }\n"
  "   Separator {\n"
  "      Translation { translation 1.1 -1.1 -1.1 }\n"
  "      USE TRANSFORMBOX_SOLIDMARKER\n"
  "   }\n"
  "   Separator {\n"
  "      Translation { translation -1.1 1.1 1.1 }\n"
  "      USE TRANSFORMBOX_SOLIDMARKER\n"
  "   }\n"
  "   Separator {\n"
  "      Translation { translation -1.1 1.1 -1.1 }\n"
  "      USE TRANSFORMBOX_SOLIDMARKER\n"
  "   }\n"
  "   Separator {\n"
  "      Translation { translation -1.1 -1.1 1.1 }\n"
  "      USE TRANSFORMBOX_SOLIDMARKER\n"
  "   }\n"
  "   Separator {\n"
  "      Translation { translation -1.1 -1.1 -1.1 }\n"
  "      USE TRANSFORMBOX_SOLIDMARKER\n"
  "   }\n"
  "}\n"
  "\n"
  "DEF transformBoxScalerScaler Separator {\n"
  "   USE TRANSFORMBOX_INACTIVE_MATERIAL\n"
  "   USE TRANSFORMBOX_SCALEDRAGPOINTS\n"
  "}\n"
  "\n"
  "DEF transformBoxScalerScalerActive Separator {\n"
  "   USE TRANSFORMBOX_ACTIVE_MATERIAL\n"
  "   USE TRANSFORMBOX_SCALEDRAGPOINTS\n"
  "}\n"
  "\n"
  "DEF transformBoxScalerFeedback Separator { }\n"
  "DEF transformBoxScalerFeedbackActive Separator { }\n"
  "\n"
  "\n"
  "\n"
  "\n"
  "DEF TRANSFORMBOX_ROTATION_MARKER Cube { width 0.04  height 2.2  depth 0.04 }\n"
  "\n"
  "DEF TRANSFORMBOX_ROTATE_SIDE Group {\n"
  "   Separator {\n"
  "      Translation { translation 1.1 0 1.1 }\n"
  "      USE TRANSFORMBOX_ROTATION_MARKER\n"
  "   }\n"
  "   Separator {\n"
  "      Translation { translation 1.1 0 -1.1 }\n"
  "      USE TRANSFORMBOX_ROTATION_MARKER\n"
  "   }\n"
  "   Separator {\n"
  "      Translation { translation -1.1 0 1.1 }\n"
  "      USE TRANSFORMBOX_ROTATION_MARKER\n"
  "   }\n"
  "   Separator {\n"
  "      Translation { translation -1.1 0 -1.1 }\n"
  "      USE TRANSFORMBOX_ROTATION_MARKER\n"
  "   }\n"
  "}\n"
  "\n"
  "DEF transformBoxRotatorRotator Separator {\n"
  "   USE TRANSFORMBOX_INACTIVE_MATERIAL\n"
  "   USE TRANSFORMBOX_ROTATE_SIDE \n"
  "}\n"
  "DEF transformBoxRotatorRotatorActive Separator {\n"
  "   USE TRANSFORMBOX_ACTIVE_MATERIAL\n"
  "   USE TRANSFORMBOX_ROTATE_SIDE \n"
  "}\n"
  "\n"
  "DEF transformBoxRotatorFeedback Separator { }\n"
  "\n"
  "DEF transformBoxRotatorFeedbackActive Separator {\n"
  "   USE TRANSFORMBOX_FEEDBACK_MATERIAL\n"
  "   Coordinate3 { point [ 0 1.2 0, 0 -1.2 0 ] }\n"
  "   IndexedLineSet { coordIndex [ 0, 1, -1 ] }\n"
  "}\n"
  "\n"
  "\n"
  "\n"
  "\n"
  "DEF TRANSFORMBOX_TRANSLATIONSIDE Separator {\n"
  "   DrawStyle { style INVISIBLE }\n"
  "   Coordinate3 { point [ 1.1 1.1 1.1, -1.1 1.1 1.1, -1.1 -1.1 1.1, 1.1 -1.1 1.1 ] }\n"
  "   IndexedFaceSet { coordIndex [ 0, 1, 2, 3, -1 ] }\n"
  "}\n"
  "\n"
  "DEF transformBoxTranslatorTranslator Separator {\n"
  "   USE TRANSFORMBOX_TRANSLATIONSIDE\n"
  "}\n"
  "\n"
  "DEF transformBoxTranslatorTranslatorActive Separator {\n"
  "   USE TRANSFORMBOX_TRANSLATIONSIDE\n"
  "}\n"
  "\n"
  "DEF transformBoxTranslatorXAxisFeedback Separator {\n"
  "   DEF TRANSFORMBOX_FEEDBACK_AXIS Group {\n"
  "      USE TRANSFORMBOX_FEEDBACK_MATERIAL\n"
  "      Coordinate3 { point [ 0.5 0 1.1, -0.5 0 1.1 ] }\n"
  "      IndexedLineSet { coordIndex [ 0, 1, -1 ] }\n"
  "      Separator {\n"
  "         Rotation { rotation 0 0 1  1.57 }\n"
  "         DEF TRANSFORMBOX_FEEDBACK_MARKER Group {\n"
  "            Translation { translation 0 0.5 1.1 }\n"
  "            Cone { bottomRadius 0.04  height 0.08 }\n"
  "         }\n"
  "      }\n"
  "      Separator {\n"
  "         Rotation { rotation 0 0 1  -1.57 }\n"
  "         USE TRANSFORMBOX_FEEDBACK_MARKER\n"
  "      }\n"
  "   }\n"
  "}\n"
  "\n"
  "DEF transformBoxTranslatorYAxisFeedback Separator {\n"
  "   Rotation { rotation 0 0 1  -1.57 }\n"
  "   USE TRANSFORMBOX_FEEDBACK_AXIS\n"
  "}\n";

#endif /* ! SO_TRANSFORMBOXDRAGGER_IV_H */
