
#ifndef __SEARCHHELPER_H
#define __SEARCHHELPER_H

#include <QGLViewer/vec.h>
#include <QGLViewer/camera.h>
#include <QGLViewer/qglviewer.h>

class SearchHelper {
  public:
  static void order_strings(const char *baseword, const char *strs, int *res);
};

class SearchHelperView {
  char *_str, *_dispstr;
  bool _infocus;
  int _posx, _posy;
  void update_dispstr(void);
  public:
  SearchHelperView(int posx, int posy);
  void draw(QGLViewer &g);
  void add_character(char c);
  void cycle_search(void);
  bool do_backspace(void);
  bool can_eat_character(char c);
  bool eat_character(char c);
  char *get_str(void);
  ~SearchHelperView(void);
};

#endif

