#include <glib.h>
#include "timeframe.h"

static GTimer *cur;

static double get_time_glib(void)
{
  double retval = g_timer_elapsed(cur, NULL);
  return retval;
}

TimeFrame::~TimeFrame(void)
{
}

TimeFrame::TimeFrame(double time_dilation_factor)
{
  do_init(time_dilation_factor);
}

double TimeFrame::time_dilation(void) const
{
  return _time_dilation;
}

void TimeFrame::do_init(double time_dilation_factor)
{
  _time_dilation = time_dilation_factor;

  _seqno = 0;

  if (cur == 0) {
    cur = g_timer_new();
    g_timer_start(cur);
  }

  _t0 = get_time_glib();
  _t = _t0;
  _dt = 0;

  set_time();

}

double TimeFrame::get_dt(void) const
{
  return _dt * _time_dilation;
}

void TimeFrame::set_time(void)
{
  double tnow = get_time_glib();
  _dt = tnow - _t;
  _t = tnow;
  _seqno += 1;
}

double TimeFrame::get_time_undilated(void) const
{
  return (_t-_t0);
}

double TimeFrame::get_time(void) const
{
  return (_t-_t0)*_time_dilation;
}

int TimeFrame::get_seqno(void) const
{
  return _seqno;
}

TimeFrame::TimeFrame(const TimeFrame& tf) {
  do_init(tf.time_dilation());
}
