/*
 * Decompiled with CFR 0.152.
 */
package jnt.scimark2;

import jnt.scimark2.FFT;
import jnt.scimark2.LU;
import jnt.scimark2.MonteCarlo;
import jnt.scimark2.Random;
import jnt.scimark2.SOR;
import jnt.scimark2.SparseCompRow;
import jnt.scimark2.Stopwatch;

public class kernel {
    public static double measureFFT(int n, double d, Random random) {
        double[] dArray = kernel.RandomVector(2 * n, random);
        double[] dArray2 = kernel.NewVectorCopy(dArray);
        long l = 1L;
        Stopwatch stopwatch = new Stopwatch();
        while (true) {
            stopwatch.start();
            int n2 = 0;
            while ((long)n2 < l) {
                FFT.transform(dArray);
                FFT.inverse(dArray);
                ++n2;
            }
            stopwatch.stop();
            if (stopwatch.read() >= d) break;
            l *= 2L;
        }
        if (FFT.test(dArray) / (double)n > 1.0E-10) {
            return 0.0;
        }
        return FFT.num_flops(n) * (double)l / stopwatch.read() * 1.0E-6;
    }

    public static double measureSOR(int n, double d, Random random) {
        double[][] dArray = kernel.RandomMatrix(n, n, random);
        Stopwatch stopwatch = new Stopwatch();
        int n2 = 1;
        while (true) {
            stopwatch.start();
            SOR.execute(1.25, dArray, n2);
            stopwatch.stop();
            if (stopwatch.read() >= d) break;
            n2 *= 2;
        }
        return SOR.num_flops(n, n, n2) / stopwatch.read() * 1.0E-6;
    }

    public static double measureMonteCarlo(double d, Random random) {
        Stopwatch stopwatch = new Stopwatch();
        int n = 1;
        while (true) {
            stopwatch.start();
            MonteCarlo.integrate(n);
            stopwatch.stop();
            if (stopwatch.read() >= d) break;
            n *= 2;
        }
        return MonteCarlo.num_flops(n) / stopwatch.read() * 1.0E-6;
    }

    public static double measureSparseMatmult(int n, int n2, double d, Random random) {
        int n3;
        double[] dArray = kernel.RandomVector(n, random);
        double[] dArray2 = new double[n];
        int n4 = n2 / n;
        int n5 = n4 * n;
        double[] dArray3 = kernel.RandomVector(n5, random);
        int[] nArray = new int[n5];
        int[] nArray2 = new int[n + 1];
        nArray2[0] = 0;
        for (int i = 0; i < n; ++i) {
            int n6 = nArray2[i];
            nArray2[i + 1] = n6 + n4;
            n3 = i / n4;
            if (n3 < 1) {
                n3 = 1;
            }
            for (int j = 0; j < n4; ++j) {
                nArray[n6 + j] = j * n3;
            }
        }
        Stopwatch stopwatch = new Stopwatch();
        n3 = 1;
        while (true) {
            stopwatch.start();
            SparseCompRow.matmult(dArray2, dArray3, nArray2, nArray, dArray, n3);
            stopwatch.stop();
            if (stopwatch.read() >= d) break;
            n3 *= 2;
        }
        return SparseCompRow.num_flops(n, n2, n3) / stopwatch.read() * 1.0E-6;
    }

    public static double measureLU(int n, double d, Random random) {
        double[][] dArray = kernel.RandomMatrix(n, n, random);
        double[][] dArray2 = new double[n][n];
        int[] nArray = new int[n];
        Stopwatch stopwatch = new Stopwatch();
        int n2 = 1;
        while (true) {
            stopwatch.start();
            for (int i = 0; i < n2; ++i) {
                kernel.CopyMatrix(dArray2, dArray);
                LU.factor(dArray2, nArray);
            }
            stopwatch.stop();
            if (stopwatch.read() >= d) break;
            n2 *= 2;
        }
        double[] dArray3 = kernel.RandomVector(n, random);
        double[] dArray4 = kernel.NewVectorCopy(dArray3);
        LU.solve(dArray2, nArray, dArray4);
        if (kernel.normabs(dArray3, kernel.matvec(dArray, dArray4)) / (double)n > 1.0E-12) {
            return 0.0;
        }
        return LU.num_flops(n) * (double)n2 / stopwatch.read() * 1.0E-6;
    }

    private static double[] NewVectorCopy(double[] dArray) {
        int n = dArray.length;
        double[] dArray2 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray2[i] = dArray[i];
        }
        return dArray2;
    }

    private static void CopyVector(double[] dArray, double[] dArray2) {
        int n = dArray2.length;
        for (int i = 0; i < n; ++i) {
            dArray[i] = dArray2[i];
        }
    }

    private static double normabs(double[] dArray, double[] dArray2) {
        int n = dArray.length;
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            d += Math.abs(dArray[i] - dArray2[i]);
        }
        return d;
    }

    private static void CopyMatrix(double[][] dArray, double[][] dArray2) {
        int n = dArray2.length;
        int n2 = dArray2[0].length;
        int n3 = n2 & 3;
        for (int i = 0; i < n; ++i) {
            double[] dArray3 = dArray[i];
            double[] dArray4 = dArray2[i];
            for (int j = 0; j < n3; ++j) {
                dArray3[j] = dArray4[j];
            }
            for (int j = n3; j < n2; j += 4) {
                dArray3[j] = dArray4[j];
                dArray3[j + 1] = dArray4[j + 1];
                dArray3[j + 2] = dArray4[j + 2];
                dArray3[j + 3] = dArray4[j + 3];
            }
        }
    }

    private static double[][] RandomMatrix(int n, int n2, Random random) {
        double[][] dArray = new double[n][n2];
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n2; ++j) {
                dArray[i][j] = random.nextDouble();
            }
        }
        return dArray;
    }

    private static double[] RandomVector(int n, Random random) {
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = random.nextDouble();
        }
        return dArray;
    }

    private static double[] matvec(double[][] dArray, double[] dArray2) {
        int n = dArray2.length;
        double[] dArray3 = new double[n];
        kernel.matvec(dArray, dArray2, dArray3);
        return dArray3;
    }

    private static void matvec(double[][] dArray, double[] dArray2, double[] dArray3) {
        int n = dArray.length;
        int n2 = dArray[0].length;
        for (int i = 0; i < n; ++i) {
            double d = 0.0;
            double[] dArray4 = dArray[i];
            for (int j = 0; j < n2; ++j) {
                d += dArray4[j] * dArray2[j];
            }
            dArray3[i] = d;
        }
    }
}

