import birdbath.Schedd;
import java.net.URL;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;

public abstract class AbstractScheddTestCase
	extends TestCase
{
	protected Schedd schedd;

	protected void setUp()
		throws Exception
	{
		String endpoint = System.getProperty("SCHEDD_ENDPOINT");
		if (null == endpoint)
		{
			throw new AssertionFailedError("Please set property SCHEDD_ENDPOINT.");
		}

		schedd = new Schedd(new URL(endpoint));
	}

	protected void tearDown()
		throws Exception
	{
		schedd = null;
	}
}
