# $Progeny$

# firstboot.py - shim firstboot module that hooks the configlets in

import sys
import os

import pygtk
pygtk.require("2.0")

import gtk
import configlet

import functions

sys.path.append("/usr/share/configlet-frontends")
import fbhelper

class childWindow:
    def __init__(self):
        self.widget = None

        # This module operates via symlinks; the module is symlinked
        # to the firstboot directory with the name of the configlet
        # in question.  The module name will be provided to us via
        # the "__name__" attribute.  This should allow us to figure
        # out which configlet we're supposed to work with and load
        # it.

        configlet.set_privileged_runner(configlet.SimplePrivilegedRunner())

        configlet_name = __name__
        configlet_path = "/usr/share/configlets/" + configlet_name
        if not os.path.isdir(configlet_path):
            for dir in os.listdir("/usr/share/configlets"):
                if dir[:len(configlet_name)] == configlet_name:
                    configlet_path = "/usr/share/configlets/" + dir
                    break

        self.configlet = configlet.start_configlet(configlet_path)

        if self.configlet:
            fbhelper.on_init(self.configlet)
            self.runPriority = fbhelper.fix_priority(self.configlet)
            self.moduleName = self.configlet.get_display_title()
        else:
            self.runPriority = 499
            self.moduleName = "ERROR: " + configlet_name

    def launch(self, doDebug = None):
        if not self.configlet:
            raise RuntimeError, "could not initialize configlet"

        fbhelper.on_launch(self.configlet)

        if len(self.configlet.get_page_names()) > 1:
            self.widget = gtk.Notebook()
            self.widget.set_tab_pos(gtk.POS_TOP)

            for page in self.configlet.get_page_names():
                pagename = self.configlet.get_page_display_title(page)
                c_label = gtk.Label(pagename)
                c_label.show()
                c_pagewidget = self.configlet.get_widget(page)
                c_pagewidget.unparent()
                self.widget.append_page(c_pagewidget, c_label)
                c_pagewidget.show()
        else:
            self.widget = self.configlet.get_widget()
            self.widget.unparent()

        self.vbox = gtk.VBox()
        self.vbox.pack_start(self.widget)

        title_pix = gtk.Label("")
        return (self.vbox, title_pix, self.configlet.get_display_title())

    def apply(self, notebook):
        fbhelper.on_apply(self.configlet)

        return 0

    def exit(self):
        fbhelper.on_exit(self.configlet)
