/*
 *  Author:       Serg Stoyan
 *
 *  Class:        SessionWindow : NSObject
 *
 *  Description:  Window with PPP session selection. After connection is
 *                established shows statistics or PPP log information.
 *                Open and close connection.
 */

@class NSString;
@class NSConnection;

@class NSWindow;
@class NSBox;
@class NSTextField;
@class NSButton;
@class NSPopUpButton;
@class NSScrollView;
@class NSTextView;

@class PPPSession;

@interface SessionWindow : NSObject
{
  NSWindow       *window;
  NSBox          *sessionBox;
  NSTextField    *sessionLabel;
  NSPopUpButton  *sessionPopup;
  NSTextField    *statusMessage;
  
  NSBox          *loginBox;
  NSTextField    *usernameLabel;
  NSTextField    *usernameTF;
  NSTextField    *passwordLabel;
  NSTextField    *passwordTF;
  NSButton       *cancelButton;
  NSButton       *connectButton;
  NSButton       *detailsButton;

  NSScrollView   *detailsScroll;
  NSTextView     *detailsText;
  
  PPPSession     *pppSession;
  NSConnection   *mainConnection;

  NSString       *selectedSession;
}

- (void) orderFront: (id)sender;

- (NSString *) getSelectedSessionName;

- (void) updateSessionsList;

- (void) clearDetailsView;

- (void) addTextToDetailsView: (NSString *)text;

@end

@interface SessionWindow (Thread)

- (void) startPPPSession;

- (oneway void) finishPPPSession;

- (oneway void) statsPPPSession;

- (oneway void) setServer: (id)anObject;

- (oneway void) processServerText: (NSString *)text;

- (oneway void) processStatusText: (NSString *)text;

@end

