/*
    This file is part of the KDE project.
    Copyright (c) 2006 Friedrich W. H. Kossebau <Friedrich.W.H@Kossebau.de>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License version 2 as published by the Free Software Foundation.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Steet, Fifth Floor,
    Boston, MA 02110-1301  USA
*/


#ifndef CONTACTSMENU_H
#define CONTACTSMENU_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// qt specific
#include <qstring.h>
// kde specific
#include <kabc/addresseelist.h>
#include <kabc/stdaddressbook.h>
#include <kpanelmenu.h>
// menu specific
#include "topcontactlistmenufiller.h"

using namespace KABC;


class ContactsMenu : public KPanelMenu
{
    Q_OBJECT

public:
    ContactsMenu( QWidget *Parent, const char *Name, const QStringList &/*args*/ );
    virtual ~ContactsMenu();

public: // KPanelMenu API
    virtual void initialize();
    virtual void slotExec(int id);

protected: // KPanelMenu API
    virtual void slotClear();

protected slots:
    void launchAddressbook();

protected:
    AddresseeList AddressList;
    TopContactListMenuFiller Filler;
};

#endif
