/*
    This file is part of the KDE project.
    Copyright (c) 2006 Friedrich W. H. Kossebau <Friedrich.W.H@Kossebau.de>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License version 2 as published by the Free Software Foundation.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Steet, Fifth Floor,
    Boston, MA 02110-1301  USA
*/

// qt specific
#include <qpopmenu.h>
// kde specific
#include <kapp.h>
#include <klocale.h>
#include <kiconloader.h>
// menu specific
#include "lazyfillmenu.h"
#include "emailmenufiller.h"

static const int EmailBaseId = 1000;


void EmailMenuFiller::createEntry( const KABC::Addressee Contact, QPopupMenu *Menu )
{
    int NoOfEmails = Contact.emails().size();
    if( NoOfEmails > 0 )
    {
        LazyFillMenu *SubMenu = new LazyFillMenu( new EmailMenuFiller(Contact), false, Menu );
        Menu->insertItem( SmallIconSet("email"), 
                          NoOfEmails==1?i18n("&Email address"):i18n("&Email addresses"), SubMenu );
    }
}


EmailMenuFiller::EmailMenuFiller( const KABC::Addressee C )
: Contact( C )
{
}


void EmailMenuFiller::fill( QPopupMenu *Menu )
{
    connect( Menu, SIGNAL(activated(int)), this, SLOT(send(int)) );

    const QStringList EmailAddresses = Contact.emails();
    int i = EmailBaseId;
    QStringList::ConstIterator it = EmailAddresses.begin();
    while( it != EmailAddresses.end() )
        Menu->insertItem( protectAmpersand(*it++), i++ );
}



void EmailMenuFiller::send( int id )
{
//     if( id >= EmailBaseId )
    {
        kapp->invokeMailer( Contact.fullEmail(Contact.emails()[id-EmailBaseId]), QString::null );
    }
}

#include "emailmenufiller.moc"
