-- filename : char-mth.lua
-- comment  : companion to char-mth.tex (in ConTeXt)
-- author   : Hans Hagen, PRAGMA-ADE, Hasselt NL
-- license  : see context related readme files
-- comment  : generated from data file downloaded from STIX website

if not versions   then versions   = { } end versions['char-mth'] = 1.001
if not characters then characters = { } end
        
characters.math = {
	[0x00020] = { mathclass='unknown', adobename='space' },
	[0x00021] = { mathclass='punctuation', adobename='exclam', texname='exclam' },
	[0x00022] = { mathclass='unknown', adobename='quotedbl', texname='textquotedbl' },
	[0x00023] = { mathclass='normal', adobename='numbersign', texname='#' },
	[0x00024] = { mathclass='normal', adobename='dollar', texname='textdollar' },
	[0x00025] = { mathclass='normal', adobename='percent', texname='%' },
	[0x00026] = { mathclass='normal', adobename='ampersand', texname='&' },
	[0x00027] = { mathclass='unknown', adobename='quotesingle' },
	[0x00028] = { mathclass='opening', adobename='parenleft', texname='lparen' },
	[0x00029] = { mathclass='closing', adobename='parenright', texname='rparen' },
	[0x0002A] = { mathclass='normal', adobename='asterisk' },
	[0x0002B] = { mathclass='binary', adobename='plus', texname='plus' },
	[0x0002C] = { mathclass='punctuation', adobename='comma' },
	[0x0002D] = { mathclass='unknown', adobename='hyphen' },
	[0x0002E] = { mathclass='punctuation', adobename='period' },
	[0x0002F] = { mathclass='relation', adobename='slash' },
	[0x00030] = { mathclass='normal', adobename='zero' },
	[0x00031] = { mathclass='normal', adobename='one' },
	[0x00032] = { mathclass='normal', adobename='two' },
	[0x00033] = { mathclass='normal', adobename='three' },
	[0x00034] = { mathclass='normal', adobename='four' },
	[0x00035] = { mathclass='normal', adobename='five' },
	[0x00036] = { mathclass='normal', adobename='six' },
	[0x00037] = { mathclass='normal', adobename='seven' },
	[0x00038] = { mathclass='normal', adobename='eight' },
	[0x00039] = { mathclass='normal', adobename='nine' },
	[0x0003A] = { mathclass='punctuation', adobename='colon' },
	[0x0003B] = { mathclass='punctuation', adobename='semicolon', texname='semicolon' },
	[0x0003C] = { mathclass='relation', adobename='less', texname='less' },
	[0x0003D] = { mathclass='relation', adobename='equal', texname='equal' },
	[0x0003E] = { mathclass='relation', adobename='greater', texname='greater' },
	[0x0003F] = { mathclass='punctuation', adobename='question' },
	[0x00040] = { mathclass='normal', adobename='at', texname='textatsign' },
	[0x00041] = { mathclass='alphabetic', adobename='A' },
	[0x00042] = { mathclass='alphabetic', adobename='B' },
	[0x00043] = { mathclass='alphabetic', adobename='C' },
	[0x00044] = { mathclass='alphabetic', adobename='D' },
	[0x00045] = { mathclass='alphabetic', adobename='E' },
	[0x00046] = { mathclass='alphabetic', adobename='F' },
	[0x00047] = { mathclass='alphabetic', adobename='G' },
	[0x00048] = { mathclass='alphabetic', adobename='H' },
	[0x00049] = { mathclass='alphabetic', adobename='I' },
	[0x0004A] = { mathclass='alphabetic', adobename='J' },
	[0x0004B] = { mathclass='alphabetic', adobename='K' },
	[0x0004C] = { mathclass='alphabetic', adobename='L' },
	[0x0004D] = { mathclass='alphabetic', adobename='M' },
	[0x0004E] = { mathclass='alphabetic', adobename='N' },
	[0x0004F] = { mathclass='alphabetic', adobename='O' },
	[0x00050] = { mathclass='alphabetic', adobename='P' },
	[0x00051] = { mathclass='alphabetic', adobename='Q' },
	[0x00052] = { mathclass='alphabetic', adobename='R' },
	[0x00053] = { mathclass='alphabetic', adobename='S' },
	[0x00054] = { mathclass='alphabetic', adobename='T' },
	[0x00055] = { mathclass='alphabetic', adobename='U' },
	[0x00056] = { mathclass='alphabetic', adobename='V' },
	[0x00057] = { mathclass='alphabetic', adobename='W' },
	[0x00058] = { mathclass='alphabetic', adobename='X' },
	[0x00059] = { mathclass='alphabetic', adobename='Y' },
	[0x0005A] = { mathclass='alphabetic', adobename='Z' },
	[0x0005B] = { mathclass='opening', adobename='bracketleft', texname='lbrack' },
	[0x0005C] = { mathclass='normal', adobename='backslash', texname='backslash' },
	[0x0005D] = { mathclass='closing', adobename='bracketright', texname='rbrack' },
	[0x0005E] = { mathclass='unknown', adobename='asciicircum', texname='textasciicircum' },
	[0x0005F] = { mathclass='unknown', adobename='underscore', texname='textunderscore' },
	[0x00060] = { mathclass='unknown', adobename='grave', texname='textasciigrave' },
	[0x00061] = { mathclass='alphabetic', adobename='a' },
	[0x00062] = { mathclass='alphabetic', adobename='b' },
	[0x00063] = { mathclass='alphabetic', adobename='c' },
	[0x00064] = { mathclass='alphabetic', adobename='d' },
	[0x00065] = { mathclass='alphabetic', adobename='e' },
	[0x00066] = { mathclass='alphabetic', adobename='f' },
	[0x00067] = { mathclass='alphabetic', adobename='g' },
	[0x00068] = { mathclass='alphabetic', adobename='h' },
	[0x00069] = { mathclass='alphabetic', adobename='i' },
	[0x0006A] = { mathclass='alphabetic', adobename='j' },
	[0x0006B] = { mathclass='alphabetic', adobename='k' },
	[0x0006C] = { mathclass='alphabetic', adobename='l' },
	[0x0006D] = { mathclass='alphabetic', adobename='m' },
	[0x0006E] = { mathclass='alphabetic', adobename='n' },
	[0x0006F] = { mathclass='alphabetic', adobename='o' },
	[0x00070] = { mathclass='alphabetic', adobename='p' },
	[0x00071] = { mathclass='alphabetic', adobename='q' },
	[0x00072] = { mathclass='alphabetic', adobename='r' },
	[0x00073] = { mathclass='alphabetic', adobename='s' },
	[0x00074] = { mathclass='alphabetic', adobename='t' },
	[0x00075] = { mathclass='alphabetic', adobename='u' },
	[0x00076] = { mathclass='alphabetic', adobename='v' },
	[0x00077] = { mathclass='alphabetic', adobename='w' },
	[0x00078] = { mathclass='alphabetic', adobename='x' },
	[0x00079] = { mathclass='alphabetic', adobename='y' },
	[0x0007A] = { mathclass='alphabetic', adobename='z' },
	[0x0007B] = { mathclass='opening', adobename='braceleft', texname='lbrace' },
	[0x0007C] = { mathclass='fence', adobename='bar', texname='vert' },
	[0x0007D] = { mathclass='closing', adobename='braceright', texname='rbrace' },
	[0x0007E] = { mathclass='unknown', adobename='asciitilde', texname='textasciitilde' },
	[0x0007F] = { mathclass='unknown', adobename='uni007F' },
	[0x000A0] = { mathclass='unknown', adobename='uni00A0' },
	[0x000A1] = { mathclass='punctuation', adobename='exclamdown', texname='textexclamdown' },
	[0x000A2] = { mathclass='normal', adobename='cent', texname='textcent' },
	[0x000A3] = { mathclass='normal', adobename='sterling', texname='sterling' },
	[0x000A4] = { mathclass='normal', adobename='currency', texname='textcurrency' },
	[0x000A5] = { mathclass='normal', adobename='yen', texname='yen' },
	[0x000A6] = { mathclass='normal', adobename='brokenbar', texname='textbrokenbar' },
	[0x000A7] = { mathclass='normal', adobename='section', texname='S' },
	[0x000A8] = { mathclass='unknown', adobename='dieresis', texname='textasciidieresis' },
	[0x000A9] = { mathclass='normal', adobename='copyright', texname='textcopyright' },
	[0x000AA] = { mathclass='unknown', adobename='ordfeminine', texname='textordfeminine' },
	[0x000AB] = { mathclass='opening', adobename='guillemotleft', texname='guillemotleft' },
	[0x000AC] = { mathclass='normal', adobename='logicalnot', texname='neg' },
	[0x000AD] = { mathclass='unknown', adobename='uni00AD' },
	[0x000AE] = { mathclass='normal', adobename='registered', texname='textregistered' },
	[0x000AF] = { mathclass='unknown', adobename='macron', texname='textasciimacron' },
	[0x000B0] = { mathclass='normal', adobename='degree', texname='textdegree' },
	[0x000B1] = { mathclass='binary', adobename='plusminus', texname='pm' },
	[0x000B2] = { mathclass='unknown', adobename='twosuperior', texname='texttwosuperior' },
	[0x000B3] = { mathclass='unknown', adobename='threesuperior', texname='textthreesuperior' },
	[0x000B4] = { mathclass='unknown', adobename='acute', texname='textasciiacute' },
	[0x000B5] = { mathclass='normal', adobename='mu', texname='textmu' },
	[0x000B6] = { mathclass='normal', adobename='paragraph', texname='P' },
	[0x000B7] = { mathclass='binary', adobename='periodcentered', texname='cdotp' },
	[0x000B8] = { mathclass='unknown', adobename='cedilla' },
	[0x000B9] = { mathclass='unknown', adobename='onesuperior', texname='textonesuperior' },
	[0x000BA] = { mathclass='unknown', adobename='ordmasculine', texname='textordmasculine' },
	[0x000BB] = { mathclass='closing', adobename='guillemotright', texname='guillemotright' },
	[0x000BC] = { mathclass='unknown', adobename='onequarter', texname='textonequarter' },
	[0x000BD] = { mathclass='unknown', adobename='onehalf', texname='textonehalf' },
	[0x000BE] = { mathclass='unknown', adobename='threequarters', texname='textthreequarters' },
	[0x000BF] = { mathclass='punctuation', adobename='questiondown', texname='textquestiondown' },
	[0x000C0] = { mathclass='alphabetic', adobename='Agrave' },
	[0x000C1] = { mathclass='alphabetic', adobename='Aacute' },
	[0x000C2] = { mathclass='alphabetic', adobename='Acircumflex' },
	[0x000C3] = { mathclass='alphabetic', adobename='Atilde' },
	[0x000C4] = { mathclass='alphabetic', adobename='Adieresis' },
	[0x000C5] = { mathclass='alphabetic', adobename='Aring', texname='AA' },
	[0x000C6] = { mathclass='alphabetic', adobename='AE', texname='AE' },
	[0x000C7] = { mathclass='alphabetic', adobename='Ccedilla' },
	[0x000C8] = { mathclass='alphabetic', adobename='Egrave' },
	[0x000C9] = { mathclass='alphabetic', adobename='Eacute' },
	[0x000CA] = { mathclass='alphabetic', adobename='Ecircumflex' },
	[0x000CB] = { mathclass='alphabetic', adobename='Edieresis' },
	[0x000CC] = { mathclass='alphabetic', adobename='Igrave' },
	[0x000CD] = { mathclass='alphabetic', adobename='Iacute' },
	[0x000CE] = { mathclass='alphabetic', adobename='Icircumflex' },
	[0x000CF] = { mathclass='alphabetic', adobename='Idieresis' },
	[0x000D0] = { mathclass='alphabetic', adobename='Eth', texname='DH' },
	[0x000D1] = { mathclass='alphabetic', adobename='Ntilde' },
	[0x000D2] = { mathclass='alphabetic', adobename='Ograve' },
	[0x000D3] = { mathclass='alphabetic', adobename='Oacute' },
	[0x000D4] = { mathclass='alphabetic', adobename='Ocircumflex' },
	[0x000D5] = { mathclass='alphabetic', adobename='Otilde' },
	[0x000D6] = { mathclass='alphabetic', adobename='Odieresis' },
	[0x000D7] = { mathclass='binary', adobename='multiply', texname='times' },
	[0x000D8] = { mathclass='alphabetic', adobename='Oslash', texname='O' },
	[0x000D9] = { mathclass='alphabetic', adobename='Ugrave' },
	[0x000DA] = { mathclass='alphabetic', adobename='Uacute' },
	[0x000DB] = { mathclass='alphabetic', adobename='Ucircumflex' },
	[0x000DC] = { mathclass='alphabetic', adobename='Udieresis' },
	[0x000DD] = { mathclass='alphabetic', adobename='Yacute' },
	[0x000DE] = { mathclass='alphabetic', adobename='Thorn', texname='TH' },
	[0x000DF] = { mathclass='alphabetic', adobename='germandbls', texname='ss' },
	[0x000E0] = { mathclass='alphabetic', adobename='agrave' },
	[0x000E1] = { mathclass='alphabetic', adobename='aacute' },
	[0x000E2] = { mathclass='alphabetic', adobename='acircumflex' },
	[0x000E3] = { mathclass='alphabetic', adobename='atilde' },
	[0x000E4] = { mathclass='alphabetic', adobename='adieresis' },
	[0x000E5] = { mathclass='alphabetic', adobename='aring', texname='aa' },
	[0x000E6] = { mathclass='alphabetic', adobename='ae', texname='ae' },
	[0x000E7] = { mathclass='alphabetic', adobename='ccedilla' },
	[0x000E8] = { mathclass='alphabetic', adobename='egrave' },
	[0x000E9] = { mathclass='alphabetic', adobename='eacute' },
	[0x000EA] = { mathclass='alphabetic', adobename='ecircumflex' },
	[0x000EB] = { mathclass='alphabetic', adobename='edieresis' },
	[0x000EC] = { mathclass='alphabetic', adobename='igrave' },
	[0x000ED] = { mathclass='alphabetic', adobename='iacute' },
	[0x000EE] = { mathclass='alphabetic', adobename='icircumflex' },
	[0x000EF] = { mathclass='alphabetic', adobename='idieresis' },
	[0x000F0] = { mathclass='alphabetic', adobename='eth', texname='dh' },
	[0x000F1] = { mathclass='alphabetic', adobename='ntilde' },
	[0x000F2] = { mathclass='alphabetic', adobename='ograve' },
	[0x000F3] = { mathclass='alphabetic', adobename='oacute' },
	[0x000F4] = { mathclass='alphabetic', adobename='ocircumflex' },
	[0x000F5] = { mathclass='alphabetic', adobename='otilde' },
	[0x000F6] = { mathclass='alphabetic', adobename='odieresis' },
	[0x000F7] = { mathclass='binary', adobename='divide', texname='div' },
	[0x000F8] = { mathclass='alphabetic', adobename='oslash', texname='o' },
	[0x000F9] = { mathclass='alphabetic', adobename='ugrave' },
	[0x000FA] = { mathclass='alphabetic', adobename='uacute' },
	[0x000FB] = { mathclass='alphabetic', adobename='ucircumflex' },
	[0x000FC] = { mathclass='alphabetic', adobename='udieresis' },
	[0x000FD] = { mathclass='alphabetic', adobename='yacute' },
	[0x000FE] = { mathclass='alphabetic', adobename='thorn', texname='th' },
	[0x000FF] = { mathclass='alphabetic', adobename='ydieresis' },
	[0x00100] = { mathclass='alphabetic', adobename='uni0100' },
	[0x00101] = { mathclass='alphabetic', adobename='uni0101' },
	[0x00102] = { mathclass='alphabetic', adobename='uni0102' },
	[0x00103] = { mathclass='alphabetic', adobename='uni0103' },
	[0x00104] = { mathclass='alphabetic', adobename='uni0104' },
	[0x00105] = { mathclass='alphabetic', adobename='uni0105' },
	[0x00106] = { mathclass='alphabetic', adobename='uni0106' },
	[0x00107] = { mathclass='alphabetic', adobename='uni0107' },
	[0x00108] = { mathclass='alphabetic', adobename='uni0108' },
	[0x00109] = { mathclass='alphabetic', adobename='uni0109' },
	[0x0010A] = { mathclass='alphabetic', adobename='uni010A' },
	[0x0010B] = { mathclass='alphabetic', adobename='uni010B' },
	[0x0010C] = { mathclass='alphabetic', adobename='uni010C' },
	[0x0010D] = { mathclass='alphabetic', adobename='uni010D' },
	[0x0010E] = { mathclass='alphabetic', adobename='uni010E' },
	[0x0010F] = { mathclass='alphabetic', adobename='uni010F' },
	[0x00110] = { mathclass='alphabetic', adobename='uni0110', texname='DJ' },
	[0x00111] = { mathclass='alphabetic', adobename='uni0111', texname='dj' },
	[0x00112] = { mathclass='alphabetic', adobename='uni0112' },
	[0x00113] = { mathclass='alphabetic', adobename='uni0113' },
	[0x00114] = { mathclass='alphabetic', adobename='uni0114' },
	[0x00115] = { mathclass='alphabetic', adobename='uni0115' },
	[0x00116] = { mathclass='alphabetic', adobename='uni0116' },
	[0x00117] = { mathclass='alphabetic', adobename='uni0117' },
	[0x00118] = { mathclass='alphabetic', adobename='uni0118' },
	[0x00119] = { mathclass='alphabetic', adobename='uni0119' },
	[0x0011A] = { mathclass='alphabetic', adobename='uni011A' },
	[0x0011B] = { mathclass='alphabetic', adobename='uni011B' },
	[0x0011C] = { mathclass='alphabetic', adobename='uni011C' },
	[0x0011D] = { mathclass='alphabetic', adobename='uni011D' },
	[0x0011E] = { mathclass='alphabetic', adobename='uni011E' },
	[0x0011F] = { mathclass='alphabetic', adobename='uni011F' },
	[0x00120] = { mathclass='alphabetic', adobename='uni0120' },
	[0x00121] = { mathclass='alphabetic', adobename='uni0121' },
	[0x00122] = { mathclass='alphabetic', adobename='uni0122' },
	[0x00123] = { mathclass='alphabetic', adobename='uni0123' },
	[0x00124] = { mathclass='alphabetic', adobename='uni0124' },
	[0x00125] = { mathclass='alphabetic', adobename='uni0125' },
	[0x00126] = { mathclass='alphabetic', adobename='uni0126' },
	[0x00127] = { mathclass='alphabetic', adobename='uni0127', texname='textcrh' },
	[0x00128] = { mathclass='alphabetic', adobename='uni0128' },
	[0x00129] = { mathclass='alphabetic', adobename='uni0129' },
	[0x0012A] = { mathclass='alphabetic', adobename='uni012A' },
	[0x0012B] = { mathclass='alphabetic', adobename='uni012B' },
	[0x0012C] = { mathclass='alphabetic', adobename='uni012C' },
	[0x0012D] = { mathclass='alphabetic', adobename='uni012D' },
	[0x0012E] = { mathclass='alphabetic', adobename='uni012E' },
	[0x0012F] = { mathclass='alphabetic', adobename='uni012F' },
	[0x00130] = { mathclass='alphabetic', adobename='uni0130' },
	[0x00131] = { mathclass='alphabetic', adobename='dotlessi', texname='i' },
	[0x00132] = { mathclass='alphabetic', adobename='uni0132' },
	[0x00133] = { mathclass='alphabetic', adobename='uni0133' },
	[0x00134] = { mathclass='alphabetic', adobename='uni0134' },
	[0x00135] = { mathclass='alphabetic', adobename='uni0135' },
	[0x00136] = { mathclass='alphabetic', adobename='uni0136' },
	[0x00137] = { mathclass='alphabetic', adobename='uni0137' },
	[0x00138] = { mathclass='alphabetic', adobename='uni0138' },
	[0x00139] = { mathclass='alphabetic', adobename='uni0139' },
	[0x0013A] = { mathclass='alphabetic', adobename='uni013A' },
	[0x0013B] = { mathclass='alphabetic', adobename='uni013B' },
	[0x0013C] = { mathclass='alphabetic', adobename='uni013C' },
	[0x0013D] = { mathclass='alphabetic', adobename='uni013D' },
	[0x0013E] = { mathclass='alphabetic', adobename='uni013E' },
	[0x0013F] = { mathclass='alphabetic', adobename='uni013F' },
	[0x00140] = { mathclass='alphabetic', adobename='uni0140' },
	[0x00141] = { mathclass='alphabetic', adobename='Lslash', texname='L' },
	[0x00142] = { mathclass='alphabetic', adobename='lslash', texname='l' },
	[0x00143] = { mathclass='alphabetic', adobename='uni0143' },
	[0x00144] = { mathclass='alphabetic', adobename='uni0144' },
	[0x00145] = { mathclass='alphabetic', adobename='uni0145' },
	[0x00146] = { mathclass='alphabetic', adobename='uni0146' },
	[0x00147] = { mathclass='alphabetic', adobename='uni0147' },
	[0x00148] = { mathclass='alphabetic', adobename='uni0148' },
	[0x00149] = { mathclass='alphabetic', adobename='uni0149' },
	[0x0014A] = { mathclass='alphabetic', adobename='uni014A', texname='NG' },
	[0x0014B] = { mathclass='alphabetic', adobename='uni014B', texname='ng' },
	[0x0014C] = { mathclass='alphabetic', adobename='uni014C' },
	[0x0014D] = { mathclass='alphabetic', adobename='uni014D' },
	[0x0014E] = { mathclass='alphabetic', adobename='uni014E' },
	[0x0014F] = { mathclass='alphabetic', adobename='uni014F' },
	[0x00150] = { mathclass='alphabetic', adobename='uni0150' },
	[0x00151] = { mathclass='alphabetic', adobename='uni0151' },
	[0x00152] = { mathclass='alphabetic', adobename='OE', texname='OE' },
	[0x00153] = { mathclass='alphabetic', adobename='oe', texname='oe' },
	[0x00154] = { mathclass='alphabetic', adobename='uni0154' },
	[0x00155] = { mathclass='alphabetic', adobename='uni0155' },
	[0x00156] = { mathclass='alphabetic', adobename='uni0156' },
	[0x00157] = { mathclass='alphabetic', adobename='uni0157' },
	[0x00158] = { mathclass='alphabetic', adobename='uni0158' },
	[0x00159] = { mathclass='alphabetic', adobename='uni0159' },
	[0x0015A] = { mathclass='alphabetic', adobename='uni015A' },
	[0x0015B] = { mathclass='alphabetic', adobename='uni015B' },
	[0x0015C] = { mathclass='alphabetic', adobename='uni015C' },
	[0x0015D] = { mathclass='alphabetic', adobename='uni015D' },
	[0x0015E] = { mathclass='alphabetic', adobename='uni015E' },
	[0x0015F] = { mathclass='alphabetic', adobename='uni015F' },
	[0x00160] = { mathclass='alphabetic', adobename='Scaron' },
	[0x00161] = { mathclass='alphabetic', adobename='scaron' },
	[0x00162] = { mathclass='alphabetic', adobename='uni0162' },
	[0x00163] = { mathclass='alphabetic', adobename='uni0163' },
	[0x00164] = { mathclass='alphabetic', adobename='uni0164' },
	[0x00165] = { mathclass='alphabetic', adobename='uni0165' },
	[0x00166] = { mathclass='alphabetic', adobename='uni0166' },
	[0x00167] = { mathclass='alphabetic', adobename='uni0167' },
	[0x00168] = { mathclass='alphabetic', adobename='uni0168' },
	[0x00169] = { mathclass='alphabetic', adobename='uni0169' },
	[0x0016A] = { mathclass='alphabetic', adobename='uni016A' },
	[0x0016B] = { mathclass='alphabetic', adobename='uni016B' },
	[0x0016C] = { mathclass='alphabetic', adobename='uni016C' },
	[0x0016D] = { mathclass='alphabetic', adobename='uni016D' },
	[0x0016E] = { mathclass='alphabetic', adobename='uni016E' },
	[0x0016F] = { mathclass='alphabetic', adobename='uni016F' },
	[0x00170] = { mathclass='alphabetic', adobename='uni0170' },
	[0x00171] = { mathclass='alphabetic', adobename='uni0171' },
	[0x00172] = { mathclass='alphabetic', adobename='uni0172' },
	[0x00173] = { mathclass='alphabetic', adobename='uni0173' },
	[0x00174] = { mathclass='alphabetic', adobename='uni0174' },
	[0x00175] = { mathclass='alphabetic', adobename='uni0175' },
	[0x00176] = { mathclass='alphabetic', adobename='uni0176' },
	[0x00177] = { mathclass='alphabetic', adobename='uni0177' },
	[0x00178] = { mathclass='alphabetic', adobename='Ydieresis' },
	[0x00179] = { mathclass='alphabetic', adobename='uni0179' },
	[0x0017A] = { mathclass='alphabetic', adobename='uni017A' },
	[0x0017B] = { mathclass='alphabetic', adobename='uni017B' },
	[0x0017C] = { mathclass='alphabetic', adobename='uni017C' },
	[0x0017D] = { mathclass='alphabetic', adobename='Zcaron' },
	[0x0017E] = { mathclass='alphabetic', adobename='zcaron' },
	[0x0017F] = { mathclass='alphabetic', adobename='uni017F' },
	[0x00180] = { mathclass='alphabetic', adobename='uni0180', texname='textcrb' },
	[0x00188] = { mathclass='unknown', adobename='uni0188', texname='texthtc' },
	[0x00190] = { mathclass='unknown', adobename='uni0190' },
	[0x00192] = { mathclass='normal', adobename='florin', texname='textflorin' },
	[0x00195] = { mathclass='unknown', adobename='uni0195', texname='texthvlig' },
	[0x00199] = { mathclass='alphabetic', adobename='uni0199', texname='texthtk' },
	[0x0019A] = { mathclass='alphabetic', adobename='uni019A', texname='textbarl' },
	[0x0019B] = { mathclass='alphabetic', adobename='uni019B', texname='textcrlambda' },
	[0x0019E] = { mathclass='alphabetic', adobename='uni019E' },
	[0x001A0] = { mathclass='alphabetic', adobename='uni01A0', texname='Ohorn' },
	[0x001A1] = { mathclass='alphabetic', adobename='uni01A1', texname='ohorn' },
	[0x001A5] = { mathclass='alphabetic', adobename='uni01A5', texname='texthtp' },
	[0x001AA] = { mathclass='alphabetic', adobename='uni01AA', texname='textlooptoprevesh' },
	[0x001AB] = { mathclass='alphabetic', adobename='uni01AB', texname='textlhookt' },
	[0x001AD] = { mathclass='alphabetic', adobename='uni01AD', texname='texthtt' },
	[0x001AF] = { mathclass='alphabetic', adobename='uni01AF', texname='Uhorn' },
	[0x001B0] = { mathclass='alphabetic', adobename='uni01B0', texname='uhorn' },
	[0x001B5] = { mathclass='normal', adobename='uni01B5', texname='Zbar' },
	[0x001BA] = { mathclass='alphabetic', adobename='uni01BA', texname='textbenttailyogh' },
	[0x001BB] = { mathclass='alphabetic', adobename='uni01BB', texname='textcrtwo' },
	[0x001BE] = { mathclass='alphabetic', adobename='uni01BE', texname='textcrinvglotstop' },
	[0x001C0] = { mathclass='alphabetic', adobename='uni01C0', texname='textpipe' },
	[0x001C1] = { mathclass='alphabetic', adobename='uni01C1', texname='textdoublepipe' },
	[0x001C2] = { mathclass='alphabetic', adobename='uni01C2', texname='textdoublebarpipe' },
	[0x001C3] = { mathclass='alphabetic', adobename='uni01C3', texname='textexclam' },
	[0x001F0] = { mathclass='alphabetic', adobename='uni01F0' },
	[0x001FA] = { mathclass='unknown', adobename='uni01FA' },
	[0x001FB] = { mathclass='unknown', adobename='uni01FB' },
	[0x001FC] = { mathclass='unknown', adobename='uni01FC' },
	[0x001FD] = { mathclass='unknown', adobename='uni01FD' },
	[0x001FE] = { mathclass='unknown', adobename='uni01FE' },
	[0x001FF] = { mathclass='unknown', adobename='uni01FF' },
	[0x00221] = { mathclass='alphabetic', adobename='uni0221', texname='textctd' },
	[0x00234] = { mathclass='alphabetic', adobename='uni0234', texname='textctl' },
	[0x00235] = { mathclass='alphabetic', adobename='uni0235', texname='textctn' },
	[0x00236] = { mathclass='alphabetic', adobename='uni0236', texname='textctt' },
	[0x00237] = { mathclass='alphabetic', adobename='uni0237', texname='textdotlessj' },
	[0x00250] = { mathclass='alphabetic', adobename='uni0250', texname='textturna' },
	[0x00251] = { mathclass='alphabetic', adobename='uni0251', texname='textscripta' },
	[0x00252] = { mathclass='alphabetic', adobename='uni0252', texname='textturnscripta' },
	[0x00253] = { mathclass='alphabetic', adobename='uni0253', texname='texthtb' },
	[0x00254] = { mathclass='binary', adobename='uni0254', texname='textopeno' },
	[0x00255] = { mathclass='alphabetic', adobename='uni0255', texname='textctc' },
	[0x00256] = { mathclass='alphabetic', adobename='uni0256', texname='textrtaild' },
	[0x00257] = { mathclass='alphabetic', adobename='uni0257', texname='texthtd' },
	[0x00258] = { mathclass='alphabetic', adobename='uni0258', texname='textreve' },
	[0x00259] = { mathclass='alphabetic', adobename='uni0259', texname='textschwa' },
	[0x0025A] = { mathclass='alphabetic', adobename='uni025A', texname='textrhookschwa' },
	[0x0025B] = { mathclass='alphabetic', adobename='uni025B', texname='textepsilon' },
	[0x0025C] = { mathclass='alphabetic', adobename='uni025C', texname='textrevepsilon' },
	[0x0025D] = { mathclass='alphabetic', adobename='uni025D', texname='textrhookrevepsilon' },
	[0x0025E] = { mathclass='alphabetic', adobename='uni025E', texname='textcloserevepsilon' },
	[0x0025F] = { mathclass='alphabetic', adobename='uni025F', texname='textbardotlessj' },
	[0x00260] = { mathclass='alphabetic', adobename='uni0260', texname='texthtg' },
	[0x00261] = { mathclass='alphabetic', adobename='uni0261', texname='textscriptg' },
	[0x00262] = { mathclass='alphabetic', adobename='uni0262', texname='textscg' },
	[0x00263] = { mathclass='alphabetic', adobename='uni0263', texname='textgamma' },
	[0x00264] = { mathclass='alphabetic', adobename='uni0264', texname='textramshorns' },
	[0x00265] = { mathclass='alphabetic', adobename='uni0265', texname='textturnh' },
	[0x00266] = { mathclass='alphabetic', adobename='uni0266', texname='texthth' },
	[0x00267] = { mathclass='alphabetic', adobename='uni0267', texname='texththeng' },
	[0x00268] = { mathclass='alphabetic', adobename='uni0268', texname='textbari' },
	[0x00269] = { mathclass='alphabetic', adobename='uni0269', texname='textiota' },
	[0x0026A] = { mathclass='alphabetic', adobename='uni026A', texname='textsci' },
	[0x0026B] = { mathclass='alphabetic', adobename='uni026B', texname='textltilde' },
	[0x0026C] = { mathclass='alphabetic', adobename='uni026C', texname='textbeltl' },
	[0x0026D] = { mathclass='alphabetic', adobename='uni026D', texname='textrtaill' },
	[0x0026E] = { mathclass='alphabetic', adobename='uni026E', texname='textlyoghlig' },
	[0x0026F] = { mathclass='alphabetic', adobename='uni026F', texname='textturnm' },
	[0x00270] = { mathclass='alphabetic', adobename='uni0270', texname='textturnmrleg' },
	[0x00271] = { mathclass='alphabetic', adobename='uni0271', texname='textltailm' },
	[0x00272] = { mathclass='alphabetic', adobename='uni0272', texname='textltailn' },
	[0x00273] = { mathclass='alphabetic', adobename='uni0273', texname='textrtailn' },
	[0x00274] = { mathclass='alphabetic', adobename='uni0274', texname='textscn' },
	[0x00275] = { mathclass='alphabetic', adobename='uni0275', texname='textbaro' },
	[0x00276] = { mathclass='alphabetic', adobename='uni0276', texname='textscoelig' },
	[0x00277] = { mathclass='alphabetic', adobename='uni0277', texname='textcloseomega' },
	[0x00278] = { mathclass='alphabetic', adobename='uni0278', texname='textphi' },
	[0x00279] = { mathclass='alphabetic', adobename='uni0279', texname='textturnr' },
	[0x0027A] = { mathclass='alphabetic', adobename='uni027A', texname='textturnlonglegr' },
	[0x0027B] = { mathclass='alphabetic', adobename='uni027B', texname='textturnrrtail' },
	[0x0027C] = { mathclass='alphabetic', adobename='uni027C', texname='textlonglegr' },
	[0x0027D] = { mathclass='alphabetic', adobename='uni027D', texname='textrtailr' },
	[0x0027E] = { mathclass='alphabetic', adobename='uni027E', texname='textfishhookr' },
	[0x0027F] = { mathclass='alphabetic', adobename='uni027F', texname='textlhti' },
	[0x00280] = { mathclass='alphabetic', adobename='uni0280', texname='textscr' },
	[0x00281] = { mathclass='alphabetic', adobename='uni0281', texname='textinvscr' },
	[0x00282] = { mathclass='alphabetic', adobename='uni0282', texname='textrtails' },
	[0x00283] = { mathclass='alphabetic', adobename='uni0283', texname='textesh' },
	[0x00284] = { mathclass='alphabetic', adobename='uni0284', texname='texthtbardotlessjvar' },
	[0x00285] = { mathclass='alphabetic', adobename='uni0285', texname='textvibyi' },
	[0x00286] = { mathclass='alphabetic', adobename='uni0286', texname='textctesh' },
	[0x00287] = { mathclass='alphabetic', adobename='uni0287', texname='textturnt' },
	[0x00288] = { mathclass='alphabetic', adobename='uni0288', texname='textrtailt' },
	[0x00289] = { mathclass='alphabetic', adobename='uni0289', texname='textbaru' },
	[0x0028A] = { mathclass='alphabetic', adobename='uni028A', texname='textupsilon' },
	[0x0028B] = { mathclass='alphabetic', adobename='uni028B', texname='textscriptv' },
	[0x0028C] = { mathclass='alphabetic', adobename='uni028C', texname='textturnv' },
	[0x0028D] = { mathclass='alphabetic', adobename='uni028D', texname='textturnw' },
	[0x0028E] = { mathclass='alphabetic', adobename='uni028E', texname='textturny' },
	[0x0028F] = { mathclass='alphabetic', adobename='uni028F', texname='textscy' },
	[0x00290] = { mathclass='alphabetic', adobename='uni0290', texname='textrtailz' },
	[0x00291] = { mathclass='alphabetic', adobename='uni0291', texname='textctz' },
	[0x00292] = { mathclass='alphabetic', adobename='uni0292', texname='textyogh' },
	[0x00293] = { mathclass='alphabetic', adobename='uni0293', texname='textctyogh' },
	[0x00294] = { mathclass='alphabetic', adobename='uni0294', texname='textglotstop' },
	[0x00295] = { mathclass='alphabetic', adobename='uni0295', texname='textrevglotstop' },
	[0x00296] = { mathclass='alphabetic', adobename='uni0296', texname='textinvglotstop' },
	[0x00297] = { mathclass='alphabetic', adobename='uni0297', texname='textstretchcvar' },
	[0x00298] = { mathclass='alphabetic', adobename='uni0298', texname='textbullseye' },
	[0x00299] = { mathclass='alphabetic', adobename='uni0299', texname='textscb' },
	[0x0029A] = { mathclass='alphabetic', adobename='uni029A', texname='textcloseepsilon' },
	[0x0029B] = { mathclass='alphabetic', adobename='uni029B', texname='texthtscg' },
	[0x0029C] = { mathclass='alphabetic', adobename='uni029C', texname='textsch' },
	[0x0029D] = { mathclass='alphabetic', adobename='uni029D', texname='textctj' },
	[0x0029E] = { mathclass='alphabetic', adobename='uni029E', texname='textturnk' },
	[0x0029F] = { mathclass='alphabetic', adobename='uni029F', texname='textscl' },
	[0x002A0] = { mathclass='alphabetic', adobename='uni02A0', texname='texthtq' },
	[0x002A1] = { mathclass='alphabetic', adobename='uni02A1', texname='textbarglotstop' },
	[0x002A2] = { mathclass='alphabetic', adobename='uni02A2', texname='textbarrevglotstop' },
	[0x002A3] = { mathclass='alphabetic', adobename='uni02A3', texname='textdzlig' },
	[0x002A4] = { mathclass='alphabetic', adobename='uni02A4', texname='textdyoghlig' },
	[0x002A5] = { mathclass='alphabetic', adobename='uni02A5', texname='textdctzlig' },
	[0x002A6] = { mathclass='alphabetic', adobename='uni02A6', texname='texttslig' },
	[0x002A7] = { mathclass='alphabetic', adobename='uni02A7', texname='textteshlig' },
	[0x002A8] = { mathclass='alphabetic', adobename='uni02A8', texname='texttctctlig' },
	[0x002AE] = { mathclass='alphabetic', adobename='uni02AE', texname='textlongy' },
	[0x002AF] = { mathclass='alphabetic', adobename='uni02AF', texname='textvibyy' },
	[0x002B0] = { mathclass='alphabetic', adobename='uni02B0', texname='textsuph' },
	[0x002B1] = { mathclass='alphabetic', adobename='uni02B1', texname='textsuphth' },
	[0x002B2] = { mathclass='alphabetic', adobename='uni02B2', texname='textsupj' },
	[0x002B3] = { mathclass='alphabetic', adobename='uni02B3', texname='textsupr' },
	[0x002B4] = { mathclass='alphabetic', adobename='uni02B4', texname='textsupturnr' },
	[0x002B5] = { mathclass='alphabetic', adobename='uni02B5', texname='textsupturnrrtail' },
	[0x002B6] = { mathclass='alphabetic', adobename='uni02B6', texname='textsupinvscr' },
	[0x002B7] = { mathclass='alphabetic', adobename='uni02B7', texname='textsupw' },
	[0x002B8] = { mathclass='alphabetic', adobename='uni02B8', texname='textsupy' },
	[0x002B9] = { mathclass='unknown', adobename='uni02B9', texname='cprime' },
	[0x002BA] = { mathclass='unknown', adobename='uni02BA', texname='cdprime' },
	[0x002BB] = { mathclass='opening', adobename='uni02BB', texname='textturncomma' },
	[0x002BC] = { mathclass='unknown', adobename='uni02BC', texname='rasp' },
	[0x002BD] = { mathclass='unknown', adobename='uni02BD', texname='lasp' },
	[0x002BE] = { mathclass='unknown', adobename='uni02BE', texname='texthamza' },
	[0x002BF] = { mathclass='unknown', adobename='uni02BF', texname='textain' },
	[0x002C0] = { mathclass='unknown', adobename='uni02C0', texname='textraiseglotstop' },
	[0x002C1] = { mathclass='unknown', adobename='uni02C1', texname='textraiserevglotstop' },
	[0x002C2] = { mathclass='unknown', adobename='uni02C2', texname='textlptr' },
	[0x002C3] = { mathclass='unknown', adobename='uni02C3', texname='textrptr' },
	[0x002C4] = { mathclass='unknown', adobename='uni02C4', texname='textuptr' },
	[0x002C5] = { mathclass='unknown', adobename='uni02C5', texname='textdptr' },
	[0x002C6] = { mathclass='unknown', adobename='circumflex', texname='^' },
	[0x002C7] = { mathclass='unknown', adobename='caron', texname='v' },
	[0x002C8] = { mathclass='unknown', adobename='uni02C8', texname='textprimstress' },
	[0x002C9] = { mathclass='unknown', adobename='uni02C9', texname='textmacron' },
	[0x002CA] = { mathclass='unknown', adobename='uni02CA', texname='textacute' },
	[0x002CB] = { mathclass='unknown', adobename='uni02CB', texname='textgrave' },
	[0x002CC] = { mathclass='unknown', adobename='uni02CC', texname='textsecstress' },
	[0x002CD] = { mathclass='unknown', adobename='uni02CD', texname='textlowmacron' },
	[0x002CE] = { mathclass='unknown', adobename='uni02CE', texname='textlowgrave' },
	[0x002CF] = { mathclass='unknown', adobename='uni02CF', texname='textlowacute' },
	[0x002D0] = { mathclass='unknown', adobename='uni02D0', texname='textlengthmark' },
	[0x002D1] = { mathclass='unknown', adobename='uni02D1', texname='texthalflength' },
	[0x002D2] = { mathclass='unknown', adobename='uni02D2', texname='textrhalfring' },
	[0x002D3] = { mathclass='unknown', adobename='uni02D3', texname='textlhalfring' },
	[0x002D4] = { mathclass='diacritic', adobename='uni02D4', texname='textraised' },
	[0x002D5] = { mathclass='diacritic', adobename='uni02D5', texname='textlowered' },
	[0x002D6] = { mathclass='diacritic', adobename='uni02D6', texname='textadvanced' },
	[0x002D7] = { mathclass='diacritic', adobename='uni02D7', texname='textretracted' },
	[0x002D8] = { mathclass='diacritic', adobename='breve', texname='textbreve' },
	[0x002D9] = { mathclass='diacritic', adobename='dotaccent', texname='textdotaccent' },
	[0x002DA] = { mathclass='diacritic', adobename='ring', texname='textringaccent' },
	[0x002DB] = { mathclass='diacritic', adobename='ogonek', texname='textogonek' },
	[0x002DC] = { mathclass='diacritic', adobename='smalltilde', texname='textsmalltilde' },
	[0x002DD] = { mathclass='diacritic', adobename='hungarumlaut', texname='textdoubleacute' },
	[0x002DE] = { mathclass='diacritic', adobename='uni02DE', texname='textrhoticity' },
	[0x002DF] = { mathclass='diacritic', adobename='uni02DF', texname='ipacrossaccent' },
	[0x002E0] = { mathclass='diacritic', adobename='uni02E0', texname='ipasupgamma' },
	[0x002E1] = { mathclass='alphabetic', adobename='uni02E1', texname='ipasupl' },
	[0x002E2] = { mathclass='alphabetic', adobename='uni02E2', texname='ipasups' },
	[0x002E3] = { mathclass='alphabetic', adobename='uni02E3', texname='ipasupx' },
	[0x002E4] = { mathclass='diacritic', adobename='uni02E4', texname='ipasuprerglotstpp' },
	[0x002E5] = { mathclass='diacritic', adobename='uni02E5', texname='tonebarextrahigh' },
	[0x002E6] = { mathclass='diacritic', adobename='uni02E6', texname='tonebarhigh' },
	[0x002E7] = { mathclass='diacritic', adobename='uni02E7', texname='tonebarmid' },
	[0x002E8] = { mathclass='diacritic', adobename='uni02E8', texname='tonebarlow' },
	[0x002E9] = { mathclass='diacritic', adobename='uni02E9', texname='tonebarextralow' },
	[0x002EC] = { mathclass='diacritic', adobename='uni02EC', texname='ipavoicing' },
	[0x002ED] = { mathclass='diacritic', adobename='uni02ED', texname='ipaunaspirated' },
	[0x00300] = { mathclass='diacritic', adobename='uni0300', texname='grave' },
	[0x00301] = { mathclass='diacritic', adobename='uni0301', texname='acute' },
	[0x00302] = { mathclass='diacritic', adobename='uni0302', texname='hat' },
	[0x00303] = { mathclass='diacritic', adobename='uni0303', texname='tilde' },
	[0x00304] = { mathclass='diacritic', adobename='uni0304', texname='bar' },
	[0x00305] = { mathclass='diacritic', adobename='uni0305', texname='overbar' },
	[0x00306] = { mathclass='diacritic', adobename='uni0306', texname='breve' },
	[0x00307] = { mathclass='diacritic', adobename='uni0307', texname='dot' },
	[0x00308] = { mathclass='diacritic', adobename='uni0308', texname='ddot' },
	[0x00309] = { mathclass='diacritic', adobename='uni0309', texname='ovhook' },
	[0x0030A] = { mathclass='diacritic', adobename='uni030A', texname='ocirc' },
	[0x0030B] = { mathclass='diacritic', adobename='uni030B', texname='H' },
	[0x0030C] = { mathclass='diacritic', adobename='uni030C', texname='check' },
	[0x0030D] = { mathclass='diacritic', adobename='uni030D', texname='textvbaraccent' },
	[0x0030E] = { mathclass='diacritic', adobename='uni030E', texname='textdoublevbaraccent' },
	[0x0030F] = { mathclass='diacritic', adobename='uni030F', texname='textdoublegrave' },
	[0x00310] = { mathclass='diacritic', adobename='uni0310', texname='candra' },
	[0x00311] = { mathclass='diacritic', adobename='uni0311', texname='textroundcap' },
	[0x00312] = { mathclass='diacritic', adobename='uni0312', texname='oturnedcomma' },
	[0x00313] = { mathclass='diacritic', adobename='uni0313', texname='osmooth' },
	[0x00314] = { mathclass='diacritic', adobename='uni0314', texname='orough' },
	[0x00315] = { mathclass='diacritic', adobename='uni0315', texname='ocommatopright' },
	[0x00316] = { mathclass='diacritic', adobename='uni0316', texname='textsubgrave' },
	[0x00317] = { mathclass='diacritic', adobename='uni0317', texname='textsubacute' },
	[0x00318] = { mathclass='diacritic', adobename='uni0318', texname='textadvancing' },
	[0x00319] = { mathclass='diacritic', adobename='uni0319', texname='textretracting' },
	[0x0031A] = { mathclass='diacritic', adobename='uni031A', texname='droang' },
	[0x0031B] = { mathclass='diacritic', adobename='uni031B', texname='texthorn' },
	[0x0031C] = { mathclass='diacritic', adobename='uni031C', texname='textsublhalfring' },
	[0x0031D] = { mathclass='diacritic', adobename='uni031D', texname='textraising' },
	[0x0031E] = { mathclass='diacritic', adobename='uni031E', texname='textlowering' },
	[0x0031F] = { mathclass='diacritic', adobename='uni031F', texname='textsubplus' },
	[0x00320] = { mathclass='diacritic', adobename='uni0320', texname='textsubminus' },
	[0x00321] = { mathclass='diacritic', adobename='uni0321', texname='textpalhook' },
	[0x00322] = { mathclass='diacritic', adobename='uni0322', texname='textrhook' },
	[0x00323] = { mathclass='diacritic', adobename='uni0323', texname='textsubdot' },
	[0x00324] = { mathclass='diacritic', adobename='uni0324', texname='textsubumlaut' },
	[0x00325] = { mathclass='diacritic', adobename='uni0325', texname='textsubring' },
	[0x00326] = { mathclass='diacritic', adobename='uni0326', texname='textsubcomma' },
	[0x00327] = { mathclass='diacritic', adobename='uni0327', texname='c' },
	[0x00328] = { mathclass='diacritic', adobename='uni0328', texname='textpolhk' },
	[0x00329] = { mathclass='diacritic', adobename='uni0329', texname='textsyllabic' },
	[0x0032A] = { mathclass='diacritic', adobename='uni032A', texname='textsubbridge' },
	[0x0032B] = { mathclass='diacritic', adobename='uni032B', texname='textsubw' },
	[0x0032C] = { mathclass='diacritic', adobename='uni032C', texname='textsubwedge' },
	[0x0032D] = { mathclass='diacritic', adobename='uni032D', texname='textsubcircum' },
	[0x0032E] = { mathclass='diacritic', adobename='uni032E', texname='textsubbreve' },
	[0x0032F] = { mathclass='diacritic', adobename='uni032F', texname='textsubarch' },
	[0x00330] = { mathclass='diacritic', adobename='uni0330', texname='textsubtilde' },
	[0x00331] = { mathclass='diacritic', adobename='uni0331', texname='textsubbar' },
	[0x00332] = { mathclass='diacritic', adobename='uni0332', texname='textsubline' },
	[0x00333] = { mathclass='diacritic', adobename='uni0333', texname='textsubdoubleline' },
	[0x00334] = { mathclass='diacritic', adobename='uni0334', texname='textsuperimposetilde' },
	[0x00335] = { mathclass='diacritic', adobename='uni0335', texname='textoverlayshortstroke' },
	[0x00336] = { mathclass='diacritic', adobename='uni0336', texname='textoverlaylongstroke' },
	[0x00337] = { mathclass='diacritic', adobename='uni0337', texname='textoverlayshortsolidus' },
	[0x00338] = { mathclass='diacritic', adobename='uni0338', texname='textoverlaylongsolidus' },
	[0x00339] = { mathclass='diacritic', adobename='uni0339', texname='textsubrhalfring' },
	[0x0033A] = { mathclass='diacritic', adobename='uni033A', texname='textinvsubbridge' },
	[0x0033B] = { mathclass='diacritic', adobename='uni033B', texname='textsubsquare' },
	[0x0033C] = { mathclass='diacritic', adobename='uni033C', texname='textseagull' },
	[0x0033D] = { mathclass='diacritic', adobename='uni033D', texname='textovercross' },
	[0x0033E] = { mathclass='diacritic', adobename='uni033E', texname='textvtilde' },
	[0x0033F] = { mathclass='diacritic', adobename='uni033F', texname='textdoubleoverline' },
	[0x00346] = { mathclass='diacritic', adobename='uni0346', texname='textoverbridge' },
	[0x0034C] = { mathclass='diacritic', adobename='uni034C', texname='textdoubletilde' },
	[0x00359] = { mathclass='unknown', adobename='uni0359', texname='textunderasterisk' },
	[0x0035C] = { mathclass='unknown', adobename='uni035C', texname='texttieunderarc' },
	[0x00360] = { mathclass='diacritic', adobename='uni0360', texname='texttietilde' },
	[0x00361] = { mathclass='diacritic', adobename='uni0361', texname='t' },
	[0x00362] = { mathclass='diacritic', adobename='uni0362', texname='texttieunderrightarrow' },
	[0x0037E] = { mathclass='diacritic', adobename='uni037E' },
	[0x00384] = { mathclass='unknown', adobename='uni0384' },
	[0x00385] = { mathclass='unknown', adobename='uni0385' },
	[0x00386] = { mathclass='unknown', adobename='uni0386' },
	[0x00387] = { mathclass='unknown', adobename='uni0387' },
	[0x00388] = { mathclass='unknown', adobename='uni0388' },
	[0x00389] = { mathclass='unknown', adobename='uni0389' },
	[0x0038A] = { mathclass='unknown', adobename='uni038A' },
	[0x0038C] = { mathclass='unknown', adobename='uni038C' },
	[0x0038E] = { mathclass='unknown', adobename='uni038E' },
	[0x0038F] = { mathclass='unknown', adobename='uni038F' },
	[0x00390] = { mathclass='unknown', adobename='uni0390' },
	[0x00391] = { mathclass='alphabetic', adobename='uni0391', texname='upAlpha' },
	[0x00392] = { mathclass='alphabetic', adobename='uni0392', texname='upBeta' },
	[0x00393] = { mathclass='alphabetic', adobename='uni0393', texname='upGamma' },
	[0x00394] = { mathclass='alphabetic', adobename='uni0394', texname='upDelta' },
	[0x00395] = { mathclass='alphabetic', adobename='uni0395', texname='upEpsilon' },
	[0x00396] = { mathclass='alphabetic', adobename='uni0396', texname='upZeta' },
	[0x00397] = { mathclass='alphabetic', adobename='uni0397', texname='upEta' },
	[0x00398] = { mathclass='alphabetic', adobename='uni0398', texname='upTheta' },
	[0x00399] = { mathclass='alphabetic', adobename='uni0399', texname='upIota' },
	[0x0039A] = { mathclass='alphabetic', adobename='uni039A', texname='upKappa' },
	[0x0039B] = { mathclass='alphabetic', adobename='uni039B', texname='upLambda' },
	[0x0039C] = { mathclass='alphabetic', adobename='uni039C', texname='upMu' },
	[0x0039D] = { mathclass='alphabetic', adobename='uni039D', texname='upNu' },
	[0x0039E] = { mathclass='alphabetic', adobename='uni039E', texname='upXi' },
	[0x0039F] = { mathclass='alphabetic', adobename='uni039F', texname='upOmicron' },
	[0x003A0] = { mathclass='alphabetic', adobename='uni03A0', texname='upPi' },
	[0x003A1] = { mathclass='alphabetic', adobename='uni03A1', texname='upRho' },
	[0x003A3] = { mathclass='alphabetic', adobename='uni03A3', texname='upSigma' },
	[0x003A4] = { mathclass='alphabetic', adobename='uni03A4', texname='upTau' },
	[0x003A5] = { mathclass='alphabetic', adobename='uni03A5', texname='upUpsilon' },
	[0x003A6] = { mathclass='alphabetic', adobename='uni03A6', texname='upPhi' },
	[0x003A7] = { mathclass='alphabetic', adobename='uni03A7', texname='upChi' },
	[0x003A8] = { mathclass='alphabetic', adobename='uni03A8', texname='upPsi' },
	[0x003A9] = { mathclass='alphabetic', adobename='uni03A9', texname='upOmega' },
	[0x003AA] = { mathclass='unknown', adobename='uni03AA' },
	[0x003AB] = { mathclass='unknown', adobename='uni03AB' },
	[0x003AC] = { mathclass='unknown', adobename='uni03AC' },
	[0x003AD] = { mathclass='unknown', adobename='uni03AD' },
	[0x003AE] = { mathclass='unknown', adobename='uni03AE' },
	[0x003AF] = { mathclass='unknown', adobename='uni03AF' },
	[0x003B0] = { mathclass='unknown', adobename='uni03B0' },
	[0x003B1] = { mathclass='alphabetic', adobename='uni03B1', texname='upalpha' },
	[0x003B2] = { mathclass='alphabetic', adobename='uni03B2', texname='upbeta' },
	[0x003B3] = { mathclass='alphabetic', adobename='uni03B3', texname='upgamma' },
	[0x003B4] = { mathclass='alphabetic', adobename='uni03B4', texname='updelta' },
	[0x003B5] = { mathclass='alphabetic', adobename='uni03B5', texname='upvarepsilon' },
	[0x003B6] = { mathclass='alphabetic', adobename='uni03B6', texname='upzeta' },
	[0x003B7] = { mathclass='alphabetic', adobename='uni03B7', texname='upeta' },
	[0x003B8] = { mathclass='alphabetic', adobename='uni03B8', texname='uptheta' },
	[0x003B9] = { mathclass='alphabetic', adobename='uni03B9', texname='upiota' },
	[0x003BA] = { mathclass='alphabetic', adobename='uni03BA', texname='upkappa' },
	[0x003BB] = { mathclass='alphabetic', adobename='uni03BB', texname='uplambda' },
	[0x003BC] = { mathclass='alphabetic', adobename='uni03BC', texname='upmu' },
	[0x003BD] = { mathclass='alphabetic', adobename='uni03BD', texname='upnu' },
	[0x003BE] = { mathclass='alphabetic', adobename='uni03BE', texname='upxi' },
	[0x003BF] = { mathclass='alphabetic', adobename='uni03BF', texname='upomicron' },
	[0x003C0] = { mathclass='alphabetic', adobename='uni03C0', texname='uppi' },
	[0x003C1] = { mathclass='alphabetic', adobename='uni03C1', texname='uprho' },
	[0x003C2] = { mathclass='alphabetic', adobename='uni03C2', texname='upvarsigma' },
	[0x003C3] = { mathclass='alphabetic', adobename='uni03C3', texname='upsigma' },
	[0x003C4] = { mathclass='alphabetic', adobename='uni03C4', texname='uptau' },
	[0x003C5] = { mathclass='alphabetic', adobename='uni03C5', texname='upupsilon' },
	[0x003C6] = { mathclass='alphabetic', adobename='uni03C6', texname='upvarphi' },
	[0x003C7] = { mathclass='alphabetic', adobename='uni03C7', texname='upchi' },
	[0x003C8] = { mathclass='alphabetic', adobename='uni03C8', texname='uppsi' },
	[0x003C9] = { mathclass='alphabetic', adobename='uni03C9', texname='upomega' },
	[0x003CA] = { mathclass='unknown', adobename='uni03CA' },
	[0x003CB] = { mathclass='unknown', adobename='uni03CB' },
	[0x003CC] = { mathclass='unknown', adobename='uni03CC' },
	[0x003CD] = { mathclass='unknown', adobename='uni03CD' },
	[0x003CE] = { mathclass='unknown', adobename='uni03CE' },
	[0x003D0] = { mathclass='alphabetic', adobename='uni03D0', texname='upvarbeta' },
	[0x003D1] = { mathclass='alphabetic', adobename='uni03D1', texname='upvartheta' },
	[0x003D2] = { mathclass='alphabetic', adobename='uni03D2', texname='upUpsilon' },
	[0x003D5] = { mathclass='alphabetic', adobename='uni03D5', texname='upphi' },
	[0x003D6] = { mathclass='alphabetic', adobename='uni03D6', texname='upvarpi' },
	[0x003D8] = { mathclass='normal', adobename='uni03D8', texname='upoldKoppa' },
	[0x003D9] = { mathclass='normal', adobename='uni03D9', texname='upoldkoppa' },
	[0x003DA] = { mathclass='alphabetic', adobename='uni03DA', texname='upStigma' },
	[0x003DB] = { mathclass='alphabetic', adobename='uni03DB', texname='upstigma' },
	[0x003DC] = { mathclass='alphabetic', adobename='uni03DC', texname='upDigamma' },
	[0x003DD] = { mathclass='alphabetic', adobename='uni03DD', texname='updigamma' },
	[0x003DE] = { mathclass='alphabetic', adobename='uni03DE', texname='upKoppa' },
	[0x003DF] = { mathclass='alphabetic', adobename='uni03DF', texname='upkoppa' },
	[0x003E0] = { mathclass='alphabetic', adobename='uni03E0', texname='upSampi' },
	[0x003E1] = { mathclass='alphabetic', adobename='uni03E1', texname='upsampi' },
	[0x003F0] = { mathclass='alphabetic', adobename='uni03F0', texname='upvarkappa' },
	[0x003F1] = { mathclass='alphabetic', adobename='uni03F1', texname='upvarrho' },
	[0x003F4] = { mathclass='alphabetic', adobename='uni03F4', texname='upvarTheta' },
	[0x003F5] = { mathclass='alphabetic', adobename='uni03F5', texname='upepsilon' },
	[0x003F6] = { mathclass='normal', adobename='uni03F6', texname='upbackepsilon' },
	[0x00401] = { mathclass='alphabetic', adobename='uni0401' },
	[0x00402] = { mathclass='alphabetic', adobename='uni0402' },
	[0x00403] = { mathclass='alphabetic', adobename='uni0403' },
	[0x00404] = { mathclass='alphabetic', adobename='uni0404' },
	[0x00405] = { mathclass='alphabetic', adobename='uni0405' },
	[0x00406] = { mathclass='alphabetic', adobename='uni0406' },
	[0x00407] = { mathclass='alphabetic', adobename='uni0407' },
	[0x00408] = { mathclass='alphabetic', adobename='uni0408' },
	[0x00409] = { mathclass='alphabetic', adobename='uni0409' },
	[0x0040A] = { mathclass='alphabetic', adobename='uni040A' },
	[0x0040B] = { mathclass='alphabetic', adobename='uni040B' },
	[0x0040C] = { mathclass='alphabetic', adobename='uni040C' },
	[0x0040E] = { mathclass='alphabetic', adobename='uni040E' },
	[0x0040F] = { mathclass='alphabetic', adobename='uni040F' },
	[0x00410] = { mathclass='alphabetic', adobename='uni0410' },
	[0x00411] = { mathclass='alphabetic', adobename='uni0411' },
	[0x00412] = { mathclass='alphabetic', adobename='uni0412' },
	[0x00413] = { mathclass='alphabetic', adobename='uni0413' },
	[0x00414] = { mathclass='alphabetic', adobename='uni0414' },
	[0x00415] = { mathclass='alphabetic', adobename='uni0415' },
	[0x00416] = { mathclass='alphabetic', adobename='uni0416' },
	[0x00417] = { mathclass='alphabetic', adobename='uni0417' },
	[0x00418] = { mathclass='alphabetic', adobename='uni0418' },
	[0x00419] = { mathclass='alphabetic', adobename='uni0419' },
	[0x0041A] = { mathclass='alphabetic', adobename='uni041A' },
	[0x0041B] = { mathclass='alphabetic', adobename='uni041B' },
	[0x0041C] = { mathclass='alphabetic', adobename='uni041C' },
	[0x0041D] = { mathclass='alphabetic', adobename='uni041D' },
	[0x0041E] = { mathclass='alphabetic', adobename='uni041E' },
	[0x0041F] = { mathclass='alphabetic', adobename='uni041F' },
	[0x00420] = { mathclass='alphabetic', adobename='uni0420' },
	[0x00421] = { mathclass='alphabetic', adobename='uni0421' },
	[0x00422] = { mathclass='alphabetic', adobename='uni0422' },
	[0x00423] = { mathclass='alphabetic', adobename='uni0423' },
	[0x00424] = { mathclass='alphabetic', adobename='uni0424' },
	[0x00425] = { mathclass='alphabetic', adobename='uni0425' },
	[0x00426] = { mathclass='alphabetic', adobename='uni0426' },
	[0x00427] = { mathclass='alphabetic', adobename='uni0427' },
	[0x00428] = { mathclass='alphabetic', adobename='uni0428' },
	[0x00429] = { mathclass='alphabetic', adobename='uni0429' },
	[0x0042A] = { mathclass='alphabetic', adobename='uni042A' },
	[0x0042B] = { mathclass='alphabetic', adobename='uni042B' },
	[0x0042C] = { mathclass='alphabetic', adobename='uni042C' },
	[0x0042D] = { mathclass='alphabetic', adobename='uni042D' },
	[0x0042E] = { mathclass='alphabetic', adobename='uni042E' },
	[0x0042F] = { mathclass='alphabetic', adobename='uni042F' },
	[0x00430] = { mathclass='alphabetic', adobename='uni0430' },
	[0x00431] = { mathclass='alphabetic', adobename='uni0431' },
	[0x00432] = { mathclass='alphabetic', adobename='uni0432' },
	[0x00433] = { mathclass='alphabetic', adobename='uni0433' },
	[0x00434] = { mathclass='alphabetic', adobename='uni0434' },
	[0x00435] = { mathclass='alphabetic', adobename='uni0435' },
	[0x00436] = { mathclass='alphabetic', adobename='uni0436' },
	[0x00437] = { mathclass='alphabetic', adobename='uni0437' },
	[0x00438] = { mathclass='alphabetic', adobename='uni0438' },
	[0x00439] = { mathclass='alphabetic', adobename='uni0439' },
	[0x0043A] = { mathclass='alphabetic', adobename='uni043A' },
	[0x0043B] = { mathclass='alphabetic', adobename='uni043B' },
	[0x0043C] = { mathclass='alphabetic', adobename='uni043C' },
	[0x0043D] = { mathclass='alphabetic', adobename='uni043D' },
	[0x0043E] = { mathclass='alphabetic', adobename='uni043E' },
	[0x0043F] = { mathclass='alphabetic', adobename='uni043F' },
	[0x00440] = { mathclass='alphabetic', adobename='uni0440' },
	[0x00441] = { mathclass='alphabetic', adobename='uni0441' },
	[0x00442] = { mathclass='alphabetic', adobename='uni0442' },
	[0x00443] = { mathclass='alphabetic', adobename='uni0443' },
	[0x00444] = { mathclass='alphabetic', adobename='uni0444' },
	[0x00445] = { mathclass='alphabetic', adobename='uni0445' },
	[0x00446] = { mathclass='alphabetic', adobename='uni0446' },
	[0x00447] = { mathclass='alphabetic', adobename='uni0447' },
	[0x00448] = { mathclass='alphabetic', adobename='uni0448' },
	[0x00449] = { mathclass='alphabetic', adobename='uni0449' },
	[0x0044A] = { mathclass='alphabetic', adobename='uni044A' },
	[0x0044B] = { mathclass='alphabetic', adobename='uni044B' },
	[0x0044C] = { mathclass='alphabetic', adobename='uni044C' },
	[0x0044D] = { mathclass='alphabetic', adobename='uni044D' },
	[0x0044E] = { mathclass='alphabetic', adobename='uni044E' },
	[0x0044F] = { mathclass='alphabetic', adobename='uni044F' },
	[0x00451] = { mathclass='alphabetic', adobename='uni0451' },
	[0x00452] = { mathclass='alphabetic', adobename='uni0452' },
	[0x00453] = { mathclass='alphabetic', adobename='uni0453' },
	[0x00454] = { mathclass='alphabetic', adobename='uni0454' },
	[0x00455] = { mathclass='alphabetic', adobename='uni0455' },
	[0x00456] = { mathclass='alphabetic', adobename='uni0456' },
	[0x00457] = { mathclass='alphabetic', adobename='uni0457' },
	[0x00458] = { mathclass='alphabetic', adobename='uni0458' },
	[0x00459] = { mathclass='alphabetic', adobename='uni0459' },
	[0x0045A] = { mathclass='alphabetic', adobename='uni045A' },
	[0x0045B] = { mathclass='alphabetic', adobename='uni045B' },
	[0x0045C] = { mathclass='alphabetic', adobename='uni045C' },
	[0x0045E] = { mathclass='alphabetic', adobename='uni045E' },
	[0x0045F] = { mathclass='alphabetic', adobename='uni045F' },
	[0x00462] = { mathclass='alphabetic', adobename='uni0462' },
	[0x00463] = { mathclass='alphabetic', adobename='uni0463' },
	[0x0046A] = { mathclass='alphabetic', adobename='uni046A' },
	[0x0046B] = { mathclass='alphabetic', adobename='uni046B' },
	[0x00472] = { mathclass='alphabetic', adobename='uni0472' },
	[0x00473] = { mathclass='alphabetic', adobename='uni0473' },
	[0x00474] = { mathclass='alphabetic', adobename='uni0474' },
	[0x00475] = { mathclass='alphabetic', adobename='uni0475' },
	[0x00490] = { mathclass='alphabetic', adobename='uni0490' },
	[0x00491] = { mathclass='alphabetic', adobename='uni0491' },
	[0x01D00] = { mathclass='alphabetic', adobename='uni1D00', texname='textsca' },
	[0x01D07] = { mathclass='alphabetic', adobename='uni1D07', texname='textsce' },
	[0x01D1C] = { mathclass='alphabetic', adobename='uni1D1C', texname='textscu' },
	[0x01D81] = { mathclass='alphabetic', adobename='uni1D81', texname='textlhookd' },
	[0x01D84] = { mathclass='alphabetic', adobename='uni1D84', texname='textlhookk' },
	[0x01D85] = { mathclass='alphabetic', adobename='uni1D85', texname='textpalhookl' },
	[0x01D8A] = { mathclass='alphabetic', adobename='uni1D8A', texname='textlhooks' },
	[0x01D8D] = { mathclass='alphabetic', adobename='uni1D8D', texname='textlhookx' },
	[0x01D8E] = { mathclass='alphabetic', adobename='uni1D8E', texname='textlhookz' },
	[0x01E80] = { mathclass='alphabetic', adobename='uni1E80' },
	[0x01E81] = { mathclass='alphabetic', adobename='uni1E81' },
	[0x01E82] = { mathclass='alphabetic', adobename='uni1E82' },
	[0x01E83] = { mathclass='alphabetic', adobename='uni1E83' },
	[0x01E84] = { mathclass='alphabetic', adobename='uni1E84' },
	[0x01E85] = { mathclass='alphabetic', adobename='uni1E85' },
	[0x01EF2] = { mathclass='alphabetic', adobename='uni1EF2' },
	[0x01EF3] = { mathclass='alphabetic', adobename='uni1EF3' },
	[0x02002] = { mathclass='unknown', adobename='uni2002', texname='enspace' },
	[0x02003] = { mathclass='unknown', adobename='uni2003', texname='quad' },
	[0x02004] = { mathclass='unknown', adobename='uni2004', texname='thirdemspace' },
	[0x02005] = { mathclass='unknown', adobename='uni2005', texname='thickspace' },
	[0x02007] = { mathclass='unknown', adobename='uni2007', texname='digitspace' },
	[0x02008] = { mathclass='unknown', adobename='uni2008', texname='punctspace' },
	[0x02009] = { mathclass='unknown', adobename='uni2009', texname='thinspace' },
	[0x0200A] = { mathclass='unknown', adobename='uni200A', texname='hspace' },
	[0x0200B] = { mathclass='unknown', adobename='uni200B', texname='zwspace' },
	[0x0200C] = { mathclass='unknown', adobename='uni200C', texname='zwnonjoin' },
	[0x0200D] = { mathclass='unknown', adobename='uni200D', texname='zwjoin' },
	[0x0200E] = { mathclass='unknown', adobename='uni200E', texname='LtoRmark' },
	[0x0200F] = { mathclass='unknown', adobename='uni200F', texname='RtoLmark' },
	[0x02010] = { mathclass='punctuation', adobename='uni2010', texname='texthyphen' },
	[0x02011] = { mathclass='unknown', adobename='uni2011', texname='nobreakhyphen' },
	[0x02012] = { mathclass='punctuation', adobename='figuredash', texname='figdash' },
	[0x02013] = { mathclass='punctuation', adobename='endash', texname='endash' },
	[0x02014] = { mathclass='punctuation', adobename='emdash', texname='emdash' },
	[0x02015] = { mathclass='unknown', adobename='uni2015', texname='horizbar' },
	[0x02016] = { mathclass='fence', adobename='uni2016', texname='Vert' },
	[0x02017] = { mathclass='unknown', adobename='uni2017', texname='twolowline' },
	[0x02018] = { mathclass='opening', adobename='quoteleft', texname='lq' },
	[0x02019] = { mathclass='closing', adobename='quoteright', texname='rq' },
	[0x0201A] = { mathclass='opening', adobename='quotesinglbase', texname='quotsinglbase' },
	[0x0201B] = { mathclass='closing', adobename='uni201B', texname='quotsinglright' },
	[0x0201C] = { mathclass='opening', adobename='quotedblleft', texname='textquotedblleft' },
	[0x0201D] = { mathclass='closing', adobename='quotedblright', texname='textquotedblright' },
	[0x0201E] = { mathclass='opening', adobename='quotedblbase', texname='quotdblbase' },
	[0x0201F] = { mathclass='closing', adobename='uni201F', texname='quotdblright' },
	[0x02020] = { mathclass='binary', adobename='dagger', texname='dagger' },
	[0x02021] = { mathclass='binary', adobename='daggerdbl', texname='ddagger' },
	[0x02022] = { mathclass='binary', adobename='bullet', texname='smblkcircle' },
	[0x02024] = { mathclass='unknown', adobename='onedotenleader', texname='enleaderonedot' },
	[0x02025] = { mathclass='unknown', adobename='twodotenleader', texname='enleadertwodots' },
	[0x02026] = { mathclass='unknown', adobename='ellipsis', texname='dots' },
	[0x02027] = { mathclass='unknown', adobename='uni2027', texname='hyphenpoint' },
	[0x02030] = { mathclass='normal', adobename='perthousand', texname='textperthousand' },
	[0x02031] = { mathclass='normal', adobename='uni2031', texname='textpertenthousand' },
	[0x02032] = { mathclass='normal', adobename='uni2032', texname='textprime' },
	[0x02033] = { mathclass='normal', adobename='uni2033', texname='textdprime' },
	[0x02034] = { mathclass='normal', adobename='uni2034', texname='texttrprime' },
	[0x02035] = { mathclass='normal', adobename='uni2035', texname='textbackprime' },
	[0x02036] = { mathclass='normal', adobename='uni2036', texname='textbackdprime' },
	[0x02037] = { mathclass='normal', adobename='uni2037', texname='textbacktrprime' },
	[0x02038] = { mathclass='unknown', adobename='uni2038', texname='caretinsert' },
	[0x02039] = { mathclass='opening', adobename='guilsinglleft', texname='guilsinglleft' },
	[0x0203A] = { mathclass='closing', adobename='guilsinglright', texname='guilsinglright' },
	[0x0203B] = { mathclass='normal', adobename='uni203B', texname='textreferencemark' },
	[0x0203C] = { mathclass='unknown', adobename='uni203C', texname='Exclam' },
	[0x0203E] = { mathclass='unknown', adobename='uni203E', texname='overline' },
	[0x02040] = { mathclass='binary', adobename='uni2040', texname='tieconcat' },
	[0x02043] = { mathclass='unknown', adobename='uni2043', texname='hyphenbullet' },
	[0x02044] = { mathclass='binary', adobename='fraction', texname='fracslash' },
	[0x02047] = { mathclass='unknown', adobename='uni2047', texname='Question' },
	[0x0204E] = { mathclass='unknown', adobename='uni204E', texname='textasterisklow' },
	[0x0204F] = { mathclass='unknown', adobename='uni204F', texname='textsemicolonreversed' },
	[0x02050] = { mathclass='relation', adobename='uni2050', texname='closure' },
	[0x02051] = { mathclass='normal', adobename='uni2051', texname='textAsterisks' },
	[0x02052] = { mathclass='normal', adobename='uni2052', texname='textdiscount' },
	[0x02057] = { mathclass='normal', adobename='uni2057', texname='textqprime' },
	[0x0205F] = { mathclass='normal', adobename='uni205F', texname='medmathspace' },
	[0x02060] = { mathclass='unknown', adobename='uni2060', texname='wordjoin' },
	[0x02061] = { mathclass='unknown', adobename='uni2061', texname='functionapply' },
	[0x02062] = { mathclass='unknown', adobename='uni2062', texname='invisibletimes' },
	[0x02063] = { mathclass='unknown', adobename='uni2063', texname='invisiblesep' },
	[0x02070] = { mathclass='unknown', adobename='zerosuperior', texname='supzero' },
	[0x02074] = { mathclass='unknown', adobename='foursuperior', texname='supfour' },
	[0x02075] = { mathclass='unknown', adobename='fivesuperior', texname='supfive' },
	[0x02076] = { mathclass='unknown', adobename='sixsuperior', texname='supsix' },
	[0x02077] = { mathclass='unknown', adobename='sevensuperior', texname='supseven' },
	[0x02078] = { mathclass='unknown', adobename='eightsuperior', texname='supeight' },
	[0x02079] = { mathclass='unknown', adobename='ninesuperior', texname='supnine' },
	[0x0207D] = { mathclass='unknown', adobename='parenleftsuperior', texname='suplparen' },
	[0x0207E] = { mathclass='unknown', adobename='parenrightsuperior', texname='suprparen' },
	[0x0207F] = { mathclass='unknown', adobename='nsuperior', texname='supn' },
	[0x02080] = { mathclass='unknown', adobename='zeroinferior', texname='subzero' },
	[0x02081] = { mathclass='unknown', adobename='oneinferior', texname='subone' },
	[0x02082] = { mathclass='unknown', adobename='twoinferior', texname='subtwo' },
	[0x02083] = { mathclass='unknown', adobename='threeinferior', texname='subthree' },
	[0x02084] = { mathclass='unknown', adobename='fourinferior', texname='subfour' },
	[0x02085] = { mathclass='unknown', adobename='fiveinferior', texname='subfive' },
	[0x02086] = { mathclass='unknown', adobename='sixinferior', texname='subsix' },
	[0x02087] = { mathclass='unknown', adobename='seveninferior', texname='subseven' },
	[0x02088] = { mathclass='unknown', adobename='eightinferior', texname='subeight' },
	[0x02089] = { mathclass='unknown', adobename='nineinferior', texname='subnine' },
	[0x0208D] = { mathclass='unknown', adobename='parenleftinferior', texname='sublparen' },
	[0x0208E] = { mathclass='unknown', adobename='parenrightinferior', texname='subrparen' },
	[0x020A1] = { mathclass='unknown', adobename='colonmonetary', texname='textcolonmonetary' },
	[0x020A3] = { mathclass='unknown', adobename='uni20A3', texname='textfranc' },
	[0x020A4] = { mathclass='unknown', adobename='uni20A4', texname='textlira' },
	[0x020A7] = { mathclass='normal', adobename='uni20A7', texname='textpesetas' },
	[0x020AC] = { mathclass='unknown', adobename='uni20AC', texname='euro' },
	[0x020D0] = { mathclass='diacritic', adobename='uni20D0', texname='leftharpoonaccent' },
	[0x020D1] = { mathclass='diacritic', adobename='uni20D1', texname='rightharpoonaccent' },
	[0x020D2] = { mathclass='diacritic', adobename='uni20D2', texname='vertoverlay' },
	[0x020D6] = { mathclass='diacritic', adobename='uni20D6', texname='overleftarrow' },
	[0x020D7] = { mathclass='diacritic', adobename='uni20D7', texname='vec' },
	[0x020DB] = { mathclass='diacritic', adobename='uni20DB', texname='dddot' },
	[0x020DC] = { mathclass='diacritic', adobename='uni20DC', texname='ddddot' },
	[0x020DD] = { mathclass='unknown', adobename='uni20DD', texname='enclosecircle' },
	[0x020DE] = { mathclass='unknown', adobename='uni20DE', texname='enclosesquare' },
	[0x020DF] = { mathclass='unknown', adobename='uni20DF', texname='enclosediamond' },
	[0x020E1] = { mathclass='diacritic', adobename='uni20E1', texname='overleftrightarrow' },
	[0x020E4] = { mathclass='unknown', adobename='uni20E4', texname='enclosetriangle' },
	[0x020E5] = { mathclass='diacritic', adobename='uni20E5', texname='textoverlaybackslash' },
	[0x020E6] = { mathclass='diacritic', adobename='uni20E6', texname='textoverlaydoublevert' },
	[0x020E7] = { mathclass='diacritic', adobename='uni20E7', texname='annuity' },
	[0x020E8] = { mathclass='diacritic', adobename='uni20E8', texname='threeunderdot' },
	[0x020E9] = { mathclass='diacritic', adobename='uni20E9', texname='widebridgeabove' },
	[0x020EA] = { mathclass='diacritic', adobename='uni20EA', texname='textoverlayleftarrow' },
	[0x020EB] = { mathclass='unknown', adobename='uni20EB', texname='textoverlaytwosolidus' },
	[0x020EC] = { mathclass='diacritic', adobename='uni20EC', texname='overrightharpoondown' },
	[0x020ED] = { mathclass='diacritic', adobename='uni20ED', texname='overleftharpoondown' },
	[0x020EE] = { mathclass='diacritic', adobename='uni20EE', texname='underleftarrow' },
	[0x020EF] = { mathclass='diacritic', adobename='uni20EF', texname='underrightarrow' },
	[0x02102] = { mathclass='alphabetic', adobename='uni2102', texname='BbbC' },
	[0x02105] = { mathclass='normal', adobename='uni2105', texname='incare' },
	[0x02107] = { mathclass='unknown', adobename='uni2107', texname='Eulerconst' },
	[0x0210A] = { mathclass='alphabetic', adobename='uni210A', texname='scrg' },
	[0x0210B] = { mathclass='alphabetic', adobename='uni210B', texname='scrH' },
	[0x0210C] = { mathclass='alphabetic', adobename='uni210C', texname='frakH' },
	[0x0210D] = { mathclass='alphabetic', adobename='uni210D', texname='BbbH' },
	[0x0210E] = { mathclass='unknown', adobename='uni210E', texname='Planckconst' },
	[0x0210F] = { mathclass='alphabetic', adobename='uni210F', texname='hslash' },
	[0x02110] = { mathclass='alphabetic', adobename='uni2110', texname='scrI' },
	[0x02111] = { mathclass='alphabetic', adobename='uni2111', texname='Im' },
	[0x02112] = { mathclass='alphabetic', adobename='uni2112', texname='scrL' },
	[0x02113] = { mathclass='alphabetic', adobename='uni2113', texname='ell' },
	[0x02115] = { mathclass='alphabetic', adobename='uni2115', texname='BbbN' },
	[0x02116] = { mathclass='normal', adobename='uni2116', texname='textnumero' },
	[0x02117] = { mathclass='normal', adobename='uni2117', texname='textcircledP' },
	[0x02118] = { mathclass='alphabetic', adobename='uni2118', texname='wp' },
	[0x02119] = { mathclass='alphabetic', adobename='uni2119', texname='BbbP' },
	[0x0211A] = { mathclass='alphabetic', adobename='uni211A', texname='BbbQ' },
	[0x0211B] = { mathclass='alphabetic', adobename='uni211B', texname='scrR' },
	[0x0211C] = { mathclass='alphabetic', adobename='uni211C', texname='Re' },
	[0x0211D] = { mathclass='alphabetic', adobename='uni211D', texname='BbbR' },
	[0x0211E] = { mathclass='normal', adobename='uni211E', texname='textrecipe' },
	[0x02122] = { mathclass='unknown', adobename='trademark', texname='texttrademark' },
	[0x02124] = { mathclass='alphabetic', adobename='uni2124', texname='BbbZ' },
	[0x02125] = { mathclass='unknown', adobename='uni2125', texname='textoz' },
	[0x02126] = { mathclass='normal', adobename='uni2126', texname='textohm' },
	[0x02127] = { mathclass='normal', adobename='uni2127', texname='mho' },
	[0x02128] = { mathclass='alphabetic', adobename='uni2128', texname='frakZ' },
	[0x02129] = { mathclass='alphabetic', adobename='uni2129', texname='turnediota' },
	[0x0212B] = { mathclass='alphabetic', adobename='uni212B', texname='Angstrom' },
	[0x0212C] = { mathclass='alphabetic', adobename='uni212C', texname='scrB' },
	[0x0212D] = { mathclass='alphabetic', adobename='uni212D', texname='frakC' },
	[0x0212E] = { mathclass='alphabetic', adobename='uni212E', texname='textestimated' },
	[0x0212F] = { mathclass='alphabetic', adobename='uni212F', texname='scre' },
	[0x02130] = { mathclass='alphabetic', adobename='uni2130', texname='scrE' },
	[0x02131] = { mathclass='alphabetic', adobename='uni2131', texname='scrF' },
	[0x02132] = { mathclass='normal', adobename='uni2132', texname='Finv' },
	[0x02133] = { mathclass='alphabetic', adobename='uni2133', texname='scrM' },
	[0x02134] = { mathclass='alphabetic', adobename='uni2134', texname='scro' },
	[0x02135] = { mathclass='alphabetic', adobename='uni2135', texname='aleph' },
	[0x02136] = { mathclass='alphabetic', adobename='uni2136', texname='beth' },
	[0x02137] = { mathclass='alphabetic', adobename='uni2137', texname='gimel' },
	[0x02138] = { mathclass='alphabetic', adobename='uni2138', texname='daleth' },
	[0x0213C] = { mathclass='normal', adobename='uni213C', texname='Bbbpi' },
	[0x0213D] = { mathclass='alphabetic', adobename='uni213D', texname='Bbbgamma' },
	[0x0213E] = { mathclass='alphabetic', adobename='uni213E', texname='BbbGamma' },
	[0x0213F] = { mathclass='alphabetic', adobename='uni213F', texname='BbbPi' },
	[0x02140] = { mathclass='large', adobename='uni2140', texname='Bbbsum' },
	[0x02141] = { mathclass='normal', adobename='uni2141', texname='Game' },
	[0x02142] = { mathclass='normal', adobename='uni2142', texname='sansLmirrored' },
	[0x02143] = { mathclass='normal', adobename='uni2143', texname='sansLinverted' },
	[0x02144] = { mathclass='normal', adobename='uni2144', texname='Yup' },
	[0x02145] = { mathclass='normal', adobename='uni2145', texname='itBbbD' },
	[0x02146] = { mathclass='normal', adobename='uni2146', texname='itBbbd' },
	[0x02147] = { mathclass='normal', adobename='uni2147', texname='itBbbe' },
	[0x02148] = { mathclass='normal', adobename='uni2148', texname='itBbbi' },
	[0x02149] = { mathclass='normal', adobename='uni2149', texname='itBbbj' },
	[0x0214A] = { mathclass='unknown', adobename='uni214A', texname='PropertyLine' },
	[0x0214B] = { mathclass='binary', adobename='uni214B', texname='upand' },
	[0x02153] = { mathclass='unknown', adobename='onethird', texname='fraconethird' },
	[0x02154] = { mathclass='unknown', adobename='twothirds', texname='fractwothirds' },
	[0x02155] = { mathclass='unknown', adobename='uni2155', texname='fraconefifth' },
	[0x02156] = { mathclass='unknown', adobename='uni2156', texname='fractwofifths' },
	[0x02157] = { mathclass='unknown', adobename='uni2157', texname='fracthreefifths' },
	[0x02158] = { mathclass='unknown', adobename='uni2158', texname='fracfourfifths' },
	[0x02159] = { mathclass='unknown', adobename='uni2159', texname='fraconesixth' },
	[0x0215A] = { mathclass='unknown', adobename='uni215A', texname='fracfivesixths' },
	[0x0215B] = { mathclass='unknown', adobename='oneeighth', texname='fraconeeighth' },
	[0x0215C] = { mathclass='unknown', adobename='threeeighths', texname='fracthreeeighths' },
	[0x0215D] = { mathclass='unknown', adobename='fiveeighths', texname='fracfiveeighths' },
	[0x0215E] = { mathclass='unknown', adobename='seveneighths', texname='fracseveneights' },
	[0x02190] = { mathclass='relation', adobename='uni2190', texname='leftarrow' },
	[0x02191] = { mathclass='relation', adobename='uni2191', texname='uparrow' },
	[0x02192] = { mathclass='relation', adobename='uni2192', texname='rightarrow' },
	[0x02193] = { mathclass='relation', adobename='uni2193', texname='downarrow' },
	[0x02194] = { mathclass='relation', adobename='uni2194', texname='leftrightarrow' },
	[0x02195] = { mathclass='relation', adobename='uni2195', texname='updownarrow' },
	[0x02196] = { mathclass='relation', adobename='uni2196', texname='nwarrow' },
	[0x02197] = { mathclass='relation', adobename='uni2197', texname='nearrow' },
	[0x02198] = { mathclass='relation', adobename='uni2198', texname='searrow' },
	[0x02199] = { mathclass='relation', adobename='uni2199', texname='swarrow' },
	[0x0219A] = { mathclass='relation', adobename='uni219A', texname='nleftarrow' },
	[0x0219B] = { mathclass='relation', adobename='uni219B', texname='nrightarrow' },
	[0x0219C] = { mathclass='relation', adobename='uni219C', texname='leftsquigarrow' },
	[0x0219D] = { mathclass='relation', adobename='uni219D', texname='rightsquigarrow' },
	[0x0219E] = { mathclass='relation', adobename='uni219E', texname='twoheadleftarrow' },
	[0x0219F] = { mathclass='relation', adobename='uni219F', texname='twoheaduparrow' },
	[0x021A0] = { mathclass='relation', adobename='uni21A0', texname='twoheadrightarrow' },
	[0x021A1] = { mathclass='relation', adobename='uni21A1', texname='twoheaddownarrow' },
	[0x021A2] = { mathclass='relation', adobename='uni21A2', texname='leftarrowtail' },
	[0x021A3] = { mathclass='relation', adobename='uni21A3', texname='rightarrowtail' },
	[0x021A4] = { mathclass='relation', adobename='uni21A4', texname='mapsfrom' },
	[0x021A5] = { mathclass='relation', adobename='uni21A5', texname='mapsup' },
	[0x021A6] = { mathclass='relation', adobename='uni21A6', texname='mapsto' },
	[0x021A7] = { mathclass='relation', adobename='uni21A7', texname='mapsdown' },
	[0x021A8] = { mathclass='unknown', adobename='uni21A8', texname='updownarrowbar' },
	[0x021A9] = { mathclass='relation', adobename='uni21A9', texname='hookleftarrow' },
	[0x021AA] = { mathclass='relation', adobename='uni21AA', texname='hookrightarrow' },
	[0x021AB] = { mathclass='relation', adobename='uni21AB', texname='looparrowleft' },
	[0x021AC] = { mathclass='relation', adobename='uni21AC', texname='looparrowright' },
	[0x021AD] = { mathclass='relation', adobename='uni21AD', texname='leftrightsquigarrow' },
	[0x021AE] = { mathclass='relation', adobename='uni21AE', texname='nleftrightarrow' },
	[0x021AF] = { mathclass='relation', adobename='uni21AF', texname='downzigzagarrow' },
	[0x021B0] = { mathclass='relation', adobename='uni21B0', texname='Lsh' },
	[0x021B1] = { mathclass='relation', adobename='uni21B1', texname='Rsh' },
	[0x021B2] = { mathclass='relation', adobename='uni21B2', texname='Ldsh' },
	[0x021B3] = { mathclass='relation', adobename='uni21B3', texname='Rdsh' },
	[0x021B4] = { mathclass='unknown', adobename='uni21B4', texname='linefeed' },
	[0x021B5] = { mathclass='unknown', adobename='uni21B5', texname='carriagereturn' },
	[0x021B6] = { mathclass='relation', adobename='uni21B6', texname='curvearrowleft' },
	[0x021B7] = { mathclass='relation', adobename='uni21B7', texname='curvearrowright' },
	[0x021B8] = { mathclass='unknown', adobename='uni21B8', texname='barovernorthwestarrow' },
	[0x021B9] = { mathclass='unknown', adobename='uni21B9', texname='barleftarrowrightarrowbar' },
	[0x021BA] = { mathclass='unknown', adobename='uni21BA', texname='acwopencirclearrow' },
	[0x021BB] = { mathclass='unknown', adobename='uni21BB', texname='cwopencirclearrow' },
	[0x021BC] = { mathclass='relation', adobename='uni21BC', texname='leftharpoonup' },
	[0x021BD] = { mathclass='relation', adobename='uni21BD', texname='leftharpoondown' },
	[0x021BE] = { mathclass='relation', adobename='uni21BE', texname='upharpoonright' },
	[0x021BF] = { mathclass='relation', adobename='uni21BF', texname='upharpoonleft' },
	[0x021C0] = { mathclass='relation', adobename='uni21C0', texname='rightharpoonup' },
	[0x021C1] = { mathclass='relation', adobename='uni21C1', texname='rightharpoondown' },
	[0x021C2] = { mathclass='relation', adobename='uni21C2', texname='downharpoonright' },
	[0x021C3] = { mathclass='relation', adobename='uni21C3', texname='downharpoonleft' },
	[0x021C4] = { mathclass='relation', adobename='uni21C4', texname='rightleftarrows' },
	[0x021C5] = { mathclass='relation', adobename='uni21C5', texname='updownarrows' },
	[0x021C6] = { mathclass='relation', adobename='uni21C6', texname='leftrightarrows' },
	[0x021C7] = { mathclass='relation', adobename='uni21C7', texname='leftleftarrows' },
	[0x021C8] = { mathclass='relation', adobename='uni21C8', texname='upuparrows' },
	[0x021C9] = { mathclass='relation', adobename='uni21C9', texname='rightrightarrows' },
	[0x021CA] = { mathclass='relation', adobename='uni21CA', texname='downdownarrows' },
	[0x021CB] = { mathclass='relation', adobename='uni21CB', texname='leftrightharpoons' },
	[0x021CC] = { mathclass='relation', adobename='uni21CC', texname='rightleftharpoons' },
	[0x021CD] = { mathclass='relation', adobename='uni21CD', texname='nLeftarrow' },
	[0x021CE] = { mathclass='relation', adobename='uni21CE', texname='nLeftrightarrow' },
	[0x021CF] = { mathclass='relation', adobename='uni21CF', texname='nRightarrow' },
	[0x021D0] = { mathclass='relation', adobename='uni21D0', texname='Leftarrow' },
	[0x021D1] = { mathclass='relation', adobename='uni21D1', texname='Uparrow' },
	[0x021D2] = { mathclass='relation', adobename='uni21D2', texname='Rightarrow' },
	[0x021D3] = { mathclass='relation', adobename='uni21D3', texname='Downarrow' },
	[0x021D4] = { mathclass='relation', adobename='uni21D4', texname='Leftrightarrow' },
	[0x021D5] = { mathclass='relation', adobename='uni21D5', texname='Updownarrow' },
	[0x021D6] = { mathclass='relation', adobename='uni21D6', texname='Nwarrow' },
	[0x021D7] = { mathclass='relation', adobename='uni21D7', texname='Nearrow' },
	[0x021D8] = { mathclass='relation', adobename='uni21D8', texname='Searrow' },
	[0x021D9] = { mathclass='relation', adobename='uni21D9', texname='Swarrow' },
	[0x021DA] = { mathclass='relation', adobename='uni21DA', texname='Lleftarrow' },
	[0x021DB] = { mathclass='relation', adobename='uni21DB', texname='Rrightarrow' },
	[0x021DC] = { mathclass='relation', adobename='uni21DC', texname='leftzigzagarrow' },
	[0x021DD] = { mathclass='relation', adobename='uni21DD', texname='rightzigzagarrow' },
	[0x021DE] = { mathclass='unknown', adobename='uni21DE', texname='nHuparrow' },
	[0x021DF] = { mathclass='unknown', adobename='uni21DF', texname='nHdownarrow' },
	[0x021E0] = { mathclass='unknown', adobename='uni21E0', texname='leftdasharrow' },
	[0x021E1] = { mathclass='unknown', adobename='uni21E1', texname='updasharrow' },
	[0x021E2] = { mathclass='unknown', adobename='uni21E2', texname='rightdasharrow' },
	[0x021E3] = { mathclass='unknown', adobename='uni21E3', texname='downdasharrow' },
	[0x021E4] = { mathclass='relation', adobename='uni21E4', texname='barleftarrow' },
	[0x021E5] = { mathclass='relation', adobename='uni21E5', texname='rightarrowbar' },
	[0x021E6] = { mathclass='unknown', adobename='uni21E6', texname='leftwhitearrow' },
	[0x021E7] = { mathclass='unknown', adobename='uni21E7', texname='upwhitearrow' },
	[0x021E8] = { mathclass='unknown', adobename='uni21E8', texname='rightwhitearrow' },
	[0x021E9] = { mathclass='unknown', adobename='uni21E9', texname='downwhitearrow' },
	[0x021EA] = { mathclass='unknown', adobename='uni21EA', texname='whitearrowupfrombar' },
	[0x021F4] = { mathclass='relation', adobename='uni21F4', texname='circleonrightarrow' },
	[0x021F5] = { mathclass='relation', adobename='uni21F5', texname='downuparrows' },
	[0x021F6] = { mathclass='relation', adobename='uni21F6', texname='rightthreearrows' },
	[0x021F7] = { mathclass='relation', adobename='uni21F7', texname='nvleftarrow' },
	[0x021F8] = { mathclass='relation', adobename='uni21F8', texname='nvrightarrow' },
	[0x021F9] = { mathclass='relation', adobename='uni21F9', texname='nvleftrightarrow' },
	[0x021FA] = { mathclass='relation', adobename='uni21FA', texname='nVleftarrow' },
	[0x021FB] = { mathclass='relation', adobename='uni21FB', texname='nVrightarrow' },
	[0x021FC] = { mathclass='relation', adobename='uni21FC', texname='nVleftrightarrow' },
	[0x021FD] = { mathclass='relation', adobename='uni21FD', texname='leftarrowtriangle' },
	[0x021FE] = { mathclass='relation', adobename='uni21FE', texname='rightarrowtriangle' },
	[0x021FF] = { mathclass='relation', adobename='uni21FF', texname='leftrightarrowtriangle' },
	[0x02200] = { mathclass='normal', adobename='uni2200', texname='forall' },
	[0x02201] = { mathclass='normal', adobename='uni2201', texname='complement' },
	[0x02202] = { mathclass='normal', adobename='uni2202', texname='partial' },
	[0x02203] = { mathclass='normal', adobename='uni2203', texname='exists' },
	[0x02204] = { mathclass='normal', adobename='uni2204', texname='nexists' },
	[0x02205] = { mathclass='normal', adobename='uni2205', texname='varnothing' },
	[0x02206] = { mathclass='normal', adobename='uni2206', texname='increment' },
	[0x02207] = { mathclass='normal', adobename='uni2207', texname='nabla' },
	[0x02208] = { mathclass='relation', adobename='uni2208', texname='in' },
	[0x02209] = { mathclass='relation', adobename='uni2209', texname='notin' },
	[0x0220A] = { mathclass='relation', adobename='uni220A', texname='smallin' },
	[0x0220B] = { mathclass='relation', adobename='uni220B', texname='ni' },
	[0x0220C] = { mathclass='relation', adobename='uni220C', texname='nni' },
	[0x0220D] = { mathclass='relation', adobename='uni220D', texname='smallni' },
	[0x0220E] = { mathclass='normal', adobename='uni220E', texname='QED' },
	[0x0220F] = { mathclass='large', adobename='uni220F', texname='prod' },
	[0x02210] = { mathclass='large', adobename='uni2210', texname='coprod' },
	[0x02211] = { mathclass='large', adobename='uni2211', texname='sum' },
	[0x02212] = { mathclass='binary', adobename='minus', texname='minus' },
	[0x02213] = { mathclass='binary', adobename='uni2213', texname='mp' },
	[0x02214] = { mathclass='binary', adobename='uni2214', texname='dotplus' },
	[0x02215] = { mathclass='binary', adobename='uni2215', texname='slash' },
	[0x02216] = { mathclass='binary', adobename='uni2216', texname='smallsetminus' },
	[0x02217] = { mathclass='binary', adobename='uni2217', texname='ast' },
	[0x02218] = { mathclass='binary', adobename='uni2218', texname='vysmwhtcircle' },
	[0x02219] = { mathclass='binary', adobename='uni2219', texname='vysmblkcircle' },
	[0x0221A] = { mathclass='opening', adobename='uni221A', texname='sqrt' },
	[0x0221B] = { mathclass='unknown', adobename='uni221B', texname='cuberoot' },
	[0x0221C] = { mathclass='unknown', adobename='uni221C', texname='fourthroot' },
	[0x0221D] = { mathclass='relation', adobename='uni221D', texname='propto' },
	[0x0221E] = { mathclass='normal', adobename='uni221E', texname='infty' },
	[0x0221F] = { mathclass='normal', adobename='uni221F', texname='rightangle' },
	[0x02220] = { mathclass='normal', adobename='uni2220', texname='angle' },
	[0x02221] = { mathclass='normal', adobename='uni2221', texname='measuredangle' },
	[0x02222] = { mathclass='normal', adobename='uni2222', texname='sphericalangle' },
	[0x02223] = { mathclass='relation', adobename='uni2223', texname='mid' },
	[0x02224] = { mathclass='relation', adobename='uni2224', texname='nmid' },
	[0x02225] = { mathclass='relation', adobename='uni2225', texname='parallel' },
	[0x02226] = { mathclass='relation', adobename='uni2226', texname='nparallel' },
	[0x02227] = { mathclass='binary', adobename='uni2227', texname='wedge' },
	[0x02228] = { mathclass='binary', adobename='uni2228', texname='vee' },
	[0x02229] = { mathclass='binary', adobename='uni2229', texname='cap' },
	[0x0222A] = { mathclass='binary', adobename='uni222A', texname='cup' },
	[0x0222B] = { mathclass='large', adobename='uni222B', texname='int' },
	[0x0222C] = { mathclass='large', adobename='uni222C', texname='iint' },
	[0x0222D] = { mathclass='large', adobename='uni222D', texname='iiint' },
	[0x0222E] = { mathclass='large', adobename='uni222E', texname='oint' },
	[0x0222F] = { mathclass='large', adobename='uni222F', texname='oiint' },
	[0x02230] = { mathclass='large', adobename='uni2230', texname='oiiint' },
	[0x02231] = { mathclass='large', adobename='uni2231', texname='intclockwise' },
	[0x02232] = { mathclass='large', adobename='uni2232', texname='varointclockwise' },
	[0x02233] = { mathclass='large', adobename='uni2233', texname='ointctrclockwise' },
	[0x02234] = { mathclass='normal', adobename='uni2234', texname='therefore' },
	[0x02235] = { mathclass='normal', adobename='uni2235', texname='because' },
	[0x02236] = { mathclass='unknown', adobename='uni2236', texname='colon' },
	[0x02237] = { mathclass='unknown', adobename='uni2237', texname='Colon' },
	[0x02238] = { mathclass='binary', adobename='uni2238', texname='dotminus' },
	[0x02239] = { mathclass='unknown', adobename='uni2239', texname='dashcolon' },
	[0x0223A] = { mathclass='unknown', adobename='uni223A', texname='dotsminusdots' },
	[0x0223B] = { mathclass='unknown', adobename='uni223B', texname='kernelcontraction' },
	[0x0223C] = { mathclass='relation', adobename='uni223C', texname='sim' },
	[0x0223D] = { mathclass='relation', adobename='uni223D', texname='backsim' },
	[0x0223E] = { mathclass='unknown', adobename='uni223E', texname='ac' },
	[0x0223F] = { mathclass='unknown', adobename='uni223F', texname='sinewave' },
	[0x02240] = { mathclass='binary', adobename='uni2240', texname='wr' },
	[0x02241] = { mathclass='relation', adobename='uni2241', texname='nsim' },
	[0x02242] = { mathclass='relation', adobename='uni2242', texname='eqsim' },
	[0x02243] = { mathclass='relation', adobename='uni2243', texname='simeq' },
	[0x02244] = { mathclass='relation', adobename='uni2244', texname='nsime' },
	[0x02245] = { mathclass='relation', adobename='uni2245', texname='cong' },
	[0x02246] = { mathclass='relation', adobename='uni2246', texname='simneqq' },
	[0x02247] = { mathclass='relation', adobename='uni2247', texname='ncong' },
	[0x02248] = { mathclass='relation', adobename='uni2248', texname='approx' },
	[0x02249] = { mathclass='relation', adobename='uni2249', texname='napprox' },
	[0x0224A] = { mathclass='relation', adobename='uni224A', texname='approxeq' },
	[0x0224B] = { mathclass='relation', adobename='uni224B', texname='approxident' },
	[0x0224C] = { mathclass='relation', adobename='uni224C', texname='backcong' },
	[0x0224D] = { mathclass='relation', adobename='uni224D', texname='asymp' },
	[0x0224E] = { mathclass='relation', adobename='uni224E', texname='Bumpeq' },
	[0x0224F] = { mathclass='relation', adobename='uni224F', texname='bumpeq' },
	[0x02250] = { mathclass='relation', adobename='uni2250', texname='doteq' },
	[0x02251] = { mathclass='relation', adobename='uni2251', texname='Doteq' },
	[0x02252] = { mathclass='relation', adobename='uni2252', texname='fallingdotseq' },
	[0x02253] = { mathclass='relation', adobename='uni2253', texname='risingdotseq' },
	[0x02254] = { mathclass='relation', adobename='uni2254', texname='coloneq' },
	[0x02255] = { mathclass='relation', adobename='uni2255', texname='eqcolon' },
	[0x02256] = { mathclass='relation', adobename='uni2256', texname='eqcirc' },
	[0x02257] = { mathclass='relation', adobename='uni2257', texname='circeq' },
	[0x02258] = { mathclass='relation', adobename='uni2258', texname='arceq' },
	[0x02259] = { mathclass='relation', adobename='uni2259', texname='wedgeq' },
	[0x0225A] = { mathclass='relation', adobename='uni225A', texname='veeeq' },
	[0x0225B] = { mathclass='relation', adobename='uni225B', texname='stareq' },
	[0x0225C] = { mathclass='relation', adobename='uni225C', texname='triangleq' },
	[0x0225D] = { mathclass='relation', adobename='uni225D', texname='eqdef' },
	[0x0225E] = { mathclass='relation', adobename='uni225E', texname='measeq' },
	[0x0225F] = { mathclass='relation', adobename='uni225F', texname='questeq' },
	[0x02260] = { mathclass='relation', adobename='uni2260', texname='ne' },
	[0x02261] = { mathclass='relation', adobename='uni2261', texname='equiv' },
	[0x02262] = { mathclass='relation', adobename='uni2262', texname='nequiv' },
	[0x02263] = { mathclass='relation', adobename='uni2263', texname='Equiv' },
	[0x02264] = { mathclass='relation', adobename='uni2264', texname='leq' },
	[0x02265] = { mathclass='relation', adobename='uni2265', texname='geq' },
	[0x02266] = { mathclass='relation', adobename='uni2266', texname='leqq' },
	[0x02267] = { mathclass='relation', adobename='uni2267', texname='geqq' },
	[0x02268] = { mathclass='relation', adobename='uni2268', texname='lneqq' },
	[0x02269] = { mathclass='relation', adobename='uni2269', texname='gneqq' },
	[0x0226A] = { mathclass='relation', adobename='uni226A', texname='ll' },
	[0x0226B] = { mathclass='relation', adobename='uni226B', texname='gg' },
	[0x0226C] = { mathclass='relation', adobename='uni226C', texname='between' },
	[0x0226D] = { mathclass='relation', adobename='uni226D', texname='nasymp' },
	[0x0226E] = { mathclass='relation', adobename='uni226E', texname='nless' },
	[0x0226F] = { mathclass='relation', adobename='uni226F', texname='ngtr' },
	[0x02270] = { mathclass='relation', adobename='uni2270', texname='nleq' },
	[0x02271] = { mathclass='relation', adobename='uni2271', texname='ngeq' },
	[0x02272] = { mathclass='relation', adobename='uni2272', texname='lesssim' },
	[0x02273] = { mathclass='relation', adobename='uni2273', texname='gtrsim' },
	[0x02274] = { mathclass='relation', adobename='uni2274', texname='nlesssim' },
	[0x02275] = { mathclass='relation', adobename='uni2275', texname='ngtrsim' },
	[0x02276] = { mathclass='relation', adobename='uni2276', texname='lessgtr' },
	[0x02277] = { mathclass='relation', adobename='uni2277', texname='gtrless' },
	[0x02278] = { mathclass='relation', adobename='uni2278', texname='nlessgtr' },
	[0x02279] = { mathclass='relation', adobename='uni2279', texname='ngtrless' },
	[0x0227A] = { mathclass='relation', adobename='uni227A', texname='prec' },
	[0x0227B] = { mathclass='relation', adobename='uni227B', texname='succ' },
	[0x0227C] = { mathclass='relation', adobename='uni227C', texname='preccurlyeq' },
	[0x0227D] = { mathclass='relation', adobename='uni227D', texname='succcurlyeq' },
	[0x0227E] = { mathclass='relation', adobename='uni227E', texname='precsim' },
	[0x0227F] = { mathclass='relation', adobename='uni227F', texname='succsim' },
	[0x02280] = { mathclass='relation', adobename='uni2280', texname='nprec' },
	[0x02281] = { mathclass='relation', adobename='uni2281', texname='nsucc' },
	[0x02282] = { mathclass='relation', adobename='uni2282', texname='subset' },
	[0x02283] = { mathclass='relation', adobename='uni2283', texname='supset' },
	[0x02284] = { mathclass='relation', adobename='uni2284', texname='nsubset' },
	[0x02285] = { mathclass='relation', adobename='uni2285', texname='nsupset' },
	[0x02286] = { mathclass='relation', adobename='uni2286', texname='subseteq' },
	[0x02287] = { mathclass='relation', adobename='uni2287', texname='supseteq' },
	[0x02288] = { mathclass='relation', adobename='uni2288', texname='nsubseteq' },
	[0x02289] = { mathclass='relation', adobename='uni2289', texname='nsupseteq' },
	[0x0228A] = { mathclass='relation', adobename='uni228A', texname='subsetneq' },
	[0x0228B] = { mathclass='relation', adobename='uni228B', texname='supsetneq' },
	[0x0228C] = { mathclass='unknown', adobename='uni228C', texname='cupleftarrow' },
	[0x0228D] = { mathclass='binary', adobename='uni228D', texname='cupdot' },
	[0x0228E] = { mathclass='binary', adobename='uni228E', texname='uplus' },
	[0x0228F] = { mathclass='relation', adobename='uni228F', texname='sqsubset' },
	[0x02290] = { mathclass='relation', adobename='uni2290', texname='sqsupset' },
	[0x02291] = { mathclass='relation', adobename='uni2291', texname='sqsubseteq' },
	[0x02292] = { mathclass='relation', adobename='uni2292', texname='sqsupseteq' },
	[0x02293] = { mathclass='binary', adobename='uni2293', texname='sqcap' },
	[0x02294] = { mathclass='binary', adobename='uni2294', texname='sqcup' },
	[0x02295] = { mathclass='binary', adobename='uni2295', texname='oplus' },
	[0x02296] = { mathclass='binary', adobename='uni2296', texname='ominus' },
	[0x02297] = { mathclass='binary', adobename='uni2297', texname='otimes' },
	[0x02298] = { mathclass='binary', adobename='uni2298', texname='oslash' },
	[0x02299] = { mathclass='binary', adobename='uni2299', texname='odot' },
	[0x0229A] = { mathclass='binary', adobename='uni229A', texname='circledcirc' },
	[0x0229B] = { mathclass='binary', adobename='uni229B', texname='circledast' },
	[0x0229C] = { mathclass='unknown', adobename='uni229C', texname='circledequal' },
	[0x0229D] = { mathclass='binary', adobename='uni229D', texname='circleddash' },
	[0x0229E] = { mathclass='binary', adobename='uni229E', texname='boxplus' },
	[0x0229F] = { mathclass='binary', adobename='uni229F', texname='boxminus' },
	[0x022A0] = { mathclass='binary', adobename='uni22A0', texname='boxtimes' },
	[0x022A1] = { mathclass='binary', adobename='uni22A1', texname='boxdot' },
	[0x022A2] = { mathclass='relation', adobename='uni22A2', texname='vdash' },
	[0x022A3] = { mathclass='relation', adobename='uni22A3', texname='dashv' },
	[0x022A4] = { mathclass='normal', adobename='uni22A4', texname='top' },
	[0x022A5] = { mathclass='normal', adobename='uni22A5', texname='bot' },
	[0x022A6] = { mathclass='relation', adobename='uni22A6', texname='assert' },
	[0x022A7] = { mathclass='relation', adobename='uni22A7', texname='models' },
	[0x022A8] = { mathclass='relation', adobename='uni22A8', texname='vDash' },
	[0x022A9] = { mathclass='relation', adobename='uni22A9', texname='Vdash' },
	[0x022AA] = { mathclass='relation', adobename='uni22AA', texname='Vvdash' },
	[0x022AB] = { mathclass='relation', adobename='uni22AB', texname='VDash' },
	[0x022AC] = { mathclass='relation', adobename='uni22AC', texname='nvdash' },
	[0x022AD] = { mathclass='relation', adobename='uni22AD', texname='nvDash' },
	[0x022AE] = { mathclass='relation', adobename='uni22AE', texname='nVdash' },
	[0x022AF] = { mathclass='relation', adobename='uni22AF', texname='nVDash' },
	[0x022B0] = { mathclass='relation', adobename='uni22B0', texname='prurel' },
	[0x022B1] = { mathclass='relation', adobename='uni22B1', texname='scurel' },
	[0x022B2] = { mathclass='relation', adobename='uni22B2', texname='vartriangleleft' },
	[0x022B3] = { mathclass='relation', adobename='uni22B3', texname='vartriangleright' },
	[0x022B4] = { mathclass='relation', adobename='uni22B4', texname='trianglelefteq' },
	[0x022B5] = { mathclass='relation', adobename='uni22B5', texname='trianglerighteq' },
	[0x022B6] = { mathclass='relation', adobename='uni22B6', texname='origof' },
	[0x022B7] = { mathclass='relation', adobename='uni22B7', texname='imageof' },
	[0x022B8] = { mathclass='relation', adobename='uni22B8', texname='multimap' },
	[0x022B9] = { mathclass='unknown', adobename='uni22B9', texname='hermitmatrix' },
	[0x022BA] = { mathclass='binary', adobename='uni22BA', texname='intercal' },
	[0x022BB] = { mathclass='binary', adobename='uni22BB', texname='veebar' },
	[0x022BC] = { mathclass='binary', adobename='uni22BC', texname='barwedge' },
	[0x022BD] = { mathclass='binary', adobename='uni22BD', texname='barvee' },
	[0x022BE] = { mathclass='unknown', adobename='uni22BE', texname='measuredrightangle' },
	[0x022BF] = { mathclass='unknown', adobename='uni22BF', texname='varlrtriangle' },
	[0x022C0] = { mathclass='large', adobename='uni22C0', texname='bigwedge' },
	[0x022C1] = { mathclass='large', adobename='uni22C1', texname='bigvee' },
	[0x022C2] = { mathclass='large', adobename='uni22C2', texname='bigcap' },
	[0x022C3] = { mathclass='large', adobename='uni22C3', texname='bigcup' },
	[0x022C4] = { mathclass='binary', adobename='uni22C4', texname='smwhtdiamond' },
	[0x022C5] = { mathclass='binary', adobename='uni22C5', texname='cdot' },
	[0x022C6] = { mathclass='binary', adobename='uni22C6', texname='star' },
	[0x022C7] = { mathclass='binary', adobename='uni22C7', texname='divideontimes' },
	[0x022C8] = { mathclass='relation', adobename='uni22C8', texname='bowtie' },
	[0x022C9] = { mathclass='binary', adobename='uni22C9', texname='ltimes' },
	[0x022CA] = { mathclass='binary', adobename='uni22CA', texname='rtimes' },
	[0x022CB] = { mathclass='binary', adobename='uni22CB', texname='leftthreetimes' },
	[0x022CC] = { mathclass='binary', adobename='uni22CC', texname='rightthreetimes' },
	[0x022CD] = { mathclass='relation', adobename='uni22CD', texname='backsimeq' },
	[0x022CE] = { mathclass='binary', adobename='uni22CE', texname='curlyvee' },
	[0x022CF] = { mathclass='binary', adobename='uni22CF', texname='curlywedge' },
	[0x022D0] = { mathclass='relation', adobename='uni22D0', texname='Subset' },
	[0x022D1] = { mathclass='relation', adobename='uni22D1', texname='Supset' },
	[0x022D2] = { mathclass='binary', adobename='uni22D2', texname='Cap' },
	[0x022D3] = { mathclass='binary', adobename='uni22D3', texname='Cup' },
	[0x022D4] = { mathclass='relation', adobename='uni22D4', texname='pitchfork' },
	[0x022D5] = { mathclass='unknown', adobename='uni22D5', texname='equalparallel' },
	[0x022D6] = { mathclass='relation', adobename='uni22D6', texname='lessdot' },
	[0x022D7] = { mathclass='relation', adobename='uni22D7', texname='gtrdot' },
	[0x022D8] = { mathclass='relation', adobename='uni22D8', texname='lll' },
	[0x022D9] = { mathclass='relation', adobename='uni22D9', texname='ggg' },
	[0x022DA] = { mathclass='relation', adobename='uni22DA', texname='lesseqgtr' },
	[0x022DB] = { mathclass='relation', adobename='uni22DB', texname='gtreqless' },
	[0x022DC] = { mathclass='relation', adobename='uni22DC', texname='eqless' },
	[0x022DD] = { mathclass='relation', adobename='uni22DD', texname='eqgtr' },
	[0x022DE] = { mathclass='relation', adobename='uni22DE', texname='curlyeqprec' },
	[0x022DF] = { mathclass='relation', adobename='uni22DF', texname='curlyeqsucc' },
	[0x022E0] = { mathclass='relation', adobename='uni22E0', texname='npreccurlyeq' },
	[0x022E1] = { mathclass='relation', adobename='uni22E1', texname='nsucccurlyeq' },
	[0x022E2] = { mathclass='relation', adobename='uni22E2', texname='nsqsubseteq' },
	[0x022E3] = { mathclass='relation', adobename='uni22E3', texname='nsqsupseteq' },
	[0x022E4] = { mathclass='relation', adobename='uni22E4', texname='sqsubsetneq' },
	[0x022E5] = { mathclass='relation', adobename='uni22E5', texname='sqsupsetneq' },
	[0x022E6] = { mathclass='relation', adobename='uni22E6', texname='lnsim' },
	[0x022E7] = { mathclass='relation', adobename='uni22E7', texname='gnsim' },
	[0x022E8] = { mathclass='relation', adobename='uni22E8', texname='precnsim' },
	[0x022E9] = { mathclass='relation', adobename='uni22E9', texname='succnsim' },
	[0x022EA] = { mathclass='relation', adobename='uni22EA', texname='ntriangleleft' },
	[0x022EB] = { mathclass='relation', adobename='uni22EB', texname='ntriangleright' },
	[0x022EC] = { mathclass='relation', adobename='uni22EC', texname='ntrianglelefteq' },
	[0x022ED] = { mathclass='relation', adobename='uni22ED', texname='ntrianglerighteq' },
	[0x022EE] = { mathclass='unknown', adobename='uni22EE', texname='vdots' },
	[0x022EF] = { mathclass='unknown', adobename='uni22EF', texname='cdots' },
	[0x022F0] = { mathclass='unknown', adobename='uni22F0', texname='adots' },
	[0x022F1] = { mathclass='unknown', adobename='uni22F1', texname='ddots' },
	[0x022F2] = { mathclass='relation', adobename='uni22F2', texname='disin' },
	[0x022F3] = { mathclass='relation', adobename='uni22F3', texname='varisins' },
	[0x022F4] = { mathclass='relation', adobename='uni22F4', texname='isins' },
	[0x022F5] = { mathclass='relation', adobename='uni22F5', texname='isindot' },
	[0x022F6] = { mathclass='relation', adobename='uni22F6', texname='varisinobar' },
	[0x022F7] = { mathclass='relation', adobename='uni22F7', texname='isinobar' },
	[0x022F8] = { mathclass='relation', adobename='uni22F8', texname='isinvb' },
	[0x022F9] = { mathclass='relation', adobename='uni22F9', texname='isinE' },
	[0x022FA] = { mathclass='relation', adobename='uni22FA', texname='nisd' },
	[0x022FB] = { mathclass='relation', adobename='uni22FB', texname='varnis' },
	[0x022FC] = { mathclass='relation', adobename='uni22FC', texname='nis' },
	[0x022FD] = { mathclass='relation', adobename='uni22FD', texname='varniobar' },
	[0x022FE] = { mathclass='relation', adobename='uni22FE', texname='niobar' },
	[0x022FF] = { mathclass='relation', adobename='uni22FF', texname='bagmember' },
	[0x02300] = { mathclass='unknown', adobename='uni2300', texname='diameter' },
	[0x02302] = { mathclass='unknown', adobename='uni2302', texname='house' },
	[0x02305] = { mathclass='binary', adobename='uni2305', texname='varbarwedge' },
	[0x02306] = { mathclass='binary', adobename='uni2306', texname='vardoublebarwedge' },
	[0x02308] = { mathclass='opening', adobename='uni2308', texname='lceil' },
	[0x02309] = { mathclass='closing', adobename='uni2309', texname='rceil' },
	[0x0230A] = { mathclass='opening', adobename='uni230A', texname='lfloor' },
	[0x0230B] = { mathclass='closing', adobename='uni230B', texname='rfloor' },
	[0x0230C] = { mathclass='fence', adobename='uni230C', texname='drcrop' },
	[0x0230D] = { mathclass='fence', adobename='uni230D', texname='dlcrop' },
	[0x0230E] = { mathclass='fence', adobename='uni230E', texname='urcrop' },
	[0x0230F] = { mathclass='fence', adobename='uni230F', texname='ulcrop' },
	[0x02310] = { mathclass='unknown', adobename='uni2310', texname='invnot' },
	[0x02311] = { mathclass='unknown', adobename='uni2311', texname='sqlozenge' },
	[0x02312] = { mathclass='unknown', adobename='uni2312', texname='profline' },
	[0x02313] = { mathclass='unknown', adobename='uni2313', texname='profsurf' },
	[0x02315] = { mathclass='unknown', adobename='uni2315', texname='recorder' },
	[0x02316] = { mathclass='unknown', adobename='uni2316', texname='target' },
	[0x02317] = { mathclass='unknown', adobename='uni2317', texname='viewdata' },
	[0x02318] = { mathclass='unknown', adobename='uni2318', texname='cloverleaf' },
	[0x02319] = { mathclass='unknown', adobename='uni2319', texname='turnednot' },
	[0x0231A] = { mathclass='unknown', adobename='uni231A', texname='watchicon' },
	[0x0231C] = { mathclass='opening', adobename='uni231C', texname='ulcorner' },
	[0x0231D] = { mathclass='closing', adobename='uni231D', texname='urcorner' },
	[0x0231E] = { mathclass='opening', adobename='uni231E', texname='llcorner' },
	[0x0231F] = { mathclass='closing', adobename='uni231F', texname='lrcorner' },
	[0x02320] = { mathclass='unknown', adobename='uni2320', texname='inttop' },
	[0x02321] = { mathclass='unknown', adobename='uni2321', texname='intbottom' },
	[0x02322] = { mathclass='relation', adobename='uni2322', texname='frown' },
	[0x02323] = { mathclass='relation', adobename='uni2323', texname='smile' },
	[0x02329] = { mathclass='unknown', adobename='uni2329', texname='clangle' },
	[0x0232A] = { mathclass='unknown', adobename='uni232A', texname='crangle' },
	[0x0232C] = { mathclass='unknown', adobename='uni232C', texname='varhexagonlrbonds' },
	[0x0232D] = { mathclass='unknown', adobename='uni232D', texname='cylcty' },
	[0x0232E] = { mathclass='unknown', adobename='uni232E', texname='profalar' },
	[0x02332] = { mathclass='unknown', adobename='uni2332', texname='conictaper' },
	[0x02336] = { mathclass='unknown', adobename='uni2336', texname='topbot' },
	[0x0233D] = { mathclass='binary', adobename='uni233D', texname='obar' },
	[0x0233F] = { mathclass='relation', adobename='uni233F', texname='APLnotslash' },
	[0x02340] = { mathclass='unknown', adobename='uni2340', texname='APLnotbackslash' },
	[0x02353] = { mathclass='unknown', adobename='uni2353', texname='APLboxupcaret' },
	[0x02370] = { mathclass='unknown', adobename='uni2370', texname='APLboxquestion' },
	[0x0237C] = { mathclass='unknown', adobename='uni237C', texname='rangledownzigzagarrow' },
	[0x02393] = { mathclass='unknown', adobename='uni2393', texname='dircurrent' },
	[0x02394] = { mathclass='normal', adobename='uni2394', texname='hexagon' },
	[0x0239B] = { mathclass='unknown', adobename='uni239B', texname='lparenuend' },
	[0x0239C] = { mathclass='unknown', adobename='uni239C', texname='lparenextender' },
	[0x0239D] = { mathclass='unknown', adobename='uni239D', texname='lparenlend' },
	[0x0239E] = { mathclass='unknown', adobename='uni239E', texname='rparenuend' },
	[0x0239F] = { mathclass='unknown', adobename='uni239F', texname='rparenextender' },
	[0x023A0] = { mathclass='unknown', adobename='uni23A0', texname='rparenlend' },
	[0x023A1] = { mathclass='unknown', adobename='uni23A1', texname='lbrackuend' },
	[0x023A2] = { mathclass='unknown', adobename='uni23A2', texname='lbrackextender' },
	[0x023A3] = { mathclass='unknown', adobename='uni23A3', texname='lbracklend' },
	[0x023A4] = { mathclass='unknown', adobename='uni23A4', texname='rbrackuend' },
	[0x023A5] = { mathclass='unknown', adobename='uni23A5', texname='rbrackextender' },
	[0x023A6] = { mathclass='unknown', adobename='uni23A6', texname='rbracklend' },
	[0x023A7] = { mathclass='unknown', adobename='uni23A7', texname='lbraceuend' },
	[0x023A8] = { mathclass='unknown', adobename='uni23A8', texname='lbracemid' },
	[0x023A9] = { mathclass='unknown', adobename='uni23A9', texname='lbracelend' },
	[0x023AA] = { mathclass='unknown', adobename='uni23AA', texname='vbraceextender' },
	[0x023AB] = { mathclass='unknown', adobename='uni23AB', texname='rbraceuend' },
	[0x023AC] = { mathclass='unknown', adobename='uni23AC', texname='rbracemid' },
	[0x023AD] = { mathclass='unknown', adobename='uni23AD', texname='rbracelend' },
	[0x023AE] = { mathclass='unknown', adobename='uni23AE', texname='intextender' },
	[0x023AF] = { mathclass='unknown', adobename='uni23AF', texname='hlineextender' },
	[0x023B0] = { mathclass='unknown', adobename='uni23B0', texname='lmoustache' },
	[0x023B1] = { mathclass='unknown', adobename='uni23B1', texname='rmoustache' },
	[0x023B2] = { mathclass='unknown', adobename='uni23B2', texname='sumtop' },
	[0x023B3] = { mathclass='unknown', adobename='uni23B3', texname='sumbottom' },
	[0x023B4] = { mathclass='unknown', adobename='uni23B4', texname='overbracket' },
	[0x023B5] = { mathclass='unknown', adobename='uni23B5', texname='underbracket' },
	[0x023B6] = { mathclass='unknown', adobename='uni23B6', texname='bbrktbrk' },
	[0x023B7] = { mathclass='unknown', adobename='uni23B7', texname='sqrtbottom' },
	[0x023B8] = { mathclass='unknown', adobename='uni23B8', texname='lvboxline' },
	[0x023B9] = { mathclass='unknown', adobename='uni23B9', texname='rvboxline' },
	[0x023CE] = { mathclass='unknown', adobename='uni23CE', texname='varcarriagereturn' },
	[0x023DC] = { mathclass='unknown', adobename='uni23DC', texname='overparen' },
	[0x023DD] = { mathclass='unknown', adobename='uni23DD', texname='underparen' },
	[0x023DE] = { mathclass='unknown', adobename='uni23DE', texname='overbrace' },
	[0x023DF] = { mathclass='unknown', adobename='uni23DF', texname='underbrace' },
	[0x023E0] = { mathclass='unknown', adobename='uni23E0', texname='obrbrak' },
	[0x023E1] = { mathclass='unknown', adobename='uni23E1', texname='ubrbrak' },
	[0x023E2] = { mathclass='normal', adobename='uni23E2', texname='trapezium' },
	[0x023E3] = { mathclass='normal', adobename='uni23E3', texname='benzenr' },
	[0x023E4] = { mathclass='normal', adobename='uni23E4', texname='strns' },
	[0x023E5] = { mathclass='normal', adobename='uni23E5', texname='fltns' },
	[0x023E6] = { mathclass='normal', adobename='uni23E6', texname='accurrent' },
	[0x023E7] = { mathclass='normal', adobename='uni23E7', texname='elinters' },
	[0x02422] = { mathclass='unknown', adobename='uni2422', texname='textblank' },
	[0x02423] = { mathclass='normal', adobename='uni2423', texname='textvisiblespace' },
	[0x02460] = { mathclass='normal', adobename='uni2460', texname='circledone' },
	[0x02461] = { mathclass='normal', adobename='uni2461', texname='circledtwo' },
	[0x02462] = { mathclass='normal', adobename='uni2462', texname='circledthree' },
	[0x02463] = { mathclass='normal', adobename='uni2463', texname='circledfour' },
	[0x02464] = { mathclass='normal', adobename='uni2464', texname='circledfive' },
	[0x02465] = { mathclass='normal', adobename='uni2465', texname='circledsix' },
	[0x02466] = { mathclass='normal', adobename='uni2466', texname='circledseven' },
	[0x02467] = { mathclass='normal', adobename='uni2467', texname='circledeight' },
	[0x02468] = { mathclass='normal', adobename='uni2468', texname='circlednine' },
	[0x024B6] = { mathclass='normal', adobename='uni24B6', texname='circledA' },
	[0x024B7] = { mathclass='normal', adobename='uni24B7', texname='circledB' },
	[0x024B8] = { mathclass='normal', adobename='uni24B8', texname='circledC' },
	[0x024B9] = { mathclass='normal', adobename='uni24B9', texname='circledD' },
	[0x024BA] = { mathclass='normal', adobename='uni24BA', texname='circledE' },
	[0x024BB] = { mathclass='normal', adobename='uni24BB', texname='circledF' },
	[0x024BC] = { mathclass='normal', adobename='uni24BC', texname='circledG' },
	[0x024BD] = { mathclass='normal', adobename='uni24BD', texname='circledH' },
	[0x024BE] = { mathclass='normal', adobename='uni24BE', texname='circledI' },
	[0x024BF] = { mathclass='normal', adobename='uni24BF', texname='circledJ' },
	[0x024C0] = { mathclass='normal', adobename='uni24C0', texname='circledK' },
	[0x024C1] = { mathclass='normal', adobename='uni24C1', texname='circledL' },
	[0x024C2] = { mathclass='normal', adobename='uni24C2', texname='circledM' },
	[0x024C3] = { mathclass='normal', adobename='uni24C3', texname='circledN' },
	[0x024C4] = { mathclass='normal', adobename='uni24C4', texname='circledO' },
	[0x024C5] = { mathclass='normal', adobename='uni24C5', texname='circledP' },
	[0x024C6] = { mathclass='normal', adobename='uni24C6', texname='circledQ' },
	[0x024C7] = { mathclass='normal', adobename='uni24C7', texname='circledR' },
	[0x024C8] = { mathclass='normal', adobename='uni24C8', texname='circledS' },
	[0x024C9] = { mathclass='normal', adobename='uni24C9', texname='circledT' },
	[0x024CA] = { mathclass='normal', adobename='uni24CA', texname='circledU' },
	[0x024CB] = { mathclass='normal', adobename='uni24CB', texname='circledV' },
	[0x024CC] = { mathclass='normal', adobename='uni24CC', texname='circledW' },
	[0x024CD] = { mathclass='normal', adobename='uni24CD', texname='circledX' },
	[0x024CE] = { mathclass='normal', adobename='uni24CE', texname='circledY' },
	[0x024CF] = { mathclass='normal', adobename='uni24CF', texname='circledZ' },
	[0x024D0] = { mathclass='normal', adobename='uni24D0', texname='circleda' },
	[0x024D1] = { mathclass='normal', adobename='uni24D1', texname='circledb' },
	[0x024D2] = { mathclass='normal', adobename='uni24D2', texname='circledc' },
	[0x024D3] = { mathclass='normal', adobename='uni24D3', texname='circledd' },
	[0x024D4] = { mathclass='normal', adobename='uni24D4', texname='circlede' },
	[0x024D5] = { mathclass='normal', adobename='uni24D5', texname='circledf' },
	[0x024D6] = { mathclass='normal', adobename='uni24D6', texname='circledg' },
	[0x024D7] = { mathclass='normal', adobename='uni24D7', texname='circledh' },
	[0x024D8] = { mathclass='normal', adobename='uni24D8', texname='circledi' },
	[0x024D9] = { mathclass='normal', adobename='uni24D9', texname='circledj' },
	[0x024DA] = { mathclass='normal', adobename='uni24DA', texname='circledk' },
	[0x024DB] = { mathclass='normal', adobename='uni24DB', texname='circledl' },
	[0x024DC] = { mathclass='normal', adobename='uni24DC', texname='circledm' },
	[0x024DD] = { mathclass='normal', adobename='uni24DD', texname='circledn' },
	[0x024DE] = { mathclass='normal', adobename='uni24DE', texname='circledo' },
	[0x024DF] = { mathclass='normal', adobename='uni24DF', texname='circledp' },
	[0x024E0] = { mathclass='normal', adobename='uni24E0', texname='circledq' },
	[0x024E1] = { mathclass='normal', adobename='uni24E1', texname='circledr' },
	[0x024E2] = { mathclass='normal', adobename='uni24E2', texname='circleds' },
	[0x024E3] = { mathclass='normal', adobename='uni24E3', texname='circledt' },
	[0x024E4] = { mathclass='normal', adobename='uni24E4', texname='circledu' },
	[0x024E5] = { mathclass='normal', adobename='uni24E5', texname='circledv' },
	[0x024E6] = { mathclass='normal', adobename='uni24E6', texname='circledw' },
	[0x024E7] = { mathclass='normal', adobename='uni24E7', texname='circledx' },
	[0x024E8] = { mathclass='normal', adobename='uni24E8', texname='circledy' },
	[0x024E9] = { mathclass='normal', adobename='uni24E9', texname='circledz' },
	[0x024EA] = { mathclass='normal', adobename='uni24EA', texname='circledzero' },
	[0x02500] = { mathclass='unknown', adobename='uni2500', texname='bdhrule' },
	[0x02502] = { mathclass='unknown', adobename='uni2502', texname='bdvrule' },
	[0x02506] = { mathclass='unknown', adobename='uni2506', texname='bdtriplevdash' },
	[0x02508] = { mathclass='unknown', adobename='uni2508', texname='bdquadhdash' },
	[0x0250A] = { mathclass='unknown', adobename='uni250A', texname='bdquadvdash' },
	[0x0250C] = { mathclass='unknown', adobename='uni250C', texname='bddvrh' },
	[0x02510] = { mathclass='unknown', adobename='uni2510', texname='bddvlh' },
	[0x02514] = { mathclass='unknown', adobename='uni2514', texname='bduvrh' },
	[0x02518] = { mathclass='unknown', adobename='uni2518', texname='bduvlh' },
	[0x0251C] = { mathclass='unknown', adobename='uni251C', texname='bdbvrh' },
	[0x02524] = { mathclass='unknown', adobename='uni2524', texname='bdbvlh' },
	[0x0252C] = { mathclass='unknown', adobename='uni252C', texname='bddvbh' },
	[0x02534] = { mathclass='unknown', adobename='uni2534', texname='bduvbh' },
	[0x0253C] = { mathclass='unknown', adobename='uni253C', texname='bdbvbh' },
	[0x02550] = { mathclass='unknown', adobename='uni2550', texname='bdHrule' },
	[0x02551] = { mathclass='unknown', adobename='uni2551', texname='bdVrule' },
	[0x02552] = { mathclass='unknown', adobename='uni2552', texname='bddvrH' },
	[0x02553] = { mathclass='unknown', adobename='uni2553', texname='bddVrh' },
	[0x02554] = { mathclass='unknown', adobename='uni2554', texname='bddVrH' },
	[0x02555] = { mathclass='unknown', adobename='uni2555', texname='bddvlH' },
	[0x02556] = { mathclass='unknown', adobename='uni2556', texname='bddVlh' },
	[0x02557] = { mathclass='unknown', adobename='uni2557', texname='bddVlH' },
	[0x02558] = { mathclass='unknown', adobename='uni2558', texname='bduvrH' },
	[0x02559] = { mathclass='unknown', adobename='uni2559', texname='bduVrh' },
	[0x0255A] = { mathclass='unknown', adobename='uni255A', texname='bduVrH' },
	[0x0255B] = { mathclass='unknown', adobename='uni255B', texname='bduvlH' },
	[0x0255C] = { mathclass='unknown', adobename='uni255C', texname='bduVlh' },
	[0x0255D] = { mathclass='unknown', adobename='uni255D', texname='bduVlH' },
	[0x0255E] = { mathclass='unknown', adobename='uni255E', texname='bdbvrH' },
	[0x0255F] = { mathclass='unknown', adobename='uni255F', texname='bdbVrh' },
	[0x02560] = { mathclass='unknown', adobename='uni2560', texname='bdbVrH' },
	[0x02561] = { mathclass='unknown', adobename='uni2561', texname='bdbvlH' },
	[0x02562] = { mathclass='unknown', adobename='uni2562', texname='bdbVlh' },
	[0x02563] = { mathclass='unknown', adobename='uni2563', texname='bdbVlH' },
	[0x02564] = { mathclass='unknown', adobename='uni2564', texname='bddvbH' },
	[0x02565] = { mathclass='unknown', adobename='uni2565', texname='bddVbh' },
	[0x02566] = { mathclass='unknown', adobename='uni2566', texname='bddVbH' },
	[0x02567] = { mathclass='unknown', adobename='uni2567', texname='bduvbH' },
	[0x02568] = { mathclass='unknown', adobename='uni2568', texname='bduVbh' },
	[0x02569] = { mathclass='unknown', adobename='uni2569', texname='bduVbH' },
	[0x0256A] = { mathclass='unknown', adobename='uni256A', texname='bdbvbH' },
	[0x0256B] = { mathclass='unknown', adobename='uni256B', texname='bdbVbh' },
	[0x0256C] = { mathclass='unknown', adobename='uni256C', texname='bdbVbH' },
	[0x02571] = { mathclass='unknown', adobename='uni2571', texname='bdnesw' },
	[0x02572] = { mathclass='unknown', adobename='uni2572', texname='bdnwse' },
	[0x02580] = { mathclass='unknown', adobename='uni2580', texname='blockuphalf' },
	[0x02584] = { mathclass='unknown', adobename='uni2584', texname='blocklowhalf' },
	[0x02588] = { mathclass='unknown', adobename='uni2588', texname='blockfull' },
	[0x0258C] = { mathclass='unknown', adobename='uni258C', texname='blocklefthalf' },
	[0x02590] = { mathclass='unknown', adobename='uni2590', texname='blockrighthalf' },
	[0x02591] = { mathclass='unknown', adobename='uni2591', texname='blockqtrshaded' },
	[0x02592] = { mathclass='unknown', adobename='uni2592', texname='blockhalfshaded' },
	[0x02593] = { mathclass='unknown', adobename='uni2593', texname='blockthreeqtrshaded' },
	[0x025A0] = { mathclass='unknown', adobename='uni25A0', texname='mdlgblksquare' },
	[0x025A1] = { mathclass='unknown', adobename='uni25A1', texname='mdlgwhtsquare' },
	[0x025A2] = { mathclass='unknown', adobename='uni25A2', texname='squoval' },
	[0x025A3] = { mathclass='unknown', adobename='uni25A3', texname='blackinwhitesquare' },
	[0x025A4] = { mathclass='unknown', adobename='uni25A4', texname='squarehfill' },
	[0x025A5] = { mathclass='unknown', adobename='uni25A5', texname='squarevfill' },
	[0x025A6] = { mathclass='unknown', adobename='uni25A6', texname='squarehvfill' },
	[0x025A7] = { mathclass='unknown', adobename='uni25A7', texname='squarenwsefill' },
	[0x025A8] = { mathclass='unknown', adobename='uni25A8', texname='squareneswfill' },
	[0x025A9] = { mathclass='normal', adobename='uni25A9', texname='squarecrossfill' },
	[0x025AA] = { mathclass='unknown', adobename='uni25AA', texname='smblksquare' },
	[0x025AB] = { mathclass='normal', adobename='uni25AB', texname='smwhtsquare' },
	[0x025AC] = { mathclass='unknown', adobename='uni25AC', texname='hrectangleblack' },
	[0x025AD] = { mathclass='unknown', adobename='uni25AD', texname='hrectangle' },
	[0x025AE] = { mathclass='unknown', adobename='uni25AE', texname='vrectangleblack' },
	[0x025AF] = { mathclass='unknown', adobename='uni25AF', texname='vrectangle' },
	[0x025B0] = { mathclass='unknown', adobename='uni25B0', texname='parallelogramblack' },
	[0x025B1] = { mathclass='unknown', adobename='uni25B1', texname='parallelogram' },
	[0x025B2] = { mathclass='unknown', adobename='uni25B2', texname='bigblacktriangleup' },
	[0x025B3] = { mathclass='unknown', adobename='uni25B3', texname='bigtriangleup' },
	[0x025B4] = { mathclass='unknown', adobename='uni25B4', texname='blacktriangle' },
	[0x025B5] = { mathclass='unknown', adobename='uni25B5', texname='vartriangle' },
	[0x025B6] = { mathclass='unknown', adobename='uni25B6', texname='blacktriangleright' },
	[0x025B7] = { mathclass='binary', adobename='uni25B7', texname='triangleright' },
	[0x025B8] = { mathclass='unknown', adobename='uni25B8', texname='smallblacktriangleright' },
	[0x025B9] = { mathclass='unknown', adobename='uni25B9', texname='smalltriangleright' },
	[0x025BA] = { mathclass='unknown', adobename='uni25BA', texname='blackpointerright' },
	[0x025BB] = { mathclass='unknown', adobename='uni25BB', texname='whitepointerright' },
	[0x025BC] = { mathclass='unknown', adobename='uni25BC', texname='bigblacktriangledown' },
	[0x025BD] = { mathclass='unknown', adobename='uni25BD', texname='bigtriangledown' },
	[0x025BE] = { mathclass='unknown', adobename='uni25BE', texname='blacktriangledown' },
	[0x025BF] = { mathclass='unknown', adobename='uni25BF', texname='triangledown' },
	[0x025C0] = { mathclass='unknown', adobename='uni25C0', texname='blacktriangleleft' },
	[0x025C1] = { mathclass='binary', adobename='uni25C1', texname='triangleleft' },
	[0x025C2] = { mathclass='unknown', adobename='uni25C2', texname='smallblacktriangleleft' },
	[0x025C3] = { mathclass='unknown', adobename='uni25C3', texname='smalltriangleleft' },
	[0x025C4] = { mathclass='unknown', adobename='uni25C4', texname='blackpointerleft' },
	[0x025C5] = { mathclass='unknown', adobename='uni25C5', texname='whitepointerleft' },
	[0x025C6] = { mathclass='normal', adobename='uni25C6', texname='mdlgblkdiamond' },
	[0x025C7] = { mathclass='normal', adobename='uni25C7', texname='mdlgwhtdiamond' },
	[0x025C8] = { mathclass='unknown', adobename='uni25C8', texname='blackinwhitediamond' },
	[0x025C9] = { mathclass='unknown', adobename='uni25C9', texname='fisheye' },
	[0x025CA] = { mathclass='unknown', adobename='uni25CA', texname='mdlgwhtlozenge' },
	[0x025CB] = { mathclass='binary', adobename='uni25CB', texname='mdlgwhtcircle' },
	[0x025CC] = { mathclass='unknown', adobename='uni25CC', texname='dottedcircle' },
	[0x025CD] = { mathclass='unknown', adobename='uni25CD', texname='circlevertfill' },
	[0x025CE] = { mathclass='unknown', adobename='uni25CE', texname='bullseye' },
	[0x025CF] = { mathclass='unknown', adobename='uni25CF', texname='mdlgblkcircle' },
	[0x025D0] = { mathclass='unknown', adobename='uni25D0', texname='circlelefthalfblack' },
	[0x025D1] = { mathclass='unknown', adobename='uni25D1', texname='circlerighthalfblack' },
	[0x025D2] = { mathclass='unknown', adobename='uni25D2', texname='circlebottomhalfblack' },
	[0x025D3] = { mathclass='unknown', adobename='uni25D3', texname='circletophalfblack' },
	[0x025D4] = { mathclass='unknown', adobename='uni25D4', texname='circleurquadblack' },
	[0x025D5] = { mathclass='unknown', adobename='uni25D5', texname='blackcircleulquadwhite' },
	[0x025D6] = { mathclass='unknown', adobename='uni25D6', texname='blacklefthalfcircle' },
	[0x025D7] = { mathclass='unknown', adobename='uni25D7', texname='blackrighthalfcircle' },
	[0x025D8] = { mathclass='unknown', adobename='uni25D8', texname='inversebullet' },
	[0x025D9] = { mathclass='unknown', adobename='uni25D9', texname='inversewhitecircle' },
	[0x025DA] = { mathclass='unknown', adobename='uni25DA', texname='invwhiteupperhalfcircle' },
	[0x025DB] = { mathclass='unknown', adobename='uni25DB', texname='invwhitelowerhalfcircle' },
	[0x025DC] = { mathclass='unknown', adobename='uni25DC', texname='ularc' },
	[0x025DD] = { mathclass='unknown', adobename='uni25DD', texname='urarc' },
	[0x025DE] = { mathclass='unknown', adobename='uni25DE', texname='lrarc' },
	[0x025DF] = { mathclass='unknown', adobename='uni25DF', texname='llarc' },
	[0x025E0] = { mathclass='unknown', adobename='uni25E0', texname='topsemicircle' },
	[0x025E1] = { mathclass='unknown', adobename='uni25E1', texname='botsemicircle' },
	[0x025E2] = { mathclass='unknown', adobename='uni25E2', texname='lrblacktriangle' },
	[0x025E3] = { mathclass='unknown', adobename='uni25E3', texname='llblacktriangle' },
	[0x025E4] = { mathclass='unknown', adobename='uni25E4', texname='ulblacktriangle' },
	[0x025E5] = { mathclass='unknown', adobename='uni25E5', texname='urblacktriangle' },
	[0x025E6] = { mathclass='unknown', adobename='uni25E6', texname='smwhtcircle' },
	[0x025E7] = { mathclass='unknown', adobename='uni25E7', texname='squareleftblack' },
	[0x025E8] = { mathclass='unknown', adobename='uni25E8', texname='squarerightblack' },
	[0x025E9] = { mathclass='unknown', adobename='uni25E9', texname='squareulblack' },
	[0x025EA] = { mathclass='unknown', adobename='uni25EA', texname='squarelrblack' },
	[0x025EB] = { mathclass='binary', adobename='uni25EB', texname='boxbar' },
	[0x025EC] = { mathclass='unknown', adobename='uni25EC', texname='trianglecdot' },
	[0x025ED] = { mathclass='unknown', adobename='uni25ED', texname='triangleleftblack' },
	[0x025EE] = { mathclass='unknown', adobename='uni25EE', texname='trianglerightblack' },
	[0x025EF] = { mathclass='unknown', adobename='uni25EF', texname='lgwhtcircle' },
	[0x025F0] = { mathclass='unknown', adobename='uni25F0', texname='squareulquad' },
	[0x025F1] = { mathclass='unknown', adobename='uni25F1', texname='squarellquad' },
	[0x025F2] = { mathclass='unknown', adobename='uni25F2', texname='squarelrquad' },
	[0x025F3] = { mathclass='unknown', adobename='uni25F3', texname='squareurquad' },
	[0x025F4] = { mathclass='unknown', adobename='uni25F4', texname='circleulquad' },
	[0x025F5] = { mathclass='unknown', adobename='uni25F5', texname='circlellquad' },
	[0x025F6] = { mathclass='unknown', adobename='uni25F6', texname='circlelrquad' },
	[0x025F7] = { mathclass='unknown', adobename='uni25F7', texname='circleurquad' },
	[0x025F8] = { mathclass='unknown', adobename='uni25F8', texname='ultriangle' },
	[0x025F9] = { mathclass='unknown', adobename='uni25F9', texname='urtriangle' },
	[0x025FA] = { mathclass='unknown', adobename='uni25FA', texname='lltriangle' },
	[0x025FB] = { mathclass='normal', adobename='uni25FB', texname='mdwhtsquare' },
	[0x025FC] = { mathclass='normal', adobename='uni25FC', texname='mdblksquare' },
	[0x025FD] = { mathclass='normal', adobename='uni25FD', texname='mdsmwhtsquare' },
	[0x025FE] = { mathclass='normal', adobename='uni25FE', texname='mdsmblksquare' },
	[0x025FF] = { mathclass='normal', adobename='uni25FF', texname='lrtriangle' },
	[0x02605] = { mathclass='unknown', adobename='uni2605', texname='bigstar' },
	[0x02606] = { mathclass='unknown', adobename='uni2606', texname='bigwhitestar' },
	[0x02609] = { mathclass='unknown', adobename='uni2609', texname='astrosun' },
	[0x0260C] = { mathclass='unknown', adobename='uni260C', texname='conjunction' },
	[0x0260E] = { mathclass='normal', adobename='uni260E', texname='phone' },
	[0x02612] = { mathclass='normal', adobename='uni2612', texname='XBox' },
	[0x02621] = { mathclass='normal', adobename='uni2621', texname='danger' },
	[0x02639] = { mathclass='normal', adobename='uni2639', texname='frownie' },
	[0x0263A] = { mathclass='normal', adobename='uni263A', texname='smiley' },
	[0x0263B] = { mathclass='unknown', adobename='uni263B', texname='blacksmiley' },
	[0x0263C] = { mathclass='unknown', adobename='uni263C', texname='sun' },
	[0x0263D] = { mathclass='unknown', adobename='uni263D', texname='rightmoon' },
	[0x0263E] = { mathclass='unknown', adobename='uni263E', texname='leftmoon' },
	[0x0263F] = { mathclass='normal', adobename='uni263F', texname='mercury' },
	[0x02640] = { mathclass='normal', adobename='uni2640', texname='female' },
	[0x02641] = { mathclass='normal', adobename='uni2641', texname='earth' },
	[0x02642] = { mathclass='normal', adobename='uni2642', texname='male' },
	[0x02643] = { mathclass='normal', adobename='uni2643', texname='jupiter' },
	[0x02644] = { mathclass='normal', adobename='uni2644', texname='saturn' },
	[0x02646] = { mathclass='normal', adobename='uni2646', texname='neptune' },
	[0x02647] = { mathclass='normal', adobename='uni2647', texname='pluto' },
	[0x02648] = { mathclass='normal', adobename='uni2648', texname='aries' },
	[0x02649] = { mathclass='normal', adobename='uni2649', texname='taurus' },
	[0x02660] = { mathclass='normal', adobename='uni2660', texname='spadesuit' },
	[0x02661] = { mathclass='normal', adobename='uni2661', texname='heartsuit' },
	[0x02662] = { mathclass='normal', adobename='uni2662', texname='diamondsuit' },
	[0x02663] = { mathclass='normal', adobename='uni2663', texname='clubsuit' },
	[0x02664] = { mathclass='normal', adobename='uni2664', texname='varspadesuit' },
	[0x02665] = { mathclass='normal', adobename='uni2665', texname='varheartsuit' },
	[0x02666] = { mathclass='normal', adobename='uni2666', texname='vardiamondsuit' },
	[0x02667] = { mathclass='normal', adobename='uni2667', texname='varclubsuit' },
	[0x02669] = { mathclass='normal', adobename='uni2669', texname='quarternote' },
	[0x0266A] = { mathclass='unknown', adobename='uni266A', texname='eighthnote' },
	[0x0266B] = { mathclass='unknown', adobename='uni266B', texname='twonotes' },
	[0x0266D] = { mathclass='normal', adobename='uni266D', texname='flat' },
	[0x0266E] = { mathclass='normal', adobename='uni266E', texname='natural' },
	[0x0266F] = { mathclass='normal', adobename='uni266F', texname='sharp' },
	[0x0267E] = { mathclass='unknown', adobename='uni267E', texname='acidfree' },
	[0x02680] = { mathclass='unknown', adobename='uni2680', texname='dicei' },
	[0x02681] = { mathclass='unknown', adobename='uni2681', texname='diceii' },
	[0x02682] = { mathclass='unknown', adobename='uni2682', texname='diceiii' },
	[0x02683] = { mathclass='unknown', adobename='uni2683', texname='diceiv' },
	[0x02684] = { mathclass='unknown', adobename='uni2684', texname='dicev' },
	[0x02685] = { mathclass='unknown', adobename='uni2685', texname='dicevi' },
	[0x02686] = { mathclass='unknown', adobename='uni2686', texname='circledrightdot' },
	[0x02687] = { mathclass='unknown', adobename='uni2687', texname='circledtwodots' },
	[0x02688] = { mathclass='unknown', adobename='uni2688', texname='blackcircledrightdot' },
	[0x02689] = { mathclass='unknown', adobename='uni2689', texname='blackcircledtwodots' },
	[0x026A0] = { mathclass='normal', adobename='uni26A0', texname='triangleexclam' },
	[0x026A5] = { mathclass='normal', adobename='uni26A5', texname='Hermaphrodite' },
	[0x026AA] = { mathclass='normal', adobename='uni26AA', texname='mdwhtcircle' },
	[0x026AB] = { mathclass='normal', adobename='uni26AB', texname='mdblkcircle' },
	[0x026AC] = { mathclass='normal', adobename='uni26AC', texname='mdsmwhtcircle' },
	[0x026B2] = { mathclass='normal', adobename='uni26B2', texname='neuter' },
	[0x02702] = { mathclass='normal', adobename='uni2702', texname='scissors' },
	[0x02709] = { mathclass='normal', adobename='uni2709', texname='envelope' },
	[0x02713] = { mathclass='normal', adobename='uni2713', texname='checkmark' },
	[0x02720] = { mathclass='normal', adobename='uni2720', texname='maltese' },
	[0x0272A] = { mathclass='unknown', adobename='uni272A', texname='circledstar' },
	[0x02736] = { mathclass='normal', adobename='uni2736', texname='varstar' },
	[0x0273D] = { mathclass='unknown', adobename='uni273D', texname='dingasterisk' },
	[0x02772] = { mathclass='opening', adobename='uni2772', texname='lbrbrak' },
	[0x02773] = { mathclass='closing', adobename='uni2773', texname='rbrbrak' },
	[0x02780] = { mathclass='unknown', adobename='uni2780', texname='circledsansone' },
	[0x02781] = { mathclass='unknown', adobename='uni2781', texname='circledsanstwo' },
	[0x02782] = { mathclass='unknown', adobename='uni2782', texname='circledsansthree' },
	[0x02783] = { mathclass='unknown', adobename='uni2783', texname='circledsansfour' },
	[0x02784] = { mathclass='unknown', adobename='uni2784', texname='circledsansfive' },
	[0x02785] = { mathclass='unknown', adobename='uni2785', texname='circledsanssix' },
	[0x02786] = { mathclass='unknown', adobename='uni2786', texname='circledsansseven' },
	[0x02787] = { mathclass='unknown', adobename='uni2787', texname='circledsanseight' },
	[0x02788] = { mathclass='unknown', adobename='uni2788', texname='circledsansnine' },
	[0x02789] = { mathclass='unknown', adobename='uni2789', texname='circledsansten' },
	[0x0278A] = { mathclass='unknown', adobename='uni278A', texname='blackcircledsansone' },
	[0x0278B] = { mathclass='unknown', adobename='uni278B', texname='blackcircledsanstwo' },
	[0x0278C] = { mathclass='unknown', adobename='uni278C', texname='blackcircledsansthree' },
	[0x0278D] = { mathclass='unknown', adobename='uni278D', texname='blackcircledsansfour' },
	[0x0278E] = { mathclass='unknown', adobename='uni278E', texname='blackcircledsansfive' },
	[0x0278F] = { mathclass='unknown', adobename='uni278F', texname='blackcircledsanssix' },
	[0x02790] = { mathclass='unknown', adobename='uni2790', texname='blackcircledsansseven' },
	[0x02791] = { mathclass='unknown', adobename='uni2791', texname='blackcircledsanseight' },
	[0x02792] = { mathclass='unknown', adobename='uni2792', texname='blackcircledsansnine' },
	[0x02793] = { mathclass='unknown', adobename='uni2793', texname='blackcircledsansten' },
	[0x0279B] = { mathclass='unknown', adobename='uni279B', texname='draftingarrow' },
	[0x027C0] = { mathclass='unknown', adobename='uni27C0', texname='threedangle' },
	[0x027C1] = { mathclass='unknown', adobename='uni27C1', texname='whiteinwhitetriangle' },
	[0x027C2] = { mathclass='relation', adobename='uni27C2', texname='perp' },
	[0x027C3] = { mathclass='unknown', adobename='uni27C3', texname='subsetcirc' },
	[0x027C4] = { mathclass='unknown', adobename='uni27C4', texname='supsetcirc' },
	[0x027C5] = { mathclass='opening', adobename='uni27C5', texname='lbag' },
	[0x027C6] = { mathclass='closing', adobename='uni27C6', texname='rbag' },
	[0x027C7] = { mathclass='binary', adobename='uni27C7', texname='veedot' },
	[0x027C8] = { mathclass='relation', adobename='uni27C8', texname='bsolhsub' },
	[0x027C9] = { mathclass='relation', adobename='uni27C9', texname='suphsol' },
	[0x027D0] = { mathclass='normal', adobename='uni27D0', texname='diamondcdot' },
	[0x027D1] = { mathclass='binary', adobename='uni27D1', texname='wedgedot' },
	[0x027D2] = { mathclass='relation', adobename='uni27D2', texname='upin' },
	[0x027D3] = { mathclass='relation', adobename='uni27D3', texname='pullback' },
	[0x027D4] = { mathclass='relation', adobename='uni27D4', texname='pushout' },
	[0x027D5] = { mathclass='large', adobename='uni27D5', texname='leftouterjoin' },
	[0x027D6] = { mathclass='large', adobename='uni27D6', texname='rightouterjoin' },
	[0x027D7] = { mathclass='large', adobename='uni27D7', texname='fullouterjoin' },
	[0x027D8] = { mathclass='large', adobename='uni27D8', texname='bigbot' },
	[0x027D9] = { mathclass='large', adobename='uni27D9', texname='bigtop' },
	[0x027DA] = { mathclass='relation', adobename='uni27DA', texname='DashVDash' },
	[0x027DB] = { mathclass='relation', adobename='uni27DB', texname='dashVdash' },
	[0x027DC] = { mathclass='relation', adobename='uni27DC', texname='multimapinv' },
	[0x027DD] = { mathclass='relation', adobename='uni27DD', texname='vlongdash' },
	[0x027DE] = { mathclass='relation', adobename='uni27DE', texname='longdashv' },
	[0x027DF] = { mathclass='relation', adobename='uni27DF', texname='cirbot' },
	[0x027E0] = { mathclass='binary', adobename='uni27E0', texname='lozengeminus' },
	[0x027E1] = { mathclass='binary', adobename='uni27E1', texname='concavediamond' },
	[0x027E2] = { mathclass='binary', adobename='uni27E2', texname='concavediamondtickleft' },
	[0x027E3] = { mathclass='binary', adobename='uni27E3', texname='concavediamondtickright' },
	[0x027E4] = { mathclass='binary', adobename='uni27E4', texname='whitesquaretickleft' },
	[0x027E5] = { mathclass='binary', adobename='uni27E5', texname='whitesquaretickright' },
	[0x027E6] = { mathclass='opening', adobename='uni27E6', texname='lBrack' },
	[0x027E7] = { mathclass='closing', adobename='uni27E7', texname='rBrack' },
	[0x027E8] = { mathclass='opening', adobename='uni27E8', texname='langle' },
	[0x027E9] = { mathclass='closing', adobename='uni27E9', texname='rangle' },
	[0x027EA] = { mathclass='opening', adobename='uni27EA', texname='lAngle' },
	[0x027EB] = { mathclass='closing', adobename='uni27EB', texname='rAngle' },
	[0x027EC] = { mathclass='opening', adobename='uni27EC', texname='Lbrbrak' },
	[0x027ED] = { mathclass='closing', adobename='uni27ED', texname='Rbrbrak' },
	[0x027F0] = { mathclass='relation', adobename='uni27F0', texname='UUparrow' },
	[0x027F1] = { mathclass='relation', adobename='uni27F1', texname='DDownarrow' },
	[0x027F2] = { mathclass='relation', adobename='uni27F2', texname='acwgapcirclearrow' },
	[0x027F3] = { mathclass='relation', adobename='uni27F3', texname='cwgapcirclearrow' },
	[0x027F4] = { mathclass='relation', adobename='uni27F4', texname='rightarrowonoplus' },
	[0x027F5] = { mathclass='relation', adobename='uni27F5', texname='longleftarrow' },
	[0x027F6] = { mathclass='relation', adobename='uni27F6', texname='longrightarrow' },
	[0x027F7] = { mathclass='relation', adobename='uni27F7', texname='longleftrightarrow' },
	[0x027F8] = { mathclass='relation', adobename='uni27F8', texname='Longleftarrow' },
	[0x027F9] = { mathclass='relation', adobename='uni27F9', texname='Longrightarrow' },
	[0x027FA] = { mathclass='relation', adobename='uni27FA', texname='Longleftrightarrow' },
	[0x027FB] = { mathclass='relation', adobename='uni27FB', texname='longmapsfrom' },
	[0x027FC] = { mathclass='relation', adobename='uni27FC', texname='longmapsto' },
	[0x027FD] = { mathclass='relation', adobename='uni27FD', texname='Longmapsfrom' },
	[0x027FE] = { mathclass='relation', adobename='uni27FE', texname='Longmapsto' },
	[0x027FF] = { mathclass='relation', adobename='uni27FF', texname='longrightzigzagarrow' },
	[0x02900] = { mathclass='relation', adobename='uni2900', texname='nvtwoheadrightarrow' },
	[0x02901] = { mathclass='relation', adobename='uni2901', texname='nVtwoheadrightarrow' },
	[0x02902] = { mathclass='relation', adobename='uni2902', texname='nvLeftarrow' },
	[0x02903] = { mathclass='relation', adobename='uni2903', texname='nvRightarrow' },
	[0x02904] = { mathclass='relation', adobename='uni2904', texname='nvLeftrightarrow' },
	[0x02905] = { mathclass='relation', adobename='uni2905', texname='twoheadmapsto' },
	[0x02906] = { mathclass='relation', adobename='uni2906', texname='Mapsfrom' },
	[0x02907] = { mathclass='relation', adobename='uni2907', texname='Mapsto' },
	[0x02908] = { mathclass='relation', adobename='uni2908', texname='downarrowbarred' },
	[0x02909] = { mathclass='relation', adobename='uni2909', texname='uparrowbarred' },
	[0x0290A] = { mathclass='relation', adobename='uni290A', texname='Uuparrow' },
	[0x0290B] = { mathclass='relation', adobename='uni290B', texname='Ddownarrow' },
	[0x0290C] = { mathclass='relation', adobename='uni290C', texname='leftbkarrow' },
	[0x0290D] = { mathclass='relation', adobename='uni290D', texname='rightbkarrow' },
	[0x0290E] = { mathclass='relation', adobename='uni290E', texname='leftdbkarrow' },
	[0x0290F] = { mathclass='relation', adobename='uni290F', texname='dbkarow' },
	[0x02910] = { mathclass='relation', adobename='uni2910', texname='drbkarow' },
	[0x02911] = { mathclass='relation', adobename='uni2911', texname='rightdotarrow' },
	[0x02912] = { mathclass='relation', adobename='uni2912', texname='baruparrow' },
	[0x02913] = { mathclass='relation', adobename='uni2913', texname='downarrowbar' },
	[0x02914] = { mathclass='relation', adobename='uni2914', texname='nvrightarrowtail' },
	[0x02915] = { mathclass='relation', adobename='uni2915', texname='nVrightarrowtail' },
	[0x02916] = { mathclass='relation', adobename='uni2916', texname='twoheadrightarrowtail' },
	[0x02917] = { mathclass='relation', adobename='uni2917', texname='nvtwoheadrightarrowtail' },
	[0x02918] = { mathclass='relation', adobename='uni2918', texname='nVtwoheadrightarrowtail' },
	[0x02919] = { mathclass='relation', adobename='uni2919', texname='lefttail' },
	[0x0291A] = { mathclass='relation', adobename='uni291A', texname='righttail' },
	[0x0291B] = { mathclass='relation', adobename='uni291B', texname='leftdbltail' },
	[0x0291C] = { mathclass='relation', adobename='uni291C', texname='rightdbltail' },
	[0x0291D] = { mathclass='relation', adobename='uni291D', texname='diamondleftarrow' },
	[0x0291E] = { mathclass='relation', adobename='uni291E', texname='rightarrowdiamond' },
	[0x0291F] = { mathclass='relation', adobename='uni291F', texname='diamondleftarrowbar' },
	[0x02920] = { mathclass='relation', adobename='uni2920', texname='barrightarrowdiamond' },
	[0x02921] = { mathclass='relation', adobename='uni2921', texname='nwsearrow' },
	[0x02922] = { mathclass='relation', adobename='uni2922', texname='neswarrow' },
	[0x02923] = { mathclass='relation', adobename='uni2923', texname='hknwarrow' },
	[0x02924] = { mathclass='relation', adobename='uni2924', texname='hknearrow' },
	[0x02925] = { mathclass='relation', adobename='uni2925', texname='hksearow' },
	[0x02926] = { mathclass='relation', adobename='uni2926', texname='hkswarow' },
	[0x02927] = { mathclass='relation', adobename='uni2927', texname='tona' },
	[0x02928] = { mathclass='relation', adobename='uni2928', texname='toea' },
	[0x02929] = { mathclass='relation', adobename='uni2929', texname='tosa' },
	[0x0292A] = { mathclass='relation', adobename='uni292A', texname='towa' },
	[0x0292B] = { mathclass='unknown', adobename='uni292B', texname='rdiagovfdiag' },
	[0x0292C] = { mathclass='unknown', adobename='uni292C', texname='fdiagovrdiag' },
	[0x0292D] = { mathclass='unknown', adobename='uni292D', texname='seovnearrow' },
	[0x0292E] = { mathclass='unknown', adobename='uni292E', texname='neovsearrow' },
	[0x0292F] = { mathclass='unknown', adobename='uni292F', texname='fdiagovnearrow' },
	[0x02930] = { mathclass='unknown', adobename='uni2930', texname='rdiagovsearrow' },
	[0x02931] = { mathclass='unknown', adobename='uni2931', texname='neovnwarrow' },
	[0x02932] = { mathclass='unknown', adobename='uni2932', texname='nwovnearrow' },
	[0x02933] = { mathclass='relation', adobename='uni2933', texname='rightcurvedarrow' },
	[0x02934] = { mathclass='unknown', adobename='uni2934', texname='uprightcurvearrow' },
	[0x02935] = { mathclass='unknown', adobename='uni2935', texname='downrightcurvedarrow' },
	[0x02936] = { mathclass='relation', adobename='uni2936', texname='leftdowncurvedarrow' },
	[0x02937] = { mathclass='relation', adobename='uni2937', texname='rightdowncurvedarrow' },
	[0x02938] = { mathclass='relation', adobename='uni2938', texname='cwrightarcarrow' },
	[0x02939] = { mathclass='relation', adobename='uni2939', texname='acwleftarcarrow' },
	[0x0293A] = { mathclass='unknown', adobename='uni293A', texname='acwoverarcarrow' },
	[0x0293B] = { mathclass='relation', adobename='uni293B', texname='acwunderarcarrow' },
	[0x0293C] = { mathclass='relation', adobename='uni293C', texname='curvearrowrightminus' },
	[0x0293D] = { mathclass='relation', adobename='uni293D', texname='curvearrowleftplus' },
	[0x0293E] = { mathclass='relation', adobename='uni293E', texname='cwundercurvearrow' },
	[0x0293F] = { mathclass='unknown', adobename='uni293F', texname='ccwundercurvearrow' },
	[0x02940] = { mathclass='relation', adobename='uni2940', texname='acwcirclearrow' },
	[0x02941] = { mathclass='relation', adobename='uni2941', texname='cwcirclearrow' },
	[0x02942] = { mathclass='relation', adobename='uni2942', texname='rightarrowshortleftarrow' },
	[0x02943] = { mathclass='relation', adobename='uni2943', texname='leftarrowshortrightarrow' },
	[0x02944] = { mathclass='relation', adobename='uni2944', texname='shortrightarrowleftarrow' },
	[0x02945] = { mathclass='relation', adobename='uni2945', texname='rightarrowplus' },
	[0x02946] = { mathclass='relation', adobename='uni2946', texname='leftarrowplus' },
	[0x02947] = { mathclass='relation', adobename='uni2947', texname='rightarrowx' },
	[0x02948] = { mathclass='relation', adobename='uni2948', texname='leftrightarrowcircle' },
	[0x02949] = { mathclass='relation', adobename='uni2949', texname='twoheaduparrowcircle' },
	[0x0294A] = { mathclass='relation', adobename='uni294A', texname='leftrightharpoonupdown' },
	[0x0294B] = { mathclass='relation', adobename='uni294B', texname='leftrightharpoondownup' },
	[0x0294C] = { mathclass='relation', adobename='uni294C', texname='updownharpoonrightleft' },
	[0x0294D] = { mathclass='relation', adobename='uni294D', texname='updownharpoonleftright' },
	[0x0294E] = { mathclass='relation', adobename='uni294E', texname='leftrightharpoonupup' },
	[0x0294F] = { mathclass='relation', adobename='uni294F', texname='updownharpoonrightright' },
	[0x02950] = { mathclass='relation', adobename='uni2950', texname='leftrightharpoondowndown' },
	[0x02951] = { mathclass='relation', adobename='uni2951', texname='updownharpoonleftleft' },
	[0x02952] = { mathclass='relation', adobename='uni2952', texname='barleftharpoonup' },
	[0x02953] = { mathclass='relation', adobename='uni2953', texname='rightharpoonupbar' },
	[0x02954] = { mathclass='relation', adobename='uni2954', texname='barupharpoonright' },
	[0x02955] = { mathclass='relation', adobename='uni2955', texname='downharpoonrightbar' },
	[0x02956] = { mathclass='relation', adobename='uni2956', texname='barleftharpoondown' },
	[0x02957] = { mathclass='relation', adobename='uni2957', texname='rightharpoondownbar' },
	[0x02958] = { mathclass='relation', adobename='uni2958', texname='barupharpoonleft' },
	[0x02959] = { mathclass='relation', adobename='uni2959', texname='downharpoonleftbar' },
	[0x0295A] = { mathclass='relation', adobename='uni295A', texname='leftharpoonupbar' },
	[0x0295B] = { mathclass='relation', adobename='uni295B', texname='barrightharpoonup' },
	[0x0295C] = { mathclass='relation', adobename='uni295C', texname='upharpoonrightbar' },
	[0x0295D] = { mathclass='relation', adobename='uni295D', texname='bardownharpoonright' },
	[0x0295E] = { mathclass='relation', adobename='uni295E', texname='leftharpoondownbar' },
	[0x0295F] = { mathclass='relation', adobename='uni295F', texname='barrightharpoondown' },
	[0x02960] = { mathclass='relation', adobename='uni2960', texname='upharpoonleftbar' },
	[0x02961] = { mathclass='relation', adobename='uni2961', texname='bardownharpoonleft' },
	[0x02962] = { mathclass='relation', adobename='uni2962', texname='leftharpoonsupdown' },
	[0x02963] = { mathclass='relation', adobename='uni2963', texname='upharpoonsleftright' },
	[0x02964] = { mathclass='relation', adobename='uni2964', texname='rightharpoonsupdown' },
	[0x02965] = { mathclass='relation', adobename='uni2965', texname='downharpoonsleftright' },
	[0x02966] = { mathclass='relation', adobename='uni2966', texname='leftrightharpoonsup' },
	[0x02967] = { mathclass='relation', adobename='uni2967', texname='leftrightharpoonsdown' },
	[0x02968] = { mathclass='relation', adobename='uni2968', texname='rightleftharpoonsup' },
	[0x02969] = { mathclass='relation', adobename='uni2969', texname='rightleftharpoonsdown' },
	[0x0296A] = { mathclass='relation', adobename='uni296A', texname='leftharpoonupdash' },
	[0x0296B] = { mathclass='relation', adobename='uni296B', texname='dashleftharpoondown' },
	[0x0296C] = { mathclass='relation', adobename='uni296C', texname='rightharpoonupdash' },
	[0x0296D] = { mathclass='relation', adobename='uni296D', texname='dashrightharpoondown' },
	[0x0296E] = { mathclass='relation', adobename='uni296E', texname='updownharpoonsleftright' },
	[0x0296F] = { mathclass='relation', adobename='uni296F', texname='downupharpoonsleftright' },
	[0x02970] = { mathclass='relation', adobename='uni2970', texname='rightimply' },
	[0x02971] = { mathclass='relation', adobename='uni2971', texname='equalrightarrow' },
	[0x02972] = { mathclass='relation', adobename='uni2972', texname='similarrightarrow' },
	[0x02973] = { mathclass='relation', adobename='uni2973', texname='leftarrowsimilar' },
	[0x02974] = { mathclass='relation', adobename='uni2974', texname='rightarrowsimilar' },
	[0x02975] = { mathclass='relation', adobename='uni2975', texname='rightarrowapprox' },
	[0x02976] = { mathclass='relation', adobename='uni2976', texname='ltlarr' },
	[0x02977] = { mathclass='relation', adobename='uni2977', texname='leftarrowless' },
	[0x02978] = { mathclass='relation', adobename='uni2978', texname='gtrarr' },
	[0x02979] = { mathclass='relation', adobename='uni2979', texname='subrarr' },
	[0x0297A] = { mathclass='relation', adobename='uni297A', texname='leftarrowsubset' },
	[0x0297B] = { mathclass='relation', adobename='uni297B', texname='suplarr' },
	[0x0297C] = { mathclass='relation', adobename='uni297C', texname='leftfishtail' },
	[0x0297D] = { mathclass='relation', adobename='uni297D', texname='rightfishtail' },
	[0x0297E] = { mathclass='relation', adobename='uni297E', texname='upfishtail' },
	[0x0297F] = { mathclass='relation', adobename='uni297F', texname='downfishtail' },
	[0x02980] = { mathclass='unknown', adobename='uni2980', texname='Vvert' },
	[0x02981] = { mathclass='normal', adobename='uni2981', texname='mdsmblkcircle' },
	[0x02982] = { mathclass='fence', adobename='uni2982', texname='typecolon' },
	[0x02983] = { mathclass='opening', adobename='uni2983', texname='lBrace' },
	[0x02984] = { mathclass='closing', adobename='uni2984', texname='rBrace' },
	[0x02985] = { mathclass='opening', adobename='uni2985', texname='lParen' },
	[0x02986] = { mathclass='closing', adobename='uni2986', texname='rParen' },
	[0x02987] = { mathclass='opening', adobename='uni2987', texname='llparenthesis' },
	[0x02988] = { mathclass='closing', adobename='uni2988', texname='rrparenthesis' },
	[0x02989] = { mathclass='opening', adobename='uni2989', texname='llangle' },
	[0x0298A] = { mathclass='closing', adobename='uni298A', texname='rrangle' },
	[0x0298B] = { mathclass='opening', adobename='uni298B', texname='lbrackubar' },
	[0x0298C] = { mathclass='closing', adobename='uni298C', texname='rbrackubar' },
	[0x0298D] = { mathclass='opening', adobename='uni298D', texname='lbrackultick' },
	[0x0298E] = { mathclass='closing', adobename='uni298E', texname='rbracklrtick' },
	[0x0298F] = { mathclass='opening', adobename='uni298F', texname='lbracklltick' },
	[0x02990] = { mathclass='closing', adobename='uni2990', texname='rbrackurtick' },
	[0x02991] = { mathclass='opening', adobename='uni2991', texname='langledot' },
	[0x02992] = { mathclass='closing', adobename='uni2992', texname='rangledot' },
	[0x02993] = { mathclass='opening', adobename='uni2993', texname='lparenless' },
	[0x02994] = { mathclass='closing', adobename='uni2994', texname='rparengtr' },
	[0x02995] = { mathclass='unknown', adobename='uni2995', texname='Lparengtr' },
	[0x02996] = { mathclass='unknown', adobename='uni2996', texname='Rparenless' },
	[0x02997] = { mathclass='opening', adobename='uni2997', texname='lblkbrbrak' },
	[0x02998] = { mathclass='closing', adobename='uni2998', texname='rblkbrbrak' },
	[0x02999] = { mathclass='unknown', adobename='uni2999', texname='fourvdots' },
	[0x0299A] = { mathclass='unknown', adobename='uni299A', texname='vzigzag' },
	[0x0299B] = { mathclass='unknown', adobename='uni299B', texname='measuredangleleft' },
	[0x0299C] = { mathclass='unknown', adobename='uni299C', texname='rightanglesqr' },
	[0x0299D] = { mathclass='unknown', adobename='uni299D', texname='rightanglemdot' },
	[0x0299E] = { mathclass='unknown', adobename='uni299E', texname='angles' },
	[0x0299F] = { mathclass='unknown', adobename='uni299F', texname='angdnr' },
	[0x029A0] = { mathclass='unknown', adobename='uni29A0', texname='gtlpar' },
	[0x029A1] = { mathclass='unknown', adobename='uni29A1', texname='sphericalangleup' },
	[0x029A2] = { mathclass='unknown', adobename='uni29A2', texname='turnangle' },
	[0x029A3] = { mathclass='unknown', adobename='uni29A3', texname='revangle' },
	[0x029A4] = { mathclass='unknown', adobename='uni29A4', texname='angleubar' },
	[0x029A5] = { mathclass='unknown', adobename='uni29A5', texname='revangleubar' },
	[0x029A6] = { mathclass='unknown', adobename='uni29A6', texname='wideangledown' },
	[0x029A7] = { mathclass='unknown', adobename='uni29A7', texname='wideangleup' },
	[0x029A8] = { mathclass='unknown', adobename='uni29A8', texname='measanglerutone' },
	[0x029A9] = { mathclass='unknown', adobename='uni29A9', texname='measanglelutonw' },
	[0x029AA] = { mathclass='unknown', adobename='uni29AA', texname='measanglerdtose' },
	[0x029AB] = { mathclass='unknown', adobename='uni29AB', texname='measangleldtosw' },
	[0x029AC] = { mathclass='unknown', adobename='uni29AC', texname='measangleurtone' },
	[0x029AD] = { mathclass='unknown', adobename='uni29AD', texname='measangleultonw' },
	[0x029AE] = { mathclass='unknown', adobename='uni29AE', texname='measangledrtose' },
	[0x029AF] = { mathclass='unknown', adobename='uni29AF', texname='measangledltosw' },
	[0x029B0] = { mathclass='normal', adobename='uni29B0', texname='revemptyset' },
	[0x029B1] = { mathclass='normal', adobename='uni29B1', texname='emptysetobar' },
	[0x029B2] = { mathclass='normal', adobename='uni29B2', texname='emptysetocirc' },
	[0x029B3] = { mathclass='normal', adobename='uni29B3', texname='emptysetoarr' },
	[0x029B4] = { mathclass='normal', adobename='uni29B4', texname='emptysetoarrl' },
	[0x029B5] = { mathclass='binary', adobename='uni29B5', texname='circlehbar' },
	[0x029B6] = { mathclass='binary', adobename='uni29B6', texname='circledvert' },
	[0x029B7] = { mathclass='binary', adobename='uni29B7', texname='circledparallel' },
	[0x029B8] = { mathclass='binary', adobename='uni29B8', texname='obslash' },
	[0x029B9] = { mathclass='binary', adobename='uni29B9', texname='operp' },
	[0x029BA] = { mathclass='normal', adobename='uni29BA', texname='obot' },
	[0x029BB] = { mathclass='normal', adobename='uni29BB', texname='olcross' },
	[0x029BC] = { mathclass='normal', adobename='uni29BC', texname='odotslashdot' },
	[0x029BD] = { mathclass='normal', adobename='uni29BD', texname='uparrowoncircle' },
	[0x029BE] = { mathclass='normal', adobename='uni29BE', texname='circledwhitebullet' },
	[0x029BF] = { mathclass='normal', adobename='uni29BF', texname='circledbullet' },
	[0x029C0] = { mathclass='binary', adobename='uni29C0', texname='olessthan' },
	[0x029C1] = { mathclass='binary', adobename='uni29C1', texname='ogreaterthan' },
	[0x029C2] = { mathclass='normal', adobename='uni29C2', texname='cirscir' },
	[0x029C3] = { mathclass='normal', adobename='uni29C3', texname='cirE' },
	[0x029C4] = { mathclass='binary', adobename='uni29C4', texname='boxdiag' },
	[0x029C5] = { mathclass='binary', adobename='uni29C5', texname='boxbslash' },
	[0x029C6] = { mathclass='binary', adobename='uni29C6', texname='boxast' },
	[0x029C7] = { mathclass='binary', adobename='uni29C7', texname='boxcircle' },
	[0x029C8] = { mathclass='binary', adobename='uni29C8', texname='boxbox' },
	[0x029C9] = { mathclass='normal', adobename='uni29C9', texname='boxonbox' },
	[0x029CA] = { mathclass='normal', adobename='uni29CA', texname='triangleodot' },
	[0x029CB] = { mathclass='normal', adobename='uni29CB', texname='triangleubar' },
	[0x029CC] = { mathclass='normal', adobename='uni29CC', texname='triangles' },
	[0x029CD] = { mathclass='binary', adobename='uni29CD', texname='triangleserifs' },
	[0x029CE] = { mathclass='relation', adobename='uni29CE', texname='rtriltri' },
	[0x029CF] = { mathclass='relation', adobename='uni29CF', texname='ltrivb' },
	[0x029D0] = { mathclass='relation', adobename='uni29D0', texname='vbrtri' },
	[0x029D1] = { mathclass='relation', adobename='uni29D1', texname='lfbowtie' },
	[0x029D2] = { mathclass='relation', adobename='uni29D2', texname='rfbowtie' },
	[0x029D3] = { mathclass='relation', adobename='uni29D3', texname='fbowtie' },
	[0x029D4] = { mathclass='relation', adobename='uni29D4', texname='lftimes' },
	[0x029D5] = { mathclass='relation', adobename='uni29D5', texname='rftimes' },
	[0x029D6] = { mathclass='binary', adobename='uni29D6', texname='hourglass' },
	[0x029D7] = { mathclass='binary', adobename='uni29D7', texname='blackhourglass' },
	[0x029D8] = { mathclass='opening', adobename='uni29D8', texname='lvzigzag' },
	[0x029D9] = { mathclass='closing', adobename='uni29D9', texname='rvzigzag' },
	[0x029DA] = { mathclass='opening', adobename='uni29DA', texname='Lvzigzag' },
	[0x029DB] = { mathclass='closing', adobename='uni29DB', texname='Rvzigzag' },
	[0x029DC] = { mathclass='normal', adobename='uni29DC', texname='iinfin' },
	[0x029DD] = { mathclass='normal', adobename='uni29DD', texname='tieinfty' },
	[0x029DE] = { mathclass='normal', adobename='uni29DE', texname='nvinfty' },
	[0x029DF] = { mathclass='relation', adobename='uni29DF', texname='dualmap' },
	[0x029E0] = { mathclass='normal', adobename='uni29E0', texname='laplac' },
	[0x029E1] = { mathclass='relation', adobename='uni29E1', texname='lrtriangleeq' },
	[0x029E2] = { mathclass='unknown', adobename='uni29E2', texname='shuffle' },
	[0x029E3] = { mathclass='relation', adobename='uni29E3', texname='eparsl' },
	[0x029E4] = { mathclass='relation', adobename='uni29E4', texname='smeparsl' },
	[0x029E5] = { mathclass='relation', adobename='uni29E5', texname='eqvparsl' },
	[0x029E6] = { mathclass='relation', adobename='uni29E6', texname='gleichstark' },
	[0x029E7] = { mathclass='normal', adobename='uni29E7', texname='thermod' },
	[0x029E8] = { mathclass='normal', adobename='uni29E8', texname='downtriangleleftblack' },
	[0x029E9] = { mathclass='normal', adobename='uni29E9', texname='downtrianglerightblack' },
	[0x029EA] = { mathclass='normal', adobename='uni29EA', texname='blackdiamonddownarrow' },
	[0x029EB] = { mathclass='binary', adobename='uni29EB', texname='mdlgblklozenge' },
	[0x029EC] = { mathclass='normal', adobename='uni29EC', texname='circledownarrow' },
	[0x029ED] = { mathclass='normal', adobename='uni29ED', texname='blackcircledownarrow' },
	[0x029EE] = { mathclass='normal', adobename='uni29EE', texname='errbarsquare' },
	[0x029EF] = { mathclass='normal', adobename='uni29EF', texname='errbarblacksquare' },
	[0x029F0] = { mathclass='normal', adobename='uni29F0', texname='errbardiamond' },
	[0x029F1] = { mathclass='normal', adobename='uni29F1', texname='errbarblackdiamond' },
	[0x029F2] = { mathclass='normal', adobename='uni29F2', texname='errbarcircle' },
	[0x029F3] = { mathclass='normal', adobename='uni29F3', texname='errbarblackcircle' },
	[0x029F4] = { mathclass='relation', adobename='uni29F4', texname='ruledelayed' },
	[0x029F5] = { mathclass='binary', adobename='uni29F5', texname='opbackslash' },
	[0x029F6] = { mathclass='binary', adobename='uni29F6', texname='dsol' },
	[0x029F7] = { mathclass='binary', adobename='uni29F7', texname='rsolbar' },
	[0x029F8] = { mathclass='large', adobename='uni29F8', texname='xsol' },
	[0x029F9] = { mathclass='large', adobename='uni29F9', texname='xbsol' },
	[0x029FA] = { mathclass='binary', adobename='uni29FA', texname='doubleplus' },
	[0x029FB] = { mathclass='binary', adobename='uni29FB', texname='tripleplus' },
	[0x029FC] = { mathclass='opening', adobename='uni29FC', texname='lcurvyangle' },
	[0x029FD] = { mathclass='closing', adobename='uni29FD', texname='rcurvyangle' },
	[0x029FE] = { mathclass='binary', adobename='uni29FE', texname='tplus' },
	[0x029FF] = { mathclass='binary', adobename='uni29FF', texname='tminus' },
	[0x02A00] = { mathclass='large', adobename='uni2A00', texname='bigodot' },
	[0x02A01] = { mathclass='large', adobename='uni2A01', texname='bigoplus' },
	[0x02A02] = { mathclass='large', adobename='uni2A02', texname='bigotimes' },
	[0x02A03] = { mathclass='large', adobename='uni2A03', texname='bigcupdot' },
	[0x02A04] = { mathclass='large', adobename='uni2A04', texname='biguplus' },
	[0x02A05] = { mathclass='large', adobename='uni2A05', texname='bigsqcap' },
	[0x02A06] = { mathclass='large', adobename='uni2A06', texname='bigsqcup' },
	[0x02A07] = { mathclass='large', adobename='uni2A07', texname='conjquant' },
	[0x02A08] = { mathclass='large', adobename='uni2A08', texname='disjquant' },
	[0x02A09] = { mathclass='large', adobename='uni2A09', texname='bigtimes' },
	[0x02A0A] = { mathclass='unknown', adobename='uni2A0A', texname='modtwosum' },
	[0x02A0B] = { mathclass='large', adobename='uni2A0B', texname='sumint' },
	[0x02A0C] = { mathclass='large', adobename='uni2A0C', texname='iiiint' },
	[0x02A0D] = { mathclass='large', adobename='uni2A0D', texname='intbar' },
	[0x02A0E] = { mathclass='large', adobename='uni2A0E', texname='intBar' },
	[0x02A0F] = { mathclass='large', adobename='uni2A0F', texname='fint' },
	[0x02A10] = { mathclass='large', adobename='uni2A10', texname='cirfnint' },
	[0x02A11] = { mathclass='large', adobename='uni2A11', texname='awint' },
	[0x02A12] = { mathclass='large', adobename='uni2A12', texname='rppolint' },
	[0x02A13] = { mathclass='large', adobename='uni2A13', texname='scpolint' },
	[0x02A14] = { mathclass='large', adobename='uni2A14', texname='npolint' },
	[0x02A15] = { mathclass='large', adobename='uni2A15', texname='pointint' },
	[0x02A16] = { mathclass='large', adobename='uni2A16', texname='sqint' },
	[0x02A17] = { mathclass='large', adobename='uni2A17', texname='intlarhk' },
	[0x02A18] = { mathclass='large', adobename='uni2A18', texname='intx' },
	[0x02A19] = { mathclass='large', adobename='uni2A19', texname='intcap' },
	[0x02A1A] = { mathclass='large', adobename='uni2A1A', texname='intcup' },
	[0x02A1B] = { mathclass='large', adobename='uni2A1B', texname='upint' },
	[0x02A1C] = { mathclass='large', adobename='uni2A1C', texname='lowint' },
	[0x02A1D] = { mathclass='large', adobename='uni2A1D', texname='Join' },
	[0x02A1E] = { mathclass='large', adobename='uni2A1E', texname='bigtriangleleft' },
	[0x02A1F] = { mathclass='large', adobename='uni2A1F', texname='zcmp' },
	[0x02A20] = { mathclass='large', adobename='uni2A20', texname='zpipe' },
	[0x02A21] = { mathclass='large', adobename='uni2A21', texname='zproject' },
	[0x02A22] = { mathclass='binary', adobename='uni2A22', texname='ringplus' },
	[0x02A23] = { mathclass='binary', adobename='uni2A23', texname='plushat' },
	[0x02A24] = { mathclass='binary', adobename='uni2A24', texname='simplus' },
	[0x02A25] = { mathclass='binary', adobename='uni2A25', texname='plusdot' },
	[0x02A26] = { mathclass='binary', adobename='uni2A26', texname='plussim' },
	[0x02A27] = { mathclass='binary', adobename='uni2A27', texname='plussubtwo' },
	[0x02A28] = { mathclass='binary', adobename='uni2A28', texname='plustrif' },
	[0x02A29] = { mathclass='binary', adobename='uni2A29', texname='commaminus' },
	[0x02A2A] = { mathclass='binary', adobename='uni2A2A', texname='minusdot' },
	[0x02A2B] = { mathclass='binary', adobename='uni2A2B', texname='minusfdots' },
	[0x02A2C] = { mathclass='binary', adobename='uni2A2C', texname='minusrdots' },
	[0x02A2D] = { mathclass='binary', adobename='uni2A2D', texname='opluslhrim' },
	[0x02A2E] = { mathclass='binary', adobename='uni2A2E', texname='oplusrhrim' },
	[0x02A2F] = { mathclass='binary', adobename='uni2A2F', texname='vectimes' },
	[0x02A30] = { mathclass='binary', adobename='uni2A30', texname='dottimes' },
	[0x02A31] = { mathclass='binary', adobename='uni2A31', texname='timesbar' },
	[0x02A32] = { mathclass='binary', adobename='uni2A32', texname='btimes' },
	[0x02A33] = { mathclass='binary', adobename='uni2A33', texname='smashtimes' },
	[0x02A34] = { mathclass='binary', adobename='uni2A34', texname='otimeslhrim' },
	[0x02A35] = { mathclass='binary', adobename='uni2A35', texname='otimesrhrim' },
	[0x02A36] = { mathclass='binary', adobename='uni2A36', texname='otimeshat' },
	[0x02A37] = { mathclass='binary', adobename='uni2A37', texname='Otimes' },
	[0x02A38] = { mathclass='binary', adobename='uni2A38', texname='odiv' },
	[0x02A39] = { mathclass='binary', adobename='uni2A39', texname='triangleplus' },
	[0x02A3A] = { mathclass='binary', adobename='uni2A3A', texname='triangleminus' },
	[0x02A3B] = { mathclass='binary', adobename='uni2A3B', texname='triangletimes' },
	[0x02A3C] = { mathclass='binary', adobename='uni2A3C', texname='intprod' },
	[0x02A3D] = { mathclass='binary', adobename='uni2A3D', texname='intprodr' },
	[0x02A3E] = { mathclass='binary', adobename='uni2A3E', texname='fcmp' },
	[0x02A3F] = { mathclass='binary', adobename='uni2A3F', texname='amalg' },
	[0x02A40] = { mathclass='binary', adobename='uni2A40', texname='capdot' },
	[0x02A41] = { mathclass='binary', adobename='uni2A41', texname='uminus' },
	[0x02A42] = { mathclass='binary', adobename='uni2A42', texname='barcup' },
	[0x02A43] = { mathclass='binary', adobename='uni2A43', texname='barcap' },
	[0x02A44] = { mathclass='binary', adobename='uni2A44', texname='capwedge' },
	[0x02A45] = { mathclass='binary', adobename='uni2A45', texname='cupvee' },
	[0x02A46] = { mathclass='binary', adobename='uni2A46', texname='cupovercap' },
	[0x02A47] = { mathclass='binary', adobename='uni2A47', texname='capovercup' },
	[0x02A48] = { mathclass='binary', adobename='uni2A48', texname='cupbarcap' },
	[0x02A49] = { mathclass='binary', adobename='uni2A49', texname='capbarcup' },
	[0x02A4A] = { mathclass='binary', adobename='uni2A4A', texname='twocups' },
	[0x02A4B] = { mathclass='binary', adobename='uni2A4B', texname='twocaps' },
	[0x02A4C] = { mathclass='binary', adobename='uni2A4C', texname='closedvarcup' },
	[0x02A4D] = { mathclass='binary', adobename='uni2A4D', texname='closedvarcap' },
	[0x02A4E] = { mathclass='binary', adobename='uni2A4E', texname='Sqcap' },
	[0x02A4F] = { mathclass='binary', adobename='uni2A4F', texname='Sqcup' },
	[0x02A50] = { mathclass='binary', adobename='uni2A50', texname='closedvarcupsmashprod' },
	[0x02A51] = { mathclass='binary', adobename='uni2A51', texname='wedgeodot' },
	[0x02A52] = { mathclass='binary', adobename='uni2A52', texname='veeodot' },
	[0x02A53] = { mathclass='binary', adobename='uni2A53', texname='Wedge' },
	[0x02A54] = { mathclass='binary', adobename='uni2A54', texname='Vee' },
	[0x02A55] = { mathclass='binary', adobename='uni2A55', texname='wedgeonwedge' },
	[0x02A56] = { mathclass='binary', adobename='uni2A56', texname='veeonvee' },
	[0x02A57] = { mathclass='binary', adobename='uni2A57', texname='bigslopedvee' },
	[0x02A58] = { mathclass='binary', adobename='uni2A58', texname='bigslopedwedge' },
	[0x02A59] = { mathclass='relation', adobename='uni2A59', texname='veeonwedge' },
	[0x02A5A] = { mathclass='binary', adobename='uni2A5A', texname='wedgemidvert' },
	[0x02A5B] = { mathclass='binary', adobename='uni2A5B', texname='veemidvert' },
	[0x02A5C] = { mathclass='binary', adobename='uni2A5C', texname='midbarwedge' },
	[0x02A5D] = { mathclass='binary', adobename='uni2A5D', texname='midbarvee' },
	[0x02A5E] = { mathclass='binary', adobename='uni2A5E', texname='doublebarwedge' },
	[0x02A5F] = { mathclass='binary', adobename='uni2A5F', texname='wedgebar' },
	[0x02A60] = { mathclass='binary', adobename='uni2A60', texname='wedgedoublebar' },
	[0x02A61] = { mathclass='binary', adobename='uni2A61', texname='varveebar' },
	[0x02A62] = { mathclass='binary', adobename='uni2A62', texname='doublebarvee' },
	[0x02A63] = { mathclass='binary', adobename='uni2A63', texname='veedoublebar' },
	[0x02A64] = { mathclass='binary', adobename='uni2A64', texname='dsub' },
	[0x02A65] = { mathclass='binary', adobename='uni2A65', texname='rsub' },
	[0x02A66] = { mathclass='relation', adobename='uni2A66', texname='eqdot' },
	[0x02A67] = { mathclass='relation', adobename='uni2A67', texname='dotequiv' },
	[0x02A68] = { mathclass='unknown', adobename='uni2A68', texname='equivVert' },
	[0x02A69] = { mathclass='unknown', adobename='uni2A69', texname='equivVvert' },
	[0x02A6A] = { mathclass='relation', adobename='uni2A6A', texname='dotsim' },
	[0x02A6B] = { mathclass='relation', adobename='uni2A6B', texname='simrdots' },
	[0x02A6C] = { mathclass='relation', adobename='uni2A6C', texname='simminussim' },
	[0x02A6D] = { mathclass='relation', adobename='uni2A6D', texname='congdot' },
	[0x02A6E] = { mathclass='relation', adobename='uni2A6E', texname='asteq' },
	[0x02A6F] = { mathclass='relation', adobename='uni2A6F', texname='hatapprox' },
	[0x02A70] = { mathclass='relation', adobename='uni2A70', texname='approxeqq' },
	[0x02A71] = { mathclass='binary', adobename='uni2A71', texname='eqqplus' },
	[0x02A72] = { mathclass='binary', adobename='uni2A72', texname='pluseqq' },
	[0x02A73] = { mathclass='relation', adobename='uni2A73', texname='eqqsim' },
	[0x02A74] = { mathclass='relation', adobename='uni2A74', texname='Coloneq' },
	[0x02A75] = { mathclass='relation', adobename='uni2A75', texname='eqeq' },
	[0x02A76] = { mathclass='relation', adobename='uni2A76', texname='eqeqeq' },
	[0x02A77] = { mathclass='relation', adobename='uni2A77', texname='ddotseq' },
	[0x02A78] = { mathclass='relation', adobename='uni2A78', texname='equivDD' },
	[0x02A79] = { mathclass='relation', adobename='uni2A79', texname='ltcir' },
	[0x02A7A] = { mathclass='relation', adobename='uni2A7A', texname='gtcir' },
	[0x02A7B] = { mathclass='relation', adobename='uni2A7B', texname='ltquest' },
	[0x02A7C] = { mathclass='relation', adobename='uni2A7C', texname='gtquest' },
	[0x02A7D] = { mathclass='relation', adobename='uni2A7D', texname='leqslant' },
	[0x02A7E] = { mathclass='relation', adobename='uni2A7E', texname='geqslant' },
	[0x02A7F] = { mathclass='relation', adobename='uni2A7F', texname='lesdot' },
	[0x02A80] = { mathclass='relation', adobename='uni2A80', texname='gesdot' },
	[0x02A81] = { mathclass='relation', adobename='uni2A81', texname='lesdoto' },
	[0x02A82] = { mathclass='relation', adobename='uni2A82', texname='gesdoto' },
	[0x02A83] = { mathclass='relation', adobename='uni2A83', texname='lesdotor' },
	[0x02A84] = { mathclass='relation', adobename='uni2A84', texname='gesdotol' },
	[0x02A85] = { mathclass='relation', adobename='uni2A85', texname='lessapprox' },
	[0x02A86] = { mathclass='relation', adobename='uni2A86', texname='gtrapprox' },
	[0x02A87] = { mathclass='relation', adobename='uni2A87', texname='lneq' },
	[0x02A88] = { mathclass='relation', adobename='uni2A88', texname='gneq' },
	[0x02A89] = { mathclass='relation', adobename='uni2A89', texname='lnapprox' },
	[0x02A8A] = { mathclass='relation', adobename='uni2A8A', texname='gnapprox' },
	[0x02A8B] = { mathclass='relation', adobename='uni2A8B', texname='lesseqqgtr' },
	[0x02A8C] = { mathclass='relation', adobename='uni2A8C', texname='gtreqqless' },
	[0x02A8D] = { mathclass='relation', adobename='uni2A8D', texname='lsime' },
	[0x02A8E] = { mathclass='relation', adobename='uni2A8E', texname='gsime' },
	[0x02A8F] = { mathclass='relation', adobename='uni2A8F', texname='lsimg' },
	[0x02A90] = { mathclass='relation', adobename='uni2A90', texname='gsiml' },
	[0x02A91] = { mathclass='relation', adobename='uni2A91', texname='lgE' },
	[0x02A92] = { mathclass='relation', adobename='uni2A92', texname='glE' },
	[0x02A93] = { mathclass='relation', adobename='uni2A93', texname='lesges' },
	[0x02A94] = { mathclass='relation', adobename='uni2A94', texname='gesles' },
	[0x02A95] = { mathclass='relation', adobename='uni2A95', texname='eqslantless' },
	[0x02A96] = { mathclass='relation', adobename='uni2A96', texname='eqslantgtr' },
	[0x02A97] = { mathclass='relation', adobename='uni2A97', texname='elsdot' },
	[0x02A98] = { mathclass='relation', adobename='uni2A98', texname='egsdot' },
	[0x02A99] = { mathclass='relation', adobename='uni2A99', texname='eqqless' },
	[0x02A9A] = { mathclass='relation', adobename='uni2A9A', texname='eqqgtr' },
	[0x02A9B] = { mathclass='relation', adobename='uni2A9B', texname='eqqslantless' },
	[0x02A9C] = { mathclass='relation', adobename='uni2A9C', texname='eqqslantgtr' },
	[0x02A9D] = { mathclass='relation', adobename='uni2A9D', texname='simless' },
	[0x02A9E] = { mathclass='relation', adobename='uni2A9E', texname='simgtr' },
	[0x02A9F] = { mathclass='relation', adobename='uni2A9F', texname='simlE' },
	[0x02AA0] = { mathclass='relation', adobename='uni2AA0', texname='simgE' },
	[0x02AA1] = { mathclass='relation', adobename='uni2AA1', texname='Lt' },
	[0x02AA2] = { mathclass='relation', adobename='uni2AA2', texname='Gt' },
	[0x02AA3] = { mathclass='relation', adobename='uni2AA3', texname='partialmeetcontraction' },
	[0x02AA4] = { mathclass='relation', adobename='uni2AA4', texname='glj' },
	[0x02AA5] = { mathclass='relation', adobename='uni2AA5', texname='gla' },
	[0x02AA6] = { mathclass='relation', adobename='uni2AA6', texname='ltcc' },
	[0x02AA7] = { mathclass='relation', adobename='uni2AA7', texname='gtcc' },
	[0x02AA8] = { mathclass='relation', adobename='uni2AA8', texname='lescc' },
	[0x02AA9] = { mathclass='relation', adobename='uni2AA9', texname='gescc' },
	[0x02AAA] = { mathclass='relation', adobename='uni2AAA', texname='smt' },
	[0x02AAB] = { mathclass='relation', adobename='uni2AAB', texname='lat' },
	[0x02AAC] = { mathclass='relation', adobename='uni2AAC', texname='smte' },
	[0x02AAD] = { mathclass='relation', adobename='uni2AAD', texname='late' },
	[0x02AAE] = { mathclass='relation', adobename='uni2AAE', texname='bumpeqq' },
	[0x02AAF] = { mathclass='relation', adobename='uni2AAF', texname='preceq' },
	[0x02AB0] = { mathclass='relation', adobename='uni2AB0', texname='succeq' },
	[0x02AB1] = { mathclass='relation', adobename='uni2AB1', texname='precneq' },
	[0x02AB2] = { mathclass='relation', adobename='uni2AB2', texname='succneq' },
	[0x02AB3] = { mathclass='relation', adobename='uni2AB3', texname='preceqq' },
	[0x02AB4] = { mathclass='relation', adobename='uni2AB4', texname='succeqq' },
	[0x02AB5] = { mathclass='relation', adobename='uni2AB5', texname='precneqq' },
	[0x02AB6] = { mathclass='relation', adobename='uni2AB6', texname='succneqq' },
	[0x02AB7] = { mathclass='relation', adobename='uni2AB7', texname='precapprox' },
	[0x02AB8] = { mathclass='relation', adobename='uni2AB8', texname='succapprox' },
	[0x02AB9] = { mathclass='relation', adobename='uni2AB9', texname='precnapprox' },
	[0x02ABA] = { mathclass='relation', adobename='uni2ABA', texname='succnapprox' },
	[0x02ABB] = { mathclass='relation', adobename='uni2ABB', texname='Prec' },
	[0x02ABC] = { mathclass='relation', adobename='uni2ABC', texname='Succ' },
	[0x02ABD] = { mathclass='relation', adobename='uni2ABD', texname='subsetdot' },
	[0x02ABE] = { mathclass='relation', adobename='uni2ABE', texname='supsetdot' },
	[0x02ABF] = { mathclass='relation', adobename='uni2ABF', texname='subsetplus' },
	[0x02AC0] = { mathclass='relation', adobename='uni2AC0', texname='supsetplus' },
	[0x02AC1] = { mathclass='relation', adobename='uni2AC1', texname='submult' },
	[0x02AC2] = { mathclass='relation', adobename='uni2AC2', texname='supmult' },
	[0x02AC3] = { mathclass='relation', adobename='uni2AC3', texname='subedot' },
	[0x02AC4] = { mathclass='relation', adobename='uni2AC4', texname='supedot' },
	[0x02AC5] = { mathclass='relation', adobename='uni2AC5', texname='subseteqq' },
	[0x02AC6] = { mathclass='relation', adobename='uni2AC6', texname='supseteqq' },
	[0x02AC7] = { mathclass='relation', adobename='uni2AC7', texname='subsim' },
	[0x02AC8] = { mathclass='relation', adobename='uni2AC8', texname='supsim' },
	[0x02AC9] = { mathclass='relation', adobename='uni2AC9', texname='subsetapprox' },
	[0x02ACA] = { mathclass='relation', adobename='uni2ACA', texname='supsetapprox' },
	[0x02ACB] = { mathclass='relation', adobename='uni2ACB', texname='subsetneqq' },
	[0x02ACC] = { mathclass='relation', adobename='uni2ACC', texname='supsetneqq' },
	[0x02ACD] = { mathclass='relation', adobename='uni2ACD', texname='lsqhook' },
	[0x02ACE] = { mathclass='relation', adobename='uni2ACE', texname='rsqhook' },
	[0x02ACF] = { mathclass='relation', adobename='uni2ACF', texname='csub' },
	[0x02AD0] = { mathclass='relation', adobename='uni2AD0', texname='csup' },
	[0x02AD1] = { mathclass='relation', adobename='uni2AD1', texname='csube' },
	[0x02AD2] = { mathclass='relation', adobename='uni2AD2', texname='csupe' },
	[0x02AD3] = { mathclass='relation', adobename='uni2AD3', texname='subsup' },
	[0x02AD4] = { mathclass='relation', adobename='uni2AD4', texname='supsub' },
	[0x02AD5] = { mathclass='relation', adobename='uni2AD5', texname='subsub' },
	[0x02AD6] = { mathclass='relation', adobename='uni2AD6', texname='supsup' },
	[0x02AD7] = { mathclass='relation', adobename='uni2AD7', texname='suphsub' },
	[0x02AD8] = { mathclass='relation', adobename='uni2AD8', texname='supdsub' },
	[0x02AD9] = { mathclass='relation', adobename='uni2AD9', texname='forkv' },
	[0x02ADA] = { mathclass='relation', adobename='uni2ADA', texname='topfork' },
	[0x02ADB] = { mathclass='relation', adobename='uni2ADB', texname='mlcp' },
	[0x02ADC] = { mathclass='relation', adobename='uni2ADC', texname='forks' },
	[0x02ADD] = { mathclass='relation', adobename='uni2ADD', texname='forksnot' },
	[0x02ADE] = { mathclass='relation', adobename='uni2ADE', texname='shortlefttack' },
	[0x02ADF] = { mathclass='relation', adobename='uni2ADF', texname='shortdowntack' },
	[0x02AE0] = { mathclass='relation', adobename='uni2AE0', texname='shortuptack' },
	[0x02AE1] = { mathclass='unknown', adobename='uni2AE1', texname='perps' },
	[0x02AE2] = { mathclass='relation', adobename='uni2AE2', texname='vDdash' },
	[0x02AE3] = { mathclass='relation', adobename='uni2AE3', texname='dashV' },
	[0x02AE4] = { mathclass='relation', adobename='uni2AE4', texname='Dashv' },
	[0x02AE5] = { mathclass='relation', adobename='uni2AE5', texname='DashV' },
	[0x02AE6] = { mathclass='relation', adobename='uni2AE6', texname='varVdash' },
	[0x02AE7] = { mathclass='relation', adobename='uni2AE7', texname='Barv' },
	[0x02AE8] = { mathclass='relation', adobename='uni2AE8', texname='vBar' },
	[0x02AE9] = { mathclass='relation', adobename='uni2AE9', texname='vBarv' },
	[0x02AEA] = { mathclass='relation', adobename='uni2AEA', texname='barV' },
	[0x02AEB] = { mathclass='relation', adobename='uni2AEB', texname='Vbar' },
	[0x02AEC] = { mathclass='relation', adobename='uni2AEC', texname='Not' },
	[0x02AED] = { mathclass='relation', adobename='uni2AED', texname='bNot' },
	[0x02AEE] = { mathclass='relation', adobename='uni2AEE', texname='revnmid' },
	[0x02AEF] = { mathclass='relation', adobename='uni2AEF', texname='cirmid' },
	[0x02AF0] = { mathclass='relation', adobename='uni2AF0', texname='midcir' },
	[0x02AF1] = { mathclass='normal', adobename='uni2AF1', texname='topcir' },
	[0x02AF2] = { mathclass='relation', adobename='uni2AF2', texname='nhpar' },
	[0x02AF3] = { mathclass='relation', adobename='uni2AF3', texname='parsim' },
	[0x02AF4] = { mathclass='binary', adobename='uni2AF4', texname='interleave' },
	[0x02AF5] = { mathclass='binary', adobename='uni2AF5', texname='nhVvert' },
	[0x02AF6] = { mathclass='binary', adobename='uni2AF6', texname='threedotcolon' },
	[0x02AF7] = { mathclass='relation', adobename='uni2AF7', texname='lllnest' },
	[0x02AF8] = { mathclass='relation', adobename='uni2AF8', texname='gggnest' },
	[0x02AF9] = { mathclass='relation', adobename='uni2AF9', texname='leqqslant' },
	[0x02AFA] = { mathclass='relation', adobename='uni2AFA', texname='geqqslant' },
	[0x02AFB] = { mathclass='binary', adobename='uni2AFB', texname='trslash' },
	[0x02AFC] = { mathclass='large', adobename='uni2AFC', texname='biginterleave' },
	[0x02AFD] = { mathclass='binary', adobename='uni2AFD', texname='sslash' },
	[0x02AFE] = { mathclass='binary', adobename='uni2AFE', texname='talloblong' },
	[0x02AFF] = { mathclass='large', adobename='uni2AFF', texname='bigtalloblong' },
	[0x02B12] = { mathclass='normal', adobename='uni2B12', texname='squaretopblack' },
	[0x02B13] = { mathclass='normal', adobename='uni2B13', texname='squarebotblack' },
	[0x02B14] = { mathclass='normal', adobename='uni2B14', texname='squareurblack' },
	[0x02B15] = { mathclass='normal', adobename='uni2B15', texname='squarellblack' },
	[0x02B16] = { mathclass='normal', adobename='uni2B16', texname='diamondleftblack' },
	[0x02B17] = { mathclass='normal', adobename='uni2B17', texname='diamondrightblack' },
	[0x02B18] = { mathclass='normal', adobename='uni2B18', texname='diamondtopblack' },
	[0x02B19] = { mathclass='normal', adobename='uni2B19', texname='diamondbotblack' },
	[0x02B1A] = { mathclass='normal', adobename='uni2B1A', texname='dottedsquare' },
	[0x02B20] = { mathclass='normal', adobename='uni2B20', texname='pentagon' },
	[0x02B21] = { mathclass='normal', adobename='uni2B21', texname='varhexagon' },
	[0x02B22] = { mathclass='normal', adobename='uni2B22', texname='varhexagonblack' },
	[0x02B23] = { mathclass='normal', adobename='uni2B23', texname='hexagonblack' },
	[0x0300A] = { mathclass='unknown', adobename='uni300A', texname='lAngle' },
	[0x0300B] = { mathclass='unknown', adobename='uni300B', texname='rAngle' },
	[0x03012] = { mathclass='unknown', adobename='uni3012', texname='postalmark' },
	[0x03014] = { mathclass='opening', adobename='uni3014', texname='lbrbrak' },
	[0x03015] = { mathclass='closing', adobename='uni3015', texname='rbrbrak' },
	[0x03018] = { mathclass='opening', adobename='uni3018', texname='Lbrbrak' },
	[0x03019] = { mathclass='closing', adobename='uni3019', texname='Rbrbrak' },
	[0x0301A] = { mathclass='unknown', adobename='uni301A', texname='lBrack' },
	[0x0301B] = { mathclass='unknown', adobename='uni301B', texname='rBrack' },
	[0x0301E] = { mathclass='unknown', adobename='uni301E', texname='cjkdprimequote' },
	[0x03030] = { mathclass='unknown', adobename='uni3030', texname='hzigzag' },
	[0x0306E] = { mathclass='normal', adobename='uni306E', texname='hiraganano' },
	[0x1D400] = { mathclass='alphabetic', adobename='u1D400', texname='bfA' },
	[0x1D401] = { mathclass='alphabetic', adobename='u1D401', texname='bfB' },
	[0x1D402] = { mathclass='alphabetic', adobename='u1D402', texname='bfC' },
	[0x1D403] = { mathclass='alphabetic', adobename='u1D403', texname='bfD' },
	[0x1D404] = { mathclass='alphabetic', adobename='u1D404', texname='bfE' },
	[0x1D405] = { mathclass='alphabetic', adobename='u1D405', texname='bfF' },
	[0x1D406] = { mathclass='alphabetic', adobename='u1D406', texname='bfG' },
	[0x1D407] = { mathclass='alphabetic', adobename='u1D407', texname='bfH' },
	[0x1D408] = { mathclass='alphabetic', adobename='u1D408', texname='bfI' },
	[0x1D409] = { mathclass='alphabetic', adobename='u1D409', texname='bfJ' },
	[0x1D40A] = { mathclass='alphabetic', adobename='u1D40A', texname='bfK' },
	[0x1D40B] = { mathclass='alphabetic', adobename='u1D40B', texname='bfL' },
	[0x1D40C] = { mathclass='alphabetic', adobename='u1D40C', texname='bfM' },
	[0x1D40D] = { mathclass='alphabetic', adobename='u1D40D', texname='bfN' },
	[0x1D40E] = { mathclass='alphabetic', adobename='u1D40E', texname='bfO' },
	[0x1D40F] = { mathclass='alphabetic', adobename='u1D40F', texname='bfP' },
	[0x1D410] = { mathclass='alphabetic', adobename='u1D410', texname='bfQ' },
	[0x1D411] = { mathclass='alphabetic', adobename='u1D411', texname='bfR' },
	[0x1D412] = { mathclass='alphabetic', adobename='u1D412', texname='bfS' },
	[0x1D413] = { mathclass='alphabetic', adobename='u1D413', texname='bfT' },
	[0x1D414] = { mathclass='alphabetic', adobename='u1D414', texname='bfU' },
	[0x1D415] = { mathclass='alphabetic', adobename='u1D415', texname='bfV' },
	[0x1D416] = { mathclass='alphabetic', adobename='u1D416', texname='bfW' },
	[0x1D417] = { mathclass='alphabetic', adobename='u1D417', texname='bfX' },
	[0x1D418] = { mathclass='alphabetic', adobename='u1D418', texname='bfY' },
	[0x1D419] = { mathclass='alphabetic', adobename='u1D419', texname='bfZ' },
	[0x1D41A] = { mathclass='alphabetic', adobename='u1D41A', texname='bfa' },
	[0x1D41B] = { mathclass='alphabetic', adobename='u1D41B', texname='bfb' },
	[0x1D41C] = { mathclass='alphabetic', adobename='u1D41C', texname='bfc' },
	[0x1D41D] = { mathclass='alphabetic', adobename='u1D41D', texname='bfd' },
	[0x1D41E] = { mathclass='alphabetic', adobename='u1D41E', texname='bfe' },
	[0x1D41F] = { mathclass='alphabetic', adobename='u1D41F', texname='bff' },
	[0x1D420] = { mathclass='alphabetic', adobename='u1D420', texname='bfg' },
	[0x1D421] = { mathclass='alphabetic', adobename='u1D421', texname='bfh' },
	[0x1D422] = { mathclass='alphabetic', adobename='u1D422', texname='bfi' },
	[0x1D423] = { mathclass='alphabetic', adobename='u1D423', texname='bfj' },
	[0x1D424] = { mathclass='alphabetic', adobename='u1D424', texname='bfk' },
	[0x1D425] = { mathclass='alphabetic', adobename='u1D425', texname='bfl' },
	[0x1D426] = { mathclass='alphabetic', adobename='u1D426', texname='bfm' },
	[0x1D427] = { mathclass='alphabetic', adobename='u1D427', texname='bfn' },
	[0x1D428] = { mathclass='alphabetic', adobename='u1D428', texname='bfo' },
	[0x1D429] = { mathclass='alphabetic', adobename='u1D429', texname='bfp' },
	[0x1D42A] = { mathclass='alphabetic', adobename='u1D42A', texname='bfq' },
	[0x1D42B] = { mathclass='alphabetic', adobename='u1D42B', texname='bfr' },
	[0x1D42C] = { mathclass='alphabetic', adobename='u1D42C', texname='bfs' },
	[0x1D42D] = { mathclass='alphabetic', adobename='u1D42D', texname='bft' },
	[0x1D42E] = { mathclass='alphabetic', adobename='u1D42E', texname='bfu' },
	[0x1D42F] = { mathclass='alphabetic', adobename='u1D42F', texname='bfv' },
	[0x1D430] = { mathclass='alphabetic', adobename='u1D430', texname='bfw' },
	[0x1D431] = { mathclass='alphabetic', adobename='u1D431', texname='bfx' },
	[0x1D432] = { mathclass='alphabetic', adobename='u1D432', texname='bfy' },
	[0x1D433] = { mathclass='alphabetic', adobename='u1D433', texname='bfz' },
	[0x1D434] = { mathclass='alphabetic', adobename='u1D434', texname='itA' },
	[0x1D435] = { mathclass='alphabetic', adobename='u1D435', texname='itB' },
	[0x1D436] = { mathclass='alphabetic', adobename='u1D436', texname='itC' },
	[0x1D437] = { mathclass='alphabetic', adobename='u1D437', texname='itD' },
	[0x1D438] = { mathclass='alphabetic', adobename='u1D438', texname='itE' },
	[0x1D439] = { mathclass='alphabetic', adobename='u1D439', texname='itF' },
	[0x1D43A] = { mathclass='alphabetic', adobename='u1D43A', texname='itG' },
	[0x1D43B] = { mathclass='alphabetic', adobename='u1D43B', texname='itH' },
	[0x1D43C] = { mathclass='alphabetic', adobename='u1D43C', texname='itI' },
	[0x1D43D] = { mathclass='alphabetic', adobename='u1D43D', texname='itJ' },
	[0x1D43E] = { mathclass='alphabetic', adobename='u1D43E', texname='itK' },
	[0x1D43F] = { mathclass='alphabetic', adobename='u1D43F', texname='itL' },
	[0x1D440] = { mathclass='alphabetic', adobename='u1D440', texname='itM' },
	[0x1D441] = { mathclass='alphabetic', adobename='u1D441', texname='itN' },
	[0x1D442] = { mathclass='alphabetic', adobename='u1D442', texname='itO' },
	[0x1D443] = { mathclass='alphabetic', adobename='u1D443', texname='itP' },
	[0x1D444] = { mathclass='alphabetic', adobename='u1D444', texname='itQ' },
	[0x1D445] = { mathclass='alphabetic', adobename='u1D445', texname='itR' },
	[0x1D446] = { mathclass='alphabetic', adobename='u1D446', texname='itS' },
	[0x1D447] = { mathclass='alphabetic', adobename='u1D447', texname='itT' },
	[0x1D448] = { mathclass='alphabetic', adobename='u1D448', texname='itU' },
	[0x1D449] = { mathclass='alphabetic', adobename='u1D449', texname='itV' },
	[0x1D44A] = { mathclass='alphabetic', adobename='u1D44A', texname='itW' },
	[0x1D44B] = { mathclass='alphabetic', adobename='u1D44B', texname='itX' },
	[0x1D44C] = { mathclass='alphabetic', adobename='u1D44C', texname='itY' },
	[0x1D44D] = { mathclass='alphabetic', adobename='u1D44D', texname='itZ' },
	[0x1D44E] = { mathclass='alphabetic', adobename='u1D44E', texname='ita' },
	[0x1D44F] = { mathclass='alphabetic', adobename='u1D44F', texname='itb' },
	[0x1D450] = { mathclass='alphabetic', adobename='u1D450', texname='itc' },
	[0x1D451] = { mathclass='alphabetic', adobename='u1D451', texname='itd' },
	[0x1D452] = { mathclass='alphabetic', adobename='u1D452', texname='ite' },
	[0x1D453] = { mathclass='alphabetic', adobename='u1D453', texname='itf' },
	[0x1D454] = { mathclass='alphabetic', adobename='u1D454', texname='itg' },
	[0x1D455] = { mathclass='alphabetic', adobename='uni210E', texname='ith' },
	[0x1D456] = { mathclass='alphabetic', adobename='u1D456', texname='iti' },
	[0x1D457] = { mathclass='alphabetic', adobename='u1D457', texname='itj' },
	[0x1D458] = { mathclass='alphabetic', adobename='u1D458', texname='itk' },
	[0x1D459] = { mathclass='alphabetic', adobename='u1D459', texname='itl' },
	[0x1D45A] = { mathclass='alphabetic', adobename='u1D45A', texname='itm' },
	[0x1D45B] = { mathclass='alphabetic', adobename='u1D45B', texname='itn' },
	[0x1D45C] = { mathclass='alphabetic', adobename='u1D45C', texname='ito' },
	[0x1D45D] = { mathclass='alphabetic', adobename='u1D45D', texname='itp' },
	[0x1D45E] = { mathclass='alphabetic', adobename='u1D45E', texname='itq' },
	[0x1D45F] = { mathclass='alphabetic', adobename='u1D45F', texname='itr' },
	[0x1D460] = { mathclass='alphabetic', adobename='u1D460', texname='its' },
	[0x1D461] = { mathclass='alphabetic', adobename='u1D461', texname='itt' },
	[0x1D462] = { mathclass='alphabetic', adobename='u1D462', texname='itu' },
	[0x1D463] = { mathclass='alphabetic', adobename='u1D463', texname='itv' },
	[0x1D464] = { mathclass='alphabetic', adobename='u1D464', texname='itw' },
	[0x1D465] = { mathclass='alphabetic', adobename='u1D465', texname='itx' },
	[0x1D466] = { mathclass='alphabetic', adobename='u1D466', texname='ity' },
	[0x1D467] = { mathclass='alphabetic', adobename='u1D467', texname='itz' },
	[0x1D468] = { mathclass='alphabetic', adobename='u1D468', texname='bfitA' },
	[0x1D469] = { mathclass='alphabetic', adobename='u1D469', texname='bfitB' },
	[0x1D46A] = { mathclass='alphabetic', adobename='u1D46A', texname='bfitC' },
	[0x1D46B] = { mathclass='alphabetic', adobename='u1D46B', texname='bfitD' },
	[0x1D46C] = { mathclass='alphabetic', adobename='u1D46C', texname='bfitE' },
	[0x1D46D] = { mathclass='alphabetic', adobename='u1D46D', texname='bfitF' },
	[0x1D46E] = { mathclass='alphabetic', adobename='u1D46E', texname='bfitG' },
	[0x1D46F] = { mathclass='alphabetic', adobename='u1D46F', texname='bfitH' },
	[0x1D470] = { mathclass='alphabetic', adobename='u1D470', texname='bfitI' },
	[0x1D471] = { mathclass='alphabetic', adobename='u1D471', texname='bfitJ' },
	[0x1D472] = { mathclass='alphabetic', adobename='u1D472', texname='bfitK' },
	[0x1D473] = { mathclass='alphabetic', adobename='u1D473', texname='bfitL' },
	[0x1D474] = { mathclass='alphabetic', adobename='u1D474', texname='bfitM' },
	[0x1D475] = { mathclass='alphabetic', adobename='u1D475', texname='bfitN' },
	[0x1D476] = { mathclass='alphabetic', adobename='u1D476', texname='bfitO' },
	[0x1D477] = { mathclass='alphabetic', adobename='u1D477', texname='bfitP' },
	[0x1D478] = { mathclass='alphabetic', adobename='u1D478', texname='bfitQ' },
	[0x1D479] = { mathclass='alphabetic', adobename='u1D479', texname='bfitR' },
	[0x1D47A] = { mathclass='alphabetic', adobename='u1D47A', texname='bfitS' },
	[0x1D47B] = { mathclass='alphabetic', adobename='u1D47B', texname='bfitT' },
	[0x1D47C] = { mathclass='alphabetic', adobename='u1D47C', texname='bfitU' },
	[0x1D47D] = { mathclass='alphabetic', adobename='u1D47D', texname='bfitV' },
	[0x1D47E] = { mathclass='alphabetic', adobename='u1D47E', texname='bfitW' },
	[0x1D47F] = { mathclass='alphabetic', adobename='u1D47F', texname='bfitX' },
	[0x1D480] = { mathclass='alphabetic', adobename='u1D480', texname='bfitY' },
	[0x1D481] = { mathclass='alphabetic', adobename='u1D481', texname='bfitZ' },
	[0x1D482] = { mathclass='alphabetic', adobename='u1D482', texname='bfita' },
	[0x1D483] = { mathclass='alphabetic', adobename='u1D483', texname='bfitb' },
	[0x1D484] = { mathclass='alphabetic', adobename='u1D484', texname='bfitc' },
	[0x1D485] = { mathclass='alphabetic', adobename='u1D485', texname='bfitd' },
	[0x1D486] = { mathclass='alphabetic', adobename='u1D486', texname='bfite' },
	[0x1D487] = { mathclass='alphabetic', adobename='u1D487', texname='bfitf' },
	[0x1D488] = { mathclass='alphabetic', adobename='u1D488', texname='bfitg' },
	[0x1D489] = { mathclass='alphabetic', adobename='u1D489', texname='bfith' },
	[0x1D48A] = { mathclass='alphabetic', adobename='u1D48A', texname='bfiti' },
	[0x1D48B] = { mathclass='alphabetic', adobename='u1D48B', texname='bfitj' },
	[0x1D48C] = { mathclass='alphabetic', adobename='u1D48C', texname='bfitk' },
	[0x1D48D] = { mathclass='alphabetic', adobename='u1D48D', texname='bfitl' },
	[0x1D48E] = { mathclass='alphabetic', adobename='u1D48E', texname='bfitm' },
	[0x1D48F] = { mathclass='alphabetic', adobename='u1D48F', texname='bfitn' },
	[0x1D490] = { mathclass='alphabetic', adobename='u1D490', texname='bfito' },
	[0x1D491] = { mathclass='alphabetic', adobename='u1D491', texname='bfitp' },
	[0x1D492] = { mathclass='alphabetic', adobename='u1D492', texname='bfitq' },
	[0x1D493] = { mathclass='alphabetic', adobename='u1D493', texname='bfitr' },
	[0x1D494] = { mathclass='alphabetic', adobename='u1D494', texname='bfits' },
	[0x1D495] = { mathclass='alphabetic', adobename='u1D495', texname='bfitt' },
	[0x1D496] = { mathclass='alphabetic', adobename='u1D496', texname='bfitu' },
	[0x1D497] = { mathclass='alphabetic', adobename='u1D497', texname='bfitv' },
	[0x1D498] = { mathclass='alphabetic', adobename='u1D498', texname='bfitw' },
	[0x1D499] = { mathclass='alphabetic', adobename='u1D499', texname='bfitx' },
	[0x1D49A] = { mathclass='alphabetic', adobename='u1D49A', texname='bfity' },
	[0x1D49B] = { mathclass='alphabetic', adobename='u1D49B', texname='bfitz' },
	[0x1D49C] = { mathclass='alphabetic', adobename='u1D49C', texname='scrA' },
	[0x1D49D] = { mathclass='alphabetic', adobename='uni212C', texname='scrB' },
	[0x1D49E] = { mathclass='alphabetic', adobename='u1D49E', texname='scrC' },
	[0x1D49F] = { mathclass='alphabetic', adobename='u1D49F', texname='scrD' },
	[0x1D4A0] = { mathclass='alphabetic', adobename='uni2130', texname='scrE' },
	[0x1D4A1] = { mathclass='alphabetic', adobename='uni2131', texname='scrF' },
	[0x1D4A2] = { mathclass='alphabetic', adobename='u1D4A2', texname='scrG' },
	[0x1D4A3] = { mathclass='alphabetic', adobename='uni210B', texname='scrH' },
	[0x1D4A4] = { mathclass='alphabetic', adobename='uni2110', texname='scrI' },
	[0x1D4A5] = { mathclass='alphabetic', adobename='u1D4A5', texname='scrJ' },
	[0x1D4A6] = { mathclass='alphabetic', adobename='u1D4A6', texname='scrK' },
	[0x1D4A7] = { mathclass='alphabetic', adobename='uni2112', texname='scrL' },
	[0x1D4A8] = { mathclass='alphabetic', adobename='uni2133', texname='scrM' },
	[0x1D4A9] = { mathclass='alphabetic', adobename='u1D4A9', texname='scrN' },
	[0x1D4AA] = { mathclass='alphabetic', adobename='u1D4AA', texname='scrO' },
	[0x1D4AB] = { mathclass='alphabetic', adobename='u1D4AB', texname='scrP' },
	[0x1D4AC] = { mathclass='alphabetic', adobename='u1D4AC', texname='scrQ' },
	[0x1D4AD] = { mathclass='alphabetic', adobename='uni211B', texname='scrR' },
	[0x1D4AE] = { mathclass='alphabetic', adobename='u1D4AE', texname='scrS' },
	[0x1D4AF] = { mathclass='alphabetic', adobename='u1D4AF', texname='scrT' },
	[0x1D4B0] = { mathclass='alphabetic', adobename='u1D4B0', texname='scrU' },
	[0x1D4B1] = { mathclass='alphabetic', adobename='u1D4B1', texname='scrV' },
	[0x1D4B2] = { mathclass='alphabetic', adobename='u1D4B2', texname='scrW' },
	[0x1D4B3] = { mathclass='alphabetic', adobename='u1D4B3', texname='scrX' },
	[0x1D4B4] = { mathclass='alphabetic', adobename='u1D4B4', texname='scrY' },
	[0x1D4B5] = { mathclass='alphabetic', adobename='u1D4B5', texname='scrZ' },
	[0x1D4B6] = { mathclass='alphabetic', adobename='u1D4B6', texname='scra' },
	[0x1D4B7] = { mathclass='alphabetic', adobename='u1D4B7', texname='scrb' },
	[0x1D4B8] = { mathclass='alphabetic', adobename='u1D4B8', texname='scrc' },
	[0x1D4B9] = { mathclass='alphabetic', adobename='u1D4B9', texname='scrd' },
	[0x1D4BA] = { mathclass='alphabetic', adobename='uni212F', texname='scre' },
	[0x1D4BB] = { mathclass='alphabetic', adobename='u1D4BB', texname='scrf' },
	[0x1D4BC] = { mathclass='alphabetic', adobename='uni210A', texname='scrg' },
	[0x1D4BD] = { mathclass='alphabetic', adobename='u1D4BD', texname='scrh' },
	[0x1D4BE] = { mathclass='alphabetic', adobename='u1D4BE', texname='scri' },
	[0x1D4BF] = { mathclass='alphabetic', adobename='u1D4BF', texname='scrj' },
	[0x1D4C0] = { mathclass='alphabetic', adobename='u1D4C0', texname='scrk' },
	[0x1D4C1] = { mathclass='alphabetic', adobename='u1D4C1', texname='scrl' },
	[0x1D4C2] = { mathclass='alphabetic', adobename='u1D4C2', texname='scrm' },
	[0x1D4C3] = { mathclass='alphabetic', adobename='u1D4C3', texname='scrn' },
	[0x1D4C4] = { mathclass='alphabetic', adobename='uni2134', texname='scro' },
	[0x1D4C5] = { mathclass='alphabetic', adobename='u1D4C5', texname='scrp' },
	[0x1D4C6] = { mathclass='alphabetic', adobename='u1D4C6', texname='scrq' },
	[0x1D4C7] = { mathclass='alphabetic', adobename='u1D4C7', texname='scrr' },
	[0x1D4C8] = { mathclass='alphabetic', adobename='u1D4C8', texname='scrs' },
	[0x1D4C9] = { mathclass='alphabetic', adobename='u1D4C9', texname='scrt' },
	[0x1D4CA] = { mathclass='alphabetic', adobename='u1D4CA', texname='scru' },
	[0x1D4CB] = { mathclass='alphabetic', adobename='u1D4CB', texname='scrv' },
	[0x1D4CC] = { mathclass='alphabetic', adobename='u1D4CC', texname='scrw' },
	[0x1D4CD] = { mathclass='alphabetic', adobename='u1D4CD', texname='scrx' },
	[0x1D4CE] = { mathclass='alphabetic', adobename='u1D4CE', texname='scry' },
	[0x1D4CF] = { mathclass='alphabetic', adobename='u1D4CF', texname='scrz' },
	[0x1D4D0] = { mathclass='alphabetic', adobename='u1D4D0', texname='bfscrA' },
	[0x1D4D1] = { mathclass='alphabetic', adobename='u1D4D1', texname='bfscrB' },
	[0x1D4D2] = { mathclass='alphabetic', adobename='u1D4D2', texname='bfscrC' },
	[0x1D4D3] = { mathclass='alphabetic', adobename='u1D4D3', texname='bfscrD' },
	[0x1D4D4] = { mathclass='alphabetic', adobename='u1D4D4', texname='bfscrE' },
	[0x1D4D5] = { mathclass='alphabetic', adobename='u1D4D5', texname='bfscrF' },
	[0x1D4D6] = { mathclass='alphabetic', adobename='u1D4D6', texname='bfscrG' },
	[0x1D4D7] = { mathclass='alphabetic', adobename='u1D4D7', texname='bfscrH' },
	[0x1D4D8] = { mathclass='alphabetic', adobename='u1D4D8', texname='bfscrI' },
	[0x1D4D9] = { mathclass='alphabetic', adobename='u1D4D9', texname='bfscrJ' },
	[0x1D4DA] = { mathclass='alphabetic', adobename='u1D4DA', texname='bfscrK' },
	[0x1D4DB] = { mathclass='alphabetic', adobename='u1D4DB', texname='bfscrL' },
	[0x1D4DC] = { mathclass='alphabetic', adobename='u1D4DC', texname='bfscrM' },
	[0x1D4DD] = { mathclass='alphabetic', adobename='u1D4DD', texname='bfscrN' },
	[0x1D4DE] = { mathclass='alphabetic', adobename='u1D4DE', texname='bfscrO' },
	[0x1D4DF] = { mathclass='alphabetic', adobename='u1D4DF', texname='bfscrP' },
	[0x1D4E0] = { mathclass='alphabetic', adobename='u1D4E0', texname='bfscrQ' },
	[0x1D4E1] = { mathclass='alphabetic', adobename='u1D4E1', texname='bfscrR' },
	[0x1D4E2] = { mathclass='alphabetic', adobename='u1D4E2', texname='bfscrS' },
	[0x1D4E3] = { mathclass='alphabetic', adobename='u1D4E3', texname='bfscrT' },
	[0x1D4E4] = { mathclass='alphabetic', adobename='u1D4E4', texname='bfscrU' },
	[0x1D4E5] = { mathclass='alphabetic', adobename='u1D4E5', texname='bfscrV' },
	[0x1D4E6] = { mathclass='alphabetic', adobename='u1D4E6', texname='bfscrW' },
	[0x1D4E7] = { mathclass='alphabetic', adobename='u1D4E7', texname='bfscrX' },
	[0x1D4E8] = { mathclass='alphabetic', adobename='u1D4E8', texname='bfscrY' },
	[0x1D4E9] = { mathclass='alphabetic', adobename='u1D4E9', texname='bfscrZ' },
	[0x1D4EA] = { mathclass='alphabetic', adobename='u1D4EA', texname='bfscra' },
	[0x1D4EB] = { mathclass='alphabetic', adobename='u1D4EB', texname='bfscrb' },
	[0x1D4EC] = { mathclass='alphabetic', adobename='u1D4EC', texname='bfscrc' },
	[0x1D4ED] = { mathclass='alphabetic', adobename='u1D4ED', texname='bfscrd' },
	[0x1D4EE] = { mathclass='alphabetic', adobename='u1D4EE', texname='bfscre' },
	[0x1D4EF] = { mathclass='alphabetic', adobename='u1D4EF', texname='bfscrf' },
	[0x1D4F0] = { mathclass='alphabetic', adobename='u1D4F0', texname='bfscrg' },
	[0x1D4F1] = { mathclass='alphabetic', adobename='u1D4F1', texname='bfscrh' },
	[0x1D4F2] = { mathclass='alphabetic', adobename='u1D4F2', texname='bfscri' },
	[0x1D4F3] = { mathclass='alphabetic', adobename='u1D4F3', texname='bfscrj' },
	[0x1D4F4] = { mathclass='alphabetic', adobename='u1D4F4', texname='bfscrk' },
	[0x1D4F5] = { mathclass='alphabetic', adobename='u1D4F5', texname='bfscrl' },
	[0x1D4F6] = { mathclass='alphabetic', adobename='u1D4F6', texname='bfscrm' },
	[0x1D4F7] = { mathclass='alphabetic', adobename='u1D4F7', texname='bfscrn' },
	[0x1D4F8] = { mathclass='alphabetic', adobename='u1D4F8', texname='bfscro' },
	[0x1D4F9] = { mathclass='alphabetic', adobename='u1D4F9', texname='bfscrp' },
	[0x1D4FA] = { mathclass='alphabetic', adobename='u1D4FA', texname='bfscrq' },
	[0x1D4FB] = { mathclass='alphabetic', adobename='u1D4FB', texname='bfscrr' },
	[0x1D4FC] = { mathclass='alphabetic', adobename='u1D4FC', texname='bfscrs' },
	[0x1D4FD] = { mathclass='alphabetic', adobename='u1D4FD', texname='bfscrt' },
	[0x1D4FE] = { mathclass='alphabetic', adobename='u1D4FE', texname='bfscru' },
	[0x1D4FF] = { mathclass='alphabetic', adobename='u1D4FF', texname='bfscrv' },
	[0x1D500] = { mathclass='alphabetic', adobename='u1D500', texname='bfscrw' },
	[0x1D501] = { mathclass='alphabetic', adobename='u1D501', texname='bfscrx' },
	[0x1D502] = { mathclass='alphabetic', adobename='u1D502', texname='bfscry' },
	[0x1D503] = { mathclass='alphabetic', adobename='u1D503', texname='bfscrz' },
	[0x1D504] = { mathclass='alphabetic', adobename='u1D504', texname='frakA' },
	[0x1D505] = { mathclass='alphabetic', adobename='u1D505', texname='frakB' },
	[0x1D506] = { mathclass='alphabetic', adobename='uni212D', texname='frakC' },
	[0x1D507] = { mathclass='alphabetic', adobename='u1D507', texname='frakD' },
	[0x1D508] = { mathclass='alphabetic', adobename='u1D508', texname='frakE' },
	[0x1D509] = { mathclass='alphabetic', adobename='u1D509', texname='frakF' },
	[0x1D50A] = { mathclass='alphabetic', adobename='u1D50A', texname='frakG' },
	[0x1D50B] = { mathclass='alphabetic', adobename='uni210C', texname='frakH' },
	[0x1D50C] = { mathclass='alphabetic', adobename='uni2111', texname='frakI' },
	[0x1D50D] = { mathclass='alphabetic', adobename='u1D50D', texname='frakJ' },
	[0x1D50E] = { mathclass='alphabetic', adobename='u1D50E', texname='frakK' },
	[0x1D50F] = { mathclass='alphabetic', adobename='u1D50F', texname='frakL' },
	[0x1D510] = { mathclass='alphabetic', adobename='u1D510', texname='frakM' },
	[0x1D511] = { mathclass='alphabetic', adobename='u1D511', texname='frakN' },
	[0x1D512] = { mathclass='alphabetic', adobename='u1D512', texname='frakO' },
	[0x1D513] = { mathclass='alphabetic', adobename='u1D513', texname='frakP' },
	[0x1D514] = { mathclass='alphabetic', adobename='u1D514', texname='frakQ' },
	[0x1D515] = { mathclass='alphabetic', adobename='uni211C', texname='frakR' },
	[0x1D516] = { mathclass='alphabetic', adobename='u1D516', texname='frakS' },
	[0x1D517] = { mathclass='alphabetic', adobename='u1D517', texname='frakT' },
	[0x1D518] = { mathclass='alphabetic', adobename='u1D518', texname='frakU' },
	[0x1D519] = { mathclass='alphabetic', adobename='u1D519', texname='frakV' },
	[0x1D51A] = { mathclass='alphabetic', adobename='u1D51A', texname='frakW' },
	[0x1D51B] = { mathclass='alphabetic', adobename='u1D51B', texname='frakX' },
	[0x1D51C] = { mathclass='alphabetic', adobename='u1D51C', texname='frakY' },
	[0x1D51D] = { mathclass='alphabetic', adobename='uni2128', texname='frakZ' },
	[0x1D51E] = { mathclass='alphabetic', adobename='u1D51E', texname='fraka' },
	[0x1D51F] = { mathclass='alphabetic', adobename='u1D51F', texname='frakb' },
	[0x1D520] = { mathclass='alphabetic', adobename='u1D520', texname='frakc' },
	[0x1D521] = { mathclass='alphabetic', adobename='u1D521', texname='frakd' },
	[0x1D522] = { mathclass='alphabetic', adobename='u1D522', texname='frake' },
	[0x1D523] = { mathclass='alphabetic', adobename='u1D523', texname='frakf' },
	[0x1D524] = { mathclass='alphabetic', adobename='u1D524', texname='frakg' },
	[0x1D525] = { mathclass='alphabetic', adobename='u1D525', texname='frakh' },
	[0x1D526] = { mathclass='alphabetic', adobename='u1D526', texname='fraki' },
	[0x1D527] = { mathclass='alphabetic', adobename='u1D527', texname='frakj' },
	[0x1D528] = { mathclass='alphabetic', adobename='u1D528', texname='frakk' },
	[0x1D529] = { mathclass='alphabetic', adobename='u1D529', texname='frakl' },
	[0x1D52A] = { mathclass='alphabetic', adobename='u1D52A', texname='frakm' },
	[0x1D52B] = { mathclass='alphabetic', adobename='u1D52B', texname='frakn' },
	[0x1D52C] = { mathclass='alphabetic', adobename='u1D52C', texname='frako' },
	[0x1D52D] = { mathclass='alphabetic', adobename='u1D52D', texname='frakp' },
	[0x1D52E] = { mathclass='alphabetic', adobename='u1D52E', texname='frakq' },
	[0x1D52F] = { mathclass='alphabetic', adobename='u1D52F', texname='frakr' },
	[0x1D530] = { mathclass='alphabetic', adobename='u1D530', texname='fraks' },
	[0x1D531] = { mathclass='alphabetic', adobename='u1D531', texname='frakt' },
	[0x1D532] = { mathclass='alphabetic', adobename='u1D532', texname='fraku' },
	[0x1D533] = { mathclass='alphabetic', adobename='u1D533', texname='frakv' },
	[0x1D534] = { mathclass='alphabetic', adobename='u1D534', texname='frakw' },
	[0x1D535] = { mathclass='alphabetic', adobename='u1D535', texname='frakx' },
	[0x1D536] = { mathclass='alphabetic', adobename='u1D536', texname='fraky' },
	[0x1D537] = { mathclass='alphabetic', adobename='u1D537', texname='frakz' },
	[0x1D538] = { mathclass='alphabetic', adobename='u1D538', texname='BbbA' },
	[0x1D539] = { mathclass='alphabetic', adobename='u1D539', texname='BbbB' },
	[0x1D53A] = { mathclass='alphabetic', adobename='uni2102', texname='BbbC' },
	[0x1D53B] = { mathclass='alphabetic', adobename='u1D53B', texname='BbbD' },
	[0x1D53C] = { mathclass='alphabetic', adobename='u1D53C', texname='BbbE' },
	[0x1D53D] = { mathclass='alphabetic', adobename='u1D53D', texname='BbbF' },
	[0x1D53E] = { mathclass='alphabetic', adobename='u1D53E', texname='BbbG' },
	[0x1D53F] = { mathclass='alphabetic', adobename='uni210D', texname='BbbH' },
	[0x1D540] = { mathclass='alphabetic', adobename='u1D540', texname='BbbI' },
	[0x1D541] = { mathclass='alphabetic', adobename='u1D541', texname='BbbJ' },
	[0x1D542] = { mathclass='alphabetic', adobename='u1D542', texname='BbbK' },
	[0x1D543] = { mathclass='alphabetic', adobename='u1D543', texname='BbbL' },
	[0x1D544] = { mathclass='alphabetic', adobename='u1D544', texname='BbbM' },
	[0x1D545] = { mathclass='alphabetic', adobename='uni2115', texname='BbbN' },
	[0x1D546] = { mathclass='alphabetic', adobename='u1D546', texname='BbbO' },
	[0x1D547] = { mathclass='alphabetic', adobename='uni2119', texname='BbbP' },
	[0x1D548] = { mathclass='alphabetic', adobename='uni211A', texname='BbbQ' },
	[0x1D549] = { mathclass='alphabetic', adobename='uni211D', texname='BbbR' },
	[0x1D54A] = { mathclass='alphabetic', adobename='u1D54A', texname='BbbS' },
	[0x1D54B] = { mathclass='alphabetic', adobename='u1D54B', texname='BbbT' },
	[0x1D54C] = { mathclass='alphabetic', adobename='u1D54C', texname='BbbU' },
	[0x1D54D] = { mathclass='alphabetic', adobename='u1D54D', texname='BbbV' },
	[0x1D54E] = { mathclass='alphabetic', adobename='u1D54E', texname='BbbW' },
	[0x1D54F] = { mathclass='alphabetic', adobename='u1D54F', texname='BbbX' },
	[0x1D550] = { mathclass='alphabetic', adobename='u1D550', texname='BbbY' },
	[0x1D551] = { mathclass='alphabetic', adobename='uni2124', texname='BbbZ' },
	[0x1D552] = { mathclass='alphabetic', adobename='u1D552', texname='Bbba' },
	[0x1D553] = { mathclass='alphabetic', adobename='u1D553', texname='Bbbb' },
	[0x1D554] = { mathclass='alphabetic', adobename='u1D554', texname='Bbbc' },
	[0x1D555] = { mathclass='alphabetic', adobename='u1D555', texname='Bbbd' },
	[0x1D556] = { mathclass='alphabetic', adobename='u1D556', texname='Bbbe' },
	[0x1D557] = { mathclass='alphabetic', adobename='u1D557', texname='Bbbf' },
	[0x1D558] = { mathclass='alphabetic', adobename='u1D558', texname='Bbbg' },
	[0x1D559] = { mathclass='alphabetic', adobename='u1D559', texname='Bbbh' },
	[0x1D55A] = { mathclass='alphabetic', adobename='u1D55A', texname='Bbbi' },
	[0x1D55B] = { mathclass='alphabetic', adobename='u1D55B', texname='Bbbj' },
	[0x1D55C] = { mathclass='alphabetic', adobename='u1D55C', texname='Bbbk' },
	[0x1D55D] = { mathclass='alphabetic', adobename='u1D55D', texname='Bbbl' },
	[0x1D55E] = { mathclass='alphabetic', adobename='u1D55E', texname='Bbbm' },
	[0x1D55F] = { mathclass='alphabetic', adobename='u1D55F', texname='Bbbn' },
	[0x1D560] = { mathclass='alphabetic', adobename='u1D560', texname='Bbbo' },
	[0x1D561] = { mathclass='alphabetic', adobename='u1D561', texname='Bbbp' },
	[0x1D562] = { mathclass='alphabetic', adobename='u1D562', texname='Bbbq' },
	[0x1D563] = { mathclass='alphabetic', adobename='u1D563', texname='Bbbr' },
	[0x1D564] = { mathclass='alphabetic', adobename='u1D564', texname='Bbbs' },
	[0x1D565] = { mathclass='alphabetic', adobename='u1D565', texname='Bbbt' },
	[0x1D566] = { mathclass='alphabetic', adobename='u1D566', texname='Bbbu' },
	[0x1D567] = { mathclass='alphabetic', adobename='u1D567', texname='Bbbv' },
	[0x1D568] = { mathclass='alphabetic', adobename='u1D568', texname='Bbbw' },
	[0x1D569] = { mathclass='alphabetic', adobename='u1D569', texname='Bbbx' },
	[0x1D56A] = { mathclass='alphabetic', adobename='u1D56A', texname='Bbby' },
	[0x1D56B] = { mathclass='alphabetic', adobename='u1D56B', texname='Bbbz' },
	[0x1D56C] = { mathclass='alphabetic', adobename='u1D56C', texname='bffrakA' },
	[0x1D56D] = { mathclass='alphabetic', adobename='u1D56D', texname='bffrakB' },
	[0x1D56E] = { mathclass='alphabetic', adobename='u1D56E', texname='bffrakC' },
	[0x1D56F] = { mathclass='alphabetic', adobename='u1D56F', texname='bffrakD' },
	[0x1D570] = { mathclass='alphabetic', adobename='u1D570', texname='bffrakE' },
	[0x1D571] = { mathclass='alphabetic', adobename='u1D571', texname='bffrakF' },
	[0x1D572] = { mathclass='alphabetic', adobename='u1D572', texname='bffrakG' },
	[0x1D573] = { mathclass='alphabetic', adobename='u1D573', texname='bffrakH' },
	[0x1D574] = { mathclass='alphabetic', adobename='u1D574', texname='bffrakI' },
	[0x1D575] = { mathclass='alphabetic', adobename='u1D575', texname='bffrakJ' },
	[0x1D576] = { mathclass='alphabetic', adobename='u1D576', texname='bffrakK' },
	[0x1D577] = { mathclass='alphabetic', adobename='u1D577', texname='bffrakL' },
	[0x1D578] = { mathclass='alphabetic', adobename='u1D578', texname='bffrakM' },
	[0x1D579] = { mathclass='alphabetic', adobename='u1D579', texname='bffrakN' },
	[0x1D57A] = { mathclass='alphabetic', adobename='u1D57A', texname='bffrakO' },
	[0x1D57B] = { mathclass='alphabetic', adobename='u1D57B', texname='bffrakP' },
	[0x1D57C] = { mathclass='alphabetic', adobename='u1D57C', texname='bffrakQ' },
	[0x1D57D] = { mathclass='alphabetic', adobename='u1D57D', texname='bffrakR' },
	[0x1D57E] = { mathclass='alphabetic', adobename='u1D57E', texname='bffrakS' },
	[0x1D57F] = { mathclass='alphabetic', adobename='u1D57F', texname='bffrakT' },
	[0x1D580] = { mathclass='alphabetic', adobename='u1D580', texname='bffrakU' },
	[0x1D581] = { mathclass='alphabetic', adobename='u1D581', texname='bffrakV' },
	[0x1D582] = { mathclass='alphabetic', adobename='u1D582', texname='bffrakW' },
	[0x1D583] = { mathclass='alphabetic', adobename='u1D583', texname='bffrakX' },
	[0x1D584] = { mathclass='alphabetic', adobename='u1D584', texname='bffrakY' },
	[0x1D585] = { mathclass='alphabetic', adobename='u1D585', texname='bffrakZ' },
	[0x1D586] = { mathclass='alphabetic', adobename='u1D586', texname='bffraka' },
	[0x1D587] = { mathclass='alphabetic', adobename='u1D587', texname='bffrakb' },
	[0x1D588] = { mathclass='alphabetic', adobename='u1D588', texname='bffrakc' },
	[0x1D589] = { mathclass='alphabetic', adobename='u1D589', texname='bffrakd' },
	[0x1D58A] = { mathclass='alphabetic', adobename='u1D58A', texname='bffrake' },
	[0x1D58B] = { mathclass='alphabetic', adobename='u1D58B', texname='bffrakf' },
	[0x1D58C] = { mathclass='alphabetic', adobename='u1D58C', texname='bffrakg' },
	[0x1D58D] = { mathclass='alphabetic', adobename='u1D58D', texname='bffrakh' },
	[0x1D58E] = { mathclass='alphabetic', adobename='u1D58E', texname='bffraki' },
	[0x1D58F] = { mathclass='alphabetic', adobename='u1D58F', texname='bffrakj' },
	[0x1D590] = { mathclass='alphabetic', adobename='u1D590', texname='bffrakk' },
	[0x1D591] = { mathclass='alphabetic', adobename='u1D591', texname='bffrakl' },
	[0x1D592] = { mathclass='alphabetic', adobename='u1D592', texname='bffrakm' },
	[0x1D593] = { mathclass='alphabetic', adobename='u1D593', texname='bffrakn' },
	[0x1D594] = { mathclass='alphabetic', adobename='u1D594', texname='bffrako' },
	[0x1D595] = { mathclass='alphabetic', adobename='u1D595', texname='bffrakp' },
	[0x1D596] = { mathclass='alphabetic', adobename='u1D596', texname='bffrakq' },
	[0x1D597] = { mathclass='alphabetic', adobename='u1D597', texname='bffrakr' },
	[0x1D598] = { mathclass='alphabetic', adobename='u1D598', texname='bffraks' },
	[0x1D599] = { mathclass='alphabetic', adobename='u1D599', texname='bffrakt' },
	[0x1D59A] = { mathclass='alphabetic', adobename='u1D59A', texname='bffraku' },
	[0x1D59B] = { mathclass='alphabetic', adobename='u1D59B', texname='bffrakv' },
	[0x1D59C] = { mathclass='alphabetic', adobename='u1D59C', texname='bffrakw' },
	[0x1D59D] = { mathclass='alphabetic', adobename='u1D59D', texname='bffrakx' },
	[0x1D59E] = { mathclass='alphabetic', adobename='u1D59E', texname='bffraky' },
	[0x1D59F] = { mathclass='alphabetic', adobename='u1D59F', texname='bffrakz' },
	[0x1D5A0] = { mathclass='alphabetic', adobename='u1D5A0', texname='sansA' },
	[0x1D5A1] = { mathclass='alphabetic', adobename='u1D5A1', texname='sansB' },
	[0x1D5A2] = { mathclass='alphabetic', adobename='u1D5A2', texname='sansC' },
	[0x1D5A3] = { mathclass='alphabetic', adobename='u1D5A3', texname='sansD' },
	[0x1D5A4] = { mathclass='alphabetic', adobename='u1D5A4', texname='sansE' },
	[0x1D5A5] = { mathclass='alphabetic', adobename='u1D5A5', texname='sansF' },
	[0x1D5A6] = { mathclass='alphabetic', adobename='u1D5A6', texname='sansG' },
	[0x1D5A7] = { mathclass='alphabetic', adobename='u1D5A7', texname='sansH' },
	[0x1D5A8] = { mathclass='alphabetic', adobename='u1D5A8', texname='sansI' },
	[0x1D5A9] = { mathclass='alphabetic', adobename='u1D5A9', texname='sansJ' },
	[0x1D5AA] = { mathclass='alphabetic', adobename='u1D5AA', texname='sansK' },
	[0x1D5AB] = { mathclass='alphabetic', adobename='u1D5AB', texname='sansL' },
	[0x1D5AC] = { mathclass='alphabetic', adobename='u1D5AC', texname='sansM' },
	[0x1D5AD] = { mathclass='alphabetic', adobename='u1D5AD', texname='sansN' },
	[0x1D5AE] = { mathclass='alphabetic', adobename='u1D5AE', texname='sansO' },
	[0x1D5AF] = { mathclass='alphabetic', adobename='u1D5AF', texname='sansP' },
	[0x1D5B0] = { mathclass='alphabetic', adobename='u1D5B0', texname='sansQ' },
	[0x1D5B1] = { mathclass='alphabetic', adobename='u1D5B1', texname='sansR' },
	[0x1D5B2] = { mathclass='alphabetic', adobename='u1D5B2', texname='sansS' },
	[0x1D5B3] = { mathclass='alphabetic', adobename='u1D5B3', texname='sansT' },
	[0x1D5B4] = { mathclass='alphabetic', adobename='u1D5B4', texname='sansU' },
	[0x1D5B5] = { mathclass='alphabetic', adobename='u1D5B5', texname='sansV' },
	[0x1D5B6] = { mathclass='alphabetic', adobename='u1D5B6', texname='sansW' },
	[0x1D5B7] = { mathclass='alphabetic', adobename='u1D5B7', texname='sansX' },
	[0x1D5B8] = { mathclass='alphabetic', adobename='u1D5B8', texname='sansY' },
	[0x1D5B9] = { mathclass='alphabetic', adobename='u1D5B9', texname='sansZ' },
	[0x1D5BA] = { mathclass='alphabetic', adobename='u1D5BA', texname='sansa' },
	[0x1D5BB] = { mathclass='alphabetic', adobename='u1D5BB', texname='sansb' },
	[0x1D5BC] = { mathclass='alphabetic', adobename='u1D5BC', texname='sansc' },
	[0x1D5BD] = { mathclass='alphabetic', adobename='u1D5BD', texname='sansd' },
	[0x1D5BE] = { mathclass='alphabetic', adobename='u1D5BE', texname='sanse' },
	[0x1D5BF] = { mathclass='alphabetic', adobename='u1D5BF', texname='sansf' },
	[0x1D5C0] = { mathclass='alphabetic', adobename='u1D5C0', texname='sansg' },
	[0x1D5C1] = { mathclass='alphabetic', adobename='u1D5C1', texname='sansh' },
	[0x1D5C2] = { mathclass='alphabetic', adobename='u1D5C2', texname='sansi' },
	[0x1D5C3] = { mathclass='alphabetic', adobename='u1D5C3', texname='sansj' },
	[0x1D5C4] = { mathclass='alphabetic', adobename='u1D5C4', texname='sansk' },
	[0x1D5C5] = { mathclass='alphabetic', adobename='u1D5C5', texname='sansl' },
	[0x1D5C6] = { mathclass='alphabetic', adobename='u1D5C6', texname='sansm' },
	[0x1D5C7] = { mathclass='alphabetic', adobename='u1D5C7', texname='sansn' },
	[0x1D5C8] = { mathclass='alphabetic', adobename='u1D5C8', texname='sanso' },
	[0x1D5C9] = { mathclass='alphabetic', adobename='u1D5C9', texname='sansp' },
	[0x1D5CA] = { mathclass='alphabetic', adobename='u1D5CA', texname='sansq' },
	[0x1D5CB] = { mathclass='alphabetic', adobename='u1D5CB', texname='sansr' },
	[0x1D5CC] = { mathclass='alphabetic', adobename='u1D5CC', texname='sanss' },
	[0x1D5CD] = { mathclass='alphabetic', adobename='u1D5CD', texname='sanst' },
	[0x1D5CE] = { mathclass='alphabetic', adobename='u1D5CE', texname='sansu' },
	[0x1D5CF] = { mathclass='alphabetic', adobename='u1D5CF', texname='sansv' },
	[0x1D5D0] = { mathclass='alphabetic', adobename='u1D5D0', texname='sansw' },
	[0x1D5D1] = { mathclass='alphabetic', adobename='u1D5D1', texname='sansx' },
	[0x1D5D2] = { mathclass='alphabetic', adobename='u1D5D2', texname='sansy' },
	[0x1D5D3] = { mathclass='alphabetic', adobename='u1D5D3', texname='sansz' },
	[0x1D5D4] = { mathclass='alphabetic', adobename='u1D5D4', texname='bfsansA' },
	[0x1D5D5] = { mathclass='alphabetic', adobename='u1D5D5', texname='bfsansB' },
	[0x1D5D6] = { mathclass='alphabetic', adobename='u1D5D6', texname='bfsansC' },
	[0x1D5D7] = { mathclass='alphabetic', adobename='u1D5D7', texname='bfsansD' },
	[0x1D5D8] = { mathclass='alphabetic', adobename='u1D5D8', texname='bfsansE' },
	[0x1D5D9] = { mathclass='alphabetic', adobename='u1D5D9', texname='bfsansF' },
	[0x1D5DA] = { mathclass='alphabetic', adobename='u1D5DA', texname='bfsansG' },
	[0x1D5DB] = { mathclass='alphabetic', adobename='u1D5DB', texname='bfsansH' },
	[0x1D5DC] = { mathclass='alphabetic', adobename='u1D5DC', texname='bfsansI' },
	[0x1D5DD] = { mathclass='alphabetic', adobename='u1D5DD', texname='bfsansJ' },
	[0x1D5DE] = { mathclass='alphabetic', adobename='u1D5DE', texname='bfsansK' },
	[0x1D5DF] = { mathclass='alphabetic', adobename='u1D5DF', texname='bfsansL' },
	[0x1D5E0] = { mathclass='alphabetic', adobename='u1D5E0', texname='bfsansM' },
	[0x1D5E1] = { mathclass='alphabetic', adobename='u1D5E1', texname='bfsansN' },
	[0x1D5E2] = { mathclass='alphabetic', adobename='u1D5E2', texname='bfsansO' },
	[0x1D5E3] = { mathclass='alphabetic', adobename='u1D5E3', texname='bfsansP' },
	[0x1D5E4] = { mathclass='alphabetic', adobename='u1D5E4', texname='bfsansQ' },
	[0x1D5E5] = { mathclass='alphabetic', adobename='u1D5E5', texname='bfsansR' },
	[0x1D5E6] = { mathclass='alphabetic', adobename='u1D5E6', texname='bfsansS' },
	[0x1D5E7] = { mathclass='alphabetic', adobename='u1D5E7', texname='bfsansT' },
	[0x1D5E8] = { mathclass='alphabetic', adobename='u1D5E8', texname='bfsansU' },
	[0x1D5E9] = { mathclass='alphabetic', adobename='u1D5E9', texname='bfsansV' },
	[0x1D5EA] = { mathclass='alphabetic', adobename='u1D5EA', texname='bfsansW' },
	[0x1D5EB] = { mathclass='alphabetic', adobename='u1D5EB', texname='bfsansX' },
	[0x1D5EC] = { mathclass='alphabetic', adobename='u1D5EC', texname='bfsansY' },
	[0x1D5ED] = { mathclass='alphabetic', adobename='u1D5ED', texname='bfsansZ' },
	[0x1D5EE] = { mathclass='alphabetic', adobename='u1D5EE', texname='bfsansa' },
	[0x1D5EF] = { mathclass='alphabetic', adobename='u1D5EF', texname='bfsansb' },
	[0x1D5F0] = { mathclass='alphabetic', adobename='u1D5F0', texname='bfsansc' },
	[0x1D5F1] = { mathclass='alphabetic', adobename='u1D5F1', texname='bfsansd' },
	[0x1D5F2] = { mathclass='alphabetic', adobename='u1D5F2', texname='bfsanse' },
	[0x1D5F3] = { mathclass='alphabetic', adobename='u1D5F3', texname='bfsansf' },
	[0x1D5F4] = { mathclass='alphabetic', adobename='u1D5F4', texname='bfsansg' },
	[0x1D5F5] = { mathclass='alphabetic', adobename='u1D5F5', texname='bfsansh' },
	[0x1D5F6] = { mathclass='alphabetic', adobename='u1D5F6', texname='bfsansi' },
	[0x1D5F7] = { mathclass='alphabetic', adobename='u1D5F7', texname='bfsansj' },
	[0x1D5F8] = { mathclass='alphabetic', adobename='u1D5F8', texname='bfsansk' },
	[0x1D5F9] = { mathclass='alphabetic', adobename='u1D5F9', texname='bfsansl' },
	[0x1D5FA] = { mathclass='alphabetic', adobename='u1D5FA', texname='bfsansm' },
	[0x1D5FB] = { mathclass='alphabetic', adobename='u1D5FB', texname='bfsansn' },
	[0x1D5FC] = { mathclass='alphabetic', adobename='u1D5FC', texname='bfsanso' },
	[0x1D5FD] = { mathclass='alphabetic', adobename='u1D5FD', texname='bfsansp' },
	[0x1D5FE] = { mathclass='alphabetic', adobename='u1D5FE', texname='bfsansq' },
	[0x1D5FF] = { mathclass='alphabetic', adobename='u1D5FF', texname='bfsansr' },
	[0x1D600] = { mathclass='alphabetic', adobename='u1D600', texname='bfsanss' },
	[0x1D601] = { mathclass='alphabetic', adobename='u1D601', texname='bfsanst' },
	[0x1D602] = { mathclass='alphabetic', adobename='u1D602', texname='bfsansu' },
	[0x1D603] = { mathclass='alphabetic', adobename='u1D603', texname='bfsansv' },
	[0x1D604] = { mathclass='alphabetic', adobename='u1D604', texname='bfsansw' },
	[0x1D605] = { mathclass='alphabetic', adobename='u1D605', texname='bfsansx' },
	[0x1D606] = { mathclass='alphabetic', adobename='u1D606', texname='bfsansy' },
	[0x1D607] = { mathclass='alphabetic', adobename='u1D607', texname='bfsansz' },
	[0x1D608] = { mathclass='alphabetic', adobename='u1D608', texname='itsansA' },
	[0x1D609] = { mathclass='alphabetic', adobename='u1D609', texname='itsansB' },
	[0x1D60A] = { mathclass='alphabetic', adobename='u1D60A', texname='itsansC' },
	[0x1D60B] = { mathclass='alphabetic', adobename='u1D60B', texname='itsansD' },
	[0x1D60C] = { mathclass='alphabetic', adobename='u1D60C', texname='itsansE' },
	[0x1D60D] = { mathclass='alphabetic', adobename='u1D60D', texname='itsansF' },
	[0x1D60E] = { mathclass='alphabetic', adobename='u1D60E', texname='itsansG' },
	[0x1D60F] = { mathclass='alphabetic', adobename='u1D60F', texname='itsansH' },
	[0x1D610] = { mathclass='alphabetic', adobename='u1D610', texname='itsansI' },
	[0x1D611] = { mathclass='alphabetic', adobename='u1D611', texname='itsansJ' },
	[0x1D612] = { mathclass='alphabetic', adobename='u1D612', texname='itsansK' },
	[0x1D613] = { mathclass='alphabetic', adobename='u1D613', texname='itsansL' },
	[0x1D614] = { mathclass='alphabetic', adobename='u1D614', texname='itsansM' },
	[0x1D615] = { mathclass='alphabetic', adobename='u1D615', texname='itsansN' },
	[0x1D616] = { mathclass='alphabetic', adobename='u1D616', texname='itsansO' },
	[0x1D617] = { mathclass='alphabetic', adobename='u1D617', texname='itsansP' },
	[0x1D618] = { mathclass='alphabetic', adobename='u1D618', texname='itsansQ' },
	[0x1D619] = { mathclass='alphabetic', adobename='u1D619', texname='itsansR' },
	[0x1D61A] = { mathclass='alphabetic', adobename='u1D61A', texname='itsansS' },
	[0x1D61B] = { mathclass='alphabetic', adobename='u1D61B', texname='itsansT' },
	[0x1D61C] = { mathclass='alphabetic', adobename='u1D61C', texname='itsansU' },
	[0x1D61D] = { mathclass='alphabetic', adobename='u1D61D', texname='itsansV' },
	[0x1D61E] = { mathclass='alphabetic', adobename='u1D61E', texname='itsansW' },
	[0x1D61F] = { mathclass='alphabetic', adobename='u1D61F', texname='itsansX' },
	[0x1D620] = { mathclass='alphabetic', adobename='u1D620', texname='itsansY' },
	[0x1D621] = { mathclass='alphabetic', adobename='u1D621', texname='itsansZ' },
	[0x1D622] = { mathclass='alphabetic', adobename='u1D622', texname='itsansa' },
	[0x1D623] = { mathclass='alphabetic', adobename='u1D623', texname='itsansb' },
	[0x1D624] = { mathclass='alphabetic', adobename='u1D624', texname='itsansc' },
	[0x1D625] = { mathclass='alphabetic', adobename='u1D625', texname='itsansd' },
	[0x1D626] = { mathclass='alphabetic', adobename='u1D626', texname='itsanse' },
	[0x1D627] = { mathclass='alphabetic', adobename='u1D627', texname='itsansf' },
	[0x1D628] = { mathclass='alphabetic', adobename='u1D628', texname='itsansg' },
	[0x1D629] = { mathclass='alphabetic', adobename='u1D629', texname='itsansh' },
	[0x1D62A] = { mathclass='alphabetic', adobename='u1D62A', texname='itsansi' },
	[0x1D62B] = { mathclass='alphabetic', adobename='u1D62B', texname='itsansj' },
	[0x1D62C] = { mathclass='alphabetic', adobename='u1D62C', texname='itsansk' },
	[0x1D62D] = { mathclass='alphabetic', adobename='u1D62D', texname='itsansl' },
	[0x1D62E] = { mathclass='alphabetic', adobename='u1D62E', texname='itsansm' },
	[0x1D62F] = { mathclass='alphabetic', adobename='u1D62F', texname='itsansn' },
	[0x1D630] = { mathclass='alphabetic', adobename='u1D630', texname='itsanso' },
	[0x1D631] = { mathclass='alphabetic', adobename='u1D631', texname='itsansp' },
	[0x1D632] = { mathclass='alphabetic', adobename='u1D632', texname='itsansq' },
	[0x1D633] = { mathclass='alphabetic', adobename='u1D633', texname='itsansr' },
	[0x1D634] = { mathclass='alphabetic', adobename='u1D634', texname='itsanss' },
	[0x1D635] = { mathclass='alphabetic', adobename='u1D635', texname='itsanst' },
	[0x1D636] = { mathclass='alphabetic', adobename='u1D636', texname='itsansu' },
	[0x1D637] = { mathclass='alphabetic', adobename='u1D637', texname='itsansv' },
	[0x1D638] = { mathclass='alphabetic', adobename='u1D638', texname='itsansw' },
	[0x1D639] = { mathclass='alphabetic', adobename='u1D639', texname='itsansx' },
	[0x1D63A] = { mathclass='alphabetic', adobename='u1D63A', texname='itsansy' },
	[0x1D63B] = { mathclass='alphabetic', adobename='u1D63B', texname='itsansz' },
	[0x1D63C] = { mathclass='alphabetic', adobename='u1D63C', texname='bfitsansA' },
	[0x1D63D] = { mathclass='alphabetic', adobename='u1D63D', texname='bfitsansB' },
	[0x1D63E] = { mathclass='alphabetic', adobename='u1D63E', texname='bfitsansC' },
	[0x1D63F] = { mathclass='alphabetic', adobename='u1D63F', texname='bfitsansD' },
	[0x1D640] = { mathclass='alphabetic', adobename='u1D640', texname='bfitsansE' },
	[0x1D641] = { mathclass='alphabetic', adobename='u1D641', texname='bfitsansF' },
	[0x1D642] = { mathclass='alphabetic', adobename='u1D642', texname='bfitsansG' },
	[0x1D643] = { mathclass='alphabetic', adobename='u1D643', texname='bfitsansH' },
	[0x1D644] = { mathclass='alphabetic', adobename='u1D644', texname='bfitsansI' },
	[0x1D645] = { mathclass='alphabetic', adobename='u1D645', texname='bfitsansJ' },
	[0x1D646] = { mathclass='alphabetic', adobename='u1D646', texname='bfitsansK' },
	[0x1D647] = { mathclass='alphabetic', adobename='u1D647', texname='bfitsansL' },
	[0x1D648] = { mathclass='alphabetic', adobename='u1D648', texname='bfitsansM' },
	[0x1D649] = { mathclass='alphabetic', adobename='u1D649', texname='bfitsansN' },
	[0x1D64A] = { mathclass='alphabetic', adobename='u1D64A', texname='bfitsansO' },
	[0x1D64B] = { mathclass='alphabetic', adobename='u1D64B', texname='bfitsansP' },
	[0x1D64C] = { mathclass='alphabetic', adobename='u1D64C', texname='bfitsansQ' },
	[0x1D64D] = { mathclass='alphabetic', adobename='u1D64D', texname='bfitsansR' },
	[0x1D64E] = { mathclass='alphabetic', adobename='u1D64E', texname='bfitsansS' },
	[0x1D64F] = { mathclass='alphabetic', adobename='u1D64F', texname='bfitsansT' },
	[0x1D650] = { mathclass='alphabetic', adobename='u1D650', texname='bfitsansU' },
	[0x1D651] = { mathclass='alphabetic', adobename='u1D651', texname='bfitsansV' },
	[0x1D652] = { mathclass='alphabetic', adobename='u1D652', texname='bfitsansW' },
	[0x1D653] = { mathclass='alphabetic', adobename='u1D653', texname='bfitsansX' },
	[0x1D654] = { mathclass='alphabetic', adobename='u1D654', texname='bfitsansY' },
	[0x1D655] = { mathclass='alphabetic', adobename='u1D655', texname='bfitsansZ' },
	[0x1D656] = { mathclass='alphabetic', adobename='u1D656', texname='bfitsansa' },
	[0x1D657] = { mathclass='alphabetic', adobename='u1D657', texname='bfitsansb' },
	[0x1D658] = { mathclass='alphabetic', adobename='u1D658', texname='bfitsansc' },
	[0x1D659] = { mathclass='alphabetic', adobename='u1D659', texname='bfitsansd' },
	[0x1D65A] = { mathclass='alphabetic', adobename='u1D65A', texname='bfitsanse' },
	[0x1D65B] = { mathclass='alphabetic', adobename='u1D65B', texname='bfitsansf' },
	[0x1D65C] = { mathclass='alphabetic', adobename='u1D65C', texname='bfitsansg' },
	[0x1D65D] = { mathclass='alphabetic', adobename='u1D65D', texname='bfitsansh' },
	[0x1D65E] = { mathclass='alphabetic', adobename='u1D65E', texname='bfitsansi' },
	[0x1D65F] = { mathclass='alphabetic', adobename='u1D65F', texname='bfitsansj' },
	[0x1D660] = { mathclass='alphabetic', adobename='u1D660', texname='bfitsansk' },
	[0x1D661] = { mathclass='alphabetic', adobename='u1D661', texname='bfitsansl' },
	[0x1D662] = { mathclass='alphabetic', adobename='u1D662', texname='bfitsansm' },
	[0x1D663] = { mathclass='alphabetic', adobename='u1D663', texname='bfitsansn' },
	[0x1D664] = { mathclass='alphabetic', adobename='u1D664', texname='bfitsanso' },
	[0x1D665] = { mathclass='alphabetic', adobename='u1D665', texname='bfitsansp' },
	[0x1D666] = { mathclass='alphabetic', adobename='u1D666', texname='bfitsansq' },
	[0x1D667] = { mathclass='alphabetic', adobename='u1D667', texname='bfitsansr' },
	[0x1D668] = { mathclass='alphabetic', adobename='u1D668', texname='bfitsanss' },
	[0x1D669] = { mathclass='alphabetic', adobename='u1D669', texname='bfitsanst' },
	[0x1D66A] = { mathclass='alphabetic', adobename='u1D66A', texname='bfitsansu' },
	[0x1D66B] = { mathclass='alphabetic', adobename='u1D66B', texname='bfitsansv' },
	[0x1D66C] = { mathclass='alphabetic', adobename='u1D66C', texname='bfitsansw' },
	[0x1D66D] = { mathclass='alphabetic', adobename='u1D66D', texname='bfitsansx' },
	[0x1D66E] = { mathclass='alphabetic', adobename='u1D66E', texname='bfitsansy' },
	[0x1D66F] = { mathclass='alphabetic', adobename='u1D66F', texname='bfitsansz' },
	[0x1D670] = { mathclass='alphabetic', adobename='u1D670', texname='ttA' },
	[0x1D671] = { mathclass='alphabetic', adobename='u1D671', texname='ttB' },
	[0x1D672] = { mathclass='alphabetic', adobename='u1D672', texname='ttC' },
	[0x1D673] = { mathclass='alphabetic', adobename='u1D673', texname='ttD' },
	[0x1D674] = { mathclass='alphabetic', adobename='u1D674', texname='ttE' },
	[0x1D675] = { mathclass='alphabetic', adobename='u1D675', texname='ttF' },
	[0x1D676] = { mathclass='alphabetic', adobename='u1D676', texname='ttG' },
	[0x1D677] = { mathclass='alphabetic', adobename='u1D677', texname='ttH' },
	[0x1D678] = { mathclass='alphabetic', adobename='u1D678', texname='ttI' },
	[0x1D679] = { mathclass='alphabetic', adobename='u1D679', texname='ttJ' },
	[0x1D67A] = { mathclass='alphabetic', adobename='u1D67A', texname='ttK' },
	[0x1D67B] = { mathclass='alphabetic', adobename='u1D67B', texname='ttL' },
	[0x1D67C] = { mathclass='alphabetic', adobename='u1D67C', texname='ttM' },
	[0x1D67D] = { mathclass='alphabetic', adobename='u1D67D', texname='ttN' },
	[0x1D67E] = { mathclass='alphabetic', adobename='u1D67E', texname='ttO' },
	[0x1D67F] = { mathclass='alphabetic', adobename='u1D67F', texname='ttP' },
	[0x1D680] = { mathclass='alphabetic', adobename='u1D680', texname='ttQ' },
	[0x1D681] = { mathclass='alphabetic', adobename='u1D681', texname='ttR' },
	[0x1D682] = { mathclass='alphabetic', adobename='u1D682', texname='ttS' },
	[0x1D683] = { mathclass='alphabetic', adobename='u1D683', texname='ttT' },
	[0x1D684] = { mathclass='alphabetic', adobename='u1D684', texname='ttU' },
	[0x1D685] = { mathclass='alphabetic', adobename='u1D685', texname='ttV' },
	[0x1D686] = { mathclass='alphabetic', adobename='u1D686', texname='ttW' },
	[0x1D687] = { mathclass='alphabetic', adobename='u1D687', texname='ttX' },
	[0x1D688] = { mathclass='alphabetic', adobename='u1D688', texname='ttY' },
	[0x1D689] = { mathclass='alphabetic', adobename='u1D689', texname='ttZ' },
	[0x1D68A] = { mathclass='alphabetic', adobename='u1D68A', texname='tta' },
	[0x1D68B] = { mathclass='alphabetic', adobename='u1D68B', texname='ttb' },
	[0x1D68C] = { mathclass='alphabetic', adobename='u1D68C', texname='ttc' },
	[0x1D68D] = { mathclass='alphabetic', adobename='u1D68D', texname='ttd' },
	[0x1D68E] = { mathclass='alphabetic', adobename='u1D68E', texname='tte' },
	[0x1D68F] = { mathclass='alphabetic', adobename='u1D68F', texname='ttf' },
	[0x1D690] = { mathclass='alphabetic', adobename='u1D690', texname='ttg' },
	[0x1D691] = { mathclass='alphabetic', adobename='u1D691', texname='tth' },
	[0x1D692] = { mathclass='alphabetic', adobename='u1D692', texname='tti' },
	[0x1D693] = { mathclass='alphabetic', adobename='u1D693', texname='ttj' },
	[0x1D694] = { mathclass='alphabetic', adobename='u1D694', texname='ttk' },
	[0x1D695] = { mathclass='alphabetic', adobename='u1D695', texname='ttl' },
	[0x1D696] = { mathclass='alphabetic', adobename='u1D696', texname='ttm' },
	[0x1D697] = { mathclass='alphabetic', adobename='u1D697', texname='ttn' },
	[0x1D698] = { mathclass='alphabetic', adobename='u1D698', texname='tto' },
	[0x1D699] = { mathclass='alphabetic', adobename='u1D699', texname='ttp' },
	[0x1D69A] = { mathclass='alphabetic', adobename='u1D69A', texname='ttq' },
	[0x1D69B] = { mathclass='alphabetic', adobename='u1D69B', texname='ttr' },
	[0x1D69C] = { mathclass='alphabetic', adobename='u1D69C', texname='tts' },
	[0x1D69D] = { mathclass='alphabetic', adobename='u1D69D', texname='ttt' },
	[0x1D69E] = { mathclass='alphabetic', adobename='u1D69E', texname='ttu' },
	[0x1D69F] = { mathclass='alphabetic', adobename='u1D69F', texname='ttv' },
	[0x1D6A0] = { mathclass='alphabetic', adobename='u1D6A0', texname='ttw' },
	[0x1D6A1] = { mathclass='alphabetic', adobename='u1D6A1', texname='ttx' },
	[0x1D6A2] = { mathclass='alphabetic', adobename='u1D6A2', texname='tty' },
	[0x1D6A3] = { mathclass='alphabetic', adobename='u1D6A3', texname='ttz' },
	[0x1D6A4] = { mathclass='alphabetic', adobename='u1D6A4', texname='imath' },
	[0x1D6A5] = { mathclass='alphabetic', adobename='u1D6A5', texname='jmath' },
	[0x1D6A6] = { mathclass='unknown', adobename='u1D6A6' },
	[0x1D6A7] = { mathclass='unknown', adobename='u1D6A7' },
	[0x1D6A8] = { mathclass='alphabetic', adobename='u1D6A8', texname='bfAlpha' },
	[0x1D6A9] = { mathclass='alphabetic', adobename='u1D6A9', texname='bfBeta' },
	[0x1D6AA] = { mathclass='alphabetic', adobename='u1D6AA', texname='bfGamma' },
	[0x1D6AB] = { mathclass='alphabetic', adobename='u1D6AB', texname='bfDelta' },
	[0x1D6AC] = { mathclass='alphabetic', adobename='u1D6AC', texname='bfEpsilon' },
	[0x1D6AD] = { mathclass='alphabetic', adobename='u1D6AD', texname='bfZeta' },
	[0x1D6AE] = { mathclass='alphabetic', adobename='u1D6AE', texname='bfEta' },
	[0x1D6AF] = { mathclass='alphabetic', adobename='u1D6AF', texname='bfTheta' },
	[0x1D6B0] = { mathclass='alphabetic', adobename='u1D6B0', texname='bfIota' },
	[0x1D6B1] = { mathclass='alphabetic', adobename='u1D6B1', texname='bfKappa' },
	[0x1D6B2] = { mathclass='alphabetic', adobename='u1D6B2', texname='bfLambda' },
	[0x1D6B3] = { mathclass='alphabetic', adobename='u1D6B3', texname='bfMu' },
	[0x1D6B4] = { mathclass='alphabetic', adobename='u1D6B4', texname='bfNu' },
	[0x1D6B5] = { mathclass='alphabetic', adobename='u1D6B5', texname='bfXi' },
	[0x1D6B6] = { mathclass='alphabetic', adobename='u1D6B6', texname='bfOmicron' },
	[0x1D6B7] = { mathclass='alphabetic', adobename='u1D6B7', texname='bfPi' },
	[0x1D6B8] = { mathclass='alphabetic', adobename='u1D6B8', texname='bfRho' },
	[0x1D6B9] = { mathclass='alphabetic', adobename='u1D6B9', texname='bfvarTheta' },
	[0x1D6BA] = { mathclass='alphabetic', adobename='u1D6BA', texname='bfSigma' },
	[0x1D6BB] = { mathclass='alphabetic', adobename='u1D6BB', texname='bfTau' },
	[0x1D6BC] = { mathclass='alphabetic', adobename='u1D6BC', texname='bfUpsilon' },
	[0x1D6BD] = { mathclass='alphabetic', adobename='u1D6BD', texname='bfPhi' },
	[0x1D6BE] = { mathclass='alphabetic', adobename='u1D6BE', texname='bfChi' },
	[0x1D6BF] = { mathclass='alphabetic', adobename='u1D6BF', texname='bfPsi' },
	[0x1D6C0] = { mathclass='alphabetic', adobename='u1D6C0', texname='bfOmega' },
	[0x1D6C1] = { mathclass='normal', adobename='u1D6C1', texname='bfnabla' },
	[0x1D6C2] = { mathclass='alphabetic', adobename='u1D6C2', texname='bfalpha' },
	[0x1D6C3] = { mathclass='alphabetic', adobename='u1D6C3', texname='bfbeta' },
	[0x1D6C4] = { mathclass='alphabetic', adobename='u1D6C4', texname='bfgamma' },
	[0x1D6C5] = { mathclass='alphabetic', adobename='u1D6C5', texname='bfdelta' },
	[0x1D6C6] = { mathclass='alphabetic', adobename='u1D6C6', texname='bfvarepsilon' },
	[0x1D6C7] = { mathclass='alphabetic', adobename='u1D6C7', texname='bfzeta' },
	[0x1D6C8] = { mathclass='alphabetic', adobename='u1D6C8', texname='bfeta' },
	[0x1D6C9] = { mathclass='alphabetic', adobename='u1D6C9', texname='bftheta' },
	[0x1D6CA] = { mathclass='alphabetic', adobename='u1D6CA', texname='bfiota' },
	[0x1D6CB] = { mathclass='alphabetic', adobename='u1D6CB', texname='bfkappa' },
	[0x1D6CC] = { mathclass='alphabetic', adobename='u1D6CC', texname='bflambda' },
	[0x1D6CD] = { mathclass='alphabetic', adobename='u1D6CD', texname='bfmu' },
	[0x1D6CE] = { mathclass='alphabetic', adobename='u1D6CE', texname='bfnu' },
	[0x1D6CF] = { mathclass='alphabetic', adobename='u1D6CF', texname='bfxi' },
	[0x1D6D0] = { mathclass='alphabetic', adobename='u1D6D0', texname='bfomicron' },
	[0x1D6D1] = { mathclass='alphabetic', adobename='u1D6D1', texname='bfpi' },
	[0x1D6D2] = { mathclass='alphabetic', adobename='u1D6D2', texname='bfrho' },
	[0x1D6D3] = { mathclass='alphabetic', adobename='u1D6D3', texname='bfvarsigma' },
	[0x1D6D4] = { mathclass='alphabetic', adobename='u1D6D4', texname='bfsigma' },
	[0x1D6D5] = { mathclass='alphabetic', adobename='u1D6D5', texname='bftau' },
	[0x1D6D6] = { mathclass='alphabetic', adobename='u1D6D6', texname='bfupsilon' },
	[0x1D6D7] = { mathclass='alphabetic', adobename='u1D6D7', texname='bfvarphi' },
	[0x1D6D8] = { mathclass='alphabetic', adobename='u1D6D8', texname='bfchi' },
	[0x1D6D9] = { mathclass='alphabetic', adobename='u1D6D9', texname='bfpsi' },
	[0x1D6DA] = { mathclass='alphabetic', adobename='u1D6DA', texname='bfomega' },
	[0x1D6DB] = { mathclass='normal', adobename='u1D6DB', texname='bfpartial' },
	[0x1D6DC] = { mathclass='alphabetic', adobename='u1D6DC', texname='bfepsilon' },
	[0x1D6DD] = { mathclass='alphabetic', adobename='u1D6DD', texname='bfvartheta' },
	[0x1D6DE] = { mathclass='alphabetic', adobename='u1D6DE', texname='bfvarkappa' },
	[0x1D6DF] = { mathclass='alphabetic', adobename='u1D6DF', texname='bfphi' },
	[0x1D6E0] = { mathclass='alphabetic', adobename='u1D6E0', texname='bfvarrho' },
	[0x1D6E1] = { mathclass='alphabetic', adobename='u1D6E1', texname='bfvarpi' },
	[0x1D6E2] = { mathclass='alphabetic', adobename='u1D6E2', texname='itAlpha' },
	[0x1D6E3] = { mathclass='alphabetic', adobename='u1D6E3', texname='itBeta' },
	[0x1D6E4] = { mathclass='alphabetic', adobename='u1D6E4', texname='itGamma' },
	[0x1D6E5] = { mathclass='alphabetic', adobename='u1D6E5', texname='itDelta' },
	[0x1D6E6] = { mathclass='alphabetic', adobename='u1D6E6', texname='itEpsilon' },
	[0x1D6E7] = { mathclass='alphabetic', adobename='u1D6E7', texname='itZeta' },
	[0x1D6E8] = { mathclass='alphabetic', adobename='u1D6E8', texname='itEta' },
	[0x1D6E9] = { mathclass='alphabetic', adobename='u1D6E9', texname='itTheta' },
	[0x1D6EA] = { mathclass='alphabetic', adobename='u1D6EA', texname='itIota' },
	[0x1D6EB] = { mathclass='alphabetic', adobename='u1D6EB', texname='itKappa' },
	[0x1D6EC] = { mathclass='alphabetic', adobename='u1D6EC', texname='itLambda' },
	[0x1D6ED] = { mathclass='alphabetic', adobename='u1D6ED', texname='itMu' },
	[0x1D6EE] = { mathclass='alphabetic', adobename='u1D6EE', texname='itNu' },
	[0x1D6EF] = { mathclass='alphabetic', adobename='u1D6EF', texname='itXi' },
	[0x1D6F0] = { mathclass='alphabetic', adobename='u1D6F0', texname='itOmicron' },
	[0x1D6F1] = { mathclass='alphabetic', adobename='u1D6F1', texname='itPi' },
	[0x1D6F2] = { mathclass='alphabetic', adobename='u1D6F2', texname='itRho' },
	[0x1D6F3] = { mathclass='alphabetic', adobename='u1D6F3', texname='itvarTheta' },
	[0x1D6F4] = { mathclass='alphabetic', adobename='u1D6F4', texname='itSigma' },
	[0x1D6F5] = { mathclass='alphabetic', adobename='u1D6F5', texname='itTau' },
	[0x1D6F6] = { mathclass='alphabetic', adobename='u1D6F6', texname='itUpsilon' },
	[0x1D6F7] = { mathclass='alphabetic', adobename='u1D6F7', texname='itPhi' },
	[0x1D6F8] = { mathclass='alphabetic', adobename='u1D6F8', texname='itChi' },
	[0x1D6F9] = { mathclass='alphabetic', adobename='u1D6F9', texname='itPsi' },
	[0x1D6FA] = { mathclass='alphabetic', adobename='u1D6FA', texname='itOmega' },
	[0x1D6FB] = { mathclass='normal', adobename='u1D6FB', texname='itnabla' },
	[0x1D6FC] = { mathclass='alphabetic', adobename='u1D6FC', texname='italpha' },
	[0x1D6FD] = { mathclass='alphabetic', adobename='u1D6FD', texname='itbeta' },
	[0x1D6FE] = { mathclass='alphabetic', adobename='u1D6FE', texname='itgamma' },
	[0x1D6FF] = { mathclass='alphabetic', adobename='u1D6FF', texname='itdelta' },
	[0x1D700] = { mathclass='alphabetic', adobename='u1D700', texname='itvarepsilon' },
	[0x1D701] = { mathclass='alphabetic', adobename='u1D701', texname='itzeta' },
	[0x1D702] = { mathclass='alphabetic', adobename='u1D702', texname='iteta' },
	[0x1D703] = { mathclass='alphabetic', adobename='u1D703', texname='ittheta' },
	[0x1D704] = { mathclass='alphabetic', adobename='u1D704', texname='itiota' },
	[0x1D705] = { mathclass='alphabetic', adobename='u1D705', texname='itkappa' },
	[0x1D706] = { mathclass='alphabetic', adobename='u1D706', texname='itlambda' },
	[0x1D707] = { mathclass='alphabetic', adobename='u1D707', texname='itmu' },
	[0x1D708] = { mathclass='alphabetic', adobename='u1D708', texname='itnu' },
	[0x1D709] = { mathclass='alphabetic', adobename='u1D709', texname='itxi' },
	[0x1D70A] = { mathclass='alphabetic', adobename='u1D70A', texname='itomicron' },
	[0x1D70B] = { mathclass='alphabetic', adobename='u1D70B', texname='itpi' },
	[0x1D70C] = { mathclass='alphabetic', adobename='u1D70C', texname='itrho' },
	[0x1D70D] = { mathclass='alphabetic', adobename='u1D70D', texname='itvarsigma' },
	[0x1D70E] = { mathclass='alphabetic', adobename='u1D70E', texname='itsigma' },
	[0x1D70F] = { mathclass='alphabetic', adobename='u1D70F', texname='ittau' },
	[0x1D710] = { mathclass='alphabetic', adobename='u1D710', texname='itupsilon' },
	[0x1D711] = { mathclass='alphabetic', adobename='u1D711', texname='itphi' },
	[0x1D712] = { mathclass='alphabetic', adobename='u1D712', texname='itchi' },
	[0x1D713] = { mathclass='alphabetic', adobename='u1D713', texname='itpsi' },
	[0x1D714] = { mathclass='alphabetic', adobename='u1D714', texname='itomega' },
	[0x1D715] = { mathclass='normal', adobename='u1D715', texname='itpartial' },
	[0x1D716] = { mathclass='alphabetic', adobename='u1D716', texname='itepsilon' },
	[0x1D717] = { mathclass='alphabetic', adobename='u1D717', texname='itvartheta' },
	[0x1D718] = { mathclass='alphabetic', adobename='u1D718', texname='itvarkappa' },
	[0x1D719] = { mathclass='alphabetic', adobename='u1D719', texname='itvarphi' },
	[0x1D71A] = { mathclass='alphabetic', adobename='u1D71A', texname='itvarrho' },
	[0x1D71B] = { mathclass='alphabetic', adobename='u1D71B', texname='itvarpi' },
	[0x1D71C] = { mathclass='alphabetic', adobename='u1D71C', texname='bfitAlpha' },
	[0x1D71D] = { mathclass='alphabetic', adobename='u1D71D', texname='bfitBeta' },
	[0x1D71E] = { mathclass='alphabetic', adobename='u1D71E', texname='bfitGamma' },
	[0x1D71F] = { mathclass='alphabetic', adobename='u1D71F', texname='bfitDelta' },
	[0x1D720] = { mathclass='alphabetic', adobename='u1D720', texname='bfitEpsilon' },
	[0x1D721] = { mathclass='alphabetic', adobename='u1D721', texname='bfitZeta' },
	[0x1D722] = { mathclass='alphabetic', adobename='u1D722', texname='bfitEta' },
	[0x1D723] = { mathclass='alphabetic', adobename='u1D723', texname='bfitTheta' },
	[0x1D724] = { mathclass='alphabetic', adobename='u1D724', texname='bfitIota' },
	[0x1D725] = { mathclass='alphabetic', adobename='u1D725', texname='bfitKappa' },
	[0x1D726] = { mathclass='alphabetic', adobename='u1D726', texname='bfitLambda' },
	[0x1D727] = { mathclass='alphabetic', adobename='u1D727', texname='bfitMu' },
	[0x1D728] = { mathclass='alphabetic', adobename='u1D728', texname='bfitNu' },
	[0x1D729] = { mathclass='alphabetic', adobename='u1D729', texname='bfitXi' },
	[0x1D72A] = { mathclass='alphabetic', adobename='u1D72A', texname='bfitOmicron' },
	[0x1D72B] = { mathclass='alphabetic', adobename='u1D72B', texname='bfitPi' },
	[0x1D72C] = { mathclass='alphabetic', adobename='u1D72C', texname='bfitRho' },
	[0x1D72D] = { mathclass='alphabetic', adobename='u1D72D', texname='bfitvarTheta' },
	[0x1D72E] = { mathclass='alphabetic', adobename='u1D72E', texname='bfitSigma' },
	[0x1D72F] = { mathclass='alphabetic', adobename='u1D72F', texname='bfitTau' },
	[0x1D730] = { mathclass='alphabetic', adobename='u1D730', texname='bfitUpsilon' },
	[0x1D731] = { mathclass='alphabetic', adobename='u1D731', texname='bfitPhi' },
	[0x1D732] = { mathclass='alphabetic', adobename='u1D732', texname='bfitChi' },
	[0x1D733] = { mathclass='alphabetic', adobename='u1D733', texname='bfitPsi' },
	[0x1D734] = { mathclass='alphabetic', adobename='u1D734', texname='bfitOmega' },
	[0x1D735] = { mathclass='normal', adobename='u1D735', texname='bfitnabla' },
	[0x1D736] = { mathclass='alphabetic', adobename='u1D736', texname='bfitalpha' },
	[0x1D737] = { mathclass='alphabetic', adobename='u1D737', texname='bfitbeta' },
	[0x1D738] = { mathclass='alphabetic', adobename='u1D738', texname='bfitgamma' },
	[0x1D739] = { mathclass='alphabetic', adobename='u1D739', texname='bfitdelta' },
	[0x1D73A] = { mathclass='alphabetic', adobename='u1D73A', texname='bfitvarepsilon' },
	[0x1D73B] = { mathclass='alphabetic', adobename='u1D73B', texname='bfitzeta' },
	[0x1D73C] = { mathclass='alphabetic', adobename='u1D73C', texname='bfiteta' },
	[0x1D73D] = { mathclass='alphabetic', adobename='u1D73D', texname='bfittheta' },
	[0x1D73E] = { mathclass='alphabetic', adobename='u1D73E', texname='bfitiota' },
	[0x1D73F] = { mathclass='alphabetic', adobename='u1D73F', texname='bfitkappa' },
	[0x1D740] = { mathclass='alphabetic', adobename='u1D740', texname='bfitlambda' },
	[0x1D741] = { mathclass='alphabetic', adobename='u1D741', texname='bfitmu' },
	[0x1D742] = { mathclass='alphabetic', adobename='u1D742', texname='bfitnu' },
	[0x1D743] = { mathclass='alphabetic', adobename='u1D743', texname='bfitxi' },
	[0x1D744] = { mathclass='alphabetic', adobename='u1D744', texname='bfitomicron' },
	[0x1D745] = { mathclass='alphabetic', adobename='u1D745', texname='bfitpi' },
	[0x1D746] = { mathclass='alphabetic', adobename='u1D746', texname='bfitrho' },
	[0x1D747] = { mathclass='alphabetic', adobename='u1D747', texname='bfitvarsigma' },
	[0x1D748] = { mathclass='alphabetic', adobename='u1D748', texname='bfitsigma' },
	[0x1D749] = { mathclass='alphabetic', adobename='u1D749', texname='bfittau' },
	[0x1D74A] = { mathclass='alphabetic', adobename='u1D74A', texname='bfitupsilon' },
	[0x1D74B] = { mathclass='alphabetic', adobename='u1D74B', texname='bfitphi' },
	[0x1D74C] = { mathclass='alphabetic', adobename='u1D74C', texname='bfitchi' },
	[0x1D74D] = { mathclass='alphabetic', adobename='u1D74D', texname='bfitpsi' },
	[0x1D74E] = { mathclass='alphabetic', adobename='u1D74E', texname='bfitomega' },
	[0x1D74F] = { mathclass='normal', adobename='u1D74F', texname='bfitpartial' },
	[0x1D750] = { mathclass='alphabetic', adobename='u1D750', texname='bfitepsilon' },
	[0x1D751] = { mathclass='alphabetic', adobename='u1D751', texname='bfitvartheta' },
	[0x1D752] = { mathclass='alphabetic', adobename='u1D752', texname='bfitvarkappa' },
	[0x1D753] = { mathclass='alphabetic', adobename='u1D753', texname='bfitvarphi' },
	[0x1D754] = { mathclass='alphabetic', adobename='u1D754', texname='bfitvarrho' },
	[0x1D755] = { mathclass='alphabetic', adobename='u1D755', texname='bfitvarpi' },
	[0x1D756] = { mathclass='alphabetic', adobename='u1D756', texname='bfsansAlpha' },
	[0x1D757] = { mathclass='alphabetic', adobename='u1D757', texname='bfsansBeta' },
	[0x1D758] = { mathclass='alphabetic', adobename='u1D758', texname='bfsansGamma' },
	[0x1D759] = { mathclass='alphabetic', adobename='u1D759', texname='bfsansDelta' },
	[0x1D75A] = { mathclass='alphabetic', adobename='u1D75A', texname='bfsansEpsilon' },
	[0x1D75B] = { mathclass='alphabetic', adobename='u1D75B', texname='bfsansZeta' },
	[0x1D75C] = { mathclass='alphabetic', adobename='u1D75C', texname='bfsansEta' },
	[0x1D75D] = { mathclass='alphabetic', adobename='u1D75D', texname='bfsansTheta' },
	[0x1D75E] = { mathclass='alphabetic', adobename='u1D75E', texname='bfsansIota' },
	[0x1D75F] = { mathclass='alphabetic', adobename='u1D75F', texname='bfsansKappa' },
	[0x1D760] = { mathclass='alphabetic', adobename='u1D760', texname='bfsansLambda' },
	[0x1D761] = { mathclass='alphabetic', adobename='u1D761', texname='bfsansMu' },
	[0x1D762] = { mathclass='alphabetic', adobename='u1D762', texname='bfsansNu' },
	[0x1D763] = { mathclass='alphabetic', adobename='u1D763', texname='bfsansXi' },
	[0x1D764] = { mathclass='alphabetic', adobename='u1D764', texname='bfsansOmicron' },
	[0x1D765] = { mathclass='alphabetic', adobename='u1D765', texname='bfsansPi' },
	[0x1D766] = { mathclass='alphabetic', adobename='u1D766', texname='bfsansRho' },
	[0x1D767] = { mathclass='alphabetic', adobename='u1D767', texname='bfsansvarTheta' },
	[0x1D768] = { mathclass='alphabetic', adobename='u1D768', texname='bfsansSigma' },
	[0x1D769] = { mathclass='alphabetic', adobename='u1D769', texname='bfsansTau' },
	[0x1D76A] = { mathclass='alphabetic', adobename='u1D76A', texname='bfsansUpsilon' },
	[0x1D76B] = { mathclass='alphabetic', adobename='u1D76B', texname='bfsansPhi' },
	[0x1D76C] = { mathclass='alphabetic', adobename='u1D76C', texname='bfsansChi' },
	[0x1D76D] = { mathclass='alphabetic', adobename='u1D76D', texname='bfsansPsi' },
	[0x1D76E] = { mathclass='alphabetic', adobename='u1D76E', texname='bfsansOmega' },
	[0x1D76F] = { mathclass='normal', adobename='u1D76F', texname='bfsansnabla' },
	[0x1D770] = { mathclass='alphabetic', adobename='u1D770', texname='bfsansalpha' },
	[0x1D771] = { mathclass='alphabetic', adobename='u1D771', texname='bfsansbeta' },
	[0x1D772] = { mathclass='alphabetic', adobename='u1D772', texname='bfsansgamma' },
	[0x1D773] = { mathclass='alphabetic', adobename='u1D773', texname='bfsansdelta' },
	[0x1D774] = { mathclass='alphabetic', adobename='u1D774', texname='bfsansvarepsilon' },
	[0x1D775] = { mathclass='alphabetic', adobename='u1D775', texname='bfsanszeta' },
	[0x1D776] = { mathclass='alphabetic', adobename='u1D776', texname='bfsanseta' },
	[0x1D777] = { mathclass='alphabetic', adobename='u1D777', texname='bfsanstheta' },
	[0x1D778] = { mathclass='alphabetic', adobename='u1D778', texname='bfsansiota' },
	[0x1D779] = { mathclass='alphabetic', adobename='u1D779', texname='bfsanskappa' },
	[0x1D77A] = { mathclass='alphabetic', adobename='u1D77A', texname='bfsanslambda' },
	[0x1D77B] = { mathclass='alphabetic', adobename='u1D77B', texname='bfsansmu' },
	[0x1D77C] = { mathclass='alphabetic', adobename='u1D77C', texname='bfsansnu' },
	[0x1D77D] = { mathclass='alphabetic', adobename='u1D77D', texname='bfsansxi' },
	[0x1D77E] = { mathclass='alphabetic', adobename='u1D77E', texname='bfsansomicron' },
	[0x1D77F] = { mathclass='alphabetic', adobename='u1D77F', texname='bfsanspi' },
	[0x1D780] = { mathclass='alphabetic', adobename='u1D780', texname='bfsansrho' },
	[0x1D781] = { mathclass='alphabetic', adobename='u1D781', texname='bfsansvarsigma' },
	[0x1D782] = { mathclass='alphabetic', adobename='u1D782', texname='bfsanssigma' },
	[0x1D783] = { mathclass='alphabetic', adobename='u1D783', texname='bfsanstau' },
	[0x1D784] = { mathclass='alphabetic', adobename='u1D784', texname='bfsansupsilon' },
	[0x1D785] = { mathclass='alphabetic', adobename='u1D785', texname='bfsansphi' },
	[0x1D786] = { mathclass='alphabetic', adobename='u1D786', texname='bfsanschi' },
	[0x1D787] = { mathclass='alphabetic', adobename='u1D787', texname='bfsanspsi' },
	[0x1D788] = { mathclass='alphabetic', adobename='u1D788', texname='bfsansomega' },
	[0x1D789] = { mathclass='normal', adobename='u1D789', texname='bfsanspartial' },
	[0x1D78A] = { mathclass='alphabetic', adobename='u1D78A', texname='bfsansepsilon' },
	[0x1D78B] = { mathclass='alphabetic', adobename='u1D78B', texname='bfsansvartheta' },
	[0x1D78C] = { mathclass='alphabetic', adobename='u1D78C', texname='bfsansvarkappa' },
	[0x1D78D] = { mathclass='alphabetic', adobename='u1D78D', texname='bfsansvarphi' },
	[0x1D78E] = { mathclass='alphabetic', adobename='u1D78E', texname='bfsansvarrho' },
	[0x1D78F] = { mathclass='alphabetic', adobename='u1D78F', texname='bfsansvarpi' },
	[0x1D790] = { mathclass='alphabetic', adobename='u1D790', texname='bfitsansAlpha' },
	[0x1D791] = { mathclass='alphabetic', adobename='u1D791', texname='bfitsansBeta' },
	[0x1D792] = { mathclass='alphabetic', adobename='u1D792', texname='bfitsansGamma' },
	[0x1D793] = { mathclass='alphabetic', adobename='u1D793', texname='bfitsansDelta' },
	[0x1D794] = { mathclass='alphabetic', adobename='u1D794', texname='bfitsansEpsilon' },
	[0x1D795] = { mathclass='alphabetic', adobename='u1D795', texname='bfitsansZeta' },
	[0x1D796] = { mathclass='alphabetic', adobename='u1D796', texname='bfitsansEta' },
	[0x1D797] = { mathclass='alphabetic', adobename='u1D797', texname='bfitsansTheta' },
	[0x1D798] = { mathclass='alphabetic', adobename='u1D798', texname='bfitsansIota' },
	[0x1D799] = { mathclass='alphabetic', adobename='u1D799', texname='bfitsansKappa' },
	[0x1D79A] = { mathclass='alphabetic', adobename='u1D79A', texname='bfitsansLambda' },
	[0x1D79B] = { mathclass='alphabetic', adobename='u1D79B', texname='bfitsansMu' },
	[0x1D79C] = { mathclass='alphabetic', adobename='u1D79C', texname='bfitsansNu' },
	[0x1D79D] = { mathclass='alphabetic', adobename='u1D79D', texname='bfitsansXi' },
	[0x1D79E] = { mathclass='alphabetic', adobename='u1D79E', texname='bfitsansOmicron' },
	[0x1D79F] = { mathclass='alphabetic', adobename='u1D79F', texname='bfitsansPi' },
	[0x1D7A0] = { mathclass='alphabetic', adobename='u1D7A0', texname='bfitsansRho' },
	[0x1D7A1] = { mathclass='alphabetic', adobename='u1D7A1', texname='bfitsansvarTheta' },
	[0x1D7A2] = { mathclass='alphabetic', adobename='u1D7A2', texname='bfitsansSigma' },
	[0x1D7A3] = { mathclass='alphabetic', adobename='u1D7A3', texname='bfitsansTau' },
	[0x1D7A4] = { mathclass='alphabetic', adobename='u1D7A4', texname='bfitsansUpsilon' },
	[0x1D7A5] = { mathclass='alphabetic', adobename='u1D7A5', texname='bfitsansPhi' },
	[0x1D7A6] = { mathclass='alphabetic', adobename='u1D7A6', texname='bfitsansChi' },
	[0x1D7A7] = { mathclass='alphabetic', adobename='u1D7A7', texname='bfitsansPsi' },
	[0x1D7A8] = { mathclass='alphabetic', adobename='u1D7A8', texname='bfitsansOmega' },
	[0x1D7A9] = { mathclass='normal', adobename='u1D7A9', texname='bfitsansnabla' },
	[0x1D7AA] = { mathclass='alphabetic', adobename='u1D7AA', texname='bfitsansalpha' },
	[0x1D7AB] = { mathclass='alphabetic', adobename='u1D7AB', texname='bfitsansbeta' },
	[0x1D7AC] = { mathclass='alphabetic', adobename='u1D7AC', texname='bfitsansgamma' },
	[0x1D7AD] = { mathclass='alphabetic', adobename='u1D7AD', texname='bfitsansdelta' },
	[0x1D7AE] = { mathclass='alphabetic', adobename='u1D7AE', texname='bfitsansvarepsilon' },
	[0x1D7AF] = { mathclass='alphabetic', adobename='u1D7AF', texname='bfitsanszeta' },
	[0x1D7B0] = { mathclass='alphabetic', adobename='u1D7B0', texname='bfitsanseta' },
	[0x1D7B1] = { mathclass='alphabetic', adobename='u1D7B1', texname='bfitsanstheta' },
	[0x1D7B2] = { mathclass='alphabetic', adobename='u1D7B2', texname='bfitsansiota' },
	[0x1D7B3] = { mathclass='alphabetic', adobename='u1D7B3', texname='bfitsanskappa' },
	[0x1D7B4] = { mathclass='alphabetic', adobename='u1D7B4', texname='bfitsanslambda' },
	[0x1D7B5] = { mathclass='alphabetic', adobename='u1D7B5', texname='bfitsansmu' },
	[0x1D7B6] = { mathclass='alphabetic', adobename='u1D7B6', texname='bfitsansnu' },
	[0x1D7B7] = { mathclass='alphabetic', adobename='u1D7B7', texname='bfitsansxi' },
	[0x1D7B8] = { mathclass='alphabetic', adobename='u1D7B8', texname='bfitsansomicron' },
	[0x1D7B9] = { mathclass='alphabetic', adobename='u1D7B9', texname='bfitsanspi' },
	[0x1D7BA] = { mathclass='alphabetic', adobename='u1D7BA', texname='bfitsansrho' },
	[0x1D7BB] = { mathclass='alphabetic', adobename='u1D7BB', texname='bfitsansvarsigma' },
	[0x1D7BC] = { mathclass='alphabetic', adobename='u1D7BC', texname='bfitsanssigma' },
	[0x1D7BD] = { mathclass='alphabetic', adobename='u1D7BD', texname='bfitsanstau' },
	[0x1D7BE] = { mathclass='alphabetic', adobename='u1D7BE', texname='bfitsansupsilon' },
	[0x1D7BF] = { mathclass='alphabetic', adobename='u1D7BF', texname='bfitsansphi' },
	[0x1D7C0] = { mathclass='alphabetic', adobename='u1D7C0', texname='bfitsanschi' },
	[0x1D7C1] = { mathclass='alphabetic', adobename='u1D7C1', texname='bfitsanspsi' },
	[0x1D7C2] = { mathclass='alphabetic', adobename='u1D7C2', texname='bfitsansomega' },
	[0x1D7C3] = { mathclass='normal', adobename='u1D7C3', texname='bfitsanspartial' },
	[0x1D7C4] = { mathclass='alphabetic', adobename='u1D7C4', texname='bfitsansepsilon' },
	[0x1D7C5] = { mathclass='alphabetic', adobename='u1D7C5', texname='bfitsansvartheta' },
	[0x1D7C6] = { mathclass='alphabetic', adobename='u1D7C6', texname='bfitsansvarkappa' },
	[0x1D7C7] = { mathclass='alphabetic', adobename='u1D7C7', texname='bfitsansvarphi' },
	[0x1D7C8] = { mathclass='alphabetic', adobename='u1D7C8', texname='bfitsansvarrho' },
	[0x1D7C9] = { mathclass='alphabetic', adobename='u1D7C9', texname='bfitsansvarpi' },
	[0x1D7CA] = { mathclass='alphabetic', adobename='u1D7CA', texname='bfDigamma' },
	[0x1D7CB] = { mathclass='alphabetic', adobename='u1D7CB', texname='bfdigamma' },
	[0x1D7CC] = { mathclass='unknown', adobename='u1D7CC' },
	[0x1D7CD] = { mathclass='unknown', adobename='u1D7CD' },
	[0x1D7CE] = { mathclass='normal', adobename='u1D7CE', texname='bfzero' },
	[0x1D7CF] = { mathclass='normal', adobename='u1D7CF', texname='bfone' },
	[0x1D7D0] = { mathclass='normal', adobename='u1D7D0', texname='bftwo' },
	[0x1D7D1] = { mathclass='normal', adobename='u1D7D1', texname='bfthree' },
	[0x1D7D2] = { mathclass='normal', adobename='u1D7D2', texname='bffour' },
	[0x1D7D3] = { mathclass='normal', adobename='u1D7D3', texname='bffive' },
	[0x1D7D4] = { mathclass='normal', adobename='u1D7D4', texname='bfsix' },
	[0x1D7D5] = { mathclass='normal', adobename='u1D7D5', texname='bfseven' },
	[0x1D7D6] = { mathclass='normal', adobename='u1D7D6', texname='bfeight' },
	[0x1D7D7] = { mathclass='normal', adobename='u1D7D7', texname='bfnine' },
	[0x1D7D8] = { mathclass='normal', adobename='u1D7D8', texname='Bbbzero' },
	[0x1D7D9] = { mathclass='normal', adobename='u1D7D9', texname='Bbbone' },
	[0x1D7DA] = { mathclass='normal', adobename='u1D7DA', texname='Bbbtwo' },
	[0x1D7DB] = { mathclass='normal', adobename='u1D7DB', texname='Bbbthree' },
	[0x1D7DC] = { mathclass='normal', adobename='u1D7DC', texname='Bbbfour' },
	[0x1D7DD] = { mathclass='normal', adobename='u1D7DD', texname='Bbbfive' },
	[0x1D7DE] = { mathclass='normal', adobename='u1D7DE', texname='Bbbsix' },
	[0x1D7DF] = { mathclass='normal', adobename='u1D7DF', texname='Bbbseven' },
	[0x1D7E0] = { mathclass='normal', adobename='u1D7E0', texname='Bbbeight' },
	[0x1D7E1] = { mathclass='normal', adobename='u1D7E1', texname='Bbbnine' },
	[0x1D7E2] = { mathclass='normal', adobename='u1D7E2', texname='sanszero' },
	[0x1D7E3] = { mathclass='normal', adobename='u1D7E3', texname='sansone' },
	[0x1D7E4] = { mathclass='normal', adobename='u1D7E4', texname='sanstwo' },
	[0x1D7E5] = { mathclass='normal', adobename='u1D7E5', texname='sansthree' },
	[0x1D7E6] = { mathclass='normal', adobename='u1D7E6', texname='sansfour' },
	[0x1D7E7] = { mathclass='normal', adobename='u1D7E7', texname='sansfive' },
	[0x1D7E8] = { mathclass='normal', adobename='u1D7E8', texname='sanssix' },
	[0x1D7E9] = { mathclass='normal', adobename='u1D7E9', texname='sansseven' },
	[0x1D7EA] = { mathclass='normal', adobename='u1D7EA', texname='sanseight' },
	[0x1D7EB] = { mathclass='normal', adobename='u1D7EB', texname='sansnine' },
	[0x1D7EC] = { mathclass='normal', adobename='u1D7EC', texname='bfsanszero' },
	[0x1D7ED] = { mathclass='normal', adobename='u1D7ED', texname='bfsansone' },
	[0x1D7EE] = { mathclass='normal', adobename='u1D7EE', texname='bfsanstwo' },
	[0x1D7EF] = { mathclass='normal', adobename='u1D7EF', texname='bfsansthree' },
	[0x1D7F0] = { mathclass='normal', adobename='u1D7F0', texname='bfsansfour' },
	[0x1D7F1] = { mathclass='normal', adobename='u1D7F1', texname='bfsansfive' },
	[0x1D7F2] = { mathclass='normal', adobename='u1D7F2', texname='bfsanssix' },
	[0x1D7F3] = { mathclass='normal', adobename='u1D7F3', texname='bfsansseven' },
	[0x1D7F4] = { mathclass='normal', adobename='u1D7F4', texname='bfsanseight' },
	[0x1D7F5] = { mathclass='normal', adobename='u1D7F5', texname='bfsansnine' },
	[0x1D7F6] = { mathclass='normal', adobename='u1D7F6', texname='ttzero' },
	[0x1D7F7] = { mathclass='normal', adobename='u1D7F7', texname='ttone' },
	[0x1D7F8] = { mathclass='normal', adobename='u1D7F8', texname='tttwo' },
	[0x1D7F9] = { mathclass='normal', adobename='u1D7F9', texname='ttthree' },
	[0x1D7FA] = { mathclass='normal', adobename='u1D7FA', texname='ttfour' },
	[0x1D7FB] = { mathclass='normal', adobename='u1D7FB', texname='ttfive' },
	[0x1D7FC] = { mathclass='normal', adobename='u1D7FC', texname='ttsix' },
	[0x1D7FD] = { mathclass='normal', adobename='u1D7FD', texname='ttseven' },
	[0x1D7FE] = { mathclass='normal', adobename='u1D7FE', texname='tteight' },
	[0x1D7FF] = { mathclass='normal', adobename='u1D7FF', texname='ttnine' },
	[0x0FB00] = { mathclass='alphabetic', adobename='ff' },
	[0x0FB01] = { mathclass='alphabetic', adobename='fi' },
	[0x0FB02] = { mathclass='alphabetic', adobename='fl' },
	[0x0FB03] = { mathclass='alphabetic', adobename='ffi' },
	[0x0FB04] = { mathclass='alphabetic', adobename='ffl' },
	[0x0FE00] = { mathclass='unknown', adobename='uniFE00' },
	[0x0FE35] = { mathclass='unknown', adobename='uni23DC', texname='overparen' },
	[0x0FE36] = { mathclass='unknown', adobename='uni23DD', texname='underparen' },
	[0x0FE37] = { mathclass='unknown', adobename='uni23DE', texname='overbrace' },
	[0x0FE38] = { mathclass='unknown', adobename='uni23DF', texname='underbrace' },
	[0x0FFFD] = { mathclass='unknown', adobename='uniFFFD', texname='unknown' },
}
