#!/usr/bin/env python

#****************************************************************************
# helpview.py, provides a window for viewing an html help file
#
# Copyright (C) 2005, Douglas W. Bell
#
# This is free software; you can redistribute it and/or modify it under the
# terms of the GNU General Public License, Version 2.  This program is
# distributed in the hope that it will be useful, but WITTHOUT ANY WARRANTY.
#*****************************************************************************

import sys
from qt import Qt, PYSIGNAL, SIGNAL, SLOT, QAction, QIconSet, QMainWindow, \
               QMimeSourceFactory, QPixmap, QPopupMenu, QTextBrowser, QToolBar
               

class HelpView(QMainWindow):
    """Main window for viewing an html help file"""
    back_xpm = [
        "16 14 2 1",
        "       c None",
        "+      c #0000A0",
        "                ",
        "     ++         ",
        "    ++          ",
        "   ++           ",
        "  ++            ",
        " ++             ",
        "++++++++++++++  ",
        "++++++++++++++  ",
        " ++             ",
        "  ++            ",
        "   ++           ",
        "    ++          ",
        "     ++         ",
        "                "]
    forward_xpm = [
        "16 14 2 1",
        "       c None",
        "+      c #0000A0",
        "                ",
        "         ++     ",
        "          ++    ",
        "           ++   ",
        "            ++  ",
        "             ++ ",
        "  ++++++++++++++",
        "  ++++++++++++++",
        "             ++ ",
        "            ++  ",
        "           ++   ",
        "          ++    ",
        "         ++     ",
        "                "]
    home_xpm = [
        "16 14 2 1",
        "       c None",
        "+      c #0000A0",
        "       ++       ",
        "      ++++      ",
        "     ++  ++     ",
        "    ++    ++    ",
        "   ++      ++   ",
        "  ++        ++  ",
        " ++          ++ ",
        " ++          ++ ",
        " ++          ++ ",
        " ++          ++ ",
        " ++          ++ ",
        " ++          ++ ",
        " ++++++++++++++ ",
        " ++++++++++++++ "]

    def __init__(self, text, caption, parent=None, name=None):
        """Helpview initialize with text"""
        QMainWindow.__init__(self, parent, name)
        self.textView = HelpViewer(self)
        self.setCentralWidget(self.textView)
        self.source = QMimeSourceFactory()
        self.source.setText('help', text)
        self.textView.setMimeSourceFactory(self.source)
        self.textView.setSource('help')
        self.resize(400, 400)
        if sys.platform == 'win32':
            caption += '  (PyQt)'
        self.setCaption(caption)
        tools = QToolBar(self)
        self.menu = QPopupMenu(self.textView)
        backAct = QAction('Back', QIconSet(QPixmap(HelpView.back_xpm)), \
                          '&Back', 0, self)
        backAct.addTo(tools)
        backAct.addTo(self.menu)
        backAct.setEnabled(0)
        self.connect(backAct, SIGNAL('activated()'), \
                     self.textView, SLOT('backward()'))
        self.connect(self.textView, SIGNAL('backwardAvailable(bool)'), \
                     backAct, SLOT('setEnabled(bool)'))

        forwardAct = QAction('Forward', \
                             QIconSet(QPixmap(HelpView.forward_xpm)), \
                             '&Forward', 0, self)
        forwardAct.addTo(tools)
        forwardAct.addTo(self.menu)
        forwardAct.setEnabled(0)
        self.connect(forwardAct, SIGNAL('activated()'), \
                     self.textView, SLOT('forward()'))
        self.connect(self.textView, SIGNAL('forwardAvailable(bool)'), \
                     forwardAct, SLOT('setEnabled(bool)'))

        homeAct = QAction('Home', QIconSet(QPixmap(HelpView.home_xpm)), \
                          '&Home', 0, self)
        homeAct.addTo(tools)
        homeAct.addTo(self.menu)
        self.connect(homeAct, SIGNAL('activated()'), \
                     self.textView, SLOT('home()'))

class HelpViewer(QTextBrowser):
    """Shows an html help file"""
    def __init__(self, parent=None, name=None):
        QTextBrowser.__init__(self, parent, name)

    def viewportMouseReleaseEvent(self, event):
        """Init popup menu on right click"""""
        if event.button() == Qt.RightButton:
            self.parentWidget().menu.popup(self.mapToGlobal(event.pos()))
        QTextBrowser.viewportMouseReleaseEvent(self, event)
