/*
    Copyright (c) 2019, Lukas Holecek <hluk@email.cz>

    This file is part of CopyQ.

    CopyQ is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    CopyQ is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with CopyQ.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef MACCLIPBOARD_H
#define MACCLIPBOARD_H

#include "platform/dummy/dummyclipboard.h"

class MacClipboard final : public DummyClipboard {
public:
    void startMonitoring(const QStringList &) override;

    void setData(ClipboardMode mode, const QVariantMap &dataMap) override;

    QByteArray clipboardOwner() override;

private:
    void clipboardTimeout();

    long int m_prevChangeCount = 0;
};

#endif // MACCLIPBOARD_H
