---

license: Licensed to the Apache Software Foundation (ASF) under one or more contributor license agreements. See the NOTICE file distributed with this work for additional information regarding copyright ownership. The ASF licenses this file to you under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with the License. You may obtain a copy of the License at

           http://www.apache.org/licenses/LICENSE-2.0
    
         Unless required by applicable law or agreed to in writing,
         software distributed under the License is distributed on an
         "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
         KIND, either express or implied.  See the License for the
         specific language governing permissions and limitations
    

   under the License.
---

# Руководство по конфиденциальности

Мобильные конфиденциальности является важным вопросом, который каждый разработчик приложения должен заниматься. Ваши пользователи ожидают, что их частной информации, будут собраны и обработаны надлежащим образом ваше приложение. Кроме того есть все большее число юрисдикций, которые сейчас имеют юридические требования в отношении конфиденциальности мобильных.

Это руководство о конфиденциальности мобильных приложений следует рассматривать *грунтовка* некоторые наиболее значительные проблемы. Он излагает некоторые общепринятого наилучшей практики и предоставляет ссылки на другие более подробные руководства и ссылки.

*   **Политика конфиденциальности**: вы app должен включать политика конфиденциальности, которая рассматривает такие темы, как какая информация Ваше приложение собирает от или о ваших пользователей, как используется эта информация, с которым он разделяет и как пользователи могут сделать выбор связанных с конфиденциальности в рамках приложения. Для облегчения понимания, вы должны использовать простой язык и избегают технического жаргона. Вы должны сделать вашу политику конфиденциальности для пользователей для рассмотрения до загрузки, такие как в описании приложения в marketplace приложение. Кроме того вы должны сделать вашу политику конфиденциальности в рамках самого приложения. Ограниченный размер дисплеев мобильных устройств создает проблемы для отображения политик конфиденциальности для пользователей. Рассмотреть вопрос о разработке *краткой формы* политики, которая включает в себя наиболее важную информацию, а затем предоставить ссылку на политику «длинная форма» для тех, кто заинтересован в более подробной информации. Некоторые группы пытаются разработать стандарты на основе значок для общения конфиденциальности, которые вы можете хотеть рассматривать после того, как эти стандарты Зрелые.

*   **Сбор конфиденциальной информации**: приложения сбора конфиденциальной личной информации поднимает важные конфиденциальности. Примеры конфиденциальной личной информации финансовой информации, здравоохранения информацию и информацию от или о детях. Он также включает информацию, полученную от некоторых датчиков и баз данных, как правило, найти на мобильных устройствах и таблетки, как геолокация информация, контакты/телефонной книги, микрофон/камеры и хранимых снимков/видеоклипов. Найти на следующих страницах документации для получения дополнительной информации: [камеры][1], [захват][2], [Контакты][3]и [геолокации][4]. Как правило следует получить разрешения пользователя прежде чем собирать конфиденциальную информацию и, если это возможно, предоставляет механизм управления, который позволяет пользователю легко изменить разрешения. App операционных систем может помочь в некоторых случаях, представляя диалоговые окна just-in-time, которые просят за разрешение пользователя перед сбором. В этих случаях не забудьте воспользоваться любой возможностью для настройки текста окна диалогового окна для уточнения, как приложение использует и, если применимо, разделяет такую информацию.

*   **Избегая пользователя сюрприз**: Если ваше приложение собирает или использует информацию таким образом, что может быть удивительным для пользователей с учетом основная цель вашего приложения (например, музыкальный проигрыватель, обращающийся к сохраненных изображений), вы должны принять аналогичные меры с сбора конфиденциальной личной информации. То есть настоятельно рекомендуется использование just-in-time диалоговых окон для информирования пользователя о коллекции или использовать эту информацию и, при необходимости, обеспечивать соответствующий контроль конфиденциальности.

*   **Сбор данных третьей стороной или обмена**: Если вы app собирает информацию, которая предоставляется другой компании--как социальный сетевой платформы или рекламной сети (например, если ваше приложение отображает рекламы)--вы должны сообщить пользователям этой коллекции и обмена. Как минимум, ваша политика конфиденциальности следует описать сбора информации и обмена и, если это уместно, предлагать пользователям возможность управления или отказаться от такой коллекции или обмена.

*   **Ограничение коллекции и безопасность**: пользователи поручить ваше приложение с их информацией и они ожидают, что вы будете принимать соответствующие предосторожности, чтобы защитить его. Один из лучших способов избежать компромиссов в безопасности личной информации не является в первую очередь собирать информацию, если ваше приложение имеет конкретных и законных оснований для коллекции. Для информации, должны быть собраны убедитесь, что элементы управления надлежащих мер безопасности для защиты этой информации, ли оно хранится на устройстве или на фоновые серверы. Следует также разработать политику хранения соответствующих данных, которая осуществляется в пределах приложения и на фоновые серверы.

 [1]: cordova_camera_camera.md.html
 [2]: cordova_media_capture_capture.md.html
 [3]: cordova_contacts_contacts.md.html
 [4]: cordova_geolocation_geolocation.md.html

Ниже приведены некоторые дополнительные полезные мобильные конфиденциальности руководства для разработчиков:

*   Генеральный прокурор Калифорнии, [конфиденциальности на ходу: рекомендации для мобильных экосистемы][5]

*   Центр демократии и технологии, будущее конфиденциальности форума, [наилучшей практики для мобильных приложений разработчиков][6]

*   CTIA-беспроводной ассоциации, [передовой практики и руководящие принципы для местоположение на основе услуг][7]

*   Федеральная торговая комиссия, [мобильных конфиденциальности информации: укрепление доверия путем прозрачности][8]

*   Будущее конфиденциальности форума, [приложения конфиденциальности][9] веб-сайта

 [5]: http://oag.ca.gov/sites/all/files/pdfs/privacy/privacy_on_the_go.pdf
 [6]: http://www.futureofprivacy.org/wp-content/uploads/Best-Practices-for-Mobile-App-Developers_Final.pdf
 [7]: http://www.ctia.org/business_resources/wic/index.cfm/AID/11300
 [8]: http://www.ftc.gov/os/2013/02/130201mobileprivacyreport.pdf
 [9]: http://www.applicationprivacy.org