---

license: Licensed to the Apache Software Foundation (ASF) under one or more contributor license agreements. See the NOTICE file distributed with this work for additional information regarding copyright ownership. The ASF licenses this file to you under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with the License. You may obtain a copy of the License at

           http://www.apache.org/licenses/LICENSE-2.0
    
         Unless required by applicable law or agreed to in writing,
         software distributed under the License is distributed on an
         "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
         KIND, either express or implied.  See the License for the
         specific language governing permissions and limitations
         under the License.
    

---

# Интерфейс командной строки

Это руководство показывает, как создавать приложения и развернуть их в различных родной мобильных платформ с использованием `cordova` интерфейс командной строки (CLI). Этот инструмент позволяет создавать новые проекты, строить их на разных платформах и запускать их в эмуляторе. CLI можно также использовать для инициализации кода проекта, после чего вы можете использовать различные платформы SDK для их дальнейшего развития.

## Необходимые условия

Перед запуском любого средства командной строки, необходимо установить пакет SDK для каждой платформы, которую вы хотите цели. (См. платформа руководства для получения более подробной информации.)

Чтобы добавить поддержку или перестроить проект для любой платформы, вы должны запустить интерфейс командной строки из той же машине, который поддерживает платформы SDK. CLI поддерживает следующие комбинации:

*   iOS (Mac)
*   Android (Mac, Linux)
*   Ежевика 10 (Mac, Linux, Windows)
*   Windows Phone 7 (Windows)
*   Windows Phone 8 (Windows)

На Mac доступны через *терминал* приложения командной строки. На ПК он доступен как *командной строки* под *Аксессуары*.

Скорее, это запустить CLI из различных машин, тем больше это имеет смысл поддерживать удаленный репозиторий, активы которых вы тянуть местные рабочие каталоги.

Чтобы установить `cordova` командной строки средство, выполните следующие действия:

1.  Скачать и установить [Node.js][1]. После установки, вы должны иметь возможность ссылаться на `node` или `npm` в командной строке.

2.  Установить `cordova` утилита. В Unix, предваряя дополнительные `sudo` команда может быть необходимым для установки утилиты разработки в противном случае ограничено каталоги:
    
        $ sudo npm install -g cordova
        
    
    Журнал установки может приводить к ошибкам для любой удаленной платформы SDK. После установки, вы должны иметь возможность запускать `cordova` в командной строке.

 [1]: http://nodejs.org/

## Создание приложения

Перейдите в каталог, где вы сохранить ваш исходный код и выполнить команду следующего вида:

        $ cordova create hello com.example.hello HelloWorld
    

Это может занять некоторое время для выполнения команды, так что будьте терпеливы. Запустите `cordova -d` для просмотра сведений о прогрессе.

Первый аргумент указывает *Привет* каталог создан для вашего проекта. Ее `www` подкаталог домов Главная страница вашего приложения, наряду с различными ресурсами под `css` , `js` , и `img` , которые следуют общей веб развития именах файлов. `config.xml`Файл содержит важные метаданные, необходимые для создания и распространения приложения.

Другие два аргументы являются необязательными: `com.example.hello` аргумент предоставляет ваш проект с идентификатором обратного домена стиля и `HelloWorld` обеспечивает приложения отображаемый текст. Вы можете редактировать оба этих значения позже в `config.xml` файл.

## Добавить платформы

Все последующие команды должны быть запущены в каталоге проекта, или подкаталоги в пределах своей области:

        $ cd hello
    

Перед тем, как можно построить проект, необходимо указать набор целевых платформ. Ваша способность выполнить эти команды зависит от того, поддерживает ли ваш компьютер каждого пакета SDK, и есть ли у вас уже установлен каждого пакета SDK. Запуск любого из них от Mac:

        $ cordova platform add ios
        $ cordova platform add android
        $ cordova platform add blackberry10
    

Выполните любую из этих из окна машины, где *wp* относится к различных версий операционной системы Windows Phone:

        $ cordova platform add wp7
        $ cordova platform add wp8
        $ cordova platform add android
        $ cordova platform add blackberry10
    

Выполните это, чтобы проверить ваш текущий набор платформ:

        $ cordova platforms ls
    

(Примечание `platform` и `platforms` команды являются синонимами.)

Выполните одну из следующих команд синонимом чтобы удалить платформу:

        $ cordova platform remove blackberry10
        $ cordova platform rm android
    

Выполнение команд для добавления или удаления платформ влияет на содержимое каталога *платформы* проекта, где каждый указанной платформе появляется как подкаталог. Исходный каталог *www* воспроизводится в подкаталоге каждой платформы, например появляясь в `platforms/ios/www` или `platforms/android/assets/www` . По умолчанию чтобы иметь возможность получить доступ ко всем API, Кордова настроен файл конфигурации каждой платформы.

Если вы хотите, можно использовать пакет SDK в этот момент чтобы открыть проект, созданный вами. Однако любые изменения, внесенные в проект в рамках SDK влияет производная набор активов, не кросс платформенный исходных файлов. Этот подход следует используйте, если вы просто хотите инициализировать проект. (См. платформа руководства для получения информации о том, как разрабатывать приложения в пределах каждого пакета SDK.) Читайте дальше, если вы хотите использовать инструменты командной строки для весь цикл разработки.

## Построение приложения

По умолчанию `cordova create` скрипт генерирует скелетных веб-приложение, Домашняя страница которого находится проекта `www/index.html` файл. Изменить это приложение, вы хотите, но любой инициализации должен быть указан как часть `deviceready` обработчика событий по умолчанию из ссылки на `www/js/index.js` . <!-- XREF
(See the Application Development Guide for details.)
XREF -->

Выполните следующую команду для последовательного построения проекта:

        $ cordova build
    

Это создает платформенно зависимый код в рамках проекта `platforms` подкаталог. При необходимости можно ограничить сферу охвата каждой сборки для конкретных платформ:

        $ cordova build ios
    

`cordova build`Команда является краткой формой для следующее, что в этом примере также ориентирована на единую платформу:

        $ cordova prepare ios
        $ cordova compile ios
    

В этом случае, после запуска `prepare` , можно использовать Apple в Xcode SDK в качестве альтернативы изменить и скомпилировать платформенно зависимый код, генерирующий Кордова в пределах `platforms/ios` . Можно использовать тот же подход с других платформ SDK.

## Тестирование приложения на эмуляторе или устройстве

SDK для мобильных платформ, которые часто поставляются в комплекте с эмуляторами, выполняемых изображения устройства, так что вы можете запустить приложение на главном экране и посмотреть, как он взаимодействует со многими функциями платформы. Выполните команду следующего вида восстановить приложение и просмотреть его в пределах определенной платформы эмулятора:

        $ cordova emulate android
    

Некоторые мобильные платформы эмулировать конкретного устройства по умолчанию, такие как iPhone iOS проектов. Для других платформ необходимо сначала связать устройство с эмулятором. (См. платформа направляющие для деталей.) Например, вы можете сначала запустить `android` команда для запуска Android SDK, а затем запустить изображение конкретного устройства, которое запускает согласно его поведение по умолчанию:

![][2]

 [2]: img/guide/cli/android_emulate_init.png

Следующие вверх с `cordova emulate` команда обновляет образ эмулятора для отображения последние приложения, который теперь доступен для запуска на начальном экране:

![][3]

 [3]: img/guide/cli/android_emulate_install.png

Поочередно Подключите телефон к компьютеру и тестирование приложения непосредственно можно:

        $ cordova run android
    

Перед выполнением этой команды, необходимо настроить устройство для тестирования, следуя процедурам, которые различаются для каждой платформы. В случае Android вам придется включить опцию **USB отладки** в устройстве и возможно добавить драйвер USB в зависимости от развития далее. Смотрите подробную информацию о потребностях каждой платформы платформы руководства.

## Добавление компонентов

При построении и просмотреть новый проект приложения по умолчанию, которое появляется не очень много. Вы можете изменить app в много способов, чтобы воспользоваться преимуществами стандартных веб-технологий, но для app тесно общаться с различными функциями на уровне устройства, вам нужно добавить плагины, которые обеспечивают доступ к основные API Cordova.

*Плагин* является немного дополнение кода, который предоставляет интерфейс для родной компонентов. Вы можете создать свой собственный плагин интерфейс, например, при разработке приложения гибрид, который смешивает Cordova WebView с собственными компонентами. (См. Встраивание WebViews и руководство по разработке плагинов для деталей.) Чаще всего, хотел бы добавить плагин, чтобы включить один из Кордова в основных функций устройства уровня <!--XREF обсуждаются в руководство По Разработке Приложений и внешних ССЫЛОК--> подробно описаны в Справочник по API.

`cordova plugin add`Команды необходимо указать хранилище для код плагина. Ниже приведены примеры функций, которые можно добавить:

*   Информация основные устройства (устройства API):
    
        $ cordova plugin add https://git-wip-us.apache.org/repos/asf/cordova-plugin-device.git
        

*   Сетевое подключение и батарея события:
    
        $ cordova plugin add https://git-wip-us.apache.org/repos/asf/cordova-plugin-network-information.git
        $ cordova plugin add https://git-wip-us.apache.org/repos/asf/cordova-plugin-battery-status.git
        

*   Акселерометр, компас и географического расположения:
    
        $ cordova plugin add https://git-wip-us.apache.org/repos/asf/cordova-plugin-device-motion.git
        $ cordova plugin add https://git-wip-us.apache.org/repos/asf/cordova-plugin-device-orientation.git
        $ cordova plugin add https://git-wip-us.apache.org/repos/asf/cordova-plugin-geolocation.git
        

*   Камера, воспроизведение мультимедиа и захват:
    
        $ cordova plugin add https://git-wip-us.apache.org/repos/asf/cordova-plugin-camera.git
        $ cordova plugin add https://git-wip-us.apache.org/repos/asf/cordova-plugin-media-capture.git
        $ cordova plugin add https://git-wip-us.apache.org/repos/asf/cordova-plugin-media.git
            

*   Доступ к файлам на устройстве или сети (файл API):
    
        $ cordova plugin add https://git-wip-us.apache.org/repos/asf/cordova-plugin-file.git
        $ cordova plugin add https://git-wip-us.apache.org/repos/asf/cordova-plugin-file-transfer.git
        

*   Уведомление через диалоговое окно или вибрации:
    
        $ cordova plugin add https://git-wip-us.apache.org/repos/asf/cordova-plugin-dialogs.git
        $ cordova plugin add https://git-wip-us.apache.org/repos/asf/cordova-plugin-vibration.git
        

*   Контакты:
    
        $ cordova plugin add https://git-wip-us.apache.org/repos/asf/cordova-plugin-contacts.git
        

*   Глобализация:
    
        $ cordova plugin add https://git-wip-us.apache.org/repos/asf/cordova-plugin-globalization.git
        

*   Экран-заставка:
    
        $ cordova plugin add https://git-wip-us.apache.org/repos/asf/cordova-plugin-splashscreen.git
        

*   Открывать новые окна браузера (InAppBrowser):
    
        $ cordova plugin add https://git-wip-us.apache.org/repos/asf/cordova-plugin-inappbrowser.git
        

*   Отладка консоли:
    
        $ cordova plugin add https://git-wip-us.apache.org/repos/asf/cordova-plugin-console.git
        

Использование `plugin ls` (или `plugin list` , или `plugin` сама по себе) для просмотра в настоящее время установленные плагины. Каждый отображает по его идентификатору:

        $ cordova plugin ls    # or 'plugin list'
        [ 'org.apache.cordova.core.console' ]
    

Чтобы удалить плагин, относятся к нему, тот же идентификатор, который отображается в списке. Например вот как бы удалить поддержка консоли отладки версии:

        $ cordova plugin rm org.apache.cordova.core.console        
        $ cordova plugin remove org.apache.cordova.core.console    # same
    

Можно удалить пакет или добавлять плагины, указав более одного аргумента, для каждой команды.

## Настройка каждой платформы

Хотя Cordova позволяет легко развертывать приложение для многих различных платформ, иногда необходимо добавить настройки. В этом случае, вы не хотите изменить исходные файлы в различных `www` каталогов в пределах верхнего уровня `platforms` каталог, потому что они регулярно вы заменили с верхнего уровня `www` кросс платформенной исходного каталога.

Вместо этого верхнего уровня `merges` Каталог предлагает место для указания активов для развертывания на определенных платформах. Каждая платформа специфического подкаталога в пределах `merges` отражает структуру каталогов `www` дерево исходных текстов, позволяет переопределять или добавлять файлы при необходимости. Например, вот как вы, возможно, использует `merges` чтобы увеличить размер шрифта по умолчанию для устройств Android:

*   Редактировать `www/index.html` файл, добавив ссылку на дополнительные CSS-файл, `overrides.css` в этом случае:
    
        <link rel="stylesheet" type="text/css" href="css/overrides.css" />
        

*   При необходимости создать пустой `www/css/overrides.css` файл, который будет применяться для всех построений-андроида, предотвращая недостающий файл ошибка.

*   Создание `css` подкаталог внутри `merges/android` , затем добавить соответствующий `overrides.css` файл. Укажите CSS, который переопределяет размер шрифта 12 пунктов по умолчанию, указанный в `www/css/index.css` , например:
    
        body { font-size:14px; }
        

При повторном построении проекта, Android версия имеет размер пользовательского шрифта, в то время как другие остаются неизменными.

Вы можете также использовать `merges` для добавления файлов не представляют в оригинале `www` каталог. Например, приложение может включать *обратно кнопку* графического в интерфейс iOS, хранящиеся в `merges/ios/img/back_button.png` , в то время как Android версии вместо этого может захватить `backbutton` события из соответствующих аппаратной кнопки.

## Обновление Кордова

После установки `cordova` утилиты, вы можете всегда обновить его до последней версии, выполнив следующую команду:

        $ sudo npm update -g cordova
    

Используйте этот синтаксис для установки определенной версии:

        $ sudo npm install -g cordova@3.0.0
    

Запуск `cordova -v` чтобы увидеть текущие версии. Запустите `npm
info` команды длиннее список, включающий текущей версии, а также другие номера версии:

        $ npm info cordova
    

Кордова 3.0 это первая версия для поддержки интерфейса командной строки, описанные в этом разделе. Если вы обновляете с версии 3.0, необходимо создать новый проект, как описано выше, а затем скопируйте старые приложения активы в верхнего уровня `www` каталог. Там, где это применимо, дальнейшие сведения об обновлении до 3.0 доступны в платформе гидов. После обновления до `cordova` интерфейс командной строки и использование `npm update` в курсе, более длительных процедур, описанные там более не являются актуальными.