---

license: Licensed to the Apache Software Foundation (ASF) under one or more contributor license agreements. See the NOTICE file distributed with this work for additional information regarding copyright ownership. The ASF licenses this file to you under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with the License. You may obtain a copy of the License at

           http://www.apache.org/licenses/LICENSE-2.0
    
         Unless required by applicable law or agreed to in writing,
         software distributed under the License is distributed on an
         "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
         KIND, either express or implied.  See the License for the
         specific language governing permissions and limitations
         under the License.
    

---

# Введение

Кордова является основой разработки мобильных открытым исходным кодом. Это позволяет использовать стандартные веб-технологии, такие как HTML5, CSS3 и JavaScript для кросс платформенной разработки, избегая каждый мобильных платформ разработки машинного языка. Приложения выполняются внутри обертки для каждой платформы и полагаются на стандартам API привязки для доступа к каждому устройству датчики, данных и состояния сети.

Используйте Cordova, если вы:

*   Мобильный разработчик и хотите расширить приложение через более чем одной платформы, без необходимости повторно реализовать его с каждой платформы языка и инструмент задать.

*   веб-разработчик и хотите, чтобы развернуть веб-приложение, который упакован для распространения в различных приложения хранят порталов.

*   Мобильный разработчик, заинтересованный в смешивания компонентов собственного приложения с *WebView* (окно браузера), можно получить доступ к API уровне устройства, или если вы хотите разработать плагин интерфейс между родной и компонентами WebView.

## Основные компоненты

Кордова приложения полагаются на общей `config.xml` файл, который содержит информацию о приложении и определяет параметры, влияющие на как она работает, такие, как ли она реагирует на ориентации сдвиги. Этот файл соответствует [Упаковке веб-приложение][1], или *виджет*, спецификации W3C.

 [1]: http://www.w3.org/TR/widgets/

Само приложение реализована как веб-страницы, по умолчанию, который ссылается на любой CSS, JavaScript, изображений, мультимедийных файлов, имя *index.html* или другие ресурсы, необходимые для его запуска. Приложение выполняет в *WebView* в пределах собственного приложения оболочки, который вы распространяете app магазины. Для веб-приложение для взаимодействия с различными функциями устройства, сделать путь родные apps, он также должен ссылаться на `cordova.js` файл, который обеспечивает API привязки. <!-- XREF
(See the API Reference for an overview, and the Application
Development Guide for examples of how to use them.)
XREF -->

WebView Cordova с поддержкой может предоставлять приложения с его весь пользовательский интерфейс. Она также может быть компонент в больше, гибридные приложения, которое смешивает WebView с собственного приложения компонентов. Cordova предоставляет интерфейс *плагина* для этих компонентов, чтобы общаться друг с другом.

## Пути развития

Самый простой способ настройки приложения является запуск `cordova` утилиты командной строки, также известный как *интерфейс командной строки* (CLI). (Для установки CLI, см интерфейс командной строки). В зависимости от набора платформ, который вы хотите цели вы можете положиться на CLI для постепенно более акций цикла разработки:

*   В самые основные сценарии CLI можно использовать просто для создания нового проекта, который заполняется с конфигурацией по умолчанию можно изменить.

*   Для многих мобильных платформ можно также использовать CLI для настройки дополнительного проекта файлы, необходимые для компиляции в пределах каждого пакета SDK. Чтобы это работало необходимо установить каждой целевой платформы SDK. (См. платформа руководства для получения инструкций.) Как указано в приведенной ниже таблице поддержки платформы, может потребоваться запустить CLI на различных операционных системах в зависимости от целевой платформы.

*   Для поддержки платформ, CLI можно скомпилировать executible приложения и запустить их в эмуляторе устройства на базе SDK. <!--Внешней ССЫЛКИ (См. Приложение Развития Руководство для деталей.) внешняя ССЫЛКА--> для комплексного тестирования, вы можете также генерировать файлы приложения и установить их непосредственно на устройство.

В любой точке цикла разработки вы можете положиться платформы SDK инструменты, которые могут предоставить расширенный набор параметров. (См. платформа руководства подробные сведения о каждой платформы средства SDK набор). Среды SDK является более подходящим, если вы хотите реализовать гибрид приложение, которое сочетает в себе компоненты веб- и собственные приложения. <!--Внешней ССЫЛКИ (См. Гибридные Приложения Руководство для более информации.) внешняя ССЫЛКА--> вы может использовать утилиту командной строки для первоначально создания app, или многократно после этого для того, чтобы подать обновленный код к инструментам SDK. Вы также можете построить файл конфигурации приложения самостоятельно. 

<!-- XREF
(See Configuration Reference for details.)
XREF -->

<!-- XREF
To build projects on some platforms, you may need to apply digital signatures.
See Distributing Applications for information on how to upload your app to various store portals.
XREF -->

## Поддержка платформ

Ниже приведен набор инструментов разработки и устройства интерфейсы API, доступные для каждой мобильной платформы. (Заголовки столбцов отображаться заглушки CLI стенографию.)

<!-- START HTML -->

<table class="compat" width="100%">
  <tr>
    <th>
      </td> <th>
        <tt>андроид</tt>
      </th>
      
      <th>
        <tt>ежевика</tt> (6)
      </th>
      
      <th>
        <tt>blackberry10</tt>
      </th>
      
      <th>
        <tt>iOS</tt>
      </th>
      
      <th>
        <tt>WP7</tt> (Windows<br />Телефон 7)
      </th>
      
      <th>
        <tt>РГ.8</tt> (Windows<br />Телефон 8)
      </th>
      
      <th>
        <tt>Win8</tt><br />(Windows 8)
      </th>
      
      <th>
        <tt>Tizen</tt>
      </th></tr> </thead> 
      
      <tr>
        <th>
          <a href="guide_cli_index.md.html">Кордова<br />CLI</a>
        </th>
        
        <td data-col="android"    class="y">
          Mac, Windows, Linux
        </td>
        
        <td data-col="blackberry" class="n">
          Mac, Windows
        </td>
        
        <td data-col="blackberry10" class="y">
          Mac, Windows
        </td>
        
        <td data-col="ios"        class="y">
          Mac
        </td>
        
        <td data-col="winphone7"  class="y">
          Windows
        </td>
        
        <td data-col="winphone8"  class="y">
          Windows
        </td>
        
        <td data-col="win8"       class="n">
        </td>
        
        <td data-col="tizen"       class="n">
        </td>
      </tr>
      
      <tr>
        <th>
          <a href="guide_hybrid_webviews_index.md.html">Встроенный<br />WebView</a>
        </th>
        
        <td data-col="android"    class="y">
          <a href="guide_platforms_android_webview.md.html">(подробности см.)</a>
        </td>
        
        <td data-col="blackberry" class="n">
        </td>
        
        <td data-col="blackberry10" class="n">
        </td>
        
        <td data-col="ios"        class="y">
          <a href="guide_platforms_ios_webview.md.html">(подробности см.)</a>
        </td>
        
        <td data-col="winphone7"  class="n">
        </td>
        
        <td data-col="winphone8"  class="n">
        </td>
        
        <td data-col="win8"       class="n">
        </td>
        
        <td data-col="tizen"       class="n">
        </td>
      </tr>
      
      <tr>
        <th>
          <a href="guide_hybrid_plugins_index.md.html">Подключаемый модуль<br />Интерфейс</a>
        </th>
        
        <td data-col="android"    class="y">
          <a href="guide_guide_platforms_android_plugin.md.html">(подробности см.)</a>
        </td>
        
        <td data-col="blackberry" class="y">
          <a href="guide_guide_platforms_blackberry_plugin.md.html">(подробности см.)</a>
        </td>
        
        <td data-col="blackberry10" class="y">
          <a href="guide_guide_platforms_blackberry10_plugin.md.html">(подробности см.)</a>
        </td>
        
        <td data-col="ios"        class="y">
          <a href="guide_guide_platforms_ios_plugin.md.html">(подробности см.)</a>
        </td>
        
        <td data-col="winphone7"  class="y">
          <a href="guide_guide_platforms_wp8_plugin.md.html">(подробности см.)</a>
        </td>
        
        <td data-col="winphone8"  class="y">
        </td>
        
        <td data-col="win8"       class="n">
        </td>
        
        <td data-col="tizen"       class="n">
        </td>
      </tr>
      
      <tr>
        <th>
        </th>
        
        <th colspan="20">
          API платформы
        </th>
      </tr>
      
      <tr>
        <th>
          <a href="cordova_accelerometer_accelerometer.md.html">Акселерометр</a>
        </th>
        
        <td data-col="android"    class="y">
        </td>
        
        <td data-col="blackberry" class="y">
        </td>
        
        <td data-col="blackberry10" class="y">
        </td>
        
        <td data-col="ios"        class="y">
        </td>
        
        <td data-col="winphone7"  class="y">
        </td>
        
        <td data-col="winphone8"  class="y">
        </td>
        
        <td data-col="win8"       class="y">
        </td>
        
        <td data-col="tizen"       class="y">
        </td>
      </tr>
      
      <tr>
        <th>
          <a href="cordova_camera_camera.md.html">Камеры</a>
        </th>
        
        <td data-col="android"    class="y">
        </td>
        
        <td data-col="blackberry" class="y">
        </td>
        
        <td data-col="blackberry10" class="y">
        </td>
        
        <td data-col="ios"        class="y">
        </td>
        
        <td data-col="winphone7"  class="y">
        </td>
        
        <td data-col="winphone8"  class="y">
        </td>
        
        <td data-col="win8"       class="y">
        </td>
        
        <td data-col="tizen"       class="y">
        </td>
      </tr>
      
      <tr>
        <th>
          <a href="cordova_media_capture_capture.md.html">Захват</a>
        </th>
        
        <td data-col="android"    class="y">
        </td>
        
        <td data-col="blackberry" class="y">
        </td>
        
        <td data-col="blackberry10" class="y">
        </td>
        
        <td data-col="ios"        class="y">
        </td>
        
        <td data-col="winphone7"  class="y">
        </td>
        
        <td data-col="winphone8"  class="y">
        </td>
        
        <td data-col="win8"       class="n">
        </td>
        
        <td data-col="tizen"       class="n">
        </td>
      </tr>
      
      <tr>
        <th>
          <a href="cordova_compass_compass.md.html">Компас</a>
        </th>
        
        <td data-col="android"    class="y">
        </td>
        
        <td data-col="blackberry" class="n">
        </td>
        
        <td data-col="blackberry10" class="y">
        </td>
        
        <td data-col="ios"        class="y">
          (3GS +)
        </td>
        
        <td data-col="winphone7"  class="y">
        </td>
        
        <td data-col="winphone8"  class="y">
        </td>
        
        <td data-col="win8"       class="y">
        </td>
        
        <td data-col="tizen"       class="y">
        </td>
      </tr>
      
      <tr>
        <th>
          <a href="cordova_connection_connection.md.html">Подключение</a>
        </th>
        
        <td data-col="android"    class="y">
        </td>
        
        <td data-col="blackberry" class="y">
        </td>
        
        <td data-col="blackberry10" class="y">
        </td>
        
        <td data-col="ios"        class="y">
        </td>
        
        <td data-col="winphone7"  class="y">
        </td>
        
        <td data-col="winphone8"  class="y">
        </td>
        
        <td data-col="win8"       class="y">
        </td>
        
        <td data-col="tizen"       class="y">
        </td>
      </tr>
      
      <tr>
        <th>
          <a href="cordova_contacts_contacts.md.html">Контакты</a>
        </th>
        
        <td data-col="android"    class="y">
        </td>
        
        <td data-col="blackberry" class="y">
        </td>
        
        <td data-col="blackberry10" class="y">
        </td>
        
        <td data-col="ios"        class="y">
        </td>
        
        <td data-col="winphone7"  class="y">
        </td>
        
        <td data-col="winphone8"  class="y">
        </td>
        
        <td data-col="win8"       class="y">
        </td>
        
        <td data-col="tizen"       class="n">
        </td>
      </tr>
      
      <tr>
        <th>
          <a href="cordova_device_device.md.html">Устройство</a>
        </th>
        
        <td data-col="android"    class="y">
        </td>
        
        <td data-col="blackberry" class="y">
        </td>
        
        <td data-col="blackberry10" class="y">
        </td>
        
        <td data-col="ios"        class="y">
        </td>
        
        <td data-col="winphone7"  class="y">
        </td>
        
        <td data-col="winphone8"  class="y">
        </td>
        
        <td data-col="win8"       class="y">
        </td>
        
        <td data-col="tizen"       class="y">
        </td>
      </tr>
      
      <tr>
        <th>
          <a href="cordova_events_events.md.html">События</a>
        </th>
        
        <td data-col="android"    class="y">
        </td>
        
        <td data-col="blackberry" class="y">
        </td>
        
        <td data-col="blackberry10" class="y">
        </td>
        
        <td data-col="ios"        class="y">
        </td>
        
        <td data-col="winphone7"  class="y">
        </td>
        
        <td data-col="winphone8"  class="y">
        </td>
        
        <td data-col="win8"       class="y">
        </td>
        
        <td data-col="tizen"       class="y">
        </td>
      </tr>
      
      <tr>
        <th>
          <a href="cordova_file_file.md.html">Файл</a>
        </th>
        
        <td data-col="android"    class="y">
        </td>
        
        <td data-col="blackberry" class="y">
        </td>
        
        <td data-col="blackberry10" class="y">
        </td>
        
        <td data-col="ios"        class="y">
        </td>
        
        <td data-col="winphone7"  class="p">
          не FileTransfer
        </td>
        
        <td data-col="winphone8"  class="p">
          не FileTransfer
        </td>
        
        <td data-col="win8"       class="y">
        </td>
        
        <td data-col="tizen"       class="n">
        </td>
      </tr>
      
      <tr>
        <th>
          <a href="cordova_geolocation_geolocation.md.html">Географическое положение</a>
        </th>
        
        <td data-col="android"    class="y">
        </td>
        
        <td data-col="blackberry" class="y">
        </td>
        
        <td data-col="blackberry10" class="y">
        </td>
        
        <td data-col="ios"        class="y">
        </td>
        
        <td data-col="winphone7"  class="y">
        </td>
        
        <td data-col="winphone8"  class="y">
        </td>
        
        <td data-col="win8"       class="y">
        </td>
        
        <td data-col="tizen"       class="y">
        </td>
      </tr>
      
      <tr>
        <th>
          <a href="cordova_globalization_globalization.md.html">Глобализация</a>
        </th>
        
        <td data-col="android"    class="y">
        </td>
        
        <td data-col="blackberry" class="y">
        </td>
        
        <td data-col="blackberry10" class="n">
        </td>
        
        <td data-col="ios"        class="y">
        </td>
        
        <td data-col="winphone7"  class="n">
        </td>
        
        <td data-col="winphone8"  class="y">
        </td>
        
        <td data-col="win8"       class="n">
        </td>
        
        <td data-col="tizen"       class="n">
        </td>
      </tr>
      
      <tr>
        <th>
          <a href="cordova_inappbrowser_inappbrowser.md.html">InAppBrowser</a>
        </th>
        
        <td data-col="android"    class="y">
        </td>
        
        <td data-col="blackberry" class="y">
        </td>
        
        <td data-col="blackberry10" class="y">
        </td>
        
        <td data-col="ios"        class="y">
        </td>
        
        <td data-col="winphone7"  class="y">
        </td>
        
        <td data-col="winphone8"  class="y">
        </td>
        
        <td data-col="win8"       class="n">
        </td>
        
        <td data-col="tizen"       class="n">
        </td>
      </tr>
      
      <tr>
        <th>
          <a href="cordova_media_media.md.html">Средства массовой информации</a>
        </th>
        
        <td data-col="android"    class="y">
        </td>
        
        <td data-col="blackberry" class="n">
        </td>
        
        <td data-col="blackberry10" class="y">
        </td>
        
        <td data-col="ios"        class="y">
        </td>
        
        <td data-col="winphone7"  class="y">
        </td>
        
        <td data-col="winphone8"  class="y">
        </td>
        
        <td data-col="win8"       class="y">
        </td>
        
        <td data-col="tizen"       class="y">
        </td>
      </tr>
      
      <tr>
        <th>
          <a href="cordova_notification_notification.md.html">Уведомление</a>
        </th>
        
        <td data-col="android"    class="y">
        </td>
        
        <td data-col="blackberry" class="y">
        </td>
        
        <td data-col="blackberry10" class="y">
        </td>
        
        <td data-col="ios"        class="y">
        </td>
        
        <td data-col="winphone7"  class="y">
        </td>
        
        <td data-col="winphone8"  class="y">
        </td>
        
        <td data-col="win8"       class="y">
        </td>
        
        <td data-col="tizen"       class="y">
        </td>
      </tr>
      
      <tr>
        <th>
          <a href="cordova_splashscreen_splashscreen.md.html">Экран-заставка</a>
        </th>
        
        <td data-col="android"    class="y">
        </td>
        
        <td data-col="blackberry" class="n">
        </td>
        
        <td data-col="blackberry10" class="y">
        </td>
        
        <td data-col="ios"        class="y">
        </td>
        
        <td data-col="winphone7"  class="y">
        </td>
        
        <td data-col="winphone8"  class="y">
        </td>
        
        <td data-col="win8"       class="y">
        </td>
        
        <td data-col="tizen"       class="n">
        </td>
      </tr>
      
      <tr>
        <th>
          <a href="cordova_storage_storage.md.html">Хранения</a>
        </th>
        
        <td data-col="android"    class="y">
        </td>
        
        <td data-col="blackberry" class="y">
        </td>
        
        <td data-col="blackberry10" class="y">
        </td>
        
        <td data-col="ios"        class="y">
        </td>
        
        <td data-col="winphone7"  class="p">
          только localStorage
        </td>
        
        <td data-col="winphone8"  class="p">
          только localStorage
        </td>
        
        <td data-col="win8"       class="y">
        </td>
        
        <td data-col="tizen"       class="y">
        </td>
      </tr></table> 
      
      <!-- END HTML -->