/*
 *  Copyright (C) 2002,2003,2004  Mattia Dongili<dongili@supereva.it>
 *                                George Staikos <staikos@0wned.org>
 *
 *  2003.16.08
 *  - added support for cpu monitoring, base code by Dietz Proepper and minor
 *    fixes by Mattia Dongili
 *    
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#include "libsys.h"

unsigned int old_weighted_activity = 0,
             old_time = 0;

void libsys_preinit ( void (*in_log) (const int prio, const char *fmt, ...), general *config ) {
  cp_log = in_log;
  configuration = config;
  cp_log(LOG_INFO, "libsys_preinit(): pre-initialization done.\n");
}

int get_cpu(void) {
  FILE* fp;
  int f;
  unsigned int c_user, c_nice, c_sys, c_time, delta_time, delta_activity, weighted_activity, perc;
  unsigned long c_idle;

  /* read raw jiffies... */
  fp = fopen ("/proc/stat", "r");
  if (!fp) {
    cp_log(LOG_ERR, "get_cpu(): %s: %s\n", "/proc/stat", strerror(errno));
    /* TODO: return value if failed ????? */
    return -1;
  }
  do {
    f = fscanf (fp, "cpu  %u %u %u %lu", &c_user, &c_nice, &c_sys, &c_idle);
  } while (f != 4);
  fclose(fp);

  /* calculate total jiffies, weight them and save */
  c_time = c_user + c_nice + c_sys + c_idle;
  delta_time = c_time - old_time;
  old_time = c_time;

  weighted_activity = c_user + c_nice / 3 + c_sys;
  delta_activity = weighted_activity - old_weighted_activity;
  old_weighted_activity = weighted_activity;

  if ( delta_activity > delta_time ) {
    perc = 100;
  } else {
    perc = delta_activity * 100 / delta_time;
  }
  cp_log(LOG_INFO, "get_cpu(): CPU usage = %d.\n", perc);
  
  return perc;
}
