/*
 *  Copyright (C) 2002,2003,2004  Mattia Dongili<dongili@supereva.it>
 *                                George Staikos <staikos@0wned.org>
 *
 *  2003.16.08
 *  - added support for cpu monitoring, base code by Dietz Proepper and minor
 *    fixes by Mattia Dongili
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#include "cpufreqd.h"

void (*cp_log) (const int prio, const char *fmt, ...); /* function pointer to the main log function */
general *configuration;

int get_cpu(void);
/* WARNING: already implemented, don't overwrite!
 *
 * This function is called before libsys_init to
 * setup the common infrastructure for plugins.
 *
 * what's provided:
 * 
 * void log (int prio, char *fmt, ...);
 *    use the log priorities from syslog (man 3 syslog). 
 *    This function shares the log_level global variable in order
 *    not to mix different log priorities.
 */
void libsys_preinit(void (*in_log) (const int prio, const char *fmt, ...), general *config);

/*
 * If you want to contribute writing a new PowerManagement plugin
 * just implement those 3 functions
 */

/*
 * Initialization function, preload static informations
 * and performs some checks to let the main program know 
 * if succesful or not.
 *
 * return 0 on success, -1 otherwise
 */
int libsys_init(void);

/*
 * Finalize function, free used memory here please.
 * This is called exiting and reinitializing
 */
void libsys_fini (void);

/*
 * Provides system necessary informations to select the correct
 * policy.
 *
 * return 0 on success, -1 otherwise
 */
int scan_system_info(sys_info *s);
