#!/sbin/runscript
# Copyright 1999-2007 Gentoo Foundation
# Distributed under the terms of the GNU General Public License v2
# $Header: $

depend() {
	need net
}

start() {
    ORDER_CPU=/etc/cpushare/*.cpu
    LOG=/var/log/cpushare/cpushare-sell-
    PID=/var/log/cpushare/cpushare-sell-
    LOADER=/usr/bin/seccomp-loader
    CERT=/usr/share/cpushare/keys/cpushare_cert.pem
    CACHE=/var/log/cpushare/cache

    ebegin "Starting CPUShare"
    if [ `ls /etc/cpushare/*.cpu 2>/dev/null | wc -l` != 1 ]; then
	eerror "Copy a single order.cpu in /etc/cpushare"
	eerror "If in permission troubles try: 'su -c \"cp order.cpu /etc/cpushare\"'"
	return 1
    fi
    if ! egrep -q '^sell_[0-9]+_' $ORDER_CPU; then
	eerror "Not a sell order"
	return 1
    fi
    NR_CPUS=`egrep '^cpu[0-9]+' /proc/stat | wc -l`
    export TZ=UTC # universal timing for the cpushare logs

    TWISTD="python -W ignore `which twistd` -r poll"

    for i in `seq 0 $(python -c "print $NR_CPUS-1")`; do
	nice -n 19 $TWISTD -u cpushare -g cpushare --logfile $LOG$i.log --pidfile $PID$i.pid cpushare --order $ORDER_CPU --seccomp_loader $LOADER --cpushare_cert $CERT --cache $CACHE
    done

    eend $?
}

stop() {
    PID=/var/log/cpushare/cpushare-sell-

    ebegin "Stopping CPUShare"
    for i in $PID*.pid; do
	start-stop-daemon --stop --quiet --pidfile $i
    done
    eend $?
}
