unit fIOTAStat;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, LResources, Forms, Controls, Graphics, Dialogs, ExtCtrls,
  Buttons, StdCtrls, Grids, inifiles;

type

  { TfrmIOTAStat }

  TfrmIOTAStat = class(TForm)
    Button1: TButton;
    btnSave: TButton;
    chkOnlyCFM: TCheckBox;
    cmbCfm: TComboBox;
    mIOTA: TMemo;
    Panel1: TPanel;
    dlgSave: TSaveDialog;
    procedure FormCloseQuery(Sender: TObject; var CanClose: boolean);
    procedure FormCreate(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure btnSaveClick(Sender: TObject);
    procedure chkOnlyCFMChange(Sender: TObject);
    procedure cmbCfmChange(Sender: TObject);
  private
    procedure CreateStat;
    { private declarations }
  public
    { public declarations }
  end; 

var
  frmIOTAStat: TfrmIOTAStat;

implementation

{ TfrmIOTAStat }
uses dData,dUtils, uMyIni;


procedure TfrmIOTAStat.FormShow(Sender: TObject);
begin
  CreateStat;
end;

procedure TfrmIOTAStat.FormCreate(Sender: TObject);
begin
  dmUtils.LoadWindowPos(self);
  {Height := cqrini.ReadInteger('IOTAstat','Height',ClientHeight);
  Width  := cqrini.ReadInteger('IOTAstat','Width',ClientWidth);
  Top    := cqrini.ReadInteger('IOTAstat','Top',20);
  Left   := cqrini.ReadInteger('IOTAstat','Left',20);
  }
  dmUtils.LoadFontSettings(self)
end;

procedure TfrmIOTAStat.FormCloseQuery(Sender: TObject; var CanClose: boolean);
begin
  {
  cqrini.WriteInteger('IOTAstat','Height',ClientHeight);
  cqrini.WriteInteger('IOTAstat','Width',ClientWidth);
  cqrini.WriteInteger('IOTAstat','Top',Top);
  cqrini.WriteInteger('IOTAstat','Left',Left)
  }
  dmUtils.SaveWindowPos(self)
end;

procedure TfrmIOTAStat.btnSaveClick(Sender: TObject);
begin
  dlgSave.DefaultExt := '.txt';
  dlgSave.Filter := 'Text files|*.txt;';
  if dlgSave.Execute then
    mIOTA.Lines.SaveToFile(dlgSave.FileName);
end;

procedure TfrmIOTAStat.chkOnlyCFMChange(Sender: TObject);
begin
  CreateStat;
end;

procedure TfrmIOTAStat.cmbCfmChange(Sender: TObject);
begin
  if chkOnlyCFM.Checked then
    CreateStat
end;

procedure TfrmIOTAStat.CreateStat;
var
  EUcount : Integer = 0;
  AFcount : Integer = 0;
  ANcount : Integer = 0;
  AScount : Integer = 0;
  NAcount : Integer = 0;
  OCcount : Integer = 0;
  SAcount : Integer = 0;
  iota    : String = '';
  call    : String = '';
begin
  mIOTA.Clear;
  dmData.Q.Close;
  dmData.trQ.StartTransaction;
  if chkOnlyCFM.Checked then
  begin
    case cmbCfm.ItemIndex of
      0: dmData.Q.SQL.Text := 'select iota,callsign from cqrlog_main where iota like' +
                              QuotedStr('EU-%') + 'and qsl_r = ' + QuotedStr('Q') +
                              ' group by iota,callsign order by iota';
      1: dmData.Q.SQL.Text := 'select iota,callsign from cqrlog_main where iota like' +
                              QuotedStr('EU-%') + 'and ((qsl_r = ' + QuotedStr('Q') +
                              ') or (lotw_qslr='+QuotedStr('L')+'))group by iota,callsign order by iota';
      2: dmData.Q.SQL.Text := 'select iota,callsign from cqrlog_main where iota like' +
                              QuotedStr('EU-%') + 'and lotw_qslr = ' + QuotedStr('L') +
                              ' group by iota,callsign order by iota'
    end
  end
  else
    dmData.Q.SQL.Text := 'select iota,callsign from cqrlog_main where iota like' +
                          QuotedStr('EU-%') + ' group by iota,callsign order by iota';
  if dmData.DebugLevel >= 1 then
    Writeln(dmData.Q.SQL.Text);
  dmData.Q.Open();
  iota := dmData.Q.Fields[0].AsString;
  if iota<>'' then
    inc(EUcount);
  call := dmData.Q.Fields[1].AsString;
  mIOTA.Lines.Add(iota + #9 + call);
  while not dmData.Q.Eof do
  begin
    if iota <> dmData.Q.Fields[0].AsString then
    begin
      iota := dmData.Q.Fields[0].AsString;
      call := dmData.Q.Fields[1].AsString;
      mIOTA.Lines.Add(iota + #9 + call);
      inc(EUcount);
    end;
    dmData.Q.Next;
  end;
  dmData.Q.Close();
  mIOTA.Lines.Add('');
  if chkOnlyCFM.Checked then
  begin
    case cmbCfm.ItemIndex of
      0: dmData.Q.SQL.Text := 'select iota,callsign from cqrlog_main where iota like' +
                              QuotedStr('AF-%') + 'and qsl_r = ' + QuotedStr('Q') +
                              ' group by iota,callsign order by iota';
      1: dmData.Q.SQL.Text := 'select iota,callsign from cqrlog_main where iota like' +
                              QuotedStr('AF-%') + 'and ((qsl_r = ' + QuotedStr('Q') +
                              ') or (lotw_qslr='+QuotedStr('L')+'))group by iota,callsign order by iota';
      2: dmData.Q.SQL.Text := 'select iota,callsign from cqrlog_main where iota like' +
                              QuotedStr('AF-%') + 'and lotw_qslr = ' + QuotedStr('L') +
                              ' group by iota,callsign order by iota'
    end
  end
  else
    dmData.Q.SQL.Text := 'select iota,callsign from cqrlog_main where iota like' +
                          QuotedStr('AF-%') + ' group by iota,callsign order by iota';
  if dmData.DebugLevel >= 1 then
    Writeln(dmData.Q.SQL.Text);
  dmData.Q.Open();
  iota := dmData.Q.Fields[0].AsString;
  if iota<>'' then
    inc(AFcount);
  call := dmData.Q.Fields[1].AsString;
  mIOTA.Lines.Add(iota + #9 + call);
  while not dmData.Q.Eof do
  begin
    if iota <> dmData.Q.Fields[0].AsString then
    begin
      iota := dmData.Q.Fields[0].AsString;
      call := dmData.Q.Fields[1].AsString;
      mIOTA.Lines.Add(iota + #9 + call);
      inc(AFcount);
    end;
    dmData.Q.Next;
  end;
  dmData.Q.Close();
  mIOTA.Lines.Add('');
  
  if chkOnlyCFM.Checked then
  begin
    case cmbCfm.ItemIndex of
      0: dmData.Q.SQL.Text := 'select iota,callsign from cqrlog_main where iota like' +
                              QuotedStr('AN-%') + 'and qsl_r = ' + QuotedStr('Q') +
                              ' group by iota,callsign order by iota';
      1: dmData.Q.SQL.Text := 'select iota,callsign from cqrlog_main where iota like' +
                              QuotedStr('AN-%') + 'and ((qsl_r = ' + QuotedStr('Q') +
                              ') or (lotw_qslr='+QuotedStr('L')+'))group by iota,callsign order by iota';
      2: dmData.Q.SQL.Text := 'select iota,callsign from cqrlog_main where iota like' +
                              QuotedStr('AN-%') + 'and lotw_qslr = ' + QuotedStr('L') +
                              ' group by iota,callsign order by iota'
    end
  end
  else
    dmData.Q.SQL.Text := 'select iota,callsign from cqrlog_main where iota like' +
                          QuotedStr('AN-%') + ' group by iota,callsign order by iota';
  if dmData.DebugLevel >= 1 then
    Writeln(dmData.Q.SQL.Text);
  dmData.Q.Open();
  iota := dmData.Q.Fields[0].AsString;
  if iota<>'' then
    inc(ANcount);
  call := dmData.Q.Fields[1].AsString;
  mIOTA.Lines.Add(iota + #9 + call);
  while not dmData.Q.Eof do
  begin
    if iota <> dmData.Q.Fields[0].AsString then
    begin
      iota := dmData.Q.Fields[0].AsString;
      call := dmData.Q.Fields[1].AsString;
      mIOTA.Lines.Add(iota + #9 + call);
      inc(ANcount);
    end;
    dmData.Q.Next;
  end;
  dmData.Q.Close();
  mIOTA.Lines.Add('');

  if chkOnlyCFM.Checked then
  begin
    case cmbCfm.ItemIndex of
      0: dmData.Q.SQL.Text := 'select iota,callsign from cqrlog_main where iota like' +
                              QuotedStr('AS-%') + 'and qsl_r = ' + QuotedStr('Q') +
                              ' group by iota,callsign order by iota';
      1: dmData.Q.SQL.Text := 'select iota,callsign from cqrlog_main where iota like' +
                              QuotedStr('AS-%') + 'and ((qsl_r = ' + QuotedStr('Q') +
                              ') or (lotw_qslr='+QuotedStr('L')+'))group by iota,callsign order by iota';
      2: dmData.Q.SQL.Text := 'select iota,callsign from cqrlog_main where iota like' +
                              QuotedStr('AS-%') + 'and lotw_qslr = ' + QuotedStr('L') +
                              ' group by iota,callsign order by iota'
    end
  end
  else
    dmData.Q.SQL.Text := 'select iota,callsign from cqrlog_main where iota like' +
                          QuotedStr('AS-%') + ' group by iota,callsign order by iota';
  if dmData.DebugLevel >= 1 then
    Writeln(dmData.Q.SQL.Text);
  dmData.Q.Open();
  iota := dmData.Q.Fields[0].AsString;
  if iota<>'' then
    inc(AScount);
  call := dmData.Q.Fields[1].AsString;
  mIOTA.Lines.Add(iota + #9 + call);
  while not dmData.Q.Eof do
  begin
    if iota <> dmData.Q.Fields[0].AsString then
    begin
      iota := dmData.Q.Fields[0].AsString;
      call := dmData.Q.Fields[1].AsString;
      mIOTA.Lines.Add(iota + #9 + call);
      inc(AScount);
    end;
    dmData.Q.Next;
  end;
  dmData.Q.Close();
  mIOTA.Lines.Add('');

  if chkOnlyCFM.Checked then
  begin
    case cmbCfm.ItemIndex of
      0: dmData.Q.SQL.Text := 'select iota,callsign from cqrlog_main where iota like' +
                              QuotedStr('NA-%') + 'and qsl_r = ' + QuotedStr('Q') +
                              ' group by iota,callsign order by iota';
      1: dmData.Q.SQL.Text := 'select iota,callsign from cqrlog_main where iota like' +
                              QuotedStr('NA-%') + 'and ((qsl_r = ' + QuotedStr('Q') +
                              ') or (lotw_qslr='+QuotedStr('L')+'))group by iota,callsign order by iota';
      2: dmData.Q.SQL.Text := 'select iota,callsign from cqrlog_main where iota like' +
                              QuotedStr('NA-%') + 'and lotw_qslr = ' + QuotedStr('L') +
                              ' group by iota,callsign order by iota'
    end
  end
  else
    dmData.Q.SQL.Text := 'select iota,callsign from cqrlog_main where iota like' +
                          QuotedStr('NA-%') + ' group by iota,callsign order by iota';
  if dmData.DebugLevel >= 1 then
    Writeln(dmData.Q.SQL.Text);
  dmData.Q.Open();
  iota := dmData.Q.Fields[0].AsString;
  if iota<>'' then
    inc(NAcount);
  call := dmData.Q.Fields[1].AsString;
  mIOTA.Lines.Add(iota + #9 + call);
  while not dmData.Q.Eof do
  begin
    if iota <> dmData.Q.Fields[0].AsString then
    begin
      iota := dmData.Q.Fields[0].AsString;
      call := dmData.Q.Fields[1].AsString;
      mIOTA.Lines.Add(iota + #9 + call);
      inc(NAcount);
    end;
    dmData.Q.Next;
  end;
  dmData.Q.Close();
  mIOTA.Lines.Add('');

  dmData.Q.Close;
  if chkOnlyCFM.Checked then
  begin
    case cmbCfm.ItemIndex of
      0: dmData.Q.SQL.Text := 'select iota,callsign from cqrlog_main where iota like' +
                              QuotedStr('OC-%') + 'and qsl_r = ' + QuotedStr('Q') +
                              ' group by iota,callsign order by iota';
      1: dmData.Q.SQL.Text := 'select iota,callsign from cqrlog_main where iota like' +
                              QuotedStr('OC-%') + 'and ((qsl_r = ' + QuotedStr('Q') +
                              ') or (lotw_qslr='+QuotedStr('L')+'))group by iota,callsign order by iota';
      2: dmData.Q.SQL.Text := 'select iota,callsign from cqrlog_main where iota like' +
                              QuotedStr('OC-%') + 'and lotw_qslr = ' + QuotedStr('L') +
                              ' group by iota,callsign order by iota'
    end
  end
  else
    dmData.Q.SQL.Text := 'select iota,callsign from cqrlog_main where iota like' +
                          QuotedStr('OC-%') + ' group by iota,callsign order by iota';
  if dmData.DebugLevel >= 1 then
    Writeln(dmData.Q.SQL.Text);
  dmData.Q.Open();
  iota := dmData.Q.Fields[0].AsString;
  if iota<>'' then
    inc(OCcount);
  call := dmData.Q.Fields[1].AsString;
  mIOTA.Lines.Add(iota + #9 + call);
  while not dmData.Q.Eof do
  begin
    if iota <> dmData.Q.Fields[0].AsString then
    begin
      iota := dmData.Q.Fields[0].AsString;
      call := dmData.Q.Fields[1].AsString;
      mIOTA.Lines.Add(iota + #9 + call);
      inc(OCcount);
    end;
    dmData.Q.Next;
  end;
  dmData.Q.Close();
  mIOTA.Lines.Add('');

  if chkOnlyCFM.Checked then
  begin
    case cmbCfm.ItemIndex of
      0: dmData.Q.SQL.Text := 'select iota,callsign from cqrlog_main where iota like' +
                              QuotedStr('SA-%') + 'and qsl_r = ' + QuotedStr('Q') +
                              ' group by iota,callsign order by iota';
      1: dmData.Q.SQL.Text := 'select iota,callsign from cqrlog_main where iota like' +
                              QuotedStr('SA-%') + 'and ((qsl_r = ' + QuotedStr('Q') +
                              ') or (lotw_qslr='+QuotedStr('L')+'))group by iota,callsign order by iota';
      2: dmData.Q.SQL.Text := 'select iota,callsign from cqrlog_main where iota like' +
                              QuotedStr('SA-%') + 'and lotw_qslr = ' + QuotedStr('L') +
                              ' group by iota,callsign order by iota'
    end
  end
  else
    dmData.Q.SQL.Text := 'select iota,callsign from cqrlog_main where iota like' +
                          QuotedStr('SA-%') + ' group by iota,callsign order by iota';
  if dmData.DebugLevel >= 1 then
    Writeln(dmData.Q.SQL.Text);
  dmData.Q.Open();
  iota := dmData.Q.Fields[0].AsString;
  if iota<>'' then
    inc(SAcount);
  call := dmData.Q.Fields[1].AsString;
  mIOTA.Lines.Add(iota + #9 + call);
  while not dmData.Q.Eof do
  begin
    if iota <> dmData.Q.Fields[0].AsString then
    begin
      iota := dmData.Q.Fields[0].AsString;
      call := dmData.Q.Fields[1].AsString;
      mIOTA.Lines.Add(iota + #9 + call);
      inc(SAcount);
    end;
    dmData.Q.Next;
  end;
  dmData.Q.Close();
  mIOTA.Lines.Add('');

  mIOTA.Lines.Add('------------------');
  mIOTA.Lines.Add('EU islands: '+IntToStr(EUcount));
  mIOTA.Lines.Add('AF islands: '+IntToStr(AFcount));
  mIOTA.Lines.Add('AN islands: '+IntToStr(ANcount));
  mIOTA.Lines.Add('AS islands: '+IntToStr(AScount));
  mIOTA.Lines.Add('NA islands: '+IntToStr(NAcount));
  mIOTA.Lines.Add('OC islands: '+IntToStr(OCcount));
  mIOTA.Lines.Add('SA islands: '+IntToStr(SAcount));
  mIOTA.Lines.Add('-------------------');
  mIOTA.Lines.Add('Total: ' + IntToStr(EUcount+AFcount+NAcount+AScount+ANcount+
                  OCcount+SAcount));
  dmData.trQ.RollBack
end;

initialization
  {$I fIOTAStat.lrs}

end.

