/*
 * unit.c
 *
 * crafted - a pud editor for the freecraft project.
 *
 * Copyright (C) 2001-2002 DindinX <David@dindinx.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <stdlib.h>
#include <unistd.h>
#include <gtk/gtk.h>
#include "crafted.h"
#include "unit.h"
#include "craftedrc.h"
#include "config.h"

UnitType default_unit_types[] =
{
  { "unit-foot-man", "Footman",
    "footman.png", "footman.png", 72, 72, 1, 1,
    NULL /* 0 */
  },
  { "unit-grunt", "Grunt",
    "grunt.png", "grunt.png", 72,72, 1,1,
    NULL /* 1 */
  },
  {
    "unit-peasant", "Peasant",
    "peasant.png", "peasant.png", 72,72, 1,1,
    NULL /* 2 */
  },
  {
    "unit-peon", "Peon",
    "peon.png", "faun.png", 72,72, 1,1,
    NULL /* 3 */
  },
  {
    "unit-ballista", "Ballista",
    "ballista.png", "ballista.png", 64, 64, 1, 1,
    NULL /* 4 */
  },
  {
    "unit-catapult", "Catapult",
    "catapult.png", "catapult.png", 64,64, 1,1,
    NULL /* 5 */
  },
  {
    "unit-knight", "Knight",
    "knight.png", "knight.png", 72, 72, 1,1,
    NULL /* 6 */
  },
  {
    "unit-ogre", "Ogre",
    "ogre.png", "ogre.png", 72, 72, 1,1,
    NULL /* 7 */
  },
  {
    "unit-archer", "Archer",
    "elven archer.png", "archer.png", 72, 72, 1,1,
    NULL /* 8 */
  },
  {
    "unit-axethrower", "Troll Axethrower",
    "troll axethrower.png", "axethrower.png", 72, 72, 1,1,
    NULL /* 9 */
  },
  {
    "unit-mage", "Mage",
    "mage.png", "mage.png", 72, 72, 1,1,
    NULL /* 10 */
  },
  {
    "unit-death-knight", "Death Knight",
    "death knight.png", "death_knight.png", 72, 72, 1,1,
    NULL /* 11 */
  },
  {
    "unit-paladin", "Paladin",
    "knight.png", "knight.png", 72, 72, 1,1,
    NULL /* 12 */
  },
  {
    "unit-ogre-mage", "Ogre Mage",
    "ogre.png", "ogre.png", 72, 72, 1,1,
    NULL /* 13 */
  },
  {
    "unit-dwarves", "Dwarves",
    "dwarven demolition squad.png", "demolition_squad.png", 56, 56, 1,1,
    NULL /* 14 */
  },
  {
    "unit-goblin-sappers", "Goblin Sappers",
    "goblin sappers.png", "goblin_sappers.png", 56, 56, 1,1,
    NULL /* 15 */
  },
  {
    "unit-attack-peasant", "Attack Peasant",
    "peasant.png", "peasant.png", 72, 72, 1,1,
    NULL /* 16 */
  },
  {
    "unit-attack-peon", "Attack Peon",
    "peon.png", "faun.png", 72, 72, 1,1,
    NULL /* 17 */
  },
  {
    "unit-ranger", "Ranger",
    "elven archer.png", "elven_archer.png", 72, 72, 1,1,
    NULL /* 18 */
  },
  {
    "unit-berserker", "Berserker",
    "troll axethrower.png", "axethrower.png", 72, 72, 1,1,
    NULL /* 19 */
  },
  {
    "unit-alleria", "Alleria",
    "elven archer.png", "elven_archer.png", 72, 72, 1,1,
    NULL /* 20 */
  },
  {
    "unit-teron-gorefiend", "Teron Gorefiend",
    "death knight.png", "death_knight.png", 72, 72, 1,1,
    NULL /* 21 */
  },
  {
    "unit-kurdan-and-sky-ree", "Kurdan and Sky'ree",
    "gryphon rider.png", "gryphon_rider.png", 80, 80, 1,1,
    NULL /* 22 */
  },
  {
    "unit-dentarg", "Dentarg",
    "ogre.png", "ogre.png", 72, 72, 1,1,
    NULL /* 23 */
  },
  {
    "unit-khadgar", "Khadgar",
    "mage.png", "mage.png", 72, 72, 1,1,
    NULL /* 24 */
  },
  {
    "unit-grom-hellscream", "Grom Hellscream",
    "grunt.png", "grunt.png", 72, 72, 1,1,
    NULL /* 25 */
  },
  {
    "unit-human-oil-tanker", "Oil tanker",
    "human/units/oil tanker empty.png", "alliance/units/empty_tanker.png", 72, 72, 1,1,
    NULL /* 26 */
  },
  {
    "unit-orc-oil-tanker", "Oil tanker",
    "orc/units/oil tanker empty.png", "mythical/units/empty_tanker.png", 72, 72, 1,1,
    NULL /* 27 */
  },
  {
    "unit-human-transport", "Transport",
    "human/units/transport.png", "alliance/units/transport.png", 72, 72, 1,1,
    NULL /* 28 */
  },
  {
    "unit-orc-transport", "Transport",
    "orc/units/transport.png", "mythical/units/transport.png", 72, 72, 1,1,
    NULL /* 29 */
  },
  {
    "unit-elven-destroyer", "Elven Destroyer",
    "elven destroyer.png", "alliance/units/destroyer.png", 80, 88, 1,1,
    NULL /* 30 */
  },
  {
    "unit-troll-destroyer", "Troll Destroyer",
    "troll destroyer.png", "mythical/units/destroyer.png", 88, 88, 1,1,
    NULL /* 31 */
  },
  {
    "unit-battleship", "Battleship",
    "battleship.png", "battleship.png", 88, 88, 1,1,
    NULL /* 32 */
  },
  {
    "unit-ogre-juggernaught", "Ogre Juggernaught",
    "ogre juggernaught.png", "juggernaught.png", 88, 88, 1,1,
    NULL /* 33 */
  },
  {
    "unit-nothing-22", "Nothing 22",
    NULL, NULL, 0, 0, 0, 0,
    NULL /* 34 */
  },
  {
    "unit-deathwing", "Deathwing",
    "dragon.png", "dragon.png", 88, 80, 1,1,          /* what about this one? */
    NULL /* 35 */
  },
  {
    "unit-nothing-24", "Nothing 24",
    NULL, NULL, 32, 32, 1,1,
    NULL /* 36 */
  },
  {
    "unit-nothing-25", "Nothing 25",
    NULL, NULL, 32, 32, 1,1,
    NULL /* 37 */
  },
  {
    "unit-gnomish-submarine", "Gnomish Submarine",
    "gnomish submarine.png", "alliance/units/submarine.png", 72, 72, 1,1,
    NULL /* 38 */
  },
  {
    "unit-giant-turtle", "Giant Turtle",
    "giant turtle.png", "mythical/units/submarine.png", 72, 72, 1,1,
    NULL /* 39 */
  },
  {
    "unit-gnomish-flying-machine", "Gnomish Flying Machine",
    "gnomish flying machine.png", "balloon.png", 80, 80, 1,1,
    NULL /* 40 */
  },
  {
    "unit-goblin-zeppelin", "Goblin Zeppelin",
    "goblin zeppelin.png", "zeppelin.png", 72, 72, 1,1,
    NULL /* 41 */
  },
  {
    "unit-gryphon-rider", "Gryphon Rider",
    "gryphon rider.png", "gryphon_rider.png", 80, 80, 1,1,
    NULL /* 42 */
  },
  {
    "unit-dragon", "Dragon",
    "dragon.png", "dragon.png", 88, 80, 1,1,
    NULL /* 43 */
  },
  {
    "unit-turalyon", "Turalyon",
    "knight.png", "knight.png", 72, 72, 1,1,
    NULL /* 44 */
  },
  {
    "unit-eye-of-kilrogg", "Eye of Kilrogg",
    "eye of kilrogg.png", "eye.png", 32, 32, 1,1,
    NULL /* 45 */
  },
  {
    "unit-danath", "Danath",
    "footman.png", "footman.png", 72, 72, 1,1,
    NULL /* 46 */
  },
  {
    "unit-korgath-bladefist", "Korgath Bladefist",
    "grunt.png", "grunt.png", 72, 72, 1,1,
    NULL /* 47 */
  },
  {
    "unit-nothing-30", "Nothing 30",
    NULL, NULL, 0, 0, 0,0,
    NULL /* 48 */
  },
  {
    "unit-cho-gall", "Cho'gall",
    "ogre.png", "ogre.png", 72, 72, 1,1,
    NULL /* 49 */
  },
  {
    "unit-lothar", "Lothar",
    "knight.png", "knight.png", 72, 72, 1,1,
    NULL /* 50 */
  },
  {
    "unit-gul-dan", "Gul'dan",
    "death knight.png", "death_knight.png", 72, 72, 1,1,
    NULL /* 51 */
  },
  {
    "unit-uther-lightbringer", "Uther Lightbringer",
    "knight.png", "knight.png", 72, 72, 1,1,
    NULL /* 52 */
  },
  {
    "unit-zuljin", "Zuljin",
    "troll axethrower.png", "axethrower.png", 72, 72, 1,1,
    NULL /* 53 */
  },
  {
    "unit-nothing-36", "Nothing 36",
    NULL, NULL, 0, 0, 0,0,
    NULL /* 54 */
  },
  {
    "unit-skeleton", "Skeleton",
    "skeleton.png", "skeleton.png", 56, 56, 1,1,
    NULL /* 55 */
  },
  {
    "unit-daemon", "Daemon",
    "daemon.png", "daemon.png", 72, 72, 1,1,
    NULL /* 56 */
  },
  {
    "unit-critter", "Critter",
    "critter.png", "critter.png", 32, 32, 1,1,
    NULL /* 57 */
  },
  {
    "unit-farm", "Farm",
    "farm.png", "alliance/buildings/farm.png", 64, 64, 2,2,
    NULL /* 58 */
  },
  {
    "unit-pig-farm", "Pig Farm",
    "pig farm.png", "mythical/buildings/farm.png", 64, 64, 2,2,
    NULL /* 59 */
  },
  {
    "unit-human-barracks", "Barracks",
    "human/buildings/barracks.png", "alliance/buildings/barracks.png", 96, 96, 3,3,
    NULL /* 60 */
  },
  {
    "unit-orc-barracks", "Barracks",
    "orc/buildings/barracks.png", "mythical/buildings/barracks.png", 96, 96, 3,3,
    NULL /* 61 */
  },
  {
    "unit-church", "Church",
    "church.png", "church.png", 96, 96, 3,3,
    NULL /* 62 */
  },
  {
    "unit-altar-of-storms", "Altar of Storms",
    "altar of storms.png", "altar_of_storms.png", 96, 96, 3,3,
    NULL /* 63 */
  },
  {
    "unit-human-watch-tower", "Scout Tower",
    "human/buildings/scout tower.png", "alliance/buildings/scout_tower.png", 64, 64, 2,2,
    NULL /* 64 */
  },
  {
    "unit-orc-watch-tower", "Scout Tower",
    "orc/buildings/watch tower.png", "mythical/buildings/scout_tower.png", 64, 64, 2,2,
    NULL /* 65 */
  },
  {
    "unit-stables", "Stables",
    "stables.png", "stables.png", 96, 96, 3,3,
    NULL /* 66 */
  },
  {
    "unit-ogre-mound", "Ogre Mound",
    "ogre mound.png", "ogre_mound.png", 96, 96, 3,3,
    NULL /* 67 */
  },
  {
    "unit-gnomish-inventor", "Gnomish Inventor",
    "gnomish inventor.png", "inventor.png", 96, 96, 3,3,
    NULL /* 68 */
  },
  {
    "unit-goblin-alchemist", "Goblin Alchemist",
    "goblin alchemist.png", "alchemist.png", 96, 96, 3,3,
    NULL /* 69 */
  },
  {
    "unit-gryphon-aviary", "Gryphon Aviary",
    "gryphon aviary.png", "gryphon_aviary.png", 96, 96, 3,3,
    NULL /* 70 */
  },
  {
    "unit-dragon-roost", "Dragon Roost",
    "dragon roost.png", "dragon_roost.png", 96, 96, 3,3,
    NULL /* 71 */
  },
  {
    "unit-human-shipyard", "Shipyard",
    "human/buildings/shipyard.png", "alliance/buildings/shipyard.png", 96, 96, 3,3,
    NULL /* 72 */
  },
  {
    "unit-orc-shipyard", "Shipyard",
    "orc/buildings/shipyard.png", "mythical/buildings/shipyard.png", 96, 96, 3,3,
    NULL /* 73 */
  },
  {
    "unit-town-hall", "Town Hall",
    "town hall.png", "town_hall.png", 128, 128, 4,4,
    NULL /* 74 */
  },
  {
    "unit-great-hall", "Great Hall",
    "great hall.png", "great_hall.png", 128, 128, 4,4,
    NULL /* 75 */
  },
  {
    "unit-elven-lumber-mill", "Elven Lumber Mill",
    "elven lumber mill.png", "lumber_mill.png", 96, 96, 3,3,
    NULL /* 76 */
  },
  {
    "unit-troll-lumber-mill", "Troll Lumber Mill",
    "troll lumber mill.png", "lumber_mill.png", 96, 96, 3,3,
    NULL /* 77 */
  },
  {
    "unit-human-foundry", "Foundry",
    "human/buildings/foundry.png", "alliance/buildings/foundry.png", 96, 96, 3,3,
    NULL /* 78 */
  },
  {
    "unit-orc-foundry", "Foundry",
    "orc/buildings/foundry.png", "mythical/buildings/foundry.png", 96, 96, 3,3,
    NULL /* 79 */
  },
  {
    "unit-mage-tower", "Mage Tower",
    "mage tower.png", "mage_tower.png", 96, 96, 3,3,
    NULL /* 80 */
  },
  {
    "unit-temple-of-the-damned", "Temple of the Damned",
    "temple of the damned.png", "temple_of_the_damned.png", 96, 96, 3,3,
    NULL /* 81 */
  },
  {
    "unit-human-blacksmith", "Blacksmith",
    "human/buildings/blacksmith.png", "alliance/buildings/blacksmith.png", 96, 96, 3,3,
    NULL /* 82 */
  },
  {
    "unit-orc-blacksmith", "Blacksmith",
    "orc/buildings/blacksmith.png", "mythical/buildings/blacksmith.png", 96, 96, 3,3,
    NULL /* 83 */
  },
  {
    "unit-human-refinery", "Refinery",
    "human/buildings/refinery.png", "alliance/buildings/refinery.png", 96, 96, 3,3,
    NULL /* 84 */
  },
  {
    "unit-orc-refinery", "Refinery",
    "orc/buildings/refinery.png", "mythical/buildings/refinery.png", 96, 96, 3,3,
    NULL /* 85 */
  },
  {
    "unit-human-oil-platform", "Oil Platform",
    "human/buildings/oil platform.png", "alliance/buildings/oil_well.png", 96, 96, 3,3,
    NULL /* 86 */
  },
  {
    "unit-orc-oil-platform", "Oil Platform",
    "orc/buildings/oil platform.png", "mythical/buildings/oil_well.png", 96, 96, 3,3,
    NULL /* 87 */
  },
  {
    "unit-keep", "Keep",
    "keep.png", "keep.png", 128, 128, 4,4,
    NULL /* 88 */
  },
  {
    "unit-stronghold", "Stronghold",
    "stronghold.png", "stronghold.png", 128, 128, 4,4,
    NULL /* 89 */
  },
  {
    "unit-castle", "Castle",
    "castle.png", "castle.png", 128, 128, 4,4,
    NULL /* 90 */
  },
  {
    "unit-fortress", "Fortress",
    "fortress.png", "fortress.png", 128, 128, 4,4,
    NULL /* 91 */
  },
  {
    "unit-gold-mine", "Gold Mine",
    "gold mine.png", "gold_mine.png", 96, 96, 3,3,
    NULL /* 92 */
  },
  {
    "unit-oil-patch", "Oil Patch",
    "oil patch.png", "oil_patch.png", 96, 96, 3,3,
    NULL /* 93 */
  },
  {
    "unit-human-start-location", "Start Location",
    "x startpoint.png", "x_startpoint.png", 32, 32, 1,1,
    NULL /* 94 */
  },
  {
    "unit-orc-start-location", "Start Location",
    "o startpoint.png", "o_startpoint.png", 32, 32, 1,1,
    NULL /* 95 */
  },
  { "unit-human-guard-tower", "Guard Tower",
    "human/buildings/guard tower.png", "alliance/buildings/guard_tower.png", 64, 64, 2,2,
    NULL /* 96 */
  },
  {
    "unit-orc-guard-tower", "Guard Tower",
    "orc/buildings/guard tower.png", "mythical/buildings/guard_tower.png", 64, 64, 2,2,
    NULL /* 97 */
  },
  {
    "unit-human-cannon-tower", "Cannon Tower",
    "human/buildings/cannon tower.png", "alliance/buildings/cannon_tower.png", 64, 64, 2,2,
    NULL /* 98 */
  },
  {
    "unit-orc-cannon-tower", "Cannon Tower",
    "orc/buildings/cannon tower.png", "mythical/buildings/cannon_tower.png", 64, 64, 2,2,
    NULL /* 99 */
  },
  {
    "unit-circle-of-power", "Circle of Power",
    "circle of power.png", "circle_of_power.png", 64, 64, 2,2,
    NULL /* 100 */
  },
  {
    "unit-dark-portal", "Dark Portal",
    "dark portal.png", "dark_portal.png", 128, 128, 4,4,
    NULL /* 101 */
  },
  {
    "unit-runestone", "Runestone",
    "runestone.png", "runestone.png", 64, 64, 2,2,
    NULL /* 102 */
  },
  {
    "unit-human-wall", "Wall",
    "wall.png", "wall.png", 32, 32, 1,1,
    NULL /* 103 */
  },
  {
    "unit-orc-wall", "Wall",
    "wall.png", "wall.png", 32, 32, 1,1,
    NULL /* 104 */
  },
  {
    "unit-dead-body", "Dead Body",
    "corpses.png", "corpses.png", 72, 72, 1,1,
    NULL /* 105 */
  },
  {
    "unit-destroyed-1x1-place", "Destroyed 1x1 Place",
    "small destroyed site.png", "small_destroyed_site.png", 32, 32, 1,1,
    NULL /* 106 */
  },
  {
    "unit-destroyed-2x2-place", "Destroyed 2x2 Place",
    "destroyed site.png", "destroyed_site.png", 64, 64, 2,2,
    NULL /* 107 */
  },
  {
    "unit-destroyed-3x3-place", "Destroyed 3x3 Place",
    "destroyed site.png", "destroyed_site.png", 96, 96, 3,3,
    NULL /* 108 */
  },
  {
    "unit-destroyed-4x4-place", "Destroyed 4x4 Place",
    "destroyed site.png", "destroyed_site.png", 128, 128, 4,4,
    NULL /* 109 */
  },
  {
    "unit-peasant-with-gold", "Peasant",
    "peasant with gold.png", "peasant_with_gold.png", 72, 72, 1,1,
    NULL /* 110 */
  },
  {
    "unit-peon-with-gold", "Peon",
    "peon with gold.png", "faun_with_gold.png", 72, 72, 1,1,
    NULL /* 111 */
  },
  {
    "unit-peasant-with-wood", "Peasant",
    "peasant with wood.png", "peasant_with_wood.png", 72, 72, 1,1,
    NULL /* 112 */
  },
  {
    "unit-peon-with-wood", "Peon",
    "peon with wood.png", "faun_with_wood.png", 72, 72, 1,1,
    NULL /* 113 */
  },
  {
    "unit-human-oil-tanker-full", "Oil tanker",
    "human/units/tanker full.png", "alliance/units/full_tanker.png", 72, 72, 1,1,
    NULL /* 114 */
  },
  {
    "unit-orc-oil-tanker-full", "Oil tanker",
    "orc/units/tanker full.png", "mythical/units/full_tanker.png", 72, 72, 1,1,
    NULL /* 115 */
  },
  { NULL, NULL, NULL, NULL, 0, 0, 0, 0, NULL}
};

gint nb_unit_types = sizeof(default_unit_types)/sizeof(default_unit_types[0]);

gint general_unit_idx[] = { 55, 56, 57, 92, 93, 100, 101, 102, -1 };

gint human_unit_idx[] = { 0, 2, 4, 6, 8, 10, 14, 16, 20, 22, 24, 26, 28, 30, 32,
                          38, 40, 42, 44, 46, 50, 52, 58, 60, 62, 64, 66, 68,
                          70, 72, 74, 76, 78, 80, 82, 84, 86, 88, 90, 94, 96,
                          98 , -1 };

gint orc_unit_idx[] = { 1, 3, 5, 7, 9, 11, 15, 17, 21, 23, 25, 27, 29, 31, 33,
			35, 39, 41, 43, 47, 49, 51, 53, 59, 61, 63, 65, 67, 69,
			71, 73, 75, 77, 79, 81, 83, 85, 87, 89, 91, 95, 97,
			99, -1 };

void fill_unit_lists(gint type, GtkWidget *gtklist)
{
  gint *idx_array = general_unit_idx;
  gint idx, i, j;
  GList *unit_list_items = NULL;
  static char *pathes[] =
  {
    "graphics",
    "graphics/neutral/buildings",
    "graphics/neutral/flyers",
    "graphics/neutral/ships",
    "graphics/neutral/units",
    "graphics/neutral",
    "graphics/human/buildings",
    "graphics/human/ships",
    "graphics/human/flyers",
    "graphics/human/units",
    "graphics/human",
    "graphics/orc/buildings",
    "graphics/orc/flyers",
    "graphics/orc/ships",
    "graphics/orc/units",
    "graphics/orc",
    "graphics/alliance/buildings",
    "graphics/alliance/ships",
    "graphics/alliance/flyers",
    "graphics/alliance/units",
    "graphics/alliance",
    "graphics/mythical/buildings",
    "graphics/mythical/flyers",
    "graphics/mythical/ships",
    "graphics/mythical/units",
    "graphics/mythical",
    "graphics/tilesets/summer/neutral/buildings",
    "graphics/tilesets/summer/neutral/flyers",
    "graphics/tilesets/summer/neutral/ships",
    "graphics/tilesets/summer/neutral/units",
    "graphics/tilesets/summer/neutral",
    "graphics/tilesets/summer/human/buildings",
    "graphics/tilesets/summer/human/flyers",
    "graphics/tilesets/summer/human/ships",
    "graphics/tilesets/summer/human/units",
    "graphics/tilesets/summer/human",
    "graphics/tilesets/summer/orc/buildings",
    "graphics/tilesets/summer/orc/flyers",
    "graphics/tilesets/summer/orc/ships",
    "graphics/tilesets/summer/orc/units",
    "graphics/tilesets/summer/orc",
    "graphics/tilesets/summer/alliance/buildings",
    "graphics/tilesets/summer/alliance/flyers",
    "graphics/tilesets/summer/alliance/ships",
    "graphics/tilesets/summer/alliance/units",
    "graphics/tilesets/summer/alliance",
    "graphics/tilesets/summer/mythical/buildings",
    "graphics/tilesets/summer/mythical/flyers",
    "graphics/tilesets/summer/mythical/ships",
    "graphics/tilesets/summer/mythical/units",
    "graphics/tilesets/summer/mythical",
    "graphics/tilesets/summer/",
    NULL
  };

  switch (type)
  {
    case 1:
      idx_array = general_unit_idx;
      break;
    case 2:
      idx_array = human_unit_idx;
      break;
    case 3:
      idx_array = orc_unit_idx;
      break;
  }

  for (idx=0 ; idx_array[idx] != -1 ; idx++)
  {
    GtkWidget *gtk_pixmap, *list_item, *item_vbox, *item_name;
    gchar *filename;

    i = idx_array[idx];
/*    gtk_progress_set_value(GTK_PROGRESS(progressbar), (gfloat)i/(nb_unit_types-1.0));*/
    while (gtk_events_pending())
      gtk_main_iteration();

    for (j=0; pathes[j]; ++j)
    {
      filename = g_strdup_printf("%s/%s/%s", data_path, pathes[j],
                                 default_unit_types[i].filename);
      if (!access(filename, F_OK))
      {
        default_unit_types[i].graphic = load_graphic_PNG_with_size(filename,
                                                                   default_unit_types[i].width,
                                                                   default_unit_types[i].height);
        g_free(filename);
        break;
      } else
        g_free(filename);
      filename = g_strdup_printf("%s/%s/%s", data_path, pathes[j],
                                 default_unit_types[i].filename2);
      if (!access(filename, F_OK))
      {
        default_unit_types[i].graphic = load_graphic_PNG_with_size(filename,
                                                                   default_unit_types[i].width,
                                                                   default_unit_types[i].height);
        g_free(filename);
        break;
      } else
        g_free(filename);
    }
    if (!pathes[j])
      g_message("cannot load %s\n", default_unit_types[i].filename);
    if (default_unit_types[i].graphic)
    {
      GdkPixmap *gdk_pixmap, *gdk_mask;
      GdkGC *gc;

      gdk_pixmap = gdk_pixmap_new(drawing_area->window,
                                  default_unit_types[i].width,
                                  default_unit_types[i].height, -1);
      gdk_window_copy_area(gdk_pixmap, drawing_area->style->white_gc,
                           0, 0, default_unit_types[i].graphic[0]->pixmap,
                           0, 0,
                           default_unit_types[i].width,
                           default_unit_types[i].height);
      gdk_mask = gdk_pixmap_new(default_unit_types[i].graphic[0]->mask,
                                default_unit_types[i].width,
                                default_unit_types[i].height, 1);
      gc = gdk_gc_new(gdk_mask);
      gdk_window_copy_area(gdk_mask, gc,
                           0, 0, default_unit_types[i].graphic[0]->mask,
                           0, 0,
                           default_unit_types[i].width,
                           default_unit_types[i].height);

      gtk_pixmap = gtk_pixmap_new(gdk_pixmap, gdk_mask);
      gdk_pixmap_unref(gdk_pixmap);
      gdk_pixmap_unref(gdk_mask);
      gdk_gc_destroy(gc);

      list_item = gtk_list_item_new();
      item_vbox = gtk_vbox_new(FALSE, 0);
      gtk_container_add(GTK_CONTAINER(list_item), item_vbox);
      gtk_widget_show(item_vbox);
      gtk_box_pack_start_defaults(GTK_BOX(item_vbox), gtk_pixmap);
      gtk_widget_show(gtk_pixmap);
      item_name = gtk_label_new(default_unit_types[i].name);
      gtk_box_pack_start_defaults(GTK_BOX(item_vbox), item_name);
      gtk_widget_show(item_name);
      gtk_widget_show(list_item);
      gtk_object_set_data(GTK_OBJECT(list_item), "idx", GINT_TO_POINTER(i));
      unit_list_items = g_list_append(unit_list_items, list_item);
    }
  }
  gtk_list_append_items(GTK_LIST(gtklist), unit_list_items);
  gtk_list_select_item(GTK_LIST(gtklist), 0);
}

