"=====================================================================
" cream-autocmd.vim
"
" Cream -- An easy-to-use configuration of the famous Vim text editor
" [ http://cream.sourceforge.net ] Copyright (C) 2002-2004  Steve Hall
" 
" License:
" This program is free software; you can redistribute it and/or modify
" it under the terms of the GNU General Public License as published by
" the Free Software Foundation; either version 2 of the License, or
" (at your option) any later version.
" [ http://www.gnu.org/licenses/gpl.html ]
" 
" This program is distributed in the hope that it will be useful, but
" WITHOUT ANY WARRANTY; without even the implied warranty of
" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
" General Public License for more details.
" 
" You should have received a copy of the GNU General Public License
" along with this program; if not, write to the Free Software
" Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
" 02111-1307, USA.
"

" Description:
" These are the Vim events Cream uses to act on

" behavior (Cream/CreamLite/Vim/Vi) {{{1
" * Note that this is called only for the condition that the over-ride
"   setting in cream-conf differs from default "cream". Isn't it
"   ironic that neither Vim nor Vi settings can retain this. ;)

autocmd VimEnter * call Cream_behave_init()

" single server {{{1

autocmd VimEnter * call Cream_singleserver_init()
autocmd VimEnter * call Cream_singleserver()

" initialize (fix vars, etc.) {{{1
autocmd VimEnter * call Cream_start()

" conf  {{{1
" (testing for existance checks if even available)
if exists("*Cream_conf_override")
	autocmd BufEnter * call Cream_conf_override()
endif

" lib {{{1

" fix version 6.0 hang in normal mode...
autocmd BufEnter * call Cream_bufenter_fix()

" helps if user exits via window manager close function
augroup CreamExit
	autocmd!
	autocmd VimLeavePre * call Cream_exit()
augroup END

" path and filename {{{1

autocmd BufEnter,BufWritePost * call Cream_buffer_pathfile()

" menus {{{1

" Toolbar
if has("gui_running")
	autocmd VimEnter * call Cream_toolbar_init()
endif

" Developer menu
if exists("g:cream_dev")
	autocmd VimEnter * call Cream_menu_devel()
endif
" Settings
autocmd VimEnter * call Cream_menu_settings()
" Colors
autocmd VimEnter * call Cream_menu_colors()

" Most recent used (MRU)
autocmd VimEnter * call MRUInitialize()
autocmd BufEnter * call MRUAddToList()

" Settings.Filetype
autocmd VimEnter * call Cream_menu_settings_filetypes()

"...................................
" Window.Buffer menu
" Notes:
" o Vim's default Buffers menu needs to be hidden because is is run
"   via autocmd. Two options:
"
"     if has("vim_starting")
"         augroup LoadBufferMenu
"             autocmd! VimEnter * if !exists("no_buffers_menu") | call BMShow() | endif
"             autocmd  VimEnter * autocmd! LoadBufferMenu
"         augroup END
"     endif
"
"   or

let no_buffers_menu = 1

" o BMShow() contains an autocmd group which handles most Events. It
"   is re-defined each operation, thus it's more logical there.
" o Only one global autocmd is required, this to fire the whole thing
"   off:

autocmd VimEnter * call BMShow()

" o We are unable to react when an unnamed buffer becomes modified
"   since Vim has no event for this.
"...................................

" filetype and syntax highlighting {{{1

" first buffer isn't detected
autocmd VimEnter * filetype detect
" re-detect new or changed buffers
autocmd VimEnter,BufEnter,FileType * call Cream_filetype()

"" detect on VimEnter so dependencies can know filetype
"autocmd VimEnter,BufEnter,FileType * call Cream_filetype()

"autocmd VimEnter,BufEnter,FileType,BufNewFile * call Cream_filetype()
"" add cream-specific improvements for some filetypes
"autocmd FileType * call Cream_filetype_setup()

" syntax highlighting (must follow filetype detection)
autocmd VimEnter * call Cream_syntax_init()


" settings {{{1

" view load
autocmd BufRead * loadview
" view save
autocmd BufWrite * mkview

autocmd BufEnter,BufNewFile * call Cream_autoindent_init()
autocmd BufEnter,BufNewFile * call Cream_tabstop_init()
autocmd BufEnter,BufNewFile * call Cream_wrap_init()
autocmd BufEnter,BufNewFile * call Cream_autowrap_init()

autocmd VimEnter,BufNew * call Cream_expandtab_init()

autocmd VimEnter,BufNew * call Cream_linenumbers_init()

" remember last status of line numbers in buffer
" need to initialize on event BufferEnter, BufferNew
"autocmd BufLeave * call Cream_linenumbers_exit()

autocmd BufNewFile,BufEnter * call Cream_search_highlight_init()

" printer settings
autocmd VimEnter * call Cream_print_init()

" window titling
autocmd VimEnter * call Cream_titletext_init()

" show invisibles (list)
autocmd BufNewFile,BufEnter * call Cream_list_init()

" keymap
autocmd VimEnter * call Cream_keymap_init()

" current working directory
if exists("g:CREAM_CWD")
    autocmd VimEnter,BufEnter * call Cream_cwd()
endif

" colors {{{1
autocmd VimEnter * call Cream_colors()

" GTK1 seems to have trouble remembering these across buffers...
autocmd VimEnter * call Cream_colors_selection()


" gui {{{1

" must preceed Cream_screen_init()
if has("gui")
autocmd VimEnter * call Cream_font_init()
endif

if has("gui")
autocmd VimEnter * call Cream_winpos_init()
endif

if has("gui")
autocmd VimEnter * call Cream_screen_init()
endif

" errorbells (must occur after GUI starts)
autocmd VimEnter * call Cream_errorbells_off()

" features {{{1

" bookmarks
autocmd VimEnter,BufEnter * call Cream_ShowMarks()

" fold, open current
autocmd VimEnter * call Cream_fold_init()

" middle mouse button behavior
autocmd VimEnter * call Cream_mouse_middle_init()

" current line highlighting
autocmd VimEnter,BufEnter * call Cream_highlight_currentline()

" spell check
autocmd VimEnter * call Cream_spell_init()
" auto-correct (abbreviations)
autocmd VimEnter * call Cream_autocorrect_init()

" expertmode
autocmd VimEnter * call Cream_expertmode_init()

" calendar
autocmd VimEnter * call Cream_calendar_init()

" auto-popup
autocmd VimEnter * call Cream_pop_init()

" bracket match flashing
autocmd VimEnter * call Cream_bracketmatch_init()

" diff updating
autocmd BufEnter,BufWritePost * call Cream_diffmode_update()


" user location {{{1
" Note: This is placed penultimatly here so it over-rides all prior
" except addons. This enables the alphabetical menuization of user
" addons with the default addons.
autocmd VimEnter * call Cream_load_user()

" add-ons {{{1

autocmd VimEnter * call Cream_addon_loadall()
autocmd VimEnter * call Cream_addon_menu()
autocmd VimEnter * call Cream_addon_maps_init()

" 1}}}
" vim:foldmethod=marker
