"
" cream-menu-settings.vim
"
" Cream -- An easy-to-use configuration of the famous Vim text editor
" [ http://cream.sourceforge.net ] Copyright (C) 2001-2006  Steve Hall
"
" License:
" This program is free software; you can redistribute it and/or modify
" it under the terms of the GNU General Public License as published by
" the Free Software Foundation; either version 2 of the License, or
" (at your option) any later version.
" [ http://www.gnu.org/licenses/gpl.html ]
"
" This program is distributed in the hope that it will be useful, but
" WITHOUT ANY WARRANTY; without even the implied warranty of
" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
" General Public License for more details.
"
" You should have received a copy of the GNU General Public License
" along with this program; if not, write to the Free Software
" Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
" 02111-1307, USA.

function! Cream_menu_settings()
" functionalized so we can toggle texts based on state

	" remove menu and restore
	silent! unmenu &Settings
	silent! unmenu! &Settings

	" status check mark (GTK2)
	if has("gui_gtk2") && &encoding == "utf8" || &encoding == "utf-8"
		"let on = nr2char("0x221a")	" √
		let on = nr2char("0x2713")	" ✓
		"let on = nr2char("0x2714")	" ✔ 
	else
		let on = nr2char(215)
	endif

	" Main Menu {{{1

    " NOTE: Do NOT add status checks to toggles, it would require the
    "       Settings menu to be refreshed for each toggle!

	" invisibles
		imenu <silent> 60.101 &Settings.&Show/Hide\ Invisibles<Tab>F4   <C-o>:call Cream_list_toggle("i")<CR>
		vmenu <silent> 60.102 &Settings.&Show/Hide\ Invisibles<Tab>F4   :<C-u>call Cream_list_toggle("v")<CR>
	anoremenu <silent> 60.103 &Settings.Line\ &Numbers\ (toggle)			:call Cream_linenumbers_toggle()<CR>

	" wrap
	anoremenu <silent> 60.104 &Settings.-SEP104-							<Nul>
	anoremenu <silent> 60.105 &Settings.&Word\ Wrap\ (toggle)<Tab>Ctrl+W	:call Cream_wrap("i")<CR>
	anoremenu <silent> 60.106 &Settings.A&uto\ Wrap\ (toggle)<Tab>Ctrl+E	:call Cream_autowrap("i")<CR>
	anoremenu <silent> 60.107 &Settings.&Set\ Wrap\ Width\.\.\.				:call Cream_autowrap_setwidth()<CR>
		imenu <silent> 60.108 &Settings.&Highlight\ Wrap\ Width\ (toggle)	<C-o>:call Cream_highlight_columns(g:CREAM_AUTOWRAP_WIDTH)<CR>
		vmenu <silent> 60.109 &Settings.&Highlight\ Wrap\ Width\ (toggle)	:<C-u>call Cream_highlight_columns(g:CREAM_AUTOWRAP_WIDTH)<CR>

	" tabs
	anoremenu <silent> 60.111 &Settings.-SEP111-							<Nul>
	anoremenu <silent> 60.112 &Settings.&Tabstop\ Width\.\.\.				:call Cream_tabstop()<CR>
	anoremenu <silent> 60.113 &Settings.Soft\ Ta&bstop\ Width\.\.\.			:call Cream_softtabstop()<CR>
		imenu <silent> 60.114 &Settings.Tab\ &Expansion\ (toggle)<Tab>Ctrl+T	<C-o>:call Cream_expandtab_toggle("i")<CR>
		vmenu <silent> 60.115 &Settings.Tab\ &Expansion\ (toggle)<Tab>Ctrl+T	:<C-u>call Cream_expandtab_toggle("v")<CR>
	anoremenu <silent> 60.116 &Settings.&Auto-indent\ (toggle)				:call Cream_autoindent_toggle()<CR>

	" syntax/highlighting
	anoremenu <silent> 60.121 &Settings.-SEP116-							<Nul>
	anoremenu <silent> 60.122 &Settings.Highlight\ Find\ (toggle)			:call Cream_search_highlight_toggle()<CR>
	anoremenu <silent> 60.123 &Settings.Highlight\ Current\ Line\ (toggle)	:call Cream_highlight_currentline_toggle()<CR>
		imenu <silent> 60.124 &Settings.Syntax\ Highlighting\ (toggle)		<C-o>:call Cream_syntax_toggle("i")<CR>
		vmenu <silent> 60.125 &Settings.Syntax\ Highlighting\ (toggle)		:<C-u>call Cream_syntax_toggle("v")<CR>


	" Filetypes {{{1

	"""function! Cream_menu_settings_filetypes()
	"""" *** called via VimEnter command on startup, so filetypes_list() is available ***
	"""" "menu-izes" the aviable filetypes
	"""
	"""    let idx = 200
	"""    execute "anoremenu \<silent> 60." . idx . " &Settings.-SEP200-  \<Nul>"
	"""    let idx = idx + 1
	"""
	"""    let myfiletypes = Cream_vim_syntax_list() . "\n"
	"""    "let myfiletypes = Cream_get_filetypes() . "\n"
	"""    " use destructive process, multvals too slow
	"""    let i = 0	" itteration index
	"""    while myfiletypes != ""
	"""        let pos = stridx(myfiletypes, "\n")
	"""        let myitem = strpart(myfiletypes, 0, pos)
	"""        let myfiletypes = strpart(myfiletypes, pos + 1)
	"""
	"""        let letters = "[" . toupper(myitem[0]) . "]"
	"""
	"""        let command = "anoremenu \<silent> 60." . (i + idx) . " &Settings.&Filetype." . letters . "." . myitem . "  :call Cream_filetype(\"" . myitem . "\")\<CR>"
	"""
	"""        execute command
	"""
	"""        let i = i + 1
	"""    endwhile
	"""
	"""endfunction

	" TODO: Experimentation with caching filetype menu and loading it
	" only when the user requests it.
	anoremenu <silent> 60.200 &Settings.-SEP200-  <Nul>

	function! Cream_menu_filetypes_init()
	" Initialize Filetypes submenu if cache exists.
		let myfile = g:cream_user . "menu-filetype.vim"
		" load if exists
		if filereadable(myfile)
			call Cream_source(myfile)
			anoremenu <silent> 60.298 &Settings.&Filetype.-SEP298-  <Nul>
			anoremenu <silent> 60.299 &Settings.&Filetype.Re-fresh\ Available\ Filetypes\.\.\.  :call Cream_menu_filetypes("refresh")<CR>
		else
			anoremenu <silent> 60.201 &Settings.&Filetype.Menu\ the\ Available\ Filetypes\.\.\.  :call Cream_menu_filetypes()<CR>
		endif
	endfunction
	call Cream_menu_filetypes_init()

	function! Cream_menu_filetypes(...)
	" Filetype submenu when user requests, either initially or to re-fresh.
	"
	" Notes:
	" o Called via VimEnter command on startup, so filetypes_list() is
	"   available! (We parse autocmds.)
	" o This submenu optimized for speed. Parsing each
	"   time is slow, so we cache it in g:cream_user / menu-filetype.vim.
	"   The function below creates the cache if it doesn't exist and then
	"   loads the menu from it.

		let myfile = g:cream_user . "menu-filetype.vim"

		" reasons to re-cache
		" 1. arg is "refresh"
		if a:0 > 0 && a:1 == "refresh"
			let flag = 1
		endif
		" 2. every 10 times used
		let mytime = localtime()
		if mytime[9] == "9"
			let flag = 1
		endif
		" delete cache
		if exists("flag")
			call delete(myfile)
		endif

		" cache if doesn't exist
		if !filereadable(myfile)
			call Cream_menu_filetypes_cache()
		endif
		" remove any existing submenu
		silent! unmenu &Settings.&Filetype
		silent! unmenu! &Settings.&Filetype
		" load
		anoremenu <silent> 60.298 &Settings.&Filetype.-SEP298-  <Nul>
		anoremenu <silent> 60.299 &Settings.&Filetype.Re-fresh\ Available\ Filetypes\.\.\.  :call Cream_menu_filetypes("refresh")<CR>
		call Cream_source(myfile)

	endfunction

	function! Cream_menu_filetypes_cache()
	" Re/creates filetype menu cache, overwriting any existing.

		let @x = ""
		let i = 0
		let idx = 203
		let myfts = Cream_vim_syntax_list() . "\n"
		" use destructive process, multvals too slow
		while myfts != ""
			let pos = stridx(myfts, "\n")
			let myitem = strpart(myfts, 0, pos)
			let myfts = strpart(myfts, pos + 1)

			let letters = "[" . toupper(myitem[0]) . "]"
			let @x = @x . "anoremenu \<silent> 60." . (i + idx) . " &Settings.&Filetype." . letters . "." . myitem . '  :call Cream_filetype("' . myitem . '")<CR>' . "\n"

			let i = i + 1
		endwhile

		" TODO: Fix windowing mistakes inherant in this...

		" mark place
		let mypos = Cream_pos()

		" TODO: use Vim7 to write var to file.
		" open temp buffer
		silent! enew
		silent! put x
		" save as
		silent! execute "silent! write! " . g:cream_user . "menu-filetype.vim"
		" close buffer
		silent! bwipeout!

		" return
		execute mypos

		call confirm(
		\ "Settings > Filetype menu filled.\n" .
		\ "\n", "&Ok", 1, "Info")

	endfunction

	" Preferences {{{1
	anoremenu <silent> 60.9000 &Settings.-Sep9000-		<Nul>

	if has("gui")
	anoremenu <silent> 60.9001 &Settings.P&references.Font\.\.\.	    			:call Cream_font_set()<CR>
	endif
	anoremenu <silent> 60.9002 &Settings.P&references.Toolbar\ (toggle)				:call Cream_toolbar()<CR>

	" Preferences, Color {{{2

	if has("gui")

		" color themes, selection
		anoremenu <silent> 60.9100 &Settings.P&references.-SEP9100-								<Nul>
		anoremenu <silent> 60.9101 &Settings.P&references.&Color\ Themes.Selection.Reverse\ Black\ (default)	:call Cream_colors_selection("reverseblack")<CR>
		anoremenu <silent> 60.9102 &Settings.P&references.&Color\ Themes.Selection.Reverse\ Blue	:call Cream_colors_selection("reverseblue")<CR>
		anoremenu <silent> 60.9103 &Settings.P&references.&Color\ Themes.Selection.Terminal		:call Cream_colors_selection("terminal")<CR>
		anoremenu <silent> 60.9104 &Settings.P&references.&Color\ Themes.Selection.Navajo			:call Cream_colors_selection("navajo")<CR>
		anoremenu <silent> 60.9105 &Settings.P&references.&Color\ Themes.Selection.Navajo-Night	:call Cream_colors_selection("navajo-night")<CR>
		anoremenu <silent> 60.9106 &Settings.P&references.&Color\ Themes.Selection.Night			:call Cream_colors_selection("night")<CR>
		anoremenu <silent> 60.9107 &Settings.P&references.&Color\ Themes.Selection.Vim			:call Cream_colors_selection("vim")<CR>
		anoremenu <silent> 60.9108 &Settings.P&references.&Color\ Themes.Selection.Magenta		:call Cream_colors_selection("magenta")<CR>

		if exists("g:cream_dev")
			" experimental
			anoremenu <silent> 60.9110 &Settings.P&references.&Color\ Themes.Selection.-Sep9110-		<Nul>
			anoremenu <silent> 60.9111 &Settings.P&references.&Color\ Themes.Selection.(experimental\ below)	<Nul>
			anoremenu <silent> 60.9112 &Settings.P&references.&Color\ Themes.Selection.-Sep9112-		<Nul>
			anoremenu <silent> 60.9113 &Settings.P&references.&Color\ Themes.Selection.Lt\.\ Magenta	:call Cream_colors_selection("ltmagenta")<CR>
			anoremenu <silent> 60.9114 &Settings.P&references.&Color\ Themes.Selection.Dk\.\ Magenta	:call Cream_colors_selection("dkmagenta")<CR>
			anoremenu <silent> 60.9115 &Settings.P&references.&Color\ Themes.Selection.Magenta		:call Cream_colors_selection("magenta")<CR>
			anoremenu <silent> 60.9116 &Settings.P&references.&Color\ Themes.Selection.Blue			:call Cream_colors_selection("blue")<CR>
			anoremenu <silent> 60.9117 &Settings.P&references.&Color\ Themes.Selection.Orange			:call Cream_colors_selection("orange")<CR>
			anoremenu <silent> 60.9118 &Settings.P&references.&Color\ Themes.Selection.Green			:call Cream_colors_selection("green")<CR>
			anoremenu <silent> 60.9119 &Settings.P&references.&Color\ Themes.Selection.Gold			:call Cream_colors_selection("gold")<CR>
			anoremenu <silent> 60.9120 &Settings.P&references.&Color\ Themes.Selection.Purple			:call Cream_colors_selection("purple")<CR>
			anoremenu <silent> 60.9121 &Settings.P&references.&Color\ Themes.Selection.Wheat			:call Cream_colors_selection("wheat")<CR>
		endif

		" color schemes (Cream)
		anoremenu <silent> 60.9140 &Settings.P&references.&Color\ Themes.-SEP9140-				<Nul>
		anoremenu <silent> 60.9141 &Settings.P&references.&Color\ Themes.Cream\ (default)		:call Cream_colors("cream")<CR>
		anoremenu <silent> 60.9142 &Settings.P&references.&Color\ Themes.Black\ and\ White	:call Cream_colors("blackwhite")<CR>
		anoremenu <silent> 60.9143 &Settings.P&references.&Color\ Themes.Chocolate\ Liquor	:call Cream_colors("chocolateliquor")<CR>
		anoremenu <silent> 60.9144 &Settings.P&references.&Color\ Themes.Dawn					:call Cream_colors("dawn")<CR>
		anoremenu <silent> 60.9145 &Settings.P&references.&Color\ Themes.Inkpot				:call Cream_colors("inkpot")<CR>
		anoremenu <silent> 60.9145 &Settings.P&references.&Color\ Themes.Navajo				:call Cream_colors("navajo")<CR>
		anoremenu <silent> 60.9146 &Settings.P&references.&Color\ Themes.Navajo-Night			:call Cream_colors("navajo-night")<CR>
		anoremenu <silent> 60.9147 &Settings.P&references.&Color\ Themes.Night				:call Cream_colors("night")<CR>
		anoremenu <silent> 60.9148 &Settings.P&references.&Color\ Themes.Ocean\ Deep			:call Cream_colors("oceandeep")<CR>
		anoremenu <silent> 60.9149 &Settings.P&references.&Color\ Themes.Terminal\ (reverse)	:call Cream_colors("terminal")<CR>
		anoremenu <silent> 60.9150 &Settings.P&references.&Color\ Themes.Zenburn				:call Cream_colors("zenburn")<CR>

		function! Cream_menu_colors()
		" color schemes (Vim's only! Ours are specifically "menu-ized" ;)
		" * This function is called via VimEnter autocmd so multvals is available.

			" this should be dev-only!
			if !exists("g:cream_dev")
				return
			else
				anoremenu <silent> 60.9159 &Settings.P&references.&Color\ Themes.-SEP9159-				<Nul>
				"anoremenu <silent> 60.9160 &Settings.P&references.&Color\ Themes.gVim\ themes\ (non-Cream):	<Nul>
			endif

			let mycolors = globpath(&runtimepath, "colors/*.vim")
			if strlen(mycolors) > 0
				let mycolors = mycolors . "\n"
			endif

			" menu each item
			let idx = 9180
			let i = 0
			while i < MvNumberOfElements(mycolors, "\n")

				let mycolor = MvElementAt(mycolors, "\n", i)

				" name doesn't have path
				let mycolor = substitute(mycolor, '.*[/\\:]\([^/\\:]*\)\.vim', '\1', '')
				execute "anoremenu <silent> 60." . idx . ' &Settings.P&references.&Color\ Themes.gVim\ themes\ (non-Cream).' . mycolor . " :colors " . mycolor . "\<CR>"

				let i = i + 1
			endwhile

		endfunction
		"" load on re-sets, not startup (multvals isn't avialable)
		"call Cream_menu_colors()

	endif
	" 2}}}

	" Syntax highlighting (removed)
	" * By default, add's a root "Syntax" menu when turned to manual.
	" * On/Off control is disabled because of the dependence other
	"   features have on it. (See the ToDo doc.)
	" * Should JustWork(tm). Why do we need control options?


	anoremenu <silent> 60.9310 &Settings.P&references.-Sep9310-		<Nul>
	if !exists("g:CREAM_LAST_BUFFER_FORGET") || g:CREAM_LAST_BUFFER_FORGET == 0
		execute 'anoremenu <silent> 60.9311 &Settings.P&references.' . on . '\ Last\ File\ Restore	:call Cream_last_buffer_toggle()<CR>'
	else
		execute 'anoremenu <silent> 60.9311 &Settings.P&references.' .  '\ \ \ Last\ File\ Restore	:call Cream_last_buffer_toggle()<CR>'
	endif
	if exists("g:CREAM_SINGLESERVER") && g:CREAM_SINGLESERVER == 1
		execute 'anoremenu <silent> 60.9312 &Settings.P&references.' . on . '\ &Single-Session\ Mode	:call Cream_singleserver_toggle()<CR>'
	else
		execute 'anoremenu <silent> 60.9312 &Settings.P&references.' .  '\ \ \ &Single-Session\ Mode	:call Cream_singleserver_toggle()<CR>'
	endif
	if exists("g:CREAM_WINPOS") && g:CREAM_WINPOS == 1
		execute 'anoremenu <silent> 60.9313 &Settings.P&references.' . on . '\ Remember\ Window\ Position	:call Cream_winpos_toggle()<CR>'
	else
		execute 'anoremenu <silent> 60.9313 &Settings.P&references.' .  '\ \ \ Remember\ Window\ Position	:call Cream_winpos_toggle()<CR>'
	endif

	if exists("g:CREAM_MOUSE_XSTYLE") && g:CREAM_MOUSE_XSTYLE == 1
		execute 'anoremenu <silent> 60.9321 &Settings.P&references.' . on . '\ &Middle-Mouse\ Pastes	:call Cream_mouse_middle_toggle()<CR>'
	else
		execute 'anoremenu <silent> 60.9321 &Settings.P&references.' .  '\ \ \ &Middle-Mouse\ Pastes	:call Cream_mouse_middle_toggle()<CR>'
	endif

	if exists("g:CREAM_BRACKETMATCH") && g:CREAM_BRACKETMATCH == 1
		execute 'anoremenu <silent> 60.9322 &Settings.P&references.' . on . '\ Bracket\ Flashing	:call Cream_bracketmatch_toggle()<CR>'
	else
		execute 'anoremenu <silent> 60.9322 &Settings.P&references.' .  '\ \ \ Bracket\ Flashing	:call Cream_bracketmatch_toggle()<CR>'
	endif
	anoremenu <silent> 60.9323 &Settings.P&references.-Sep9320-		<Nul>
	anoremenu <silent> 60.9324 &Settings.P&references.Info\ Pop\ Options\.\.\.		:call Cream_pop_options()<CR>


	" language
	anoremenu <silent> 60.9400 &Settings.P&references.-Sep940-	<Nul>
	anoremenu <silent> 60.9401 &Settings.P&references.Language\.\.\.\ (Future)			<Nop>


	" Keymap {{{1

	if has("keymap")

		" get vim's list
		let maps = Cream_getfilelist($VIMRUNTIME . "/keymap/*.vim")
		if maps != ""

			" none
			if exists("g:CREAM_KEYMAP") && g:CREAM_KEYMAP == ""
				execute 'anoremenu <silent> 60.9502 &Settings.P&references.&Keymap.' . on . '\ None :call Cream_keymap("")<CR>'
			else
				execute 'anoremenu <silent> 60.9502 &Settings.P&references.&Keymap.' .  '\ \ \ None :call Cream_keymap("")<CR>'
			endif
			" other
			let cnt = MvNumberOfElements(maps, "\n")
			let i = 0
			while i < cnt
				let mapp = MvElementAt(maps, "\n", i)
				let mapp = matchstr(mapp, 'keymap/\zs.*\ze\.vim')
				" cat string
				let idx = i
				while strlen(idx) < 2
					let idx = "0" . idx
				endwhile
				if exists("g:CREAM_KEYMAP") && g:CREAM_KEYMAP == mapp
					" if this map is active
					execute 'anoremenu <silent> 60.95' . idx . ' &Settings.P&references.&Keymap.' . on . '\ ' . mapp . ' :call Cream_keymap("' . mapp . '")<CR>'
				else
					" if this map isn't
					execute 'anoremenu <silent> 60.95' . idx . ' &Settings.P&references.&Keymap.' .  '\ \ \ ' . mapp . ' :call Cream_keymap("' . mapp . '")<CR>'
				endif
				let i = i + 1
			endwhile

		endif

	endif

	"......................................................................

	anoremenu <silent> 60.9600 &Settings.P&references.-Sep920-	<Nul>

	" Expert mode
	anoremenu <silent> 60.9900 &Settings.P&references.&Expert\ Mode\.\.\.			:call Cream_expertmode_toggle()<CR>
	" Behavior
	anoremenu <silent> 60.9910 &Settings.P&references.&Behavior.&Cream\ (default)	:call Cream_behave_cream()<CR>
	anoremenu <silent> 60.9920 &Settings.P&references.&Behavior.&Cream\ Lite\.\.\.	:call Cream_behave_creamlite()<CR>
	anoremenu <silent> 60.9930 &Settings.P&references.&Behavior.&Vim\.\.\.			:call Cream_behave_vim()<CR>
	anoremenu <silent> 60.9940 &Settings.P&references.&Behavior.&Vi\.\.\.			:call Cream_behave_vi()<CR>


endfunction
call Cream_menu_settings()

" 1}}}
" vim:foldmethod=marker
