/* cfed -- a level editor for Crimson Fields
   Copyright (C) 2000-2003 Jens Granseuer

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/* editor.h */

#include "SDL_endian.h"		/* used for endianness detection */

#define MakeID(a,b,c,d)		((a)|((b)<<8)|((c)<<16)|((d)<<24))
#define FID_UNITSET		MakeID('U','S','E','T')
#define FID_TILESET		MakeID('T','S','E','T')

#define MAX_MAP_WIDTH	250
#define MAX_MAP_HEIGHT	250

#define MODE_NONE	0
#define MODE_MAP	1
#define MODE_UNIT	2
#define MODE_GAME	3
#define MODE_BUILDING	4
#define MODE_EVENT	5
#define MODE_PLAYER	6

#define HAVE_NONE	0
#define HAVE_MAP	(1<<MODE_MAP)
#define HAVE_UNIT	(1<<MODE_UNIT)
#define HAVE_GAME	(1<<MODE_GAME)
#define HAVE_BUILDING	(1<<MODE_BUILDING)
#define HAVE_EVENT	(1<<MODE_EVENT)
#define HAVE_PLAYER	(1<<MODE_PLAYER)

/* structures */

struct Point {
  short x;
  short y;
};

struct UnitType {
  unsigned short ut_terrain;		/* wherever it may roam... */
  unsigned short ut_image;
  unsigned short ut_flags;
  unsigned char ut_moves;
  unsigned char ut_weight;		/* used by transports */
  unsigned char ut_defence;		/* defensive strength */
  unsigned char ut_pow_ground;		/* offensive strengths */
  unsigned char ut_pow_ship;
  unsigned char ut_pow_air;
  unsigned char ut_min_range_ground;
  unsigned char ut_max_range_ground;
  unsigned char ut_min_range_ship;
  unsigned char ut_max_range_ship;
  unsigned char ut_min_range_air;
  unsigned char ut_max_range_air;
  unsigned char ut_build;		/* resources needed to build this unit type */
  unsigned char ut_snd_move;		/* movement sound (255 == none) */
  unsigned char ut_snd_fire;		/* shoot sound (255 == none) */
  unsigned char ut_trans_slots;		/* number of transport slots */
  unsigned char ut_trans_min_weight;	/* min weight the transport can carry */
  unsigned char ut_trans_max_weight;	/* max weight the transport can carry */
  unsigned char ut_typeid;
  signed char ut_portrait;		/* unit image index for the unit info dialog (-1 == none) */
  char ut_name[20];
};

struct Unit {
  struct Point u_pos;		/* position on map */
  unsigned long u_flags;
  unsigned short u_id;
  
  unsigned char u_moves;
  unsigned char u_facing;	/* direction */
  unsigned char u_group;	/* group size */
  unsigned char u_xp;		/* experience */
  unsigned char u_pid;		/* player id */
  unsigned char u_utype;

  unsigned short u_crystals;	/* only used for transports */
  struct Point u_target;
};

struct Building {
  struct Point b_pos;
  unsigned short b_id;
  unsigned short b_flags;

  unsigned short b_crystals;
  unsigned short b_maxcrystals;

  unsigned long b_unitprod;

  unsigned char b_crystalprod;
  unsigned char b_player;
  unsigned char b_minweight;
  unsigned char b_maxweight;
  char b_name[20];
};

struct Event {
  unsigned char e_id;
  unsigned char e_type;
  unsigned char e_trigger;
  signed char e_depend;
  short e_tdata[3];		/* trigger data */
  short e_data[3];		/* event data */
  short e_title;
  short e_message;
  unsigned short e_flags;
  unsigned char e_player;
};

struct Player {
  unsigned char p_id;
  unsigned char p_level;
  unsigned char p_success;
  signed char p_briefing;
  char p_name[16];
  char p_password[8];
};

struct GameInfo {
  unsigned long file_id;       /* always FID_MISSION */
  unsigned char version;
  signed char level_info_str;
  signed char next_map_str;
  unsigned short flags;
  char password[8];

  unsigned short num_units;
  unsigned short num_buildings;
  unsigned short num_combatrecords;
  unsigned short num_events;
  unsigned short num_texts;
  unsigned long text_length;

  unsigned short map_width;
  unsigned short map_height;
  unsigned short turn;
  unsigned char current_player;
  unsigned char phase;
};

struct TerrainType {
  unsigned short tt_type;       /* one (or more) of the TT_ defined above */
  unsigned short tt_image;
  signed char tt_att_mod;       /* attack modifier (percent) */
  signed char tt_def_mod;       /* defence modifier (percent) */
  signed char tt_move;          /* cost to cross hex type */
  char reserved;
  unsigned long tt_color;       /* color shown on the overview map display */
};

