/* mkdatafile -- create a Crimson Fields data file
   Copyright (C) 2000-2003 Jens Granseuer

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/* takes five file names: icons BMP, small font BMP, large font BMP, and output filename

   The data file is written in little-endian format.

   Creates a data file for Crimson Fields containing fonts and icons image data
*/

#include <stdio.h>
#include <stdlib.h>

#include "SDL.h"
#include "SDL_endian.h"

extern int save_image_data( const char *filename, int trans, SDL_RWops *out );

#define FONT_CAPS_ONLY	0x01

struct FontInfo {
  unsigned char w;
  unsigned char h;
  unsigned char chars;
  unsigned char flags;
};

int main( int argc, char *argv[] ) {
  int status;
  SDL_RWops *out;
  struct FontInfo font;
 
  if ( argc != 5 ) {
    fprintf(stderr, "Invalid number of arguments\n"
                    "Usage: %s <icons.bmp> <smallfont.bmp> <largefont.bmp> <outfile>\n",
                    argv[0] );
    exit(-1);
  }


  if ( SDL_Init(0) < 0 ) {
    fprintf(stderr, "Couldn't init SDL: %s\n", SDL_GetError());
    exit(-1);
  }
  atexit(SDL_Quit);

  out = SDL_RWFromFile( argv[4], "wb" );
  if ( !out ) {
    fprintf(stderr, "Couldn't open output file %s\n", argv[5] );
    exit(-1);
  }

  /* icons */
  status = save_image_data( argv[1], 1, out );
  if ( status ) goto error_exit;

  /* small font */
  font.w = 7; font.h = 12; font.chars = 90; font.flags = 0;
  SDL_RWwrite( out, (char *)&font, sizeof(struct FontInfo), 1 );
  status = save_image_data( argv[2], 1, out );
  if ( status ) goto error_exit;

  /* large font */
  font.w = 12; font.h = 14; font.chars = 64; font.flags = FONT_CAPS_ONLY;
  SDL_RWwrite( out, (char *)&font, sizeof(struct FontInfo), 1 );
  status = save_image_data( argv[3], 1, out );

error_exit:
  SDL_RWclose( out );
  return status;
}

