// CoMET - The Crimson Fields Map Editing Tool
// Copyright (C) 2002-2004 Jens Granseuer
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

//////////////////////////////////////////////////////////////////////
// edwidget.h - widgets used by the mission editor
//////////////////////////////////////////////////////////////////////

#ifndef _INCLUDE_EDWIDGET_H
#define _INCLUDE_EDWIDGET_H

#include "textbox.h" // for NumberWidget

class NumberWidget : public StringWidget, public InputValidator {
public:
  NumberWidget( short id, short x, short y, unsigned short w, unsigned short h,
                short number, short min, short max, unsigned short flags,
                const char *title, Window *window );
  bool ValidateKey( const char *str, unsigned short key,
                    unsigned short pos ) const;
  short Number( void ) const { return num; }
  void SetNumber( short number, bool upd = true );
  void SetMin( short min );
  void SetMax( short max );
  void Release( void );

private:
  short num;
  short minval;
  short maxval;
  char numbuf[8];
  char numbuf2[8];
};

#endif	// _INCLUDE_EDWIDGET_H

