/* Default tile set definitions for Crimson Fields
   Copyright (C) 2000-2004 Jens Granseuer

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/* default_tiles.c */

#include "ccompat.h"
#include "gamedefs.h"

const unsigned short NUM_TERRAIN_TYPES = 375;

const struct TerrainType TModels[] = {
  { TT_ENTRANCE,        9,   0,   0,  1,  0, 0x008a7664 },      /* 000 headquarters [player 1], north */
  { TT_ENTRANCE,       10,   0,   0,  1,  0, 0x008a7664 },      /* 001 headquarters [player 2], north */
  { TT_ENTRANCE,        8,   0,   0,  1,  0, 0x008a7664 },      /* 002 headquarters [neutral], north */
  { TT_ENTRANCE,       12,   0,   0,  1,  0, 0x008a7664 },      /* 003 headquarters [player 1], west */
  { TT_ENTRANCE,       13,   0,   0,  1,  0, 0x008a7664 },      /* 004 headquarters [player 2], west */
  { TT_ENTRANCE,       11,   0,   0,  1,  0, 0x008a7664 },      /* 005 headquarters [neutral], west */
  { TT_ENTRANCE,       15,   0,   0,  1,  0, 0x008a7664 },      /* 006 headquarters [player 1], east */
  { TT_ENTRANCE,       16,   0,   0,  1,  0, 0x008a7664 },      /* 007 headquarters [player 2], east */
  { TT_ENTRANCE,       14,   0,   0,  1,  0, 0x008a7664 },      /* 008 headquarters [neutral], east */
  { TT_ENTRANCE,       18,   0,   0,  1,  0, 0x008a7664 },      /* 009 depot [player 1], north */
  { TT_ENTRANCE,       19,   0,   0,  1,  0, 0x008a7664 },      /* 010 depot [player 2], north */
  { TT_ENTRANCE,       17,   0,   0,  1,  0, 0x008a7664 },      /* 011 depot [neutral], north */
  { TT_ENTRANCE,       36,   0,   0,  1,  0, 0x008a7664 },      /* 012 factory [player 1], north */
  { TT_ENTRANCE,       37,   0,   0,  1,  0, 0x008a7664 },      /* 013 factory [player 2], north */
  { TT_ENTRANCE,       35,   0,   0,  1,  0, 0x008a7664 },      /* 014 factory [neutral], north */
  { TT_ENTRANCE,       39,   0,   0,  1,  0, 0x008a7664 },      /* 015 factory [player 1], east */
  { TT_ENTRANCE,       40,   0,   0,  1,  0, 0x008a7664 },      /* 016 factory [player 2], east */
  { TT_ENTRANCE,       38,   0,   0,  1,  0, 0x008a7664 },      /* 017 factory [neutral], east */
  { TT_ENTRANCE,       42,   0,   0,  1,  0, 0x008a7664 },      /* 018 city [player 1] */
  { TT_ENTRANCE,       43,   0,   0,  1,  0, 0x008a7664 },      /* 019 city [player 2] */
  { TT_ENTRANCE,       41,   0,   0,  1,  0, 0x008a7664 },      /* 020 city [neutral] */
  { TT_KEEP_OFF,       21,   0,   0, -1,  0, 0x008a7664 },      /* 021 structure, north */
  { TT_KEEP_OFF,       20,   0,   0, -1,  0, 0x008a7664 },      /* 022 structure, west */
  { TT_KEEP_OFF,       23,   0,   0, -1,  0, 0x008a7664 },      /* 023 structure, east */
  { TT_KEEP_OFF,       22,   0,   0, -1,  0, 0x008a7664 },      /* 024 structure, south */
  { TT_KEEP_OFF,       34,   0,   0, -1,  0, 0x008a7664 },      /* 025 structure, center */
  { TT_KEEP_OFF,       44,   0,   0, -1,  0, 0x008a7664 },      /* 026 depot [under construction], north */
  { TT_KEEP_OFF,       46,   0,   0, -1,  0, 0x008a7664 },      /* 027 depot [under construction], west */
  { TT_KEEP_OFF,       47,   0,   0, -1,  0, 0x008a7664 },      /* 028 depot [under construction], east */
  { TT_KEEP_OFF,       45,   0,   0, -1,  0, 0x008a7664 },      /* 029 depot [under construction], south */
  { TT_PLAINS,         24,   0,   0,  2,  0, 0x005e8e34 },      /* 030 plains */
  { TT_PLAINS,         25,   1,   1,  2,  0, 0x005e8e34 },      /* 031 plains [slightly rugged] */
  { TT_PLAINS,         26,   0,   1,  2,  0, 0x005e8e34 },      /* 032 plains [moderately rugged] */
  { TT_PLAINS,         27,   2,   2,  2,  0, 0x0066721d },      /* 033 plains [rugged] */
  { TT_PLAINS,         28,   0,   0,  2,  0, 0x005e8e34 },      /* 034 plains [few pebbles] */
  { TT_PLAINS,         29,   0,   0,  2,  0, 0x005e8e34 },      /* 035 plains [pebbles] */
  { TT_PLAINS,         30,   2,   2,  2,  0, 0x0066721d },      /* 036 plains [rugged, few pebbles] */
  { TT_PLAINS,         31,   2,   2,  2,  0, 0x0066721d },      /* 037 plains [rugged, pebbles] */
  { TT_PLAINS,         32,   1,   0,  2,  0, 0x005e8e34 },      /* 038 plains [hilly] 1 */
  { TT_PLAINS,          1,   1,   0,  2,  0, 0x005e8e34 },      /* 039 plains [hilly] 2 */
  { TT_PLAINS,          1,   1,   0,  2,  0, 0x005e8e34 },      /* 040 plains [craters] 1 */
  { TT_PLAINS,          1,   1,   0,  2,  0, 0x005e8e34 },      /* 041 plains [craters] 2 */
  { TT_PLAINS,          1,   1,   0,  2,  0, 0x005e8e34 },      /* 042 plains [craters] 3 */
  { TT_KEEP_OFF,        1,   0,   0, -1,  0, 0x00000000 },      /* 043 reserved */
  { TT_KEEP_OFF,        1,   0,   0, -1,  0, 0x00000000 },      /* 044 reserved */
  { TT_KEEP_OFF,        1,   0,   0, -1,  0, 0x00000000 },      /* 045 reserved */
  { TT_PLAINS,          1,   0,   1,  2,  0, 0x005e8e34 },      /* 046 building [large house], north */
  { TT_PLAINS,          1,   0,   1,  2,  0, 0x005e8e34 },      /* 047 building [large house], west */
  { TT_PLAINS,          1,   0,   1,  2,  0, 0x005e8e34 },      /* 048 building [large house], east */
  { TT_PLAINS,          1,   0,   1,  2,  0, 0x005e8e34 },      /* 049 building [large house], south */
  { TT_KEEP_OFF,       66,   0,   1,  2,  0, 0x008a7664 },      /* 050 building [warehouse], north */
  { TT_KEEP_OFF,       65,   0,   1,  2,  0, 0x008a7664 },      /* 051 building [warehouse], west */
  { TT_KEEP_OFF,       67,   0,   1,  2,  0, 0x008a7664 },      /* 052 building [warehouse], south */
  { TT_PLAINS,         61,   0,   1,  2,  0, 0x005e8e34 },      /* 053 building [house] */
  { TT_PLAINS,         62,   0,   1,  2,  0, 0x005e8e34 },      /* 054 building [cottage] */
  { TT_PLAINS,         63,   0,   1,  2,  0, 0x005e8e34 },      /* 055 building [shed] */
  { TT_PLAINS,         64,   0,   1,  2,  0, 0x005e8e34 },      /* 056 building [silos] */
  { TT_PLAINS,         68,   0,   1,  2,  0, 0x00685919 },      /* 057 building [hangars] */
  { TT_PLAINS,         69,   0,   0,  2,  0, 0x00685919 },      /* 058 airstrip, north */
  { TT_PLAINS,         70,   0,   0,  2,  0, 0x00685919 },      /* 059 airstrip, south */
  { TT_ROAD,           71,   3,  -3,  1,  0, 0x00322204 },      /* 060 landing platform [small] */
  { TT_ROAD,          382,   3,  -3,  1,  0, 0x00322204 },      /* 061 landing platform [large], north */
  { TT_ROAD,          380,   3,  -3,  1,  0, 0x00322204 },      /* 062 landing platform [large], west */
  { TT_ROAD,          381,   3,  -3,  1,  0, 0x00322204 },      /* 063 landing platform [large], east */
  { TT_ROAD,          383,   3,  -3,  1,  0, 0x00322204 },      /* 064 landing platform [large], south */
  { TT_BARRICADES,     72,   3,   3,  3,  0, 0x0046701f },      /* 065 hill [small] 1 */
  { TT_BARRICADES,     73,   3,   3,  3,  0, 0x0046701f },      /* 066 hill [small] 2 */
  { TT_BARRICADES,     74,   4,   4,  3,  0, 0x0066721d },      /* 067 hill [small, rugged] */
  { TT_BARRICADES,     75,   3,   3,  3,  0, 0x0046701f },      /* 068 hill [medium], northwest */
  { TT_BARRICADES,     76,   3,   3,  3,  0, 0x0046701f },      /* 069 hill [medium], southeast */
  { TT_BARRICADES,     77,   3,   3,  3,  0, 0x0046701f },      /* 070 hill [large], west */
  { TT_BARRICADES,     79,   3,   3,  3,  0, 0x0046701f },      /* 071 hill [large], north */
  { TT_BARRICADES,     78,   3,   3,  3,  0, 0x0046701f },      /* 072 hill [large], east */
  { TT_BARRICADES,     80,   3,   3,  3,  0, 0x0046701f },      /* 073 hill [large], south */
  { TT_PLAINS,         97,   0,   1,  3,  0, 0x005e8e34 },      /* 074 rocks [one] */
  { TT_PLAINS,         98,   0,   1,  3,  0, 0x005e8e34 },      /* 075 rocks [two] */
  { TT_PLAINS,         96,   0,   1,  3,  0, 0x005e8e34 },      /* 076 rocks [three] */
  { TT_PLAINS,         48,   0,   0,  2,  0, 0x005e8e34 },      /* 077 woodlands [very light] */
  { TT_PLAINS,         49,   1,   1,  2,  0, 0x0046701f },      /* 078 woodlands [light] */
  { TT_PLAINS,         50,   2,   2,  2,  0, 0x0046701f },      /* 079 woodlands [medium] */
  { TT_PLAINS,         51,   3,   3,  2,  0, 0x0046701f },      /* 080 woodlands [dense] */
  { TT_FOREST,         52,   5,  10,  3,  0, 0x002e5614 },      /* 081 forest 1 */
  { TT_FOREST,         53,   5,  10,  3,  0, 0x002e5614 },      /* 082 forest 2 */
  { TT_FOREST,         56,   5,  10,  3,  0, 0x002e5614 },      /* 083 forest [large], north */
  { TT_FOREST,         54,   5,  10,  3,  0, 0x002e5614 },      /* 084 forest [large], west */
  { TT_FOREST,         55,   5,  10,  3,  0, 0x002e5614 },      /* 085 forest [large], east */
  { TT_FOREST,         57,   5,  10,  3,  0, 0x002e5614 },      /* 086 forest [large], south */
  { TT_BARRICADES,     86,   0,   0,  3,  0, 0x005e8e34 },      /* 087 slope [straight], n-s(w) */
  { TT_BARRICADES,     85,   0,   0,  3,  0, 0x005e8e34 },      /* 088 slope [straight], n-s(e) */
  { TT_BARRICADES,     84,   0,   0,  3,  0, 0x005e8e34 },      /* 089 slope [straight], nw-se(ne) */
  { TT_BARRICADES,     83,   0,   0,  3,  0, 0x005e8e34 },      /* 090 slope [straight], nw-se(sw) */
  { TT_BARRICADES,     82,   0,   0,  3,  0, 0x005e8e34 },      /* 091 slope [straight], sw-ne(nw) */
  { TT_BARRICADES,     81,   0,   0,  3,  0, 0x005e8e34 },      /* 092 slope [straight], sw-ne(se) */
  { TT_BARRICADES,    106,   0,   0,  3,  0, 0x005e8e34 },      /* 093 slope [curve], n-se(ne) */
  { TT_BARRICADES,     91,   0,   0,  3,  0, 0x005e8e34 },      /* 094 slope [curve], n-se(sw) */
  { TT_BARRICADES,     95,   0,   0,  3,  0, 0x005e8e34 },      /* 095 slope [curve], n-sw(nw) */
  { TT_BARRICADES,     89,   0,   0,  3,  0, 0x005e8e34 },      /* 096 slope [curve], n-sw(se) */
  { TT_BARRICADES,     92,   0,   0,  3,  0, 0x005e8e34 },      /* 097 slope [curve], s-ne(nw) */
  { TT_BARRICADES,    107,   0,   0,  3,  0, 0x005e8e34 },      /* 098 slope [curve], s-ne(se) */
  { TT_BARRICADES,     94,   0,   0,  3,  0, 0x005e8e34 },      /* 099 slope [curve], s-nw(sw) */
  { TT_BARRICADES,     88,   0,   0,  3,  0, 0x005e8e34 },      /* 100 slope [curve], s-nw(ne) */
  { TT_BARRICADES,    105,   0,   0,  3,  0, 0x005e8e34 },      /* 101 slope [curve], nw-ne(n) */
  { TT_BARRICADES,     90,   0,   0,  3,  0, 0x005e8e34 },      /* 102 slope [curve], nw-ne(s) */
  { TT_BARRICADES,     87,   0,   0,  3,  0, 0x005e8e34 },      /* 103 slope [curve], sw-se(n) */
  { TT_BARRICADES,     93,   0,   0,  3,  0, 0x005e8e34 },      /* 104 slope [curve], sw-se(s) */
  { TT_PLAINS,        119,   0,   0,  2,  0, 0x005e8e34 },      /* 105 slope [end], n-s(w) */
  { TT_PLAINS,        118,   0,   0,  2,  0, 0x005e8e34 },      /* 106 slope [end], n-s(e) */
  { TT_PLAINS,        113,   0,   0,  2,  0, 0x005e8e34 },      /* 107 slope [end], s-n(w) */
  { TT_PLAINS,        112,   0,   0,  2,  0, 0x005e8e34 },      /* 108 slope [end], s-n(e) */
  { TT_PLAINS,        117,   0,   0,  2,  0, 0x005e8e34 },      /* 109 slope [end], nw-se(ne) */
  { TT_PLAINS,        116,   0,   0,  2,  0, 0x005e8e34 },      /* 110 slope [end], nw-se(sw) */
  { TT_PLAINS,        115,   0,   0,  2,  0, 0x005e8e34 },      /* 111 slope [end], ne-sw(nw) */
  { TT_PLAINS,        114,   0,   0,  2,  0, 0x005e8e34 },      /* 112 slope [end], ne-sw(se) */
  { TT_PLAINS,        109,   0,   0,  2,  0, 0x005e8e34 },      /* 113 slope [end], sw-ne(nw) */
  { TT_PLAINS,        108,   0,   0,  2,  0, 0x005e8e34 },      /* 114 slope [end], sw-ne(se) */
  { TT_PLAINS,        111,   0,   0,  2,  0, 0x005e8e34 },      /* 115 slope [end], se-nw(ne) */
  { TT_PLAINS,        110,   0,   0,  2,  0, 0x005e8e34 },      /* 116 slope [end], se-nw(sw) */
  { TT_MOUNTAINS,      99,  15,  15,  4,  0, 0x00b2b6b4 },      /* 117 mountain [small] */
  { TT_MOUNTAINS,     126,  15,  15,  4,  0, 0x00b2b6b4 },      /* 118 mountain [large/huge], north */
  { TT_MOUNTAINS,     121,  15,  15,  4,  0, 0x00b2b6b4 },      /* 119 mountain [huge], northwest */
  { TT_MOUNTAINS,     124,  15,  15,  4,  0, 0x00b2b6b4 },      /* 120 mountain [huge], northeast */
  { TT_MOUNTAINS,     120,  15,  15,  4,  0, 0x00b2b6b4 },      /* 121 mountain [large/huge], west */
  { TT_MOUNTAINS,     128,  15,  15,  4,  0, 0x00b2b6b4 },      /* 122 mountain [huge], summit */
  { TT_MOUNTAINS,     123,  15,  15,  4,  0, 0x00b2b6b4 },      /* 123 mountain [large/huge], east */
  { TT_MOUNTAINS,     122,  15,  15,  4,  0, 0x00b2b6b4 },      /* 124 mountain [huge], southwest */
  { TT_MOUNTAINS,     125,  15,  15,  4,  0, 0x00b2b6b4 },      /* 125 mountain [huge], southeast */
  { TT_MOUNTAINS,     127,  15,  15,  4,  0, 0x00b2b6b4 },      /* 126 mountain [large/huge], south */
  { TT_BARRICADES,    100,   2,   2,  3,  0, 0x0066721d },      /* 127 barricades [little rubble] 1 */
  { TT_BARRICADES,    101,   2,   2,  3,  0, 0x0066721d },      /* 128 barricades [little rubble] 2 */
  { TT_BARRICADES,    102,   2,   2,  3,  0, 0x0066721d },      /* 129 barricades [medium rubble] */
  { TT_BARRICADES,    103,   2,   2,  3,  0, 0x0066721d },      /* 130 barricades [dense rubble] */
  { TT_BARRICADES,    103,   2,   2,  3,  0, 0x0066721d },      /* 131 barricades [crater] */
  { TT_BARRICADES,    104,   4,   4,  3,  0, 0x0066721d },      /* 132 barricades [rugged, tank stoppers] */
  { TT_BARRICADES,    148,   4,   5,  3,  0, 0x00969a84 },      /* 133 fence [straight], n-s */
  { TT_BARRICADES,    150,   4,   5,  3,  0, 0x00969a84 },      /* 134 fence [straight], nw-se */
  { TT_BARRICADES,    149,   4,   5,  3,  0, 0x00969a84 },      /* 135 fence [straight], ne-sw */
  { TT_BARRICADES,    168,   4,   5,  3,  0, 0x00969a84 },      /* 136 fence [curve], n-sw */
  { TT_BARRICADES,    169,   4,   5,  3,  0, 0x00969a84 },      /* 137 fence [curve], n-se */
  { TT_BARRICADES,    151,   4,   5,  3,  0, 0x00969a84 },      /* 138 fence [curve], s-nw */
  { TT_BARRICADES,    152,   4,   5,  3,  0, 0x00969a84 },      /* 139 fence [curve], s-ne */
  { TT_BARRICADES,    170,   4,   5,  3,  0, 0x00969a84 },      /* 140 fence [curve], nw-ne */
  { TT_BARRICADES,    171,   4,   5,  3,  0, 0x00969a84 },      /* 141 fence [curve], sw-se */
  { TT_BARRICADES,    173,   4,   5,  3,  0, 0x00969a84 },      /* 142 fence [end], n-s */
  { TT_BARRICADES,    172,   4,   5,  3,  0, 0x00969a84 },      /* 143 fence [end], s-n */
  { TT_BARRICADES,    144,   4,   5,  3,  0, 0x00969a84 },      /* 144 fence [end], nw-se */
  { TT_BARRICADES,    147,   4,   5,  3,  0, 0x00969a84 },      /* 145 fence [end], ne-sw */
  { TT_BARRICADES,    146,   4,   5,  3,  0, 0x00969a84 },      /* 146 fence [end], sw-ne */
  { TT_BARRICADES,    145,   4,   5,  3,  0, 0x00969a84 },      /* 147 fence [end], se-nw */
  { TT_TRENCHES,      129,   5,  10,  3,  0, 0x0066721d },      /* 148 trenches [straight], n-s */
  { TT_TRENCHES,      134,   5,  10,  3,  0, 0x0066721d },      /* 149 trenches [straight], nw-se */
  { TT_TRENCHES,      133,   5,  10,  3,  0, 0x0066721d },      /* 150 trenches [straight], ne-sw */
  { TT_TRENCHES,      135,   5,  10,  3,  0, 0x0066721d },      /* 151 trenches [curve], nw-ne */
  { TT_TRENCHES,      136,   5,  10,  3,  0, 0x0066721d },      /* 152 trenches [curve], sw-se */
  { TT_TRENCHES,      130,   5,  10,  3,  0, 0x0066721d },      /* 153 trenches [curve], n-sw */
  { TT_TRENCHES,      131,   5,  10,  3,  0, 0x0066721d },      /* 154 trenches [curve], n-se */
  { TT_TRENCHES,      132,   5,  10,  3,  0, 0x0066721d },      /* 155 trenches [curve], nw-s */
  { TT_TRENCHES,      153,   5,  10,  3,  0, 0x0066721d },      /* 156 trenches [curve], ne-s */
  { TT_TRENCHES,      139,   5,  10,  3,  0, 0x0066721d },      /* 157 trenches [junction], nw-se-ne */
  { TT_TRENCHES,      138,   5,  10,  3,  0, 0x0066721d },      /* 158 trenches [junction], ne-sw-nw */
  { TT_TRENCHES,      137,   5,  10,  3,  0, 0x0066721d },      /* 159 trenches [junction], sw-ne-se */
  { TT_TRENCHES,      140,   5,  10,  3,  0, 0x0066721d },      /* 160 trenches [junction], se-nw-sw */
  { TT_TRENCHES,      154,   5,  10,  3,  0, 0x0066721d },      /* 161 trenches [junction], n-sw-se */
  { TT_TRENCHES,      155,   5,  10,  3,  0, 0x0066721d },      /* 162 trenches [junction], s-nw-ne */
  { TT_TRENCHES,      156,   5,  10,  3,  0, 0x0066721d },      /* 163 trenches [junction], n-s-sw */
  { TT_TRENCHES,      157,   5,  10,  3,  0, 0x0066721d },      /* 164 trenches [junction], n-s-se */
  { TT_TRENCHES,      158,   5,  10,  3,  0, 0x0066721d },      /* 165 trenches [junction], nw-s-se */
  { TT_TRENCHES,      159,   5,  10,  3,  0, 0x0066721d },      /* 166 trenches [junction], ne-sw-s */
  { TT_TRENCHES,      160,   5,  10,  3,  0, 0x0066721d },      /* 167 trenches [junction], n-ne-sw */
  { TT_TRENCHES,      161,   5,  10,  3,  0, 0x0066721d },      /* 168 trenches [junction], n-nw-se */
  { TT_TRENCHES,      162,   5,  10,  3,  0, 0x0066721d },      /* 169 trenches [crossing], n-nw-s-se */
  { TT_TRENCHES,      163,   5,  10,  3,  0, 0x0066721d },      /* 170 trenches [crossing], n-ne-s-sw */
  { TT_TRENCHES,      164,   5,  10,  3,  0, 0x0066721d },      /* 171 trenches [crossing], nw-ne-sw-se */
  { TT_TRENCHES,      167,   5,  10,  3,  0, 0x0066721d },      /* 172 trenches [circular] */
  { TT_TRENCHES,      141,   5,  15,  3,  0, 0x0066721d },      /* 173 trenches [barbed wire], n-s */
  { TT_TRENCHES,      143,   5,  15,  3,  0, 0x0066721d },      /* 174 trenches [barbed wire], nw-se */
  { TT_TRENCHES,      142,   5,  15,  3,  0, 0x0066721d },      /* 175 trenches [barbed wire], sw-ne */
  { TT_ROAD,          193,   3,  -3,  1,  0, 0x00322204 },      /* 176 road [straight], n-s */
  { TT_ROAD,          192,   3,  -3,  1,  0, 0x00322204 },      /* 177 road [straight], nw-se */
  { TT_ROAD,          194,   3,  -3,  1,  0, 0x00322204 },      /* 178 road [straight], ne-sw */
  { TT_ROAD,          198,   3,  -3,  1,  0, 0x00322204 },      /* 179 road [curve], n-sw */
  { TT_ROAD,          197,   3,  -3,  1,  0, 0x00322204 },      /* 180 road [curve], n-se */
  { TT_ROAD,          199,   3,  -3,  1,  0, 0x00322204 },      /* 181 road [curve], s-nw */
  { TT_ROAD,          200,   3,  -3,  1,  0, 0x00322204 },      /* 182 road [curve], s-ne */
  { TT_ROAD,          202,   3,  -3,  1,  0, 0x00322204 },      /* 183 road [curve], nw-ne */
  { TT_ROAD,          201,   3,  -3,  1,  0, 0x00322204 },      /* 184 road [curve], sw-se */
  { TT_ROAD,          225,   3,  -3,  1,  0, 0x00322204 },      /* 185 road [junction], n-sw-se */
  { TT_ROAD,          226,   3,  -3,  1,  0, 0x00322204 },      /* 186 road [junction], s-nw-ne */
  { TT_ROAD,          216,   3,  -3,  1,  0, 0x00322204 },      /* 187 road [junction], n-s-sw */
  { TT_ROAD,          206,   3,  -3,  1,  0, 0x00322204 },      /* 188 road [junction], n-s-se */
  { TT_ROAD,          218,   3,  -3,  1,  0, 0x00322204 },      /* 189 road [junction], s-n-nw */
  { TT_ROAD,          217,   3,  -3,  1,  0, 0x00322204 },      /* 190 road [junction], s-n-ne */
  { TT_ROAD,          205,   3,  -3,  1,  0, 0x00322204 },      /* 191 road [junction], nw-se-s */
  { TT_ROAD,          204,   3,  -3,  1,  0, 0x00322204 },      /* 192 road [junction], ne-sw-s */
  { TT_ROAD,          195,   3,  -3,  1,  0, 0x00322204 },      /* 193 road [junction], sw-ne-n */
  { TT_ROAD,          196,   3,  -3,  1,  0, 0x00322204 },      /* 194 road [junction], se-nw-n */
  { TT_ROAD,          221,   3,  -3,  1,  0, 0x00322204 },      /* 195 road [junction], nw-se-ne */
  { TT_ROAD,          222,   3,  -3,  1,  0, 0x00322204 },      /* 196 road [junction], ne-sw-nw */
  { TT_ROAD,          223,   3,  -3,  1,  0, 0x00322204 },      /* 197 road [junction], sw-ne-se */
  { TT_ROAD,          224,   3,  -3,  1,  0, 0x00322204 },      /* 198 road [junction], se-nw-sw */
  { TT_ROAD,          219,   3,  -3,  1,  0, 0x00322204 },      /* 199 road [crossing], n-s-nw-se */
  { TT_ROAD,          220,   3,  -3,  1,  0, 0x00322204 },      /* 200 road [crossing], n-s-ne-sw */
  { TT_ROAD,          203,   3,  -3,  1,  0, 0x00322204 },      /* 201 road [crossing], nw-se-ne-sw */
  { TT_ROAD,          177,   2,  -3,  2,  0, 0x00322204 },      /* 202 road [craters], n-s */
  { TT_ROAD,          178,   2,  -3,  2,  0, 0x00322204 },      /* 203 road [craters], nw-se */
  { TT_ROAD,          179,   2,  -3,  2,  0, 0x00322204 },      /* 204 road [craters], ne-sw */
  { TT_BARRICADES,    174,   5,  -2,  2,  0, 0x00322204 },      /* 205 road [tank stoppers], n-s */
  { TT_BARRICADES,    175,   5,  -2,  2,  0, 0x00322204 },      /* 206 road [tank stoppers], nw-se */
  { TT_BARRICADES,    176,   5,  -2,  2,  0, 0x00322204 },      /* 207 road [tank stoppers], ne-sw */
  { TT_ROAD,          183,   3,  -3,  1,  0, 0x00322204 },      /* 208 road [bridge], n-s */
  { TT_ROAD,          184,   3,  -3,  1,  0, 0x00322204 },      /* 209 road [bridge], nw-se */
  { TT_ROAD,          185,   3,  -3,  1,  0, 0x00322204 },      /* 210 road [bridge], ne-sw */
  { TT_WATER,         186,   0,   0,  2,  0, 0x00327694 },      /* 211 road [destroyed bridge], n-s */
  { TT_WATER,         187,   0,   0,  2,  0, 0x00327694 },      /* 212 road [destroyed bridge], nw-se */
  { TT_WATER,         188,   0,   0,  2,  0, 0x00327694 },      /* 213 road [destroyed bridge], ne-sw */
  { TT_ROAD,          207,   3,  -3,  1,  0, 0x00322204 },      /* 214 road [bridge], n-s    +  coast, nw-n-ne */
  { TT_ROAD,          208,   3,  -3,  1,  0, 0x00322204 },      /* 215 road [bridge], n-s    +  coast, sw-s-se */
  { TT_ROAD,          231,   3,  -3,  1,  0, 0x00322204 },      /* 216 road [bridge], nw-se  +  coast, n-nw */
  { TT_ROAD,          232,   3,  -3,  1,  0, 0x00322204 },      /* 217 road [bridge], nw-se  +  coast, s-se */
  { TT_ROAD,          211,   3,  -3,  1,  0, 0x00322204 },      /* 218 road [bridge], nw-se  +  coast, n-nw-sw-s */
  { TT_ROAD,          212,   3,  -3,  1,  0, 0x00322204 },      /* 219 road [bridge], nw-se  +  coast, n-ne-se-s */
  { TT_ROAD,          209,   3,  -3,  1,  0, 0x00322204 },      /* 220 road [bridge], ne-sw  +  coast, n-nw-sw-s */
  { TT_ROAD,          210,   3,  -3,  1,  0, 0x00322204 },      /* 221 road [bridge], ne-sw  +  coast, n-ne-se-s */
  { TT_ROAD,          240,   3,  -3,  2,  0, 0x00685919 },      /* 222 path [straight], n-s */
  { TT_ROAD,          241,   3,  -3,  2,  0, 0x00685919 },      /* 223 path [straight], nw-se */
  { TT_ROAD,          242,   3,  -3,  2,  0, 0x00685919 },      /* 224 path [straight], ne-sw */
  { TT_ROAD,          245,   3,  -3,  2,  0, 0x00685919 },      /* 225 path [curve], n-sw */
  { TT_ROAD,          246,   3,  -3,  2,  0, 0x00685919 },      /* 226 path [curve], n-se */
  { TT_ROAD,          247,   3,  -3,  2,  0, 0x00685919 },      /* 227 path [curve], s-ne */
  { TT_ROAD,          248,   3,  -3,  2,  0, 0x00685919 },      /* 228 path [curve], s-nw */
  { TT_ROAD,          244,   3,  -3,  2,  0, 0x00685919 },      /* 229 path [curve], nw-ne */
  { TT_ROAD,          243,   3,  -3,  2,  0, 0x00685919 },      /* 230 path [curve], sw-se */
  { TT_ROAD,          273,   3,  -3,  2,  0, 0x00685919 },      /* 231 path [junction], n-sw-se */
  { TT_ROAD,          274,   3,  -3,  2,  0, 0x00685919 },      /* 232 path [junction], s-nw-ne */
  { TT_ROAD,          252,   3,  -3,  2,  0, 0x00685919 },      /* 233 path [junction], n-s-sw */
  { TT_ROAD,          253,   3,  -3,  2,  0, 0x00685919 },      /* 234 path [junction], n-s-se */
  { TT_ROAD,          255,   3,  -3,  2,  0, 0x00685919 },      /* 235 path [junction], s-n-nw */
  { TT_ROAD,          254,   3,  -3,  2,  0, 0x00685919 },      /* 236 path [junction], s-n-ne */
  { TT_ROAD,          228,   3,  -3,  2,  0, 0x00685919 },      /* 237 path [junction], nw-se-s */
  { TT_ROAD,          229,   3,  -3,  2,  0, 0x00685919 },      /* 238 path [junction], ne-sw-s */
  { TT_ROAD,          256,   3,  -3,  2,  0, 0x00685919 },      /* 239 path [junction], sw-ne-n */
  { TT_ROAD,          227,   3,  -3,  2,  0, 0x00685919 },      /* 240 path [junction], se-nw-n */
  { TT_ROAD,          230,   3,  -3,  2,  0, 0x00685919 },      /* 241 path [junction], nw-se-ne */
  { TT_ROAD,          270,   3,  -3,  2,  0, 0x00685919 },      /* 242 path [junction], ne-sw-nw */
  { TT_ROAD,          271,   3,  -3,  2,  0, 0x00685919 },      /* 243 path [junction], sw-ne-se */
  { TT_ROAD,          272,   3,  -3,  2,  0, 0x00685919 },      /* 244 path [junction], se-nw-sw */
  { TT_ROAD,          249,   3,  -3,  2,  0, 0x00685919 },      /* 245 path [crossing], n-s-nw-se */
  { TT_ROAD,          251,   3,  -3,  2,  0, 0x00685919 },      /* 246 path [crossing], n-s-ne-sw */
  { TT_ROAD,          250,   3,  -3,  2,  0, 0x00685919 },      /* 247 path [crossing], nw-se-ne-sw */
  { TT_RAILS,         239,   2,  -3,  2,  0, 0x00322204 },      /* 248 rails [straight], n-s */
  { TT_RAILS,         257,   2,  -3,  2,  0, 0x00322204 },      /* 249 rails [straight], nw-se */
  { TT_RAILS,         258,   2,  -3,  2,  0, 0x00322204 },      /* 250 rails [straight], ne-sw */
  { TT_RAILS,         261,   2,  -3,  2,  0, 0x00322204 },      /* 251 rails [curve], n-sw */
  { TT_RAILS,         262,   2,  -3,  2,  0, 0x00322204 },      /* 252 rails [curve], n-se */
  { TT_RAILS,         281,   2,  -3,  2,  0, 0x00322204 },      /* 253 rails [curve], s-nw */
  { TT_RAILS,         263,   2,  -3,  2,  0, 0x00322204 },      /* 254 rails [curve], s-ne */
  { TT_RAILS,         260,   2,  -3,  2,  0, 0x00322204 },      /* 255 rails [curve], nw-ne */
  { TT_RAILS,         259,   2,  -3,  2,  0, 0x00322204 },      /* 256 rails [curve], sw-se */
  { TT_RAILS,         310,   2,  -3,  2,  0, 0x00322204 },      /* 257 rails [junction], n-sw-se */
  { TT_RAILS,         311,   2,  -3,  2,  0, 0x00322204 },      /* 258 rails [junction], s-nw-ne */
  { TT_RAILS,         285,   2,  -3,  2,  0, 0x00322204 },      /* 259 rails [junction], n-s-sw */
  { TT_RAILS,         286,   2,  -3,  2,  0, 0x00322204 },      /* 260 rails [junction], n-s-se */
  { TT_RAILS,         301,   2,  -3,  2,  0, 0x00322204 },      /* 261 rails [junction], s-n-nw */
  { TT_RAILS,         287,   2,  -3,  2,  0, 0x00322204 },      /* 262 rails [junction], s-n-ne */
  { TT_RAILS,         304,   2,  -3,  2,  0, 0x00322204 },      /* 263 rails [junction], nw-se-s */
  { TT_RAILS,         305,   2,  -3,  2,  0, 0x00322204 },      /* 264 rails [junction], ne-sw-s */
  { TT_RAILS,         302,   2,  -3,  2,  0, 0x00322204 },      /* 265 rails [junction], sw-ne-n */
  { TT_RAILS,         303,   2,  -3,  2,  0, 0x00322204 },      /* 266 rails [junction], se-nw-n */
  { TT_RAILS,         306,   2,  -3,  2,  0, 0x00322204 },      /* 267 rails [junction], nw-se-ne */
  { TT_RAILS,         307,   2,  -3,  2,  0, 0x00322204 },      /* 268 rails [junction], ne-sw-nw */
  { TT_RAILS,         308,   2,  -3,  2,  0, 0x00322204 },      /* 269 rails [junction], sw-ne-se */
  { TT_RAILS,         309,   2,  -3,  2,  0, 0x00322204 },      /* 270 rails [junction], se-nw-sw */
  { TT_RAILS,         282,   2,  -3,  2,  0, 0x00322204 },      /* 271 rails [crossing], n-s-nw-se */
  { TT_RAILS,         284,   2,  -3,  2,  0, 0x00322204 },      /* 272 rails [crossing], n-s-ne-sw */
  { TT_RAILS,         283,   2,  -3,  2,  0, 0x00322204 },      /* 273 rails [crossing], nw-se-ne-sw */
  { TT_RAILS,         292,   2,  -3,  2,  0, 0x00322204 },      /* 274 rails [bridge], n-s */
  { TT_RAILS,         293,   2,  -3,  2,  0, 0x00322204 },      /* 275 rails [bridge], nw-se */
  { TT_RAILS,         294,   2,  -3,  2,  0, 0x00322204 },      /* 276 rails [bridge], ne-sw */
  { TT_RAILS|TT_ROAD, 189,   3,  -3,  1,  0, 0x00322204 },      /* 277 crossing: rails, n-s    +  road, nw-se */
  { TT_RAILS|TT_ROAD, 190,   3,  -3,  1,  0, 0x00322204 },      /* 278 crossing: rails, n-s    +  road, ne-sw */
  { TT_RAILS|TT_ROAD, 191,   3,  -3,  1,  0, 0x00322204 },      /* 279 crossing: rails, nw-se  +  road, n-s */
  { TT_RAILS|TT_ROAD, 213,   3,  -3,  1,  0, 0x00322204 },      /* 280 crossing: rails, nw-se  +  road, ne-sw */
  { TT_RAILS|TT_ROAD, 214,   3,  -3,  1,  0, 0x00322204 },      /* 281 crossing: rails, ne-sw  +  road, n-s */
  { TT_RAILS|TT_ROAD, 215,   3,  -3,  1,  0, 0x00322204 },      /* 282 crossing: rails, ne-sw  +  road, nw-se */
  { TT_ROAD|TT_RAILS, 275,   3,  -3,  2,  0, 0x00685919 },      /* 283 crossing: rails, n-s    +  path, nw-se */
  { TT_ROAD|TT_RAILS, 276,   3,  -3,  2,  0, 0x00685919 },      /* 284 crossing: rails, n-s    +  path, ne-sw */
  { TT_ROAD|TT_RAILS, 277,   3,  -3,  2,  0, 0x00685919 },      /* 285 crossing: rails, nw-se  +  path, n-s */
  { TT_ROAD|TT_RAILS, 278,   3,  -3,  2,  0, 0x00685919 },      /* 286 crossing: rails, nw-se  +  path, ne-sw */
  { TT_ROAD|TT_RAILS, 279,   3,  -3,  2,  0, 0x00685919 },      /* 287 crossing: rails, ne-sw  +  path, n-s */
  { TT_ROAD|TT_RAILS, 280,   3,  -3,  2,  0, 0x00685919 },      /* 288 crossing: rails, ne-sw  +  path, nw-se */
  { TT_RAILS,         297,   0,  -4,  2,  0, 0x00322204 },      /* 289 crossing: rails, n-s    +  river nw-se */
  { TT_RAILS,         299,   0,  -4,  2,  0, 0x00322204 },      /* 290 crossing: rails, n-s    +  river ne-sw */
  { TT_RAILS,         295,   0,  -4,  2,  0, 0x00322204 },      /* 291 crossing: rails, nw-se  +  river n-s */
  { TT_RAILS,         300,   0,  -4,  2,  0, 0x00322204 },      /* 292 crossing: rails, nw-se  +  river ne-sw */
  { TT_RAILS,         296,   0,  -4,  2,  0, 0x00322204 },      /* 293 crossing: rails, ne-sw  +  river n-s */
  { TT_RAILS,         298,   0,  -4,  2,  0, 0x00322204 },      /* 294 crossing: rails, ne-sw  +  river nw-se */
  { TT_ROAD,          235,   3,  -4,  1,  0, 0x00322204 },      /* 295 crossing: road, n-s    +  river, nw-se */
  { TT_ROAD,          237,   3,  -4,  1,  0, 0x00322204 },      /* 296 crossing: road, n-s    +  river, ne-sw */
  { TT_ROAD,          233,   3,  -4,  1,  0, 0x00322204 },      /* 297 crossing: road, nw-se  +  river, n-s */
  { TT_ROAD,          238,   3,  -4,  1,  0, 0x00322204 },      /* 298 crossing: road, nw-se  +  river, ne-sw */
  { TT_ROAD,          234,   3,  -4,  1,  0, 0x00322204 },      /* 299 crossing: road, ne-sw  +  river, n-s */
  { TT_ROAD,          236,   3,  -4,  1,  0, 0x00322204 },      /* 300 crossing: road, ne-sw  +  river, nw-se */
  { TT_ROAD,          266,   3,  -4,  2,  0, 0x00685919 },      /* 301 crossing: path, n-s    +  river, nw-se */
  { TT_ROAD,          268,   3,  -4,  2,  0, 0x00685919 },      /* 302 crossing: path, n-s    +  river, ne-sw */
  { TT_ROAD,          264,   3,  -4,  2,  0, 0x00685919 },      /* 303 crossing: path, nw-se  +  river, n-s */
  { TT_ROAD,          269,   3,  -4,  2,  0, 0x00685919 },      /* 304 crossing: path, nw-se  +  river, ne-sw */
  { TT_ROAD,          265,   3,  -4,  2,  0, 0x00685919 },      /* 305 crossing: path, ne-sw  +  river, n-s */
  { TT_ROAD,          267,   3,  -4,  2,  0, 0x00685919 },      /* 306 crossing: path, ne-sw  +  river, nw-se */
  { TT_SWAMP,          33,  -5,  -5,  4,  0, 0x00324624 },      /* 307 swamp */
  { TT_WATER_SHALLOW, 288,   0,   0,  2,  0, 0x005696bc },      /* 308 lake */
  { TT_WATER_SHALLOW, 312,   0,   0,  2,  0, 0x005696bc },      /* 309 river [straight], n-s */
  { TT_WATER_SHALLOW, 313,   0,   0,  2,  0, 0x005696bc },      /* 310 river [straight], nw-se */
  { TT_WATER_SHALLOW, 314,   0,   0,  2,  0, 0x005696bc },      /* 311 river [straight], ne-sw */
  { TT_WATER_SHALLOW, 317,   0,   0,  2,  0, 0x005696bc },      /* 312 river [curve], n-sw */
  { TT_WATER_SHALLOW, 318,   0,   0,  2,  0, 0x005696bc },      /* 313 river [curve], n-se */
  { TT_WATER_SHALLOW, 320,   0,   0,  2,  0, 0x005696bc },      /* 314 river [curve], s-nw */
  { TT_WATER_SHALLOW, 319,   0,   0,  2,  0, 0x005696bc },      /* 315 river [curve], s-ne */
  { TT_WATER_SHALLOW, 316,   0,   0,  2,  0, 0x005696bc },      /* 316 river [curve], nw-ne */
  { TT_WATER_SHALLOW, 315,   0,   0,  2,  0, 0x005696bc },      /* 317 river [curve], sw-se */
  { TT_WATER_SHALLOW, 327,   0,   0,  2,  0, 0x005696bc },      /* 318 river [junction], n-sw-se */
  { TT_WATER_SHALLOW, 328,   0,   0,  2,  0, 0x005696bc },      /* 319 river [junction], s-nw-ne */
  { TT_WATER_SHALLOW, 329,   0,   0,  2,  0, 0x005696bc },      /* 320 river [junction], sw-ne-n */
  { TT_WATER_SHALLOW, 336,   0,   0,  2,  0, 0x005696bc },      /* 321 river [junction], n-sw-s */
  { TT_WATER_SHALLOW, 337,   0,   0,  2,  0, 0x005696bc },      /* 322 river [junction], n-s-se */
  { TT_WATER_SHALLOW, 338,   0,   0,  2,  0, 0x005696bc },      /* 323 river [junction], nw-n-s */
  { TT_WATER_SHALLOW, 339,   0,   0,  2,  0, 0x005696bc },      /* 324 river [junction], n-ne-s */
  { TT_WATER_SHALLOW, 340,   0,   0,  2,  0, 0x005696bc },      /* 325 river [junction], nw-s-se */
  { TT_WATER_SHALLOW, 341,   0,   0,  2,  0, 0x005696bc },      /* 326 river [junction], ne-sw-s */
  { TT_WATER_SHALLOW, 342,   0,   0,  2,  0, 0x005696bc },      /* 327 river [junction], nw-n-se */
  { TT_WATER_SHALLOW, 343,   0,   0,  2,  0, 0x005696bc },      /* 328 river [junction], nw-ne-se */
  { TT_WATER_SHALLOW, 344,   0,   0,  2,  0, 0x005696bc },      /* 329 river [junction], nw-ne-sw */
  { TT_WATER_SHALLOW, 345,   0,   0,  2,  0, 0x005696bc },      /* 330 river [junction], ne-sw-se */
  { TT_WATER_SHALLOW, 346,   0,   0,  2,  0, 0x005696bc },      /* 331 river [junction], nw-sw-se */
  { TT_WATER_SHALLOW, 347,   0,   0,  2,  0, 0x005696bc },      /* 332 river [crossing], n-nw-s-se */
  { TT_WATER_SHALLOW, 348,   0,   0,  2,  0, 0x005696bc },      /* 333 river [crossing], n-ne-s-sw */
  { TT_WATER_SHALLOW, 349,   0,   0,  2,  0, 0x005696bc },      /* 334 river [crossing], nw-ne-sw-se */
  { TT_WATER_SHALLOW, 322,   0,   0,  2,  0, 0x005696bc },      /* 335 river [end], n-s */
  { TT_WATER_SHALLOW, 321,   0,   0,  2,  0, 0x005696bc },      /* 336 river [end], s-n */
  { TT_WATER_SHALLOW, 324,   0,   0,  2,  0, 0x005696bc },      /* 337 river [end], nw-se */
  { TT_WATER_SHALLOW, 326,   0,   0,  2,  0, 0x005696bc },      /* 338 river [end], ne-sw */
  { TT_WATER_SHALLOW, 325,   0,   0,  2,  0, 0x005696bc },      /* 339 river [end], sw-ne */
  { TT_WATER_SHALLOW, 323,   0,   0,  2,  0, 0x005696bc },      /* 340 river [end], se-nw */
  { TT_RESTRICTED,    289,   3,  -3,  1,  0, 0x00685919 },      /* 341 river [footbridge], n-s */
  { TT_RESTRICTED,    290,   3,  -3,  1,  0, 0x00685919 },      /* 342 river [footbridge], nw-se */
  { TT_RESTRICTED,    291,   3,  -3,  1,  0, 0x00685919 },      /* 343 river [footbridge], ne-sw */
  { TT_WATER_SHALLOW, 360,   0,   0,  2,  0, 0x005696bc },      /* 344 coast, n */
  { TT_WATER_SHALLOW, 365,   0,   0,  2,  0, 0x005696bc },      /* 345 coast, nw */
  { TT_WATER_SHALLOW, 361,   0,   0,  2,  0, 0x005696bc },      /* 346 coast, ne */
  { TT_WATER_SHALLOW, 364,   0,   0,  2,  0, 0x005696bc },      /* 347 coast, sw */
  { TT_WATER_SHALLOW, 362,   0,   0,  2,  0, 0x005696bc },      /* 348 coast, se */
  { TT_WATER_SHALLOW, 363,   0,   0,  2,  0, 0x005696bc },      /* 349 coast, s */
  { TT_WATER_SHALLOW, 366,   0,   0,  2,  0, 0x005696bc },      /* 350 coast, n-nw */
  { TT_WATER_SHALLOW, 367,   0,   0,  2,  0, 0x005696bc },      /* 351 coast, n-ne */
  { TT_WATER_SHALLOW, 371,   0,   0,  2,  0, 0x005696bc },      /* 352 coast, nw-sw */
  { TT_WATER_SHALLOW, 368,   0,   0,  2,  0, 0x005696bc },      /* 353 coast, ne-se */
  { TT_WATER_SHALLOW, 370,   0,   0,  2,  0, 0x005696bc },      /* 354 coast, s-sw */
  { TT_WATER_SHALLOW, 369,   0,   0,  2,  0, 0x005696bc },      /* 355 coast, s-se */
  { TT_WATER_SHALLOW, 372,   0,   0,  2,  0, 0x005696bc },      /* 356 coast, nw-n-ne */
  { TT_WATER_SHALLOW, 375,   0,   0,  2,  0, 0x005696bc },      /* 357 coast, n-nw-sw-s */
  { TT_WATER_SHALLOW, 373,   0,   0,  2,  0, 0x005696bc },      /* 358 coast, n-ne-se-s */
  { TT_WATER_SHALLOW, 374,   0,   0,  2,  0, 0x005696bc },      /* 359 coast, sw-s-se */
  { TT_WATER_SHALLOW, 333,   0,   0,  2,  0, 0x005696bc },      /* 360 water [shallow] */
  { TT_WATER,         334,   0,   0,  2,  0, 0x00327694 },      /* 361 water [medium] */
  { TT_WATER_DEEP,    335,   0,   0,  2,  0, 0x002c6277 },      /* 362 water [deep] */
  { TT_BARRICADES,    330,  -5,  -5,  3,  0, 0x00969a84 },      /* 363 cliffs [one] */
  { TT_BARRICADES,    331,  -5,  -5,  3,  0, 0x00969a84 },      /* 364 cliffs [two] */
  { TT_BARRICADES,    332,  -5,  -5,  3,  0, 0x00969a84 },      /* 365 cliffs [three] */
  { TT_PLAINS,        354,   0,   0,  2,  0, 0x008a7664 },      /* 366 pier, west */
  { TT_PLAINS,        355,   0,   0,  2,  0, 0x008a7664 },      /* 367 pier, east */
  { TT_PLAINS,        352,   0,   0,  2,  0, 0x008a7664 },      /* 368 pier [crane], west */
  { TT_PLAINS,        353,   0,   0,  2,  0, 0x008a7664 },      /* 369 pier [crane], east */
  { TT_PLAINS,        356,   0,   0,  2,  0, 0x008a7664 },      /* 370 pier [jetty], n-s */
  { TT_PLAINS,        357,   0,   0,  2,  0, 0x008a7664 },      /* 371 pier [jetty], south */
  { TT_PLAINS,        358,   0,   0,  2,  0, 0x008a7664 },      /* 372 pier [jetty], north */
  { TT_WATER|TT_WATER_SHALLOW, 350,   0,   0,  2,  0, 0x005696bc },      /* 373 pier [dock], south */
  { TT_WATER|TT_WATER_SHALLOW, 351,   0,   0,  2,  0, 0x005696bc }       /* 374 pier [dock], north */
};

