// Description:
//   Wrapper for GL_ARB_multitexture extension.
//
// Copyright (C) 2001 Frank Becker
//
// This program is free software; you can redistribute it and/or modify it under
// the terms of the GNU General Public License as published by the Free Software
// Foundation;  either version 2 of the License,  or (at your option) any  later
// version.
//
// This program is distributed in the hope that it will be useful,  but  WITHOUT
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
// FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details
//
#include <GLMultiTexture.hpp>

PFNGLACTIVETEXTUREARBPROC GLMultiTexture::_glActiveTextureARB = 0;
PFNGLCLIENTACTIVETEXTUREARBPROC GLMultiTexture::_glClientActiveTextureARB = 0;

PFNGLMULTITEXCOORD1DARBPROC GLMultiTexture::_glMultiTexCoord1dARB = 0;
PFNGLMULTITEXCOORD1DVARBPROC GLMultiTexture::_glMultiTexCoord1dvARB = 0;
PFNGLMULTITEXCOORD1FARBPROC GLMultiTexture::_glMultiTexCoord1fARB = 0;
PFNGLMULTITEXCOORD1FVARBPROC GLMultiTexture::_glMultiTexCoord1fvARB = 0;
PFNGLMULTITEXCOORD1IARBPROC GLMultiTexture::_glMultiTexCoord1iARB = 0;
PFNGLMULTITEXCOORD1IVARBPROC GLMultiTexture::_glMultiTexCoord1ivARB = 0;
PFNGLMULTITEXCOORD1SARBPROC GLMultiTexture::_glMultiTexCoord1sARB = 0;
PFNGLMULTITEXCOORD1SVARBPROC GLMultiTexture::_glMultiTexCoord1svARB = 0;

PFNGLMULTITEXCOORD2DARBPROC GLMultiTexture::_glMultiTexCoord2dARB = 0;
PFNGLMULTITEXCOORD2DVARBPROC GLMultiTexture::_glMultiTexCoord2dvARB = 0;
PFNGLMULTITEXCOORD2FARBPROC GLMultiTexture::_glMultiTexCoord2fARB = 0;
PFNGLMULTITEXCOORD2FVARBPROC GLMultiTexture::_glMultiTexCoord2fvARB = 0;
PFNGLMULTITEXCOORD2IARBPROC GLMultiTexture::_glMultiTexCoord2iARB = 0;
PFNGLMULTITEXCOORD2IVARBPROC GLMultiTexture::_glMultiTexCoord2ivARB = 0;
PFNGLMULTITEXCOORD2SARBPROC GLMultiTexture::_glMultiTexCoord2sARB = 0;
PFNGLMULTITEXCOORD2SVARBPROC GLMultiTexture::_glMultiTexCoord2svARB = 0;

PFNGLMULTITEXCOORD3DARBPROC GLMultiTexture::_glMultiTexCoord3dARB = 0;
PFNGLMULTITEXCOORD3DVARBPROC GLMultiTexture::_glMultiTexCoord3dvARB = 0;
PFNGLMULTITEXCOORD3FARBPROC GLMultiTexture::_glMultiTexCoord3fARB = 0;
PFNGLMULTITEXCOORD3FVARBPROC GLMultiTexture::_glMultiTexCoord3fvARB = 0;
PFNGLMULTITEXCOORD3IARBPROC GLMultiTexture::_glMultiTexCoord3iARB = 0;
PFNGLMULTITEXCOORD3IVARBPROC GLMultiTexture::_glMultiTexCoord3ivARB = 0;
PFNGLMULTITEXCOORD3SARBPROC GLMultiTexture::_glMultiTexCoord3sARB = 0;
PFNGLMULTITEXCOORD3SVARBPROC GLMultiTexture::_glMultiTexCoord3svARB = 0;

PFNGLMULTITEXCOORD4DARBPROC GLMultiTexture::_glMultiTexCoord4dARB = 0;
PFNGLMULTITEXCOORD4DVARBPROC GLMultiTexture::_glMultiTexCoord4dvARB = 0;
PFNGLMULTITEXCOORD4FARBPROC GLMultiTexture::_glMultiTexCoord4fARB = 0;
PFNGLMULTITEXCOORD4FVARBPROC GLMultiTexture::_glMultiTexCoord4fvARB = 0;
PFNGLMULTITEXCOORD4IARBPROC GLMultiTexture::_glMultiTexCoord4iARB = 0;
PFNGLMULTITEXCOORD4IVARBPROC GLMultiTexture::_glMultiTexCoord4ivARB = 0;
PFNGLMULTITEXCOORD4SARBPROC GLMultiTexture::_glMultiTexCoord4sARB = 0;
PFNGLMULTITEXCOORD4SVARBPROC GLMultiTexture::_glMultiTexCoord4svARB = 0;

int GLMultiTexture::_numTexUnits = 0;

GLMultiTexture::GLMultiTexture( void):GLExtension( getName())
{
    glGetIntegerv(GL_MAX_TEXTURE_UNITS_ARB, &_numTexUnits);
    fprintf( stdout, "Found: GL_ARB_multitexture [%d texture units]\n", _numTexUnits);

    GLEXTCAST _glActiveTextureARB       = GetExtensionProc("glActiveTextureARB");
    GLEXTCAST _glActiveTextureARB       = GetExtensionProc("glActiveTextureARB");
    GLEXTCAST _glClientActiveTextureARB = GetExtensionProc("glClientActiveTextureARB");
    GLEXTCAST _glMultiTexCoord1dARB     = GetExtensionProc("glMultiTexCoord1dARB");
    GLEXTCAST _glMultiTexCoord1dvARB    = GetExtensionProc("glMultiTexCoord1dvARB");
    GLEXTCAST _glMultiTexCoord1fARB     = GetExtensionProc("glMultiTexCoord1fARB");
    GLEXTCAST _glMultiTexCoord1fvARB    = GetExtensionProc("glMultiTexCoord1fvARB");
    GLEXTCAST _glMultiTexCoord1iARB     = GetExtensionProc("glMultiTexCoord1iARB");
    GLEXTCAST _glMultiTexCoord1ivARB    = GetExtensionProc("glMultiTexCoord1ivARB");
    GLEXTCAST _glMultiTexCoord1sARB     = GetExtensionProc("glMultiTexCoord1sARB");
    GLEXTCAST _glMultiTexCoord1svARB    = GetExtensionProc("glMultiTexCoord1svARB");
    GLEXTCAST _glMultiTexCoord2dARB     = GetExtensionProc("glMultiTexCoord2dARB");
    GLEXTCAST _glMultiTexCoord2dvARB    = GetExtensionProc("glMultiTexCoord2dvARB");
    GLEXTCAST _glMultiTexCoord2fARB     = GetExtensionProc("glMultiTexCoord2fARB");
    GLEXTCAST _glMultiTexCoord2fvARB    = GetExtensionProc("glMultiTexCoord2fvARB");
    GLEXTCAST _glMultiTexCoord2iARB     = GetExtensionProc("glMultiTexCoord2iARB");
    GLEXTCAST _glMultiTexCoord2ivARB    = GetExtensionProc("glMultiTexCoord2ivARB");
    GLEXTCAST _glMultiTexCoord2sARB     = GetExtensionProc("glMultiTexCoord2sARB");
    GLEXTCAST _glMultiTexCoord2svARB    = GetExtensionProc("glMultiTexCoord2svARB");
    GLEXTCAST _glMultiTexCoord3dARB     = GetExtensionProc("glMultiTexCoord3dARB");
    GLEXTCAST _glMultiTexCoord3dvARB    = GetExtensionProc("glMultiTexCoord3dvARB");
    GLEXTCAST _glMultiTexCoord3fARB     = GetExtensionProc("glMultiTexCoord3fARB");
    GLEXTCAST _glMultiTexCoord3fvARB    = GetExtensionProc("glMultiTexCoord3fvARB");
    GLEXTCAST _glMultiTexCoord3iARB     = GetExtensionProc("glMultiTexCoord3iARB");
    GLEXTCAST _glMultiTexCoord3ivARB    = GetExtensionProc("glMultiTexCoord3ivARB");
    GLEXTCAST _glMultiTexCoord3sARB     = GetExtensionProc("glMultiTexCoord3sARB");
    GLEXTCAST _glMultiTexCoord3svARB    = GetExtensionProc("glMultiTexCoord3svARB");
    GLEXTCAST _glMultiTexCoord4dARB     = GetExtensionProc("glMultiTexCoord4dARB");
    GLEXTCAST _glMultiTexCoord4dvARB    = GetExtensionProc("glMultiTexCoord4dvARB");
    GLEXTCAST _glMultiTexCoord4fARB     = GetExtensionProc("glMultiTexCoord4fARB");
    GLEXTCAST _glMultiTexCoord4fvARB    = GetExtensionProc("glMultiTexCoord4fvARB");
    GLEXTCAST _glMultiTexCoord4iARB     = GetExtensionProc("glMultiTexCoord4iARB");
    GLEXTCAST _glMultiTexCoord4ivARB    = GetExtensionProc("glMultiTexCoord4ivARB");
    GLEXTCAST _glMultiTexCoord4sARB     = GetExtensionProc("glMultiTexCoord4sARB");
    GLEXTCAST _glMultiTexCoord4svARB    = GetExtensionProc("glMultiTexCoord4svARB");
}
