# group.rb : A class to describe a group of parameters
# Copyright (C) 2006 Vincent Fourmond
 
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA

# The MetaBuilder module contains the classes necessary to create classes
# with a simple meta-information system that lets you save/export the
# state of an object (under certain assumptions), query paramters in
# different ways (command-line, Qt widgets, and others if necessary).
module MetaBuilder

  # The ParameterGroup class provides an easy way to group parameters
  # of a described class. The group should have a #name, a #long_name,
  # more descriptive and a description. 

  class ParameterGroup
    # The short name of the group
    attr_accessor :name
    
    # The long name of the group
    attr_accessor :long_name
    
    # The (text) description of the group
    attr_accessor :description

    # The list of parameters in that group, in the order they were
    # declared.

    attr_accessor :parameter_list
   
    def initialize(name, long_name = name, 
                   description = nil)
      @name = name
      @description = description
      @long_name = long_name
      @parameter_list = []
    end

    def add_parameter(param)
      @parameter_list << param
    end

  end

end
