# movingarray.rb, copyright (c) 2007 by Vincent Fourmond: 
# Moving arrays
  
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
  
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details (in the COPYING file).

require 'Dobjects/Dvector'
require 'Tioga/FigureConstants'


module CTioga

  # The MovingArray class provides a way to scroll through an array,
  # such as a set of colors, markers, linstyles, and so on. The class
  # provides a way to set the value directly as well, and to forget it.


  # TODO: now, we can remove many features from this file,
  # as the theme mechanism render quite a few useless.
  class MovingArray 
    include Tioga

    def initialize(sets, current = "", startpoint = 0)
      @sets = sets
      @current_set = current
      # if current is empty or simply not present in the hash, we just pickup
      # whichever one we want...
      if ! @sets.has_key?(current) && ! @sets.empty?
        @current_set = @sets.keys[0] 
      end

      @current_point = startpoint # the current point in the current set
      @set_value = nil # value set externally
    end

    # Returns true if the value has been statically changed.
    def static?
      return false if @set_value.nil?
      return true
    end

    # Sets the current value of the array according to a string
    # (or true or false), _arg_
    def read_arg(arg)
      case arg
      when DISABLE_RE, false # we disable the stuff
        set_static_value(false)
      when DEFAULT_RE, true # we make it rely on the default values
        reset_static_value
      else # we call the array's implementation
        set_static_value(arg)
      end
    end


    def set_static_value(value)
      @set_value = value
    end

    def reset_static_value
      set_static_value(nil)
    end

    # to start again from scratch
    def reset
      reset_static_value
      @current_point = 0
    end

    def value
      if @set_value.nil?
        current_set = @sets[@current_set]
        if @current_point >= current_set.length
          @current_point %= current_set.length
        end
        @current_point += 1
        return current_set[@current_point - 1]
      else
        return @set_value
      end
    end

    def choose_current_set(name)
      if !@sets.empty? && @sets.key?(name)
        @current_set = name 
      elsif name =~ /gradient:(.+)--(.+),(\d+)/
        s = CTioga.get_tioga_color($1)
        e = CTioga.get_tioga_color($2)
        nb = $3.to_i
        fact = 1.0/(nb)
        array = []
        nb.times do |i|
          a = []
          f = i * fact
          e.each_index do |c|
            a << s[c] * (1 - f) + e[c] * f
          end
          array << a
        end
        @sets[name] = array
        @current_set = name
      end
    end

    # Returns the available sets.
    def available_sets
      return @sets.keys
    end

  end

  # A helper function that converts user input into a Tioga
  # color.
  def CTioga.get_tioga_color(str)
    if str =~ /([\d.]+),([\d.]+),([\d.]+)/
      color = Dvector.new([$1.to_f,$2.to_f,$3.to_f])
      if color.max > 1
        color *= 1.0/255.0
      end
      return color.to_a
    else
      return eval("Tioga::FigureConstants::#{str}") 
    end
  end

  class MovingColorArray < MovingArray
    # the same as before, but with a special handling of colors

    # this function converts a given string to a color object, wich is
    # an array of three digits < 1. It supports two formats:
    # * if the string is a comma-separated list of values, it returns
    #   the corresponding table, divided by 255 if there's something over
    #   1
    # * if not, it evals the  string, hoping that it will give one color
    #   name

    def set_static_value(value)
      if value.is_a?(String)
        @set_value = CTioga.get_tioga_color(value)
      else
        @set_value = value
      end
    end

    # If the _name_ given is not part of the known sets, we try to interpret
    # it as a gradient: a color slowly blending from one to another.
    def choose_current_set(name)
      if @sets.key?(name)
        @current_set = name
      elsif name =~ /gradient:(.+)--(.+),(\d+)/
        s = CTioga.get_tioga_color($1)
        e = CTioga.get_tioga_color($2)
        nb = $3.to_i
        fact = 1.0/(nb)
        array = []
        nb.times do |i|
          a = []
          f = i * fact
          e.each_index do |c|
            a << s[c] * (1 - f) + e[c] * f
          end
          array << a
        end
        @sets[name] = array
        @current_set = name
      end
    end

  end


  module TiogaMovingArray
    # a module to be included by subclasses of MovingArray to
    # make life easier when working with tioga constants...

    include Tioga::FigureConstants

    def set_static_value(value)
      if value.is_a?(String)
        @set_value = eval(value)
      else
        @set_value = value
      end
    end
  end


  class MovingMarkerArray < MovingArray
    include TiogaMovingArray
  end

  class MovingLineStyleArray < MovingArray
    include TiogaMovingArray
  end

end
