#!/bin/sh
# This file contains some 'visual tests' for ctioga to make sure that when
# I add some features to ctioga, I don't break everything existing.
# As such, it also stands as a 'feature list' for ctioga.

. ./test_style.sh

# Then, we try various styles:
ctioga -N -t 'Transparency and fills' \
    --fill y-axis --fill-transparency 0.6 'sin(x)' 'cos(x)'
ctioga -N -t 'Markers' \
    --marker auto 'sin(x)**2' 'cos(x)**2'
ctioga -N -t 'Dot clouds' \
    --marker auto --marker-scale 0.2 --line-style no 'x**2' '1 - x**2'
# Style manipulations
ctioga -N -t 'Reset override' \
    --marker auto --marker-scale 0.2 --line-style no 'x**2' '1 - x**2' \
    --reset-override '10 - x**2'
# And override manipulations
ctioga -N -t 'Override manipulations' \
    --marker auto --marker-scale 0.2 --line-style no 'x**2' \
    --save-override cloud --reset-override \
    '1 - x**2' '10 - x**2' --use-override cloud 'x**2 - 10'

# Now testing background colors

ctioga -N -t 'Turquoise background' \
    --background PaleTurquoise 'sin(x)**2' 'cos(x)**2'

ctioga -N -t 'Backgrounds with --grid' \
    --grid column=2 \
    --background PaleTurquoise 'sin(x)**2' 'cos(x)**2' \
    --next 'tan(x)' --next --background Chiffon \
    'x**2' 'x**2 + 10'

