/***************************************************************************
                          record.h  -  description
                             -------------------
    begin                : Thu Jul 20 2000
    copyright            : (C) 2000 by Immi
    email                : cuyo@pcpool.mathematik.uni-freiburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#ifndef RECORD_H
#define RECORD_H

#include <qstring.h>
#include "inkompatibel.h"


/* "Spielerzahl", die angibt, dass gegen die KI gespielt wird. */
#define spz_ki 3



class Spielfeld;

/***** Diese Funktionen dienen dazu, Spiele aufzunehmen und abzuspielen.
       *****/

/** Irgend wann wird das vielleicht mal eine Klasse namens Aufnahme.
    Bis dahin mach ich's mit einem Namespace. */
namespace Aufnahme {


/** Am Anfang eines Levels aufrufen.
    Allerdings erst *nach* ladLevel(), weil der
    Levelname schon zur Verfgung stehen muss.
    spz gibt die Anzahl der Spieler an (bzw. = spz_ki falls gegen KI). */
void init(bool abspielen, int spz);


/** Liefert eine Zufallszahl... evtl. eine aufgenommene. (Im Moment bemerkt
    man die Tatsache, dass es sich um eine aufgenommene Zufallszahl handelt,
    gar nicht, weil das ber das randseed geht.) */
int rnd(int bis);

/** Nimmt ggf. den Tastendruck t von Spieler sp auf.
    Muss bei jedem Tastendruck aufgerufen werden. */
void recTaste(int sp, int t);

/** Muss einmal vor jedem Spielschritt aufgerufen werden. Spielt ggf.
    Tastendrcke ab.
    spf muss das Haupt-Spielfeld-Array sein, damit Tastendrcke
    ausgefhrt werden knnen. */
void recSchritt(Spielfeld ** spf);



void laden(__String pfad);

void speichern(__String pfad);


/** Liefert den Level-Namen zurck, fr den die aktuelle Aufnahme ist. */
__String getLevelName();

/** Liefert die Spielerzahl zurck, fr die die aktuelle Aufnahme ist. */
int getSpZ();


} // namespace Aufnahme


#endif
