(*
   Copyright 2008 by Mark Weyer
   modified 20.7.2009 by Bernhard R. Link <brlink@debian.org>
   to only generate one image at a time

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*)

open Farbe
open Graphik
open Vektorgraphik

open Male_mit_aa

let male breite hoehe bild =
  male bild (1.0/.32.0) (monochrom durchsichtig breite hoehe)

let raus gric todo name bild =
     if todo = name then
             gib_xpm_aus (rgb_grau 1.0) name (berechne gric bild)

let pi = 4.0*.(atan 1.0)

let bogen (x,y) winkel laenge kruemmung =
  let cw,sw = cos winkel, sin winkel  in
  let pos = kruemmung > 0.0  in
  let w' = if pos  then winkel-.pi/.2.0  else winkel+.pi/.2.0  in
  Bogen ((x-.kruemmung*.sw,y+.kruemmung*.cw),
    (if pos  then kruemmung  else -.kruemmung),
    pos, w', w'+.laenge/.kruemmung)


let arm_dicke1 = 1.0/.30.0
let arm_dicke2 = 1.0/.45.0

let octopus (a0,a1,a2,a3,a4,a5,a6,a7) farbe1 farbe2 =
  let arm nummer kruemmung =
    let winkel = (float_of_int (nummer+2))*.pi/.4.0  in
    [match kruemmung with
    | None -> Strecke ((0.5,0.5),(0.5+.cos winkel,0.5+.sin winkel))
    | Some r -> bogen (0.5,0.5) (winkel-.1.0/.7.0/.r) (3.0/.7.0) r
    ]  in
  let arme = konvertiere_polygon
    ((arm 0 a0) @ (arm 1 a1) @ (arm 2 a2) @ (arm 3 a3) @
    (arm 4 a4) @ (arm 5 a5) @ (arm 6 a6) @ (arm 7 a7))  in
  let kopfrad = 1.0/.4.0  in
  let kopfh = kopfrad*.3.0/.4.0  in
  let halsy = 0.5-.kopfrad*.(2.0-.sqrt(3.0))  in
  let kopfy = halsy+.kopfh  in
  let kopf = konvertiere_polygon [
    Bogen ((0.5,kopfy), kopfrad, true, 0.0, pi);
    Strecke ((0.5-.kopfrad, kopfy), (0.5-.kopfrad, halsy));
    Bogen ((0.5, halsy+.kopfrad*.sqrt(3.0)), 2.0*.kopfrad,
      true, pi*.4.0/.3.0, pi*.5.0/.3.0);
    Strecke ((0.5+.kopfrad, halsy), (0.5+.kopfrad, kopfy))
  ]  in
  let blesse = konvertiere_polygon
    [Bogen ((0.5,kopfy), kopfrad*.3.0/.4.0, true,
      pi*.2.0/.5.0, pi*.3.0/.4.0)]  in
  let augerad = kopfrad/.3.0  in
  let augey = kopfy  in
  let augend = augerad*.3.0  in
  let puprad = kopfrad/.5.0  in
  let pupy = augey-.puprad/.2.0  in
  let augepup t =
    let x = 0.5+.augend*.t/.2.0  in
      [Kreis ((x,augey),augerad)],
      [Kreis ((x,pupy),puprad)]  in
  let auge1,pup1 = augepup (-1.0)  in
  let auge2,pup2 = augepup (1.0)  in
  let auge = konvertiere_polygon (auge1@auge2)  in
  let pup = konvertiere_polygon (pup1@pup2)  in
  male 1 1 (erzeuge_vektorbild [
      Dicker_Strich (farbe1, 1.0/.30.0, [arme]);
      Dicker_Strich (farbe2, 1.0/.45.0, [arme]);
      Strich (farbe1, [kopf]);
      Flaechen ([| farbe1; weiss; schwarz |], [
        kopf, 0, None;
        auge, 1, Some 0;
        pup, 2, Some 1;
      ]);
      Dicker_Strich (farbe2, kopfrad/.7.0, [blesse]);
    ])

let octopus (k0,k1,k2,k3,k4,k5,k6,k7) ad a0 a2 a4 a6 =
  octopus (
    (if a0  then None  else Some k0),
    (if ad  then None  else Some k1),
    (if a2  then None  else Some k2),
    (if ad  then None  else Some k3),
    (if a4  then None  else Some k4),
    (if ad  then None  else Some k5),
    (if a6  then None  else Some k6),
    (if ad  then None  else Some k7))

let schema_mitte farbe1 farbe2 =
  let raute = konvertiere_polygon [
    Strecke ((-0.5,0.5),(0.5,-0.5));
    Strecke ((0.5,-0.5),(1.5,0.5));
    Strecke ((1.5,0.5),(0.5,1.5));
    Strecke ((0.5,1.5),(-0.5,0.5));
  ]  in
  male 1 1 (erzeuge_vektorbild [
    Dicker_Strich (farbe1, arm_dicke1, [raute]);
    Dicker_Strich (farbe2, arm_dicke2, [raute]);
  ])
  
let octopi farbe1 farbe2 kruemmungen =
  let octopus = octopus kruemmungen  in
  kombiniere_bildchen 3 3
    (List.map (fun (x,y,b) -> (x,y,b farbe1 farbe2)) [
      0,0,octopus false true  true  false false;
      1,0,octopus true  false false true  true;
      2,0,octopus false false true  true  false;
      0,1,octopus true  false true  true  false;
      1,1,schema_mitte;
      2,1,octopus true  true  false false true;
      0,2,octopus false true  false false true;
      1,2,octopus true  true  true  false false;
      2,2,octopus false false false true  true;
    ])

let octopi_daten = [|
    rgbrgb 0.79 0.06 0.79, rgbrgb 0.95 0.37 0.96,
      ( 3.0, -1.0,  0.5,  1.5, -0.3, -2.0,  0.4,  0.7);
    rgb_grau 0.2, rgb_grau 0.6,
      (-2.0, -1.5, -1.5,  0.8,  1.0, -1.0,  0.6, -1.0);
    rgbrgb 0.2 0.2 0.8, rgbrgb 0.5 0.5 1.0,
      (-2.5,  1.0,  0.7, -0.5, -0.5,  0.6, -1.0,  1.5);
    rgbrgb 0.6 0.61 0.1, rgbrgb 0.8 0.83 0.3,
      ( 3.0,  0.7,  1.0, -0.3,  0.8,  0.3, -2.0, -1.0);
    rgbrgb 0.8 0.5 0.1, rgbrgb 0.9 0.7 0.4,
      ( 2.0,  1.5, -0.3, -1.0, -2.0,  0.5,  1.0,  1.0);
  |]

let octopi gric todo = Array.iteri
  (fun i -> fun (farbe1,farbe2,kruemmungen) ->
    raus gric todo ("moOctopus"^string_of_int(i+1))
      (octopi (von_rgb farbe1) (von_rgb farbe2) kruemmungen))
  octopi_daten



let welle w d x y = cos ((x*.cos w +. y*.sin w)/.d)

let anemone w1 w2 =
  let num = 50  in
  let g = (sqrt 5.0 -. 1.0)*.pi  in
  let num_ = float_of_int num  in
  let farbe1 = von_rgb (rgbrgb 1.0 0.7 0.7)  in
  let farbe2 = von_rgb (rgbrgb 1.0 0.3 0.7)  in
  let farbe3 = von_rgb (rgbrgb 1.0 1.0 0.7)  in
  let farbe4 = von_rgb (rgbrgb 0.8 0.8 0.2)  in
  let faeden = Array.init num
    (fun i ->
      let i = float_of_int i  in
      let w = g *. i  in
      let r = sqrt (i/.num_)/.4.0  in
      (r*.cos w, r*.sin w))  in
  Array.sort
    (fun (x1,y1) -> fun (x2,y2) -> Pervasives.compare y2 y1)
    faeden;
  male 1 1 (erzeuge_vektorbild (List.concat (List.map
    (fun (x,y) ->
      let r2 = x*.x +. y*.y  in
      let mitte = 31.0*.r2 < 1.0  in
      let strich = konvertiere_polygon
        [bogen (0.5+.x, 0.25+.y/.2.0) (pi/.2.0 -. x)
          ((if mitte  then 0.3  else 0.4)
            -. 3.0*.r2 +. (welle w1 0.1 x y)/.29.0 +. y/.3.0)
          (0.4/.((welle w2 0.1 x y)/.2.0 -. 5.0*.x))]  in
      [Dicker_Strich ((if mitte  then farbe4  else farbe2),
          1.0/.29.0, [strich]);
        Strich ((if mitte  then farbe3  else farbe1), [strich]);
      ])
    (Array.to_list faeden))))

let anemonen gric todo =
  raus gric todo "moAnemone" (kombiniere_bildchen 4 1
    (List.map (fun (x,w1,w2) -> (x,0,anemone w1 w2)) [
      0, 4.0, 1.0;
      1, 8.0, 6.0;
      2, 7.0, 5.0;
      3, 2.0, 3.0;
    ]))


let riff r l o u ro ru lo lu loch =
  let p = [|
    0.25,0.125;  0.47,0.1;  0.85,0.15;  0.95,0.52;
    0.9,0.85;  0.5,0.9;  0.2,0.9;  0.05,0.5;
    0.55,0.25;  0.8,0.45;  0.45,0.75;  0.2,0.45;
    0.7,0.65;
    |]  in
  let rr (x,y) = (x+.1.0,y)  in
  let ll (x,y) = (x-.1.0,y)  in
  let oo (x,y) = (x,y+.1.0)  in
  let uu (x,y) = (x,y-.1.0)  in
  let punkte = [|
    p.(0);  p.(1);  p.(2);  p.(3);  p.(4);  p.(5);  p.(6);  p.(7);
    p.(8);  p.(9);  p.(10); p.(11);
    uu p.(6);  uu p.(5);  uu p.(4);
    rr p.(0);  rr p.(7);  rr p.(6);
    oo p.(2);  oo p.(1);  oo p.(0);
    ll p.(4);  ll p.(3);  ll p.(2);
    uu (rr p.(6));  oo (rr p.(0));  oo (ll p.(2));  uu (ll p.(4));
    p.(12);
    |]  in
  let basis_farben = Array.append (Array.map
    (fun (r,g,b) -> misch2 (grau 0.5) (von_rgb (rgbrgb r g b)) 0.7)
    [|
      0.7,0.7,0.5;  0.8,0.7,0.4;  0.7,0.6,0.5;  0.7,0.6,0.4;  0.8,0.6,0.5;
      0.8,0.7,0.5;  0.6,0.6,0.4;  0.7,0.7,0.6;  0.7,0.6,0.6;  0.7,0.7,0.4;
    |])
    [| durchsichtig |]  in
  if loch != None then basis_farben.(4) <- schwarz;
  let farben = Array.map (fun f -> basis_farben.(f)) [|
    0; 1; 2; 3; 4;
    if u then 5 else 10;  if u then 6 else 10;  if ru then 7  else 10;
    if r then 8 else 10;  if r then 9 else 10;  if ro then 7  else 10;
    if o then 6 else 10;  if o then 5 else 10;  if lo then 7  else 10;
    if l then 9 else 10;  if l then 8 else 10;  if lu then 7  else 10;
    |]  in
  let linien1 = List.map
    (fun (a,b,l,r) ->
      (konvertiere_polygon [Strecke (punkte.(a),punkte.(b))], l, Some r))
    [
      0,1,0,5;  1,2,1,6;  2,3,1,8;  3,4,2,9;
      4,5,2,11;  5,6,3,12;  6,7,3,14;  7,0,0,15;
      1,8,0,1;  3,9,1,2;  5,10,2,3;  7,11,3,0;
      8,9,4,1;  9,28,4,2;  28,10,4,2;  10,11,4,3;  11,8,4,0;
      0,12,5,16;  1,13,6,5;  2,14,7,6;  2,15,8,7;  3,16,9,8;  4,17,10,9;
      4,18,11,10;  5,19,12,11;  6,20,13,12;
      6,21,14,13;  7,22,15,14;  0,23,16,15;
    ]  in
  let linien2 = List.map
    (fun (a,b,l) ->
      (konvertiere_polygon [Strecke (punkte.(a),punkte.(b))], l, None))
    [
      12,13,5;  13,14,6;  14,24,7;  24,15,7;
      15,16,8;  16,17,9;  17,25,10;  25,18,10;
      18,19,11;  19,20,12;  20,26,13;  26,21,13;
      21,22,14;  22,23,15;  23,27,16;  27,12,16;
    ]  in
  let auge x y nr dr =
    let rad1 = 1.0/.9.0  in
    let rad2 = rad1/.5.0  in
    let dx = rad1/.4.0*.(if nr  then 1.0  else -1.0)  in
    let x = x +. rad1*.(if dr  then 1.0  else -1.0)  in
    let umriss = konvertiere_polygon
      [Bogen ((x,y-.rad1*.sqrt 0.75),rad1,true,pi/.3.0,pi*.2.0/.3.0);
        Bogen ((x,y+.rad1*.sqrt 0.75),rad1,true,pi*.4.0/.3.0,pi*.5.0/.3.0)]  in
    let pup = konvertiere_polygon [Kreis ((x+.dx,y),rad2)]  in
    [Strich (weiss,[umriss]);
      Flaechen ([|weiss|], [umriss,0,None]);
      Strich (schwarz,[pup]);
      Flaechen ([|schwarz|], [pup,0,None])]  in
  let augen x y r = (auge x y r true) @ (auge x y r false)  in
  let augen = match loch  with
  | Some (Some true) -> augen 0.52 0.58 true
  | Some (Some false) -> augen 0.45 0.45 false
  | _ -> []  in
  male 1 1 (erzeuge_vektorbild ([Flaechen (farben, linien1@linien2)] @ augen))

let riff gric todo = List.iter
  (fun (suf,loch) -> raus gric todo ("moRiff"^suf)
    (kombiniere_bildchen 5 1 (List.map
      (fun (x,r,l,o,u,ro,ru,lo,lu) -> (x,0,riff r l o u ro ru lo lu loch))
        [
          0, true,true,false,true, false,true,false,false;
          1, false,true,true,true, false,false,false,true;
          2, false,false,false,false, false,false,false,false;
          3, true,false,true,true, true,false,false,false;
          4, true,true,true,false, false,false,true,false;
        ])))
  ["1",None; "2",Some None; "3",Some (Some true); "4",Some (Some false);]


let fisch gric todo =
  let blau1 = von_rgb (rgbrgb 0.45 0.55 1.0)  in
  let blau2 = von_rgb (rgbrgb 0.5 0.7 1.0)  in
  let blau3 = von_rgb (rgbrgb 0.3 0.4 0.8)  in
  let koerper_p = (0.55,0.5)  in
  let koerper = konvertiere_polygon [Kreis (koerper_p,0.35)]  in
  let auge_p = (0.75,0.6)  in
  let dreieck p1 p2 p3 = konvertiere_polygon
    [Strecke (p1,p2); Strecke (p2,p3); Strecke (p3,p1)]  in
  let ruecken = dreieck (0.5,0.9) (0.6,0.8) (0.5,0.8)  in
  let schwanz = dreieck (0.2,0.5) (0.1,0.7) (0.1,0.3)  in
  let bein = dreieck (0.35,0.25) (0.35,0.15) (0.4,0.2)  in
  let arm = dreieck (0.7,0.25) (0.75,0.15) (0.75,0.3)  in
  let flosse umriss =
    [Strich (blau3,[umriss]); Flaechen ([| blau3 |],[umriss,0,None])]  in
  let fisch =
    (flosse ruecken) @ (flosse schwanz) @ (flosse bein) @
    [
    Strich (blau1,[koerper]);
    Flaechen ([| blau1; weiss; schwarz |], [
      koerper,0,None;
      konvertiere_polygon [Kreis (auge_p,0.09)], 1, Some 0;
      konvertiere_polygon [Kreis (auge_p,0.03)], 2, Some 1;
      ]);
    Dicker_Strich (blau2, 0.04, [konvertiere_polygon
      [Bogen (koerper_p,0.25,true,pi*.2.0/.5.0, pi*.6.0/.7.0)]])
    ] @
    (flosse arm)  in
  raus gric todo "moFisch" (male 1 1 (erzeuge_vektorbild fisch))


;;

let gric = int_of_string Sys.argv.(1)  in
let todo = Sys.argv.(2)  in

octopi gric todo;

anemonen gric todo;

fisch gric todo;

(* Obsolet: riff gric; *)

