#!/usr/bin/perl -w

use strict;



open IN, "<summary.in";
open SUM, ">summary.ld";

print SUM << "---";
# This file was automatically generated by genSummary.pl. Don't modify
# it directly. Modify summary.in instead.

---

my $srcdir = shift @ARGV;

for (@ARGV) {
	if( -e $_ ) {
		processFile($_);
	} else {
		processFile($srcdir . "/" . $_);
	}
}

while (<IN>) {
  removeComments() or next;
  if (m/^file +(.*)$/i) {
    processFile($1);
  } elsif (m/^verbatim$/i) {
    while (<IN>) {
      chomp;
      last if (m/^\s*end\s*(#.*)?$/i);
      print SUM $_, "\n";
    }
  } else {
    die "summary.in: Did not understand '$_'\n";
  }
}

close IN;
close SUM;



sub processFile {
  my $fileName = shift;
  open LD, "<$fileName";
  
  my $levelName;
  
  while (<LD>) {
    removeComments() or next;
    
    next if (m/^include /);  # provisorisch
    
    if (!defined($levelName)) {
      m/^(\w+)\s*=(\s*\{)?$/
        or die "$fileName: Expected '<levelName> =' at the beginning.\n";
      $levelName = $1;
      print SUM "$levelName = {\n";
      print SUM "  filename = \"$fileName\"\n";
      next;
    }
    
    m/^((\w+)(\[[^][]*\])?)\s*=\s*(".*")$/ or next;
    $2 eq "name" || $2 eq "author" or next;
    print SUM "  $1 = $4\n";
  }
  
  defined($levelName) or die "$fileName does not contain a level?\n";
  print SUM "}\n";
  
  close LD;
}




# Operates on $_;
# returns false if, after removing comments, nothing is left over
sub removeComments {
  chomp;
  # Remove comments, leading and trailing space
  s/#.*//;
  s/^\s*//;
  s/\s*$//;
  return $_ ne "";
}






