#!/usr/bin/ruby -w
# -*- ruby -*-

# Extended so that we can convert "Unix" (shell, actually) regular expressions
# ("*.java") to Ruby regular expressions ("/\.java$/").

class Regexp

  # shell expressions to Ruby regular expressions
  @@sh2re = Hash[
    '*'  => '.*', 
    '?'  => '.',
    '['  => '[',
    ']'  => ']',
    '.'  => '\.',
    '$'  => '\$',
    '/'  => '\/'
  ]

  # Returns a regular expression for the given Unix file system expression.
  
  def Regexp.unixre_to_string(pat)
    str = pat.gsub(/(\\.)|(.)/) do
      if $1
        $1
      else
        if @@sh2re.has_key?($2) then
          @@sh2re[$2] 
        else
          $2
        end
      end
    end
    str
  end

end
