/*	cvsnt agent
    Copyright (C) 2004-5 Tony Hoyle and March-Hare Software Ltd

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License version 2.1 as published by the Free Software Foundation.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
// cvsagent.cpp : Defines the entry point for the application.
//

#include "stdafx.h"
#include "cvsagent.h"
#include "aboutdialog.h"
#include "listenserver.h"
#include "PasswordDialog.h"

std::map<std::string,std::string> g_Passwords;
bool g_bTopmost = true;

class CAgentWnd : public CWnd
{
	void ShowContextMenu();

	afx_msg LRESULT OnTrayMessage(WPARAM wParam,LPARAM lParam);
	afx_msg LRESULT OnPasswordMessage(WPARAM wParam,LPARAM lParam);
	afx_msg LRESULT OnPasswordMessageDelete(WPARAM wParam,LPARAM lParam);
	afx_msg void OnAbout();
	afx_msg void OnQuit();
	afx_msg void OnClearPasswords();
	afx_msg void OnAlwaysOnTop();

	DECLARE_MESSAGE_MAP();
};

BEGIN_MESSAGE_MAP(CAgentWnd,CWnd)
ON_MESSAGE(TRAY_MESSAGE,OnTrayMessage)
ON_MESSAGE(PWD_MESSAGE,OnPasswordMessage)
ON_MESSAGE(PWD_MESSAGE_DELETE,OnPasswordMessageDelete)
ON_COMMAND(ID_ABOUT,OnAbout)
ON_COMMAND(ID_QUIT,OnQuit)
ON_COMMAND(ID_CLEARPASSWORDS,OnClearPasswords)
ON_COMMAND(ID_ALWAYSONTOP,OnAlwaysOnTop)
END_MESSAGE_MAP()

class CAgentApp : public CWinApp
{
	virtual BOOL InitInstance();
	virtual BOOL ExitInstance();

	static DWORD WINAPI _ThreadProc(LPVOID lpParam);
	DWORD ThreadProc();
};

CAgentApp app;

BOOL CAgentApp::InitInstance()
{
	m_pMainWnd = new CAgentWnd;
	m_pMainWnd->CreateEx(0,_T("static"),NULL,WS_OVERLAPPED,CRect(1,1,1,1),NULL,0);

	NOTIFYICONDATA nid = { sizeof(NOTIFYICONDATA) };
	nid.uFlags=NIF_ICON|NIF_MESSAGE|NIF_TIP;
	nid.uCallbackMessage=TRAY_MESSAGE;
	nid.hIcon=LoadIcon(IDI_CVSAGENT);
	nid.uID=IDI_CVSAGENT;
	_tcscpy(nid.szTip,_T("CVSNT password agent"));
	nid.hWnd=m_pMainWnd->GetSafeHwnd();
	Shell_NotifyIcon(NIM_ADD,&nid);

	CloseHandle(::CreateThread(0,0,_ThreadProc,this,0,NULL));
	return TRUE;
}

DWORD WINAPI CAgentApp::_ThreadProc(LPVOID lpParam)
{
	return ((CAgentApp*)lpParam)->ThreadProc();
}

DWORD CAgentApp::ThreadProc()
{
	CListenServer l;
	l.Listen("32401");
	return 0;
}

BOOL CAgentApp::ExitInstance()
{
	NOTIFYICONDATA nid = { sizeof(NOTIFYICONDATA) };
	nid.hWnd=m_pMainWnd->GetSafeHwnd();
	nid.uID=IDI_CVSAGENT;
	Shell_NotifyIcon(NIM_DELETE,&nid);
	return TRUE;
}

LRESULT CAgentWnd::OnTrayMessage(WPARAM wParam, LPARAM lParam)
{
	switch(lParam)
	{
	case WM_LBUTTONDBLCLK:
		break;
	case WM_RBUTTONDOWN:
	case WM_CONTEXTMENU:
		ShowContextMenu();
		break;
	}
	
	return 0;
}

void CAgentWnd::ShowContextMenu()
{
	CMenu menu;
	CPoint pt;
	menu.LoadMenu(IDR_MENU1);
	SetForegroundWindow();
	GetCursorPos(&pt);
	CMenu *sub = menu.GetSubMenu(0);
	sub->CheckMenuItem(ID_ALWAYSONTOP,g_bTopmost?MF_CHECKED:MF_UNCHECKED);
	sub->TrackPopupMenu(TPM_BOTTOMALIGN|TPM_CENTERALIGN|TPM_LEFTBUTTON,pt.x,pt.y,this);
}

void CAgentWnd::OnAbout()
{
	CAboutDialog dlg;
	dlg.DoModal();
}

void CAgentWnd::OnQuit()
{
	PostQuitMessage(0);
}

void CAgentWnd::OnClearPasswords()
{
	g_Passwords.clear();
}

void CAgentWnd::OnAlwaysOnTop()
{
	g_bTopmost=!g_bTopmost;
}

LRESULT CAgentWnd::OnPasswordMessage(WPARAM wParam,LPARAM lParam)
{
	char *buffer = (char*)wParam;
	int *len = (int*)lParam;
	CScramble scramble;

	CPasswordDialog dlg;
	dlg.m_szCvsRoot=buffer;
	if(dlg.DoModal()!=IDOK)
		return 0;
	strcpy(buffer,scramble.Scramble(dlg.m_szPassword.c_str()));
	*len=(int)strlen(buffer);

	g_Passwords[dlg.m_szCvsRoot]=buffer;
	return 1;
}

LRESULT CAgentWnd::OnPasswordMessageDelete(WPARAM wParam,LPARAM lParam)
{
	char *buffer = (char*)wParam;

	if(g_Passwords.find(buffer)!=g_Passwords.end())
		g_Passwords.erase(g_Passwords.find(buffer));
	return 0;
}
