/*
	CVSNT Helper application API
    Copyright (C) 2004-5 Tony Hoyle and March-Hare Software Ltd

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License version 2.1 as published by the Free Software Foundation.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
/* Unix specific */
#include <cvsapi.h>
#include <errno.h>
#include "export.h"
#include "../GlobalSettings.h"
#include "../TriggerLibrary.h"

CTriggerLibrary::trigger_list_t CTriggerLibrary::trigger_list;

const trigger_interface *CTriggerLibrary::LoadTrigger(const char *library, const char *command, const char *date, const char *hostname, const char *username, const char *virtual_repository, const char *physical_repository, const char *sessionid, const char *editor, int count_uservar, const char **uservar, const char **userval, const char *client_version, const char *character_set)
{
	trigger_interface *cb = NULL;

	cb = trigger_list[library];
	if(cb)
		return cb;

	CLibraryAccess lib;

	if(!lib.Load(library,CGlobalSettings::GetLibraryDirectory()))
	{
		CServerIo::trace(3,"Unable to load %s: %s",strerror(errno));
		return NULL;
	}

	CVSINFOPROC pCvsInfo = (CVSINFOPROC)lib.GetProc("GetCvsInfo");
	if(!pCvsInfo)
		return NULL;
	cb = pCvsInfo(TRIGGER_INTERFACE_VERSION);
	if(cb)
	{
		CTriggerLibrary::trigger_info_t *inf = new CTriggerLibrary::trigger_info_t;
		inf->pLib = lib.Detach();
		cb->_reserved = inf;
	}

	if(cb)
	{
		if(cb->init)
		{
			if(cb->init(cb, command, date, hostname, username, virtual_repository, physical_repository, sessionid, editor, count_uservar, uservar, userval, client_version, character_set))
			{
				CTriggerLibrary::trigger_info_t *inf = (CTriggerLibrary::trigger_info_t*)cb->_reserved;	
				CLibraryAccess lib(inf->pLib);
				lib.Unload();
				for(size_t n=0; n<inf->to_free.size(); n++)
					free(inf->to_free[n]);
				if(inf->delete_cb)
					delete cb;
				delete inf;
				cb = NULL;
			}

		}
		if(cb)
			trigger_list[library]=cb;
	}
	return cb;
}

bool CTriggerLibrary::CloseTrigger(trigger_interface *cb)
{
	return true;
};

bool CTriggerLibrary::CloseAllTriggers()
{
	std::map<std::string, trigger_interface *>::const_iterator i;
	for(i=trigger_list.begin();i!=trigger_list.end();i++)
	{
		if(i->second)
		{
			CTriggerLibrary::trigger_info_t *inf = (CTriggerLibrary::trigger_info_t*)i->second->_reserved;

			CServerIo::trace(3,"Unloading %s",i->first.c_str());
			if(i->second->close)
				i->second->close(i->second);

			if(inf->pLib)
			{
				CLibraryAccess lib(inf->pLib);
				lib.Unload();
			}
			for(size_t n=0; n<inf->to_free.size(); n++)
				free(inf->to_free[n]);
			if(inf->delete_cb)
				delete i->second;
			delete inf;
		}
	}
	trigger_list.clear();
	return true;
}

const trigger_interface *CTriggerLibrary::EnumLoadedTriggers(bool& first, const char *& name)
{
	if(first)
		m_it = trigger_list.begin();

	first = false;

	trigger_interface *tri;
	do
	{
		if(m_it==trigger_list.end())
			return NULL;

		tri = m_it->second;
		name = m_it->first.c_str();
		++m_it;
	} while(!tri);
	return tri;
}


