-- MS SQL specific configuration script

Create Table SessionLog (Id Integer Identity Primary Key Not Null,
	Command nvarchar(32),
	Date datetime,
	Hostname nvarchar(256),
	Username nvarchar(256),
	SessionId nvarchar(32),
	VirtRepos nvarchar(256),
	PhysRepos nvarchar(256),
	Client nvarchar(64));

Create Table CommitLog (Id Integer Identity Primary Key Not Null,
	SessionId Integer,
	Directory nvarchar(256),
	Message text,
	Type char(1),
	Filename nvarchar(256),
	Tag nvarchar(64),
	BugId nvarchar(64),
	OldRev nvarchar(64),
	NewRev nvarchar(64),
	Added Integer,
	Removed Integer,
	Diff text);

Create Index Commit_SessionId On CommitLog(SessionId);

Create Table HistoryLog (Id Integer Identity Primary Key Not Null,
	SessionId Integer,
	Type char(1),
	WorkDir nvarchar(256),
	Revs nvarchar(64),
	Name nvarchar(256),
	BugId nvarchar(64),
	Message text);

Create Index History_SessionId on HistoryLog(SessionId);

Create Table TagLog (Id Integer Identity Primary Key Not Null,
	SessionId Integer,
	Directory nvarchar(256),
	Filename nvarchar(256),
	Tag nvarchar(64),
	Revision nvarchar(64),
	Message text,
	Action nvarchar(32),
	Type char(1));
	
Create Index Tag_SessionId on TagLog(SessionId);
