-- MySql specific configuration script

Create Table SessionLog (Id Integer Auto_Increment Primary Key Not Null,
	Command varchar(32),
	Date datetime,
	Hostname varchar(255),
	Username varchar(255),
	SessionId varchar(32),
	VirtRepos varchar(255),
	PhysRepos varchar(255),
	Client varchar(64));

Create Table CommitLog (Id Integer Auto_Increment Primary Key Not Null,
	SessionId Integer,
	Directory varchar(255),
	Message text,
	Type char(1),
	Filename varchar(255),
	Tag varchar(64),
	BugId varchar(64),
	OldRev varchar(64),
	NewRev varchar(64),
	Added Integer,
	Removed Integer,
	Diff text);

Create Index Commit_SessionId On CommitLog(SessionId);

Create Table HistoryLog (Id Integer Auto_Increment Primary Key Not Null,
	SessionId Integer,
	Type char(1),
	WorkDir varchar(255),
	Revs varchar(64),
	Name varchar(255),
	BugId varchar(64),
	Message text);

Create Index History_SessionId on HistoryLog(SessionId);

Create Table TagLog (Id Integer Auto_Increment Primary Key Not Null,
	SessionId Integer,
	Directory varchar(255),
	Filename varchar(255),
	Tag varchar(64),
	Revision varchar(64),
	Message text,
	Action varchar(32),
	Type char(1));
	
Create Index Tag_SessionId on TagLog(SessionId);
