#ifndef CVSFLT_PUB__H
#define CVSFLT_PUB__H

#ifndef CTL_CODE
#include <WinIoctl.h>
#endif

struct _CVSFLT_GETVERSION_OUT
{
	ULONG Version;
};

struct _CVSFLT_ADDPOSIXDIRECTORY_IN
{
	USHORT Temporary;
	WCHAR Directory[1];
};

struct _CVSFLT_REMOVEPOSIXDIRECTORY_IN
{
	USHORT Temporary;
	WCHAR Directory[1];
};

struct _CVSFLT_GETPOSIXDIRECTORY_IN
{
	USHORT Index;
};

struct _CVSFLT_GETPOSIXDIRECTORY_OUT
{
	ULONG Length; /* Length in bytes */
	WCHAR Directory[1];
};

struct _CVSFLT_GETKERNELNAME_IN
{
	WCHAR Directory[1];
};

struct _CVSFLT_GETKERNELNAME_OUT
{
	ULONG Length; /* Length in bytes */
	WCHAR Directory[1];
};

#define CVSFLT_GetVersion			(ULONG)CTL_CODE( FILE_DEVICE_DISK_FILE_SYSTEM, 0x00, METHOD_BUFFERED, FILE_READ_ACCESS )
#define CVSFLT_AddPosixDirectory	(ULONG)CTL_CODE( FILE_DEVICE_DISK_FILE_SYSTEM, 0x01, METHOD_BUFFERED, FILE_WRITE_ACCESS )
#define CVSFLT_RemovePosixDirectory	(ULONG)CTL_CODE( FILE_DEVICE_DISK_FILE_SYSTEM, 0x02, METHOD_BUFFERED, FILE_WRITE_ACCESS )
#define CVSFLT_GetPosixDirectory	(ULONG)CTL_CODE( FILE_DEVICE_DISK_FILE_SYSTEM, 0x03, METHOD_BUFFERED, FILE_READ_ACCESS )
#define CVSFLT_GetKernelName		(ULONG)CTL_CODE( FILE_DEVICE_DISK_FILE_SYSTEM, 0x04, METHOD_BUFFERED, FILE_READ_ACCESS )

#define CVSFLT_WIN32_DEVICE_NAME L"\\\\.\\CvsFlt"

#define CVSFLT_VERSION 0x0100

#endif
